import Vue from 'vue'
import Router from 'vue-router'
//import Login from '.././views/login.vue'
//import NotFound from '.././views/404.vue'
//import Home from '.././views/index.vue'
Vue.use(Router)

const router = new Router({
  mode: 'history',//去掉#号
  routes: [
    {
      path: '/',
      name: 'login',
      component: () => import('../pages/login')
    },
    {
      path: '/index',
      name: 'index',
      redirect: '/bigdata',
      component: () => import('../pages/index'),
      children: [
        {
          path: '/bigdata',
          name: 'bigdata',
          component: () => import('../pages/bigdata')
        },
        {
          path: '/event',
          name: 'event',
          component: () => import('../pages/eventTable')
        }
      ]
    }
  ]
})

router.beforeEach(async(to, from, next) => {
  let account = JSON.parse(localStorage.getItem('accountInfo'))
  const workerId = account ? account : null
  // 已登陆
  // console.log(workerId)
  if (workerId) {
    if (to.path != '/') { // 已登录状态直接去首页
      next()
    } else {
      next('/index')
    }
  } else {
    if (to.path == '/') {
      next()
    } else {
      next({ path: '/' })
    } // 未登录的状态跳转登录页
  }
})

export default router