import Vue from "vue";
import App from "./App.vue";
import router from "./router/router";
import VueRouter from "vue-router";
import "@/styles/common.css";
// 引入videojs
import Video from "video.js";
import "video.js/dist/video-js.css";
Vue.prototype.$Video = Video;
import hls from "videojs-contrib-hls";
Vue.use(hls); // 要播放hls流

import md5 from "js-md5";
Vue.prototype.$md5 = md5;
import {
  Select,
  Option,
  Radio,
  RadioGroup,
  Image,
  Dialog,
  Input,
  Button,
  Tabs,
  Form,
  FormItem,
  DatePicker,
  Table,
  Loading,
  TableColumn,
  Pagination,
  Dropdown,
  DropdownItem,
  DropdownMenu,
  Message,
  CheckboxGroup,
  Checkbox,
  Tree,
  Cascader,
  MessageBox,
  Upload,
} from "element-ui";

import "element-ui/lib/theme-chalk/index.css";
import "@/styles/element.css";
import "@/styles/common.css";

import "./utils/directive";

Vue.config.productionTip = false;
Vue.use(Select)
  .use(Option)
  .use(Radio)
  .use(RadioGroup)
  .use(Image)
  .use(Dialog)
  .use(Input)
  .use(Button)
  .use(Tabs)
  .use(Form)
  .use(FormItem)
  .use(DatePicker)
  .use(Table)
  .use(TableColumn)
  .use(Pagination)
  .use(Dropdown)
  .use(DropdownItem)
  .use(DropdownMenu)
  .use(CheckboxGroup)
  .use(Checkbox)
  .use(Loading)
  .use(Tree)
  .use(Upload)
  .use(Cascader);

Vue.prototype.$message = Message;
Vue.prototype.$confirm = MessageBox.confirm;
Vue.use(VueRouter);

new Vue({
  router,
  render: (h) => h(App),
}).$mount("#app");
