import { api, formatParams, config } from '@/utils/request';

// 获取7、30天数据
export function getGroupData(params) {
	return api(Object.assign(formatParams('GET', params), {
		url: `${config.proxy}/receive/data/api/report/thirty`
	}))
}

// 获取当日告警数据
export function getTodayData(params) {
	return api(Object.assign(formatParams('GET', params), {
		url: `${config.proxy}/receive/data/api/report/today`
	}))
}

// 获取最新10条数据
export function getLatestData(params) {
	return api(Object.assign(formatParams('GET', params), {
		url: `${config.proxy}/receive/data/api/lastest`
	}))
}

// 获取事件列表
export function getEventsData(params) {
  return api(Object.assign(formatParams('POST', params), {
    url: `${config.proxy}/receive/data/api/query/page`
  }))
}

// 获取事件列表
export function getCameraList(params) {
  return api(Object.assign(formatParams('POST', params), {
    url: `${config.proxy}/camera/fullMsg/list`
  }))
}

// 获取摄像头视频
export function getCameraVideo(params) {
  return api(Object.assign(formatParams('POST', params), {
    url: `${config.proxy}/camera/view/${params.cameraId}`
  }))
}

// 获取成效统计
export function getResultRate(params) {
  return api(Object.assign(formatParams('GET', params), {
    url: `${config.proxy}/receive/data/api/effect/statistics`
  }))
}

// 获取事件详情
export function eventDetail (params) {
  return api(Object.assign(formatParams('POST', params), {
    url: `${config.proxy}/net/worker/api/detail/${params.id}`
  }))
}

// 登陆
export function login (params) {
  return api(Object.assign(formatParams('POST', params), {
    url: `${config.proxy}/net/worker/api/data/login`
  }))
}


/**
 * 获取token
 */
// export function getNewToken (params) {
//   return api(Object.assign(formatParams('GET'), {
//     url: `${config.proxy}/login/api/token/update/${params.id}`
//   }))
// }

/**
 * 获取token
 */
export function getNewToken (params) {
  return api(Object.assign(formatParams('GET'), {
    url: `${config.proxy}/net/worker/api/token/update/data/${params.id}`
  }))
}

/**
 * 7天成效统计(时间与网格)
 */
export function queryCustom (params) {
  return api(Object.assign(formatParams('POST', params), {
    url: `${config.proxy}/receive/data/api/query/custom`
  }))
}

/**
 * 获取网格列表
 */
export function queryNetArea (params) {
  return api(Object.assign(formatParams('POST', params), {
    url: `${config.proxy}/receive/data/api/query/netArea`
  }))
}
