/*
 * @Descripttion:
 * @version:
 * @Author: zhouyh
 * @Date: 2021-09-30 17:17:21
 * @LastEditors: zhouyh
 * @LastEditTime: 2021-09-30 17:49:08
 */
import { api, formatParams, config } from "@/utils/request";

// 获取7、30天数据
export function getGroupData(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/receive/data/api/report/thirty`,
    })
  );
}

// 获取当日告警数据
export function getTodayData(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/receive/data/api/report/today`,
    })
  );
}

// 获取最新10条数据 // flag
// export function getLatestData(params) {
//   return api(
//     Object.assign(formatParams("GET", params), {
//       url: `${config.proxy}/receive/data/api/lastest`,
//     })
//   );
// }

// 获取事件分页列表
export function getEventsData(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/api/page?currentNo=${params.currentNo}&pageSize=${params.pageSize}&typeId=${params.typeId}`,
    })
  );
}

// 获取摄像头列表
export function getCameraList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/api/fullMsg/list?&typeId=${params.typeId}`,
    })
  );
}

// 获取摄像头分类一级列表
export function CameraShowOne(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/api/show/one?typeName=${params.typeName}`,
    })
  );
}

// 获取摄像头分类下级列表
export function CameraShowNext(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/api/show/next?id=${params.id}&typeId=${params.typeId}`,
    })
  );
}

// 获取摄像头视频
export function getCameraVideo(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/manage/deviceInfo/view`,
    })
  );
}

// 一键播报告警
export function personPlayOnByList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/urgentRadioManager/personPlayOnByList`,
    })
  );
}
// 地图开启播报告警
export function personPlay(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/urgentRadioManager/personPlay`,
    })
  );
}

// 列表开启播报告警
export function personPlayOnList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/urgentRadioManager/personPlayOnList`,
    })
  );
}

// 关闭播报告警
export function stopPersonPlay(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/urgentRadioManager/stopPersonPlay`,
    })
  );
}

// 获取成效统计
export function getResultRate(params) {
  return api(
    Object.assign(formatParams("GET", params), {
      url: `${config.proxy}/receive/data/api/effect/statistics`,
    })
  );
}

// 获取事件详情
export function eventDetail(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/api/${params.id}`,
    })
  );
}

// 登陆
export function login(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/manage/login`,
    })
  );
}

/**
 * 获取token
 */
// export function getNewToken (params) {
//   return api(Object.assign(formatParams('GET'), {
//     url: `${config.proxy}/login/api/token/update/${params.id}`
//   }))
// }

/**
 * 获取token
 */
export function getNewToken(params) {
  return api(
    Object.assign(formatParams("GET"), {
      url: `${config.proxy}/login/api/token/update/${params.id}`,
    })
  );
}

/**
 * 7天成效统计(时间与网格)  flag
 */
export function queryCustom(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/api/query/custom`,
    })
  );
}

/**
 * 获取网格列表
 */
export function queryNetArea(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/api/query/netArea`,
    })
  );
}

/**
 * 获取token,免登陆
 */
export function getUserInfo(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/login/api/getUserInfo/${params.userId}`,
    })
  );
}

// 获取监控设备分类列表
export function treeList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/manage/deviceClassify/tree/dataList`,
    })
  );
}

// 根据分类获取监控设备
export function cameraByType(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/manage/deviceInfo/page?current=1&size=999`,
    })
  );
}

// 监控设备: 云台操作
export function cloud(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/camera/manager/cloud?cameraId=${params.cameraId}&action=${params.action}&command=${params.command}`,
    })
  );
}

// 上报事件
export function uploadEvent(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/accept/upload/event`,
    })
  );
}

// 获取类型
// export function eventTypeList(params) {
//   return api(
//     Object.assign(formatParams("POST", params), {
//       url: `/urgentRadioManager/eventTypeList`,
//     })
//   );
// }

// 获取摄像头回放视频
export function playbackURLs(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/api/playbackURLs`,
    })
  );
}

// 获取事件类型列表
export function eventTypeList(params) {
  return api(
    Object.assign(formatParams("POST", params), {
      url: `${config.proxy}/receive/data/web/api/eventTypeList`,
    })
  );
}