/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50712
Source Host           : localhost:3306
Source Database       : ejweb

Target Server Type    : MYSQL
Target Server Version : 50712
File Encoding         : 65001

Date: 2017-11-06 13:01:24
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for cms_article
-- ----------------------------
DROP TABLE IF EXISTS `cms_article`;
CREATE TABLE `cms_article` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `category_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '栏目编号',
  `title` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '标题',
  `link` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '文章链接',
  `color` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '标题颜色',
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '文章图片',
  `keywords` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关键字',
  `description` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '描述、摘要',
  `weight` int(11) DEFAULT '0' COMMENT '权重，越大越靠前',
  `weight_date` datetime DEFAULT NULL COMMENT '权重期限',
  `hits` int(11) DEFAULT '0' COMMENT '点击数',
  `posid` varchar(10) COLLATE utf8_bin DEFAULT NULL COMMENT '推荐位，多选',
  `custom_content_view` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '自定义内容视图',
  `view_config` text COLLATE utf8_bin COMMENT '视图配置',
  `create_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '更新者',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `cms_article_create_by` (`create_by`),
  KEY `cms_article_title` (`title`),
  KEY `cms_article_keywords` (`keywords`),
  KEY `cms_article_del_flag` (`del_flag`),
  KEY `cms_article_weight` (`weight`),
  KEY `cms_article_update_date` (`update_date`),
  KEY `cms_article_category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='文章表';

-- ----------------------------
-- Records of cms_article
-- ----------------------------
INSERT INTO `cms_article` VALUES ('1', '3', '文章标题标题标题标题', null, 'green', null, '关键字1,关键字2', null, '0', null, '9', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('10', '4', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '3', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('11', '5', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('12', '5', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('13', '5', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('14', '7', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '1', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('15', '7', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('16', '7', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('17', '7', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('18', '8', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('19', '8', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('2', '3', '文章标题标题标题标题', null, 'red', null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('20', '8', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('21', '8', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('22', '9', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('23', '9', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('24', '9', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('25', '9', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('26', '9', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('27', '11', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '1', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('28', '11', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('29', '11', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('3', '3', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('30', '11', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('31', '11', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('32', '12', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('33', '12', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('34', '12', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('35', '12', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('36', '12', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('37', '13', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('38', '13', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('39', '13', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('4', '3', '文章标题标题标题标题', null, 'green', null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('40', '13', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('41', '14', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('42', '14', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('43', '14', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('44', '14', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('45', '14', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('46', '15', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('47', '15', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('48', '15', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('49', '16', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('5', '3', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '1', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('50', '17', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '3', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('51', '17', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('52', '26', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('53', '26', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('6', '3', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('7', '4', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('8', '4', '文章标题标题标题标题', null, 'blue', null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_article` VALUES ('9', '4', '文章标题标题标题标题', null, null, null, '关键字1,关键字2', null, '0', null, '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');

-- ----------------------------
-- Table structure for cms_article_data
-- ----------------------------
DROP TABLE IF EXISTS `cms_article_data`;
CREATE TABLE `cms_article_data` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `content` text COLLATE utf8_bin COMMENT '文章内容',
  `copyfrom` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '文章来源',
  `relation` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '相关文章',
  `allow_comment` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '是否允许评论',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='文章详表';

-- ----------------------------
-- Records of cms_article_data
-- ----------------------------
INSERT INTO `cms_article_data` VALUES ('1', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('10', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('11', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('12', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('13', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('14', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('15', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('16', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('17', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('18', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('19', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('2', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('20', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('21', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('22', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('23', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('24', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('25', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('26', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('27', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('28', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('29', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('3', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('30', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('31', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('32', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('33', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('34', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('35', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('36', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('37', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('38', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('39', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('4', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('40', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('41', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('42', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('43', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('44', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('45', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('46', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('47', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('48', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('49', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('5', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('50', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('51', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('52', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('53', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('6', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('7', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('8', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');
INSERT INTO `cms_article_data` VALUES ('9', 0xE69687E7ABA0E58685E5AEB9E58685E5AEB9E58685E5AEB9E58685E5AEB9, '来源', '1,2,3', '1');

-- ----------------------------
-- Table structure for cms_category
-- ----------------------------
DROP TABLE IF EXISTS `cms_category`;
CREATE TABLE `cms_category` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `project_id` varchar(64) CHARACTER SET utf8 DEFAULT '' COMMENT '项目ID',
  `parent_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '父级编号',
  `parent_ids` varchar(2000) COLLATE utf8_bin NOT NULL COMMENT '所有父级编号',
  `site_id` varchar(64) COLLATE utf8_bin DEFAULT '1' COMMENT '站点编号',
  `office_id` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '归属机构',
  `module` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT '栏目模块',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '栏目名称',
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '栏目图片',
  `href` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '链接',
  `target` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT '目标',
  `description` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '描述',
  `keywords` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关键字',
  `sort` int(11) DEFAULT '30' COMMENT '排序（升序）',
  `in_menu` char(1) COLLATE utf8_bin DEFAULT '1' COMMENT '是否在导航中显示',
  `in_list` char(1) COLLATE utf8_bin DEFAULT '1' COMMENT '是否在分类页中显示列表',
  `show_modes` char(1) COLLATE utf8_bin DEFAULT '0' COMMENT '展现方式',
  `allow_comment` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '是否允许评论',
  `is_audit` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '是否需要审核',
  `custom_list_view` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '自定义列表视图',
  `custom_content_view` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '自定义内容视图',
  `view_config` text COLLATE utf8_bin COMMENT '视图配置',
  `create_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '更新者',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `cms_category_parent_id` (`parent_id`),
  KEY `cms_category_module` (`module`),
  KEY `cms_category_name` (`name`),
  KEY `cms_category_sort` (`sort`),
  KEY `cms_category_del_flag` (`del_flag`),
  KEY `cms_category_office_id` (`office_id`),
  KEY `cms_category_site_id` (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='栏目表';

-- ----------------------------
-- Records of cms_category
-- ----------------------------
INSERT INTO `cms_category` VALUES ('1', '', '0', '0,', '0', '1', null, '顶级栏目', null, null, null, null, null, '0', '1', '1', '0', '0', '1', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('10', '', '1', '0,1,', '1', '4', 'article', '软件介绍', null, null, null, null, null, '20', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('11', '', '10', '0,1,10,', '1', '4', 'article', '网络工具', null, null, null, null, null, '30', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('12', '', '10', '0,1,10,', '1', '4', 'article', '浏览工具', null, null, null, null, null, '40', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('13', '', '10', '0,1,10,', '1', '4', 'article', '浏览辅助', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('14', '', '10', '0,1,10,', '1', '4', 'article', '网络优化', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('15', '', '10', '0,1,10,', '1', '4', 'article', '邮件处理', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('16', '', '10', '0,1,10,', '1', '4', 'article', '下载工具', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('17', '', '10', '0,1,10,', '1', '4', 'article', '搜索工具', null, null, null, null, null, '50', '1', '1', '2', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('18', '', '1', '0,1,', '1', '5', 'link', '友情链接', null, null, null, null, null, '90', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('19', '', '18', '0,1,18,', '1', '5', 'link', '常用网站', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('2', '', '1', '0,1,', '1', '3', 'article', '组织机构', null, null, null, null, null, '10', '1', '1', '0', '0', '1', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('20', '', '18', '0,1,18,', '1', '5', 'link', '门户网站', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('21', '', '18', '0,1,18,', '1', '5', 'link', '购物网站', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('22', '', '18', '0,1,18,', '1', '5', 'link', '交友社区', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('23', '', '18', '0,1,18,', '1', '5', 'link', '音乐视频', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('24', '', '1', '0,1,', '1', '6', null, '百度一下', null, 'http://www.baidu.com', '_blank', null, null, '90', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('25', '', '1', '0,1,', '1', '6', null, '全文检索', null, '/search', null, null, null, '90', '0', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('26', '', '1', '0,1,', '2', '6', 'article', '测试栏目', null, null, null, null, null, '90', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('27', '', '1', '0,1,', '1', '6', null, '公共留言', null, '/guestbook', null, null, null, '90', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('3', '', '2', '0,1,2,', '1', '3', 'article', '网站简介', null, null, null, null, null, '30', '1', '1', '0', '0', '1', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('4', '', '2', '0,1,2,', '1', '3', 'article', '内部机构', null, null, null, null, null, '40', '1', '1', '0', '0', '1', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('5', '', '2', '0,1,2,', '1', '3', 'article', '地方机构', null, null, null, null, null, '50', '1', '1', '0', '0', '1', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('6', '', '1', '0,1,', '1', '3', 'article', '质量检验', null, null, null, null, null, '20', '1', '1', '1', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('7', '', '6', '0,1,6,', '1', '3', 'article', '产品质量', null, null, null, null, null, '30', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('8', '', '6', '0,1,6,', '1', '3', 'article', '技术质量', null, null, null, null, null, '40', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_category` VALUES ('9', '', '6', '0,1,6,', '1', '3', 'article', '工程质量', null, null, null, null, null, '50', '1', '1', '0', '1', '0', null, null, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');

-- ----------------------------
-- Table structure for cms_comment
-- ----------------------------
DROP TABLE IF EXISTS `cms_comment`;
CREATE TABLE `cms_comment` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `category_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '栏目编号',
  `content_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '栏目内容的编号',
  `title` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '栏目内容的标题',
  `content` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '评论内容',
  `name` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '评论姓名',
  `ip` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '评论IP',
  `create_date` datetime NOT NULL COMMENT '评论时间',
  `audit_user_id` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '审核人',
  `audit_date` datetime DEFAULT NULL COMMENT '审核时间',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `cms_comment_category_id` (`category_id`),
  KEY `cms_comment_content_id` (`content_id`),
  KEY `cms_comment_status` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='评论表';

-- ----------------------------
-- Records of cms_comment
-- ----------------------------

-- ----------------------------
-- Table structure for cms_guestbook
-- ----------------------------
DROP TABLE IF EXISTS `cms_guestbook`;
CREATE TABLE `cms_guestbook` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `type` char(1) COLLATE utf8_bin NOT NULL COMMENT '留言分类',
  `content` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '留言内容',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '姓名',
  `email` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '邮箱',
  `phone` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '电话',
  `workunit` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '单位',
  `ip` varchar(100) COLLATE utf8_bin NOT NULL COMMENT 'IP',
  `create_date` datetime NOT NULL COMMENT '留言时间',
  `re_user_id` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '回复人',
  `re_date` datetime DEFAULT NULL COMMENT '回复时间',
  `re_content` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '回复内容',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `cms_guestbook_del_flag` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='留言板';

-- ----------------------------
-- Records of cms_guestbook
-- ----------------------------

-- ----------------------------
-- Table structure for cms_link
-- ----------------------------
DROP TABLE IF EXISTS `cms_link`;
CREATE TABLE `cms_link` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `category_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '栏目编号',
  `title` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '链接名称',
  `color` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '标题颜色',
  `image` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '链接图片',
  `href` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '链接地址',
  `weight` int(11) DEFAULT '0' COMMENT '权重，越大越靠前',
  `weight_date` datetime DEFAULT NULL COMMENT '权重期限',
  `create_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '更新者',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `cms_link_category_id` (`category_id`),
  KEY `cms_link_title` (`title`),
  KEY `cms_link_del_flag` (`del_flag`),
  KEY `cms_link_weight` (`weight`),
  KEY `cms_link_create_by` (`create_by`),
  KEY `cms_link_update_date` (`update_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='友情链接';

-- ----------------------------
-- Records of cms_link
-- ----------------------------
INSERT INTO `cms_link` VALUES ('1', '19', 'JeeSite', null, null, 'http://thinkgem.github.com/jeesite', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('10', '22', '58同城', null, null, 'http://www.58.com/', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('11', '23', '视频大全', null, null, 'http://v.360.cn/', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('12', '23', '凤凰网', null, null, 'http://www.ifeng.com/', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('2', '19', 'ThinkGem', null, null, 'http://thinkgem.iteye.com/', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('3', '19', '百度一下', null, null, 'http://www.baidu.com', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('4', '19', '谷歌搜索', null, null, 'http://www.google.com', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('5', '20', '新浪网', null, null, 'http://www.sina.com.cn', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('6', '20', '腾讯网', null, null, 'http://www.qq.com/', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('7', '21', '淘宝网', null, null, 'http://www.taobao.com/', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('8', '21', '新华网', null, null, 'http://www.xinhuanet.com/', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_link` VALUES ('9', '22', '赶集网', null, null, 'http://www.ganji.com/', '0', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');

-- ----------------------------
-- Table structure for cms_site
-- ----------------------------
DROP TABLE IF EXISTS `cms_site`;
CREATE TABLE `cms_site` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '站点名称',
  `title` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '站点标题',
  `logo` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '站点Logo',
  `domain` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '站点域名',
  `description` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '描述',
  `keywords` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '关键字',
  `theme` varchar(255) COLLATE utf8_bin DEFAULT 'default' COMMENT '主题',
  `copyright` text COLLATE utf8_bin COMMENT '版权信息',
  `custom_index_view` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '自定义站点首页视图',
  `create_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '更新者',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `cms_site_del_flag` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='站点表';

-- ----------------------------
-- Records of cms_site
-- ----------------------------
INSERT INTO `cms_site` VALUES ('1', '默认站点', 'JeeSite Web', null, null, 'JeeSite', 'JeeSite', 'basic', 0x436F707972696768742026636F70793B20323031322D32303133203C6120687265663D27687474703A2F2F7468696E6B67656D2E69746579652E636F6D27207461726765743D275F626C616E6B273E5468696E6B47656D3C2F613E202D20506F7765726564204279203C6120687265663D2768747470733A2F2F6769746875622E636F6D2F7468696E6B67656D2F6A65657369746527207461726765743D275F626C616E6B273E4A6565536974653C2F613E2056312E30, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `cms_site` VALUES ('2', '子站点测试', 'JeeSite Subsite', null, null, 'JeeSite subsite', 'JeeSite subsite', 'basic', 0x436F707972696768742026636F70793B20323031322D32303133203C6120687265663D27687474703A2F2F7468696E6B67656D2E69746579652E636F6D27207461726765743D275F626C616E6B273E5468696E6B47656D3C2F613E202D20506F7765726564204279203C6120687265663D2768747470733A2F2F6769746875622E636F6D2F7468696E6B67656D2F6A65657369746527207461726765743D275F626C616E6B273E4A6565536974653C2F613E2056312E30, null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');

-- ----------------------------
-- Table structure for district
-- ----------------------------
DROP TABLE IF EXISTS `district`;
CREATE TABLE `district` (
  `id` smallint(5) DEFAULT NULL,
  `name` varchar(270) DEFAULT NULL,
  `parent_id` smallint(5) DEFAULT NULL,
  `initial` char(3) DEFAULT NULL,
  `initials` varchar(30) DEFAULT NULL,
  `pinyin` varchar(600) DEFAULT NULL,
  `extra` varchar(60) DEFAULT NULL,
  `suffix` varchar(15) DEFAULT NULL,
  `code` char(30) DEFAULT NULL,
  `area_code` varchar(30) DEFAULT NULL,
  `order` tinyint(2) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of district
-- ----------------------------
INSERT INTO `district` VALUES ('1', '北京', '0', 'b', 'bj', 'beijing', '', '市', '110000', '010', '1');
INSERT INTO `district` VALUES ('2', '天津', '0', 't', 'tj', 'tianjin', '', '市', '120000', '022', '2');
INSERT INTO `district` VALUES ('3', '上海', '0', 's', 'sh', 'shanghai', '', '市', '310000', '021', '3');
INSERT INTO `district` VALUES ('4', '重庆', '0', 'z', 'zq', 'zhongqing', '', '市', '500000', '023', '4');
INSERT INTO `district` VALUES ('5', '河北', '0', 'h', 'hb', 'hebei', '', '省', '130000', '', '5');
INSERT INTO `district` VALUES ('6', '山西', '0', 's', 'sx', 'shanxi', '', '省', '140000', '', '6');
INSERT INTO `district` VALUES ('7', '内蒙古', '0', 'n', 'nmg', 'neimenggu', '', '自治区', '150000', '', '7');
INSERT INTO `district` VALUES ('8', '辽宁', '0', 'l', 'ln', 'liaoning', '', '省', '210000', '', '8');
INSERT INTO `district` VALUES ('9', '吉林', '0', 'j', 'jl', 'jilin', '', '省', '220000', '', '9');
INSERT INTO `district` VALUES ('10', '黑龙江', '0', 'h', 'hlj', 'heilongjiang', '', '省', '230000', '', '10');
INSERT INTO `district` VALUES ('11', '江苏', '0', 'j', 'js', 'jiangsu', '', '省', '320000', '', '11');
INSERT INTO `district` VALUES ('12', '浙江', '0', 'z', 'zj', 'zhejiang', '', '省', '330000', '', '12');
INSERT INTO `district` VALUES ('13', '安徽', '0', 'a', 'ah', 'anhui', '', '省', '340000', '', '13');
INSERT INTO `district` VALUES ('14', '福建', '0', 'f', 'fj', 'fujian', '', '省', '350000', '', '14');
INSERT INTO `district` VALUES ('15', '江西', '0', 'j', 'jx', 'jiangxi', '', '省', '360000', '', '15');
INSERT INTO `district` VALUES ('16', '山东', '0', 's', 'sd', 'shandong', '', '省', '370000', '', '16');
INSERT INTO `district` VALUES ('17', '河南', '0', 'h', 'hn', 'henan', '', '省', '410000', '', '17');
INSERT INTO `district` VALUES ('18', '湖北', '0', 'h', 'hb', 'hubei', '', '省', '420000', '', '18');
INSERT INTO `district` VALUES ('19', '湖南', '0', 'h', 'hn', 'hunan', '', '省', '430000', '', '19');
INSERT INTO `district` VALUES ('20', '广东', '0', 'g', 'gd', 'guangdong', '', '省', '440000', '', '20');
INSERT INTO `district` VALUES ('21', '广西', '0', 'g', 'gx', 'guangxi', '壮族', '自治区', '450000', '', '21');
INSERT INTO `district` VALUES ('22', '海南', '0', 'h', 'hn', 'hainan', '', '省', '460000', '', '22');
INSERT INTO `district` VALUES ('23', '四川', '0', 's', 'sc', 'sichuan', '', '省', '510000', '', '23');
INSERT INTO `district` VALUES ('24', '贵州', '0', 'g', 'gz', 'guizhou', '', '省', '520000', '', '24');
INSERT INTO `district` VALUES ('25', '云南', '0', 'y', 'yn', 'yunnan', '', '省', '530000', '', '25');
INSERT INTO `district` VALUES ('26', '西藏', '0', 'x', 'xz', 'xizang', '', '自治区', '540000', '', '26');
INSERT INTO `district` VALUES ('27', '陕西', '0', 's', 'sx', 'shanxi', '', '省', '610000', '', '27');
INSERT INTO `district` VALUES ('28', '甘肃', '0', 'g', 'gs', 'gansu', '', '省', '620000', '', '28');
INSERT INTO `district` VALUES ('29', '青海', '0', 'q', 'qh', 'qinghai', '', '省', '630000', '', '29');
INSERT INTO `district` VALUES ('30', '宁夏', '0', 'n', 'nx', 'ningxia', '回族', '自治区', '640000', '', '30');
INSERT INTO `district` VALUES ('31', '新疆', '0', 'x', 'xj', 'xinjiang', '维吾尔', '自治区', '650000', '', '31');
INSERT INTO `district` VALUES ('32', '台湾', '0', 't', 'tw', 'taiwan', '', '省', '710000', '', '32');
INSERT INTO `district` VALUES ('33', '香港', '0', 'x', 'xg', 'xianggang', '', '特别行政区', '810000', '852', '33');
INSERT INTO `district` VALUES ('34', '澳门', '0', 'a', 'am', 'aomen', '', '特别行政区', '820000', '853', '34');
INSERT INTO `district` VALUES ('35', '海外', '0', 'h', 'hw', 'haiwai', '', '', '', '', '35');
INSERT INTO `district` VALUES ('36', '东城', '1', 'd', 'dc', 'dongcheng', '', '区', '110101', '010', '1');
INSERT INTO `district` VALUES ('37', '西城', '1', 'x', 'xc', 'xicheng', '', '区', '110102', '010', '2');
INSERT INTO `district` VALUES ('38', '崇文', '1', 'c', 'cw', 'chongwen', '', '区', '110103', '010', '3');
INSERT INTO `district` VALUES ('39', '宣武', '1', 'x', 'xw', 'xuanwu', '', '区', '110104', '010', '4');
INSERT INTO `district` VALUES ('40', '朝阳', '1', 'c', 'cy', 'chaoyang', '', '区', '110105', '010', '5');
INSERT INTO `district` VALUES ('41', '丰台', '1', 'f', 'ft', 'fengtai', '', '区', '110106', '010', '6');
INSERT INTO `district` VALUES ('42', '石景山', '1', 's', 'sjs', 'shijingshan', '', '区', '110107', '010', '7');
INSERT INTO `district` VALUES ('43', '海淀', '1', 'h', 'hd', 'haidian', '', '区', '110108', '010', '8');
INSERT INTO `district` VALUES ('44', '门头沟', '1', 'm', 'mtg', 'mentougou', '', '区', '110109', '010', '9');
INSERT INTO `district` VALUES ('45', '房山', '1', 'f', 'fs', 'fangshan', '', '区', '110111', '010', '10');
INSERT INTO `district` VALUES ('46', '通州', '1', 't', 'tz', 'tongzhou', '', '区', '110112', '010', '11');
INSERT INTO `district` VALUES ('47', '顺义', '1', 's', 'sy', 'shunyi', '', '区', '110113', '010', '12');
INSERT INTO `district` VALUES ('48', '昌平', '1', 'c', 'cp', 'changping', '', '区', '110114', '010', '13');
INSERT INTO `district` VALUES ('49', '大兴', '1', 'd', 'dx', 'daxing', '', '区', '110115', '010', '14');
INSERT INTO `district` VALUES ('50', '怀柔', '1', 'h', 'hr', 'huairou', '', '区', '110116', '010', '15');
INSERT INTO `district` VALUES ('51', '平谷', '1', 'p', 'pg', 'pinggu', '', '区', '110117', '010', '16');
INSERT INTO `district` VALUES ('52', '密云', '1', 'm', 'my', 'miyun', '', '区', '110228', '010', '17');
INSERT INTO `district` VALUES ('53', '延庆', '1', 'y', 'yq', 'yanqing', '', '区', '110229', '010', '18');
INSERT INTO `district` VALUES ('54', '和平', '2', 'h', 'hp', 'heping', '', '区', '120101', '022', '1');
INSERT INTO `district` VALUES ('55', '河东', '2', 'h', 'hd', 'hedong', '', '区', '120102', '022', '2');
INSERT INTO `district` VALUES ('56', '河西', '2', 'h', 'hx', 'hexi', '', '区', '120103', '022', '3');
INSERT INTO `district` VALUES ('57', '南开', '2', 'n', 'nk', 'nankai', '', '区', '120104', '022', '4');
INSERT INTO `district` VALUES ('58', '河北', '2', 'h', 'hb', 'hebei', '', '区', '120105', '022', '5');
INSERT INTO `district` VALUES ('59', '红桥', '2', 'h', 'hq', 'hongqiao', '', '区', '120106', '022', '6');
INSERT INTO `district` VALUES ('60', '东丽', '2', 'd', 'dl', 'dongli', '', '区', '120110', '022', '7');
INSERT INTO `district` VALUES ('61', '西青', '2', 'x', 'xq', 'xiqing', '', '区', '120111', '022', '8');
INSERT INTO `district` VALUES ('62', '津南', '2', 'j', 'jn', 'jinnan', '', '区', '120112', '022', '9');
INSERT INTO `district` VALUES ('63', '北辰', '2', 'b', 'bc', 'beichen', '', '区', '120113', '022', '10');
INSERT INTO `district` VALUES ('64', '武清', '2', 'w', 'wq', 'wuqing', '', '区', '120114', '022', '11');
INSERT INTO `district` VALUES ('65', '宝坻', '2', 'b', 'bc', 'baochi', '', '区', '120115', '022', '12');
INSERT INTO `district` VALUES ('66', '滨海新区', '2', 'b', 'bhxq', 'binhaixinqu', '', '', '120116', '022', '13');
INSERT INTO `district` VALUES ('67', '宁河', '2', 'n', 'nh', 'ninghe', '', '区', '120221', '022', '14');
INSERT INTO `district` VALUES ('68', '蓟州', '2', 'j', 'jz', 'jizhou', '', '区', '120223', '022', '15');
INSERT INTO `district` VALUES ('69', '静海', '2', 'j', 'jh', 'jinghai', '', '区', '120225', '022', '16');
INSERT INTO `district` VALUES ('70', '黄浦', '3', 'h', 'hp', 'huangpu', '', '区', '310101', '021', '1');
INSERT INTO `district` VALUES ('71', '徐汇', '3', 'x', 'xh', 'xuhui', '', '区', '310104', '021', '2');
INSERT INTO `district` VALUES ('72', '长宁', '3', 'z', 'zn', 'zhangning', '', '区', '310105', '021', '3');
INSERT INTO `district` VALUES ('73', '静安', '3', 'j', 'ja', 'jingan', '', '区', '310106', '021', '4');
INSERT INTO `district` VALUES ('74', '普陀', '3', 'p', 'pt', 'putuo', '', '区', '310107', '021', '5');
INSERT INTO `district` VALUES ('76', '虹口', '3', 'h', 'hk', 'hongkou', '', '区', '310109', '021', '7');
INSERT INTO `district` VALUES ('77', '杨浦', '3', 'y', 'yp', 'yangpu', '', '区', '310110', '021', '8');
INSERT INTO `district` VALUES ('78', '闵行', '3', 'm', 'mx', 'minxing', '', '区', '310112', '021', '9');
INSERT INTO `district` VALUES ('79', '宝山', '3', 'b', 'bs', 'baoshan', '', '区', '310113', '021', '10');
INSERT INTO `district` VALUES ('80', '嘉定', '3', 'j', 'jd', 'jiading', '', '区', '310114', '021', '11');
INSERT INTO `district` VALUES ('81', '浦东新区', '3', 'p', 'pdxq', 'pudongxinqu', '', '', '310115', '021', '12');
INSERT INTO `district` VALUES ('82', '金山', '3', 'j', 'js', 'jinshan', '', '区', '310116', '021', '13');
INSERT INTO `district` VALUES ('83', '松江', '3', 's', 'sj', 'songjiang', '', '区', '310117', '021', '14');
INSERT INTO `district` VALUES ('84', '青浦', '3', 'q', 'qp', 'qingpu', '', '区', '310118', '021', '15');
INSERT INTO `district` VALUES ('85', '奉贤', '3', 'f', 'fx', 'fengxian', '', '区', '310120', '021', '16');
INSERT INTO `district` VALUES ('86', '崇明', '3', 'c', 'cm', 'chongming', '', '区', '310230', '021', '17');
INSERT INTO `district` VALUES ('87', '万州', '4', 'w', 'wz', 'wanzhou', '', '区', '500101', '023', '1');
INSERT INTO `district` VALUES ('88', '涪陵', '4', 'f', 'fl', 'fuling', '', '区', '500102', '023', '2');
INSERT INTO `district` VALUES ('89', '渝中', '4', 'y', 'yz', 'yuzhong', '', '区', '500103', '023', '3');
INSERT INTO `district` VALUES ('90', '大渡口', '4', 'd', 'ddk', 'dadukou', '', '区', '500104', '023', '4');
INSERT INTO `district` VALUES ('91', '江北', '4', 'j', 'jb', 'jiangbei', '', '区', '500105', '023', '5');
INSERT INTO `district` VALUES ('92', '沙坪坝', '4', 's', 'spb', 'shapingba', '', '区', '500106', '023', '6');
INSERT INTO `district` VALUES ('93', '九龙坡', '4', 'j', 'jlp', 'jiulongpo', '', '区', '500107', '023', '7');
INSERT INTO `district` VALUES ('94', '南岸', '4', 'n', 'na', 'nanan', '', '区', '500108', '023', '8');
INSERT INTO `district` VALUES ('95', '北碚', '4', 'b', 'bb', 'beibei', '', '区', '500109', '023', '9');
INSERT INTO `district` VALUES ('96', '綦江', '4', 'q', 'qj', 'qijiang', '', '区', '500110', '023', '10');
INSERT INTO `district` VALUES ('97', '大足', '4', 'd', 'dz', 'dazu', '', '区', '500111', '023', '11');
INSERT INTO `district` VALUES ('98', '渝北', '4', 'y', 'yb', 'yubei', '', '区', '500112', '023', '12');
INSERT INTO `district` VALUES ('99', '巴南', '4', 'b', 'bn', 'banan', '', '区', '500113', '023', '13');
INSERT INTO `district` VALUES ('100', '黔江', '4', 'q', 'qj', 'qianjiang', '', '区', '500114', '023', '14');
INSERT INTO `district` VALUES ('101', '长寿', '4', 'z', 'zs', 'zhangshou', '', '区', '500115', '023', '15');
INSERT INTO `district` VALUES ('102', '江津', '4', 'j', 'jj', 'jiangjin', '', '区', '500116', '023', '16');
INSERT INTO `district` VALUES ('103', '合川', '4', 'h', 'hc', 'hechuan', '', '区', '500117', '023', '17');
INSERT INTO `district` VALUES ('104', '永川', '4', 'y', 'yc', 'yongchuan', '', '区', '500118', '023', '18');
INSERT INTO `district` VALUES ('105', '南川', '4', 'n', 'nc', 'nanchuan', '', '区', '500119', '023', '19');
INSERT INTO `district` VALUES ('106', '潼南', '4', 't', 'tn', 'tongnan', '', '区', '500223', '023', '22');
INSERT INTO `district` VALUES ('107', '铜梁', '4', 't', 'tl', 'tongliang', '', '区', '500151', '023', '21');
INSERT INTO `district` VALUES ('108', '荣昌', '4', 'r', 'rc', 'rongchang', '', '区', '500226', '023', '23');
INSERT INTO `district` VALUES ('109', '璧山', '4', 'b', 'bs', 'bishan', '', '区', '500120', '023', '20');
INSERT INTO `district` VALUES ('110', '梁平', '4', 'l', 'lp', 'liangping', '', '区', '500228', '023', '24');
INSERT INTO `district` VALUES ('111', '城口', '4', 'c', 'ck', 'chengkou', '', '县', '500229', '023', '25');
INSERT INTO `district` VALUES ('112', '丰都', '4', 'f', 'fd', 'fengdou', '', '县', '500230', '023', '26');
INSERT INTO `district` VALUES ('113', '垫江', '4', 'd', 'dj', 'dianjiang', '', '县', '500231', '023', '27');
INSERT INTO `district` VALUES ('114', '武隆', '4', 'w', 'wl', 'wulong', '', '区', '500232', '023', '28');
INSERT INTO `district` VALUES ('115', '忠县', '4', 'z', 'zx', 'zhongxian', '', '', '500233', '023', '29');
INSERT INTO `district` VALUES ('116', '开州', '4', 'k', 'kz', 'kaizhou', '', '区', '500234', '023', '30');
INSERT INTO `district` VALUES ('117', '云阳', '4', 'y', 'yy', 'yunyang', '', '县', '500235', '023', '31');
INSERT INTO `district` VALUES ('118', '奉节', '4', 'f', 'fj', 'fengjie', '', '县', '500236', '023', '32');
INSERT INTO `district` VALUES ('119', '巫山', '4', 'w', 'ws', 'wushan', '', '县', '500237', '023', '33');
INSERT INTO `district` VALUES ('120', '巫溪', '4', 'w', 'wx', 'wuxi', '', '县', '500238', '023', '34');
INSERT INTO `district` VALUES ('121', '石柱', '4', 's', 'sz', 'shizhu', '土家族', '自治县', '500240', '023', '35');
INSERT INTO `district` VALUES ('122', '秀山', '4', 'x', 'xs', 'xiushan', '土家族苗族', '自治县', '500241', '023', '36');
INSERT INTO `district` VALUES ('123', '酉阳', '4', 'y', 'yy', 'youyang', '土家族苗族', '自治县', '500242', '023', '37');
INSERT INTO `district` VALUES ('124', '彭水', '4', 'p', 'ps', 'pengshui', '苗族土家族', '自治县', '500243', '023', '38');
INSERT INTO `district` VALUES ('125', '石家庄', '5', 's', 'sjz', 'shijiazhuang', '', '市', '130100', '0311', '1');
INSERT INTO `district` VALUES ('126', '唐山', '5', 't', 'ts', 'tangshan', '', '市', '130200', '0315', '2');
INSERT INTO `district` VALUES ('127', '秦皇岛', '5', 'q', 'qhd', 'qinhuangdao', '', '市', '130300', '0335', '3');
INSERT INTO `district` VALUES ('128', '邯郸', '5', 'h', 'hd', 'handan', '', '市', '130400', '0310', '4');
INSERT INTO `district` VALUES ('129', '邢台', '5', 'x', 'xt', 'xingtai', '', '市', '130500', '0319', '5');
INSERT INTO `district` VALUES ('130', '保定', '5', 'b', 'bd', 'baoding', '', '市', '130600', '0312', '6');
INSERT INTO `district` VALUES ('131', '张家口', '5', 'z', 'zjk', 'zhangjiakou', '', '市', '130700', '0313', '7');
INSERT INTO `district` VALUES ('132', '承德', '5', 'c', 'cd', 'chengde', '', '市', '130800', '0314', '8');
INSERT INTO `district` VALUES ('133', '沧州', '5', 'c', 'cz', 'cangzhou', '', '市', '130900', '0317', '9');
INSERT INTO `district` VALUES ('134', '廊坊', '5', 'l', 'lf', 'langfang', '', '市', '131000', '0316', '10');
INSERT INTO `district` VALUES ('135', '衡水', '5', 'h', 'hs', 'hengshui', '', '市', '131100', '0318', '11');
INSERT INTO `district` VALUES ('136', '太原', '6', 't', 'ty', 'taiyuan', '', '市', '140100', '0351', '1');
INSERT INTO `district` VALUES ('137', '大同', '6', 'd', 'dt', 'datong', '', '市', '140200', '0352', '2');
INSERT INTO `district` VALUES ('138', '阳泉', '6', 'y', 'yq', 'yangquan', '', '市', '140300', '0353', '3');
INSERT INTO `district` VALUES ('139', '长治', '6', 'z', 'zz', 'zhangzhi', '', '市', '140400', '0355', '4');
INSERT INTO `district` VALUES ('140', '晋城', '6', 'j', 'jc', 'jincheng', '', '市', '140500', '0356', '5');
INSERT INTO `district` VALUES ('141', '朔州', '6', 's', 'sz', 'shuozhou', '', '市', '140600', '0349', '6');
INSERT INTO `district` VALUES ('142', '晋中', '6', 'j', 'jz', 'jinzhong', '', '市', '140700', '0354', '7');
INSERT INTO `district` VALUES ('143', '运城', '6', 'y', 'yc', 'yuncheng', '', '市', '140800', '0359', '8');
INSERT INTO `district` VALUES ('144', '忻州', '6', 'x', 'xz', 'xinzhou', '', '市', '140900', '0350', '9');
INSERT INTO `district` VALUES ('145', '临汾', '6', 'l', 'lf', 'linfen', '', '市', '141000', '0357', '10');
INSERT INTO `district` VALUES ('146', '吕梁', '6', 'l', 'll', 'lu:liang', '', '市', '141100', '0358', '11');
INSERT INTO `district` VALUES ('147', '呼和浩特', '7', 'h', 'hhht', 'huhehaote', '', '市', '150100', '0471', '1');
INSERT INTO `district` VALUES ('148', '包头', '7', 'b', 'bt', 'baotou', '', '市', '150200', '0472', '2');
INSERT INTO `district` VALUES ('149', '乌海', '7', 'w', 'wh', 'wuhai', '', '市', '150300', '0473', '3');
INSERT INTO `district` VALUES ('150', '赤峰', '7', 'c', 'cf', 'chifeng', '', '市', '150400', '0476', '4');
INSERT INTO `district` VALUES ('151', '通辽', '7', 't', 'tl', 'tongliao', '', '市', '150500', '0475', '5');
INSERT INTO `district` VALUES ('152', '鄂尔多斯', '7', 'e', 'eeds', 'eerduosi', '', '市', '150600', '0477', '6');
INSERT INTO `district` VALUES ('153', '呼伦贝尔', '7', 'h', 'hlbe', 'hulunbeier', '', '市', '150700', '0470', '7');
INSERT INTO `district` VALUES ('154', '巴彦淖尔', '7', 'b', 'byne', 'bayannaoer', '', '市', '150800', '0478', '8');
INSERT INTO `district` VALUES ('155', '乌兰察布', '7', 'w', 'wlcb', 'wulanchabu', '', '市', '150900', '0474', '9');
INSERT INTO `district` VALUES ('156', '兴安', '7', 'x', 'xa', 'xingan', '', '盟', '152200', '0482', '10');
INSERT INTO `district` VALUES ('157', '锡林郭勒', '7', 'x', 'xlgl', 'xilinguole', '', '盟', '152500', '0479', '11');
INSERT INTO `district` VALUES ('158', '阿拉善', '7', 'a', 'als', 'alashan', '', '盟', '152900', '0483', '12');
INSERT INTO `district` VALUES ('159', '沈阳', '8', 's', 'sy', 'shenyang', '', '市', '210100', '024', '1');
INSERT INTO `district` VALUES ('160', '大连', '8', 'd', 'dl', 'dalian', '', '市', '210200', '0411', '2');
INSERT INTO `district` VALUES ('161', '鞍山', '8', 'a', 'as', 'anshan', '', '市', '210300', '0412', '3');
INSERT INTO `district` VALUES ('162', '抚顺', '8', 'f', 'fs', 'fushun', '', '市', '210400', '0413', '4');
INSERT INTO `district` VALUES ('163', '本溪', '8', 'b', 'bx', 'benxi', '', '市', '210500', '0414', '5');
INSERT INTO `district` VALUES ('164', '丹东', '8', 'd', 'dd', 'dandong', '', '市', '210600', '0415', '6');
INSERT INTO `district` VALUES ('165', '锦州', '8', 'j', 'jz', 'jinzhou', '', '市', '210700', '0416', '7');
INSERT INTO `district` VALUES ('166', '营口', '8', 'y', 'yk', 'yingkou', '', '市', '210800', '0417', '8');
INSERT INTO `district` VALUES ('167', '阜新', '8', 'f', 'fx', 'fuxin', '', '市', '210900', '0418', '9');
INSERT INTO `district` VALUES ('168', '辽阳', '8', 'l', 'ly', 'liaoyang', '', '市', '211000', '0419', '10');
INSERT INTO `district` VALUES ('169', '盘锦', '8', 'p', 'pj', 'panjin', '', '市', '211100', '0427', '11');
INSERT INTO `district` VALUES ('170', '铁岭', '8', 't', 'tl', 'tieling', '', '市', '211200', '0410', '12');
INSERT INTO `district` VALUES ('171', '朝阳', '8', 'c', 'cy', 'chaoyang', '', '市', '211300', '0421', '13');
INSERT INTO `district` VALUES ('172', '葫芦岛', '8', 'h', 'hld', 'huludao', '', '市', '211400', '0429', '14');
INSERT INTO `district` VALUES ('173', '长春', '9', 'z', 'zc', 'zhangchun', '', '市', '220100', '0431', '1');
INSERT INTO `district` VALUES ('174', '吉林', '9', 'j', 'jl', 'jilin', '', '市', '220200', '0432', '2');
INSERT INTO `district` VALUES ('175', '四平', '9', 's', 'sp', 'siping', '', '市', '220300', '0434', '3');
INSERT INTO `district` VALUES ('176', '辽源', '9', 'l', 'ly', 'liaoyuan', '', '市', '220400', '0437', '4');
INSERT INTO `district` VALUES ('177', '通化', '9', 't', 'th', 'tonghua', '', '市', '220500', '0435', '5');
INSERT INTO `district` VALUES ('178', '白山', '9', 'b', 'bs', 'baishan', '', '市', '220600', '0439', '6');
INSERT INTO `district` VALUES ('179', '松原', '9', 's', 'sy', 'songyuan', '', '市', '220700', '0438', '7');
INSERT INTO `district` VALUES ('180', '白城', '9', 'b', 'bc', 'baicheng', '', '市', '220800', '0436', '8');
INSERT INTO `district` VALUES ('181', '延边', '9', 'y', 'yb', 'yanbian', '朝鲜族', '自治州', '222400', '0433', '9');
INSERT INTO `district` VALUES ('182', '哈尔滨', '10', 'h', 'heb', 'haerbin', '', '市', '230100', '0451', '1');
INSERT INTO `district` VALUES ('183', '齐齐哈尔', '10', 'q', 'qqhe', 'qiqihaer', '', '市', '230200', '0452', '2');
INSERT INTO `district` VALUES ('184', '鸡西', '10', 'j', 'jx', 'jixi', '', '市', '230300', '0467', '3');
INSERT INTO `district` VALUES ('185', '鹤岗', '10', 'h', 'hg', 'hegang', '', '市', '230400', '0468', '4');
INSERT INTO `district` VALUES ('186', '双鸭山', '10', 's', 'sys', 'shuangyashan', '', '市', '230500', '0469', '5');
INSERT INTO `district` VALUES ('187', '大庆', '10', 'd', 'dq', 'daqing', '', '市', '230600', '0459', '6');
INSERT INTO `district` VALUES ('188', '伊春', '10', 'y', 'yc', 'yichun', '', '市', '230700', '0458', '7');
INSERT INTO `district` VALUES ('189', '佳木斯', '10', 'j', 'jms', 'jiamusi', '', '市', '230800', '0454', '8');
INSERT INTO `district` VALUES ('190', '七台河', '10', 'q', 'qth', 'qitaihe', '', '市', '230900', '0464', '9');
INSERT INTO `district` VALUES ('191', '牡丹江', '10', 'm', 'mdj', 'mudanjiang', '', '市', '231000', '0453', '10');
INSERT INTO `district` VALUES ('192', '黑河', '10', 'h', 'hh', 'heihe', '', '市', '231100', '0456', '11');
INSERT INTO `district` VALUES ('193', '绥化', '10', 's', 'sh', 'suihua', '', '市', '231200', '0455', '12');
INSERT INTO `district` VALUES ('194', '大兴安岭', '10', 'd', 'dxal', 'daxinganling', '', '地区', '232700', '0457', '13');
INSERT INTO `district` VALUES ('195', '南京', '11', 'n', 'nj', 'nanjing', '', '市', '320100', '', '1');
INSERT INTO `district` VALUES ('196', '无锡', '11', 'w', 'wx', 'wuxi', '', '市', '320200', '0510', '2');
INSERT INTO `district` VALUES ('197', '徐州', '11', 'x', 'xz', 'xuzhou', '', '市', '320300', '0516', '3');
INSERT INTO `district` VALUES ('198', '常州', '11', 'c', 'cz', 'changzhou', '', '市', '320400', '0519', '4');
INSERT INTO `district` VALUES ('199', '苏州', '11', 's', 'sz', 'suzhou', '', '市', '320500', '0512', '5');
INSERT INTO `district` VALUES ('200', '南通', '11', 'n', 'nt', 'nantong', '', '市', '320600', '0513', '6');
INSERT INTO `district` VALUES ('201', '连云港', '11', 'l', 'lyg', 'lianyungang', '', '市', '320700', '0518', '7');
INSERT INTO `district` VALUES ('202', '淮安', '11', 'h', 'ha', 'huaian', '', '市', '320800', '0517', '8');
INSERT INTO `district` VALUES ('203', '盐城', '11', 'y', 'yc', 'yancheng', '', '市', '320900', '0515', '9');
INSERT INTO `district` VALUES ('204', '扬州', '11', 'y', 'yz', 'yangzhou', '', '市', '321000', '0514', '10');
INSERT INTO `district` VALUES ('205', '镇江', '11', 'z', 'zj', 'zhenjiang', '', '市', '321100', '0511', '11');
INSERT INTO `district` VALUES ('206', '泰州', '11', 't', 'tz', 'taizhou', '', '市', '321200', '0523', '12');
INSERT INTO `district` VALUES ('207', '宿迁', '11', 's', 'sq', 'suqian', '', '市', '321300', '0527', '13');
INSERT INTO `district` VALUES ('208', '杭州', '12', 'h', 'hz', 'hangzhou', '', '市', '330100', '0571', '1');
INSERT INTO `district` VALUES ('209', '宁波', '12', 'n', 'nb', 'ningbo', '', '市', '330200', '0574', '2');
INSERT INTO `district` VALUES ('210', '温州', '12', 'w', 'wz', 'wenzhou', '', '市', '330300', '0577', '3');
INSERT INTO `district` VALUES ('211', '嘉兴', '12', 'j', 'jx', 'jiaxing', '', '市', '330400', '0573', '4');
INSERT INTO `district` VALUES ('212', '湖州', '12', 'h', 'hz', 'huzhou', '', '市', '330500', '0572', '5');
INSERT INTO `district` VALUES ('213', '绍兴', '12', 's', 'sx', 'shaoxing', '', '市', '330600', '0575', '6');
INSERT INTO `district` VALUES ('214', '金华', '12', 'j', 'jh', 'jinhua', '', '市', '330700', '0579', '7');
INSERT INTO `district` VALUES ('215', '衢州', '12', 'q', 'qz', 'quzhou', '', '市', '330800', '0570', '8');
INSERT INTO `district` VALUES ('216', '舟山', '12', 'z', 'zs', 'zhoushan', '', '市', '330900', '0580', '9');
INSERT INTO `district` VALUES ('217', '台州', '12', 't', 'tz', 'taizhou', '', '市', '331000', '0576', '10');
INSERT INTO `district` VALUES ('218', '丽水', '12', 'l', 'ls', 'lishui', '', '市', '331100', '0578', '11');
INSERT INTO `district` VALUES ('219', '合肥', '13', 'h', 'hf', 'hefei', '', '市', '340100', '0551', '1');
INSERT INTO `district` VALUES ('220', '芜湖', '13', 'w', 'wh', 'wuhu', '', '市', '340200', '0553', '2');
INSERT INTO `district` VALUES ('221', '蚌埠', '13', 'b', 'bb', 'bangbu', '', '市', '340300', '0552', '3');
INSERT INTO `district` VALUES ('222', '淮南', '13', 'h', 'hn', 'huainan', '', '市', '340400', '0554', '4');
INSERT INTO `district` VALUES ('223', '马鞍山', '13', 'm', 'mas', 'maanshan', '', '市', '340500', '0555', '5');
INSERT INTO `district` VALUES ('224', '淮北', '13', 'h', 'hb', 'huaibei', '', '市', '340600', '0561', '6');
INSERT INTO `district` VALUES ('225', '铜陵', '13', 't', 'tl', 'tongling', '', '市', '340700', '0562', '7');
INSERT INTO `district` VALUES ('226', '安庆', '13', 'a', 'aq', 'anqing', '', '市', '340800', '0556', '8');
INSERT INTO `district` VALUES ('227', '黄山', '13', 'h', 'hs', 'huangshan', '', '市', '341000', '0559', '9');
INSERT INTO `district` VALUES ('228', '滁州', '13', 'c', 'cz', 'chuzhou', '', '市', '341100', '0550', '10');
INSERT INTO `district` VALUES ('229', '阜阳', '13', 'f', 'fy', 'fuyang', '', '市', '341200', '0558', '11');
INSERT INTO `district` VALUES ('230', '宿州', '13', 's', 'sz', 'suzhou', '', '市', '341300', '0557', '12');
INSERT INTO `district` VALUES ('231', '六安', '13', 'l', 'la', 'liuan', '', '市', '341500', '0564', '13');
INSERT INTO `district` VALUES ('232', '亳州', '13', 'b', 'bz', 'bozhou', '', '市', '341600', '0558', '14');
INSERT INTO `district` VALUES ('233', '池州', '13', 'c', 'cz', 'chizhou', '', '市', '341700', '0566', '15');
INSERT INTO `district` VALUES ('234', '宣城', '13', 'x', 'xc', 'xuancheng', '', '市', '341800', '0563', '16');
INSERT INTO `district` VALUES ('235', '福州', '14', 'f', 'fz', 'fuzhou', '', '市', '350100', '0591', '1');
INSERT INTO `district` VALUES ('236', '厦门', '14', 's', 'sm', 'shamen', '', '市', '350200', '0592', '2');
INSERT INTO `district` VALUES ('237', '莆田', '14', 'p', 'pt', 'putian', '', '市', '350300', '0594', '3');
INSERT INTO `district` VALUES ('238', '三明', '14', 's', 'sm', 'sanming', '', '市', '350400', '0598', '4');
INSERT INTO `district` VALUES ('239', '泉州', '14', 'q', 'qz', 'quanzhou', '', '市', '350500', '0595', '5');
INSERT INTO `district` VALUES ('240', '漳州', '14', 'z', 'zz', 'zhangzhou', '', '市', '350600', '0596', '6');
INSERT INTO `district` VALUES ('241', '南平', '14', 'n', 'np', 'nanping', '', '市', '350700', '0599', '7');
INSERT INTO `district` VALUES ('242', '龙岩', '14', 'l', 'ly', 'longyan', '', '市', '350800', '0597', '8');
INSERT INTO `district` VALUES ('243', '宁德', '14', 'n', 'nd', 'ningde', '', '市', '350900', '0593', '9');
INSERT INTO `district` VALUES ('244', '南昌', '15', 'n', 'nc', 'nanchang', '', '市', '360100', '0791', '1');
INSERT INTO `district` VALUES ('245', '景德镇', '15', 'j', 'jdz', 'jingdezhen', '', '市', '360200', '0798', '2');
INSERT INTO `district` VALUES ('246', '萍乡', '15', 'p', 'px', 'pingxiang', '', '市', '360300', '0799', '3');
INSERT INTO `district` VALUES ('247', '九江', '15', 'j', 'jj', 'jiujiang', '', '市', '360400', '0792', '4');
INSERT INTO `district` VALUES ('248', '新余', '15', 'x', 'xy', 'xinyu', '', '市', '360500', '0790', '5');
INSERT INTO `district` VALUES ('249', '鹰潭', '15', 'y', 'yt', 'yingtan', '', '市', '360600', '0701', '6');
INSERT INTO `district` VALUES ('250', '赣州', '15', 'g', 'gz', 'ganzhou', '', '市', '360700', '0797', '7');
INSERT INTO `district` VALUES ('251', '吉安', '15', 'j', 'ja', 'jian', '', '市', '360800', '0796', '8');
INSERT INTO `district` VALUES ('252', '宜春', '15', 'y', 'yc', 'yichun', '', '市', '360900', '0795', '9');
INSERT INTO `district` VALUES ('253', '抚州', '15', 'f', 'fz', 'fuzhou', '', '市', '361000', '0794', '10');
INSERT INTO `district` VALUES ('254', '上饶', '15', 's', 'sr', 'shangrao', '', '市', '361100', '0793', '11');
INSERT INTO `district` VALUES ('255', '济南', '16', 'j', 'jn', 'jinan', '', '市', '370100', '0531', '1');
INSERT INTO `district` VALUES ('256', '青岛', '16', 'q', 'qd', 'qingdao', '', '市', '370200', '0532', '2');
INSERT INTO `district` VALUES ('257', '淄博', '16', 'z', 'zb', 'zibo', '', '市', '370300', '0533', '3');
INSERT INTO `district` VALUES ('258', '枣庄', '16', 'z', 'zz', 'zaozhuang', '', '市', '370400', '0632', '4');
INSERT INTO `district` VALUES ('259', '东营', '16', 'd', 'dy', 'dongying', '', '市', '370500', '0546', '5');
INSERT INTO `district` VALUES ('260', '烟台', '16', 'y', 'yt', 'yantai', '', '市', '370600', '0535', '6');
INSERT INTO `district` VALUES ('261', '潍坊', '16', 'w', 'wf', 'weifang', '', '市', '370700', '0536', '7');
INSERT INTO `district` VALUES ('262', '济宁', '16', 'j', 'jn', 'jining', '', '市', '370800', '0537', '8');
INSERT INTO `district` VALUES ('263', '泰安', '16', 't', 'ta', 'taian', '', '市', '370900', '0538', '9');
INSERT INTO `district` VALUES ('264', '威海', '16', 'w', 'wh', 'weihai', '', '市', '371000', '0631', '10');
INSERT INTO `district` VALUES ('265', '日照', '16', 'r', 'rz', 'rizhao', '', '市', '371100', '0633', '11');
INSERT INTO `district` VALUES ('266', '莱芜', '16', 'l', 'lw', 'laiwu', '', '市', '371200', '0634', '12');
INSERT INTO `district` VALUES ('267', '临沂', '16', 'l', 'ly', 'linyi', '', '市', '371300', '0539', '13');
INSERT INTO `district` VALUES ('268', '德州', '16', 'd', 'dz', 'dezhou', '', '市', '371400', '0534', '14');
INSERT INTO `district` VALUES ('269', '聊城', '16', 'l', 'lc', 'liaocheng', '', '市', '371500', '0635', '15');
INSERT INTO `district` VALUES ('270', '滨州', '16', 'b', 'bz', 'binzhou', '', '市', '371600', '0543', '16');
INSERT INTO `district` VALUES ('271', '菏泽', '16', 'h', 'hz', 'heze', '', '市', '371700', '0530', '17');
INSERT INTO `district` VALUES ('272', '郑州', '17', 'z', 'zz', 'zhengzhou', '', '市', '410100', '0371', '1');
INSERT INTO `district` VALUES ('273', '开封', '17', 'k', 'kf', 'kaifeng', '', '市', '410200', '0378', '2');
INSERT INTO `district` VALUES ('274', '洛阳', '17', 'l', 'ly', 'luoyang', '', '市', '410300', '0376', '3');
INSERT INTO `district` VALUES ('275', '平顶山', '17', 'p', 'pds', 'pingdingshan', '', '市', '410400', '0375', '4');
INSERT INTO `district` VALUES ('276', '安阳', '17', 'a', 'ay', 'anyang', '', '市', '410500', '0372', '5');
INSERT INTO `district` VALUES ('277', '鹤壁', '17', 'h', 'hb', 'hebi', '', '市', '410600', '0392', '6');
INSERT INTO `district` VALUES ('278', '新乡', '17', 'x', 'xx', 'xinxiang', '', '市', '410700', '0373', '7');
INSERT INTO `district` VALUES ('279', '焦作', '17', 'j', 'jz', 'jiaozuo', '', '市', '410800', '0391', '8');
INSERT INTO `district` VALUES ('280', '濮阳', '17', 'p', 'py', 'puyang', '', '市', '410900', '', '9');
INSERT INTO `district` VALUES ('281', '许昌', '17', 'x', 'xc', 'xuchang', '', '市', '411000', '0374', '10');
INSERT INTO `district` VALUES ('282', '漯河', '17', 'l', 'lh', 'luohe', '', '市', '411100', '0395', '11');
INSERT INTO `district` VALUES ('283', '三门峡', '17', 's', 'smx', 'sanmenxia', '', '市', '411200', '0398', '12');
INSERT INTO `district` VALUES ('284', '南阳', '17', 'n', 'ny', 'nanyang', '', '市', '411300', '0377', '13');
INSERT INTO `district` VALUES ('285', '商丘', '17', 's', 'sq', 'shangqiu', '', '市', '411400', '0370', '14');
INSERT INTO `district` VALUES ('286', '信阳', '17', 'x', 'xy', 'xinyang', '', '市', '411500', '0376', '15');
INSERT INTO `district` VALUES ('287', '周口', '17', 'z', 'zk', 'zhoukou', '', '市', '411600', '0394', '16');
INSERT INTO `district` VALUES ('288', '驻马店', '17', 'z', 'zmd', 'zhumadian', '', '市', '411700', '0396', '17');
INSERT INTO `district` VALUES ('289', '济源', '17', 'j', 'jy', 'jiyuan', '', '市', '419001', '0391', '18');
INSERT INTO `district` VALUES ('290', '武汉', '18', 'w', 'wh', 'wuhan', '', '市', '420100', '027', '1');
INSERT INTO `district` VALUES ('291', '黄石', '18', 'h', 'hs', 'huangshi', '', '市', '420200', '0714', '2');
INSERT INTO `district` VALUES ('292', '十堰', '18', 's', 'sy', 'shiyan', '', '市', '420300', '0719', '3');
INSERT INTO `district` VALUES ('293', '宜昌', '18', 'y', 'yc', 'yichang', '', '市', '420500', '0717', '4');
INSERT INTO `district` VALUES ('294', '襄阳', '18', 'x', 'xy', 'xiangyang', '', '市', '420600', '0710', '5');
INSERT INTO `district` VALUES ('295', '鄂州', '18', 'e', 'ez', 'ezhou', '', '市', '420700', '', '6');
INSERT INTO `district` VALUES ('296', '荆门', '18', 'j', 'jm', 'jingmen', '', '市', '420800', '0724', '7');
INSERT INTO `district` VALUES ('297', '孝感', '18', 'x', 'xg', 'xiaogan', '', '市', '420900', '0712', '8');
INSERT INTO `district` VALUES ('298', '荆州', '18', 'j', 'jz', 'jingzhou', '', '市', '421000', '0716', '9');
INSERT INTO `district` VALUES ('299', '黄冈', '18', 'h', 'hg', 'huanggang', '', '市', '421100', '0713', '10');
INSERT INTO `district` VALUES ('300', '咸宁', '18', 'x', 'xn', 'xianning', '', '市', '421200', '0715', '11');
INSERT INTO `district` VALUES ('301', '随州', '18', 's', 'sz', 'suizhou', '', '市', '421300', '0722', '12');
INSERT INTO `district` VALUES ('302', '恩施', '18', 'e', 'es', 'enshi', '土家族苗族', '自治州', '422800', '0718', '13');
INSERT INTO `district` VALUES ('303', '仙桃', '18', 'x', 'xt', 'xiantao', '', '市', '429004', '0728', '14');
INSERT INTO `district` VALUES ('304', '潜江', '18', 'q', 'qj', 'qianjiang', '', '市', '429005', '0728', '15');
INSERT INTO `district` VALUES ('305', '天门', '18', 't', 'tm', 'tianmen', '', '市', '429006', '0728', '16');
INSERT INTO `district` VALUES ('306', '神农架林区', '18', 's', 'snjlq', 'shennongjialinqu', '', '', '429021', '0719', '17');
INSERT INTO `district` VALUES ('307', '长沙', '19', 'z', 'zs', 'zhangsha', '', '市', '430100', '0731', '1');
INSERT INTO `district` VALUES ('308', '株洲', '19', 'z', 'zz', 'zhuzhou', '', '市', '430200', '0731', '2');
INSERT INTO `district` VALUES ('309', '湘潭', '19', 'x', 'xt', 'xiangtan', '', '市', '430300', '0731', '3');
INSERT INTO `district` VALUES ('310', '衡阳', '19', 'h', 'hy', 'hengyang', '', '市', '430400', '0734', '4');
INSERT INTO `district` VALUES ('311', '邵阳', '19', 's', 'sy', 'shaoyang', '', '市', '430500', '0739', '5');
INSERT INTO `district` VALUES ('312', '岳阳', '19', 'y', 'yy', 'yueyang', '', '市', '430600', '0730', '6');
INSERT INTO `district` VALUES ('313', '常德', '19', 'c', 'cd', 'changde', '', '市', '430700', '0736', '7');
INSERT INTO `district` VALUES ('314', '张家界', '19', 'z', 'zjj', 'zhangjiajie', '', '市', '430800', '0744', '8');
INSERT INTO `district` VALUES ('315', '益阳', '19', 'y', 'yy', 'yiyang', '', '市', '430900', '0737', '9');
INSERT INTO `district` VALUES ('316', '郴州', '19', 'c', 'cz', 'chenzhou', '', '市', '431000', '0735', '10');
INSERT INTO `district` VALUES ('317', '永州', '19', 'y', 'yz', 'yongzhou', '', '市', '431100', '0746', '11');
INSERT INTO `district` VALUES ('318', '怀化', '19', 'h', 'hh', 'huaihua', '', '市', '431200', '0745', '12');
INSERT INTO `district` VALUES ('319', '娄底', '19', 'l', 'ld', 'loudi', '', '市', '431300', '0738', '13');
INSERT INTO `district` VALUES ('320', '湘西', '19', 'x', 'xx', 'xiangxi', '土家族苗族', '自治州', '433100', '0743', '14');
INSERT INTO `district` VALUES ('321', '广州', '20', 'g', 'gz', 'guangzhou', '', '市', '440100', '020', '1');
INSERT INTO `district` VALUES ('322', '韶关', '20', 's', 'sg', 'shaoguan', '', '市', '440200', '0751', '2');
INSERT INTO `district` VALUES ('323', '深圳', '20', 's', 'sz', 'shenzhen', '', '市', '440300', '0755', '3');
INSERT INTO `district` VALUES ('324', '珠海', '20', 'z', 'zh', 'zhuhai', '', '市', '440400', '0756', '4');
INSERT INTO `district` VALUES ('325', '汕头', '20', 's', 'st', 'shantou', '', '市', '440500', '0754', '5');
INSERT INTO `district` VALUES ('326', '佛山', '20', 'f', 'fs', 'foshan', '', '市', '440600', '0757', '6');
INSERT INTO `district` VALUES ('327', '江门', '20', 'j', 'jm', 'jiangmen', '', '市', '440700', '0750', '7');
INSERT INTO `district` VALUES ('328', '湛江', '20', 'z', 'zj', 'zhanjiang', '', '市', '440800', '0759', '8');
INSERT INTO `district` VALUES ('329', '茂名', '20', 'm', 'mm', 'maoming', '', '市', '440900', '0668', '9');
INSERT INTO `district` VALUES ('330', '肇庆', '20', 'z', 'zq', 'zhaoqing', '', '市', '441200', '0758', '10');
INSERT INTO `district` VALUES ('331', '惠州', '20', 'h', 'hz', 'huizhou', '', '市', '441300', '0752', '11');
INSERT INTO `district` VALUES ('332', '梅州', '20', 'm', 'mz', 'meizhou', '', '市', '441400', '0753', '12');
INSERT INTO `district` VALUES ('333', '汕尾', '20', 's', 'sw', 'shanwei', '', '市', '441500', '0660', '13');
INSERT INTO `district` VALUES ('334', '河源', '20', 'h', 'hy', 'heyuan', '', '市', '441600', '0762', '14');
INSERT INTO `district` VALUES ('335', '阳江', '20', 'y', 'yj', 'yangjiang', '', '市', '441700', '0662', '15');
INSERT INTO `district` VALUES ('336', '清远', '20', 'q', 'qy', 'qingyuan', '', '市', '441800', '0763', '16');
INSERT INTO `district` VALUES ('337', '东莞', '20', 'd', 'dg', 'dongguan', '', '市', '441900', '0769', '17');
INSERT INTO `district` VALUES ('338', '中山', '20', 'z', 'zs', 'zhongshan', '', '市', '442000', '0760', '18');
INSERT INTO `district` VALUES ('339', '潮州', '20', 'c', 'cz', 'chaozhou', '', '市', '445100', '0768', '19');
INSERT INTO `district` VALUES ('340', '揭阳', '20', 'j', 'jy', 'jieyang', '', '市', '445200', '0663', '20');
INSERT INTO `district` VALUES ('341', '云浮', '20', 'y', 'yf', 'yunfu', '', '市', '445300', '0766', '21');
INSERT INTO `district` VALUES ('342', '南宁', '21', 'n', 'nn', 'nanning', '', '市', '450100', '0771', '1');
INSERT INTO `district` VALUES ('343', '柳州', '21', 'l', 'lz', 'liuzhou', '', '市', '450200', '0772', '2');
INSERT INTO `district` VALUES ('344', '桂林', '21', 'g', 'gl', 'guilin', '', '市', '450300', '0773', '3');
INSERT INTO `district` VALUES ('345', '梧州', '21', 'w', 'wz', 'wuzhou', '', '市', '450400', '0774', '4');
INSERT INTO `district` VALUES ('346', '北海', '21', 'b', 'bh', 'beihai', '', '市', '450500', '0779', '5');
INSERT INTO `district` VALUES ('347', '防城港', '21', 'f', 'fcg', 'fangchenggang', '', '市', '450600', '0770', '6');
INSERT INTO `district` VALUES ('348', '钦州', '21', 'q', 'qz', 'qinzhou', '', '市', '450700', '0777', '7');
INSERT INTO `district` VALUES ('349', '贵港', '21', 'g', 'gg', 'guigang', '', '市', '450800', '0775', '8');
INSERT INTO `district` VALUES ('350', '玉林', '21', 'y', 'yl', 'yulin', '', '市', '450900', '0775', '9');
INSERT INTO `district` VALUES ('351', '百色', '21', 'b', 'bs', 'baise', '', '市', '451000', '0776', '10');
INSERT INTO `district` VALUES ('352', '贺州', '21', 'h', 'hz', 'hezhou', '', '市', '451100', '0774', '11');
INSERT INTO `district` VALUES ('353', '河池', '21', 'h', 'hc', 'hechi', '', '市', '451200', '0778', '12');
INSERT INTO `district` VALUES ('354', '来宾', '21', 'l', 'lb', 'laibin', '', '市', '451300', '0772', '13');
INSERT INTO `district` VALUES ('355', '崇左', '21', 'c', 'cz', 'chongzuo', '', '市', '451400', '0771', '14');
INSERT INTO `district` VALUES ('356', '海口', '22', 'h', 'hk', 'haikou', '', '市', '460100', '0898', '1');
INSERT INTO `district` VALUES ('357', '三亚', '22', 's', 'sy', 'sanya', '', '市', '460200', '0898', '2');
INSERT INTO `district` VALUES ('358', '三沙', '22', 's', 'ss', 'sansha', '', '市', '460300', '0898', '3');
INSERT INTO `district` VALUES ('359', '五指山', '22', 'w', 'wzs', 'wuzhishan', '', '市', '469001', '0898', '4');
INSERT INTO `district` VALUES ('360', '琼海', '22', 'q', 'qh', 'qionghai', '', '市', '469002', '0898', '5');
INSERT INTO `district` VALUES ('361', '儋州', '22', 'd', 'dz', 'danzhou', '', '市', '460400', '0898', '6');
INSERT INTO `district` VALUES ('362', '文昌', '22', 'w', 'wc', 'wenchang', '', '市', '469005', '0898', '7');
INSERT INTO `district` VALUES ('363', '万宁', '22', 'w', 'wn', 'wanning', '', '市', '469006', '0898', '8');
INSERT INTO `district` VALUES ('364', '东方', '22', 'd', 'df', 'dongfang', '', '市', '469007', '0898', '9');
INSERT INTO `district` VALUES ('365', '定安', '22', 'd', 'da', 'dingan', '', '县', '469025', '0898', '10');
INSERT INTO `district` VALUES ('366', '屯昌', '22', 't', 'tc', 'tunchang', '', '县', '469026', '0898', '11');
INSERT INTO `district` VALUES ('367', '澄迈', '22', 'c', 'cm', 'chengmai', '', '县', '469027', '0898', '12');
INSERT INTO `district` VALUES ('368', '临高', '22', 'l', 'lg', 'lingao', '', '县', '469028', '0898', '13');
INSERT INTO `district` VALUES ('369', '白沙', '22', 'b', 'bs', 'baisha', '黎族', '自治县', '469030', '0898', '14');
INSERT INTO `district` VALUES ('370', '昌江', '22', 'c', 'cj', 'changjiang', '黎族', '自治县', '469031', '0898', '15');
INSERT INTO `district` VALUES ('371', '乐东', '22', 'l', 'ld', 'ledong', '黎族', '自治县', '469033', '0898', '16');
INSERT INTO `district` VALUES ('372', '陵水', '22', 'l', 'ls', 'lingshui', '黎族', '自治县', '469034', '0898', '17');
INSERT INTO `district` VALUES ('373', '保亭', '22', 'b', 'bt', 'baoting', '黎族苗族', '自治县', '469035', '0898', '18');
INSERT INTO `district` VALUES ('374', '琼中', '22', 'q', 'qz', 'qiongzhong', '黎族苗族', '自治县', '469036', '0898', '19');
INSERT INTO `district` VALUES ('375', '成都', '23', 'c', 'cd', 'chengdou', '', '市', '510100', '028', '1');
INSERT INTO `district` VALUES ('376', '自贡', '23', 'z', 'zg', 'zigong', '', '市', '510300', '0813', '2');
INSERT INTO `district` VALUES ('377', '攀枝花', '23', 'p', 'pzh', 'panzhihua', '', '市', '510400', '0812', '3');
INSERT INTO `district` VALUES ('378', '泸州', '23', 'l', 'lz', 'luzhou', '', '市', '510500', '0830', '4');
INSERT INTO `district` VALUES ('379', '德阳', '23', 'd', 'dy', 'deyang', '', '市', '510600', '0838', '5');
INSERT INTO `district` VALUES ('380', '绵阳', '23', 'm', 'my', 'mianyang', '', '市', '510700', '0816', '6');
INSERT INTO `district` VALUES ('381', '广元', '23', 'g', 'gy', 'guangyuan', '', '市', '510800', '0839', '7');
INSERT INTO `district` VALUES ('382', '遂宁', '23', 's', 'sn', 'suining', '', '市', '510900', '0825', '8');
INSERT INTO `district` VALUES ('383', '内江', '23', 'n', 'nj', 'neijiang', '', '市', '511000', '', '9');
INSERT INTO `district` VALUES ('384', '乐山', '23', 'l', 'ls', 'leshan', '', '市', '511100', '0833', '10');
INSERT INTO `district` VALUES ('385', '南充', '23', 'n', 'nc', 'nanchong', '', '市', '511300', '0817', '11');
INSERT INTO `district` VALUES ('386', '眉山', '23', 'm', 'ms', 'meishan', '', '市', '511400', '028', '12');
INSERT INTO `district` VALUES ('387', '宜宾', '23', 'y', 'yb', 'yibin', '', '市', '511500', '0831', '13');
INSERT INTO `district` VALUES ('388', '广安', '23', 'g', 'ga', 'guangan', '', '市', '511600', '0826', '14');
INSERT INTO `district` VALUES ('389', '达州', '23', 'd', 'dz', 'dazhou', '', '市', '511700', '0818', '15');
INSERT INTO `district` VALUES ('390', '雅安', '23', 'y', 'ya', 'yaan', '', '市', '511800', '0835', '16');
INSERT INTO `district` VALUES ('391', '巴中', '23', 'b', 'bz', 'bazhong', '', '市', '511900', '0827', '17');
INSERT INTO `district` VALUES ('392', '资阳', '23', 'z', 'zy', 'ziyang', '', '市', '512000', '028', '18');
INSERT INTO `district` VALUES ('393', '阿坝', '23', 'a', 'ab', 'aba', '藏族羌族', '自治州', '513200', '0837', '19');
INSERT INTO `district` VALUES ('394', '甘孜', '23', 'g', 'gz', 'ganzi', '藏族', '自治州', '513300', '0836', '20');
INSERT INTO `district` VALUES ('395', '凉山', '23', 'l', 'ls', 'liangshan', '彝族', '自治州', '615000', '0834', '21');
INSERT INTO `district` VALUES ('396', '贵阳', '24', 'g', 'gy', 'guiyang', '', '市', '520100', '0851', '1');
INSERT INTO `district` VALUES ('397', '六盘水', '24', 'l', 'lps', 'liupanshui', '', '市', '520200', '0858', '2');
INSERT INTO `district` VALUES ('398', '遵义', '24', 'z', 'zy', 'zunyi', '', '市', '520300', '0852', '3');
INSERT INTO `district` VALUES ('399', '安顺', '24', 'a', 'as', 'anshun', '', '市', '520400', '0853', '4');
INSERT INTO `district` VALUES ('400', '毕节', '24', 'b', 'bj', 'bijie', '', '市', '520500', '0857', '5');
INSERT INTO `district` VALUES ('401', '铜仁', '24', 't', 'tr', 'tongren', '', '市', '520600', '0856', '6');
INSERT INTO `district` VALUES ('402', '黔西南', '24', 'q', 'qxn', 'qianxinan', '布依族苗族', '自治州', '522300', '0859', '7');
INSERT INTO `district` VALUES ('403', '黔东南', '24', 'q', 'qdn', 'qiandongnan', '苗族侗族', '自治州', '522600', '0855', '8');
INSERT INTO `district` VALUES ('404', '黔南', '24', 'q', 'qn', 'qiannan', '布依族苗族', '自治州', '522700', '0854', '9');
INSERT INTO `district` VALUES ('405', '昆明', '25', 'k', 'km', 'kunming', '', '市', '530100', '0871', '1');
INSERT INTO `district` VALUES ('406', '曲靖', '25', 'q', 'qj', 'qujing', '', '市', '530300', '0874', '2');
INSERT INTO `district` VALUES ('407', '玉溪', '25', 'y', 'yx', 'yuxi', '', '市', '530400', '0877', '3');
INSERT INTO `district` VALUES ('408', '昭通', '25', 'z', 'zt', 'zhaotong', '', '市', '530600', '0870', '4');
INSERT INTO `district` VALUES ('409', '丽江', '25', 'l', 'lj', 'lijiang', '', '市', '530700', '0888', '5');
INSERT INTO `district` VALUES ('410', '普洱', '25', 'p', 'pe', 'puer', '', '市', '530800', '0879', '6');
INSERT INTO `district` VALUES ('411', '临沧', '25', 'l', 'lc', 'lincang', '', '市', '530900', '0883', '7');
INSERT INTO `district` VALUES ('412', '楚雄', '25', 'c', 'cx', 'chuxiong', '彝族', '自治州', '532300', '0878', '8');
INSERT INTO `district` VALUES ('413', '红河', '25', 'h', 'hh', 'honghe', '哈尼族彝族', '自治州', '532500', '0873', '9');
INSERT INTO `district` VALUES ('414', '文山', '25', 'w', 'ws', 'wenshan', '壮族苗族', '自治州', '532600', '0876', '10');
INSERT INTO `district` VALUES ('415', '西双版纳', '25', 'x', 'xsbn', 'xishuangbanna', '傣族', '自治州', '532800', '0691', '11');
INSERT INTO `district` VALUES ('416', '大理', '25', 'd', 'dl', 'dali', '白族', '自治州', '532900', '0872', '12');
INSERT INTO `district` VALUES ('417', '德宏', '25', 'd', 'dh', 'dehong', '傣族景颇族', '自治州', '533100', '0692', '13');
INSERT INTO `district` VALUES ('418', '怒江', '25', 'n', 'nj', 'nujiang', '傈僳族', '自治州', '533300', '0886', '14');
INSERT INTO `district` VALUES ('419', '迪庆', '25', 'd', 'dq', 'diqing', '藏族', '自治州', '533400', '0887', '15');
INSERT INTO `district` VALUES ('420', '保山', '25', 'b', 'bs', 'baoshan', '', '市', '678000', '0875', '16');
INSERT INTO `district` VALUES ('421', '拉萨', '26', 'l', 'ls', 'lasa', '', '市', '540100', '0891', '1');
INSERT INTO `district` VALUES ('422', '昌都', '26', 'c', 'cd', 'changdou', '', '市', '542100', '0895', '2');
INSERT INTO `district` VALUES ('423', '山南', '26', 's', 'sn', 'shannan', '', '市', '542200', '0893', '3');
INSERT INTO `district` VALUES ('424', '日喀则', '26', 'r', 'rkz', 'rikaze', '', '市', '542300', '0892', '4');
INSERT INTO `district` VALUES ('425', '那曲', '26', 'n', 'nq', 'neiqu', '', '地区', '542400', '0896', '5');
INSERT INTO `district` VALUES ('426', '阿里', '26', 'a', 'al', 'ali', '', '地区', '542500', '0897', '6');
INSERT INTO `district` VALUES ('427', '林芝', '26', 'l', 'lz', 'linzhi', '', '市', '540400', '0894', '7');
INSERT INTO `district` VALUES ('428', '西安', '27', 'x', 'xa', 'xian', '', '市', '610100', '029', '1');
INSERT INTO `district` VALUES ('429', '铜川', '27', 't', 'tc', 'tongchuan', '', '市', '610200', '0919', '2');
INSERT INTO `district` VALUES ('430', '宝鸡', '27', 'b', 'bj', 'baoji', '', '市', '610300', '0917', '3');
INSERT INTO `district` VALUES ('431', '咸阳', '27', 'x', 'xy', 'xianyang', '', '市', '610400', '029', '4');
INSERT INTO `district` VALUES ('432', '渭南', '27', 'w', 'wn', 'weinan', '', '市', '610500', '0913', '5');
INSERT INTO `district` VALUES ('433', '延安', '27', 'y', 'ya', 'yanan', '', '市', '610600', '0911', '6');
INSERT INTO `district` VALUES ('434', '汉中', '27', 'h', 'hz', 'hanzhong', '', '市', '610700', '0916', '7');
INSERT INTO `district` VALUES ('435', '榆林', '27', 'y', 'yl', 'yulin', '', '市', '610800', '0912', '8');
INSERT INTO `district` VALUES ('436', '安康', '27', 'a', 'ak', 'ankang', '', '市', '610900', '0915', '9');
INSERT INTO `district` VALUES ('437', '商洛', '27', 's', 'sl', 'shangluo', '', '市', '611000', '0914', '10');
INSERT INTO `district` VALUES ('438', '兰州', '28', 'l', 'lz', 'lanzhou', '', '市', '620100', '0931', '1');
INSERT INTO `district` VALUES ('439', '嘉峪关', '28', 'j', 'jyg', 'jiayuguan', '', '市', '620200', '0937', '2');
INSERT INTO `district` VALUES ('440', '金昌', '28', 'j', 'jc', 'jinchang', '', '市', '620300', '0935', '3');
INSERT INTO `district` VALUES ('441', '白银', '28', 'b', 'by', 'baiyin', '', '市', '620400', '0943', '4');
INSERT INTO `district` VALUES ('442', '天水', '28', 't', 'ts', 'tianshui', '', '市', '620500', '0938', '5');
INSERT INTO `district` VALUES ('443', '武威', '28', 'w', 'ww', 'wuwei', '', '市', '620600', '0935', '6');
INSERT INTO `district` VALUES ('444', '张掖', '28', 'z', 'zy', 'zhangye', '', '市', '620700', '0936', '7');
INSERT INTO `district` VALUES ('445', '平凉', '28', 'p', 'pl', 'pingliang', '', '市', '620800', '0933', '8');
INSERT INTO `district` VALUES ('446', '酒泉', '28', 'j', 'jq', 'jiuquan', '', '市', '620900', '0937', '9');
INSERT INTO `district` VALUES ('447', '庆阳', '28', 'q', 'qy', 'qingyang', '', '市', '621000', '0934', '10');
INSERT INTO `district` VALUES ('448', '定西', '28', 'd', 'dx', 'dingxi', '', '市', '621100', '0932', '11');
INSERT INTO `district` VALUES ('449', '陇南', '28', 'l', 'ln', 'longnan', '', '市', '621200', '0939', '12');
INSERT INTO `district` VALUES ('450', '临夏', '28', 'l', 'lx', 'linxia', '回族', '自治州', '622900', '0930', '13');
INSERT INTO `district` VALUES ('451', '甘南', '28', 'g', 'gn', 'gannan', '藏族', '自治州', '623000', '0941', '14');
INSERT INTO `district` VALUES ('452', '西宁', '29', 'x', 'xn', 'xining', '', '市', '630100', '0971', '1');
INSERT INTO `district` VALUES ('453', '海东', '29', 'h', 'hd', 'haidong', '', '市', '632100', '0972', '2');
INSERT INTO `district` VALUES ('454', '海北', '29', 'h', 'hb', 'haibei', '藏族', '自治州', '632200', '0970', '3');
INSERT INTO `district` VALUES ('455', '黄南', '29', 'h', 'hn', 'huangnan', '藏族', '自治州', '632300', '0973', '4');
INSERT INTO `district` VALUES ('456', '海南', '29', 'h', 'hn', 'hainan', '藏族', '自治州', '632500', '0974', '5');
INSERT INTO `district` VALUES ('457', '果洛', '29', 'g', 'gl', 'guoluo', '藏族', '自治州', '632600', '0975', '6');
INSERT INTO `district` VALUES ('458', '玉树', '29', 'y', 'ys', 'yushu', '藏族', '自治州', '632700', '0976', '7');
INSERT INTO `district` VALUES ('459', '海西', '29', 'h', 'hx', 'haixi', '蒙古族藏族', '自治州', '632800', '0977', '8');
INSERT INTO `district` VALUES ('460', '银川', '30', 'y', 'yc', 'yinchuan', '', '市', '640100', '0951', '1');
INSERT INTO `district` VALUES ('461', '石嘴山', '30', 's', 'szs', 'shizuishan', '', '市', '640200', '0952', '2');
INSERT INTO `district` VALUES ('462', '吴忠', '30', 'w', 'wz', 'wuzhong', '', '市', '640300', '0953', '3');
INSERT INTO `district` VALUES ('463', '固原', '30', 'g', 'gy', 'guyuan', '', '市', '640400', '0954', '4');
INSERT INTO `district` VALUES ('464', '中卫', '30', 'z', 'zw', 'zhongwei', '', '市', '640500', '', '5');
INSERT INTO `district` VALUES ('465', '乌鲁木齐', '31', 'w', 'wlmq', 'wulumuqi', '', '市', '650100', '0991', '1');
INSERT INTO `district` VALUES ('466', '克拉玛依', '31', 'k', 'klmy', 'kelamayi', '', '市', '650200', '0990', '2');
INSERT INTO `district` VALUES ('467', '吐鲁番', '31', 't', 'tlf', 'tulufan', '', '市', '652100', '0995', '3');
INSERT INTO `district` VALUES ('468', '哈密', '31', 'h', 'hm', 'hami', '', '市', '652200', '0902', '4');
INSERT INTO `district` VALUES ('469', '昌吉', '31', 'c', 'cj', 'changji', '', '自治州', '652300', '0994', '5');
INSERT INTO `district` VALUES ('470', '博尔塔拉', '31', 'b', 'betl', 'boertala', '蒙古', '自治州', '652700', '0909', '6');
INSERT INTO `district` VALUES ('471', '巴音郭楞', '31', 'b', 'bygl', 'bayinguoleng', '蒙古', '自治州', '652800', '0996', '7');
INSERT INTO `district` VALUES ('472', '阿克苏', '31', 'a', 'aks', 'akesu', '柯尔克孜', '地区', '652900', '0997', '8');
INSERT INTO `district` VALUES ('473', '克孜勒苏', '31', 'k', 'kzls', 'kezilesu', '', '自治州', '653000', '0908', '9');
INSERT INTO `district` VALUES ('474', '喀什', '31', 'k', 'ks', 'kashi', '', '地区', '653100', '0998', '10');
INSERT INTO `district` VALUES ('475', '和田', '31', 'h', 'ht', 'hetian', '哈萨克', '地区', '653200', '0903', '11');
INSERT INTO `district` VALUES ('476', '伊犁', '31', 'y', 'yl', 'yili', '', '自治州', '654000', '0999', '12');
INSERT INTO `district` VALUES ('477', '塔城', '31', 't', 'tc', 'tacheng', '', '地区', '654200', '0901', '13');
INSERT INTO `district` VALUES ('478', '阿勒泰', '31', 'a', 'alt', 'aletai', '', '地区', '654300', '0906', '14');
INSERT INTO `district` VALUES ('479', '石河子', '31', 's', 'shz', 'shihezi', '', '市', '659001', '0993', '15');
INSERT INTO `district` VALUES ('480', '阿拉尔', '31', 'a', 'ale', 'alaer', '', '市', '659002', '0997', '16');
INSERT INTO `district` VALUES ('481', '图木舒克', '31', 't', 'tmsk', 'tumushuke', '', '市', '659003', '0998', '17');
INSERT INTO `district` VALUES ('482', '五家渠', '31', 'w', 'wjq', 'wujiaqu', '', '市', '659004', '0994', '18');
INSERT INTO `district` VALUES ('483', '北屯', '31', 'b', 'bt', 'beitun', '', '市', '659005', '0906', '19');
INSERT INTO `district` VALUES ('484', '铁门关', '31', 't', 'tmg', 'tiemenguan', '', '市', '659006', '0996', '20');
INSERT INTO `district` VALUES ('485', '台北', '32', 't', 'tb', 'taibei', '', '市', '63', '02', '1');
INSERT INTO `district` VALUES ('486', '高雄', '32', 'g', 'gx', 'gaoxiong', '', '市', '64', '07', '2');
INSERT INTO `district` VALUES ('487', '基隆', '32', 'j', 'jl', 'jilong', '', '市', '10017', '02', '3');
INSERT INTO `district` VALUES ('488', '台中', '32', 't', 'tz', 'taizhong', '', '市', '10019', '04', '4');
INSERT INTO `district` VALUES ('489', '台南', '32', 't', 'tn', 'tainan', '', '市', '10021', '06', '5');
INSERT INTO `district` VALUES ('490', '新竹', '32', 'x', 'xz', 'xinzhu', '', '市', '10018', '', '6');
INSERT INTO `district` VALUES ('491', '嘉义', '32', 'j', 'jy', 'jiayi', '', '市', '10020', '05', '7');
INSERT INTO `district` VALUES ('492', '新北', '32', 'x', 'xb', 'xinbei', '', '市', '', '', '8');
INSERT INTO `district` VALUES ('493', '宜兰', '32', 'y', 'yl', 'yilan', '', '县', '10002', '', '9');
INSERT INTO `district` VALUES ('494', '桃园', '32', 't', 'ty', 'taoyuan', '', '县', '10003', '', '10');
INSERT INTO `district` VALUES ('495', '新竹', '32', 'x', 'xz', 'xinzhu', '', '县', '10004', '', '11');
INSERT INTO `district` VALUES ('496', '苗栗', '32', 'm', 'ml', 'miaoli', '', '县', '10005', '', '12');
INSERT INTO `district` VALUES ('497', '彰化', '32', 'z', 'zh', 'zhanghua', '', '县', '10007', '', '13');
INSERT INTO `district` VALUES ('498', '南投', '32', 'n', 'nt', 'nantou', '', '县', '10008', '', '14');
INSERT INTO `district` VALUES ('499', '云林', '32', 'y', 'yl', 'yunlin', '', '县', '10009', '', '15');
INSERT INTO `district` VALUES ('500', '嘉义', '32', 'j', 'jy', 'jiayi', '', '县', '10020', '', '16');
INSERT INTO `district` VALUES ('501', '屏东', '32', 'p', 'pd', 'pingdong', '', '县', '10013', '', '17');
INSERT INTO `district` VALUES ('502', '台东', '32', 't', 'td', 'taidong', '', '县', '10014', '', '18');
INSERT INTO `district` VALUES ('503', '花莲', '32', 'h', 'hl', 'hualian', '', '县', '10015', '', '19');
INSERT INTO `district` VALUES ('504', '澎湖', '32', 'p', 'ph', 'penghu', '', '县', '10016', '07', '20');
INSERT INTO `district` VALUES ('505', '连江', '32', 'l', 'lj', 'lianjiang', '', '县', '', '', '21');
INSERT INTO `district` VALUES ('506', '金门', '32', 'j', 'jm', 'jinmen', '', '县', '', '', '22');
INSERT INTO `district` VALUES ('507', '中西', '33', 'z', 'zx', 'zhongxi', '', '区', '', '852', '1');
INSERT INTO `district` VALUES ('508', '葵青', '33', 'k', 'kq', 'kuiqing', '', '区', '', '852', '2');
INSERT INTO `district` VALUES ('509', '元朗', '33', 'y', 'yl', 'yuanlang', '', '区', '', '852', '3');
INSERT INTO `district` VALUES ('510', '屯门', '33', 't', 'tm', 'tunmen', '', '区', '', '852', '4');
INSERT INTO `district` VALUES ('511', '荃湾', '33', 'q', 'qw', 'quanwan', '', '区', '', '852', '5');
INSERT INTO `district` VALUES ('512', '西贡', '33', 'x', 'xg', 'xigong', '', '区', '', '852', '6');
INSERT INTO `district` VALUES ('513', '沙田', '33', 's', 'st', 'shatian', '', '区', '', '852', '7');
INSERT INTO `district` VALUES ('514', '大埔', '33', 'd', 'dp', 'dapu', '', '区', '', '852', '8');
INSERT INTO `district` VALUES ('515', '北区', '33', 'b', 'bq', 'beiqu', '', '', '', '852', '9');
INSERT INTO `district` VALUES ('516', '观塘', '33', 'g', 'gt', 'guantang', '', '区', '', '852', '10');
INSERT INTO `district` VALUES ('517', '黄大仙', '33', 'h', 'hdx', 'huangdaxian', '', '区', '', '852', '11');
INSERT INTO `district` VALUES ('518', '深水埗', '33', 's', 'ssb', 'shenshuibu', '', '区', '', '852', '12');
INSERT INTO `district` VALUES ('519', '油尖旺', '33', 'y', 'yjw', 'youjianwang', '', '区', '', '852', '13');
INSERT INTO `district` VALUES ('520', '九龙城', '33', 'j', 'jlc', 'jiulongcheng', '', '区', '', '852', '14');
INSERT INTO `district` VALUES ('521', '南区', '33', 'n', 'nq', 'nanqu', '', '', '', '852', '15');
INSERT INTO `district` VALUES ('522', '东区', '33', 'd', 'dq', 'dongqu', '', '', '', '852', '16');
INSERT INTO `district` VALUES ('523', '湾仔', '33', 'w', 'wz', 'wanzi', '', '区', '', '852', '17');
INSERT INTO `district` VALUES ('524', '离岛', '33', 'l', 'ld', 'lidao', '', '区', '', '852', '18');
INSERT INTO `district` VALUES ('525', '花地玛', '34', 'h', 'hdm', 'huadima', '', '堂区', '', '853', '1');
INSERT INTO `district` VALUES ('526', '圣安多', '34', 's', 'sad', 'shenganduo', '', '堂区', '', '853', '2');
INSERT INTO `district` VALUES ('527', '大堂区', '34', 'd', 'dtq', 'datangqu', '', '堂区', '', '853', '3');
INSERT INTO `district` VALUES ('528', '望德', '34', 'w', 'wd', 'wangde', '', '堂区', '', '853', '4');
INSERT INTO `district` VALUES ('529', '风顺', '34', 'f', 'fs', 'fengshun', '', '堂区', '', '853', '5');
INSERT INTO `district` VALUES ('530', '嘉模', '34', 'j', 'jm', 'jiamo', '', '堂区', '', '853', '6');
INSERT INTO `district` VALUES ('531', '圣方济各', '34', 's', 'sfjg', 'shengfangjige', '', '堂区', '', '853', '7');
INSERT INTO `district` VALUES ('532', '路氹城', '34', 'l', 'ldc', 'ludangcheng', '', '', '', '853', '8');
INSERT INTO `district` VALUES ('533', '长安', '125', 'z', 'za', 'zhangan', '', '区', '130102', '0311', '1');
INSERT INTO `district` VALUES ('535', '桥西', '125', 'q', 'qx', 'qiaoxi', '', '区', '130104', '0311', '2');
INSERT INTO `district` VALUES ('536', '新华', '125', 'x', 'xh', 'xinhua', '', '区', '130105', '0311', '3');
INSERT INTO `district` VALUES ('537', '井陉矿', '125', 'j', 'jxk', 'jingxingkuang', '', '区', '130107', '0311', '4');
INSERT INTO `district` VALUES ('538', '裕华', '125', 'y', 'yh', 'yuhua', '', '区', '130108', '0311', '5');
INSERT INTO `district` VALUES ('539', '井陉', '125', 'j', 'jx', 'jingxing', '', '县', '130121', '0311', '9');
INSERT INTO `district` VALUES ('540', '正定', '125', 'z', 'zd', 'zhengding', '', '县', '130123', '0311', '10');
INSERT INTO `district` VALUES ('541', '栾城', '125', 'l', 'lc', 'luancheng', '', '区', '130111', '0311', '8');
INSERT INTO `district` VALUES ('542', '行唐', '125', 'x', 'xt', 'xingtang', '', '县', '130125', '0311', '11');
INSERT INTO `district` VALUES ('543', '灵寿', '125', 'l', 'ls', 'lingshou', '', '县', '130126', '0311', '12');
INSERT INTO `district` VALUES ('544', '高邑', '125', 'g', 'gy', 'gaoyi', '', '县', '130127', '0311', '13');
INSERT INTO `district` VALUES ('545', '深泽', '125', 's', 'sz', 'shenze', '', '县', '130128', '0311', '14');
INSERT INTO `district` VALUES ('546', '赞皇', '125', 'z', 'zh', 'zanhuang', '', '县', '130129', '0311', '15');
INSERT INTO `district` VALUES ('547', '无极', '125', 'w', 'wj', 'wuji', '', '县', '130130', '0311', '16');
INSERT INTO `district` VALUES ('548', '平山', '125', 'p', 'ps', 'pingshan', '', '县', '130131', '0311', '17');
INSERT INTO `district` VALUES ('549', '元氏', '125', 'y', 'ys', 'yuanshi', '', '县', '130132', '0311', '18');
INSERT INTO `district` VALUES ('550', '赵县', '125', 'z', 'zx', 'zhaoxian', '', '', '130133', '0311', '19');
INSERT INTO `district` VALUES ('551', '辛集', '125', 'x', 'xj', 'xinji', '', '市', '130181', '0311', '20');
INSERT INTO `district` VALUES ('552', '藁城', '125', 'g', 'gc', 'gaocheng', '', '区', '130109', '0311', '6');
INSERT INTO `district` VALUES ('553', '晋州', '125', 'j', 'jz', 'jinzhou', '', '市', '130183', '0311', '21');
INSERT INTO `district` VALUES ('554', '新乐', '125', 'x', 'xl', 'xinle', '', '市', '130184', '0311', '22');
INSERT INTO `district` VALUES ('555', '鹿泉', '125', 'l', 'lq', 'luquan', '', '区', '130110', '0311', '7');
INSERT INTO `district` VALUES ('556', '路南', '126', 'l', 'ln', 'lunan', '', '区', '130202', '0315', '1');
INSERT INTO `district` VALUES ('557', '路北', '126', 'l', 'lb', 'lubei', '', '区', '130203', '0315', '2');
INSERT INTO `district` VALUES ('558', '古冶', '126', 'g', 'gy', 'guye', '', '区', '130204', '0315', '3');
INSERT INTO `district` VALUES ('559', '开平', '126', 'k', 'kp', 'kaiping', '', '区', '130205', '0315', '4');
INSERT INTO `district` VALUES ('560', '丰南', '126', 'f', 'fn', 'fengnan', '', '区', '130207', '0315', '5');
INSERT INTO `district` VALUES ('561', '丰润', '126', 'f', 'fr', 'fengrun', '', '区', '130208', '0315', '6');
INSERT INTO `district` VALUES ('562', '滦县', '126', 'l', 'lx', 'luanxian', '', '', '130223', '0315', '7');
INSERT INTO `district` VALUES ('563', '滦南', '126', 'l', 'ln', 'luannan', '', '县', '130224', '0315', '8');
INSERT INTO `district` VALUES ('564', '乐亭', '126', 'l', 'lt', 'leting', '', '县', '130225', '0315', '9');
INSERT INTO `district` VALUES ('565', '迁西', '126', 'q', 'qx', 'qianxi', '', '县', '130227', '0315', '10');
INSERT INTO `district` VALUES ('566', '玉田', '126', 'y', 'yt', 'yutian', '', '县', '130229', '0315', '11');
INSERT INTO `district` VALUES ('567', '唐海', '126', 't', 'th', 'tanghai', '', '县', '130230', '0315', '12');
INSERT INTO `district` VALUES ('568', '遵化', '126', 'z', 'zh', 'zunhua', '', '市', '130281', '0315', '13');
INSERT INTO `district` VALUES ('569', '迁安', '126', 'q', 'qa', 'qianan', '', '市', '130283', '0315', '14');
INSERT INTO `district` VALUES ('570', '海港', '127', 'h', 'hg', 'haigang', '', '区', '130302', '0335', '1');
INSERT INTO `district` VALUES ('571', '山海关', '127', 's', 'shg', 'shanhaiguan', '', '区', '130303', '0335', '2');
INSERT INTO `district` VALUES ('572', '北戴河', '127', 'b', 'bdh', 'beidaihe', '', '区', '130304', '0335', '3');
INSERT INTO `district` VALUES ('573', '青龙', '127', 'q', 'ql', 'qinglong', '满族', '自治县', '130321', '0335', '4');
INSERT INTO `district` VALUES ('574', '昌黎', '127', 'c', 'cl', 'changli', '', '县', '130322', '0335', '5');
INSERT INTO `district` VALUES ('575', '抚宁', '127', 'f', 'fn', 'funing', '', '区', '130323', '0335', '6');
INSERT INTO `district` VALUES ('576', '卢龙', '127', 'l', 'll', 'lulong', '', '县', '130324', '0335', '7');
INSERT INTO `district` VALUES ('577', '邯山', '128', 'h', 'hs', 'hanshan', '', '区', '130402', '0310', '1');
INSERT INTO `district` VALUES ('578', '丛台', '128', 'c', 'ct', 'congtai', '', '区', '130403', '0310', '2');
INSERT INTO `district` VALUES ('579', '复兴', '128', 'f', 'fx', 'fuxing', '', '区', '130404', '0310', '3');
INSERT INTO `district` VALUES ('580', '峰峰矿', '128', 'f', 'ffk', 'fengfengkuang', '', '区', '130406', '0310', '4');
INSERT INTO `district` VALUES ('582', '临漳', '128', 'l', 'lz', 'linzhang', '', '县', '130423', '0310', '6');
INSERT INTO `district` VALUES ('583', '成安', '128', 'c', 'ca', 'chengan', '', '县', '130424', '0310', '7');
INSERT INTO `district` VALUES ('584', '大名', '128', 'd', 'dm', 'daming', '', '县', '130425', '0310', '8');
INSERT INTO `district` VALUES ('585', '涉县', '128', 's', 'sx', 'shexian', '', '', '130426', '0310', '9');
INSERT INTO `district` VALUES ('586', '磁县', '128', 'c', 'cx', 'cixian', '', '', '130427', '0310', '10');
INSERT INTO `district` VALUES ('587', '肥乡', '128', 'f', 'fx', 'feixiang', '', '区', '130428', '0310', '11');
INSERT INTO `district` VALUES ('588', '永年', '128', 'y', 'yn', 'yongnian', '', '区', '130429', '0310', '12');
INSERT INTO `district` VALUES ('589', '邱县', '128', 'q', 'qx', 'qiuxian', '', '', '130430', '0310', '13');
INSERT INTO `district` VALUES ('590', '鸡泽', '128', 'j', 'jz', 'jize', '', '县', '130431', '0310', '14');
INSERT INTO `district` VALUES ('591', '广平', '128', 'g', 'gp', 'guangping', '', '县', '130432', '0310', '15');
INSERT INTO `district` VALUES ('592', '馆陶', '128', 'g', 'gt', 'guantao', '', '县', '130433', '0310', '16');
INSERT INTO `district` VALUES ('593', '魏县', '128', 'w', 'wx', 'weixian', '', '', '130434', '0310', '17');
INSERT INTO `district` VALUES ('594', '曲周', '128', 'q', 'qz', 'quzhou', '', '县', '130435', '0310', '18');
INSERT INTO `district` VALUES ('595', '武安', '128', 'w', 'wa', 'wuan', '', '市', '130481', '0310', '19');
INSERT INTO `district` VALUES ('596', '桥东', '129', 'q', 'qd', 'qiaodong', '', '区', '130502', '0319', '1');
INSERT INTO `district` VALUES ('597', '桥西', '129', 'q', 'qx', 'qiaoxi', '', '区', '130503', '0319', '2');
INSERT INTO `district` VALUES ('598', '邢台', '129', 'x', 'xt', 'xingtai', '', '县', '130521', '0319', '3');
INSERT INTO `district` VALUES ('599', '临城', '129', 'l', 'lc', 'lincheng', '', '县', '130522', '0319', '4');
INSERT INTO `district` VALUES ('600', '内丘', '129', 'n', 'nq', 'neiqiu', '', '县', '130523', '0319', '5');
INSERT INTO `district` VALUES ('601', '柏乡', '129', 'b', 'bx', 'boxiang', '', '县', '130524', '0319', '6');
INSERT INTO `district` VALUES ('602', '隆尧', '129', 'l', 'ly', 'longyao', '', '县', '130525', '0319', '7');
INSERT INTO `district` VALUES ('603', '任县', '129', 'r', 'rx', 'renxian', '', '', '130526', '0319', '8');
INSERT INTO `district` VALUES ('604', '南和', '129', 'n', 'nh', 'nanhe', '', '县', '130527', '0319', '9');
INSERT INTO `district` VALUES ('605', '宁晋', '129', 'n', 'nj', 'ningjin', '', '县', '130528', '0319', '10');
INSERT INTO `district` VALUES ('606', '巨鹿', '129', 'j', 'jl', 'julu', '', '县', '130529', '0319', '11');
INSERT INTO `district` VALUES ('607', '新河', '129', 'x', 'xh', 'xinhe', '', '县', '130530', '0319', '12');
INSERT INTO `district` VALUES ('608', '广宗', '129', 'g', 'gz', 'guangzong', '', '县', '130531', '0319', '13');
INSERT INTO `district` VALUES ('609', '平乡', '129', 'p', 'px', 'pingxiang', '', '县', '130532', '0319', '14');
INSERT INTO `district` VALUES ('610', '威县', '129', 'w', 'wx', 'weixian', '', '', '130533', '0319', '15');
INSERT INTO `district` VALUES ('611', '清河', '129', 'q', 'qh', 'qinghe', '', '县', '130534', '0319', '16');
INSERT INTO `district` VALUES ('612', '临西', '129', 'l', 'lx', 'linxi', '', '县', '130535', '0319', '17');
INSERT INTO `district` VALUES ('613', '南宫', '129', 'n', 'ng', 'nangong', '', '市', '130581', '0319', '18');
INSERT INTO `district` VALUES ('614', '沙河', '129', 's', 'sh', 'shahe', '', '市', '130582', '0319', '19');
INSERT INTO `district` VALUES ('615', '竞秀', '130', 'j', 'jx', 'jingxiu', '', '区', '130602', '0312', '1');
INSERT INTO `district` VALUES ('616', '莲池', '130', 'l', 'lc', 'lianchi', '', '区', '130603', '0312', '2');
INSERT INTO `district` VALUES ('618', '满城', '130', 'm', 'mc', 'mancheng', '', '区', '130621', '0312', '4');
INSERT INTO `district` VALUES ('619', '清苑', '130', 'q', 'qy', 'qingyuan', '', '区', '130622', '0312', '5');
INSERT INTO `district` VALUES ('620', '涞水', '130', 'l', 'ls', 'laishui', '', '县', '130623', '0312', '6');
INSERT INTO `district` VALUES ('621', '阜平', '130', 'f', 'fp', 'fuping', '', '县', '130624', '0312', '7');
INSERT INTO `district` VALUES ('622', '徐水', '130', 'x', 'xs', 'xushui', '', '区', '130625', '0312', '8');
INSERT INTO `district` VALUES ('623', '定兴', '130', 'd', 'dx', 'dingxing', '', '县', '130626', '0312', '9');
INSERT INTO `district` VALUES ('624', '唐县', '130', 't', 'tx', 'tangxian', '', '', '130627', '0312', '10');
INSERT INTO `district` VALUES ('625', '高阳', '130', 'g', 'gy', 'gaoyang', '', '县', '130628', '0312', '11');
INSERT INTO `district` VALUES ('626', '容城', '130', 'r', 'rc', 'rongcheng', '', '县', '130629', '0312', '12');
INSERT INTO `district` VALUES ('627', '涞源', '130', 'l', 'ly', 'laiyuan', '', '县', '130630', '0312', '13');
INSERT INTO `district` VALUES ('628', '望都', '130', 'w', 'wd', 'wangdou', '', '县', '130631', '0312', '14');
INSERT INTO `district` VALUES ('629', '安新', '130', 'a', 'ax', 'anxin', '', '县', '130632', '0312', '15');
INSERT INTO `district` VALUES ('630', '易县', '130', 'y', 'yx', 'yixian', '', '', '130633', '0312', '16');
INSERT INTO `district` VALUES ('631', '曲阳', '130', 'q', 'qy', 'quyang', '', '县', '130634', '0312', '17');
INSERT INTO `district` VALUES ('632', '蠡县', '130', 'l', 'lx', 'lixian', '', '', '130635', '0312', '18');
INSERT INTO `district` VALUES ('633', '顺平', '130', 's', 'sp', 'shunping', '', '县', '130636', '0312', '19');
INSERT INTO `district` VALUES ('634', '博野', '130', 'b', 'by', 'boye', '', '县', '130637', '0312', '20');
INSERT INTO `district` VALUES ('635', '雄县', '130', 'x', 'xx', 'xiongxian', '', '', '130638', '0312', '21');
INSERT INTO `district` VALUES ('636', '涿州', '130', 'z', 'zz', 'zhuozhou', '', '市', '130681', '0312', '22');
INSERT INTO `district` VALUES ('637', '定州', '130', 'd', 'dz', 'dingzhou', '', '市', '130682', '0312', '23');
INSERT INTO `district` VALUES ('638', '安国', '130', 'a', 'ag', 'anguo', '', '市', '130683', '0312', '24');
INSERT INTO `district` VALUES ('639', '高碑店', '130', 'g', 'gbd', 'gaobeidian', '', '市', '130684', '0312', '25');
INSERT INTO `district` VALUES ('640', '桥东', '131', 'q', 'qd', 'qiaodong', '', '区', '130702', '0313', '1');
INSERT INTO `district` VALUES ('641', '桥西', '131', 'q', 'qx', 'qiaoxi', '', '区', '130703', '0313', '2');
INSERT INTO `district` VALUES ('642', '宣化', '131', 'x', 'xh', 'xuanhua', '', '区', '130705', '0313', '3');
INSERT INTO `district` VALUES ('643', '下花园', '131', 'x', 'xhy', 'xiahuayuan', '', '区', '130706', '0313', '4');
INSERT INTO `district` VALUES ('645', '张北', '131', 'z', 'zb', 'zhangbei', '', '县', '130722', '0313', '6');
INSERT INTO `district` VALUES ('646', '康保', '131', 'k', 'kb', 'kangbao', '', '县', '130723', '0313', '7');
INSERT INTO `district` VALUES ('647', '沽源', '131', 'g', 'gy', 'guyuan', '', '县', '130724', '0313', '8');
INSERT INTO `district` VALUES ('648', '尚义', '131', 's', 'sy', 'shangyi', '', '县', '130725', '0313', '9');
INSERT INTO `district` VALUES ('649', '蔚县', '131', 'y', 'yx', 'yuxian', '', '', '130726', '0313', '10');
INSERT INTO `district` VALUES ('650', '阳原', '131', 'y', 'yy', 'yangyuan', '', '县', '130727', '0313', '11');
INSERT INTO `district` VALUES ('651', '怀安', '131', 'h', 'ha', 'huaian', '', '县', '130728', '0313', '12');
INSERT INTO `district` VALUES ('652', '万全', '131', 'w', 'wq', 'wanquan', '', '县', '130729', '0313', '13');
INSERT INTO `district` VALUES ('653', '怀来', '131', 'h', 'hl', 'huailai', '', '县', '130730', '0313', '14');
INSERT INTO `district` VALUES ('654', '涿鹿', '131', 'z', 'zl', 'zhuolu', '', '县', '130731', '0313', '15');
INSERT INTO `district` VALUES ('655', '赤城', '131', 'c', 'cc', 'chicheng', '', '县', '130732', '0313', '16');
INSERT INTO `district` VALUES ('656', '崇礼', '131', 'c', 'cl', 'chongli', '', '县', '130733', '0313', '17');
INSERT INTO `district` VALUES ('657', '双桥', '132', 's', 'sq', 'shuangqiao', '', '区', '130802', '0314', '1');
INSERT INTO `district` VALUES ('658', '双滦', '132', 's', 'sl', 'shuangluan', '', '区', '130803', '0314', '2');
INSERT INTO `district` VALUES ('659', '鹰手营子', '132', 'y', 'ysyz', 'yingshouyingzi', '矿', '区', '130804', '0314', '3');
INSERT INTO `district` VALUES ('660', '承德', '132', 'c', 'cd', 'chengde', '', '县', '130821', '0314', '4');
INSERT INTO `district` VALUES ('661', '兴隆', '132', 'x', 'xl', 'xinglong', '', '县', '130822', '0314', '5');
INSERT INTO `district` VALUES ('662', '平泉', '132', 'p', 'pq', 'pingquan', '', '县', '130823', '0314', '6');
INSERT INTO `district` VALUES ('663', '滦平', '132', 'l', 'lp', 'luanping', '', '县', '130824', '0314', '7');
INSERT INTO `district` VALUES ('664', '隆化', '132', 'l', 'lh', 'longhua', '', '县', '130825', '0314', '8');
INSERT INTO `district` VALUES ('665', '丰宁', '132', 'f', 'fn', 'fengning', '满族', '自治县', '130826', '0314', '9');
INSERT INTO `district` VALUES ('666', '宽城', '132', 'k', 'kc', 'kuancheng', '满族', '自治县', '130827', '0314', '10');
INSERT INTO `district` VALUES ('667', '围场', '132', 'w', 'wc', 'weichang', '满族蒙古族', '自治县', '130828', '0314', '11');
INSERT INTO `district` VALUES ('668', '新华', '133', 'x', 'xh', 'xinhua', '', '区', '130902', '0317', '1');
INSERT INTO `district` VALUES ('669', '运河', '133', 'y', 'yh', 'yunhe', '', '区', '130903', '0317', '2');
INSERT INTO `district` VALUES ('670', '沧县', '133', 'c', 'cx', 'cangxian', '', '', '130921', '0317', '3');
INSERT INTO `district` VALUES ('671', '青县', '133', 'q', 'qx', 'qingxian', '', '', '130922', '0317', '4');
INSERT INTO `district` VALUES ('672', '东光', '133', 'd', 'dg', 'dongguang', '', '县', '130923', '0317', '5');
INSERT INTO `district` VALUES ('673', '海兴', '133', 'h', 'hx', 'haixing', '', '县', '130924', '0317', '6');
INSERT INTO `district` VALUES ('674', '盐山', '133', 'y', 'ys', 'yanshan', '', '县', '130925', '0317', '7');
INSERT INTO `district` VALUES ('675', '肃宁', '133', 's', 'sn', 'suning', '', '县', '130926', '0317', '8');
INSERT INTO `district` VALUES ('676', '南皮', '133', 'n', 'np', 'nanpi', '', '县', '130927', '0317', '9');
INSERT INTO `district` VALUES ('677', '吴桥', '133', 'w', 'wq', 'wuqiao', '', '县', '130928', '0317', '10');
INSERT INTO `district` VALUES ('678', '献县', '133', 'x', 'xx', 'xianxian', '', '', '130929', '0317', '11');
INSERT INTO `district` VALUES ('679', '孟村', '133', 'm', 'mc', 'mengcun', '回族', '自治县', '130930', '0317', '12');
INSERT INTO `district` VALUES ('680', '泊头', '133', 'b', 'bt', 'botou', '', '市', '130981', '0317', '13');
INSERT INTO `district` VALUES ('681', '任丘', '133', 'r', 'rq', 'renqiu', '', '市', '130982', '0317', '14');
INSERT INTO `district` VALUES ('682', '黄骅', '133', 'h', 'hh', 'huanghua', '', '市', '130983', '0317', '15');
INSERT INTO `district` VALUES ('683', '河间', '133', 'h', 'hj', 'hejian', '', '市', '130984', '0317', '16');
INSERT INTO `district` VALUES ('684', '安次', '134', 'a', 'ac', 'anci', '', '区', '131002', '0316', '1');
INSERT INTO `district` VALUES ('685', '广阳', '134', 'g', 'gy', 'guangyang', '', '区', '131003', '0316', '2');
INSERT INTO `district` VALUES ('686', '固安', '134', 'g', 'ga', 'guan', '', '县', '131022', '0316', '3');
INSERT INTO `district` VALUES ('687', '永清', '134', 'y', 'yq', 'yongqing', '', '县', '131023', '0316', '4');
INSERT INTO `district` VALUES ('688', '香河', '134', 'x', 'xh', 'xianghe', '', '县', '131024', '0316', '5');
INSERT INTO `district` VALUES ('689', '大城', '134', 'd', 'dc', 'dacheng', '', '县', '131025', '0316', '6');
INSERT INTO `district` VALUES ('690', '文安', '134', 'w', 'wa', 'wenan', '', '县', '131026', '0316', '7');
INSERT INTO `district` VALUES ('691', '大厂', '134', 'd', 'dc', 'dachang', '回族', '自治县', '131028', '0316', '8');
INSERT INTO `district` VALUES ('692', '霸州', '134', 'b', 'bz', 'bazhou', '', '市', '131081', '0316', '9');
INSERT INTO `district` VALUES ('693', '三河', '134', 's', 'sh', 'sanhe', '', '市', '131082', '0316', '10');
INSERT INTO `district` VALUES ('694', '桃城', '135', 't', 'tc', 'taocheng', '', '区', '131102', '0318', '1');
INSERT INTO `district` VALUES ('695', '枣强', '135', 'z', 'zq', 'zaoqiang', '', '县', '131121', '0318', '2');
INSERT INTO `district` VALUES ('696', '武邑', '135', 'w', 'wy', 'wuyi', '', '县', '131122', '0318', '3');
INSERT INTO `district` VALUES ('697', '武强', '135', 'w', 'wq', 'wuqiang', '', '县', '131123', '0318', '4');
INSERT INTO `district` VALUES ('698', '饶阳', '135', 'r', 'ry', 'raoyang', '', '县', '131124', '0318', '5');
INSERT INTO `district` VALUES ('699', '安平', '135', 'a', 'ap', 'anping', '', '县', '131125', '0318', '6');
INSERT INTO `district` VALUES ('700', '故城', '135', 'g', 'gc', 'gucheng', '', '县', '131126', '0318', '7');
INSERT INTO `district` VALUES ('701', '景县', '135', 'j', 'jx', 'jingxian', '', '', '131127', '0318', '8');
INSERT INTO `district` VALUES ('702', '阜城', '135', 'f', 'fc', 'fucheng', '', '县', '131128', '0318', '9');
INSERT INTO `district` VALUES ('703', '冀州', '135', 'j', 'jz', 'jizhou', '', '区', '131181', '0318', '10');
INSERT INTO `district` VALUES ('704', '深州', '135', 's', 'sz', 'shenzhou', '', '市', '131182', '0318', '11');
INSERT INTO `district` VALUES ('705', '小店', '136', 'x', 'xd', 'xiaodian', '', '区', '140105', '0351', '1');
INSERT INTO `district` VALUES ('706', '迎泽', '136', 'y', 'yz', 'yingze', '', '区', '140106', '0351', '2');
INSERT INTO `district` VALUES ('707', '杏花岭', '136', 'x', 'xhl', 'xinghualing', '', '区', '140107', '0351', '3');
INSERT INTO `district` VALUES ('708', '尖草坪', '136', 'j', 'jcp', 'jiancaoping', '', '区', '140108', '0351', '4');
INSERT INTO `district` VALUES ('709', '万柏林', '136', 'w', 'wbl', 'wanbolin', '', '区', '140109', '0351', '5');
INSERT INTO `district` VALUES ('710', '晋源', '136', 'j', 'jy', 'jinyuan', '', '区', '140110', '0351', '6');
INSERT INTO `district` VALUES ('711', '清徐', '136', 'q', 'qx', 'qingxu', '', '县', '140121', '0351', '7');
INSERT INTO `district` VALUES ('712', '阳曲', '136', 'y', 'yq', 'yangqu', '', '县', '140122', '0351', '8');
INSERT INTO `district` VALUES ('713', '娄烦', '136', 'l', 'lf', 'loufan', '', '县', '140123', '0351', '9');
INSERT INTO `district` VALUES ('714', '古交', '136', 'g', 'gj', 'gujiao', '', '市', '140181', '0351', '10');
INSERT INTO `district` VALUES ('715', '城区', '137', 'c', 'cq', 'chengqu', '', '', '140202', '0352', '1');
INSERT INTO `district` VALUES ('716', '矿区', '137', 'k', 'kq', 'kuangqu', '', '', '140203', '0352', '2');
INSERT INTO `district` VALUES ('717', '南郊', '137', 'n', 'nj', 'nanjiao', '', '区', '140211', '0352', '3');
INSERT INTO `district` VALUES ('718', '新荣', '137', 'x', 'xr', 'xinrong', '', '区', '140212', '0352', '4');
INSERT INTO `district` VALUES ('719', '阳高', '137', 'y', 'yg', 'yanggao', '', '县', '140221', '0352', '5');
INSERT INTO `district` VALUES ('720', '天镇', '137', 't', 'tz', 'tianzhen', '', '县', '140222', '0352', '6');
INSERT INTO `district` VALUES ('721', '广灵', '137', 'g', 'gl', 'guangling', '', '县', '140223', '0352', '7');
INSERT INTO `district` VALUES ('722', '灵丘', '137', 'l', 'lq', 'lingqiu', '', '县', '140224', '0352', '8');
INSERT INTO `district` VALUES ('723', '浑源', '137', 'h', 'hy', 'hunyuan', '', '县', '140225', '0352', '9');
INSERT INTO `district` VALUES ('724', '左云', '137', 'z', 'zy', 'zuoyun', '', '县', '140226', '0352', '10');
INSERT INTO `district` VALUES ('725', '大同', '137', 'd', 'dt', 'datong', '', '县', '140227', '0352', '11');
INSERT INTO `district` VALUES ('726', '城区', '138', 'c', 'cq', 'chengqu', '', '', '140302', '0353', '1');
INSERT INTO `district` VALUES ('727', '矿区', '138', 'k', 'kq', 'kuangqu', '', '', '140303', '0353', '2');
INSERT INTO `district` VALUES ('728', '郊区', '138', 'j', 'jq', 'jiaoqu', '', '', '140311', '0353', '3');
INSERT INTO `district` VALUES ('729', '平定', '138', 'p', 'pd', 'pingding', '', '县', '140321', '0353', '4');
INSERT INTO `district` VALUES ('730', '盂县', '138', 'y', 'yx', 'yuxian', '', '', '140322', '0353', '5');
INSERT INTO `district` VALUES ('731', '城区', '139', 'c', 'cq', 'chengqu', '', '', '140402', '0355', '1');
INSERT INTO `district` VALUES ('732', '郊区', '139', 'j', 'jq', 'jiaoqu', '', '', '140411', '0355', '2');
INSERT INTO `district` VALUES ('733', '长治', '139', 'z', 'zz', 'zhangzhi', '', '县', '140421', '0355', '3');
INSERT INTO `district` VALUES ('734', '襄垣', '139', 'x', 'xy', 'xiangyuan', '', '县', '140423', '0355', '4');
INSERT INTO `district` VALUES ('735', '屯留', '139', 't', 'tl', 'tunliu', '', '县', '140424', '0355', '5');
INSERT INTO `district` VALUES ('736', '平顺', '139', 'p', 'ps', 'pingshun', '', '县', '140425', '0355', '6');
INSERT INTO `district` VALUES ('737', '黎城', '139', 'l', 'lc', 'licheng', '', '县', '140426', '0355', '7');
INSERT INTO `district` VALUES ('738', '壶关', '139', 'h', 'hg', 'huguan', '', '县', '140427', '0355', '8');
INSERT INTO `district` VALUES ('739', '长子', '139', 'z', 'zz', 'zhangzi', '', '县', '140428', '0355', '9');
INSERT INTO `district` VALUES ('740', '武乡', '139', 'w', 'wx', 'wuxiang', '', '县', '140429', '0355', '10');
INSERT INTO `district` VALUES ('741', '沁县', '139', 'q', 'qx', 'qinxian', '', '', '140430', '0355', '11');
INSERT INTO `district` VALUES ('742', '沁源', '139', 'q', 'qy', 'qinyuan', '', '县', '140431', '0355', '12');
INSERT INTO `district` VALUES ('743', '潞城', '139', 'l', 'lc', 'lucheng', '', '县', '140481', '0355', '13');
INSERT INTO `district` VALUES ('744', '城区', '140', 'c', 'cq', 'chengqu', '', '', '140502', '0356', '1');
INSERT INTO `district` VALUES ('745', '沁水', '140', 'q', 'qs', 'qinshui', '', '县', '140521', '0356', '2');
INSERT INTO `district` VALUES ('746', '阳城', '140', 'y', 'yc', 'yangcheng', '', '县', '140522', '0356', '3');
INSERT INTO `district` VALUES ('747', '陵川', '140', 'l', 'lc', 'lingchuan', '', '县', '140524', '0356', '4');
INSERT INTO `district` VALUES ('748', '泽州', '140', 'z', 'zz', 'zezhou', '', '县', '140525', '0356', '5');
INSERT INTO `district` VALUES ('749', '高平', '140', 'g', 'gp', 'gaoping', '', '市', '140581', '0356', '6');
INSERT INTO `district` VALUES ('750', '朔城', '141', 's', 'sc', 'shuocheng', '', '区', '140602', '0349', '1');
INSERT INTO `district` VALUES ('751', '平鲁', '141', 'p', 'pl', 'pinglu', '', '区', '140603', '0349', '2');
INSERT INTO `district` VALUES ('752', '山阴', '141', 's', 'sy', 'shanyin', '', '县', '140621', '0349', '3');
INSERT INTO `district` VALUES ('753', '应县', '141', 'y', 'yx', 'yingxian', '', '', '140622', '0349', '4');
INSERT INTO `district` VALUES ('754', '右玉', '141', 'y', 'yy', 'youyu', '', '县', '140623', '0349', '5');
INSERT INTO `district` VALUES ('755', '怀仁', '141', 'h', 'hr', 'huairen', '', '县', '140624', '0349', '6');
INSERT INTO `district` VALUES ('756', '榆次', '142', 'y', 'yc', 'yuci', '', '区', '030600', '0354', '1');
INSERT INTO `district` VALUES ('757', '榆社', '142', 'y', 'ys', 'yushe', '', '县', '140721', '0354', '2');
INSERT INTO `district` VALUES ('758', '左权', '142', 'z', 'zq', 'zuoquan', '', '县', '140722', '0354', '3');
INSERT INTO `district` VALUES ('759', '和顺', '142', 'h', 'hs', 'heshun', '', '县', '140723', '0354', '4');
INSERT INTO `district` VALUES ('760', '昔阳', '142', 'x', 'xy', 'xiyang', '', '县', '140724', '0354', '5');
INSERT INTO `district` VALUES ('761', '寿阳', '142', 's', 'sy', 'shouyang', '', '县', '140725', '0354', '6');
INSERT INTO `district` VALUES ('762', '太谷', '142', 't', 'tg', 'taigu', '', '县', '140726', '0354', '7');
INSERT INTO `district` VALUES ('763', '祁县', '142', 'q', 'qx', 'qixian', '', '', '140727', '0354', '8');
INSERT INTO `district` VALUES ('764', '平遥', '142', 'p', 'py', 'pingyao', '', '县', '140728', '0354', '9');
INSERT INTO `district` VALUES ('765', '灵石', '142', 'l', 'ls', 'lingshi', '', '县', '140729', '0354', '10');
INSERT INTO `district` VALUES ('766', '介休', '142', 'j', 'jx', 'jiexiu', '', '市', '140781', '0354', '11');
INSERT INTO `district` VALUES ('767', '盐湖', '143', 'y', 'yh', 'yanhu', '', '区', '140802', '0359', '1');
INSERT INTO `district` VALUES ('768', '临猗', '143', 'l', 'ly', 'linyi', '', '县', '140821', '0359', '2');
INSERT INTO `district` VALUES ('769', '万荣', '143', 'w', 'wr', 'wanrong', '', '县', '140822', '0359', '3');
INSERT INTO `district` VALUES ('770', '闻喜', '143', 'w', 'wx', 'wenxi', '', '县', '140823', '0359', '4');
INSERT INTO `district` VALUES ('771', '稷山', '143', 'j', 'js', 'jishan', '', '县', '140824', '0359', '5');
INSERT INTO `district` VALUES ('772', '新绛', '143', 'x', 'xj', 'xinjiang', '', '县', '140825', '0359', '6');
INSERT INTO `district` VALUES ('773', '绛县', '143', 'j', 'jx', 'jiangxian', '', '', '140826', '0359', '7');
INSERT INTO `district` VALUES ('774', '垣曲', '143', 'y', 'yq', 'yuanqu', '', '县', '140827', '0359', '8');
INSERT INTO `district` VALUES ('775', '夏县', '143', 'x', 'xx', 'xiaxian', '', '', '140828', '0359', '9');
INSERT INTO `district` VALUES ('776', '平陆', '143', 'p', 'pl', 'pinglu', '', '县', '140829', '0359', '10');
INSERT INTO `district` VALUES ('777', '芮城', '143', 'r', 'rc', 'ruicheng', '', '县', '140830', '0359', '11');
INSERT INTO `district` VALUES ('778', '永济', '143', 'y', 'yj', 'yongji', '', '市', '140881', '0359', '12');
INSERT INTO `district` VALUES ('779', '河津', '143', 'h', 'hj', 'hejin', '', '市', '140882', '0359', '13');
INSERT INTO `district` VALUES ('780', '忻府', '144', 'x', 'xf', 'xinfu', '', '区', '140902', '0350', '1');
INSERT INTO `district` VALUES ('781', '定襄', '144', 'd', 'dx', 'dingxiang', '', '县', '140921', '0350', '2');
INSERT INTO `district` VALUES ('782', '五台', '144', 'w', 'wt', 'wutai', '', '县', '140922', '0350', '3');
INSERT INTO `district` VALUES ('783', '代县', '144', 'd', 'dx', 'daixian', '', '', '140923', '0350', '4');
INSERT INTO `district` VALUES ('784', '繁峙', '144', 'f', 'fz', 'fanzhi', '', '县', '140924', '0350', '5');
INSERT INTO `district` VALUES ('785', '宁武', '144', 'n', 'nw', 'ningwu', '', '县', '140925', '0350', '6');
INSERT INTO `district` VALUES ('786', '静乐', '144', 'j', 'jl', 'jingle', '', '县', '140926', '0350', '7');
INSERT INTO `district` VALUES ('787', '神池', '144', 's', 'sc', 'shenchi', '', '县', '140927', '0350', '8');
INSERT INTO `district` VALUES ('788', '五寨', '144', 'w', 'wz', 'wuzhai', '', '县', '140928', '0350', '9');
INSERT INTO `district` VALUES ('789', '岢岚', '144', 'k', 'kl', 'kelan', '', '县', '140929', '0350', '10');
INSERT INTO `district` VALUES ('790', '河曲', '144', 'h', 'hq', 'hequ', '', '县', '140930', '0350', '11');
INSERT INTO `district` VALUES ('791', '保德', '144', 'b', 'bd', 'baode', '', '县', '140931', '0350', '12');
INSERT INTO `district` VALUES ('792', '偏关', '144', 'p', 'pg', 'pianguan', '', '县', '140932', '0350', '13');
INSERT INTO `district` VALUES ('793', '原平', '144', 'y', 'yp', 'yuanping', '', '市', '140981', '0350', '14');
INSERT INTO `district` VALUES ('794', '尧都', '145', 'y', 'yd', 'yaodou', '', '区', '141002', '0357', '1');
INSERT INTO `district` VALUES ('795', '曲沃', '145', 'q', 'qw', 'quwo', '', '县', '141021', '0357', '2');
INSERT INTO `district` VALUES ('796', '翼城', '145', 'y', 'yc', 'yicheng', '', '县', '141022', '0357', '3');
INSERT INTO `district` VALUES ('797', '襄汾', '145', 'x', 'xf', 'xiangfen', '', '县', '141023', '0357', '4');
INSERT INTO `district` VALUES ('798', '洪洞', '145', 'h', 'hd', 'hongdong', '', '县', '141024', '0357', '5');
INSERT INTO `district` VALUES ('799', '古县', '145', 'g', 'gx', 'guxian', '', '', '141025', '0357', '6');
INSERT INTO `district` VALUES ('800', '安泽', '145', 'a', 'az', 'anze', '', '县', '141026', '0357', '7');
INSERT INTO `district` VALUES ('801', '浮山', '145', 'f', 'fs', 'fushan', '', '县', '141027', '0357', '8');
INSERT INTO `district` VALUES ('802', '吉县', '145', 'j', 'jx', 'jixian', '', '', '141028', '0357', '9');
INSERT INTO `district` VALUES ('803', '乡宁', '145', 'x', 'xn', 'xiangning', '', '县', '141029', '0357', '10');
INSERT INTO `district` VALUES ('804', '大宁', '145', 'd', 'dn', 'daning', '', '县', '141030', '0357', '11');
INSERT INTO `district` VALUES ('805', '隰县', '145', 'x', 'xx', 'xixian', '', '', '141031', '0357', '12');
INSERT INTO `district` VALUES ('806', '永和', '145', 'y', 'yh', 'yonghe', '', '县', '141032', '0357', '13');
INSERT INTO `district` VALUES ('807', '蒲县', '145', 'p', 'px', 'puxian', '', '', '141033', '0357', '14');
INSERT INTO `district` VALUES ('808', '汾西', '145', 'f', 'fx', 'fenxi', '', '县', '141034', '0357', '15');
INSERT INTO `district` VALUES ('809', '侯马', '145', 'h', 'hm', 'houma', '', '市', '141081', '0357', '16');
INSERT INTO `district` VALUES ('810', '霍州', '145', 'h', 'hz', 'huozhou', '', '市', '141082', '0357', '17');
INSERT INTO `district` VALUES ('811', '离石', '146', 'l', 'ls', 'lishi', '', '区', '141102', '0358', '1');
INSERT INTO `district` VALUES ('812', '文水', '146', 'w', 'ws', 'wenshui', '', '县', '141121', '0358', '2');
INSERT INTO `district` VALUES ('813', '交城', '146', 'j', 'jc', 'jiaocheng', '', '县', '141122', '0358', '3');
INSERT INTO `district` VALUES ('814', '兴县', '146', 'x', 'xx', 'xingxian', '', '', '141123', '0358', '4');
INSERT INTO `district` VALUES ('815', '临县', '146', 'l', 'lx', 'linxian', '', '', '141124', '0358', '5');
INSERT INTO `district` VALUES ('816', '柳林', '146', 'l', 'll', 'liulin', '', '县', '141125', '0358', '6');
INSERT INTO `district` VALUES ('817', '石楼', '146', 's', 'sl', 'shilou', '', '县', '141126', '0358', '7');
INSERT INTO `district` VALUES ('818', '岚县', '146', 'l', 'lx', 'lanxian', '', '', '141127', '0358', '8');
INSERT INTO `district` VALUES ('819', '方山', '146', 'f', 'fs', 'fangshan', '', '县', '141128', '0358', '9');
INSERT INTO `district` VALUES ('820', '中阳', '146', 'z', 'zy', 'zhongyang', '', '县', '141129', '0358', '10');
INSERT INTO `district` VALUES ('821', '交口', '146', 'j', 'jk', 'jiaokou', '', '县', '141130', '0358', '11');
INSERT INTO `district` VALUES ('822', '孝义', '146', 'x', 'xy', 'xiaoyi', '', '市', '141181', '0358', '12');
INSERT INTO `district` VALUES ('823', '汾阳', '146', 'f', 'fy', 'fenyang', '', '市', '141182', '0358', '13');
INSERT INTO `district` VALUES ('824', '新城', '147', 'x', 'xc', 'xincheng', '', '区', '150102', '0471', '1');
INSERT INTO `district` VALUES ('825', '回民', '147', 'h', 'hm', 'huimin', '', '区', '150103', '0471', '2');
INSERT INTO `district` VALUES ('826', '玉泉', '147', 'y', 'yq', 'yuquan', '', '区', '150104', '0471', '3');
INSERT INTO `district` VALUES ('827', '赛罕', '147', 's', 'sh', 'saihan', '', '区', '150105', '0471', '4');
INSERT INTO `district` VALUES ('828', '土默特左', '147', 't', 'tmtz', 'tumotezuo', '', '旗', '150121', '0471', '5');
INSERT INTO `district` VALUES ('829', '托克托', '147', 't', 'tkt', 'tuoketuo', '', '县', '150122', '0471', '6');
INSERT INTO `district` VALUES ('830', '和林格尔', '147', 'h', 'hlge', 'helingeer', '', '县', '150123', '0471', '7');
INSERT INTO `district` VALUES ('831', '清水河', '147', 'q', 'qsh', 'qingshuihe', '', '县', '150124', '0471', '8');
INSERT INTO `district` VALUES ('832', '武川', '147', 'w', 'wc', 'wuchuan', '', '县', '150125', '0471', '9');
INSERT INTO `district` VALUES ('833', '东河', '148', 'd', 'dh', 'donghe', '', '区', '150202', '0472', '1');
INSERT INTO `district` VALUES ('834', '昆都仑', '148', 'k', 'kdl', 'kundoulun', '', '区', '150203', '0472', '2');
INSERT INTO `district` VALUES ('835', '青山', '148', 'q', 'qs', 'qingshan', '', '区', '150204', '0472', '3');
INSERT INTO `district` VALUES ('836', '石拐', '148', 's', 'sg', 'shiguai', '', '区', '150205', '0472', '4');
INSERT INTO `district` VALUES ('837', '白云', '148', 'b', 'by', 'baiyun', '矿', '区', '150206', '0472', '5');
INSERT INTO `district` VALUES ('838', '九原', '148', 'j', 'jy', 'jiuyuan', '', '区', '150207', '0472', '6');
INSERT INTO `district` VALUES ('839', '土默特右', '148', 't', 'tmty', 'tumoteyou', '', '旗', '150221', '0472', '7');
INSERT INTO `district` VALUES ('840', '固阳', '148', 'g', 'gy', 'guyang', '', '县', '150222', '0472', '8');
INSERT INTO `district` VALUES ('841', '达尔罕茂明安', '148', 'd', 'dehmma', 'daerhanmaomingan', '联合', '旗', '150223', '0472', '9');
INSERT INTO `district` VALUES ('842', '海勃湾', '149', 'h', 'hbw', 'haibowan', '', '区', '150302', '0473', '1');
INSERT INTO `district` VALUES ('843', '海南', '149', 'h', 'hn', 'hainan', '', '区', '150303', '0473', '2');
INSERT INTO `district` VALUES ('844', '乌达', '149', 'w', 'wd', 'wuda', '', '区', '150304', '0473', '3');
INSERT INTO `district` VALUES ('845', '红山', '150', 'h', 'hs', 'hongshan', '', '区', '150402', '0476', '1');
INSERT INTO `district` VALUES ('846', '元宝山', '150', 'y', 'ybs', 'yuanbaoshan', '', '区', '150403', '0476', '2');
INSERT INTO `district` VALUES ('847', '松山', '150', 's', 'ss', 'songshan', '', '区', '150404', '0476', '3');
INSERT INTO `district` VALUES ('848', '阿鲁科尔沁', '150', 'a', 'alkeq', 'alukeerqin', '', '旗', '150421', '0476', '4');
INSERT INTO `district` VALUES ('849', '巴林左', '150', 'b', 'blz', 'balinzuo', '', '旗', '150422', '0476', '5');
INSERT INTO `district` VALUES ('850', '巴林右', '150', 'b', 'bly', 'balinyou', '', '旗', '150423', '0476', '6');
INSERT INTO `district` VALUES ('851', '林西', '150', 'l', 'lx', 'linxi', '', '县', '150424', '0476', '7');
INSERT INTO `district` VALUES ('852', '克什克腾', '150', 'k', 'kskt', 'keshenketeng', '', '旗', '150425', '0476', '8');
INSERT INTO `district` VALUES ('853', '翁牛特', '150', 'w', 'wnt', 'wengniute', '', '旗', '150426', '0476', '9');
INSERT INTO `district` VALUES ('854', '喀喇沁', '150', 'k', 'klq', 'kalaqin', '', '旗', '150428', '0476', '10');
INSERT INTO `district` VALUES ('855', '宁城', '150', 'n', 'nc', 'ningcheng', '', '县', '150429', '0476', '11');
INSERT INTO `district` VALUES ('856', '敖汉', '150', 'a', 'ah', 'aohan', '', '旗', '150430', '0476', '12');
INSERT INTO `district` VALUES ('857', '科尔沁', '151', 'k', 'keq', 'keerqin', '', '区', '150502', '0475', '1');
INSERT INTO `district` VALUES ('858', '科尔沁左翼中', '151', 'k', 'keqzyz', 'keerqinzuoyizhong', '', '旗', '150521', '0475', '2');
INSERT INTO `district` VALUES ('859', '科尔沁左翼后', '151', 'k', 'keqzyh', 'keerqinzuoyihou', '', '旗', '150522', '0475', '3');
INSERT INTO `district` VALUES ('860', '开鲁', '151', 'k', 'kl', 'kailu', '', '县', '150523', '0475', '4');
INSERT INTO `district` VALUES ('861', '库伦', '151', 'k', 'kl', 'kulun', '', '旗', '150524', '0475', '5');
INSERT INTO `district` VALUES ('862', '奈曼', '151', 'n', 'nm', 'naiman', '', '旗', '150525', '0475', '6');
INSERT INTO `district` VALUES ('863', '扎鲁特', '151', 'z', 'zlt', 'zhalute', '', '旗', '150526', '0475', '7');
INSERT INTO `district` VALUES ('864', '霍林郭勒', '151', 'h', 'hlgl', 'huolinguole', '', '市', '150581', '0475', '8');
INSERT INTO `district` VALUES ('865', '东胜', '152', 'd', 'ds', 'dongsheng', '', '区', '150602', '0477', '1');
INSERT INTO `district` VALUES ('866', '达拉特', '152', 'd', 'dlt', 'dalate', '', '旗', '150621', '0477', '2');
INSERT INTO `district` VALUES ('867', '准格尔', '152', 'z', 'zge', 'zhungeer', '', '旗', '150622', '0477', '3');
INSERT INTO `district` VALUES ('868', '鄂托克前', '152', 'e', 'etkq', 'etuokeqian', '', '旗', '150623', '0477', '4');
INSERT INTO `district` VALUES ('869', '鄂托克', '152', 'e', 'etk', 'etuoke', '', '旗', '150624', '0477', '5');
INSERT INTO `district` VALUES ('870', '杭锦', '152', 'h', 'hj', 'hangjin', '', '旗', '150625', '0477', '6');
INSERT INTO `district` VALUES ('871', '乌审', '152', 'w', 'ws', 'wushen', '', '旗', '150626', '0477', '7');
INSERT INTO `district` VALUES ('872', '伊金霍洛', '152', 'y', 'yjhl', 'yijinhuoluo', '', '旗', '150627', '0477', '8');
INSERT INTO `district` VALUES ('873', '海拉尔', '153', 'h', 'hle', 'hailaer', '', '区', '150702', '0470', '1');
INSERT INTO `district` VALUES ('874', '阿荣', '153', 'a', 'ar', 'arong', '', '旗', '150721', '0470', '2');
INSERT INTO `district` VALUES ('875', '莫力达瓦', '153', 'm', 'mldw', 'molidawa', '达斡尔族', '自治旗', '150722', '0470', '3');
INSERT INTO `district` VALUES ('876', '鄂伦春', '153', 'e', 'elc', 'elunchun', '', '自治旗', '150723', '0470', '4');
INSERT INTO `district` VALUES ('877', '鄂温克族', '153', 'e', 'ewkz', 'ewenkezu', '', '自治旗', '150724', '0470', '5');
INSERT INTO `district` VALUES ('878', '陈巴尔虎', '153', 'c', 'cbeh', 'chenbaerhu', '', '旗', '150725', '0470', '6');
INSERT INTO `district` VALUES ('879', '新巴尔虎左', '153', 'x', 'xbehz', 'xinbaerhuzuo', '', '旗', '150726', '0470', '7');
INSERT INTO `district` VALUES ('880', '新巴尔虎右', '153', 'x', 'xbehy', 'xinbaerhuyou', '', '旗', '150727', '0470', '8');
INSERT INTO `district` VALUES ('881', '满洲里', '153', 'm', 'mzl', 'manzhouli', '', '市', '150781', '0470', '9');
INSERT INTO `district` VALUES ('882', '牙克石', '153', 'y', 'yks', 'yakeshi', '', '市', '150782', '0470', '10');
INSERT INTO `district` VALUES ('883', '扎兰屯', '153', 'z', 'zlt', 'zhalantun', '', '市', '150783', '0470', '11');
INSERT INTO `district` VALUES ('884', '额尔古纳', '153', 'e', 'eegn', 'eerguna', '', '市', '150784', '0470', '12');
INSERT INTO `district` VALUES ('885', '根河', '153', 'g', 'gh', 'genhe', '', '市', '150785', '0470', '13');
INSERT INTO `district` VALUES ('886', '临河', '154', 'l', 'lh', 'linhe', '', '区', '150802', '0478', '1');
INSERT INTO `district` VALUES ('887', '五原', '154', 'w', 'wy', 'wuyuan', '', '县', '150821', '0478', '2');
INSERT INTO `district` VALUES ('888', '磴口', '154', 'd', 'dk', 'dengkou', '', '县', '150822', '0478', '3');
INSERT INTO `district` VALUES ('889', '乌拉特前', '154', 'w', 'wltq', 'wulateqian', '', '旗', '150823', '0478', '4');
INSERT INTO `district` VALUES ('890', '乌拉特中', '154', 'w', 'wltz', 'wulatezhong', '', '旗', '150824', '0478', '5');
INSERT INTO `district` VALUES ('891', '乌拉特后', '154', 'w', 'wlth', 'wulatehou', '', '旗', '150825', '0478', '6');
INSERT INTO `district` VALUES ('892', '杭锦后', '154', 'h', 'hjh', 'hangjinhou', '', '旗', '150826', '0478', '7');
INSERT INTO `district` VALUES ('893', '集宁', '155', 'j', 'jn', 'jining', '', '区', '150902', '0474', '1');
INSERT INTO `district` VALUES ('894', '卓资', '155', 'z', 'zz', 'zhuozi', '', '县', '150921', '0474', '2');
INSERT INTO `district` VALUES ('895', '化德', '155', 'h', 'hd', 'huade', '', '县', '150922', '0474', '3');
INSERT INTO `district` VALUES ('896', '商都', '155', 's', 'sd', 'shangdou', '', '县', '150923', '0474', '4');
INSERT INTO `district` VALUES ('897', '兴和', '155', 'x', 'xh', 'xinghe', '', '县', '150924', '0474', '5');
INSERT INTO `district` VALUES ('898', '凉城', '155', 'l', 'lc', 'liangcheng', '', '县', '150925', '0474', '6');
INSERT INTO `district` VALUES ('899', '察哈尔右翼前', '155', 'c', 'cheyyq', 'chahaeryouyiqian', '', '旗', '150926', '0474', '7');
INSERT INTO `district` VALUES ('900', '察哈尔右翼中', '155', 'c', 'cheyyz', 'chahaeryouyizhong', '', '旗', '150927', '0474', '8');
INSERT INTO `district` VALUES ('901', '察哈尔右翼后', '155', 'c', 'cheyyh', 'chahaeryouyihou', '', '旗', '150928', '0474', '9');
INSERT INTO `district` VALUES ('902', '四子王', '155', 's', 'szw', 'siziwang', '', '旗', '150929', '0474', '10');
INSERT INTO `district` VALUES ('903', '丰镇', '155', 'f', 'fz', 'fengzhen', '', '市', '150981', '0474', '11');
INSERT INTO `district` VALUES ('904', '乌兰浩特', '156', 'w', 'wlht', 'wulanhaote', '', '市', '152201', '0482', '1');
INSERT INTO `district` VALUES ('905', '阿尔山', '156', 'a', 'aes', 'aershan', '', '市', '152202', '0482', '2');
INSERT INTO `district` VALUES ('906', '科尔沁右翼前', '156', 'k', 'keqyyq', 'keerqinyouyiqian', '', '旗', '152221', '0482', '3');
INSERT INTO `district` VALUES ('907', '科尔沁右翼中', '156', 'k', 'keqyyz', 'keerqinyouyizhong', '', '旗', '152222', '0482', '4');
INSERT INTO `district` VALUES ('908', '扎赉特', '156', 'z', 'zlt', 'zhalaite', '', '旗', '152223', '0482', '5');
INSERT INTO `district` VALUES ('909', '突泉', '156', 't', 'tq', 'tuquan', '', '县', '152224', '0482', '6');
INSERT INTO `district` VALUES ('910', '二连浩特', '157', 'e', 'elht', 'erlianhaote', '', '市', '152501', '0479', '1');
INSERT INTO `district` VALUES ('911', '锡林浩特', '157', 'x', 'xlht', 'xilinhaote', '', '市', '152502', '0479', '2');
INSERT INTO `district` VALUES ('912', '阿巴嘎', '157', 'a', 'abg', 'abaga', '', '旗', '152522', '0479', '3');
INSERT INTO `district` VALUES ('913', '苏尼特左', '157', 's', 'sntz', 'sunitezuo', '', '旗', '152523', '0479', '4');
INSERT INTO `district` VALUES ('914', '苏尼特右', '157', 's', 'snty', 'suniteyou', '', '旗', '152524', '0479', '5');
INSERT INTO `district` VALUES ('915', '东乌珠穆沁', '157', 'd', 'dwzmq', 'dongwuzhumuqin', '', '旗', '152525', '0479', '6');
INSERT INTO `district` VALUES ('916', '西乌珠穆沁', '157', 'x', 'xwzmq', 'xiwuzhumuqin', '', '旗', '152526', '0479', '7');
INSERT INTO `district` VALUES ('917', '太仆寺', '157', 't', 'tps', 'taipusi', '', '旗', '152527', '0479', '8');
INSERT INTO `district` VALUES ('918', '镶黄', '157', 'x', 'xh', 'xianghuang', '', '旗', '152528', '0479', '9');
INSERT INTO `district` VALUES ('919', '正镶白', '157', 'z', 'zxb', 'zhengxiangbai', '', '旗', '152529', '0479', '10');
INSERT INTO `district` VALUES ('920', '正蓝', '157', 'z', 'zl', 'zhenglan', '', '旗', '152530', '0479', '11');
INSERT INTO `district` VALUES ('921', '多伦', '157', 'd', 'dl', 'duolun', '', '县', '152531', '0479', '12');
INSERT INTO `district` VALUES ('922', '阿拉善左', '158', 'a', 'alsz', 'alashanzuo', '', '旗', '152921', '0483', '1');
INSERT INTO `district` VALUES ('923', '阿拉善右', '158', 'a', 'alsy', 'alashanyou', '', '旗', '152922', '0483', '2');
INSERT INTO `district` VALUES ('924', '额济纳', '158', 'e', 'ejn', 'ejina', '', '旗', '152923', '0483', '3');
INSERT INTO `district` VALUES ('925', '和平', '159', 'h', 'hp', 'heping', '', '区', '210102', '024', '1');
INSERT INTO `district` VALUES ('926', '沈河', '159', 's', 'sh', 'shenhe', '', '区', '210103', '024', '2');
INSERT INTO `district` VALUES ('927', '大东', '159', 'd', 'dd', 'dadong', '', '区', '210104', '024', '3');
INSERT INTO `district` VALUES ('928', '皇姑', '159', 'h', 'hg', 'huanggu', '', '区', '210105', '024', '4');
INSERT INTO `district` VALUES ('929', '铁西', '159', 't', 'tx', 'tiexi', '', '区', '210106', '024', '5');
INSERT INTO `district` VALUES ('930', '苏家屯', '159', 's', 'sjt', 'sujiatun', '', '区', '210111', '024', '6');
INSERT INTO `district` VALUES ('931', '浑南', '159', 'h', 'hn', 'hunnan', '', '区', '210112', '024', '7');
INSERT INTO `district` VALUES ('932', '沈北新区', '159', 's', 'sbxq', 'shenbeixinqu', '', '', '210113', '024', '8');
INSERT INTO `district` VALUES ('933', '于洪', '159', 'y', 'yh', 'yuhong', '', '区', '210114', '024', '9');
INSERT INTO `district` VALUES ('934', '辽中', '159', 'l', 'lz', 'liaozhong', '', '区', '210122', '024', '10');
INSERT INTO `district` VALUES ('935', '康平', '159', 'k', 'kp', 'kangping', '', '县', '210123', '024', '11');
INSERT INTO `district` VALUES ('936', '法库', '159', 'f', 'fk', 'faku', '', '县', '210124', '024', '12');
INSERT INTO `district` VALUES ('937', '新民', '159', 'x', 'xm', 'xinmin', '', '市', '210181', '024', '13');
INSERT INTO `district` VALUES ('938', '中山', '160', 'z', 'zs', 'zhongshan', '', '区', '210202', '0411', '1');
INSERT INTO `district` VALUES ('939', '西岗', '160', 'x', 'xg', 'xigang', '', '区', '210203', '0411', '2');
INSERT INTO `district` VALUES ('940', '沙河口', '160', 's', 'shk', 'shahekou', '', '区', '210204', '0411', '3');
INSERT INTO `district` VALUES ('941', '甘井子', '160', 'g', 'gjz', 'ganjingzi', '', '区', '210211', '0411', '4');
INSERT INTO `district` VALUES ('942', '旅顺口', '160', 'l', 'lsk', 'lu:shunkou', '', '区', '210212', '0411', '5');
INSERT INTO `district` VALUES ('943', '金州', '160', 'j', 'jz', 'jinzhou', '', '区', '210213', '0411', '6');
INSERT INTO `district` VALUES ('944', '长海', '160', 'z', 'zh', 'zhanghai', '', '县', '210224', '0411', '7');
INSERT INTO `district` VALUES ('945', '瓦房店', '160', 'w', 'wfd', 'wafangdian', '', '市', '210281', '0411', '8');
INSERT INTO `district` VALUES ('946', '普兰店', '160', 'p', 'pld', 'pulandian', '', '区', '210282', '0411', '9');
INSERT INTO `district` VALUES ('947', '庄河', '160', 'z', 'zh', 'zhuanghe', '', '市', '210283', '0411', '10');
INSERT INTO `district` VALUES ('948', '铁东', '161', 't', 'td', 'tiedong', '', '区', '210302', '0412', '1');
INSERT INTO `district` VALUES ('949', '铁西', '161', 't', 'tx', 'tiexi', '', '区', '210303', '0412', '2');
INSERT INTO `district` VALUES ('950', '立山', '161', 'l', 'ls', 'lishan', '', '区', '210304', '0412', '3');
INSERT INTO `district` VALUES ('951', '千山', '161', 'q', 'qs', 'qianshan', '', '区', '210311', '0412', '4');
INSERT INTO `district` VALUES ('952', '台安', '161', 't', 'ta', 'taian', '', '县', '210321', '0412', '5');
INSERT INTO `district` VALUES ('953', '岫岩', '161', 'x', 'xy', 'xiuyan', '满族', '自治县', '210323', '0412', '6');
INSERT INTO `district` VALUES ('954', '海城', '161', 'h', 'hc', 'haicheng', '', '市', '210381', '0412', '7');
INSERT INTO `district` VALUES ('955', '新抚', '162', 'x', 'xf', 'xinfu', '', '区', '210402', '0413', '1');
INSERT INTO `district` VALUES ('956', '东洲', '162', 'd', 'dz', 'dongzhou', '', '区', '210403', '0413', '2');
INSERT INTO `district` VALUES ('957', '望花', '162', 'w', 'wh', 'wanghua', '', '区', '210404', '0413', '3');
INSERT INTO `district` VALUES ('958', '顺城', '162', 's', 'sc', 'shuncheng', '', '区', '210411', '0413', '4');
INSERT INTO `district` VALUES ('959', '抚顺', '162', 'f', 'fs', 'fushun', '', '县', '210421', '0413', '5');
INSERT INTO `district` VALUES ('960', '新宾', '162', 'x', 'xb', 'xinbin', '满族', '自治县', '210422', '0413', '6');
INSERT INTO `district` VALUES ('961', '清原', '162', 'q', 'qy', 'qingyuan', '满族', '自治县', '210423', '0413', '7');
INSERT INTO `district` VALUES ('962', '平山', '163', 'p', 'ps', 'pingshan', '', '区', '210502', '0414', '1');
INSERT INTO `district` VALUES ('963', '溪湖', '163', 'x', 'xh', 'xihu', '', '区', '210503', '0414', '2');
INSERT INTO `district` VALUES ('964', '明山', '163', 'm', 'ms', 'mingshan', '', '区', '210504', '0414', '3');
INSERT INTO `district` VALUES ('965', '南芬', '163', 'n', 'nf', 'nanfen', '', '区', '210505', '0414', '4');
INSERT INTO `district` VALUES ('966', '本溪', '163', 'b', 'bx', 'benxi', '满族', '自治县', '210521', '0414', '5');
INSERT INTO `district` VALUES ('967', '桓仁', '163', 'h', 'hr', 'huanren', '满族', '自治县', '210522', '0414', '6');
INSERT INTO `district` VALUES ('968', '元宝', '164', 'y', 'yb', 'yuanbao', '', '区', '210602', '0415', '1');
INSERT INTO `district` VALUES ('969', '振兴', '164', 'z', 'zx', 'zhenxing', '', '区', '210603', '0415', '2');
INSERT INTO `district` VALUES ('970', '振安', '164', 'z', 'za', 'zhenan', '', '区', '210604', '0415', '3');
INSERT INTO `district` VALUES ('971', '宽甸', '164', 'k', 'kd', 'kuandian', '满族', '自治县', '210624', '0415', '4');
INSERT INTO `district` VALUES ('972', '东港', '164', 'd', 'dg', 'donggang', '', '市', '210681', '0415', '5');
INSERT INTO `district` VALUES ('973', '凤城', '164', 'f', 'fc', 'fengcheng', '', '市', '210682', '0415', '6');
INSERT INTO `district` VALUES ('974', '古塔', '165', 'g', 'gt', 'guta', '', '区', '210702', '0416', '1');
INSERT INTO `district` VALUES ('975', '凌河', '165', 'l', 'lh', 'linghe', '', '区', '210703', '0416', '2');
INSERT INTO `district` VALUES ('976', '太和', '165', 't', 'th', 'taihe', '', '区', '210711', '0416', '3');
INSERT INTO `district` VALUES ('977', '黑山', '165', 'h', 'hs', 'heishan', '', '县', '210726', '0416', '4');
INSERT INTO `district` VALUES ('978', '义县', '165', 'y', 'yx', 'yixian', '', '', '210727', '0416', '5');
INSERT INTO `district` VALUES ('979', '凌海', '165', 'l', 'lh', 'linghai', '', '市', '210781', '0416', '6');
INSERT INTO `district` VALUES ('980', '北镇', '165', 'b', 'bz', 'beizhen', '', '市', '210782', '0416', '7');
INSERT INTO `district` VALUES ('981', '站前', '166', 'z', 'zq', 'zhanqian', '', '区', '210802', '0417', '1');
INSERT INTO `district` VALUES ('982', '西市', '166', 'x', 'xs', 'xishi', '', '区', '210803', '0417', '2');
INSERT INTO `district` VALUES ('983', '鲅鱼圈', '166', 'b', 'byq', 'bayuquan', '', '区', '210804', '0417', '3');
INSERT INTO `district` VALUES ('984', '老边', '166', 'l', 'lb', 'laobian', '', '区', '210811', '0417', '4');
INSERT INTO `district` VALUES ('985', '盖州', '166', 'g', 'gz', 'gaizhou', '', '市', '210881', '0417', '5');
INSERT INTO `district` VALUES ('986', '大石桥', '166', 'd', 'dsq', 'dashiqiao', '', '市', '210882', '0417', '6');
INSERT INTO `district` VALUES ('987', '海州', '167', 'h', 'hz', 'haizhou', '', '区', '210902', '0418', '1');
INSERT INTO `district` VALUES ('988', '新邱', '167', 'x', 'xq', 'xinqiu', '', '区', '210903', '0418', '2');
INSERT INTO `district` VALUES ('989', '太平', '167', 't', 'tp', 'taiping', '', '区', '210904', '0418', '3');
INSERT INTO `district` VALUES ('990', '清河门', '167', 'q', 'qhm', 'qinghemen', '', '区', '210905', '0418', '4');
INSERT INTO `district` VALUES ('991', '细河', '167', 'x', 'xh', 'xihe', '', '区', '210911', '0418', '5');
INSERT INTO `district` VALUES ('992', '阜新', '167', 'f', 'fx', 'fuxin', '蒙古族', '自治县', '210921', '0418', '6');
INSERT INTO `district` VALUES ('993', '彰武', '167', 'z', 'zw', 'zhangwu', '', '县', '210922', '0418', '7');
INSERT INTO `district` VALUES ('994', '白塔', '168', 'b', 'bt', 'baita', '', '区', '211002', '0419', '1');
INSERT INTO `district` VALUES ('995', '文圣', '168', 'w', 'ws', 'wensheng', '', '区', '211003', '0419', '2');
INSERT INTO `district` VALUES ('996', '宏伟', '168', 'h', 'hw', 'hongwei', '', '区', '211004', '0419', '3');
INSERT INTO `district` VALUES ('997', '弓长岭', '168', 'g', 'gzl', 'gongzhangling', '', '区', '211005', '0419', '4');
INSERT INTO `district` VALUES ('998', '辽阳', '168', 'l', 'ly', 'liaoyang', '', '县', '211021', '0419', '5');
INSERT INTO `district` VALUES ('999', '灯塔', '168', 'd', 'dt', 'dengta', '', '市', '211081', '0419', '6');
INSERT INTO `district` VALUES ('1000', '太子河', '168', 't', 'tzh', 'taizihe', '', '区', '211110', '0419', '7');
INSERT INTO `district` VALUES ('1001', '双台子', '169', 's', 'stz', 'shuangtaizi', '', '区', '211103', '0427', '1');
INSERT INTO `district` VALUES ('1002', '兴隆台', '169', 'x', 'xlt', 'xinglongtai', '', '区', '211103', '0427', '2');
INSERT INTO `district` VALUES ('1003', '大洼', '169', 'd', 'dw', 'dawa', '', '区', '211121', '0427', '3');
INSERT INTO `district` VALUES ('1004', '盘山', '169', 'p', 'ps', 'panshan', '', '县', '211122', '0427', '4');
INSERT INTO `district` VALUES ('1005', '银州', '170', 'y', 'yz', 'yinzhou', '', '区', '211202', '0410', '1');
INSERT INTO `district` VALUES ('1006', '清河', '170', 'q', 'qh', 'qinghe', '', '区', '211204', '0410', '2');
INSERT INTO `district` VALUES ('1007', '铁岭', '170', 't', 'tl', 'tieling', '', '县', '211221', '0410', '3');
INSERT INTO `district` VALUES ('1008', '西丰', '170', 'x', 'xf', 'xifeng', '', '县', '211223', '0410', '4');
INSERT INTO `district` VALUES ('1009', '昌图', '170', 'c', 'ct', 'changtu', '', '县', '211224', '0410', '5');
INSERT INTO `district` VALUES ('1010', '调兵山', '170', 'd', 'dbs', 'diaobingshan', '', '市', '211281', '0410', '6');
INSERT INTO `district` VALUES ('1011', '开原', '170', 'k', 'ky', 'kaiyuan', '', '市', '211282', '0410', '7');
INSERT INTO `district` VALUES ('1012', '双塔', '171', 's', 'st', 'shuangta', '', '区', '211302', '0421', '1');
INSERT INTO `district` VALUES ('1013', '龙城', '171', 'l', 'lc', 'longcheng', '', '区', '211303', '0421', '2');
INSERT INTO `district` VALUES ('1014', '朝阳', '171', 'c', 'cy', 'chaoyang', '', '县', '211321', '0421', '3');
INSERT INTO `district` VALUES ('1015', '建平', '171', 'j', 'jp', 'jianping', '', '县', '211322', '0421', '4');
INSERT INTO `district` VALUES ('1016', '喀喇沁左翼', '171', 'k', 'klqzy', 'kalaqinzuoyi', '蒙古族', '自治县', '211324', '0421', '5');
INSERT INTO `district` VALUES ('1017', '北票', '171', 'b', 'bp', 'beipiao', '', '市', '211381', '0421', '6');
INSERT INTO `district` VALUES ('1018', '凌源', '171', 'l', 'ly', 'lingyuan', '', '市', '211382', '0421', '7');
INSERT INTO `district` VALUES ('1019', '连山', '172', 'l', 'ls', 'lianshan', '', '区', '211402', '0429', '1');
INSERT INTO `district` VALUES ('1020', '龙港', '172', 'l', 'lg', 'longgang', '', '区', '211403', '0429', '2');
INSERT INTO `district` VALUES ('1021', '南票', '172', 'n', 'np', 'nanpiao', '', '区', '211404', '0429', '3');
INSERT INTO `district` VALUES ('1022', '绥中', '172', 's', 'sz', 'suizhong', '', '县', '211421', '0429', '4');
INSERT INTO `district` VALUES ('1023', '建昌', '172', 'j', 'jc', 'jianchang', '', '县', '211422', '0429', '5');
INSERT INTO `district` VALUES ('1024', '兴城', '172', 'x', 'xc', 'xingcheng', '', '市', '211481', '0429', '6');
INSERT INTO `district` VALUES ('1025', '南关', '173', 'n', 'ng', 'nanguan', '', '区', '220102', '0431', '1');
INSERT INTO `district` VALUES ('1026', '宽城', '173', 'k', 'kc', 'kuancheng', '', '区', '220103', '0431', '2');
INSERT INTO `district` VALUES ('1027', '朝阳', '173', 'c', 'cy', 'chaoyang', '', '区', '220104', '0431', '3');
INSERT INTO `district` VALUES ('1028', '二道', '173', 'e', 'ed', 'erdao', '', '区', '220105', '0431', '4');
INSERT INTO `district` VALUES ('1029', '绿园', '173', 'l', 'ly', 'lu:yuan', '', '区', '220106', '0431', '5');
INSERT INTO `district` VALUES ('1030', '双阳', '173', 's', 'sy', 'shuangyang', '', '区', '220112', '0431', '6');
INSERT INTO `district` VALUES ('1031', '农安', '173', 'n', 'na', 'nongan', '', '县', '220122', '0431', '8');
INSERT INTO `district` VALUES ('1032', '九台', '173', 'j', 'jt', 'jiutai', '', '区', '220113', '0431', '7');
INSERT INTO `district` VALUES ('1033', '榆树', '173', 'y', 'ys', 'yushu', '', '市', '220182', '0431', '9');
INSERT INTO `district` VALUES ('1034', '德惠', '173', 'd', 'dh', 'dehui', '', '市', '220183', '0431', '10');
INSERT INTO `district` VALUES ('1035', '昌邑', '174', 'c', 'cy', 'changyi', '', '区', '220202', '0432', '1');
INSERT INTO `district` VALUES ('1036', '龙潭', '174', 'l', 'lt', 'longtan', '', '区', '220203', '0432', '2');
INSERT INTO `district` VALUES ('1037', '船营', '174', 'c', 'cy', 'chuanying', '', '区', '220204', '0432', '3');
INSERT INTO `district` VALUES ('1038', '丰满', '174', 'f', 'fm', 'fengman', '', '区', '220211', '0432', '4');
INSERT INTO `district` VALUES ('1039', '永吉', '174', 'y', 'yj', 'yongji', '', '县', '220221', '0432', '5');
INSERT INTO `district` VALUES ('1040', '桦甸', '174', 'h', 'hd', 'huadian', '', '市', '220281', '0432', '6');
INSERT INTO `district` VALUES ('1041', '蛟河', '174', 'j', 'jh', 'jiaohe', '', '市', '220282', '0432', '7');
INSERT INTO `district` VALUES ('1042', '舒兰', '174', 's', 'sl', 'shulan', '', '市', '220283', '0432', '8');
INSERT INTO `district` VALUES ('1043', '磐石', '174', 'p', 'ps', 'panshi', '', '市', '220284', '0432', '9');
INSERT INTO `district` VALUES ('1044', '铁西', '175', 't', 'tx', 'tiexi', '', '区', '220302', '0434', '1');
INSERT INTO `district` VALUES ('1045', '铁东', '175', 't', 'td', 'tiedong', '', '区', '220303', '0434', '2');
INSERT INTO `district` VALUES ('1046', '梨树', '175', 'l', 'ls', 'lishu', '', '县', '220322', '0434', '3');
INSERT INTO `district` VALUES ('1047', '伊通', '175', 'y', 'yt', 'yitong', '满族', '自治县', '220323', '0434', '4');
INSERT INTO `district` VALUES ('1048', '公主岭', '175', 'g', 'gzl', 'gongzhuling', '', '市', '220381', '0434', '5');
INSERT INTO `district` VALUES ('1049', '双辽', '175', 's', 'sl', 'shuangliao', '', '市', '220382', '0434', '6');
INSERT INTO `district` VALUES ('1050', '龙山', '176', 'l', 'ls', 'longshan', '', '区', '220402', '0437', '1');
INSERT INTO `district` VALUES ('1051', '西安', '176', 'x', 'xa', 'xian', '', '区', '220403', '0437', '2');
INSERT INTO `district` VALUES ('1052', '东丰', '176', 'd', 'df', 'dongfeng', '', '县', '220421', '0437', '3');
INSERT INTO `district` VALUES ('1053', '东辽', '176', 'd', 'dl', 'dongliao', '', '县', '220422', '0437', '4');
INSERT INTO `district` VALUES ('1054', '东昌', '177', 'd', 'dc', 'dongchang', '', '区', '220502', '0435', '1');
INSERT INTO `district` VALUES ('1055', '二道江', '177', 'e', 'edj', 'erdaojiang', '', '区', '220503', '0435', '2');
INSERT INTO `district` VALUES ('1056', '通化', '177', 't', 'th', 'tonghua', '', '县', '220521', '0435', '3');
INSERT INTO `district` VALUES ('1057', '辉南', '177', 'h', 'hn', 'huinan', '', '县', '220523', '0435', '4');
INSERT INTO `district` VALUES ('1058', '柳河', '177', 'l', 'lh', 'liuhe', '', '县', '220524', '0435', '5');
INSERT INTO `district` VALUES ('1059', '梅河口', '177', 'm', 'mhk', 'meihekou', '', '市', '220581', '0435', '6');
INSERT INTO `district` VALUES ('1060', '集安', '177', 'j', 'ja', 'jian', '', '市', '220582', '0435', '7');
INSERT INTO `district` VALUES ('1061', '浑江', '178', 'h', 'hj', 'hunjiang', '', '区', '220602', '0439', '1');
INSERT INTO `district` VALUES ('1062', '江源', '178', 'j', 'jy', 'jiangyuan', '', '区', '220604', '0439', '2');
INSERT INTO `district` VALUES ('1063', '抚松', '178', 'f', 'fs', 'fusong', '', '县', '220621', '0439', '3');
INSERT INTO `district` VALUES ('1064', '靖宇', '178', 'j', 'jy', 'jingyu', '', '县', '220622', '0439', '4');
INSERT INTO `district` VALUES ('1065', '长白', '178', 'z', 'zb', 'zhangbai', '朝鲜族', '自治县', '220623', '0439', '5');
INSERT INTO `district` VALUES ('1066', '临江', '178', 'l', 'lj', 'linjiang', '', '市', '220681', '0439', '6');
INSERT INTO `district` VALUES ('1067', '宁江', '179', 'n', 'nj', 'ningjiang', '', '区', '220702', '0438', '1');
INSERT INTO `district` VALUES ('1068', '前郭尔罗斯', '179', 'q', 'qgels', 'qianguoerluosi', '蒙古族', '自治县', '220721', '0438', '2');
INSERT INTO `district` VALUES ('1069', '长岭', '179', 'z', 'zl', 'zhangling', '', '县', '220722', '0438', '3');
INSERT INTO `district` VALUES ('1070', '乾安', '179', 'q', 'qa', 'qianan', '', '县', '220723', '0438', '4');
INSERT INTO `district` VALUES ('1071', '扶余', '179', 'f', 'fy', 'fuyu', '', '市', '220724', '0438', '5');
INSERT INTO `district` VALUES ('1072', '洮北', '180', 't', 'tb', 'taobei', '', '区', '220802', '0436', '1');
INSERT INTO `district` VALUES ('1073', '镇赉', '180', 'z', 'zl', 'zhenlai', '', '县', '220821', '0436', '2');
INSERT INTO `district` VALUES ('1074', '洮南', '180', 't', 'tn', 'taonan', '', '市', '220881', '0436', '4');
INSERT INTO `district` VALUES ('1075', '大安', '180', 'd', 'da', 'daan', '', '市', '220882', '0436', '5');
INSERT INTO `district` VALUES ('1076', '通榆', '180', 't', 'ty', 'tongyu', '', '县', '220822', '0436', '3');
INSERT INTO `district` VALUES ('1077', '延吉', '181', 'y', 'yj', 'yanji', '', '市', '222401', '0433', '1');
INSERT INTO `district` VALUES ('1078', '图们', '181', 't', 'tm', 'tumen', '', '市', '222402', '0433', '2');
INSERT INTO `district` VALUES ('1079', '敦化', '181', 'd', 'dh', 'dunhua', '', '市', '222403', '0433', '3');
INSERT INTO `district` VALUES ('1080', '珲春', '181', 'h', 'hc', 'hunchun', '', '市', '222404', '0433', '4');
INSERT INTO `district` VALUES ('1081', '龙井', '181', 'l', 'lj', 'longjing', '', '市', '222405', '0433', '5');
INSERT INTO `district` VALUES ('1082', '和龙', '181', 'h', 'hl', 'helong', '', '市', '222406', '0433', '6');
INSERT INTO `district` VALUES ('1083', '汪清', '181', 'w', 'wq', 'wangqing', '', '县', '222424', '0433', '7');
INSERT INTO `district` VALUES ('1084', '安图', '181', 'a', 'at', 'antu', '', '县', '222426', '0433', '8');
INSERT INTO `district` VALUES ('1085', '道里', '182', 'd', 'dl', 'daoli', '', '区', '230102', '0451', '1');
INSERT INTO `district` VALUES ('1086', '南岗', '182', 'n', 'ng', 'nangang', '', '区', '230103', '0451', '2');
INSERT INTO `district` VALUES ('1087', '道外', '182', 'd', 'dw', 'daowai', '', '区', '230104', '0451', '3');
INSERT INTO `district` VALUES ('1088', '平房', '182', 'p', 'pf', 'pingfang', '', '区', '230108', '0451', '4');
INSERT INTO `district` VALUES ('1089', '松北', '182', 's', 'sb', 'songbei', '', '区', '230109', '0451', '5');
INSERT INTO `district` VALUES ('1090', '香坊', '182', 'x', 'xf', 'xiangfang', '', '区', '230110', '0451', '6');
INSERT INTO `district` VALUES ('1091', '呼兰', '182', 'h', 'hl', 'hulan', '', '区', '230111', '0451', '7');
INSERT INTO `district` VALUES ('1092', '阿城', '182', 'a', 'ac', 'acheng', '', '区', '230112', '0451', '8');
INSERT INTO `district` VALUES ('1093', '依兰', '182', 'y', 'yl', 'yilan', '', '县', '230123', '0451', '9');
INSERT INTO `district` VALUES ('1094', '方正', '182', 'f', 'fz', 'fangzheng', '', '县', '230124', '0451', '10');
INSERT INTO `district` VALUES ('1095', '宾县', '182', 'b', 'bx', 'binxian', '', '', '230125', '0451', '11');
INSERT INTO `district` VALUES ('1096', '巴彦', '182', 'b', 'by', 'bayan', '', '县', '230126', '0451', '12');
INSERT INTO `district` VALUES ('1097', '木兰', '182', 'm', 'ml', 'mulan', '', '县', '230127', '0451', '13');
INSERT INTO `district` VALUES ('1098', '通河', '182', 't', 'th', 'tonghe', '', '县', '230128', '0451', '14');
INSERT INTO `district` VALUES ('1099', '延寿', '182', 'y', 'ys', 'yanshou', '', '县', '230129', '0451', '15');
INSERT INTO `district` VALUES ('1100', '双城', '182', 's', 'sc', 'shuangcheng', '', '区', '230182', '0451', '16');
INSERT INTO `district` VALUES ('1101', '尚志', '182', 's', 'sz', 'shangzhi', '', '市', '230183', '0451', '17');
INSERT INTO `district` VALUES ('1102', '五常', '182', 'w', 'wc', 'wuchang', '', '市', '230184', '0451', '18');
INSERT INTO `district` VALUES ('1103', '龙沙', '183', 'l', 'ls', 'longsha', '', '区', '230202', '0452', '1');
INSERT INTO `district` VALUES ('1104', '建华', '183', 'j', 'jh', 'jianhua', '', '区', '230203', '0452', '2');
INSERT INTO `district` VALUES ('1105', '铁锋', '183', 't', 'tf', 'tiefeng', '', '区', '230204', '0452', '3');
INSERT INTO `district` VALUES ('1106', '昂昂溪', '183', 'a', 'aax', 'angangxi', '', '区', '230205', '0452', '4');
INSERT INTO `district` VALUES ('1107', '富拉尔基', '183', 'f', 'flej', 'fulaerji', '', '区', '230206', '0452', '5');
INSERT INTO `district` VALUES ('1108', '碾子山', '183', 'n', 'nzs', 'nianzishan', '', '区', '230207', '0452', '6');
INSERT INTO `district` VALUES ('1109', '梅里斯', '183', 'm', 'mls', 'meilisi', '达斡尔族', '区', '230208', '0452', '7');
INSERT INTO `district` VALUES ('1110', '龙江', '183', 'l', 'lj', 'longjiang', '', '县', '230221', '0452', '8');
INSERT INTO `district` VALUES ('1111', '依安', '183', 'y', 'ya', 'yian', '', '县', '230223', '0452', '9');
INSERT INTO `district` VALUES ('1112', '泰来', '183', 't', 'tl', 'tailai', '', '县', '230224', '0452', '10');
INSERT INTO `district` VALUES ('1113', '甘南', '183', 'g', 'gn', 'gannan', '', '县', '230225', '0452', '11');
INSERT INTO `district` VALUES ('1114', '富裕', '183', 'f', 'fy', 'fuyu', '', '县', '230227', '0452', '12');
INSERT INTO `district` VALUES ('1115', '克山', '183', 'k', 'ks', 'keshan', '', '县', '230229', '0452', '13');
INSERT INTO `district` VALUES ('1116', '克东', '183', 'k', 'kd', 'kedong', '', '县', '230230', '0452', '14');
INSERT INTO `district` VALUES ('1117', '拜泉', '183', 'b', 'bq', 'baiquan', '', '县', '230231', '0452', '15');
INSERT INTO `district` VALUES ('1118', '讷河', '183', 'n', 'nh', 'nehe', '', '市', '230281', '0452', '16');
INSERT INTO `district` VALUES ('1119', '鸡冠', '184', 'j', 'jg', 'jiguan', '', '区', '230302', '0467', '1');
INSERT INTO `district` VALUES ('1120', '恒山', '184', 'h', 'hs', 'hengshan', '', '区', '230303', '0467', '2');
INSERT INTO `district` VALUES ('1121', '滴道', '184', 'd', 'dd', 'didao', '', '区', '230304', '0467', '3');
INSERT INTO `district` VALUES ('1122', '梨树', '184', 'l', 'ls', 'lishu', '', '区', '230305', '0467', '4');
INSERT INTO `district` VALUES ('1123', '城子河', '184', 'c', 'czh', 'chengzihe', '', '区', '230306', '0467', '5');
INSERT INTO `district` VALUES ('1124', '麻山', '184', 'm', 'ms', 'mashan', '', '区', '230307', '0467', '6');
INSERT INTO `district` VALUES ('1125', '鸡东', '184', 'j', 'jd', 'jidong', '', '县', '230321', '0467', '7');
INSERT INTO `district` VALUES ('1126', '虎林', '184', 'h', 'hl', 'hulin', '', '市', '230381', '0467', '8');
INSERT INTO `district` VALUES ('1127', '密山', '184', 'm', 'ms', 'mishan', '', '市', '230382', '0467', '9');
INSERT INTO `district` VALUES ('1128', '向阳', '185', 'x', 'xy', 'xiangyang', '', '区', '230402', '0468', '1');
INSERT INTO `district` VALUES ('1129', '工农', '185', 'g', 'gn', 'gongnong', '', '区', '230403', '0468', '2');
INSERT INTO `district` VALUES ('1130', '南山', '185', 'n', 'ns', 'nanshan', '', '区', '230404', '0468', '3');
INSERT INTO `district` VALUES ('1131', '兴安', '185', 'x', 'xa', 'xingan', '', '区', '230405', '0468', '4');
INSERT INTO `district` VALUES ('1132', '东山', '185', 'd', 'ds', 'dongshan', '', '区', '230406', '0468', '5');
INSERT INTO `district` VALUES ('1133', '兴山', '185', 'x', 'xs', 'xingshan', '', '区', '230407', '0468', '6');
INSERT INTO `district` VALUES ('1134', '萝北', '185', 'l', 'lb', 'luobei', '', '县', '230421', '0468', '7');
INSERT INTO `district` VALUES ('1135', '绥滨', '185', 's', 'sb', 'suibin', '', '县', '230422', '0468', '8');
INSERT INTO `district` VALUES ('1136', '尖山', '186', 'j', 'js', 'jianshan', '', '区', '230502', '0469', '1');
INSERT INTO `district` VALUES ('1137', '岭东', '186', 'l', 'ld', 'lingdong', '', '区', '230503', '0469', '2');
INSERT INTO `district` VALUES ('1138', '四方台', '186', 's', 'sft', 'sifangtai', '', '区', '230505', '0469', '3');
INSERT INTO `district` VALUES ('1139', '宝山', '186', 'b', 'bs', 'baoshan', '', '区', '230506', '0469', '4');
INSERT INTO `district` VALUES ('1140', '集贤', '186', 'j', 'jx', 'jixian', '', '县', '230521', '0469', '5');
INSERT INTO `district` VALUES ('1141', '友谊', '186', 'y', 'yy', 'youyi', '', '县', '230522', '0469', '6');
INSERT INTO `district` VALUES ('1142', '宝清', '186', 'b', 'bq', 'baoqing', '', '县', '230523', '0469', '7');
INSERT INTO `district` VALUES ('1143', '饶河', '186', 'r', 'rh', 'raohe', '', '县', '230524', '0469', '8');
INSERT INTO `district` VALUES ('1144', '萨尔图', '187', 's', 'set', 'saertu', '', '区', '230602', '0459', '1');
INSERT INTO `district` VALUES ('1145', '龙凤', '187', 'l', 'lf', 'longfeng', '', '区', '230603', '0459', '2');
INSERT INTO `district` VALUES ('1146', '让胡路', '187', 'r', 'rhl', 'ranghulu', '', '区', '230604', '0459', '3');
INSERT INTO `district` VALUES ('1147', '红岗', '187', 'h', 'hg', 'honggang', '', '区', '230605', '0459', '4');
INSERT INTO `district` VALUES ('1148', '大同', '187', 'd', 'dt', 'datong', '', '区', '230606', '0459', '5');
INSERT INTO `district` VALUES ('1149', '肇州', '187', 'z', 'zz', 'zhaozhou', '', '县', '230621', '0459', '6');
INSERT INTO `district` VALUES ('1150', '肇源', '187', 'z', 'zy', 'zhaoyuan', '', '县', '230622', '0459', '7');
INSERT INTO `district` VALUES ('1151', '林甸', '187', 'l', 'ld', 'lindian', '', '县', '230623', '0459', '8');
INSERT INTO `district` VALUES ('1152', '杜尔伯特', '187', 'd', 'debt', 'duerbote', '蒙古族', '自治县', '230624', '0459', '9');
INSERT INTO `district` VALUES ('1153', '伊春', '188', 'y', 'yc', 'yichun', '', '区', '230702', '0458', '1');
INSERT INTO `district` VALUES ('1154', '南岔', '188', 'n', 'nc', 'nancha', '', '区', '230703', '0458', '2');
INSERT INTO `district` VALUES ('1155', '友好', '188', 'y', 'yh', 'youhao', '', '区', '230704', '0458', '3');
INSERT INTO `district` VALUES ('1156', '西林', '188', 'x', 'xl', 'xilin', '', '区', '230705', '0458', '4');
INSERT INTO `district` VALUES ('1157', '翠峦', '188', 'c', 'cl', 'cuiluan', '', '区', '230706', '0458', '5');
INSERT INTO `district` VALUES ('1158', '新青', '188', 'x', 'xq', 'xinqing', '', '区', '230707', '0458', '6');
INSERT INTO `district` VALUES ('1159', '美溪', '188', 'm', 'mx', 'meixi', '', '区', '230708', '0458', '7');
INSERT INTO `district` VALUES ('1160', '金山屯', '188', 'j', 'jst', 'jinshantun', '', '区', '230709', '0458', '8');
INSERT INTO `district` VALUES ('1161', '五营', '188', 'w', 'wy', 'wuying', '', '区', '230710', '0458', '9');
INSERT INTO `district` VALUES ('1162', '乌马河', '188', 'w', 'wmh', 'wumahe', '', '区', '230711', '0458', '10');
INSERT INTO `district` VALUES ('1163', '汤旺河', '188', 't', 'twh', 'tangwanghe', '', '区', '230712', '0458', '11');
INSERT INTO `district` VALUES ('1164', '带岭', '188', 'd', 'dl', 'dailing', '', '区', '230713', '0458', '12');
INSERT INTO `district` VALUES ('1165', '乌伊岭', '188', 'w', 'wyl', 'wuyiling', '', '区', '230714', '0458', '13');
INSERT INTO `district` VALUES ('1166', '红星', '188', 'h', 'hx', 'hongxing', '', '区', '230715', '0458', '14');
INSERT INTO `district` VALUES ('1167', '上甘岭', '188', 's', 'sgl', 'shangganling', '', '区', '230716', '0458', '15');
INSERT INTO `district` VALUES ('1168', '嘉荫', '188', 'j', 'jy', 'jiayin', '', '县', '230722', '0458', '16');
INSERT INTO `district` VALUES ('1169', '铁力', '188', 't', 'tl', 'tieli', '', '市', '230781', '0458', '17');
INSERT INTO `district` VALUES ('1170', '向阳', '189', 'x', 'xy', 'xiangyang', '', '区', '230803', '0454', '1');
INSERT INTO `district` VALUES ('1171', '前进', '189', 'q', 'qj', 'qianjin', '', '区', '230804', '0454', '2');
INSERT INTO `district` VALUES ('1172', '东风', '189', 'd', 'df', 'dongfeng', '', '区', '230805', '0454', '3');
INSERT INTO `district` VALUES ('1173', '郊区', '189', 'j', 'jq', 'jiaoqu', '', '', '230811', '0454', '4');
INSERT INTO `district` VALUES ('1174', '桦南', '189', 'h', 'hn', 'huanan', '', '县', '230822', '0454', '5');
INSERT INTO `district` VALUES ('1175', '桦川', '189', 'h', 'hc', 'huachuan', '', '县', '230826', '0454', '6');
INSERT INTO `district` VALUES ('1176', '汤原', '189', 't', 'ty', 'tangyuan', '', '县', '230828', '0454', '7');
INSERT INTO `district` VALUES ('1177', '抚远', '189', 'f', 'fy', 'fuyuan', '', '市', '230833', '0454', '8');
INSERT INTO `district` VALUES ('1178', '同江', '189', 't', 'tj', 'tongjiang', '', '市', '230881', '0454', '9');
INSERT INTO `district` VALUES ('1179', '富锦', '189', 'f', 'fj', 'fujin', '', '市', '230882', '0454', '10');
INSERT INTO `district` VALUES ('1180', '新兴', '190', 'x', 'xx', 'xinxing', '', '区', '230902', '0464', '1');
INSERT INTO `district` VALUES ('1181', '桃山', '190', 't', 'ts', 'taoshan', '', '区', '230903', '0464', '2');
INSERT INTO `district` VALUES ('1182', '茄子河', '190', 'q', 'qzh', 'qiezihe', '', '区', '230904', '0464', '3');
INSERT INTO `district` VALUES ('1183', '勃利', '190', 'b', 'bl', 'boli', '', '县', '230921', '0464', '4');
INSERT INTO `district` VALUES ('1184', '东安', '191', 'd', 'da', 'dongan', '', '区', '231002', '0453', '1');
INSERT INTO `district` VALUES ('1185', '阳明', '191', 'y', 'ym', 'yangming', '', '区', '231003', '0453', '2');
INSERT INTO `district` VALUES ('1186', '爱民', '191', 'a', 'am', 'aimin', '', '区', '231004', '0453', '3');
INSERT INTO `district` VALUES ('1187', '西安', '191', 'x', 'xa', 'xian', '', '区', '231005', '0453', '4');
INSERT INTO `district` VALUES ('1188', '东宁', '191', 'd', 'dn', 'dongning', '', '市', '231024', '0453', '5');
INSERT INTO `district` VALUES ('1189', '林口', '191', 'l', 'lk', 'linkou', '', '县', '231025', '0453', '6');
INSERT INTO `district` VALUES ('1190', '绥芬河', '191', 's', 'sfh', 'suifenhe', '', '市', '231081', '0453', '7');
INSERT INTO `district` VALUES ('1191', '海林', '191', 'h', 'hl', 'hailin', '', '市', '231083', '0453', '8');
INSERT INTO `district` VALUES ('1192', '宁安', '191', 'n', 'na', 'ningan', '', '市', '231084', '0453', '9');
INSERT INTO `district` VALUES ('1193', '穆棱', '191', 'm', 'ml', 'muleng', '', '市', '231085', '0453', '10');
INSERT INTO `district` VALUES ('1194', '爱辉', '192', 'a', 'ah', 'aihui', '', '区', '231102', '0456', '1');
INSERT INTO `district` VALUES ('1195', '嫩江', '192', 'n', 'nj', 'nenjiang', '', '县', '231121', '0456', '2');
INSERT INTO `district` VALUES ('1196', '逊克', '192', 'x', 'xk', 'xunke', '', '县', '231123', '0456', '3');
INSERT INTO `district` VALUES ('1197', '孙吴', '192', 's', 'sw', 'sunwu', '', '县', '231124', '0456', '4');
INSERT INTO `district` VALUES ('1198', '北安', '192', 'b', 'ba', 'beian', '', '市', '231181', '0456', '5');
INSERT INTO `district` VALUES ('1199', '五大连池', '192', 'w', 'wdlc', 'wudalianchi', '', '市', '231182', '0456', '6');
INSERT INTO `district` VALUES ('1200', '北林', '193', 'b', 'bl', 'beilin', '', '区', '231202', '0455', '1');
INSERT INTO `district` VALUES ('1201', '望奎', '193', 'w', 'wk', 'wangkui', '', '县', '231221', '0455', '2');
INSERT INTO `district` VALUES ('1202', '兰西', '193', 'l', 'lx', 'lanxi', '', '县', '231222', '0455', '3');
INSERT INTO `district` VALUES ('1203', '青冈', '193', 'q', 'qg', 'qinggang', '', '县', '231223', '0455', '4');
INSERT INTO `district` VALUES ('1204', '庆安', '193', 'q', 'qa', 'qingan', '', '县', '231224', '0455', '5');
INSERT INTO `district` VALUES ('1205', '明水', '193', 'm', 'ms', 'mingshui', '', '县', '231225', '0455', '6');
INSERT INTO `district` VALUES ('1206', '绥棱', '193', 's', 'sl', 'suileng', '', '县', '231226', '0455', '7');
INSERT INTO `district` VALUES ('1207', '安达', '193', 'a', 'ad', 'anda', '', '市', '231281', '0455', '8');
INSERT INTO `district` VALUES ('1208', '肇东', '193', 'z', 'zd', 'zhaodong', '', '市', '231282', '0455', '9');
INSERT INTO `district` VALUES ('1209', '海伦', '193', 'h', 'hl', 'hailun', '', '市', '231283', '0455', '10');
INSERT INTO `district` VALUES ('1210', '加格达奇', '194', 'j', 'jgdq', 'jiagedaqi', '', '区', '232701', '0457', '1');
INSERT INTO `district` VALUES ('1211', '松岭', '194', 's', 'sl', 'songling', '', '区', '232702', '0457', '2');
INSERT INTO `district` VALUES ('1212', '新林', '194', 'x', 'xl', 'xinlin', '', '区', '232703', '0457', '3');
INSERT INTO `district` VALUES ('1213', '呼中', '194', 'h', 'hz', 'huzhong', '', '区', '232704', '0457', '4');
INSERT INTO `district` VALUES ('1214', '呼玛', '194', 'h', 'hm', 'huma', '', '县', '232721', '0457', '5');
INSERT INTO `district` VALUES ('1215', '塔河', '194', 't', 'th', 'tahe', '', '县', '232722', '0457', '6');
INSERT INTO `district` VALUES ('1216', '漠河', '194', 'm', 'mh', 'mohe', '', '县', '232723', '0457', '7');
INSERT INTO `district` VALUES ('1217', '玄武', '195', 'x', 'xw', 'xuanwu', '', '区', '320102', '', '1');
INSERT INTO `district` VALUES ('1218', '秦淮', '195', 'q', 'qh', 'qinhuai', '', '区', '320104', '', '2');
INSERT INTO `district` VALUES ('1219', '建邺', '195', 'j', 'jy', 'jianye', '', '区', '320105', '', '3');
INSERT INTO `district` VALUES ('1220', '鼓楼', '195', 'g', 'gl', 'gulou', '', '区', '320106', '', '4');
INSERT INTO `district` VALUES ('1221', '浦口', '195', 'p', 'pk', 'pukou', '', '区', '320111', '', '5');
INSERT INTO `district` VALUES ('1222', '栖霞', '195', 'q', 'qx', 'qixia', '', '区', '320113', '', '6');
INSERT INTO `district` VALUES ('1223', '雨花台', '195', 'y', 'yht', 'yuhuatai', '', '区', '320114', '', '7');
INSERT INTO `district` VALUES ('1224', '江宁', '195', 'j', 'jn', 'jiangning', '', '区', '320115', '', '8');
INSERT INTO `district` VALUES ('1225', '六合', '195', 'l', 'lh', 'liuhe', '', '区', '320116', '', '9');
INSERT INTO `district` VALUES ('1226', '溧水', '195', 'l', 'ls', 'lishui', '', '区', '320124', '', '10');
INSERT INTO `district` VALUES ('1227', '高淳', '195', 'g', 'gc', 'gaochun', '', '区', '320125', '', '11');
INSERT INTO `district` VALUES ('1228', '梁溪', '196', 'l', 'lx', 'liangxi', '', '区', '320202', '0510', '1');
INSERT INTO `district` VALUES ('1229', '新吴', '196', 'x', 'xw', 'xinwu', '', '区', '', '0510', '2');
INSERT INTO `district` VALUES ('1231', '锡山', '196', 'x', 'xs', 'xishan', '', '区', '320205', '0510', '4');
INSERT INTO `district` VALUES ('1232', '惠山', '196', 'h', 'hs', 'huishan', '', '区', '320206', '0510', '5');
INSERT INTO `district` VALUES ('1233', '滨湖', '196', 'b', 'bh', 'binhu', '', '区', '320211', '0510', '6');
INSERT INTO `district` VALUES ('1234', '江阴', '196', 'j', 'jy', 'jiangyin', '', '市', '320281', '0510', '7');
INSERT INTO `district` VALUES ('1235', '宜兴', '196', 'y', 'yx', 'yixing', '', '市', '320282', '0510', '8');
INSERT INTO `district` VALUES ('1236', '鼓楼', '197', 'g', 'gl', 'gulou', '', '区', '320302', '0516', '1');
INSERT INTO `district` VALUES ('1237', '云龙', '197', 'y', 'yl', 'yunlong', '', '区', '320303', '0516', '2');
INSERT INTO `district` VALUES ('1238', '贾汪', '197', 'j', 'jw', 'jiawang', '', '区', '320305', '0516', '3');
INSERT INTO `district` VALUES ('1239', '泉山', '197', 'q', 'qs', 'quanshan', '', '区', '320311', '0516', '4');
INSERT INTO `district` VALUES ('1240', '铜山', '197', 't', 'ts', 'tongshan', '', '区', '320312', '0516', '5');
INSERT INTO `district` VALUES ('1241', '丰县', '197', 'f', 'fx', 'fengxian', '', '', '320321', '0516', '6');
INSERT INTO `district` VALUES ('1242', '沛县', '197', 'p', 'px', 'peixian', '', '', '320322', '0516', '7');
INSERT INTO `district` VALUES ('1243', '睢宁', '197', 's', 'sn', 'suining', '', '县', '320324', '0516', '8');
INSERT INTO `district` VALUES ('1244', '新沂', '197', 'x', 'xy', 'xinyi', '', '市', '320381', '0516', '9');
INSERT INTO `district` VALUES ('1245', '邳州', '197', 'p', 'pz', 'pizhou', '', '市', '320382', '0516', '10');
INSERT INTO `district` VALUES ('1246', '天宁', '198', 't', 'tn', 'tianning', '', '区', '320402', '0519', '1');
INSERT INTO `district` VALUES ('1247', '钟楼', '198', 'z', 'zl', 'zhonglou', '', '区', '320404', '0519', '2');
INSERT INTO `district` VALUES ('1249', '新北', '198', 'x', 'xb', 'xinbei', '', '区', '320411', '0519', '4');
INSERT INTO `district` VALUES ('1250', '武进', '198', 'w', 'wj', 'wujin', '', '区', '320412', '0519', '5');
INSERT INTO `district` VALUES ('1251', '溧阳', '198', 'l', 'ly', 'liyang', '', '市', '320481', '0519', '6');
INSERT INTO `district` VALUES ('1252', '金坛', '198', 'j', 'jt', 'jintan', '', '区', '320482', '0519', '7');
INSERT INTO `district` VALUES ('1253', '虎丘', '199', 'h', 'hq', 'huqiu', '', '区', '320505', '0512', '1');
INSERT INTO `district` VALUES ('1254', '吴中', '199', 'w', 'wz', 'wuzhong', '', '区', '320506', '0512', '2');
INSERT INTO `district` VALUES ('1255', '相城', '199', 'x', 'xc', 'xiangcheng', '', '区', '320507', '0512', '3');
INSERT INTO `district` VALUES ('1256', '姑苏', '199', 'g', 'gs', 'gusu', '', '区', '320508', '0512', '4');
INSERT INTO `district` VALUES ('1257', '吴江', '199', 'w', 'wj', 'wujiang', '', '市', '320509', '0512', '5');
INSERT INTO `district` VALUES ('1258', '常熟', '199', 'c', 'cs', 'changshu', '', '市', '320581', '0512', '6');
INSERT INTO `district` VALUES ('1259', '张家港', '199', 'z', 'zjg', 'zhangjiagang', '', '市', '320582', '0512', '7');
INSERT INTO `district` VALUES ('1260', '昆山', '199', 'k', 'ks', 'kunshan', '', '市', '320583', '0512', '8');
INSERT INTO `district` VALUES ('1261', '太仓', '199', 't', 'tc', 'taicang', '', '市', '320585', '0512', '9');
INSERT INTO `district` VALUES ('1262', '崇川', '200', 'c', 'cc', 'chongchuan', '', '区', '320602', '0513', '1');
INSERT INTO `district` VALUES ('1263', '港闸', '200', 'g', 'gz', 'gangzha', '', '区', '320611', '0513', '2');
INSERT INTO `district` VALUES ('1264', '通州', '200', 't', 'tz', 'tongzhou', '', '区', '320612', '0513', '3');
INSERT INTO `district` VALUES ('1265', '海安', '200', 'h', 'ha', 'haian', '', '县', '320621', '0513', '4');
INSERT INTO `district` VALUES ('1266', '如东', '200', 'r', 'rd', 'rudong', '', '县', '320623', '0513', '5');
INSERT INTO `district` VALUES ('1267', '启东', '200', 'q', 'qd', 'qidong', '', '市', '320681', '0513', '6');
INSERT INTO `district` VALUES ('1268', '如皋', '200', 'r', 'rg', 'rugao', '', '市', '320682', '0513', '7');
INSERT INTO `district` VALUES ('1269', '海门', '200', 'h', 'hm', 'haimen', '', '市', '320684', '0513', '8');
INSERT INTO `district` VALUES ('1270', '连云', '201', 'l', 'ly', 'lianyun', '', '区', '320703', '0518', '1');
INSERT INTO `district` VALUES ('1272', '海州', '201', 'h', 'hz', 'haizhou', '', '区', '320706', '0518', '2');
INSERT INTO `district` VALUES ('1273', '赣榆', '201', 'g', 'gy', 'ganyu', '', '区', '320721', '0518', '3');
INSERT INTO `district` VALUES ('1274', '东海', '201', 'd', 'dh', 'donghai', '', '县', '320722', '0518', '4');
INSERT INTO `district` VALUES ('1275', '灌云', '201', 'g', 'gy', 'guanyun', '', '县', '320723', '0518', '5');
INSERT INTO `district` VALUES ('1276', '灌南', '201', 'g', 'gn', 'guannan', '', '县', '320724', '0518', '6');
INSERT INTO `district` VALUES ('1277', '清河', '202', 'q', 'qh', 'qinghe', '', '区', '320802', '0517', '1');
INSERT INTO `district` VALUES ('1278', '淮安', '202', 'h', 'ha', 'huaian', '', '区', '320803', '0517', '2');
INSERT INTO `district` VALUES ('1279', '淮阴', '202', 'h', 'hy', 'huaiyin', '', '区', '320804', '0517', '3');
INSERT INTO `district` VALUES ('1280', '清浦', '202', 'q', 'qp', 'qingpu', '', '区', '320811', '0517', '4');
INSERT INTO `district` VALUES ('1281', '涟水', '202', 'l', 'ls', 'lianshui', '', '县', '320826', '0517', '5');
INSERT INTO `district` VALUES ('1282', '洪泽', '202', 'h', 'hz', 'hongze', '', '县', '320829', '0517', '6');
INSERT INTO `district` VALUES ('1283', '盱眙', '202', 'x', 'xy', 'xuyi', '', '县', '320830', '0517', '7');
INSERT INTO `district` VALUES ('1284', '金湖', '202', 'j', 'jh', 'jinhu', '', '县', '320831', '0517', '8');
INSERT INTO `district` VALUES ('1285', '亭湖', '203', 't', 'th', 'tinghu', '', '区', '320902', '0515', '1');
INSERT INTO `district` VALUES ('1286', '盐都', '203', 'y', 'yd', 'yandou', '', '区', '320903', '0515', '2');
INSERT INTO `district` VALUES ('1287', '响水', '203', 'x', 'xs', 'xiangshui', '', '县', '320921', '0515', '3');
INSERT INTO `district` VALUES ('1288', '滨海', '203', 'b', 'bh', 'binhai', '', '县', '320922', '0515', '4');
INSERT INTO `district` VALUES ('1289', '阜宁', '203', 'f', 'fn', 'funing', '', '县', '320923', '0515', '5');
INSERT INTO `district` VALUES ('1290', '射阳', '203', 's', 'sy', 'sheyang', '', '县', '320924', '0515', '6');
INSERT INTO `district` VALUES ('1291', '建湖', '203', 'j', 'jh', 'jianhu', '', '县', '320925', '0515', '7');
INSERT INTO `district` VALUES ('1292', '东台', '203', 'd', 'dt', 'dongtai', '', '市', '320981', '0515', '8');
INSERT INTO `district` VALUES ('1293', '大丰', '203', 'd', 'df', 'dafeng', '', '区', '320982', '0515', '9');
INSERT INTO `district` VALUES ('1294', '广陵', '204', 'g', 'gl', 'guangling', '', '区', '321002', '0514', '1');
INSERT INTO `district` VALUES ('1295', '邗江', '204', 'h', 'hj', 'hanjiang', '', '区', '321003', '0514', '2');
INSERT INTO `district` VALUES ('1296', '江都', '204', 'j', 'jd', 'jiangdou', '', '区', '321012', '0514', '3');
INSERT INTO `district` VALUES ('1297', '宝应', '204', 'b', 'by', 'baoying', '', '县', '321023', '0514', '4');
INSERT INTO `district` VALUES ('1298', '仪征', '204', 'y', 'yz', 'yizheng', '', '市', '321081', '0514', '5');
INSERT INTO `district` VALUES ('1299', '高邮', '204', 'g', 'gy', 'gaoyou', '', '市', '321084', '0514', '6');
INSERT INTO `district` VALUES ('1300', '京口', '205', 'j', 'jk', 'jingkou', '', '区', '321102', '0511', '1');
INSERT INTO `district` VALUES ('1301', '润州', '205', 'r', 'rz', 'runzhou', '', '区', '321111', '0511', '2');
INSERT INTO `district` VALUES ('1302', '丹徒', '205', 'd', 'dt', 'dantu', '', '区', '321112', '0511', '3');
INSERT INTO `district` VALUES ('1303', '丹阳', '205', 'd', 'dy', 'danyang', '', '市', '321181', '0511', '4');
INSERT INTO `district` VALUES ('1304', '扬中', '205', 'y', 'yz', 'yangzhong', '', '市', '321182', '0511', '5');
INSERT INTO `district` VALUES ('1305', '句容', '205', 'j', 'jr', 'jurong', '', '市', '321183', '0511', '6');
INSERT INTO `district` VALUES ('1306', '海陵', '206', 'h', 'hl', 'hailing', '', '区', '321202', '0523', '1');
INSERT INTO `district` VALUES ('1307', '高港', '206', 'g', 'gg', 'gaogang', '', '区', '321203', '0523', '2');
INSERT INTO `district` VALUES ('1308', '兴化', '206', 'x', 'xh', 'xinghua', '', '市', '321281', '0523', '3');
INSERT INTO `district` VALUES ('1309', '靖江', '206', 'j', 'jj', 'jingjiang', '', '市', '321282', '0523', '4');
INSERT INTO `district` VALUES ('1310', '泰兴', '206', 't', 'tx', 'taixing', '', '市', '321283', '0523', '5');
INSERT INTO `district` VALUES ('1311', '姜堰', '206', 'j', 'jy', 'jiangyan', '', '区', '321284', '0523', '6');
INSERT INTO `district` VALUES ('1312', '宿城', '207', 's', 'sc', 'sucheng', '', '区', '321302', '0527', '1');
INSERT INTO `district` VALUES ('1313', '宿豫', '207', 's', 'sy', 'suyu', '', '区', '321311', '0527', '2');
INSERT INTO `district` VALUES ('1314', '沭阳', '207', 's', 'sy', 'shuyang', '', '县', '321322', '0527', '3');
INSERT INTO `district` VALUES ('1315', '泗阳', '207', 's', 'sy', 'siyang', '', '县', '321323', '0527', '4');
INSERT INTO `district` VALUES ('1316', '泗洪', '207', 's', 'sh', 'sihong', '', '县', '321324', '0527', '5');
INSERT INTO `district` VALUES ('1317', '上城', '208', 's', 'sc', 'shangcheng', '', '区', '330102', '0571', '1');
INSERT INTO `district` VALUES ('1318', '下城', '208', 'x', 'xc', 'xiacheng', '', '区', '330103', '0571', '2');
INSERT INTO `district` VALUES ('1319', '江干', '208', 'j', 'jg', 'jianggan', '', '区', '330104', '0571', '3');
INSERT INTO `district` VALUES ('1320', '拱墅', '208', 'g', 'gs', 'gongshu', '', '区', '330105', '0571', '4');
INSERT INTO `district` VALUES ('1321', '西湖', '208', 'x', 'xh', 'xihu', '', '区', '330106', '0571', '5');
INSERT INTO `district` VALUES ('1322', '滨江', '208', 'b', 'bj', 'binjiang', '', '区', '330108', '0571', '6');
INSERT INTO `district` VALUES ('1323', '萧山', '208', 'x', 'xs', 'xiaoshan', '', '区', '330109', '0571', '7');
INSERT INTO `district` VALUES ('1324', '余杭', '208', 'y', 'yh', 'yuhang', '', '区', '330110', '0571', '8');
INSERT INTO `district` VALUES ('1325', '桐庐', '208', 't', 'tl', 'tonglu', '', '县', '330122', '0571', '9');
INSERT INTO `district` VALUES ('1326', '淳安', '208', 'c', 'ca', 'chunan', '', '县', '330127', '0571', '11');
INSERT INTO `district` VALUES ('1327', '建德', '208', 'j', 'jd', 'jiande', '', '市', '330182', '0571', '12');
INSERT INTO `district` VALUES ('1328', '富阳', '208', 'f', 'fy', 'fuyang', '', '区', '330183', '0571', '10');
INSERT INTO `district` VALUES ('1329', '临安', '208', 'l', 'la', 'linan', '', '市', '330185', '0571', '13');
INSERT INTO `district` VALUES ('1330', '海曙', '209', 'h', 'hs', 'haishu', '', '区', '330203', '0574', '1');
INSERT INTO `district` VALUES ('1332', '江北', '209', 'j', 'jb', 'jiangbei', '', '区', '330205', '0574', '3');
INSERT INTO `district` VALUES ('1333', '北仑', '209', 'b', 'bl', 'beilun', '', '区', '330206', '0574', '4');
INSERT INTO `district` VALUES ('1334', '镇海', '209', 'z', 'zh', 'zhenhai', '', '区', '330211', '0574', '5');
INSERT INTO `district` VALUES ('1335', '鄞州', '209', 'y', 'yz', 'yinzhou', '', '区', '330212', '0574', '6');
INSERT INTO `district` VALUES ('1336', '象山', '209', 'x', 'xs', 'xiangshan', '', '县', '330225', '0574', '7');
INSERT INTO `district` VALUES ('1337', '宁海', '209', 'n', 'nh', 'ninghai', '', '县', '330226', '0574', '8');
INSERT INTO `district` VALUES ('1338', '余姚', '209', 'y', 'yy', 'yuyao', '', '市', '330281', '0574', '9');
INSERT INTO `district` VALUES ('1339', '慈溪', '209', 'c', 'cx', 'cixi', '', '市', '330282', '0574', '10');
INSERT INTO `district` VALUES ('1340', '奉化', '209', 'f', 'fh', 'fenghua', '', '区', '330283', '0574', '11');
INSERT INTO `district` VALUES ('1341', '鹿城', '210', 'l', 'lc', 'lucheng', '', '区', '330302', '0577', '1');
INSERT INTO `district` VALUES ('1342', '龙湾', '210', 'l', 'lw', 'longwan', '', '区', '330303', '0577', '2');
INSERT INTO `district` VALUES ('1343', '瓯海', '210', 'o', 'oh', 'ouhai', '', '区', '330304', '0577', '3');
INSERT INTO `district` VALUES ('1344', '洞头', '210', 'd', 'dt', 'dongtou', '', '区', '330322', '0577', '4');
INSERT INTO `district` VALUES ('1345', '永嘉', '210', 'y', 'yj', 'yongjia', '', '县', '330324', '0577', '5');
INSERT INTO `district` VALUES ('1346', '平阳', '210', 'p', 'py', 'pingyang', '', '县', '330326', '0577', '6');
INSERT INTO `district` VALUES ('1347', '苍南', '210', 'c', 'cn', 'cangnan', '', '县', '330327', '0577', '7');
INSERT INTO `district` VALUES ('1348', '文成', '210', 'w', 'wc', 'wencheng', '', '县', '330328', '0577', '8');
INSERT INTO `district` VALUES ('1349', '泰顺', '210', 't', 'ts', 'taishun', '', '县', '330329', '0577', '9');
INSERT INTO `district` VALUES ('1350', '瑞安', '210', 'r', 'ra', 'ruian', '', '市', '330381', '0577', '10');
INSERT INTO `district` VALUES ('1351', '乐清', '210', 'l', 'lq', 'leqing', '', '市', '330382', '0577', '11');
INSERT INTO `district` VALUES ('1352', '南湖', '211', 'n', 'nh', 'nanhu', '', '区', '330402', '0573', '1');
INSERT INTO `district` VALUES ('1353', '秀洲', '211', 'x', 'xz', 'xiuzhou', '', '区', '330411', '0573', '2');
INSERT INTO `district` VALUES ('1354', '嘉善', '211', 'j', 'js', 'jiashan', '', '县', '330421', '0573', '3');
INSERT INTO `district` VALUES ('1355', '海盐', '211', 'h', 'hy', 'haiyan', '', '县', '330424', '0573', '4');
INSERT INTO `district` VALUES ('1356', '海宁', '211', 'h', 'hn', 'haining', '', '市', '330481', '0573', '5');
INSERT INTO `district` VALUES ('1357', '平湖', '211', 'p', 'ph', 'pinghu', '', '市', '330482', '0573', '6');
INSERT INTO `district` VALUES ('1358', '桐乡', '211', 't', 'tx', 'tongxiang', '', '市', '330483', '0573', '7');
INSERT INTO `district` VALUES ('1359', '吴兴', '212', 'w', 'wx', 'wuxing', '', '区', '330502', '0572', '1');
INSERT INTO `district` VALUES ('1360', '南浔', '212', 'n', 'nx', 'nanxun', '', '区', '330503', '0572', '2');
INSERT INTO `district` VALUES ('1361', '德清', '212', 'd', 'dq', 'deqing', '', '县', '330521', '0572', '3');
INSERT INTO `district` VALUES ('1362', '长兴', '212', 'z', 'zx', 'zhangxing', '', '县', '330522', '0572', '4');
INSERT INTO `district` VALUES ('1363', '安吉', '212', 'a', 'aj', 'anji', '', '县', '330523', '0572', '5');
INSERT INTO `district` VALUES ('1364', '越城', '213', 'y', 'yc', 'yuecheng', '', '区', '330602', '0575', '1');
INSERT INTO `district` VALUES ('1365', '柯桥', '213', 'k', 'kq', 'keqiao', '', '区', '330603', '0575', '2');
INSERT INTO `district` VALUES ('1366', '新昌', '213', 'x', 'xc', 'xinchang', '', '县', '330624', '0575', '4');
INSERT INTO `district` VALUES ('1367', '诸暨', '213', 'z', 'zj', 'zhuji', '', '市', '330681', '0575', '5');
INSERT INTO `district` VALUES ('1368', '上虞', '213', 's', 'sy', 'shangyu', '', '区', '330604', '0575', '3');
INSERT INTO `district` VALUES ('1369', '嵊州', '213', 's', 'sz', 'shengzhou', '', '市', '330683', '0575', '6');
INSERT INTO `district` VALUES ('1370', '婺城', '214', 'w', 'wc', 'wucheng', '', '区', '330702', '0579', '1');
INSERT INTO `district` VALUES ('1371', '金东', '214', 'j', 'jd', 'jindong', '', '区', '330703', '0579', '2');
INSERT INTO `district` VALUES ('1372', '武义', '214', 'w', 'wy', 'wuyi', '', '县', '330723', '0579', '3');
INSERT INTO `district` VALUES ('1373', '浦江', '214', 'p', 'pj', 'pujiang', '', '县', '330726', '0579', '4');
INSERT INTO `district` VALUES ('1374', '磐安', '214', 'p', 'pa', 'panan', '', '县', '330727', '0579', '5');
INSERT INTO `district` VALUES ('1375', '兰溪', '214', 'l', 'lx', 'lanxi', '', '市', '330781', '0579', '6');
INSERT INTO `district` VALUES ('1376', '义乌', '214', 'y', 'yw', 'yiwu', '', '市', '330782', '0579', '7');
INSERT INTO `district` VALUES ('1377', '东阳', '214', 'd', 'dy', 'dongyang', '', '市', '330783', '0579', '8');
INSERT INTO `district` VALUES ('1378', '永康', '214', 'y', 'yk', 'yongkang', '', '市', '330784', '0579', '9');
INSERT INTO `district` VALUES ('1379', '柯城', '215', 'k', 'kc', 'kecheng', '', '区', '330802', '0570', '1');
INSERT INTO `district` VALUES ('1380', '衢江', '215', 'q', 'qj', 'qujiang', '', '区', '330803', '0570', '2');
INSERT INTO `district` VALUES ('1381', '常山', '215', 'c', 'cs', 'changshan', '', '县', '330822', '0570', '3');
INSERT INTO `district` VALUES ('1382', '开化', '215', 'k', 'kh', 'kaihua', '', '县', '330824', '0570', '4');
INSERT INTO `district` VALUES ('1383', '龙游', '215', 'l', 'ly', 'longyou', '', '县', '330825', '0570', '5');
INSERT INTO `district` VALUES ('1384', '江山', '215', 'j', 'js', 'jiangshan', '', '市', '330881', '0570', '6');
INSERT INTO `district` VALUES ('1385', '定海', '216', 'd', 'dh', 'dinghai', '', '区', '330902', '0580', '1');
INSERT INTO `district` VALUES ('1386', '普陀', '216', 'p', 'pt', 'putuo', '', '区', '330903', '0580', '2');
INSERT INTO `district` VALUES ('1387', '岱山', '216', 'd', 'ds', 'daishan', '', '县', '330921', '0580', '3');
INSERT INTO `district` VALUES ('1388', '嵊泗', '216', 's', 'ss', 'shengsi', '', '县', '330922', '0580', '4');
INSERT INTO `district` VALUES ('1389', '椒江', '217', 'j', 'jj', 'jiaojiang', '', '区', '331002', '0576', '1');
INSERT INTO `district` VALUES ('1390', '黄岩', '217', 'h', 'hy', 'huangyan', '', '区', '331003', '0576', '2');
INSERT INTO `district` VALUES ('1391', '路桥', '217', 'l', 'lq', 'luqiao', '', '区', '331004', '0576', '3');
INSERT INTO `district` VALUES ('1392', '玉环', '217', 'y', 'yh', 'yuhuan', '', '县', '331021', '0576', '4');
INSERT INTO `district` VALUES ('1393', '三门', '217', 's', 'sm', 'sanmen', '', '县', '331022', '0576', '5');
INSERT INTO `district` VALUES ('1394', '天台', '217', 't', 'tt', 'tiantai', '', '县', '331023', '0576', '6');
INSERT INTO `district` VALUES ('1395', '仙居', '217', 'x', 'xj', 'xianju', '', '县', '331024', '0576', '7');
INSERT INTO `district` VALUES ('1396', '温岭', '217', 'w', 'wl', 'wenling', '', '市', '331081', '0576', '8');
INSERT INTO `district` VALUES ('1397', '临海', '217', 'l', 'lh', 'linhai', '', '市', '331082', '0576', '9');
INSERT INTO `district` VALUES ('1398', '莲都', '218', 'l', 'ld', 'liandou', '', '区', '331102', '0578', '1');
INSERT INTO `district` VALUES ('1399', '青田', '218', 'q', 'qt', 'qingtian', '', '县', '331121', '0578', '2');
INSERT INTO `district` VALUES ('1400', '缙云', '218', 'j', 'jy', 'jinyun', '', '县', '331122', '0578', '3');
INSERT INTO `district` VALUES ('1401', '遂昌', '218', 's', 'sc', 'suichang', '', '县', '331123', '0578', '4');
INSERT INTO `district` VALUES ('1402', '松阳', '218', 's', 'sy', 'songyang', '', '县', '331124', '0578', '5');
INSERT INTO `district` VALUES ('1403', '云和', '218', 'y', 'yh', 'yunhe', '', '县', '331125', '0578', '6');
INSERT INTO `district` VALUES ('1404', '庆元', '218', 'q', 'qy', 'qingyuan', '', '县', '331126', '0578', '7');
INSERT INTO `district` VALUES ('1405', '景宁', '218', 'j', 'jn', 'jingning', '畲族', '自治县', '331127', '0578', '8');
INSERT INTO `district` VALUES ('1406', '龙泉', '218', 'l', 'lq', 'longquan', '', '市', '331181', '0578', '9');
INSERT INTO `district` VALUES ('1407', '瑶海', '219', 'y', 'yh', 'yaohai', '', '区', '340102', '0551', '1');
INSERT INTO `district` VALUES ('1408', '庐阳', '219', 'l', 'ly', 'luyang', '', '区', '340103', '0551', '2');
INSERT INTO `district` VALUES ('1409', '蜀山', '219', 's', 'ss', 'shushan', '', '区', '340104', '0551', '3');
INSERT INTO `district` VALUES ('1410', '包河', '219', 'b', 'bh', 'baohe', '', '区', '340111', '0551', '4');
INSERT INTO `district` VALUES ('1411', '长丰', '219', 'z', 'zf', 'zhangfeng', '', '县', '340121', '0551', '5');
INSERT INTO `district` VALUES ('1412', '肥东', '219', 'f', 'fd', 'feidong', '', '县', '340122', '0551', '6');
INSERT INTO `district` VALUES ('1413', '肥西', '219', 'f', 'fx', 'feixi', '', '县', '340123', '0551', '7');
INSERT INTO `district` VALUES ('1414', '庐江', '219', 'l', 'lj', 'lujiang', '', '县', '340124', '0551', '8');
INSERT INTO `district` VALUES ('1415', '巢湖', '219', 'c', 'ch', 'chaohu', '', '市', '340181', '0551', '9');
INSERT INTO `district` VALUES ('1416', '镜湖', '220', 'j', 'jh', 'jinghu', '', '区', '340202', '0553', '1');
INSERT INTO `district` VALUES ('1417', '弋江', '220', 'y', 'yj', 'yijiang', '', '区', '340203', '0553', '2');
INSERT INTO `district` VALUES ('1418', '鸠江', '220', 'j', 'jj', 'jiujiang', '', '区', '340207', '0553', '3');
INSERT INTO `district` VALUES ('1419', '三山', '220', 's', 'ss', 'sanshan', '', '区', '340208', '0553', '4');
INSERT INTO `district` VALUES ('1420', '芜湖', '220', 'w', 'wh', 'wuhu', '', '县', '340221', '0553', '5');
INSERT INTO `district` VALUES ('1421', '繁昌', '220', 'f', 'fc', 'fanchang', '', '县', '340222', '0553', '6');
INSERT INTO `district` VALUES ('1422', '南陵', '220', 'n', 'nl', 'nanling', '', '县', '340223', '0553', '7');
INSERT INTO `district` VALUES ('1423', '无为', '220', 'w', 'ww', 'wuwei', '', '县', '340225', '0553', '8');
INSERT INTO `district` VALUES ('1424', '龙子湖', '221', 'l', 'lzh', 'longzihu', '', '区', '340302', '0552', '1');
INSERT INTO `district` VALUES ('1425', '蚌山', '221', 'b', 'bs', 'bangshan', '', '区', '340303', '0552', '2');
INSERT INTO `district` VALUES ('1426', '禹会', '221', 'y', 'yh', 'yuhui', '', '区', '340304', '0552', '3');
INSERT INTO `district` VALUES ('1427', '淮上', '221', 'h', 'hs', 'huaishang', '', '区', '340311', '0552', '4');
INSERT INTO `district` VALUES ('1428', '怀远', '221', 'h', 'hy', 'huaiyuan', '', '县', '340321', '0552', '5');
INSERT INTO `district` VALUES ('1429', '五河', '221', 'w', 'wh', 'wuhe', '', '县', '340322', '0552', '6');
INSERT INTO `district` VALUES ('1430', '固镇', '221', 'g', 'gz', 'guzhen', '', '县', '340323', '0552', '7');
INSERT INTO `district` VALUES ('1431', '大通', '222', 'd', 'dt', 'datong', '', '区', '340402', '0554', '1');
INSERT INTO `district` VALUES ('1432', '田家庵', '222', 't', 'tja', 'tianjiaan', '', '区', '340403', '0554', '2');
INSERT INTO `district` VALUES ('1433', '谢家集', '222', 'x', 'xjj', 'xiejiaji', '', '区', '340404', '0554', '3');
INSERT INTO `district` VALUES ('1434', '八公山', '222', 'b', 'bgs', 'bagongshan', '', '区', '340405', '0554', '4');
INSERT INTO `district` VALUES ('1435', '潘集', '222', 'p', 'pj', 'panji', '', '区', '340406', '0554', '5');
INSERT INTO `district` VALUES ('1436', '凤台', '222', 'f', 'ft', 'fengtai', '', '县', '340421', '0554', '6');
INSERT INTO `district` VALUES ('1437', '花山', '223', 'h', 'hs', 'huashan', '', '区', '340503', '0555', '1');
INSERT INTO `district` VALUES ('1438', '雨山', '223', 'y', 'ys', 'yushan', '', '区', '340504', '0555', '2');
INSERT INTO `district` VALUES ('1439', '博望', '223', 'b', 'bw', 'bowang', '', '区', '340506', '0555', '3');
INSERT INTO `district` VALUES ('1440', '当涂', '223', 'd', 'dt', 'dangtu', '', '县', '340521', '0555', '4');
INSERT INTO `district` VALUES ('1441', '含山', '223', 'h', 'hs', 'hanshan', '', '县', '340522', '0555', '5');
INSERT INTO `district` VALUES ('1442', '和县', '223', 'h', 'hx', 'hexian', '', '', '340523', '0555', '6');
INSERT INTO `district` VALUES ('1443', '杜集', '224', 'd', 'dj', 'duji', '', '区', '340602', '0561', '1');
INSERT INTO `district` VALUES ('1444', '相山', '224', 'x', 'xs', 'xiangshan', '', '区', '340603', '0561', '2');
INSERT INTO `district` VALUES ('1445', '烈山', '224', 'l', 'ls', 'lieshan', '', '区', '340604', '0561', '3');
INSERT INTO `district` VALUES ('1446', '濉溪', '224', 's', 'sx', 'suixi', '', '县', '340621', '0561', '4');
INSERT INTO `district` VALUES ('1447', '铜官山', '225', 't', 'tgs', 'tongguanshan', '', '区', '340702', '0562', '1');
INSERT INTO `district` VALUES ('1449', '郊区', '225', 'j', 'jq', 'jiaoqu', '', '', '340711', '0562', '3');
INSERT INTO `district` VALUES ('1450', '义安', '225', 'y', 'ya', 'yian', '', '区', '340721', '0562', '4');
INSERT INTO `district` VALUES ('1451', '迎江', '226', 'y', 'yj', 'yingjiang', '', '区', '340802', '0556', '1');
INSERT INTO `district` VALUES ('1452', '大观', '226', 'd', 'dg', 'daguan', '', '区', '340803', '0556', '2');
INSERT INTO `district` VALUES ('1453', '宜秀', '226', 'y', 'yx', 'yixiu', '', '区', '340811', '0556', '3');
INSERT INTO `district` VALUES ('1454', '怀宁', '226', 'h', 'hn', 'huaining', '', '县', '340822', '0556', '4');
INSERT INTO `district` VALUES ('1455', '枞阳', '225', 'z', 'zy', 'zongyang', '', '县', '340823', '0556', '5');
INSERT INTO `district` VALUES ('1456', '潜山', '226', 'q', 'qs', 'qianshan', '', '县', '340824', '0556', '6');
INSERT INTO `district` VALUES ('1457', '太湖', '226', 't', 'th', 'taihu', '', '县', '340825', '0556', '7');
INSERT INTO `district` VALUES ('1458', '宿松', '226', 's', 'ss', 'susong', '', '县', '340826', '0556', '8');
INSERT INTO `district` VALUES ('1459', '望江', '226', 'w', 'wj', 'wangjiang', '', '县', '340827', '0556', '9');
INSERT INTO `district` VALUES ('1460', '岳西', '226', 'y', 'yx', 'yuexi', '', '县', '340828', '0556', '10');
INSERT INTO `district` VALUES ('1461', '桐城', '226', 't', 'tc', 'tongcheng', '', '市', '340881', '0556', '11');
INSERT INTO `district` VALUES ('1462', '屯溪', '227', 't', 'tx', 'tunxi', '', '区', '341002', '0559', '1');
INSERT INTO `district` VALUES ('1463', '黄山', '227', 'h', 'hs', 'huangshan', '', '区', '341003', '0559', '2');
INSERT INTO `district` VALUES ('1464', '徽州', '227', 'h', 'hz', 'huizhou', '', '区', '341004', '0559', '3');
INSERT INTO `district` VALUES ('1465', '歙县', '227', 's', 'sx', 'shexian', '', '', '341021', '0559', '4');
INSERT INTO `district` VALUES ('1466', '休宁', '227', 'x', 'xn', 'xiuning', '', '县', '341022', '0559', '5');
INSERT INTO `district` VALUES ('1467', '黟县', '227', 'y', 'yx', 'yixian', '', '', '341023', '0559', '6');
INSERT INTO `district` VALUES ('1468', '祁门', '227', 'q', 'qm', 'qimen', '', '县', '341024', '0559', '7');
INSERT INTO `district` VALUES ('1469', '琅玡', '228', 'l', 'ly', 'langya', '', '区', '341102', '0550', '1');
INSERT INTO `district` VALUES ('1470', '南谯', '228', 'n', 'nq', 'nanqiao', '', '区', '341103', '0550', '2');
INSERT INTO `district` VALUES ('1471', '来安', '228', 'l', 'la', 'laian', '', '县', '341122', '0550', '3');
INSERT INTO `district` VALUES ('1472', '全椒', '228', 'q', 'qj', 'quanjiao', '', '县', '341124', '0550', '4');
INSERT INTO `district` VALUES ('1473', '定远', '228', 'd', 'dy', 'dingyuan', '', '县', '341125', '0550', '5');
INSERT INTO `district` VALUES ('1474', '凤阳', '228', 'f', 'fy', 'fengyang', '', '县', '341126', '0550', '6');
INSERT INTO `district` VALUES ('1475', '天长', '228', 't', 'tz', 'tianzhang', '', '市', '341181', '0550', '7');
INSERT INTO `district` VALUES ('1476', '明光', '228', 'm', 'mg', 'mingguang', '', '市', '341182', '0550', '8');
INSERT INTO `district` VALUES ('1477', '颍州', '229', 'y', 'yz', 'yingzhou', '', '区', '341202', '0558', '1');
INSERT INTO `district` VALUES ('1478', '颍东', '229', 'y', 'yd', 'yingdong', '', '区', '341203', '0558', '2');
INSERT INTO `district` VALUES ('1479', '颍泉', '229', 'y', 'yq', 'yingquan', '', '区', '341204', '0558', '3');
INSERT INTO `district` VALUES ('1480', '临泉', '229', 'l', 'lq', 'linquan', '', '县', '341221', '0558', '4');
INSERT INTO `district` VALUES ('1481', '太和', '229', 't', 'th', 'taihe', '', '县', '341222', '0558', '5');
INSERT INTO `district` VALUES ('1482', '阜南', '229', 'f', 'fn', 'funan', '', '县', '341225', '0558', '6');
INSERT INTO `district` VALUES ('1483', '颖上', '229', 'y', 'ys', 'yingshang', '', '县', '341226', '0558', '7');
INSERT INTO `district` VALUES ('1484', '界首', '229', 'j', 'js', 'jieshou', '', '市', '341282', '0558', '8');
INSERT INTO `district` VALUES ('1485', '埇桥', '230', 'y', 'yq', 'yongqiao', '', '区', '341302', '0557', '1');
INSERT INTO `district` VALUES ('1486', '砀山', '230', 'd', 'ds', 'dangshan', '', '县', '341321', '0557', '2');
INSERT INTO `district` VALUES ('1487', '萧县', '230', 'x', 'xx', 'xiaoxian', '', '', '341322', '0557', '3');
INSERT INTO `district` VALUES ('1488', '灵璧', '230', 'l', 'lb', 'lingbi', '', '县', '341323', '0557', '4');
INSERT INTO `district` VALUES ('1489', '泗县', '230', 's', 'sx', 'sixian', '', '', '341324', '0557', '5');
INSERT INTO `district` VALUES ('1490', '金安', '231', 'j', 'ja', 'jinan', '', '区', '341502', '0564', '1');
INSERT INTO `district` VALUES ('1491', '裕安', '231', 'y', 'ya', 'yuan', '', '区', '341503', '0564', '2');
INSERT INTO `district` VALUES ('1492', '寿县', '222', 's', 'sx', 'shouxian', '', '', '341521', '0564', '3');
INSERT INTO `district` VALUES ('1493', '霍邱', '231', 'h', 'hq', 'huoqiu', '', '县', '341522', '0564', '4');
INSERT INTO `district` VALUES ('1494', '舒城', '231', 's', 'sc', 'shucheng', '', '县', '341523', '0564', '5');
INSERT INTO `district` VALUES ('1495', '金寨', '231', 'j', 'jz', 'jinzhai', '', '县', '341524', '0564', '6');
INSERT INTO `district` VALUES ('1496', '霍山', '231', 'h', 'hs', 'huoshan', '', '县', '341525', '0564', '7');
INSERT INTO `district` VALUES ('1497', '谯城', '232', 'q', 'qc', 'qiaocheng', '', '区', '341602', '0558', '1');
INSERT INTO `district` VALUES ('1498', '涡阳', '232', 'w', 'wy', 'woyang', '', '县', '341621', '0558', '2');
INSERT INTO `district` VALUES ('1499', '蒙城', '232', 'm', 'mc', 'mengcheng', '', '县', '341622', '0558', '3');
INSERT INTO `district` VALUES ('1500', '利辛', '232', 'l', 'lx', 'lixin', '', '县', '341623', '0558', '4');
INSERT INTO `district` VALUES ('1501', '贵池', '233', 'g', 'gc', 'guichi', '', '区', '341702', '0566', '1');
INSERT INTO `district` VALUES ('1502', '东至', '233', 'd', 'dz', 'dongzhi', '', '县', '341721', '0566', '2');
INSERT INTO `district` VALUES ('1503', '石台', '233', 's', 'st', 'shitai', '', '县', '341722', '0566', '3');
INSERT INTO `district` VALUES ('1504', '青阳', '233', 'q', 'qy', 'qingyang', '', '县', '341723', '0566', '4');
INSERT INTO `district` VALUES ('1505', '宣州', '234', 'x', 'xz', 'xuanzhou', '', '区', '341802', '0563', '1');
INSERT INTO `district` VALUES ('1506', '郎溪', '234', 'l', 'lx', 'langxi', '', '县', '341821', '0563', '2');
INSERT INTO `district` VALUES ('1507', '广德', '234', 'g', 'gd', 'guangde', '', '县', '341822', '0563', '3');
INSERT INTO `district` VALUES ('1508', '泾县', '234', 'j', 'jx', 'jingxian', '', '', '341823', '0563', '4');
INSERT INTO `district` VALUES ('1509', '绩溪', '234', 'j', 'jx', 'jixi', '', '县', '341824', '0563', '5');
INSERT INTO `district` VALUES ('1510', '旌德', '234', 'j', 'jd', 'jingde', '', '县', '341825', '0563', '6');
INSERT INTO `district` VALUES ('1511', '宁国', '234', 'n', 'ng', 'ningguo', '', '市', '341881', '0563', '7');
INSERT INTO `district` VALUES ('1512', '鼓楼', '235', 'g', 'gl', 'gulou', '', '区', '350102', '0591', '1');
INSERT INTO `district` VALUES ('1513', '台江', '235', 't', 'tj', 'taijiang', '', '区', '350103', '0591', '2');
INSERT INTO `district` VALUES ('1514', '仓山', '235', 'c', 'cs', 'cangshan', '', '区', '350104', '0591', '3');
INSERT INTO `district` VALUES ('1515', '马尾', '235', 'm', 'mw', 'mawei', '', '区', '350105', '0591', '4');
INSERT INTO `district` VALUES ('1516', '晋安', '235', 'j', 'ja', 'jinan', '', '区', '350111', '0591', '5');
INSERT INTO `district` VALUES ('1517', '闽侯', '235', 'm', 'mh', 'minhou', '', '县', '350121', '0591', '6');
INSERT INTO `district` VALUES ('1518', '连江', '235', 'l', 'lj', 'lianjiang', '', '县', '350122', '0591', '7');
INSERT INTO `district` VALUES ('1519', '罗源', '235', 'l', 'ly', 'luoyuan', '', '县', '350123', '0591', '8');
INSERT INTO `district` VALUES ('1520', '闽清', '235', 'm', 'mq', 'minqing', '', '县', '350124', '0591', '9');
INSERT INTO `district` VALUES ('1521', '永泰', '235', 'y', 'yt', 'yongtai', '', '县', '350125', '0591', '10');
INSERT INTO `district` VALUES ('1522', '平潭', '235', 'p', 'pt', 'pingtan', '', '县', '350128', '0591', '11');
INSERT INTO `district` VALUES ('1523', '福清', '235', 'f', 'fq', 'fuqing', '', '市', '350181', '0591', '12');
INSERT INTO `district` VALUES ('1524', '长乐', '235', 'z', 'zl', 'zhangle', '', '市', '350182', '0591', '13');
INSERT INTO `district` VALUES ('1525', '思明', '236', 's', 'sm', 'siming', '', '区', '350203', '0592', '1');
INSERT INTO `district` VALUES ('1526', '海沧', '236', 'h', 'hc', 'haicang', '', '区', '350205', '0592', '2');
INSERT INTO `district` VALUES ('1527', '湖里', '236', 'h', 'hl', 'huli', '', '区', '350206', '0592', '3');
INSERT INTO `district` VALUES ('1528', '集美', '236', 'j', 'jm', 'jimei', '', '区', '350211', '0592', '4');
INSERT INTO `district` VALUES ('1529', '同安', '236', 't', 'ta', 'tongan', '', '区', '350212', '0592', '5');
INSERT INTO `district` VALUES ('1530', '翔安', '236', 'x', 'xa', 'xiangan', '', '区', '350213', '0592', '6');
INSERT INTO `district` VALUES ('1531', '城厢', '237', 'c', 'cx', 'chengxiang', '', '区', '350302', '0594', '1');
INSERT INTO `district` VALUES ('1532', '涵江', '237', 'h', 'hj', 'hanjiang', '', '区', '350303', '0594', '2');
INSERT INTO `district` VALUES ('1533', '荔城', '237', 'l', 'lc', 'licheng', '', '区', '350304', '0594', '3');
INSERT INTO `district` VALUES ('1534', '秀屿', '237', 'x', 'xy', 'xiuyu', '', '区', '350305', '0594', '4');
INSERT INTO `district` VALUES ('1535', '仙游', '237', 'x', 'xy', 'xianyou', '', '县', '350322', '0594', '5');
INSERT INTO `district` VALUES ('1536', '梅列', '238', 'm', 'ml', 'meilie', '', '区', '350402', '0598', '1');
INSERT INTO `district` VALUES ('1537', '三元', '238', 's', 'sy', 'sanyuan', '', '区', '350403', '0598', '2');
INSERT INTO `district` VALUES ('1538', '明溪', '238', 'm', 'mx', 'mingxi', '', '县', '350421', '0598', '3');
INSERT INTO `district` VALUES ('1539', '清流', '238', 'q', 'ql', 'qingliu', '', '县', '350423', '0598', '4');
INSERT INTO `district` VALUES ('1540', '宁化', '238', 'n', 'nh', 'ninghua', '', '县', '350424', '0598', '5');
INSERT INTO `district` VALUES ('1541', '大田', '238', 'd', 'dt', 'datian', '', '县', '350425', '0598', '6');
INSERT INTO `district` VALUES ('1542', '尤溪', '238', 'y', 'yx', 'youxi', '', '县', '350426', '0598', '7');
INSERT INTO `district` VALUES ('1543', '沙县', '238', 's', 'sx', 'shaxian', '', '', '350427', '0598', '8');
INSERT INTO `district` VALUES ('1544', '将乐', '238', 'j', 'jl', 'jiangle', '', '县', '350428', '0598', '9');
INSERT INTO `district` VALUES ('1545', '泰宁', '238', 't', 'tn', 'taining', '', '县', '350429', '0598', '10');
INSERT INTO `district` VALUES ('1546', '建宁', '238', 'j', 'jn', 'jianning', '', '县', '350430', '0598', '11');
INSERT INTO `district` VALUES ('1547', '永安', '238', 'y', 'ya', 'yongan', '', '市', '350481', '0598', '12');
INSERT INTO `district` VALUES ('1548', '鲤城', '239', 'l', 'lc', 'licheng', '', '区', '350502', '0595', '1');
INSERT INTO `district` VALUES ('1549', '丰泽', '239', 'f', 'fz', 'fengze', '', '区', '350503', '0595', '2');
INSERT INTO `district` VALUES ('1550', '洛江', '239', 'l', 'lj', 'luojiang', '', '区', '350504', '0595', '3');
INSERT INTO `district` VALUES ('1551', '泉港', '239', 'q', 'qg', 'quangang', '', '区', '350505', '0595', '4');
INSERT INTO `district` VALUES ('1552', '惠安', '239', 'h', 'ha', 'huian', '', '县', '350521', '0595', '5');
INSERT INTO `district` VALUES ('1553', '安溪', '239', 'a', 'ax', 'anxi', '', '县', '350524', '0595', '6');
INSERT INTO `district` VALUES ('1554', '永春', '239', 'y', 'yc', 'yongchun', '', '县', '350525', '0595', '7');
INSERT INTO `district` VALUES ('1555', '德化', '239', 'd', 'dh', 'dehua', '', '县', '350526', '0595', '8');
INSERT INTO `district` VALUES ('1556', '金门', '239', 'j', 'jm', 'jinmen', '', '县', '350527', '0595', '9');
INSERT INTO `district` VALUES ('1557', '石狮', '239', 's', 'ss', 'shishi', '', '市', '350581', '0595', '10');
INSERT INTO `district` VALUES ('1558', '晋江', '239', 'j', 'jj', 'jinjiang', '', '市', '350582', '0595', '11');
INSERT INTO `district` VALUES ('1559', '南安', '239', 'n', 'na', 'nanan', '', '市', '350583', '0595', '12');
INSERT INTO `district` VALUES ('1560', '芗城', '240', 'x', 'xc', 'xiangcheng', '', '区', '350602', '0596', '1');
INSERT INTO `district` VALUES ('1561', '龙文', '240', 'l', 'lw', 'longwen', '', '区', '350603', '0596', '2');
INSERT INTO `district` VALUES ('1562', '云霄', '240', 'y', 'yx', 'yunxiao', '', '县', '350622', '0596', '3');
INSERT INTO `district` VALUES ('1563', '漳浦', '240', 'z', 'zp', 'zhangpu', '', '县', '350623', '0596', '4');
INSERT INTO `district` VALUES ('1564', '诏安', '240', 'z', 'za', 'zhaoan', '', '县', '350624', '0596', '5');
INSERT INTO `district` VALUES ('1565', '长泰', '240', 'z', 'zt', 'zhangtai', '', '县', '350625', '0596', '6');
INSERT INTO `district` VALUES ('1566', '东山', '240', 'd', 'ds', 'dongshan', '', '县', '350626', '0596', '7');
INSERT INTO `district` VALUES ('1567', '南靖', '240', 'n', 'nj', 'nanjing', '', '县', '350627', '0596', '8');
INSERT INTO `district` VALUES ('1568', '平和', '240', 'p', 'ph', 'pinghe', '', '县', '350628', '0596', '9');
INSERT INTO `district` VALUES ('1569', '华安', '240', 'h', 'ha', 'huaan', '', '县', '350629', '0596', '10');
INSERT INTO `district` VALUES ('1570', '龙海', '240', 'l', 'lh', 'longhai', '', '市', '350681', '0596', '11');
INSERT INTO `district` VALUES ('1571', '延平', '241', 'y', 'yp', 'yanping', '', '区', '350702', '0599', '1');
INSERT INTO `district` VALUES ('1572', '顺昌', '241', 's', 'sc', 'shunchang', '', '县', '350721', '0599', '3');
INSERT INTO `district` VALUES ('1573', '浦城', '241', 'p', 'pc', 'pucheng', '', '县', '350722', '0599', '4');
INSERT INTO `district` VALUES ('1574', '光泽', '241', 'g', 'gz', 'guangze', '', '县', '350723', '0599', '5');
INSERT INTO `district` VALUES ('1575', '松溪', '241', 's', 'sx', 'songxi', '', '县', '350724', '0599', '6');
INSERT INTO `district` VALUES ('1576', '政和', '241', 'z', 'zh', 'zhenghe', '', '县', '350725', '0599', '7');
INSERT INTO `district` VALUES ('1577', '邵武', '241', 's', 'sw', 'shaowu', '', '市', '350781', '0599', '8');
INSERT INTO `district` VALUES ('1578', '武夷山', '241', 'w', 'wys', 'wuyishan', '', '市', '350782', '0599', '9');
INSERT INTO `district` VALUES ('1579', '建瓯', '241', 'j', 'jo', 'jianou', '', '市', '350783', '0599', '10');
INSERT INTO `district` VALUES ('1580', '建阳', '241', 'j', 'jy', 'jianyang', '', '区', '350703', '0599', '2');
INSERT INTO `district` VALUES ('1581', '新罗', '242', 'x', 'xl', 'xinluo', '', '区', '350802', '0597', '1');
INSERT INTO `district` VALUES ('1582', '长汀', '242', 'z', 'zt', 'zhangting', '', '县', '350821', '0597', '3');
INSERT INTO `district` VALUES ('1583', '永定', '242', 'y', 'yd', 'yongding', '', '区', '350803', '0597', '2');
INSERT INTO `district` VALUES ('1584', '上杭', '242', 's', 'sh', 'shanghang', '', '县', '350823', '0597', '4');
INSERT INTO `district` VALUES ('1585', '武平', '242', 'w', 'wp', 'wuping', '', '县', '350824', '0597', '5');
INSERT INTO `district` VALUES ('1586', '连城', '242', 'l', 'lc', 'liancheng', '', '县', '350825', '0597', '6');
INSERT INTO `district` VALUES ('1587', '漳平', '242', 'z', 'zp', 'zhangping', '', '市', '350881', '0597', '7');
INSERT INTO `district` VALUES ('1588', '蕉城', '243', 'j', 'jc', 'jiaocheng', '', '区', '350902', '0593', '1');
INSERT INTO `district` VALUES ('1589', '霞浦', '243', 'x', 'xp', 'xiapu', '', '县', '350921', '0593', '2');
INSERT INTO `district` VALUES ('1590', '古田', '243', 'g', 'gt', 'gutian', '', '县', '350922', '0593', '3');
INSERT INTO `district` VALUES ('1591', '屏南', '243', 'p', 'pn', 'pingnan', '', '县', '350923', '0593', '4');
INSERT INTO `district` VALUES ('1592', '寿宁', '243', 's', 'sn', 'shouning', '', '县', '350924', '0593', '5');
INSERT INTO `district` VALUES ('1593', '周宁', '243', 'z', 'zn', 'zhouning', '', '县', '350925', '0593', '6');
INSERT INTO `district` VALUES ('1594', '柘荣', '243', 'z', 'zr', 'zherong', '', '县', '350926', '0593', '7');
INSERT INTO `district` VALUES ('1595', '福安', '243', 'f', 'fa', 'fuan', '', '市', '350981', '0593', '8');
INSERT INTO `district` VALUES ('1596', '福鼎', '243', 'f', 'fd', 'fuding', '', '市', '350982', '0593', '9');
INSERT INTO `district` VALUES ('1597', '东湖', '244', 'd', 'dh', 'donghu', '', '区', '360102', '0791', '1');
INSERT INTO `district` VALUES ('1598', '西湖', '244', 'x', 'xh', 'xihu', '', '区', '360103', '0791', '2');
INSERT INTO `district` VALUES ('1599', '青云谱', '244', 'q', 'qyp', 'qingyunpu', '', '区', '360104', '0791', '3');
INSERT INTO `district` VALUES ('1600', '湾里', '244', 'w', 'wl', 'wanli', '', '区', '360105', '0791', '4');
INSERT INTO `district` VALUES ('1601', '青山湖', '244', 'q', 'qsh', 'qingshanhu', '', '区', '360111', '0791', '5');
INSERT INTO `district` VALUES ('1602', '南昌', '244', 'n', 'nc', 'nanchang', '', '县', '360121', '0791', '6');
INSERT INTO `district` VALUES ('1603', '新建', '244', 'x', 'xj', 'xinjian', '', '区', '360122', '0791', '7');
INSERT INTO `district` VALUES ('1604', '安义', '244', 'a', 'ay', 'anyi', '', '县', '360123', '0791', '8');
INSERT INTO `district` VALUES ('1605', '进贤', '244', 'j', 'jx', 'jinxian', '', '县', '360124', '0791', '9');
INSERT INTO `district` VALUES ('1606', '昌江', '245', 'c', 'cj', 'changjiang', '', '区', '360202', '0798', '1');
INSERT INTO `district` VALUES ('1607', '珠山', '245', 'z', 'zs', 'zhushan', '', '区', '360203', '0798', '2');
INSERT INTO `district` VALUES ('1608', '浮梁', '245', 'f', 'fl', 'fuliang', '', '县', '360222', '0798', '3');
INSERT INTO `district` VALUES ('1609', '乐平', '245', 'l', 'lp', 'leping', '', '市', '360281', '0798', '4');
INSERT INTO `district` VALUES ('1610', '安源', '246', 'a', 'ay', 'anyuan', '', '区', '360302', '0799', '1');
INSERT INTO `district` VALUES ('1611', '湘东', '246', 'x', 'xd', 'xiangdong', '', '区', '360313', '0799', '2');
INSERT INTO `district` VALUES ('1612', '莲花', '246', 'l', 'lh', 'lianhua', '', '县', '360321', '0799', '3');
INSERT INTO `district` VALUES ('1613', '上栗', '246', 's', 'sl', 'shangli', '', '县', '360322', '0799', '4');
INSERT INTO `district` VALUES ('1614', '芦溪', '246', 'l', 'lx', 'luxi', '', '县', '360323', '0799', '5');
INSERT INTO `district` VALUES ('1615', '濂溪', '247', 'l', 'lx', 'lianxi', '', '区', '360402', '0792', '1');
INSERT INTO `district` VALUES ('1616', '浔阳', '247', 'x', 'xy', 'xunyang', '', '区', '360403', '0792', '2');
INSERT INTO `district` VALUES ('1617', '九江', '247', 'j', 'jj', 'jiujiang', '', '县', '360421', '0792', '3');
INSERT INTO `district` VALUES ('1618', '武宁', '247', 'w', 'wn', 'wuning', '', '县', '360423', '0792', '4');
INSERT INTO `district` VALUES ('1619', '修水', '247', 'x', 'xs', 'xiushui', '', '县', '360424', '0792', '5');
INSERT INTO `district` VALUES ('1620', '永修', '247', 'y', 'yx', 'yongxiu', '', '县', '360425', '0792', '6');
INSERT INTO `district` VALUES ('1621', '德安', '247', 'd', 'da', 'dean', '', '县', '360426', '0792', '7');
INSERT INTO `district` VALUES ('1622', '庐山', '247', 'l', 'ls', 'lushan', '', '市', '360427', '0792', '8');
INSERT INTO `district` VALUES ('1623', '都昌', '247', 'd', 'dc', 'douchang', '', '县', '360428', '0792', '9');
INSERT INTO `district` VALUES ('1624', '湖口', '247', 'h', 'hk', 'hukou', '', '县', '360429', '0792', '10');
INSERT INTO `district` VALUES ('1625', '彭泽', '247', 'p', 'pz', 'pengze', '', '县', '360430', '0792', '11');
INSERT INTO `district` VALUES ('1626', '瑞昌', '247', 'r', 'rc', 'ruichang', '', '市', '360481', '0792', '12');
INSERT INTO `district` VALUES ('1627', '共青城', '247', 'g', 'gqc', 'gongqingcheng', '', '市', '360482', '0792', '13');
INSERT INTO `district` VALUES ('1628', '渝水', '248', 'y', 'ys', 'yushui', '', '区', '360502', '0790', '1');
INSERT INTO `district` VALUES ('1629', '分宜', '248', 'f', 'fy', 'fenyi', '', '县', '360521', '0790', '2');
INSERT INTO `district` VALUES ('1630', '月湖', '249', 'y', 'yh', 'yuehu', '', '区', '360602', '0701', '1');
INSERT INTO `district` VALUES ('1631', '余江', '249', 'y', 'yj', 'yujiang', '', '县', '360622', '0701', '2');
INSERT INTO `district` VALUES ('1632', '贵溪', '249', 'g', 'gx', 'guixi', '', '市', '360681', '0701', '3');
INSERT INTO `district` VALUES ('1633', '章贡', '250', 'z', 'zg', 'zhanggong', '', '区', '360702', '0797', '1');
INSERT INTO `district` VALUES ('1634', '赣县', '250', 'g', 'gx', 'ganxian', '', '区', '360721', '0797', '2');
INSERT INTO `district` VALUES ('1635', '信丰', '250', 'x', 'xf', 'xinfeng', '', '县', '360722', '0797', '3');
INSERT INTO `district` VALUES ('1636', '大余', '250', 'd', 'dy', 'dayu', '', '县', '360723', '0797', '4');
INSERT INTO `district` VALUES ('1637', '上犹', '250', 's', 'sy', 'shangyou', '', '县', '360724', '0797', '5');
INSERT INTO `district` VALUES ('1638', '崇义', '250', 'c', 'cy', 'chongyi', '', '县', '360725', '0797', '6');
INSERT INTO `district` VALUES ('1639', '安远', '250', 'a', 'ay', 'anyuan', '', '县', '360726', '0797', '7');
INSERT INTO `district` VALUES ('1640', '龙南', '250', 'l', 'ln', 'longnan', '', '县', '360727', '0797', '8');
INSERT INTO `district` VALUES ('1641', '定南', '250', 'd', 'dn', 'dingnan', '', '县', '360728', '0797', '9');
INSERT INTO `district` VALUES ('1642', '全南', '250', 'q', 'qn', 'quannan', '', '县', '360729', '0797', '10');
INSERT INTO `district` VALUES ('1643', '宁都', '250', 'n', 'nd', 'ningdou', '', '县', '360730', '0797', '11');
INSERT INTO `district` VALUES ('1644', '于都', '250', 'y', 'yd', 'yudou', '', '县', '360731', '0797', '12');
INSERT INTO `district` VALUES ('1645', '兴国', '250', 'x', 'xg', 'xingguo', '', '县', '360732', '0797', '13');
INSERT INTO `district` VALUES ('1646', '会昌', '250', 'h', 'hc', 'huichang', '', '县', '360733', '0797', '14');
INSERT INTO `district` VALUES ('1647', '寻乌', '250', 'x', 'xw', 'xunwu', '', '县', '360734', '0797', '15');
INSERT INTO `district` VALUES ('1648', '石城', '250', 's', 'sc', 'shicheng', '', '县', '360735', '0797', '16');
INSERT INTO `district` VALUES ('1649', '瑞金', '250', 'r', 'rj', 'ruijin', '', '市', '360781', '0797', '17');
INSERT INTO `district` VALUES ('1650', '南康', '250', 'n', 'nk', 'nankang', '', '区', '360782', '0797', '18');
INSERT INTO `district` VALUES ('1651', '吉州', '251', 'j', 'jz', 'jizhou', '', '区', '360802', '0796', '1');
INSERT INTO `district` VALUES ('1652', '青原', '251', 'q', 'qy', 'qingyuan', '', '区', '360803', '0796', '2');
INSERT INTO `district` VALUES ('1653', '吉安', '251', 'j', 'ja', 'jian', '', '县', '360821', '0796', '3');
INSERT INTO `district` VALUES ('1654', '吉水', '251', 'j', 'js', 'jishui', '', '县', '360822', '0796', '4');
INSERT INTO `district` VALUES ('1655', '峡江', '251', 'x', 'xj', 'xiajiang', '', '县', '360823', '0796', '5');
INSERT INTO `district` VALUES ('1656', '新干', '251', 'x', 'xg', 'xingan', '', '县', '360824', '0796', '6');
INSERT INTO `district` VALUES ('1657', '永丰', '251', 'y', 'yf', 'yongfeng', '', '县', '360825', '0796', '7');
INSERT INTO `district` VALUES ('1658', '泰和', '251', 't', 'th', 'taihe', '', '县', '360826', '0796', '8');
INSERT INTO `district` VALUES ('1659', '遂川', '251', 's', 'sc', 'suichuan', '', '县', '360827', '0796', '9');
INSERT INTO `district` VALUES ('1660', '万安', '251', 'w', 'wa', 'wanan', '', '县', '360828', '0796', '10');
INSERT INTO `district` VALUES ('1661', '安福', '251', 'a', 'af', 'anfu', '', '县', '360829', '0796', '11');
INSERT INTO `district` VALUES ('1662', '永新', '251', 'y', 'yx', 'yongxin', '', '县', '360830', '0796', '12');
INSERT INTO `district` VALUES ('1663', '井冈山', '251', 'j', 'jgs', 'jinggangshan', '', '市', '360881', '0796', '13');
INSERT INTO `district` VALUES ('1664', '袁州', '252', 'y', 'yz', 'yuanzhou', '', '区', '360902', '0795', '1');
INSERT INTO `district` VALUES ('1665', '奉新', '252', 'f', 'fx', 'fengxin', '', '县', '360921', '0795', '2');
INSERT INTO `district` VALUES ('1666', '万载', '252', 'w', 'wz', 'wanzai', '', '县', '360922', '0795', '3');
INSERT INTO `district` VALUES ('1667', '上高', '252', 's', 'sg', 'shanggao', '', '县', '360923', '0795', '4');
INSERT INTO `district` VALUES ('1668', '宜丰', '252', 'y', 'yf', 'yifeng', '', '县', '360924', '0795', '5');
INSERT INTO `district` VALUES ('1669', '靖安', '252', 'j', 'ja', 'jingan', '', '县', '360925', '0795', '6');
INSERT INTO `district` VALUES ('1670', '铜鼓', '252', 't', 'tg', 'tonggu', '', '县', '360926', '0795', '7');
INSERT INTO `district` VALUES ('1671', '丰城', '252', 'f', 'fc', 'fengcheng', '', '市', '360981', '0795', '8');
INSERT INTO `district` VALUES ('1672', '樟树', '252', 'z', 'zs', 'zhangshu', '', '市', '360982', '0795', '9');
INSERT INTO `district` VALUES ('1673', '高安', '252', 'g', 'ga', 'gaoan', '', '市', '360983', '0795', '10');
INSERT INTO `district` VALUES ('1674', '临川', '253', 'l', 'lc', 'linchuan', '', '区', '361002', '0794', '1');
INSERT INTO `district` VALUES ('1675', '南城', '253', 'n', 'nc', 'nancheng', '', '县', '361021', '0794', '2');
INSERT INTO `district` VALUES ('1676', '黎川', '253', 'l', 'lc', 'lichuan', '', '县', '361022', '0794', '3');
INSERT INTO `district` VALUES ('1677', '南丰', '253', 'n', 'nf', 'nanfeng', '', '县', '361023', '0794', '4');
INSERT INTO `district` VALUES ('1678', '崇仁', '253', 'c', 'cr', 'chongren', '', '县', '361024', '0794', '5');
INSERT INTO `district` VALUES ('1679', '乐安', '253', 'l', 'la', 'lean', '', '县', '361025', '0794', '6');
INSERT INTO `district` VALUES ('1680', '宜黄', '253', 'y', 'yh', 'yihuang', '', '县', '361026', '0794', '7');
INSERT INTO `district` VALUES ('1681', '金溪', '253', 'j', 'jx', 'jinxi', '', '县', '361027', '0794', '8');
INSERT INTO `district` VALUES ('1682', '资溪', '253', 'z', 'zx', 'zixi', '', '县', '361028', '0794', '9');
INSERT INTO `district` VALUES ('1683', '东乡', '253', 'd', 'dx', 'dongxiang', '', '县', '361029', '0794', '10');
INSERT INTO `district` VALUES ('1684', '广昌', '253', 'g', 'gc', 'guangchang', '', '县', '361030', '0794', '11');
INSERT INTO `district` VALUES ('1685', '信州', '254', 'x', 'xz', 'xinzhou', '', '区', '361102', '0793', '1');
INSERT INTO `district` VALUES ('1686', '上饶', '254', 's', 'sr', 'shangrao', '', '县', '361121', '0793', '3');
INSERT INTO `district` VALUES ('1687', '广丰', '254', 'g', 'gf', 'guangfeng', '', '区', '361122', '0793', '2');
INSERT INTO `district` VALUES ('1688', '玉山', '254', 'y', 'ys', 'yushan', '', '县', '361123', '0793', '4');
INSERT INTO `district` VALUES ('1689', '铅山', '254', 'q', 'qs', 'qianshan', '', '县', '361124', '0793', '5');
INSERT INTO `district` VALUES ('1690', '横峰', '254', 'h', 'hf', 'hengfeng', '', '县', '361125', '0793', '6');
INSERT INTO `district` VALUES ('1691', '弋阳', '254', 'y', 'yy', 'yiyang', '', '县', '361126', '0793', '7');
INSERT INTO `district` VALUES ('1692', '余干', '254', 'y', 'yg', 'yugan', '', '县', '361127', '0793', '8');
INSERT INTO `district` VALUES ('1693', '鄱阳', '254', 'p', 'py', 'poyang', '', '县', '361128', '0793', '9');
INSERT INTO `district` VALUES ('1694', '万年', '254', 'w', 'wn', 'wannian', '', '县', '361129', '0793', '10');
INSERT INTO `district` VALUES ('1695', '婺源', '254', 'w', 'wy', 'wuyuan', '', '县', '361130', '0793', '11');
INSERT INTO `district` VALUES ('1696', '德兴', '254', 'd', 'dx', 'dexing', '', '市', '361181', '0793', '12');
INSERT INTO `district` VALUES ('1697', '历下', '255', 'l', 'lx', 'lixia', '', '区', '370102', '0531', '1');
INSERT INTO `district` VALUES ('1698', '市中', '255', 's', 'sz', 'shizhong', '', '区', '370103', '0531', '2');
INSERT INTO `district` VALUES ('1699', '槐荫', '255', 'h', 'hy', 'huaiyin', '', '区', '370104', '0531', '3');
INSERT INTO `district` VALUES ('1700', '天桥', '255', 't', 'tq', 'tianqiao', '', '区', '370105', '0531', '4');
INSERT INTO `district` VALUES ('1701', '历城', '255', 'l', 'lc', 'licheng', '', '区', '370112', '0531', '5');
INSERT INTO `district` VALUES ('1702', '长清', '255', 'z', 'zq', 'zhangqing', '', '区', '370113', '0531', '6');
INSERT INTO `district` VALUES ('1703', '平阴', '255', 'p', 'py', 'pingyin', '', '县', '370124', '0531', '7');
INSERT INTO `district` VALUES ('1704', '济阳', '255', 'j', 'jy', 'jiyang', '', '县', '370125', '0531', '8');
INSERT INTO `district` VALUES ('1705', '商河', '255', 's', 'sh', 'shanghe', '', '县', '370126', '0531', '9');
INSERT INTO `district` VALUES ('1706', '章丘', '255', 'z', 'zq', 'zhangqiu', '', '区', '370181', '0531', '10');
INSERT INTO `district` VALUES ('1707', '市南', '256', 's', 'sn', 'shinan', '', '区', '370202', '0532', '1');
INSERT INTO `district` VALUES ('1708', '市北', '256', 's', 'sb', 'shibei', '', '区', '370203', '0532', '2');
INSERT INTO `district` VALUES ('1709', '黄岛', '256', 'h', 'hd', 'huangdao', '', '区', '370211', '0532', '3');
INSERT INTO `district` VALUES ('1710', '崂山', '256', 'l', 'ls', 'laoshan', '', '区', '370212', '0532', '4');
INSERT INTO `district` VALUES ('1711', '李沧', '256', 'l', 'lc', 'licang', '', '区', '370213', '0532', '5');
INSERT INTO `district` VALUES ('1712', '城阳', '256', 'c', 'cy', 'chengyang', '', '区', '370214', '0532', '6');
INSERT INTO `district` VALUES ('1713', '胶州', '256', 'j', 'jz', 'jiaozhou', '', '市', '370281', '0532', '7');
INSERT INTO `district` VALUES ('1714', '即墨', '256', 'j', 'jm', 'jimo', '', '市', '370282', '0532', '8');
INSERT INTO `district` VALUES ('1715', '平度', '256', 'p', 'pd', 'pingdu', '', '市', '370283', '0532', '9');
INSERT INTO `district` VALUES ('1716', '莱西', '256', 'l', 'lx', 'laixi', '', '市', '370285', '0532', '10');
INSERT INTO `district` VALUES ('1717', '淄川', '257', 'z', 'zc', 'zichuan', '', '区', '370302', '0533', '1');
INSERT INTO `district` VALUES ('1718', '张店', '257', 'z', 'zd', 'zhangdian', '', '区', '370303', '0533', '2');
INSERT INTO `district` VALUES ('1719', '博山', '257', 'b', 'bs', 'boshan', '', '区', '370304', '0533', '3');
INSERT INTO `district` VALUES ('1720', '临淄', '257', 'l', 'lz', 'linzi', '', '区', '370305', '0533', '4');
INSERT INTO `district` VALUES ('1721', '周村', '257', 'z', 'zc', 'zhoucun', '', '区', '370306', '0533', '5');
INSERT INTO `district` VALUES ('1722', '桓台', '257', 'h', 'ht', 'huantai', '', '县', '370321', '0533', '6');
INSERT INTO `district` VALUES ('1723', '高青', '257', 'g', 'gq', 'gaoqing', '', '县', '370322', '0533', '7');
INSERT INTO `district` VALUES ('1724', '沂源', '257', 'y', 'yy', 'yiyuan', '', '县', '370323', '0533', '8');
INSERT INTO `district` VALUES ('1725', '市中', '258', 's', 'sz', 'shizhong', '', '区', '370402', '0632', '1');
INSERT INTO `district` VALUES ('1726', '薛城', '258', 'x', 'xc', 'xuecheng', '', '区', '370403', '0632', '2');
INSERT INTO `district` VALUES ('1727', '峄城', '258', 'y', 'yc', 'yicheng', '', '区', '370404', '0632', '3');
INSERT INTO `district` VALUES ('1728', '台儿庄', '258', 't', 'tez', 'taierzhuang', '', '区', '370405', '0632', '4');
INSERT INTO `district` VALUES ('1729', '山亭', '258', 's', 'st', 'shanting', '', '区', '370406', '0632', '5');
INSERT INTO `district` VALUES ('1730', '滕州', '258', 't', 'tz', 'tengzhou', '', '市', '370481', '0632', '6');
INSERT INTO `district` VALUES ('1731', '东营', '259', 'd', 'dy', 'dongying', '', '区', '370502', '0546', '1');
INSERT INTO `district` VALUES ('1732', '河口', '259', 'h', 'hk', 'hekou', '', '区', '370503', '0546', '2');
INSERT INTO `district` VALUES ('1733', '垦利', '259', 'k', 'kl', 'kenli', '', '区', '370521', '0546', '3');
INSERT INTO `district` VALUES ('1734', '利津', '259', 'l', 'lj', 'lijin', '', '县', '370522', '0546', '4');
INSERT INTO `district` VALUES ('1735', '广饶', '259', 'g', 'gr', 'guangrao', '', '县', '370523', '0546', '5');
INSERT INTO `district` VALUES ('1736', '芝罘', '260', 'z', 'zf', 'zhifu', '', '区', '370602', '0535', '1');
INSERT INTO `district` VALUES ('1737', '福山', '260', 'f', 'fs', 'fushan', '', '区', '370611', '0535', '2');
INSERT INTO `district` VALUES ('1738', '牟平', '260', 'm', 'mp', 'mouping', '', '区', '370612', '0535', '3');
INSERT INTO `district` VALUES ('1739', '莱山', '260', 'l', 'ls', 'laishan', '', '区', '370613', '0535', '4');
INSERT INTO `district` VALUES ('1740', '长岛', '260', 'z', 'zd', 'zhangdao', '', '县', '370634', '0535', '5');
INSERT INTO `district` VALUES ('1741', '龙口', '260', 'l', 'lk', 'longkou', '', '市', '370681', '0535', '6');
INSERT INTO `district` VALUES ('1742', '莱阳', '260', 'l', 'ly', 'laiyang', '', '市', '370682', '0535', '7');
INSERT INTO `district` VALUES ('1743', '莱州', '260', 'l', 'lz', 'laizhou', '', '市', '370683', '0535', '8');
INSERT INTO `district` VALUES ('1744', '蓬莱', '260', 'p', 'pl', 'penglai', '', '市', '370684', '0535', '9');
INSERT INTO `district` VALUES ('1745', '招远', '260', 'z', 'zy', 'zhaoyuan', '', '市', '370685', '0535', '10');
INSERT INTO `district` VALUES ('1746', '栖霞', '260', 'q', 'qx', 'qixia', '', '市', '370686', '0535', '11');
INSERT INTO `district` VALUES ('1747', '海阳', '260', 'h', 'hy', 'haiyang', '', '市', '370687', '0535', '12');
INSERT INTO `district` VALUES ('1748', '潍城', '261', 'w', 'wc', 'weicheng', '', '区', '370702', '0536', '1');
INSERT INTO `district` VALUES ('1749', '寒亭', '261', 'h', 'ht', 'hanting', '', '区', '370703', '0536', '2');
INSERT INTO `district` VALUES ('1750', '坊子', '261', 'f', 'fz', 'fangzi', '', '区', '370704', '0536', '3');
INSERT INTO `district` VALUES ('1751', '奎文', '261', 'k', 'kw', 'kuiwen', '', '区', '370705', '0536', '4');
INSERT INTO `district` VALUES ('1752', '临朐', '261', 'l', 'lq', 'linqu', '', '县', '370724', '0536', '5');
INSERT INTO `district` VALUES ('1753', '昌乐', '261', 'c', 'cl', 'changle', '', '县', '370725', '0536', '6');
INSERT INTO `district` VALUES ('1754', '青州', '261', 'q', 'qz', 'qingzhou', '', '市', '370781', '0536', '7');
INSERT INTO `district` VALUES ('1755', '诸城', '261', 'z', 'zc', 'zhucheng', '', '市', '370782', '0536', '8');
INSERT INTO `district` VALUES ('1756', '寿光', '261', 's', 'sg', 'shouguang', '', '市', '370783', '0536', '9');
INSERT INTO `district` VALUES ('1757', '安丘', '261', 'a', 'aq', 'anqiu', '', '市', '370784', '0536', '10');
INSERT INTO `district` VALUES ('1758', '高密', '261', 'g', 'gm', 'gaomi', '', '市', '370785', '0536', '11');
INSERT INTO `district` VALUES ('1759', '昌邑', '261', 'c', 'cy', 'changyi', '', '市', '370786', '0536', '12');
INSERT INTO `district` VALUES ('1761', '任城', '262', 'r', 'rc', 'rencheng', '', '区', '370811', '0537', '1');
INSERT INTO `district` VALUES ('1762', '微山', '262', 'w', 'ws', 'weishan', '', '县', '370826', '0537', '3');
INSERT INTO `district` VALUES ('1763', '鱼台', '262', 'y', 'yt', 'yutai', '', '县', '370827', '0537', '4');
INSERT INTO `district` VALUES ('1764', '金乡', '262', 'j', 'jx', 'jinxiang', '', '县', '370828', '0537', '5');
INSERT INTO `district` VALUES ('1765', '嘉祥', '262', 'j', 'jx', 'jiaxiang', '', '县', '370829', '0537', '6');
INSERT INTO `district` VALUES ('1766', '汶上', '262', 'w', 'ws', 'wenshang', '', '县', '370830', '0537', '7');
INSERT INTO `district` VALUES ('1767', '泗水', '262', 's', 'ss', 'sishui', '', '县', '370831', '0537', '8');
INSERT INTO `district` VALUES ('1768', '梁山', '262', 'l', 'ls', 'liangshan', '', '县', '370832', '0537', '9');
INSERT INTO `district` VALUES ('1769', '曲阜', '262', 'q', 'qf', 'qufu', '', '市', '370881', '0537', '10');
INSERT INTO `district` VALUES ('1770', '兖州', '262', 'y', 'yz', 'yanzhou', '', '区', '370812', '0537', '2');
INSERT INTO `district` VALUES ('1771', '邹城', '262', 'z', 'zc', 'zoucheng', '', '市', '370883', '0537', '11');
INSERT INTO `district` VALUES ('1772', '泰山', '263', 't', 'ts', 'taishan', '', '区', '370902', '0538', '1');
INSERT INTO `district` VALUES ('1773', '岱岳', '263', 'd', 'dy', 'daiyue', '', '区', '370911', '0538', '2');
INSERT INTO `district` VALUES ('1774', '宁阳', '263', 'n', 'ny', 'ningyang', '', '县', '370921', '0538', '3');
INSERT INTO `district` VALUES ('1775', '东平', '263', 'd', 'dp', 'dongping', '', '县', '370923', '0538', '4');
INSERT INTO `district` VALUES ('1776', '新泰', '263', 'x', 'xt', 'xintai', '', '市', '370982', '0538', '5');
INSERT INTO `district` VALUES ('1777', '肥城', '263', 'f', 'fc', 'feicheng', '', '市', '370983', '0538', '6');
INSERT INTO `district` VALUES ('1778', '环翠', '264', 'h', 'hc', 'huancui', '', '区', '371002', '0631', '1');
INSERT INTO `district` VALUES ('1779', '文登', '264', 'w', 'wd', 'wendeng', '', '区', '371003', '0631', '2');
INSERT INTO `district` VALUES ('1780', '荣成', '264', 'r', 'rc', 'rongcheng', '', '市', '371082', '0631', '3');
INSERT INTO `district` VALUES ('1781', '乳山', '264', 'r', 'rs', 'rushan', '', '市', '371083', '0631', '4');
INSERT INTO `district` VALUES ('1782', '东港', '265', 'd', 'dg', 'donggang', '', '区', '371102', '0633', '1');
INSERT INTO `district` VALUES ('1783', '岚山', '265', 'l', 'ls', 'lanshan', '', '区', '371103', '0633', '2');
INSERT INTO `district` VALUES ('1784', '五莲', '265', 'w', 'wl', 'wulian', '', '县', '371121', '0633', '3');
INSERT INTO `district` VALUES ('1785', '莒县', '265', 'j', 'jx', 'juxian', '', '', '371122', '0633', '4');
INSERT INTO `district` VALUES ('1786', '莱城', '266', 'l', 'lc', 'laicheng', '', '区', '371202', '0634', '1');
INSERT INTO `district` VALUES ('1787', '钢城', '266', 'g', 'gc', 'gangcheng', '', '区', '371203', '0634', '2');
INSERT INTO `district` VALUES ('1788', '兰山', '267', 'l', 'ls', 'lanshan', '', '区', '371302', '0539', '1');
INSERT INTO `district` VALUES ('1789', '罗庄', '267', 'l', 'lz', 'luozhuang', '', '区', '371311', '0539', '2');
INSERT INTO `district` VALUES ('1790', '河东', '267', 'h', 'hd', 'hedong', '', '区', '371312', '0539', '3');
INSERT INTO `district` VALUES ('1791', '沂南', '267', 'y', 'yn', 'yinan', '', '县', '371321', '0539', '4');
INSERT INTO `district` VALUES ('1792', '郯城', '267', 't', 'tc', 'tancheng', '', '县', '371322', '0539', '5');
INSERT INTO `district` VALUES ('1793', '沂水', '267', 'y', 'ys', 'yishui', '', '县', '371323', '0539', '6');
INSERT INTO `district` VALUES ('1794', '兰陵', '267', 'l', 'll', 'lanling', '', '县', '371324', '0539', '7');
INSERT INTO `district` VALUES ('1795', '费县', '267', 'f', 'fx', 'feixian', '', '', '371325', '0539', '8');
INSERT INTO `district` VALUES ('1796', '平邑', '267', 'p', 'py', 'pingyi', '', '县', '371326', '0539', '9');
INSERT INTO `district` VALUES ('1797', '莒南', '267', 'j', 'jn', 'junan', '', '县', '371327', '0539', '10');
INSERT INTO `district` VALUES ('1798', '蒙阴', '267', 'm', 'my', 'mengyin', '', '县', '371328', '0539', '11');
INSERT INTO `district` VALUES ('1799', '临沭', '267', 'l', 'ls', 'linshu', '', '县', '371329', '0539', '12');
INSERT INTO `district` VALUES ('1800', '德城', '268', 'd', 'dc', 'decheng', '', '区', '371402', '0534', '1');
INSERT INTO `district` VALUES ('1801', '陵城', '268', 'l', 'lc', 'lingcheng', '', '区', '371403', '0534', '2');
INSERT INTO `district` VALUES ('1802', '宁津', '268', 'n', 'nj', 'ningjin', '', '县', '371422', '0534', '3');
INSERT INTO `district` VALUES ('1803', '庆云', '268', 'q', 'qy', 'qingyun', '', '县', '371423', '0534', '4');
INSERT INTO `district` VALUES ('1804', '临邑', '268', 'l', 'ly', 'linyi', '', '县', '371424', '0534', '5');
INSERT INTO `district` VALUES ('1805', '齐河', '268', 'q', 'qh', 'qihe', '', '县', '371425', '0534', '6');
INSERT INTO `district` VALUES ('1806', '平原', '268', 'p', 'py', 'pingyuan', '', '县', '371426', '0534', '7');
INSERT INTO `district` VALUES ('1807', '夏津', '268', 'x', 'xj', 'xiajin', '', '县', '371427', '0534', '8');
INSERT INTO `district` VALUES ('1808', '武城', '268', 'w', 'wc', 'wucheng', '', '县', '371428', '0534', '9');
INSERT INTO `district` VALUES ('1809', '乐陵', '268', 'l', 'll', 'leling', '', '市', '371481', '0534', '10');
INSERT INTO `district` VALUES ('1810', '禹城', '268', 'y', 'yc', 'yucheng', '', '市', '371482', '0534', '11');
INSERT INTO `district` VALUES ('1811', '东昌府', '269', 'd', 'dcf', 'dongchangfu', '', '区', '371502', '0635', '1');
INSERT INTO `district` VALUES ('1812', '阳谷', '269', 'y', 'yg', 'yanggu', '', '县', '371521', '0635', '2');
INSERT INTO `district` VALUES ('1813', '莘县', '269', 'x', 'xx', 'xinxian', '', '', '371522', '0635', '3');
INSERT INTO `district` VALUES ('1814', '茌平', '269', 'c', 'cp', 'chiping', '', '县', '371523', '0635', '4');
INSERT INTO `district` VALUES ('1815', '东阿', '269', 'd', 'da', 'donga', '', '县', '371524', '0635', '5');
INSERT INTO `district` VALUES ('1816', '冠县', '269', 'g', 'gx', 'guanxian', '', '', '371525', '0635', '6');
INSERT INTO `district` VALUES ('1817', '高唐', '269', 'g', 'gt', 'gaotang', '', '县', '371526', '0635', '7');
INSERT INTO `district` VALUES ('1818', '临清', '269', 'l', 'lq', 'linqing', '', '市', '371581', '0635', '8');
INSERT INTO `district` VALUES ('1819', '滨城', '270', 'b', 'bc', 'bincheng', '', '区', '371602', '0543', '1');
INSERT INTO `district` VALUES ('1820', '惠民', '270', 'h', 'hm', 'huimin', '', '县', '371621', '0543', '2');
INSERT INTO `district` VALUES ('1821', '阳信', '270', 'y', 'yx', 'yangxin', '', '县', '371622', '0543', '3');
INSERT INTO `district` VALUES ('1822', '无棣', '270', 'w', 'wd', 'wudi', '', '县', '371623', '0543', '4');
INSERT INTO `district` VALUES ('1823', '沾化', '270', 'z', 'zh', 'zhanhua', '', '区', '371624', '0543', '5');
INSERT INTO `district` VALUES ('1824', '博兴', '270', 'b', 'bx', 'boxing', '', '县', '371625', '0543', '6');
INSERT INTO `district` VALUES ('1825', '邹平', '270', 'z', 'zp', 'zouping', '', '县', '371626', '0543', '7');
INSERT INTO `district` VALUES ('1826', '牡丹', '271', 'm', 'md', 'mudan', '', '区', '371702', '0530', '1');
INSERT INTO `district` VALUES ('1827', '曹县', '271', 'c', 'cx', 'caoxian', '', '', '371721', '0530', '2');
INSERT INTO `district` VALUES ('1828', '单县', '271', 'd', 'dx', 'danxian', '', '', '371722', '0530', '3');
INSERT INTO `district` VALUES ('1829', '成武', '271', 'c', 'cw', 'chengwu', '', '县', '371723', '0530', '4');
INSERT INTO `district` VALUES ('1830', '巨野', '271', 'j', 'jy', 'juye', '', '县', '371724', '0530', '5');
INSERT INTO `district` VALUES ('1831', '郓城', '271', 'y', 'yc', 'yuncheng', '', '县', '371725', '0530', '6');
INSERT INTO `district` VALUES ('1832', '鄄城', '271', 'j', 'jc', 'juancheng', '', '县', '371726', '0530', '7');
INSERT INTO `district` VALUES ('1833', '定陶', '271', 'd', 'dt', 'dingtao', '', '区', '371727', '0530', '8');
INSERT INTO `district` VALUES ('1834', '东明', '271', 'd', 'dm', 'dongming', '', '县', '371728', '0530', '9');
INSERT INTO `district` VALUES ('1835', '中原', '272', 'z', 'zy', 'zhongyuan', '', '区', '410102', '0371', '1');
INSERT INTO `district` VALUES ('1836', '二七', '272', 'e', 'eq', 'erqi', '', '区', '410103', '0371', '2');
INSERT INTO `district` VALUES ('1837', '管城', '272', 'g', 'gc', 'guancheng', '回族', '区', '410104', '0371', '3');
INSERT INTO `district` VALUES ('1838', '金水', '272', 'j', 'js', 'jinshui', '', '区', '410105', '0371', '4');
INSERT INTO `district` VALUES ('1839', '上街', '272', 's', 'sj', 'shangjie', '', '区', '410106', '0371', '5');
INSERT INTO `district` VALUES ('1840', '惠济', '272', 'h', 'hj', 'huiji', '', '区', '410108', '0371', '6');
INSERT INTO `district` VALUES ('1841', '中牟', '272', 'z', 'zm', 'zhongmou', '', '县', '410122', '0371', '7');
INSERT INTO `district` VALUES ('1842', '巩义', '272', 'g', 'gy', 'gongyi', '', '市', '410181', '0371', '8');
INSERT INTO `district` VALUES ('1843', '荥阳', '272', 'y', 'yy', 'yingyang', '', '市', '410182', '0371', '9');
INSERT INTO `district` VALUES ('1844', '新密', '272', 'x', 'xm', 'xinmi', '', '市', '410183', '0371', '10');
INSERT INTO `district` VALUES ('1845', '新郑', '272', 'x', 'xz', 'xinzheng', '', '市', '410184', '0371', '11');
INSERT INTO `district` VALUES ('1846', '登封', '272', 'd', 'df', 'dengfeng', '', '市', '410185', '0371', '12');
INSERT INTO `district` VALUES ('1847', '龙亭', '273', 'l', 'lt', 'longting', '', '区', '410202', '0378', '1');
INSERT INTO `district` VALUES ('1848', '顺河', '273', 's', 'sh', 'shunhe', '回族', '区', '410203', '0378', '2');
INSERT INTO `district` VALUES ('1849', '鼓楼', '273', 'g', 'gl', 'gulou', '', '区', '410204', '0378', '3');
INSERT INTO `district` VALUES ('1850', '禹王台', '273', 'y', 'ywt', 'yuwangtai', '', '区', '410205', '0378', '4');
INSERT INTO `district` VALUES ('1852', '杞县', '273', 'q', 'qx', 'qixian', '', '', '410221', '0378', '6');
INSERT INTO `district` VALUES ('1853', '通许', '273', 't', 'tx', 'tongxu', '', '县', '410222', '0378', '7');
INSERT INTO `district` VALUES ('1854', '尉氏', '273', 'w', 'ws', 'weishi', '', '县', '410223', '0378', '8');
INSERT INTO `district` VALUES ('1855', '祥符', '273', 'x', 'xf', 'kaifeng', '', '区', '410212', '0378', '5');
INSERT INTO `district` VALUES ('1856', '兰考', '273', 'l', 'lk', 'lankao', '', '县', '410225', '0378', '9');
INSERT INTO `district` VALUES ('1857', '老城', '274', 'l', 'lc', 'laocheng', '', '区', '410302', '0376', '1');
INSERT INTO `district` VALUES ('1858', '西工', '274', 'x', 'xg', 'xigong', '', '区', '410303', '0376', '2');
INSERT INTO `district` VALUES ('1859', '瀍河', '274', 'c', 'ch', 'chanhe', '回族', '区', '410304', '0376', '3');
INSERT INTO `district` VALUES ('1860', '涧西', '274', 'j', 'jx', 'jianxi', '', '区', '410305', '0376', '4');
INSERT INTO `district` VALUES ('1861', '吉利', '274', 'j', 'jl', 'jili', '', '区', '410306', '0376', '5');
INSERT INTO `district` VALUES ('1862', '洛龙', '274', 'l', 'll', 'luolong', '', '区', '410311', '0376', '6');
INSERT INTO `district` VALUES ('1863', '孟津', '274', 'm', 'mj', 'mengjin', '', '县', '410322', '0376', '7');
INSERT INTO `district` VALUES ('1864', '新安', '274', 'x', 'xa', 'xinan', '', '县', '410323', '0376', '8');
INSERT INTO `district` VALUES ('1865', '栾川', '274', 'l', 'lc', 'luanchuan', '', '县', '410324', '0376', '9');
INSERT INTO `district` VALUES ('1866', '嵩县', '274', 's', 'sx', 'songxian', '', '', '410325', '0376', '10');
INSERT INTO `district` VALUES ('1867', '汝阳', '274', 'r', 'ry', 'ruyang', '', '县', '410326', '0376', '11');
INSERT INTO `district` VALUES ('1868', '宜阳', '274', 'y', 'yy', 'yiyang', '', '县', '410327', '0376', '12');
INSERT INTO `district` VALUES ('1869', '洛宁', '274', 'l', 'ln', 'luoning', '', '县', '410328', '0376', '13');
INSERT INTO `district` VALUES ('1870', '伊川', '274', 'y', 'yc', 'yichuan', '', '县', '410329', '0376', '14');
INSERT INTO `district` VALUES ('1871', '偃师', '274', 'y', 'ys', 'yanshi', '', '市', '410381', '0376', '15');
INSERT INTO `district` VALUES ('1872', '新华', '275', 'x', 'xh', 'xinhua', '', '区', '410402', '0375', '1');
INSERT INTO `district` VALUES ('1873', '卫东', '275', 'w', 'wd', 'weidong', '', '区', '410403', '0375', '2');
INSERT INTO `district` VALUES ('1874', '石龙', '275', 's', 'sl', 'shilong', '', '区', '410404', '0375', '3');
INSERT INTO `district` VALUES ('1875', '湛河', '275', 'z', 'zh', 'zhanhe', '', '区', '410411', '0375', '4');
INSERT INTO `district` VALUES ('1876', '宝丰', '275', 'b', 'bf', 'baofeng', '', '县', '410421', '0375', '5');
INSERT INTO `district` VALUES ('1877', '叶县', '275', 'y', 'yx', 'yexian', '', '', '410422', '0375', '6');
INSERT INTO `district` VALUES ('1878', '鲁山', '275', 'l', 'ls', 'lushan', '', '县', '410423', '0375', '7');
INSERT INTO `district` VALUES ('1879', '郏县', '275', 'j', 'jx', 'jiaxian', '', '', '410425', '0375', '8');
INSERT INTO `district` VALUES ('1880', '舞钢', '275', 'w', 'wg', 'wugang', '', '市', '410481', '0375', '9');
INSERT INTO `district` VALUES ('1881', '汝州', '275', 'r', 'rz', 'ruzhou', '', '市', '410482', '0375', '10');
INSERT INTO `district` VALUES ('1882', '文峰', '276', 'w', 'wf', 'wenfeng', '', '区', '410502', '0372', '1');
INSERT INTO `district` VALUES ('1883', '北关', '276', 'b', 'bg', 'beiguan', '', '区', '410503', '0372', '2');
INSERT INTO `district` VALUES ('1884', '殷都', '276', 'y', 'yd', 'yindou', '', '区', '410505', '0372', '3');
INSERT INTO `district` VALUES ('1885', '龙安', '276', 'l', 'la', 'longan', '', '区', '410506', '0372', '4');
INSERT INTO `district` VALUES ('1886', '安阳', '276', 'a', 'ay', 'anyang', '', '县', '410522', '0372', '5');
INSERT INTO `district` VALUES ('1887', '汤阴', '276', 't', 'ty', 'tangyin', '', '县', '410523', '0372', '6');
INSERT INTO `district` VALUES ('1888', '滑县', '276', 'h', 'hx', 'huaxian', '', '', '410526', '0372', '7');
INSERT INTO `district` VALUES ('1889', '内黄', '276', 'n', 'nh', 'neihuang', '', '县', '410527', '0372', '8');
INSERT INTO `district` VALUES ('1890', '林州', '276', 'l', 'lz', 'linzhou', '', '市', '410581', '0372', '9');
INSERT INTO `district` VALUES ('1891', '鹤山', '277', 'h', 'hs', 'heshan', '', '区', '410602', '0392', '1');
INSERT INTO `district` VALUES ('1892', '山城', '277', 's', 'sc', 'shancheng', '', '区', '410603', '0392', '2');
INSERT INTO `district` VALUES ('1893', '淇滨', '277', 'q', 'qb', 'qibin', '', '区', '410611', '0392', '3');
INSERT INTO `district` VALUES ('1894', '浚县', '277', 'j', 'jx', 'junxian', '', '', '410621', '0392', '4');
INSERT INTO `district` VALUES ('1895', '淇县', '277', 'q', 'qx', 'qixian', '', '', '410622', '0392', '5');
INSERT INTO `district` VALUES ('1896', '红旗', '278', 'h', 'hq', 'hongqi', '', '区', '410702', '0373', '1');
INSERT INTO `district` VALUES ('1897', '卫滨', '278', 'w', 'wb', 'weibin', '', '区', '410703', '0373', '2');
INSERT INTO `district` VALUES ('1898', '凤泉', '278', 'f', 'fq', 'fengquan', '', '区', '410704', '0373', '3');
INSERT INTO `district` VALUES ('1899', '牧野', '278', 'm', 'my', 'muye', '', '区', '410711', '0373', '4');
INSERT INTO `district` VALUES ('1900', '新乡', '278', 'x', 'xx', 'xinxiang', '', '县', '410721', '0373', '5');
INSERT INTO `district` VALUES ('1901', '获嘉', '278', 'h', 'hj', 'huojia', '', '县', '410724', '0373', '6');
INSERT INTO `district` VALUES ('1902', '原阳', '278', 'y', 'yy', 'yuanyang', '', '县', '410725', '0373', '7');
INSERT INTO `district` VALUES ('1903', '延津', '278', 'y', 'yj', 'yanjin', '', '县', '410726', '0373', '8');
INSERT INTO `district` VALUES ('1904', '封丘', '278', 'f', 'fq', 'fengqiu', '', '县', '410727', '0373', '9');
INSERT INTO `district` VALUES ('1905', '长垣', '278', 'z', 'zy', 'zhangyuan', '', '县', '410728', '0373', '10');
INSERT INTO `district` VALUES ('1906', '卫辉', '278', 'w', 'wh', 'weihui', '', '市', '410781', '0373', '11');
INSERT INTO `district` VALUES ('1907', '辉县', '278', 'h', 'hx', 'huixian', '', '市', '410782', '0373', '12');
INSERT INTO `district` VALUES ('1908', '解放', '279', 'j', 'jf', 'jiefang', '', '区', '410802', '0391', '1');
INSERT INTO `district` VALUES ('1909', '中站', '279', 'z', 'zz', 'zhongzhan', '', '区', '410803', '0391', '2');
INSERT INTO `district` VALUES ('1910', '马村', '279', 'm', 'mc', 'macun', '', '区', '410804', '0391', '3');
INSERT INTO `district` VALUES ('1911', '山阳', '279', 's', 'sy', 'shanyang', '', '区', '410811', '0391', '4');
INSERT INTO `district` VALUES ('1912', '修武', '279', 'x', 'xw', 'xiuwu', '', '县', '410821', '0391', '5');
INSERT INTO `district` VALUES ('1913', '博爱', '279', 'b', 'ba', 'boai', '', '县', '410822', '0391', '6');
INSERT INTO `district` VALUES ('1914', '武陟', '279', 'w', 'wz', 'wuzhi', '', '县', '410823', '0391', '7');
INSERT INTO `district` VALUES ('1915', '温县', '279', 'w', 'wx', 'wenxian', '', '', '410825', '0391', '8');
INSERT INTO `district` VALUES ('1916', '沁阳', '279', 'q', 'qy', 'qinyang', '', '市', '410882', '0391', '9');
INSERT INTO `district` VALUES ('1917', '孟州', '279', 'm', 'mz', 'mengzhou', '', '市', '410883', '0391', '10');
INSERT INTO `district` VALUES ('1918', '华龙', '280', 'h', 'hl', 'hualong', '', '区', '410902', '', '1');
INSERT INTO `district` VALUES ('1919', '清丰', '280', 'q', 'qf', 'qingfeng', '', '县', '410922', '', '2');
INSERT INTO `district` VALUES ('1920', '南乐', '280', 'n', 'nl', 'nanle', '', '县', '410923', '', '3');
INSERT INTO `district` VALUES ('1921', '范县', '280', 'f', 'fx', 'fanxian', '', '', '410926', '', '4');
INSERT INTO `district` VALUES ('1922', '台前', '280', 't', 'tq', 'taiqian', '', '县', '410927', '', '5');
INSERT INTO `district` VALUES ('1923', '濮阳', '280', 'p', 'py', 'puyang', '', '县', '410928', '', '6');
INSERT INTO `district` VALUES ('1924', '魏都', '281', 'w', 'wd', 'weidou', '', '区', '411002', '0374', '1');
INSERT INTO `district` VALUES ('1925', '建安', '281', 'j', 'ja', 'jianan', '', '区', '411023', '0374', '2');
INSERT INTO `district` VALUES ('1926', '鄢陵', '281', 'y', 'yl', 'yanling', '', '县', '411024', '0374', '3');
INSERT INTO `district` VALUES ('1927', '襄城', '281', 'x', 'xc', 'xiangcheng', '', '县', '411025', '0374', '4');
INSERT INTO `district` VALUES ('1928', '禹州', '281', 'y', 'yz', 'yuzhou', '', '市', '411081', '0374', '5');
INSERT INTO `district` VALUES ('1929', '长葛', '281', 'z', 'zg', 'zhangge', '', '市', '411082', '0374', '6');
INSERT INTO `district` VALUES ('1930', '源汇', '282', 'y', 'yh', 'yuanhui', '', '区', '411102', '0395', '1');
INSERT INTO `district` VALUES ('1931', '郾城', '282', 'y', 'yc', 'yancheng', '', '区', '411103', '0395', '2');
INSERT INTO `district` VALUES ('1932', '召陵', '282', 'z', 'zl', 'zhaoling', '', '区', '411104', '0395', '3');
INSERT INTO `district` VALUES ('1933', '舞阳', '282', 'w', 'wy', 'wuyang', '', '县', '411121', '0395', '4');
INSERT INTO `district` VALUES ('1934', '临颍', '282', 'l', 'ly', 'linying', '', '县', '411122', '0395', '5');
INSERT INTO `district` VALUES ('1935', '湖滨', '283', 'h', 'hb', 'hubin', '', '区', '411202', '0398', '1');
INSERT INTO `district` VALUES ('1936', '渑池', '283', 'm', 'mc', 'mianchi', '', '县', '411221', '0398', '3');
INSERT INTO `district` VALUES ('1937', '陕州', '283', 's', 'sz', 'shanzhou', '', '区', '411222', '0398', '2');
INSERT INTO `district` VALUES ('1938', '卢氏', '283', 'l', 'ls', 'lushi', '', '县', '411224', '0398', '4');
INSERT INTO `district` VALUES ('1939', '义马', '283', 'y', 'ym', 'yima', '', '市', '411281', '0398', '5');
INSERT INTO `district` VALUES ('1940', '灵宝', '283', 'l', 'lb', 'lingbao', '', '市', '411282', '0398', '6');
INSERT INTO `district` VALUES ('1941', '宛城', '284', 'w', 'wc', 'wancheng', '', '区', '411302', '0377', '1');
INSERT INTO `district` VALUES ('1942', '卧龙', '284', 'w', 'wl', 'wolong', '', '区', '411303', '0377', '2');
INSERT INTO `district` VALUES ('1943', '南召', '284', 'n', 'nz', 'nanzhao', '', '县', '411321', '0377', '3');
INSERT INTO `district` VALUES ('1944', '方城', '284', 'f', 'fc', 'fangcheng', '', '县', '411322', '0377', '4');
INSERT INTO `district` VALUES ('1945', '西峡', '284', 'x', 'xx', 'xixia', '', '县', '411323', '0377', '5');
INSERT INTO `district` VALUES ('1946', '镇平', '284', 'z', 'zp', 'zhenping', '', '县', '411324', '0377', '6');
INSERT INTO `district` VALUES ('1947', '内乡', '284', 'n', 'nx', 'neixiang', '', '县', '411325', '0377', '7');
INSERT INTO `district` VALUES ('1948', '淅川', '284', 'x', 'xc', 'xichuan', '', '县', '411326', '0377', '8');
INSERT INTO `district` VALUES ('1949', '社旗', '284', 's', 'sq', 'sheqi', '', '县', '411327', '0377', '9');
INSERT INTO `district` VALUES ('1950', '唐河', '284', 't', 'th', 'tanghe', '', '县', '411328', '0377', '10');
INSERT INTO `district` VALUES ('1951', '新野', '284', 'x', 'xy', 'xinye', '', '县', '411329', '0377', '11');
INSERT INTO `district` VALUES ('1952', '桐柏', '284', 't', 'tb', 'tongbo', '', '县', '411330', '0377', '12');
INSERT INTO `district` VALUES ('1953', '邓州', '284', 'd', 'dz', 'dengzhou', '', '市', '411381', '0377', '13');
INSERT INTO `district` VALUES ('1954', '粱园', '285', 'l', 'ly', 'liangyuan', '', '区', '411402', '0370', '1');
INSERT INTO `district` VALUES ('1955', '睢阳', '285', 's', 'sy', 'suiyang', '', '区', '411403', '0370', '2');
INSERT INTO `district` VALUES ('1956', '民权', '285', 'm', 'mq', 'minquan', '', '县', '411421', '0370', '3');
INSERT INTO `district` VALUES ('1957', '睢县', '285', 's', 'sx', 'suixian', '', '', '411422', '0370', '4');
INSERT INTO `district` VALUES ('1958', '宁陵', '285', 'n', 'nl', 'ningling', '', '县', '411423', '0370', '5');
INSERT INTO `district` VALUES ('1959', '柘城', '285', 'z', 'zc', 'zhecheng', '', '县', '411424', '0370', '6');
INSERT INTO `district` VALUES ('1960', '虞城', '285', 'y', 'yc', 'yucheng', '', '县', '411425', '0370', '7');
INSERT INTO `district` VALUES ('1961', '夏邑', '285', 'x', 'xy', 'xiayi', '', '县', '411426', '0370', '8');
INSERT INTO `district` VALUES ('1962', '永城', '285', 'y', 'yc', 'yongcheng', '', '市', '411481', '0370', '9');
INSERT INTO `district` VALUES ('1963', '浉河', '286', 's', 'sh', 'shihe', '', '区', '411502', '0376', '1');
INSERT INTO `district` VALUES ('1964', '平桥', '286', 'p', 'pq', 'pingqiao', '', '区', '411503', '0376', '2');
INSERT INTO `district` VALUES ('1965', '罗山', '286', 'l', 'ls', 'luoshan', '', '县', '411521', '0376', '3');
INSERT INTO `district` VALUES ('1966', '光山', '286', 'g', 'gs', 'guangshan', '', '县', '411522', '0376', '4');
INSERT INTO `district` VALUES ('1967', '新县', '286', 'x', 'xx', 'xinxian', '', '', '411523', '0376', '5');
INSERT INTO `district` VALUES ('1968', '商城', '286', 's', 'sc', 'shangcheng', '', '县', '411524', '0376', '6');
INSERT INTO `district` VALUES ('1969', '固始', '286', 'g', 'gs', 'gushi', '', '县', '411525', '0376', '7');
INSERT INTO `district` VALUES ('1970', '潢川', '286', 'h', 'hc', 'huangchuan', '', '县', '411526', '0376', '8');
INSERT INTO `district` VALUES ('1971', '淮滨', '286', 'h', 'hb', 'huaibin', '', '县', '411527', '0376', '9');
INSERT INTO `district` VALUES ('1972', '息县', '286', 'x', 'xx', 'xixian', '', '', '411528', '0376', '10');
INSERT INTO `district` VALUES ('1973', '川汇', '287', 'c', 'ch', 'chuanhui', '', '区', '411602', '0394', '1');
INSERT INTO `district` VALUES ('1974', '扶沟', '287', 'f', 'fg', 'fugou', '', '县', '411621', '0394', '2');
INSERT INTO `district` VALUES ('1975', '西华', '287', 'x', 'xh', 'xihua', '', '县', '411622', '0394', '3');
INSERT INTO `district` VALUES ('1976', '商水', '287', 's', 'ss', 'shangshui', '', '县', '411623', '0394', '4');
INSERT INTO `district` VALUES ('1977', '沈丘', '287', 's', 'sq', 'shenqiu', '', '县', '411624', '0394', '5');
INSERT INTO `district` VALUES ('1978', '郸城', '287', 'd', 'dc', 'dancheng', '', '县', '411625', '0394', '6');
INSERT INTO `district` VALUES ('1979', '淮阳', '287', 'h', 'hy', 'huaiyang', '', '县', '411626', '0394', '7');
INSERT INTO `district` VALUES ('1980', '太康', '287', 't', 'tk', 'taikang', '', '县', '411627', '0394', '8');
INSERT INTO `district` VALUES ('1981', '鹿邑', '287', 'l', 'ly', 'luyi', '', '县', '411628', '0394', '9');
INSERT INTO `district` VALUES ('1982', '项城', '287', 'x', 'xc', 'xiangcheng', '', '市', '411681', '0394', '10');
INSERT INTO `district` VALUES ('1983', '驿城', '288', 'y', 'yc', 'yicheng', '', '区', '411702', '0396', '1');
INSERT INTO `district` VALUES ('1984', '西平', '288', 'x', 'xp', 'xiping', '', '县', '411721', '0396', '2');
INSERT INTO `district` VALUES ('1985', '上蔡', '288', 's', 'sc', 'shangcai', '', '县', '411722', '0396', '3');
INSERT INTO `district` VALUES ('1986', '平舆', '288', 'p', 'py', 'pingyu', '', '县', '411723', '0396', '4');
INSERT INTO `district` VALUES ('1987', '正阳', '288', 'z', 'zy', 'zhengyang', '', '县', '411724', '0396', '5');
INSERT INTO `district` VALUES ('1988', '确山', '288', 'q', 'qs', 'queshan', '', '县', '411725', '0396', '6');
INSERT INTO `district` VALUES ('1989', '泌阳', '288', 'm', 'my', 'miyang', '', '县', '411726', '0396', '7');
INSERT INTO `district` VALUES ('1990', '汝南', '288', 'r', 'rn', 'runan', '', '县', '411727', '0396', '8');
INSERT INTO `district` VALUES ('1991', '遂平', '288', 's', 'sp', 'suiping', '', '县', '411728', '0396', '9');
INSERT INTO `district` VALUES ('1992', '新蔡', '288', 'x', 'xc', 'xincai', '', '县', '411729', '0396', '10');
INSERT INTO `district` VALUES ('1993', '江岸', '290', 'j', 'ja', 'jiangan', '', '区', '420102', '027', '1');
INSERT INTO `district` VALUES ('1994', '江汉', '290', 'j', 'jh', 'jianghan', '', '区', '420103', '027', '2');
INSERT INTO `district` VALUES ('1995', '硚口', '290', 'q', 'qk', 'qiaokou', '', '区', '420104', '027', '3');
INSERT INTO `district` VALUES ('1996', '汉阳', '290', 'h', 'hy', 'hanyang', '', '区', '420105', '027', '4');
INSERT INTO `district` VALUES ('1997', '武昌', '290', 'w', 'wc', 'wuchang', '', '区', '420106', '027', '5');
INSERT INTO `district` VALUES ('1998', '青山', '290', 'q', 'qs', 'qingshan', '', '区', '420107', '027', '6');
INSERT INTO `district` VALUES ('1999', '洪山', '290', 'h', 'hs', 'hongshan', '', '区', '420111', '027', '7');
INSERT INTO `district` VALUES ('2000', '东西湖', '290', 'd', 'dxh', 'dongxihu', '', '区', '420112', '027', '8');
INSERT INTO `district` VALUES ('2001', '汉南', '290', 'h', 'hn', 'hannan', '', '区', '420113', '027', '9');
INSERT INTO `district` VALUES ('2002', '蔡甸', '290', 'c', 'cd', 'caidian', '', '区', '420114', '027', '10');
INSERT INTO `district` VALUES ('2003', '江夏', '290', 'j', 'jx', 'jiangxia', '', '区', '420115', '027', '11');
INSERT INTO `district` VALUES ('2004', '黄陂', '290', 'h', 'hp', 'huangpo', '', '区', '420116', '027', '12');
INSERT INTO `district` VALUES ('2005', '新洲', '290', 'x', 'xz', 'xinzhou', '', '区', '420117', '027', '13');
INSERT INTO `district` VALUES ('2006', '黄石港', '291', 'h', 'hsg', 'huangshigang', '', '区', '420202', '0714', '1');
INSERT INTO `district` VALUES ('2007', '西塞山', '291', 'x', 'xss', 'xisaishan', '', '区', '420203', '0714', '2');
INSERT INTO `district` VALUES ('2008', '下陆', '291', 'x', 'xl', 'xialu', '', '区', '420204', '0714', '3');
INSERT INTO `district` VALUES ('2009', '铁山', '291', 't', 'ts', 'tieshan', '', '区', '420205', '0714', '4');
INSERT INTO `district` VALUES ('2010', '阳新', '291', 'y', 'yx', 'yangxin', '', '县', '420222', '0714', '5');
INSERT INTO `district` VALUES ('2011', '大冶', '291', 'd', 'dy', 'daye', '', '市', '420281', '0714', '6');
INSERT INTO `district` VALUES ('2012', '茅箭', '292', 'm', 'mj', 'maojian', '', '区', '420302', '0719', '1');
INSERT INTO `district` VALUES ('2013', '张湾', '292', 'z', 'zw', 'zhangwan', '', '区', '420303', '0719', '2');
INSERT INTO `district` VALUES ('2014', '郧阳', '292', 'y', 'yy', 'yunyang', '', '区', '420304', '0719', '3');
INSERT INTO `district` VALUES ('2015', '郧西', '292', 'y', 'yx', 'yunxi', '', '县', '420322', '0719', '4');
INSERT INTO `district` VALUES ('2016', '竹山', '292', 'z', 'zs', 'zhushan', '', '县', '420323', '0719', '5');
INSERT INTO `district` VALUES ('2017', '竹溪', '292', 'z', 'zx', 'zhuxi', '', '县', '420324', '0719', '6');
INSERT INTO `district` VALUES ('2018', '房县', '292', 'f', 'fx', 'fangxian', '', '', '420325', '0719', '7');
INSERT INTO `district` VALUES ('2019', '丹江口', '292', 'd', 'djk', 'danjiangkou', '', '市', '420381', '0719', '8');
INSERT INTO `district` VALUES ('2020', '西陵', '293', 'x', 'xl', 'xiling', '', '区', '420502', '0717', '1');
INSERT INTO `district` VALUES ('2021', '伍家岗', '293', 'w', 'wjg', 'wujiagang', '', '区', '420503', '0717', '2');
INSERT INTO `district` VALUES ('2022', '点军', '293', 'd', 'dj', 'dianjun', '', '区', '420504', '0717', '3');
INSERT INTO `district` VALUES ('2023', '虢亭', '293', 'g', 'gt', 'guoting', '', '区', '420505', '0717', '4');
INSERT INTO `district` VALUES ('2024', '夷陵', '293', 'y', 'yl', 'yiling', '', '区', '420506', '0717', '5');
INSERT INTO `district` VALUES ('2025', '远安', '293', 'y', 'ya', 'yuanan', '', '县', '420525', '0717', '6');
INSERT INTO `district` VALUES ('2026', '兴山', '293', 'x', 'xs', 'xingshan', '', '县', '420526', '0717', '7');
INSERT INTO `district` VALUES ('2027', '秭归', '293', 'z', 'zg', 'zigui', '', '县', '420527', '0717', '8');
INSERT INTO `district` VALUES ('2028', '长阳', '293', 'z', 'zy', 'zhangyang', '土家族', '自治县', '420528', '0717', '9');
INSERT INTO `district` VALUES ('2029', '五峰', '293', 'w', 'wf', 'wufeng', '土家族', '自治县', '420529', '0717', '10');
INSERT INTO `district` VALUES ('2030', '宜都', '293', 'y', 'yd', 'yidou', '', '市', '420581', '0717', '11');
INSERT INTO `district` VALUES ('2031', '当阳', '293', 'd', 'dy', 'dangyang', '', '市', '420582', '0717', '12');
INSERT INTO `district` VALUES ('2032', '枝江', '293', 'z', 'zj', 'zhijiang', '', '市', '420583', '0717', '13');
INSERT INTO `district` VALUES ('2033', '襄城', '294', 'x', 'xc', 'xiangcheng', '', '区', '420602', '0710', '1');
INSERT INTO `district` VALUES ('2034', '樊城', '294', 'f', 'fc', 'fancheng', '', '区', '420606', '0710', '2');
INSERT INTO `district` VALUES ('2035', '襄州', '294', 'x', 'xz', 'xiangzhou', '', '区', '420607', '0710', '3');
INSERT INTO `district` VALUES ('2036', '南漳', '294', 'n', 'nz', 'nanzhang', '', '县', '420624', '0710', '4');
INSERT INTO `district` VALUES ('2037', '谷城', '294', 'g', 'gc', 'gucheng', '', '县', '420625', '0710', '5');
INSERT INTO `district` VALUES ('2038', '保康', '294', 'b', 'bk', 'baokang', '', '县', '420626', '0710', '6');
INSERT INTO `district` VALUES ('2039', '老河口', '294', 'l', 'lhk', 'laohekou', '', '市', '420682', '0710', '7');
INSERT INTO `district` VALUES ('2040', '枣阳', '294', 'z', 'zy', 'zaoyang', '', '市', '420683', '0710', '8');
INSERT INTO `district` VALUES ('2041', '宜城', '294', 'y', 'yc', 'yicheng', '', '市', '420684', '0710', '9');
INSERT INTO `district` VALUES ('2042', '粱子湖', '295', 'l', 'lzh', 'liangzihu', '', '区', '420702', '', '1');
INSERT INTO `district` VALUES ('2043', '华容', '295', 'h', 'hr', 'huarong', '', '区', '420703', '', '2');
INSERT INTO `district` VALUES ('2044', '鄂城', '295', 'e', 'ec', 'echeng', '', '区', '420704', '', '3');
INSERT INTO `district` VALUES ('2045', '东宝', '296', 'd', 'db', 'dongbao', '', '区', '420802', '0724', '1');
INSERT INTO `district` VALUES ('2046', '掇刀', '296', 'd', 'dd', 'duodao', '', '区', '420804', '0724', '2');
INSERT INTO `district` VALUES ('2047', '京山', '296', 'j', 'js', 'jingshan', '', '县', '420821', '0724', '3');
INSERT INTO `district` VALUES ('2048', '沙洋', '296', 's', 'sy', 'shayang', '', '县', '420822', '0724', '4');
INSERT INTO `district` VALUES ('2049', '钟祥', '296', 'z', 'zx', 'zhongxiang', '', '市', '420881', '0724', '5');
INSERT INTO `district` VALUES ('2050', '孝南', '297', 'x', 'xn', 'xiaonan', '', '区', '420902', '0712', '1');
INSERT INTO `district` VALUES ('2051', '大悟', '297', 'd', 'dw', 'dawu', '', '县', '420922', '0712', '2');
INSERT INTO `district` VALUES ('2052', '云梦', '297', 'y', 'ym', 'yunmeng', '', '县', '420923', '0712', '3');
INSERT INTO `district` VALUES ('2053', '应城', '297', 'y', 'yc', 'yingcheng', '', '市', '420981', '0712', '4');
INSERT INTO `district` VALUES ('2054', '安陆', '297', 'a', 'al', 'anlu', '', '市', '420982', '0712', '5');
INSERT INTO `district` VALUES ('2055', '汉川', '297', 'h', 'hc', 'hanchuan', '', '市', '420984', '0712', '6');
INSERT INTO `district` VALUES ('2056', '沙市', '298', 's', 'ss', 'shashi', '', '区', '421002', '0716', '1');
INSERT INTO `district` VALUES ('2057', '荆州', '298', 'j', 'jz', 'jingzhou', '', '区', '421003', '0716', '2');
INSERT INTO `district` VALUES ('2058', '公安', '298', 'g', 'ga', 'gongan', '', '县', '421022', '0716', '3');
INSERT INTO `district` VALUES ('2059', '监利', '298', 'j', 'jl', 'jianli', '', '县', '421023', '0716', '4');
INSERT INTO `district` VALUES ('2060', '江陵', '298', 'j', 'jl', 'jiangling', '', '县', '421024', '0716', '5');
INSERT INTO `district` VALUES ('2061', '石首', '298', 's', 'ss', 'shishou', '', '市', '421081', '0716', '6');
INSERT INTO `district` VALUES ('2062', '洪湖', '298', 'h', 'hh', 'honghu', '', '市', '421083', '0716', '7');
INSERT INTO `district` VALUES ('2063', '松滋', '298', 's', 'sz', 'songzi', '', '市', '421087', '0716', '8');
INSERT INTO `district` VALUES ('2064', '黄州', '299', 'h', 'hz', 'huangzhou', '', '区', '421102', '0713', '1');
INSERT INTO `district` VALUES ('2065', '团风', '299', 't', 'tf', 'tuanfeng', '', '县', '421121', '0713', '2');
INSERT INTO `district` VALUES ('2066', '红安', '299', 'h', 'ha', 'hongan', '', '县', '421122', '0713', '3');
INSERT INTO `district` VALUES ('2067', '罗田', '299', 'l', 'lt', 'luotian', '', '县', '421123', '0713', '4');
INSERT INTO `district` VALUES ('2068', '英山', '299', 'y', 'ys', 'yingshan', '', '县', '421124', '0713', '5');
INSERT INTO `district` VALUES ('2069', '浠水', '299', 'x', 'xs', 'xishui', '', '县', '421125', '0713', '6');
INSERT INTO `district` VALUES ('2070', '蕲春', '299', 'q', 'qc', 'qichun', '', '县', '421126', '0713', '7');
INSERT INTO `district` VALUES ('2071', '黄梅', '299', 'h', 'hm', 'huangmei', '', '县', '421127', '0713', '8');
INSERT INTO `district` VALUES ('2072', '麻城', '299', 'm', 'mc', 'macheng', '', '市', '421181', '0713', '9');
INSERT INTO `district` VALUES ('2073', '武穴', '299', 'w', 'wx', 'wuxue', '', '市', '421182', '0713', '10');
INSERT INTO `district` VALUES ('2074', '咸安', '300', 'x', 'xa', 'xianan', '', '区', '421202', '0715', '1');
INSERT INTO `district` VALUES ('2075', '嘉鱼', '300', 'j', 'jy', 'jiayu', '', '县', '421221', '0715', '2');
INSERT INTO `district` VALUES ('2076', '通城', '300', 't', 'tc', 'tongcheng', '', '县', '421222', '0715', '3');
INSERT INTO `district` VALUES ('2077', '崇阳', '300', 'c', 'cy', 'chongyang', '', '县', '421223', '0715', '4');
INSERT INTO `district` VALUES ('2078', '通山', '300', 't', 'ts', 'tongshan', '', '县', '421224', '0715', '5');
INSERT INTO `district` VALUES ('2079', '赤壁', '300', 'c', 'cb', 'chibi', '', '市', '421281', '0715', '6');
INSERT INTO `district` VALUES ('2080', '曾都', '301', 'c', 'cd', 'cengdou', '', '区', '421303', '0722', '1');
INSERT INTO `district` VALUES ('2081', '随县', '301', 's', 'sx', 'suixian', '', '', '421321', '0722', '2');
INSERT INTO `district` VALUES ('2082', '广水', '301', 'g', 'gs', 'guangshui', '', '市', '421381', '0722', '3');
INSERT INTO `district` VALUES ('2083', '恩施', '302', 'e', 'es', 'enshi', '', '市', '422801', '0718', '1');
INSERT INTO `district` VALUES ('2084', '利川', '302', 'l', 'lc', 'lichuan', '', '市', '422802', '0718', '2');
INSERT INTO `district` VALUES ('2085', '建始', '302', 'j', 'js', 'jianshi', '', '县', '422822', '0718', '3');
INSERT INTO `district` VALUES ('2086', '巴东', '302', 'b', 'bd', 'badong', '', '县', '422823', '0718', '4');
INSERT INTO `district` VALUES ('2087', '宣恩', '302', 'x', 'xe', 'xuanen', '', '县', '422825', '0718', '5');
INSERT INTO `district` VALUES ('2088', '咸丰', '302', 'x', 'xf', 'xianfeng', '', '县', '422826', '0718', '6');
INSERT INTO `district` VALUES ('2089', '来凤', '302', 'l', 'lf', 'laifeng', '', '县', '422827', '0718', '7');
INSERT INTO `district` VALUES ('2090', '鹤峰', '302', 'h', 'hf', 'hefeng', '', '县', '422828', '0718', '8');
INSERT INTO `district` VALUES ('2091', '芙蓉', '307', 'f', 'fr', 'furong', '', '区', '430102', '0731', '1');
INSERT INTO `district` VALUES ('2092', '天心', '307', 't', 'tx', 'tianxin', '', '区', '430103', '0731', '2');
INSERT INTO `district` VALUES ('2093', '岳麓', '307', 'y', 'yl', 'yuelu', '', '区', '430104', '0731', '3');
INSERT INTO `district` VALUES ('2094', '开福', '307', 'k', 'kf', 'kaifu', '', '区', '430105', '0731', '4');
INSERT INTO `district` VALUES ('2095', '雨花', '307', 'y', 'yh', 'yuhua', '', '区', '430111', '0731', '5');
INSERT INTO `district` VALUES ('2096', '望城', '307', 'w', 'wc', 'wangcheng', '', '区', '430112', '0731', '6');
INSERT INTO `district` VALUES ('2097', '长沙', '307', 'z', 'zs', 'zhangsha', '', '县', '430121', '0731', '7');
INSERT INTO `district` VALUES ('2098', '宁乡', '307', 'n', 'nx', 'ningxiang', '', '县', '430124', '0731', '8');
INSERT INTO `district` VALUES ('2099', '浏阳', '307', 'l', 'ly', 'liuyang', '', '市', '430181', '0731', '9');
INSERT INTO `district` VALUES ('2100', '荷塘', '308', 'h', 'ht', 'hetang', '', '区', '430202', '0731', '1');
INSERT INTO `district` VALUES ('2101', '芦淞', '308', 'l', 'ls', 'lusong', '', '区', '430203', '0731', '2');
INSERT INTO `district` VALUES ('2102', '石峰', '308', 's', 'sf', 'shifeng', '', '区', '430204', '0731', '3');
INSERT INTO `district` VALUES ('2103', '天元', '308', 't', 'ty', 'tianyuan', '', '区', '430211', '0731', '4');
INSERT INTO `district` VALUES ('2104', '株洲', '308', 'z', 'zz', 'zhuzhou', '', '县', '430221', '0731', '5');
INSERT INTO `district` VALUES ('2105', '攸县', '308', 'y', 'yx', 'youxian', '', '', '430223', '0731', '6');
INSERT INTO `district` VALUES ('2106', '茶陵', '308', 'c', 'cl', 'chaling', '', '县', '430224', '0731', '7');
INSERT INTO `district` VALUES ('2107', '炎陵', '308', 'y', 'yl', 'yanling', '', '县', '430225', '0731', '8');
INSERT INTO `district` VALUES ('2108', '醴陵', '308', 'l', 'll', 'liling', '', '市', '430281', '0731', '9');
INSERT INTO `district` VALUES ('2109', '雨湖', '309', 'y', 'yh', 'yuhu', '', '区', '430302', '0731', '1');
INSERT INTO `district` VALUES ('2110', '岳塘', '309', 'y', 'yt', 'yuetang', '', '区', '430304', '0731', '2');
INSERT INTO `district` VALUES ('2111', '湘潭', '309', 'x', 'xt', 'xiangtan', '', '县', '430321', '0731', '3');
INSERT INTO `district` VALUES ('2112', '湘乡', '309', 'x', 'xx', 'xiangxiang', '', '市', '430381', '0731', '4');
INSERT INTO `district` VALUES ('2113', '韶山', '309', 's', 'ss', 'shaoshan', '', '市', '430382', '0731', '5');
INSERT INTO `district` VALUES ('2114', '珠晖', '310', 'z', 'zh', 'zhuhui', '', '区', '430405', '0734', '1');
INSERT INTO `district` VALUES ('2115', '雁峰', '310', 'y', 'yf', 'yanfeng', '', '区', '430406', '0734', '2');
INSERT INTO `district` VALUES ('2116', '石鼓', '310', 's', 'sg', 'shigu', '', '区', '430407', '0734', '3');
INSERT INTO `district` VALUES ('2117', '蒸湘', '310', 'z', 'zx', 'zhengxiang', '', '区', '430408', '0734', '4');
INSERT INTO `district` VALUES ('2118', '南岳', '310', 'n', 'ny', 'nanyue', '', '区', '430412', '0734', '5');
INSERT INTO `district` VALUES ('2119', '衡阳', '310', 'h', 'hy', 'hengyang', '', '县', '430421', '0734', '6');
INSERT INTO `district` VALUES ('2120', '衡南', '310', 'h', 'hn', 'hengnan', '', '县', '430422', '0734', '7');
INSERT INTO `district` VALUES ('2121', '衡山', '310', 'h', 'hs', 'hengshan', '', '县', '430423', '0734', '8');
INSERT INTO `district` VALUES ('2122', '衡东', '310', 'h', 'hd', 'hengdong', '', '县', '430424', '0734', '9');
INSERT INTO `district` VALUES ('2123', '祁东', '310', 'q', 'qd', 'qidong', '', '县', '430426', '0734', '10');
INSERT INTO `district` VALUES ('2124', '耒阳', '310', 'l', 'ly', 'leiyang', '', '市', '430481', '0734', '11');
INSERT INTO `district` VALUES ('2125', '常宁', '310', 'c', 'cn', 'changning', '', '市', '430482', '0734', '12');
INSERT INTO `district` VALUES ('2126', '双清', '311', 's', 'sq', 'shuangqing', '', '区', '430502', '0739', '1');
INSERT INTO `district` VALUES ('2127', '大祥', '311', 'd', 'dx', 'daxiang', '', '区', '430503', '0739', '2');
INSERT INTO `district` VALUES ('2128', '北塔', '311', 'b', 'bt', 'beita', '', '区', '430511', '0739', '3');
INSERT INTO `district` VALUES ('2129', '邵东', '311', 's', 'sd', 'shaodong', '', '县', '430521', '0739', '4');
INSERT INTO `district` VALUES ('2130', '新邵', '311', 'x', 'xs', 'xinshao', '', '县', '430522', '0739', '5');
INSERT INTO `district` VALUES ('2131', '邵阳', '311', 's', 'sy', 'shaoyang', '', '县', '430523', '0739', '6');
INSERT INTO `district` VALUES ('2132', '隆回', '311', 'l', 'lh', 'longhui', '', '县', '430524', '0739', '7');
INSERT INTO `district` VALUES ('2133', '洞口', '311', 'd', 'dk', 'dongkou', '', '县', '430525', '0739', '8');
INSERT INTO `district` VALUES ('2134', '绥宁', '311', 's', 'sn', 'suining', '', '县', '430527', '0739', '9');
INSERT INTO `district` VALUES ('2135', '新宁', '311', 'x', 'xn', 'xinning', '', '县', '430528', '0739', '10');
INSERT INTO `district` VALUES ('2136', '城步', '311', 'c', 'cb', 'chengbu', '苗族', '自治县', '430529', '0739', '11');
INSERT INTO `district` VALUES ('2137', '武冈', '311', 'w', 'wg', 'wugang', '', '市', '430581', '0739', '12');
INSERT INTO `district` VALUES ('2138', '岳阳楼', '312', 'y', 'yyl', 'yueyanglou', '', '区', '430602', '0730', '1');
INSERT INTO `district` VALUES ('2139', '云溪', '312', 'y', 'yx', 'yunxi', '', '区', '430603', '0730', '2');
INSERT INTO `district` VALUES ('2140', '君山', '312', 'j', 'js', 'junshan', '', '区', '430611', '0730', '3');
INSERT INTO `district` VALUES ('2141', '岳阳', '312', 'y', 'yy', 'yueyang', '', '县', '430621', '0730', '4');
INSERT INTO `district` VALUES ('2142', '华容', '312', 'h', 'hr', 'huarong', '', '县', '430623', '0730', '5');
INSERT INTO `district` VALUES ('2143', '湘阴', '312', 'x', 'xy', 'xiangyin', '', '县', '430624', '0730', '6');
INSERT INTO `district` VALUES ('2144', '平江', '312', 'p', 'pj', 'pingjiang', '', '县', '430626', '0730', '7');
INSERT INTO `district` VALUES ('2145', '汨罗', '312', 'm', 'ml', 'miluo', '', '市', '430681', '0730', '8');
INSERT INTO `district` VALUES ('2146', '临湘', '312', 'l', 'lx', 'linxiang', '', '市', '430682', '0730', '9');
INSERT INTO `district` VALUES ('2147', '武陵', '313', 'w', 'wl', 'wuling', '', '区', '430702', '0736', '1');
INSERT INTO `district` VALUES ('2148', '鼎城', '313', 'd', 'dc', 'dingcheng', '', '区', '430703', '0736', '2');
INSERT INTO `district` VALUES ('2149', '安乡', '313', 'a', 'ax', 'anxiang', '', '县', '430721', '0736', '3');
INSERT INTO `district` VALUES ('2150', '汉寿', '313', 'h', 'hs', 'hanshou', '', '县', '430722', '0736', '4');
INSERT INTO `district` VALUES ('2151', '澧县', '313', 'l', 'lx', 'lixian', '', '', '430723', '0736', '5');
INSERT INTO `district` VALUES ('2152', '临澧', '313', 'l', 'll', 'linli', '', '县', '430724', '0736', '6');
INSERT INTO `district` VALUES ('2153', '桃源', '313', 't', 'ty', 'taoyuan', '', '县', '430725', '0736', '7');
INSERT INTO `district` VALUES ('2154', '石门', '313', 's', 'sm', 'shimen', '', '县', '430726', '0736', '8');
INSERT INTO `district` VALUES ('2155', '津市', '313', 'j', 'js', 'jinshi', '', '市', '430781', '0736', '9');
INSERT INTO `district` VALUES ('2156', '永定', '314', 'y', 'yd', 'yongding', '', '区', '430802', '0744', '1');
INSERT INTO `district` VALUES ('2157', '武陵源', '314', 'w', 'wly', 'wulingyuan', '', '区', '430811', '0744', '2');
INSERT INTO `district` VALUES ('2158', '慈利', '314', 'c', 'cl', 'cili', '', '县', '430821', '0744', '3');
INSERT INTO `district` VALUES ('2159', '桑植', '314', 's', 'sz', 'sangzhi', '', '县', '430822', '0744', '4');
INSERT INTO `district` VALUES ('2160', '资阳', '315', 'z', 'zy', 'ziyang', '', '区', '430902', '0737', '1');
INSERT INTO `district` VALUES ('2161', '赫山', '315', 'h', 'hs', 'heshan', '', '区', '430903', '0737', '2');
INSERT INTO `district` VALUES ('2162', '南县', '315', 'n', 'nx', 'nanxian', '', '', '430921', '0737', '3');
INSERT INTO `district` VALUES ('2163', '桃江', '315', 't', 'tj', 'taojiang', '', '县', '430922', '0737', '4');
INSERT INTO `district` VALUES ('2164', '安化', '315', 'a', 'ah', 'anhua', '', '县', '430923', '0737', '5');
INSERT INTO `district` VALUES ('2165', '沅江', '315', 'y', 'yj', 'yuanjiang', '', '市', '430981', '0737', '6');
INSERT INTO `district` VALUES ('2166', '北湖', '316', 'b', 'bh', 'beihu', '', '区', '431002', '0735', '1');
INSERT INTO `district` VALUES ('2167', '苏仙', '316', 's', 'sx', 'suxian', '', '区', '431003', '0735', '2');
INSERT INTO `district` VALUES ('2168', '桂阳', '316', 'g', 'gy', 'guiyang', '', '县', '431021', '0735', '3');
INSERT INTO `district` VALUES ('2169', '宜章', '316', 'y', 'yz', 'yizhang', '', '县', '431022', '0735', '4');
INSERT INTO `district` VALUES ('2170', '永兴', '316', 'y', 'yx', 'yongxing', '', '县', '431023', '0735', '5');
INSERT INTO `district` VALUES ('2171', '嘉禾', '316', 'j', 'jh', 'jiahe', '', '县', '431024', '0735', '6');
INSERT INTO `district` VALUES ('2172', '临武', '316', 'l', 'lw', 'linwu', '', '县', '431025', '0735', '7');
INSERT INTO `district` VALUES ('2173', '汝城', '316', 'r', 'rc', 'rucheng', '', '县', '431026', '0735', '8');
INSERT INTO `district` VALUES ('2174', '桂东', '316', 'g', 'gd', 'guidong', '', '县', '431027', '0735', '9');
INSERT INTO `district` VALUES ('2175', '安仁', '316', 'a', 'ar', 'anren', '', '县', '431028', '0735', '10');
INSERT INTO `district` VALUES ('2176', '资兴', '316', 'z', 'zx', 'zixing', '', '市', '431081', '0735', '11');
INSERT INTO `district` VALUES ('2177', '零陵', '317', 'l', 'll', 'lingling', '', '区', '431102', '0746', '1');
INSERT INTO `district` VALUES ('2178', '冷水滩', '317', 'l', 'lst', 'lengshuitan', '', '区', '431103', '0746', '2');
INSERT INTO `district` VALUES ('2179', '祁阳', '317', 'q', 'qy', 'qiyang', '', '县', '431121', '0746', '3');
INSERT INTO `district` VALUES ('2180', '东安', '317', 'd', 'da', 'dongan', '', '县', '431122', '0746', '4');
INSERT INTO `district` VALUES ('2181', '双牌', '317', 's', 'sp', 'shuangpai', '', '县', '431123', '0746', '5');
INSERT INTO `district` VALUES ('2182', '道县', '317', 'd', 'dx', 'daoxian', '', '', '431124', '0746', '6');
INSERT INTO `district` VALUES ('2183', '江永', '317', 'j', 'jy', 'jiangyong', '', '县', '431125', '0746', '7');
INSERT INTO `district` VALUES ('2184', '宁远', '317', 'n', 'ny', 'ningyuan', '', '县', '431126', '0746', '8');
INSERT INTO `district` VALUES ('2185', '蓝山', '317', 'l', 'ls', 'lanshan', '', '县', '431127', '0746', '9');
INSERT INTO `district` VALUES ('2186', '新田', '317', 'x', 'xt', 'xintian', '', '县', '431128', '0746', '10');
INSERT INTO `district` VALUES ('2187', '江华', '317', 'j', 'jh', 'jianghua', '瑶族', '自治县', '431129', '0746', '11');
INSERT INTO `district` VALUES ('2188', '鹤城', '318', 'h', 'hc', 'hecheng', '', '区', '431202', '0745', '1');
INSERT INTO `district` VALUES ('2189', '中方', '318', 'z', 'zf', 'zhongfang', '', '县', '431221', '0745', '2');
INSERT INTO `district` VALUES ('2190', '沅陵', '318', 'y', 'yl', 'yuanling', '', '县', '431222', '0745', '3');
INSERT INTO `district` VALUES ('2191', '辰溪', '318', 'c', 'cx', 'chenxi', '', '县', '431223', '0745', '4');
INSERT INTO `district` VALUES ('2192', '溆浦', '318', 'x', 'xp', 'xupu', '', '县', '431224', '0745', '5');
INSERT INTO `district` VALUES ('2193', '会同', '318', 'h', 'ht', 'huitong', '', '县', '431225', '0745', '6');
INSERT INTO `district` VALUES ('2194', '麻阳', '318', 'm', 'my', 'mayang', '苗族', '自治县', '431226', '0745', '7');
INSERT INTO `district` VALUES ('2195', '新晃', '318', 'x', 'xh', 'xinhuang', '侗族', '自治县', '431227', '0745', '8');
INSERT INTO `district` VALUES ('2196', '芷江', '318', 'z', 'zj', 'zhijiang', '侗族', '自治县', '431228', '0745', '9');
INSERT INTO `district` VALUES ('2197', '靖州', '318', 'j', 'jz', 'jingzhou', '苗族侗族', '自治县', '431229', '0745', '10');
INSERT INTO `district` VALUES ('2198', '通道', '318', 't', 'td', 'tongdao', '侗族', '自治县', '431230', '0745', '11');
INSERT INTO `district` VALUES ('2199', '洪江', '318', 'h', 'hj', 'hongjiang', '', '市', '431281', '0745', '12');
INSERT INTO `district` VALUES ('2200', '娄星', '319', 'l', 'lx', 'louxing', '', '区', '431302', '0738', '1');
INSERT INTO `district` VALUES ('2201', '双峰', '319', 's', 'sf', 'shuangfeng', '', '县', '431321', '0738', '2');
INSERT INTO `district` VALUES ('2202', '新化', '319', 'x', 'xh', 'xinhua', '', '县', '431322', '0738', '3');
INSERT INTO `district` VALUES ('2203', '冷水江', '319', 'l', 'lsj', 'lengshuijiang', '', '市', '431381', '0738', '4');
INSERT INTO `district` VALUES ('2204', '涟源', '319', 'l', 'ly', 'lianyuan', '', '市', '431382', '0738', '5');
INSERT INTO `district` VALUES ('2205', '吉首', '320', 'j', 'js', 'jishou', '', '市', '433101', '0743', '1');
INSERT INTO `district` VALUES ('2206', '泸溪', '320', 'l', 'lx', 'luxi', '', '县', '433122', '0743', '2');
INSERT INTO `district` VALUES ('2207', '凤凰', '320', 'f', 'fh', 'fenghuang', '', '县', '433123', '0743', '3');
INSERT INTO `district` VALUES ('2208', '花垣', '320', 'h', 'hy', 'huayuan', '', '县', '433124', '0743', '4');
INSERT INTO `district` VALUES ('2209', '保靖', '320', 'b', 'bj', 'baojing', '', '县', '433125', '0743', '5');
INSERT INTO `district` VALUES ('2210', '古丈', '320', 'g', 'gz', 'guzhang', '', '县', '433126', '0743', '6');
INSERT INTO `district` VALUES ('2211', '永顺', '320', 'y', 'ys', 'yongshun', '', '县', '433127', '0743', '7');
INSERT INTO `district` VALUES ('2212', '龙山', '320', 'l', 'ls', 'longshan', '', '县', '433130', '0743', '8');
INSERT INTO `district` VALUES ('2213', '荔湾', '321', 'l', 'lw', 'liwan', '', '区', '440103', '020', '1');
INSERT INTO `district` VALUES ('2214', '越秀', '321', 'y', 'yx', 'yuexiu', '', '区', '440104', '020', '2');
INSERT INTO `district` VALUES ('2215', '海珠', '321', 'h', 'hz', 'haizhu', '', '区', '440105', '020', '3');
INSERT INTO `district` VALUES ('2216', '天河', '321', 't', 'th', 'tianhe', '', '区', '440106', '020', '4');
INSERT INTO `district` VALUES ('2217', '白云', '321', 'b', 'by', 'baiyun', '', '区', '440111', '020', '5');
INSERT INTO `district` VALUES ('2218', '黄埔', '321', 'h', 'hp', 'huangpu', '', '区', '440112', '020', '6');
INSERT INTO `district` VALUES ('2219', '番禺', '321', 'f', 'fy', 'fanyu', '', '区', '440113', '020', '7');
INSERT INTO `district` VALUES ('2220', '花都', '321', 'h', 'hd', 'huadou', '', '区', '440114', '020', '8');
INSERT INTO `district` VALUES ('2221', '南沙', '321', 'n', 'ns', 'nansha', '', '区', '440115', '020', '9');
INSERT INTO `district` VALUES ('2223', '增城', '321', 'z', 'zc', 'zengcheng', '', '区', '440118', '020', '12');
INSERT INTO `district` VALUES ('2224', '从化', '321', 'c', 'ch', 'conghua', '', '区', '440117', '020', '11');
INSERT INTO `district` VALUES ('2225', '武江', '322', 'w', 'wj', 'wujiang', '', '区', '440203', '0751', '1');
INSERT INTO `district` VALUES ('2226', '浈江', '322', 'z', 'zj', 'zhenjiang', '', '区', '440204', '0751', '2');
INSERT INTO `district` VALUES ('2227', '曲江', '322', 'q', 'qj', 'qujiang', '', '区', '440205', '0751', '3');
INSERT INTO `district` VALUES ('2228', '始兴', '322', 's', 'sx', 'shixing', '', '县', '440222', '0751', '4');
INSERT INTO `district` VALUES ('2229', '仁化', '322', 'r', 'rh', 'renhua', '', '县', '440224', '0751', '5');
INSERT INTO `district` VALUES ('2230', '翁源', '322', 'w', 'wy', 'wengyuan', '', '县', '440229', '0751', '6');
INSERT INTO `district` VALUES ('2231', '乳源', '322', 'r', 'ry', 'ruyuan', '瑶族', '自治县', '440232', '0751', '7');
INSERT INTO `district` VALUES ('2232', '新丰', '322', 'x', 'xf', 'xinfeng', '', '县', '440233', '0751', '8');
INSERT INTO `district` VALUES ('2233', '乐昌', '322', 'l', 'lc', 'lechang', '', '市', '440281', '0751', '9');
INSERT INTO `district` VALUES ('2234', '南雄', '322', 'n', 'nx', 'nanxiong', '', '市', '440282', '0751', '10');
INSERT INTO `district` VALUES ('2235', '罗湖', '323', 'l', 'lh', 'luohu', '', '区', '440303', '0755', '1');
INSERT INTO `district` VALUES ('2236', '福田', '323', 'f', 'ft', 'futian', '', '区', '440304', '0755', '2');
INSERT INTO `district` VALUES ('2237', '南山', '323', 'n', 'ns', 'nanshan', '', '区', '440305', '0755', '3');
INSERT INTO `district` VALUES ('2238', '宝安', '323', 'b', 'ba', 'baoan', '', '区', '440306', '0755', '4');
INSERT INTO `district` VALUES ('2239', '龙岗', '323', 'l', 'lg', 'longgang', '', '区', '440307', '0755', '5');
INSERT INTO `district` VALUES ('2240', '盐田', '323', 'y', 'yt', 'yantian', '', '区', '440308', '0755', '6');
INSERT INTO `district` VALUES ('2241', '香洲', '324', 'x', 'xz', 'xiangzhou', '', '区', '440402', '0756', '1');
INSERT INTO `district` VALUES ('2242', '斗门', '324', 'd', 'dm', 'doumen', '', '区', '440403', '0756', '2');
INSERT INTO `district` VALUES ('2243', '金湾', '324', 'j', 'jw', 'jinwan', '', '区', '440404', '0756', '3');
INSERT INTO `district` VALUES ('2244', '龙湖', '325', 'l', 'lh', 'longhu', '', '区', '440507', '0754', '1');
INSERT INTO `district` VALUES ('2245', '金平', '325', 'j', 'jp', 'jinping', '', '区', '440511', '0754', '2');
INSERT INTO `district` VALUES ('2246', '濠江', '325', 'h', 'hj', 'haojiang', '', '区', '440512', '0754', '3');
INSERT INTO `district` VALUES ('2247', '潮阳', '325', 'c', 'cy', 'chaoyang', '', '区', '440513', '0754', '4');
INSERT INTO `district` VALUES ('2248', '潮南', '325', 'c', 'cn', 'chaonan', '', '区', '440514', '0754', '5');
INSERT INTO `district` VALUES ('2249', '澄海', '325', 'c', 'ch', 'chenghai', '', '区', '440515', '0754', '6');
INSERT INTO `district` VALUES ('2250', '南澳', '325', 'n', 'na', 'nanao', '', '县', '440523', '0754', '7');
INSERT INTO `district` VALUES ('2251', '禅城', '326', 's', 'sc', 'shancheng', '', '区', '440604', '0757', '1');
INSERT INTO `district` VALUES ('2252', '南海', '326', 'n', 'nh', 'nanhai', '', '区', '440605', '0757', '2');
INSERT INTO `district` VALUES ('2253', '顺德', '326', 's', 'sd', 'shunde', '', '区', '440606', '0757', '3');
INSERT INTO `district` VALUES ('2254', '三水', '326', 's', 'ss', 'sanshui', '', '区', '440607', '0757', '4');
INSERT INTO `district` VALUES ('2255', '高明', '326', 'g', 'gm', 'gaoming', '', '区', '440608', '0757', '5');
INSERT INTO `district` VALUES ('2256', '蓬江', '327', 'p', 'pj', 'pengjiang', '', '区', '440703', '0750', '1');
INSERT INTO `district` VALUES ('2257', '江海', '327', 'j', 'jh', 'jianghai', '', '区', '440704', '0750', '2');
INSERT INTO `district` VALUES ('2258', '新会', '327', 'x', 'xh', 'xinhui', '', '区', '440705', '0750', '3');
INSERT INTO `district` VALUES ('2259', '台山', '327', 't', 'ts', 'taishan', '', '市', '440781', '0750', '4');
INSERT INTO `district` VALUES ('2260', '开平', '327', 'k', 'kp', 'kaiping', '', '市', '440783', '0750', '5');
INSERT INTO `district` VALUES ('2261', '鹤山', '327', 'h', 'hs', 'heshan', '', '市', '440784', '0750', '6');
INSERT INTO `district` VALUES ('2262', '恩平', '327', 'e', 'ep', 'enping', '', '市', '440785', '0750', '7');
INSERT INTO `district` VALUES ('2263', '赤坎', '328', 'c', 'ck', 'chikan', '', '区', '440802', '0759', '1');
INSERT INTO `district` VALUES ('2264', '霞山', '328', 'x', 'xs', 'xiashan', '', '区', '440803', '0759', '2');
INSERT INTO `district` VALUES ('2265', '坡头', '328', 'p', 'pt', 'potou', '', '区', '440804', '0759', '3');
INSERT INTO `district` VALUES ('2266', '麻章', '328', 'm', 'mz', 'mazhang', '', '区', '440811', '0759', '4');
INSERT INTO `district` VALUES ('2267', '遂溪', '328', 's', 'sx', 'suixi', '', '县', '440823', '0759', '5');
INSERT INTO `district` VALUES ('2268', '徐闻', '328', 'x', 'xw', 'xuwen', '', '县', '440825', '0759', '6');
INSERT INTO `district` VALUES ('2269', '廉江', '328', 'l', 'lj', 'lianjiang', '', '市', '440881', '0759', '7');
INSERT INTO `district` VALUES ('2270', '雷州', '328', 'l', 'lz', 'leizhou', '', '市', '440882', '0759', '8');
INSERT INTO `district` VALUES ('2271', '吴川', '328', 'w', 'wc', 'wuchuan', '', '市', '440883', '0759', '9');
INSERT INTO `district` VALUES ('2272', '茂南', '329', 'm', 'mn', 'maonan', '', '区', '440902', '0668', '1');
INSERT INTO `district` VALUES ('2274', '电白', '329', 'd', 'db', 'dianbai', '', '区', '440904', '0668', '2');
INSERT INTO `district` VALUES ('2275', '高州', '329', 'g', 'gz', 'gaozhou', '', '市', '440981', '0668', '3');
INSERT INTO `district` VALUES ('2276', '化州', '329', 'h', 'hz', 'huazhou', '', '市', '440982', '0668', '4');
INSERT INTO `district` VALUES ('2277', '信宜', '329', 'x', 'xy', 'xinyi', '', '市', '440983', '0668', '5');
INSERT INTO `district` VALUES ('2278', '端州', '330', 'd', 'dz', 'duanzhou', '', '区', '441202', '0758', '1');
INSERT INTO `district` VALUES ('2279', '鼎湖', '330', 'd', 'dh', 'dinghu', '', '区', '441203', '0758', '2');
INSERT INTO `district` VALUES ('2280', '广宁', '330', 'g', 'gn', 'guangning', '', '县', '441223', '0758', '3');
INSERT INTO `district` VALUES ('2281', '怀集', '330', 'h', 'hj', 'huaiji', '', '县', '441224', '0758', '4');
INSERT INTO `district` VALUES ('2282', '封开', '330', 'f', 'fk', 'fengkai', '', '县', '441225', '0758', '5');
INSERT INTO `district` VALUES ('2283', '德庆', '330', 'd', 'dq', 'deqing', '', '县', '441226', '0758', '6');
INSERT INTO `district` VALUES ('2284', '高要', '330', 'g', 'gy', 'gaoyao', '', '区', '441283', '0758', '7');
INSERT INTO `district` VALUES ('2285', '四会', '330', 's', 'sh', 'sihui', '', '市', '441284', '0758', '8');
INSERT INTO `district` VALUES ('2286', '惠城', '331', 'h', 'hc', 'huicheng', '', '区', '441302', '0752', '1');
INSERT INTO `district` VALUES ('2287', '惠阳', '331', 'h', 'hy', 'huiyang', '', '区', '441303', '0752', '2');
INSERT INTO `district` VALUES ('2288', '博罗', '331', 'b', 'bl', 'boluo', '', '县', '441322', '0752', '3');
INSERT INTO `district` VALUES ('2289', '惠东', '331', 'h', 'hd', 'huidong', '', '县', '441323', '0752', '4');
INSERT INTO `district` VALUES ('2290', '龙门', '331', 'l', 'lm', 'longmen', '', '县', '441324', '0752', '5');
INSERT INTO `district` VALUES ('2291', '梅江', '332', 'm', 'mj', 'meijiang', '', '区', '441402', '0753', '1');
INSERT INTO `district` VALUES ('2292', '梅县', '332', 'm', 'mx', 'meixian', '', '区', '441403', '0753', '2');
INSERT INTO `district` VALUES ('2293', '大埔', '332', 'd', 'dp', 'dapu', '', '县', '441422', '0753', '3');
INSERT INTO `district` VALUES ('2294', '丰顺', '332', 'f', 'fs', 'fengshun', '', '县', '441423', '0753', '4');
INSERT INTO `district` VALUES ('2295', '五华', '332', 'w', 'wh', 'wuhua', '', '县', '441424', '0753', '5');
INSERT INTO `district` VALUES ('2296', '平远', '332', 'p', 'py', 'pingyuan', '', '县', '441426', '0753', '6');
INSERT INTO `district` VALUES ('2297', '蕉岭', '332', 'j', 'jl', 'jiaoling', '', '县', '441427', '0753', '7');
INSERT INTO `district` VALUES ('2298', '兴宁', '332', 'x', 'xn', 'xingning', '', '市', '441481', '0753', '8');
INSERT INTO `district` VALUES ('2299', '城区', '333', 'c', 'cq', 'chengqu', '', '区', '441502', '0660', '1');
INSERT INTO `district` VALUES ('2300', '海丰', '333', 'h', 'hf', 'haifeng', '', '县', '441521', '0660', '2');
INSERT INTO `district` VALUES ('2301', '陆河', '333', 'l', 'lh', 'luhe', '', '县', '441523', '0660', '3');
INSERT INTO `district` VALUES ('2302', '陆丰', '333', 'l', 'lf', 'lufeng', '', '市', '441581', '0660', '4');
INSERT INTO `district` VALUES ('2303', '源城', '334', 'y', 'yc', 'yuancheng', '', '区', '441602', '0762', '1');
INSERT INTO `district` VALUES ('2304', '紫金', '334', 'z', 'zj', 'zijin', '', '县', '441621', '0762', '2');
INSERT INTO `district` VALUES ('2305', '龙川', '334', 'l', 'lc', 'longchuan', '', '县', '441622', '0762', '3');
INSERT INTO `district` VALUES ('2306', '连平', '334', 'l', 'lp', 'lianping', '', '县', '441623', '0762', '4');
INSERT INTO `district` VALUES ('2307', '和平', '334', 'h', 'hp', 'heping', '', '县', '441624', '0762', '5');
INSERT INTO `district` VALUES ('2308', '东源', '334', 'd', 'dy', 'dongyuan', '', '县', '441625', '0762', '6');
INSERT INTO `district` VALUES ('2309', '江城', '335', 'j', 'jc', 'jiangcheng', '', '区', '441702', '0662', '1');
INSERT INTO `district` VALUES ('2310', '阳西', '335', 'y', 'yx', 'yangxi', '', '县', '441721', '0662', '2');
INSERT INTO `district` VALUES ('2311', '阳东', '335', 'y', 'yd', 'yangdong', '', '区', '441723', '0662', '3');
INSERT INTO `district` VALUES ('2312', '阳春', '335', 'y', 'yc', 'yangchun', '', '市', '441781', '0662', '4');
INSERT INTO `district` VALUES ('2313', '清城', '336', 'q', 'qc', 'qingcheng', '', '区', '441802', '0763', '1');
INSERT INTO `district` VALUES ('2314', '佛冈', '336', 'f', 'fg', 'fogang', '', '县', '441821', '0763', '2');
INSERT INTO `district` VALUES ('2315', '阳山', '336', 'y', 'ys', 'yangshan', '', '县', '441823', '0763', '3');
INSERT INTO `district` VALUES ('2316', '连山', '336', 'l', 'ls', 'lianshan', '壮族瑶族', '自治县', '441825', '0763', '4');
INSERT INTO `district` VALUES ('2317', '连南', '336', 'l', 'ln', 'liannan', '瑶族', '自治县', '441826', '0763', '5');
INSERT INTO `district` VALUES ('2318', '清新', '336', 'q', 'qx', 'qingxin', '', '县', '441827', '0763', '6');
INSERT INTO `district` VALUES ('2319', '英德', '336', 'y', 'yd', 'yingde', '', '市', '441881', '0763', '7');
INSERT INTO `district` VALUES ('2320', '连州', '336', 'l', 'lz', 'lianzhou', '', '市', '441882', '0763', '8');
INSERT INTO `district` VALUES ('2321', '湘桥', '339', 'x', 'xq', 'xiangqiao', '', '区', '445102', '0768', '1');
INSERT INTO `district` VALUES ('2322', '潮安', '339', 'c', 'ca', 'chaoan', '', '区', '445121', '0768', '2');
INSERT INTO `district` VALUES ('2323', '饶平', '339', 'r', 'rp', 'raoping', '', '县', '445122', '0768', '3');
INSERT INTO `district` VALUES ('2324', '榕城', '340', 'r', 'rc', 'rongcheng', '', '区', '445202', '0663', '1');
INSERT INTO `district` VALUES ('2325', '揭东', '340', 'j', 'jd', 'jiedong', '', '县', '445221', '0663', '2');
INSERT INTO `district` VALUES ('2326', '揭西', '340', 'j', 'jx', 'jiexi', '', '县', '445222', '0663', '3');
INSERT INTO `district` VALUES ('2327', '惠来', '340', 'h', 'hl', 'huilai', '', '县', '445224', '0663', '4');
INSERT INTO `district` VALUES ('2328', '普宁', '340', 'p', 'pn', 'puning', '', '市', '445281', '0663', '5');
INSERT INTO `district` VALUES ('2329', '云城', '341', 'y', 'yc', 'yuncheng', '', '区', '445302', '0766', '1');
INSERT INTO `district` VALUES ('2330', '新兴', '341', 'x', 'xx', 'xinxing', '', '县', '445321', '0766', '3');
INSERT INTO `district` VALUES ('2331', '郁南', '341', 'y', 'yn', 'yunan', '', '县', '445322', '0766', '4');
INSERT INTO `district` VALUES ('2332', '云安', '341', 'y', 'ya', 'yunan', '', '区', '445302', '0766', '2');
INSERT INTO `district` VALUES ('2333', '罗定', '341', 'l', 'ld', 'luoding', '', '市', '445381', '0766', '5');
INSERT INTO `district` VALUES ('2334', '兴宁', '342', 'x', 'xn', 'xingning', '', '区', '450102', '0771', '1');
INSERT INTO `district` VALUES ('2335', '青秀', '342', 'q', 'qx', 'qingxiu', '', '区', '450103', '0771', '2');
INSERT INTO `district` VALUES ('2336', '江南', '342', 'j', 'jn', 'jiangnan', '', '区', '450105', '0771', '3');
INSERT INTO `district` VALUES ('2337', '西乡塘', '342', 'x', 'xxt', 'xixiangtang', '', '区', '450107', '0771', '4');
INSERT INTO `district` VALUES ('2338', '良庆', '342', 'l', 'lq', 'liangqing', '', '区', '450108', '0771', '5');
INSERT INTO `district` VALUES ('2339', '邕宁', '342', 'y', 'yn', 'yongning', '', '区', '450109', '0771', '6');
INSERT INTO `district` VALUES ('2340', '武鸣', '342', 'w', 'wm', 'wuming', '', '区', '450122', '0771', '7');
INSERT INTO `district` VALUES ('2341', '隆安', '342', 'l', 'la', 'longan', '', '县', '450123', '0771', '8');
INSERT INTO `district` VALUES ('2342', '马山', '342', 'm', 'ms', 'mashan', '', '县', '450124', '0771', '9');
INSERT INTO `district` VALUES ('2343', '上林', '342', 's', 'sl', 'shanglin', '', '县', '450125', '0771', '10');
INSERT INTO `district` VALUES ('2344', '宾阳', '342', 'b', 'by', 'binyang', '', '县', '450126', '0771', '11');
INSERT INTO `district` VALUES ('2345', '横县', '342', 'h', 'hx', 'hengxian', '', '', '450127', '0771', '12');
INSERT INTO `district` VALUES ('2346', '城中', '343', 'c', 'cz', 'chengzhong', '', '区', '450202', '0772', '1');
INSERT INTO `district` VALUES ('2347', '鱼峰', '343', 'y', 'yf', 'yufeng', '', '区', '450203', '0772', '2');
INSERT INTO `district` VALUES ('2348', '柳南', '343', 'l', 'ln', 'liunan', '', '区', '450204', '0772', '3');
INSERT INTO `district` VALUES ('2349', '柳北', '343', 'l', 'lb', 'liubei', '', '区', '450205', '0772', '4');
INSERT INTO `district` VALUES ('2350', '柳江', '343', 'l', 'lj', 'liujiang', '', '区', '450221', '0772', '5');
INSERT INTO `district` VALUES ('2351', '柳城', '343', 'l', 'lc', 'liucheng', '', '县', '450222', '0772', '6');
INSERT INTO `district` VALUES ('2352', '鹿寨', '343', 'l', 'lz', 'luzhai', '', '县', '450223', '0772', '7');
INSERT INTO `district` VALUES ('2353', '融安', '343', 'r', 'ra', 'rongan', '', '县', '450224', '0772', '8');
INSERT INTO `district` VALUES ('2354', '融水', '343', 'r', 'rs', 'rongshui', '苗族', '自治县', '450225', '0772', '9');
INSERT INTO `district` VALUES ('2355', '三江', '343', 's', 'sj', 'sanjiang', '侗族', '自治县', '450226', '0772', '10');
INSERT INTO `district` VALUES ('2356', '秀峰', '344', 'x', 'xf', 'xiufeng', '', '区', '450302', '0773', '1');
INSERT INTO `district` VALUES ('2357', '叠彩', '344', 'd', 'dc', 'diecai', '', '区', '450303', '0773', '2');
INSERT INTO `district` VALUES ('2358', '象山', '344', 'x', 'xs', 'xiangshan', '', '区', '450304', '0773', '3');
INSERT INTO `district` VALUES ('2359', '七星', '344', 'q', 'qx', 'qixing', '', '区', '450305', '0773', '4');
INSERT INTO `district` VALUES ('2360', '雁山', '344', 'y', 'ys', 'yanshan', '', '区', '450311', '0773', '5');
INSERT INTO `district` VALUES ('2361', '阳朔', '344', 'y', 'ys', 'yangshuo', '', '县', '450321', '0773', '6');
INSERT INTO `district` VALUES ('2362', '临桂', '344', 'l', 'lg', 'lingui', '', '区', '450322', '0773', '7');
INSERT INTO `district` VALUES ('2363', '灵川', '344', 'l', 'lc', 'lingchuan', '', '县', '450323', '0773', '8');
INSERT INTO `district` VALUES ('2364', '全州', '344', 'q', 'qz', 'quanzhou', '', '县', '450324', '0773', '9');
INSERT INTO `district` VALUES ('2365', '兴安', '344', 'x', 'xa', 'xingan', '', '县', '450325', '0773', '10');
INSERT INTO `district` VALUES ('2366', '永福', '344', 'y', 'yf', 'yongfu', '', '县', '450326', '0773', '11');
INSERT INTO `district` VALUES ('2367', '灌阳', '344', 'g', 'gy', 'guanyang', '', '县', '450327', '0773', '12');
INSERT INTO `district` VALUES ('2368', '龙胜', '344', 'l', 'ls', 'longsheng', '各族', '自治县', '450328', '0773', '13');
INSERT INTO `district` VALUES ('2369', '资源', '344', 'z', 'zy', 'ziyuan', '', '县', '450329', '0773', '14');
INSERT INTO `district` VALUES ('2370', '平乐', '344', 'p', 'pl', 'pingle', '', '县', '450330', '0773', '15');
INSERT INTO `district` VALUES ('2371', '荔浦', '344', 'l', 'lp', 'lipu', '', '县', '450331', '0773', '16');
INSERT INTO `district` VALUES ('2372', '恭城', '344', 'g', 'gc', 'gongcheng', '瑶族', '自治县', '450332', '0773', '17');
INSERT INTO `district` VALUES ('2373', '龙圩', '345', 'l', 'lw', 'longwei', '', '区', '', '0774', '1');
INSERT INTO `district` VALUES ('2374', '万秀', '345', 'w', 'wx', 'wanxiu', '', '区', '450403', '0774', '2');
INSERT INTO `district` VALUES ('2375', '长洲', '345', 'z', 'zz', 'zhangzhou', '', '区', '450405', '0774', '3');
INSERT INTO `district` VALUES ('2376', '苍梧', '345', 'c', 'cw', 'cangwu', '', '县', '450421', '0774', '4');
INSERT INTO `district` VALUES ('2377', '藤县', '345', 't', 'tx', 'tengxian', '', '', '450422', '0774', '5');
INSERT INTO `district` VALUES ('2378', '蒙山', '345', 'm', 'ms', 'mengshan', '', '县', '450423', '0774', '6');
INSERT INTO `district` VALUES ('2379', '岑溪', '345', 'c', 'cx', 'cenxi', '', '市', '450481', '0774', '7');
INSERT INTO `district` VALUES ('2380', '海城', '346', 'h', 'hc', 'haicheng', '', '区', '450502', '0779', '1');
INSERT INTO `district` VALUES ('2381', '银海', '346', 'y', 'yh', 'yinhai', '', '区', '450503', '0779', '2');
INSERT INTO `district` VALUES ('2382', '铁山港', '346', 't', 'tsg', 'tieshangang', '', '区', '450512', '0779', '3');
INSERT INTO `district` VALUES ('2383', '合浦', '346', 'h', 'hp', 'hepu', '', '县', '450521', '0779', '4');
INSERT INTO `district` VALUES ('2384', '港口', '347', 'g', 'gk', 'gangkou', '', '区', '450602', '0770', '1');
INSERT INTO `district` VALUES ('2385', '防城', '347', 'f', 'fc', 'fangcheng', '', '区', '450603', '0770', '2');
INSERT INTO `district` VALUES ('2386', '上思', '347', 's', 'ss', 'shangsi', '', '县', '450621', '0770', '3');
INSERT INTO `district` VALUES ('2387', '东兴', '347', 'd', 'dx', 'dongxing', '', '市', '450681', '0770', '4');
INSERT INTO `district` VALUES ('2388', '钦南', '348', 'q', 'qn', 'qinnan', '', '区', '450702', '0777', '1');
INSERT INTO `district` VALUES ('2389', '钦北', '348', 'q', 'qb', 'qinbei', '', '区', '450703', '0777', '2');
INSERT INTO `district` VALUES ('2390', '灵山', '348', 'l', 'ls', 'lingshan', '', '县', '450721', '0777', '3');
INSERT INTO `district` VALUES ('2391', '浦北', '348', 'p', 'pb', 'pubei', '', '县', '450722', '0777', '4');
INSERT INTO `district` VALUES ('2392', '港北', '349', 'g', 'gb', 'gangbei', '', '区', '450802', '0775', '1');
INSERT INTO `district` VALUES ('2393', '港南', '349', 'g', 'gn', 'gangnan', '', '区', '450803', '0775', '2');
INSERT INTO `district` VALUES ('2394', '覃塘', '349', 't', 'tt', 'tantang', '', '区', '450804', '0775', '3');
INSERT INTO `district` VALUES ('2395', '桂平', '349', 'g', 'gp', 'guiping', '', '市', '450821', '0775', '4');
INSERT INTO `district` VALUES ('2396', '平南', '349', 'p', 'pn', 'pingnan', '', '县', '450881', '0775', '5');
INSERT INTO `district` VALUES ('2397', '玉州', '350', 'y', 'yz', 'yuzhou', '', '区', '450902', '0775', '1');
INSERT INTO `district` VALUES ('2398', '容县', '350', 'r', 'rx', 'rongxian', '', '', '450921', '0775', '3');
INSERT INTO `district` VALUES ('2399', '陆川', '350', 'l', 'lc', 'luchuan', '', '县', '450922', '0775', '4');
INSERT INTO `district` VALUES ('2400', '博白', '350', 'b', 'bb', 'bobai', '', '县', '450923', '0775', '5');
INSERT INTO `district` VALUES ('2401', '兴业', '350', 'x', 'xy', 'xingye', '', '县', '450924', '0775', '6');
INSERT INTO `district` VALUES ('2402', '北流', '350', 'b', 'bl', 'beiliu', '', '市', '450981', '0775', '7');
INSERT INTO `district` VALUES ('2403', '右江', '351', 'y', 'yj', 'youjiang', '', '区', '451002', '0776', '1');
INSERT INTO `district` VALUES ('2404', '田阳', '351', 't', 'ty', 'tianyang', '', '县', '451021', '0776', '2');
INSERT INTO `district` VALUES ('2405', '田东', '351', 't', 'td', 'tiandong', '', '县', '451022', '0776', '3');
INSERT INTO `district` VALUES ('2406', '平果', '351', 'p', 'pg', 'pingguo', '', '县', '451023', '0776', '4');
INSERT INTO `district` VALUES ('2407', '德保', '351', 'd', 'db', 'debao', '', '县', '451024', '0776', '5');
INSERT INTO `district` VALUES ('2408', '靖西', '351', 'j', 'jx', 'jingxi', '', '市', '451025', '0776', '6');
INSERT INTO `district` VALUES ('2409', '那坡', '351', 'n', 'np', 'neipo', '', '县', '451026', '0776', '7');
INSERT INTO `district` VALUES ('2410', '凌云', '351', 'l', 'ly', 'lingyun', '', '县', '451027', '0776', '8');
INSERT INTO `district` VALUES ('2411', '乐业', '351', 'l', 'ly', 'leye', '', '县', '451028', '0776', '9');
INSERT INTO `district` VALUES ('2412', '田林', '351', 't', 'tl', 'tianlin', '', '县', '451029', '0776', '10');
INSERT INTO `district` VALUES ('2413', '西林', '351', 'x', 'xl', 'xilin', '', '县', '451030', '0776', '11');
INSERT INTO `district` VALUES ('2414', '隆林', '351', 'l', 'll', 'longlin', '各族', '自治县', '451031', '0776', '12');
INSERT INTO `district` VALUES ('2415', '八步', '352', 'b', 'bb', 'babu', '', '区', '451102', '0774', '1');
INSERT INTO `district` VALUES ('2416', '昭平', '352', 'z', 'zp', 'zhaoping', '', '县', '451121', '0774', '3');
INSERT INTO `district` VALUES ('2417', '钟山', '352', 'z', 'zs', 'zhongshan', '', '县', '451122', '0774', '4');
INSERT INTO `district` VALUES ('2418', '富川', '352', 'f', 'fc', 'fuchuan', '瑶族', '自治县', '451123', '0774', '5');
INSERT INTO `district` VALUES ('2419', '金城江', '353', 'j', 'jcj', 'jinchengjiang', '', '区', '451202', '0778', '1');
INSERT INTO `district` VALUES ('2420', '南丹', '353', 'n', 'nd', 'nandan', '', '县', '451221', '0778', '3');
INSERT INTO `district` VALUES ('2421', '天峨', '353', 't', 'te', 'tiane', '', '县', '451222', '0778', '4');
INSERT INTO `district` VALUES ('2422', '凤山', '353', 'f', 'fs', 'fengshan', '', '县', '451223', '0778', '5');
INSERT INTO `district` VALUES ('2423', '东兰', '353', 'd', 'dl', 'donglan', '', '县', '451224', '0778', '6');
INSERT INTO `district` VALUES ('2424', '罗城', '353', 'l', 'lc', 'luocheng', '仫佬族', '自治县', '451225', '0778', '7');
INSERT INTO `district` VALUES ('2425', '环江', '353', 'h', 'hj', 'huanjiang', '毛南族', '自治县', '451226', '0778', '8');
INSERT INTO `district` VALUES ('2426', '巴马', '353', 'b', 'bm', 'bama', '瑶族', '自治县', '451227', '0778', '9');
INSERT INTO `district` VALUES ('2427', '都安', '353', 'd', 'da', 'douan', '瑶族', '自治县', '451228', '0778', '10');
INSERT INTO `district` VALUES ('2428', '大化', '353', 'd', 'dh', 'dahua', '瑶族', '自治县', '451229', '0778', '11');
INSERT INTO `district` VALUES ('2429', '宜州', '353', 'y', 'yz', 'yizhou', '', '区', '451281', '0778', '2');
INSERT INTO `district` VALUES ('2430', '兴宾', '354', 'x', 'xb', 'xingbin', '', '区', '451302', '0772', '1');
INSERT INTO `district` VALUES ('2431', '忻城', '354', 'x', 'xc', 'xincheng', '', '县', '451321', '0772', '2');
INSERT INTO `district` VALUES ('2432', '象州', '354', 'x', 'xz', 'xiangzhou', '', '县', '451322', '0772', '3');
INSERT INTO `district` VALUES ('2433', '武宣', '354', 'w', 'wx', 'wuxuan', '', '县', '451323', '0772', '4');
INSERT INTO `district` VALUES ('2434', '金秀', '354', 'j', 'jx', 'jinxiu', '瑶族', '自治县', '451324', '0772', '5');
INSERT INTO `district` VALUES ('2435', '合山', '354', 'h', 'hs', 'heshan', '', '市', '451381', '0772', '6');
INSERT INTO `district` VALUES ('2436', '江州', '355', 'j', 'jz', 'jiangzhou', '', '区', '451402', '0771', '1');
INSERT INTO `district` VALUES ('2437', '扶绥', '355', 'f', 'fs', 'fusui', '', '县', '451421', '0771', '2');
INSERT INTO `district` VALUES ('2438', '宁明', '355', 'n', 'nm', 'ningming', '', '县', '451422', '0771', '3');
INSERT INTO `district` VALUES ('2439', '龙州', '355', 'l', 'lz', 'longzhou', '', '县', '451423', '0771', '4');
INSERT INTO `district` VALUES ('2440', '大新', '355', 'd', 'dx', 'daxin', '', '县', '451424', '0771', '5');
INSERT INTO `district` VALUES ('2441', '天等', '355', 't', 'td', 'tiandeng', '', '县', '451425', '0771', '6');
INSERT INTO `district` VALUES ('2442', '凭祥', '355', 'p', 'px', 'pingxiang', '', '市', '451481', '0771', '7');
INSERT INTO `district` VALUES ('2443', '秀英', '356', 'x', 'xy', 'xiuying', '', '区', '460105', '0898', '1');
INSERT INTO `district` VALUES ('2444', '龙华', '356', 'l', 'lh', 'longhua', '', '区', '460106', '0898', '2');
INSERT INTO `district` VALUES ('2445', '琼山', '356', 'q', 'qs', 'qiongshan', '', '区', '460107', '0898', '3');
INSERT INTO `district` VALUES ('2446', '美兰', '356', 'm', 'ml', 'meilan', '', '区', '460108', '0898', '4');
INSERT INTO `district` VALUES ('2447', '锦江', '375', 'j', 'jj', 'jinjiang', '', '区', '510104', '028', '1');
INSERT INTO `district` VALUES ('2448', '青羊', '375', 'q', 'qy', 'qingyang', '', '区', '510105', '028', '2');
INSERT INTO `district` VALUES ('2449', '金牛', '375', 'j', 'jn', 'jinniu', '', '区', '510106', '028', '3');
INSERT INTO `district` VALUES ('2450', '武侯', '375', 'w', 'wh', 'wuhou', '', '区', '510107', '028', '4');
INSERT INTO `district` VALUES ('2451', '成华', '375', 'c', 'ch', 'chenghua', '', '区', '510108', '028', '5');
INSERT INTO `district` VALUES ('2452', '龙泉驿', '375', 'l', 'lqy', 'longquanyi', '', '区', '510112', '028', '6');
INSERT INTO `district` VALUES ('2453', '青白江', '375', 'q', 'qbj', 'qingbaijiang', '', '区', '510113', '028', '7');
INSERT INTO `district` VALUES ('2454', '新都', '375', 'x', 'xd', 'xindou', '', '区', '510114', '028', '8');
INSERT INTO `district` VALUES ('2455', '温江', '375', 'w', 'wj', 'wenjiang', '', '区', '510115', '028', '9');
INSERT INTO `district` VALUES ('2456', '金堂', '375', 'j', 'jt', 'jintang', '', '县', '510121', '028', '10');
INSERT INTO `district` VALUES ('2457', '双流', '375', 's', 'sl', 'shuangliu', '', '区', '510122', '028', '11');
INSERT INTO `district` VALUES ('2458', '郫都', '375', 'p', 'pd', 'pidu', '', '区', '510124', '028', '12');
INSERT INTO `district` VALUES ('2459', '大邑', '375', 'd', 'dy', 'dayi', '', '县', '510129', '028', '13');
INSERT INTO `district` VALUES ('2460', '蒲江', '375', 'p', 'pj', 'pujiang', '', '县', '510131', '028', '14');
INSERT INTO `district` VALUES ('2461', '新津', '375', 'x', 'xj', 'xinjin', '', '县', '510132', '028', '15');
INSERT INTO `district` VALUES ('2462', '都江堰', '375', 'd', 'djy', 'doujiangyan', '', '市', '510181', '028', '16');
INSERT INTO `district` VALUES ('2463', '彭州', '375', 'p', 'pz', 'pengzhou', '', '市', '510182', '028', '17');
INSERT INTO `district` VALUES ('2464', '邛崃', '375', 'q', 'ql', 'qionglai', '', '市', '510183', '028', '18');
INSERT INTO `district` VALUES ('2465', '崇州', '375', 'c', 'cz', 'chongzhou', '', '市', '510184', '028', '19');
INSERT INTO `district` VALUES ('2466', '自流井', '376', 'z', 'zlj', 'ziliujing', '', '区', '510302', '0813', '1');
INSERT INTO `district` VALUES ('2467', '贡井', '376', 'g', 'gj', 'gongjing', '', '区', '510303', '0813', '2');
INSERT INTO `district` VALUES ('2468', '大安', '376', 'd', 'da', 'daan', '', '区', '510304', '0813', '3');
INSERT INTO `district` VALUES ('2469', '沿滩', '376', 'y', 'yt', 'yantan', '', '区', '510311', '0813', '4');
INSERT INTO `district` VALUES ('2470', '荣县', '376', 'r', 'rx', 'rongxian', '', '', '510321', '0813', '5');
INSERT INTO `district` VALUES ('2471', '富顺', '376', 'f', 'fs', 'fushun', '', '县', '510322', '0813', '6');
INSERT INTO `district` VALUES ('2472', '东区', '377', 'd', 'dq', 'dongqu', '', '', '510402', '0812', '1');
INSERT INTO `district` VALUES ('2473', '西区', '377', 'x', 'xq', 'xiqu', '', '', '510403', '0812', '2');
INSERT INTO `district` VALUES ('2474', '仁和', '377', 'r', 'rh', 'renhe', '', '区', '510411', '0812', '3');
INSERT INTO `district` VALUES ('2475', '米易', '377', 'm', 'my', 'miyi', '', '县', '510421', '0812', '4');
INSERT INTO `district` VALUES ('2476', '盐边', '377', 'y', 'yb', 'yanbian', '', '县', '510422', '0812', '5');
INSERT INTO `district` VALUES ('2477', '江阳', '378', 'j', 'jy', 'jiangyang', '', '区', '510502', '0830', '1');
INSERT INTO `district` VALUES ('2478', '纳溪', '378', 'n', 'nx', 'naxi', '', '区', '510503', '0830', '2');
INSERT INTO `district` VALUES ('2479', '龙马潭', '378', 'l', 'lmt', 'longmatan', '', '区', '510504', '0830', '3');
INSERT INTO `district` VALUES ('2480', '泸县', '378', 'l', 'lx', 'luxian', '', '', '510521', '0830', '4');
INSERT INTO `district` VALUES ('2481', '合江', '378', 'h', 'hj', 'hejiang', '', '县', '510522', '0830', '5');
INSERT INTO `district` VALUES ('2482', '叙永', '378', 'x', 'xy', 'xuyong', '', '县', '510524', '0830', '6');
INSERT INTO `district` VALUES ('2483', '古蔺', '378', 'g', 'gl', 'gulin', '', '县', '510525', '0830', '7');
INSERT INTO `district` VALUES ('2484', '旌阳', '379', 'j', 'jy', 'jingyang', '', '区', '510603', '0838', '1');
INSERT INTO `district` VALUES ('2485', '中江', '379', 'z', 'zj', 'zhongjiang', '', '县', '510623', '0838', '2');
INSERT INTO `district` VALUES ('2486', '罗江', '379', 'l', 'lj', 'luojiang', '', '县', '510626', '0838', '3');
INSERT INTO `district` VALUES ('2487', '广汉', '379', 'g', 'gh', 'guanghan', '', '市', '510681', '0838', '4');
INSERT INTO `district` VALUES ('2488', '什邡', '379', 's', 'sf', 'shenfang', '', '市', '510682', '0838', '5');
INSERT INTO `district` VALUES ('2489', '绵竹', '379', 'm', 'mz', 'mianzhu', '', '市', '510683', '0838', '6');
INSERT INTO `district` VALUES ('2490', '涪城', '380', 'f', 'fc', 'fucheng', '', '区', '510703', '0816', '1');
INSERT INTO `district` VALUES ('2491', '游仙', '380', 'y', 'yx', 'youxian', '', '区', '510704', '0816', '2');
INSERT INTO `district` VALUES ('2492', '三台', '380', 's', 'st', 'santai', '', '县', '510722', '0816', '3');
INSERT INTO `district` VALUES ('2493', '盐亭', '380', 'y', 'yt', 'yanting', '', '县', '510723', '0816', '4');
INSERT INTO `district` VALUES ('2494', '安州', '380', 'a', 'az', 'anzhou', '', '区', '510724', '0816', '5');
INSERT INTO `district` VALUES ('2495', '梓潼', '380', 'z', 'zt', 'zitong', '', '县', '510725', '0816', '6');
INSERT INTO `district` VALUES ('2496', '北川', '380', 'b', 'bc', 'beichuan', '羌族', '自治县', '510726', '0816', '7');
INSERT INTO `district` VALUES ('2497', '平武', '380', 'p', 'pw', 'pingwu', '', '县', '510727', '0816', '8');
INSERT INTO `district` VALUES ('2498', '江油', '380', 'j', 'jy', 'jiangyou', '', '市', '510781', '0816', '9');
INSERT INTO `district` VALUES ('2499', '利州', '381', 'l', 'lz', 'lizhou', '', '区', '510802', '0839', '1');
INSERT INTO `district` VALUES ('2500', '昭化', '381', 'z', 'zh', 'zhaohua', '', '区', '510811', '0839', '2');
INSERT INTO `district` VALUES ('2501', '朝天', '381', 'c', 'ct', 'chaotian', '', '区', '510812', '0839', '3');
INSERT INTO `district` VALUES ('2502', '旺苍', '381', 'w', 'wc', 'wangcang', '', '县', '510821', '0839', '4');
INSERT INTO `district` VALUES ('2503', '青川', '381', 'q', 'qc', 'qingchuan', '', '县', '510822', '0839', '5');
INSERT INTO `district` VALUES ('2504', '剑阁', '381', 'j', 'jg', 'jiange', '', '县', '510823', '0839', '6');
INSERT INTO `district` VALUES ('2505', '苍溪', '381', 'c', 'cx', 'cangxi', '', '县', '510824', '0839', '7');
INSERT INTO `district` VALUES ('2506', '船山', '382', 'c', 'cs', 'chuanshan', '', '区', '510903', '0825', '1');
INSERT INTO `district` VALUES ('2507', '安居', '382', 'a', 'aj', 'anju', '', '区', '510904', '0825', '2');
INSERT INTO `district` VALUES ('2508', '蓬溪', '382', 'p', 'px', 'pengxi', '', '县', '510921', '0825', '3');
INSERT INTO `district` VALUES ('2509', '射洪', '382', 's', 'sh', 'shehong', '', '县', '510922', '0825', '4');
INSERT INTO `district` VALUES ('2510', '大英', '382', 'd', 'dy', 'daying', '', '县', '510923', '0825', '5');
INSERT INTO `district` VALUES ('2511', '市中', '383', 's', 'sz', 'shizhong', '', '区', '511002', '', '1');
INSERT INTO `district` VALUES ('2512', '东兴', '383', 'd', 'dx', 'dongxing', '', '区', '511011', '', '2');
INSERT INTO `district` VALUES ('2513', '威远', '383', 'w', 'wy', 'weiyuan', '', '县', '511024', '', '3');
INSERT INTO `district` VALUES ('2514', '资中', '383', 'z', 'zz', 'zizhong', '', '县', '511025', '', '4');
INSERT INTO `district` VALUES ('2515', '隆昌', '383', 'l', 'lc', 'longchang', '', '县', '511028', '', '5');
INSERT INTO `district` VALUES ('2516', '市中', '384', 's', 'sz', 'shizhong', '', '区', '511102', '0833', '1');
INSERT INTO `district` VALUES ('2517', '沙湾', '384', 's', 'sw', 'shawan', '', '区', '511111', '0833', '2');
INSERT INTO `district` VALUES ('2518', '五通桥', '384', 'w', 'wtq', 'wutongqiao', '', '区', '511112', '0833', '3');
INSERT INTO `district` VALUES ('2519', '金口河', '384', 'j', 'jkh', 'jinkouhe', '', '区', '511113', '0833', '4');
INSERT INTO `district` VALUES ('2520', '犍为', '384', 'j', 'jw', 'jianwei', '', '县', '511123', '0833', '5');
INSERT INTO `district` VALUES ('2521', '井研', '384', 'j', 'jy', 'jingyan', '', '县', '511124', '0833', '6');
INSERT INTO `district` VALUES ('2522', '夹江', '384', 'j', 'jj', 'jiajiang', '', '县', '511126', '0833', '7');
INSERT INTO `district` VALUES ('2523', '沐川', '384', 'm', 'mc', 'muchuan', '', '县', '511129', '0833', '8');
INSERT INTO `district` VALUES ('2524', '峨边', '384', 'e', 'eb', 'ebian', '彝族', '自治县', '511132', '0833', '9');
INSERT INTO `district` VALUES ('2525', '马边', '384', 'm', 'mb', 'mabian', '彝族', '自治县', '511133', '0833', '10');
INSERT INTO `district` VALUES ('2526', '峨眉山', '384', 'e', 'ems', 'emeishan', '', '市', '511181', '0833', '11');
INSERT INTO `district` VALUES ('2527', '顺庆', '385', 's', 'sq', 'shunqing', '', '区', '511302', '0817', '1');
INSERT INTO `district` VALUES ('2528', '高坪', '385', 'g', 'gp', 'gaoping', '', '区', '511303', '0817', '2');
INSERT INTO `district` VALUES ('2529', '嘉陵', '385', 'j', 'jl', 'jialing', '', '区', '511304', '0817', '3');
INSERT INTO `district` VALUES ('2530', '南部', '385', 'n', 'nb', 'nanbu', '', '县', '511321', '0817', '4');
INSERT INTO `district` VALUES ('2531', '营山', '385', 'y', 'ys', 'yingshan', '', '县', '511322', '0817', '5');
INSERT INTO `district` VALUES ('2532', '蓬安', '385', 'p', 'pa', 'pengan', '', '县', '511323', '0817', '6');
INSERT INTO `district` VALUES ('2533', '仪陇', '385', 'y', 'yl', 'yilong', '', '县', '511324', '0817', '7');
INSERT INTO `district` VALUES ('2534', '西充', '385', 'x', 'xc', 'xichong', '', '县', '511325', '0817', '8');
INSERT INTO `district` VALUES ('2535', '阆中', '385', 'l', 'lz', 'langzhong', '', '市', '511381', '0817', '9');
INSERT INTO `district` VALUES ('2536', '东坡', '386', 'd', 'dp', 'dongpo', '', '区', '511402', '028', '1');
INSERT INTO `district` VALUES ('2537', '仁寿', '386', 'r', 'rs', 'renshou', '', '县', '511421', '028', '2');
INSERT INTO `district` VALUES ('2538', '彭山', '386', 'p', 'ps', 'pengshan', '', '区', '511422', '028', '3');
INSERT INTO `district` VALUES ('2539', '洪雅', '386', 'h', 'hy', 'hongya', '', '县', '511423', '028', '4');
INSERT INTO `district` VALUES ('2540', '丹棱', '386', 'd', 'dl', 'danleng', '', '县', '511424', '028', '5');
INSERT INTO `district` VALUES ('2541', '青神', '386', 'q', 'qs', 'qingshen', '', '县', '511425', '028', '6');
INSERT INTO `district` VALUES ('2542', '翠屏', '387', 'c', 'cp', 'cuiping', '', '区', '511502', '0831', '1');
INSERT INTO `district` VALUES ('2543', '南溪', '387', 'n', 'nx', 'nanxi', '', '区', '511503', '0831', '2');
INSERT INTO `district` VALUES ('2544', '宜宾', '387', 'y', 'yb', 'yibin', '', '县', '511521', '0831', '3');
INSERT INTO `district` VALUES ('2545', '江安', '387', 'j', 'ja', 'jiangan', '', '县', '511523', '0831', '4');
INSERT INTO `district` VALUES ('2546', '长宁', '387', 'z', 'zn', 'zhangning', '', '县', '511524', '0831', '5');
INSERT INTO `district` VALUES ('2547', '高县', '387', 'g', 'gx', 'gaoxian', '', '', '511525', '0831', '6');
INSERT INTO `district` VALUES ('2548', '珙县', '387', 'g', 'gx', 'gongxian', '', '', '511526', '0831', '7');
INSERT INTO `district` VALUES ('2549', '筠连', '387', 'y', 'yl', 'yunlian', '', '县', '511527', '0831', '8');
INSERT INTO `district` VALUES ('2550', '兴文', '387', 'x', 'xw', 'xingwen', '', '县', '511528', '0831', '9');
INSERT INTO `district` VALUES ('2551', '屏山', '387', 'p', 'ps', 'pingshan', '', '县', '511529', '0831', '10');
INSERT INTO `district` VALUES ('2552', '广安', '388', 'g', 'ga', 'guangan', '', '区', '511602', '0826', '1');
INSERT INTO `district` VALUES ('2553', '岳池', '388', 'y', 'yc', 'yuechi', '', '县', '511621', '0826', '3');
INSERT INTO `district` VALUES ('2554', '武胜', '388', 'w', 'ws', 'wusheng', '', '县', '511622', '0826', '4');
INSERT INTO `district` VALUES ('2555', '邻水', '388', 'l', 'ls', 'linshui', '', '县', '511623', '0826', '5');
INSERT INTO `district` VALUES ('2556', '华蓥', '388', 'h', 'hy', 'huaying', '', '市', '511681', '0826', '6');
INSERT INTO `district` VALUES ('2557', '通川', '389', 't', 'tc', 'tongchuan', '', '区', '511702', '0818', '1');
INSERT INTO `district` VALUES ('2558', '达川', '389', 'd', 'dc', 'dachuan', '', '区', '511721', '0818', '2');
INSERT INTO `district` VALUES ('2559', '宣汉', '389', 'x', 'xh', 'xuanhan', '', '县', '511722', '0818', '3');
INSERT INTO `district` VALUES ('2560', '开江', '389', 'k', 'kj', 'kaijiang', '', '县', '511723', '0818', '4');
INSERT INTO `district` VALUES ('2561', '大竹', '389', 'd', 'dz', 'dazhu', '', '县', '511724', '0818', '5');
INSERT INTO `district` VALUES ('2562', '渠县', '389', 'q', 'qx', 'quxian', '', '', '511725', '0818', '6');
INSERT INTO `district` VALUES ('2563', '万源', '389', 'w', 'wy', 'wanyuan', '', '市', '511781', '0818', '7');
INSERT INTO `district` VALUES ('2564', '雨城', '390', 'y', 'yc', 'yucheng', '', '区', '511802', '0835', '1');
INSERT INTO `district` VALUES ('2565', '名山', '390', 'm', 'ms', 'mingshan', '', '区', '511803', '0835', '2');
INSERT INTO `district` VALUES ('2566', '荥经', '390', 'y', 'yj', 'yingjing', '', '县', '511822', '0835', '3');
INSERT INTO `district` VALUES ('2567', '汉源', '390', 'h', 'hy', 'hanyuan', '', '县', '511823', '0835', '4');
INSERT INTO `district` VALUES ('2568', '石棉', '390', 's', 'sm', 'shimian', '', '县', '511824', '0835', '5');
INSERT INTO `district` VALUES ('2569', '天全', '390', 't', 'tq', 'tianquan', '', '县', '511825', '0835', '6');
INSERT INTO `district` VALUES ('2570', '芦山', '390', 'l', 'ls', 'lushan', '', '县', '511826', '0835', '7');
INSERT INTO `district` VALUES ('2571', '宝兴', '390', 'b', 'bx', 'baoxing', '', '县', '511827', '0835', '8');
INSERT INTO `district` VALUES ('2572', '巴州', '391', 'b', 'bz', 'bazhou', '', '区', '511902', '0827', '1');
INSERT INTO `district` VALUES ('2573', '通江', '391', 't', 'tj', 'tongjiang', '', '县', '511921', '0827', '2');
INSERT INTO `district` VALUES ('2574', '南江', '391', 'n', 'nj', 'nanjiang', '', '县', '511922', '0827', '3');
INSERT INTO `district` VALUES ('2575', '平昌', '391', 'p', 'pc', 'pingchang', '', '县', '511923', '0827', '4');
INSERT INTO `district` VALUES ('2576', '雁江', '392', 'y', 'yj', 'yanjiang', '', '区', '512002', '028', '1');
INSERT INTO `district` VALUES ('2577', '安岳', '392', 'a', 'ay', 'anyue', '', '县', '512021', '028', '2');
INSERT INTO `district` VALUES ('2578', '乐至', '392', 'l', 'lz', 'lezhi', '', '县', '512022', '028', '3');
INSERT INTO `district` VALUES ('2579', '简阳', '375', 'j', 'jy', 'jianyang', '', '市', '512081', '028', '4');
INSERT INTO `district` VALUES ('2580', '马尔康', '393', 'm', 'mek', 'maerkang', '', '市', '513229', '0837', '1');
INSERT INTO `district` VALUES ('2581', '汶川', '393', 'w', 'wc', 'wenchuan', '', '县', '513221', '0837', '2');
INSERT INTO `district` VALUES ('2582', '理县', '393', 'l', 'lx', 'lixian', '', '', '513222', '0837', '3');
INSERT INTO `district` VALUES ('2583', '茂县', '393', 'm', 'mx', 'maoxian', '', '', '513223', '0837', '4');
INSERT INTO `district` VALUES ('2584', '松潘', '393', 's', 'sp', 'songpan', '', '县', '513224', '0837', '5');
INSERT INTO `district` VALUES ('2585', '九寨沟', '393', 'j', 'jzg', 'jiuzhaigou', '', '县', '513225', '0837', '6');
INSERT INTO `district` VALUES ('2586', '金川', '393', 'j', 'jc', 'jinchuan', '', '县', '513226', '0837', '7');
INSERT INTO `district` VALUES ('2587', '小金', '393', 'x', 'xj', 'xiaojin', '', '县', '513227', '0837', '8');
INSERT INTO `district` VALUES ('2588', '黑水', '393', 'h', 'hs', 'heishui', '', '县', '513228', '0837', '9');
INSERT INTO `district` VALUES ('2589', '壤塘', '393', 'r', 'rt', 'rangtang', '', '县', '513230', '0837', '10');
INSERT INTO `district` VALUES ('2590', '阿坝', '393', 'a', 'ab', 'aba', '', '县', '513231', '0837', '11');
INSERT INTO `district` VALUES ('2591', '若尔盖', '393', 'r', 'reg', 'ruoergai', '', '县', '513232', '0837', '12');
INSERT INTO `district` VALUES ('2592', '红原', '393', 'h', 'hy', 'hongyuan', '', '县', '513233', '0837', '13');
INSERT INTO `district` VALUES ('2593', '康定', '394', 'k', 'kd', 'kangding', '', '市', '513301', '0836', '1');
INSERT INTO `district` VALUES ('2594', '泸定', '394', 'l', 'ld', 'luding', '', '县', '513322', '0836', '2');
INSERT INTO `district` VALUES ('2595', '丹巴', '394', 'd', 'db', 'danba', '', '县', '513323', '0836', '3');
INSERT INTO `district` VALUES ('2596', '九龙', '394', 'j', 'jl', 'jiulong', '', '县', '513324', '0836', '4');
INSERT INTO `district` VALUES ('2597', '雅江', '394', 'y', 'yj', 'yajiang', '', '县', '513325', '0836', '5');
INSERT INTO `district` VALUES ('2598', '道孚', '394', 'd', 'df', 'daofu', '', '县', '513326', '0836', '6');
INSERT INTO `district` VALUES ('2599', '炉霍', '394', 'l', 'lh', 'luhuo', '', '县', '513327', '0836', '7');
INSERT INTO `district` VALUES ('2600', '甘孜', '394', 'g', 'gz', 'ganzi', '', '县', '513328', '0836', '8');
INSERT INTO `district` VALUES ('2601', '新龙', '394', 'x', 'xl', 'xinlong', '', '县', '513329', '0836', '9');
INSERT INTO `district` VALUES ('2602', '德格', '394', 'd', 'dg', 'dege', '', '县', '513330', '0836', '10');
INSERT INTO `district` VALUES ('2603', '白玉', '394', 'b', 'by', 'baiyu', '', '县', '513331', '0836', '11');
INSERT INTO `district` VALUES ('2604', '石渠', '394', 's', 'sq', 'shiqu', '', '县', '513332', '0836', '12');
INSERT INTO `district` VALUES ('2605', '色达', '394', 's', 'sd', 'seda', '', '县', '513333', '0836', '13');
INSERT INTO `district` VALUES ('2606', '理塘', '394', 'l', 'lt', 'litang', '', '县', '513334', '0836', '14');
INSERT INTO `district` VALUES ('2607', '巴塘', '394', 'b', 'bt', 'batang', '', '县', '513335', '0836', '15');
INSERT INTO `district` VALUES ('2608', '乡城', '394', 'x', 'xc', 'xiangcheng', '', '县', '513336', '0836', '16');
INSERT INTO `district` VALUES ('2609', '稻城', '394', 'd', 'dc', 'daocheng', '', '县', '513337', '0836', '17');
INSERT INTO `district` VALUES ('2610', '得荣', '394', 'd', 'dr', 'derong', '', '县', '513338', '0836', '18');
INSERT INTO `district` VALUES ('2611', '西昌', '395', 'x', 'xc', 'xichang', '', '市', '513401', '0834', '1');
INSERT INTO `district` VALUES ('2612', '木里', '395', 'm', 'ml', 'muli', '藏族', '自治县', '513422', '0834', '2');
INSERT INTO `district` VALUES ('2613', '盐源', '395', 'y', 'yy', 'yanyuan', '', '县', '513423', '0834', '3');
INSERT INTO `district` VALUES ('2614', '德昌', '395', 'd', 'dc', 'dechang', '', '县', '513424', '0834', '4');
INSERT INTO `district` VALUES ('2615', '会理', '395', 'h', 'hl', 'huili', '', '县', '513425', '0834', '5');
INSERT INTO `district` VALUES ('2616', '会东', '395', 'h', 'hd', 'huidong', '', '县', '513426', '0834', '6');
INSERT INTO `district` VALUES ('2617', '宁南', '395', 'n', 'nn', 'ningnan', '', '县', '513427', '0834', '7');
INSERT INTO `district` VALUES ('2618', '普格', '395', 'p', 'pg', 'puge', '', '县', '513428', '0834', '8');
INSERT INTO `district` VALUES ('2619', '布拖', '395', 'b', 'bt', 'butuo', '', '县', '513429', '0834', '9');
INSERT INTO `district` VALUES ('2620', '金阳', '395', 'j', 'jy', 'jinyang', '', '县', '513430', '0834', '10');
INSERT INTO `district` VALUES ('2621', '昭觉', '395', 'z', 'zj', 'zhaojue', '', '县', '513431', '0834', '11');
INSERT INTO `district` VALUES ('2622', '喜德', '395', 'x', 'xd', 'xide', '', '县', '513432', '0834', '12');
INSERT INTO `district` VALUES ('2623', '冕宁', '395', 'm', 'mn', 'mianning', '', '县', '513433', '0834', '13');
INSERT INTO `district` VALUES ('2624', '越西', '395', 'y', 'yx', 'yuexi', '', '县', '513434', '0834', '14');
INSERT INTO `district` VALUES ('2625', '甘洛', '395', 'g', 'gl', 'ganluo', '', '县', '513435', '0834', '15');
INSERT INTO `district` VALUES ('2626', '美姑', '395', 'm', 'mg', 'meigu', '', '县', '513436', '0834', '16');
INSERT INTO `district` VALUES ('2627', '雷波', '395', 'l', 'lb', 'leibo', '', '县', '513437', '0834', '17');
INSERT INTO `district` VALUES ('2628', '观山湖', '396', 'g', 'gsh', 'guanshanhu', '', '区', '', '0851', '1');
INSERT INTO `district` VALUES ('2629', '南明', '396', 'n', 'nm', 'nanming', '', '区', '520102', '0851', '2');
INSERT INTO `district` VALUES ('2630', '云岩', '396', 'y', 'yy', 'yunyan', '', '区', '520103', '0851', '3');
INSERT INTO `district` VALUES ('2631', '花溪', '396', 'h', 'hx', 'huaxi', '', '区', '520111', '0851', '4');
INSERT INTO `district` VALUES ('2632', '乌当', '396', 'w', 'wd', 'wudang', '', '区', '520112', '0851', '5');
INSERT INTO `district` VALUES ('2633', '白云', '396', 'b', 'by', 'baiyun', '', '区', '520113', '0851', '6');
INSERT INTO `district` VALUES ('2634', '开阳', '396', 'k', 'ky', 'kaiyang', '', '县', '520121', '0851', '7');
INSERT INTO `district` VALUES ('2635', '息烽', '396', 'x', 'xf', 'xifeng', '', '县', '520122', '0851', '8');
INSERT INTO `district` VALUES ('2636', '修文', '396', 'x', 'xw', 'xiuwen', '', '县', '520123', '0851', '9');
INSERT INTO `district` VALUES ('2637', '清镇', '396', 'q', 'qz', 'qingzhen', '', '市', '520181', '0851', '10');
INSERT INTO `district` VALUES ('2638', '钟山', '397', 'z', 'zs', 'zhongshan', '', '区', '520201', '0858', '1');
INSERT INTO `district` VALUES ('2639', '六枝特', '397', 'l', 'lzt', 'liuzhite', '', '区', '520203', '0858', '2');
INSERT INTO `district` VALUES ('2640', '水城', '397', 's', 'sc', 'shuicheng', '', '县', '520221', '0858', '3');
INSERT INTO `district` VALUES ('2641', '盘县', '397', 'p', 'px', 'panxian', '', '', '520222', '0858', '4');
INSERT INTO `district` VALUES ('2642', '红花岗', '398', 'h', 'hhg', 'honghuagang', '', '区', '520302', '0852', '1');
INSERT INTO `district` VALUES ('2643', '汇川', '398', 'h', 'hc', 'huichuan', '', '区', '520303', '0852', '2');
INSERT INTO `district` VALUES ('2644', '播州', '398', 'b', 'bz', 'bozhou', '', '区', '520321', '0852', '3');
INSERT INTO `district` VALUES ('2645', '桐梓', '398', 't', 'tz', 'tongzi', '', '县', '520322', '0852', '4');
INSERT INTO `district` VALUES ('2646', '绥阳', '398', 's', 'sy', 'suiyang', '', '县', '520323', '0852', '5');
INSERT INTO `district` VALUES ('2647', '正安', '398', 'z', 'za', 'zhengan', '', '县', '520324', '0852', '6');
INSERT INTO `district` VALUES ('2648', '道真', '398', 'd', 'dz', 'daozhen', '仡佬族苗族', '自治县', '520325', '0852', '7');
INSERT INTO `district` VALUES ('2649', '务川', '398', 'w', 'wc', 'wuchuan', '仡佬族苗族', '自治县', '520326', '0852', '8');
INSERT INTO `district` VALUES ('2650', '凤冈', '398', 'f', 'fg', 'fenggang', '', '县', '520327', '0852', '9');
INSERT INTO `district` VALUES ('2651', '湄潭', '398', 'm', 'mt', 'meitan', '', '县', '520328', '0852', '10');
INSERT INTO `district` VALUES ('2652', '余庆', '398', 'y', 'yq', 'yuqing', '', '县', '520329', '0852', '11');
INSERT INTO `district` VALUES ('2653', '习水', '398', 'x', 'xs', 'xishui', '', '县', '520330', '0852', '12');
INSERT INTO `district` VALUES ('2654', '赤水', '398', 'c', 'cs', 'chishui', '', '市', '520381', '0852', '13');
INSERT INTO `district` VALUES ('2655', '仁怀', '398', 'r', 'rh', 'renhuai', '', '市', '520382', '0852', '14');
INSERT INTO `district` VALUES ('2656', '西秀', '399', 'x', 'xx', 'xixiu', '', '区', '520402', '0853', '1');
INSERT INTO `district` VALUES ('2657', '平坝', '399', 'p', 'pb', 'pingba', '', '区', '520403', '0853', '2');
INSERT INTO `district` VALUES ('2658', '普定', '399', 'p', 'pd', 'puding', '', '县', '520422', '0853', '3');
INSERT INTO `district` VALUES ('2659', '镇宁', '399', 'z', 'zn', 'zhenning', '布依族苗族', '自治县', '520423', '0853', '4');
INSERT INTO `district` VALUES ('2660', '关岭', '399', 'g', 'gl', 'guanling', '布依族苗族', '自治县', '520424', '0853', '5');
INSERT INTO `district` VALUES ('2661', '紫云', '399', 'z', 'zy', 'ziyun', '苗族布依族', '自治县', '520425', '0853', '6');
INSERT INTO `district` VALUES ('2662', '七星关', '400', 'q', 'qxg', 'qixingguan', '', '区', '520502', '0857', '1');
INSERT INTO `district` VALUES ('2663', '大方', '400', 'd', 'df', 'dafang', '', '县', '520521', '0857', '2');
INSERT INTO `district` VALUES ('2664', '黔西', '400', 'q', 'qx', 'qianxi', '', '县', '520522', '0857', '3');
INSERT INTO `district` VALUES ('2665', '金沙', '400', 'j', 'js', 'jinsha', '', '县', '520523', '0857', '4');
INSERT INTO `district` VALUES ('2666', '织金', '400', 'z', 'zj', 'zhijin', '', '县', '520524', '0857', '5');
INSERT INTO `district` VALUES ('2667', '纳雍', '400', 'n', 'ny', 'nayong', '', '县', '520525', '0857', '6');
INSERT INTO `district` VALUES ('2668', '威宁', '400', 'w', 'wn', 'weining', '彝族回族苗族', '自治县', '520526', '0857', '7');
INSERT INTO `district` VALUES ('2669', '赫章', '400', 'h', 'hz', 'hezhang', '', '县', '520527', '0857', '8');
INSERT INTO `district` VALUES ('2670', '碧江', '401', 'b', 'bj', 'bijiang', '', '区', '520602', '0856', '1');
INSERT INTO `district` VALUES ('2671', '万山', '401', 'w', 'ws', 'wanshan', '', '区', '520603', '0856', '2');
INSERT INTO `district` VALUES ('2672', '江口', '401', 'j', 'jk', 'jiangkou', '', '县', '520621', '0856', '3');
INSERT INTO `district` VALUES ('2673', '玉屏', '401', 'y', 'yp', 'yuping', '侗族', '自治县', '520622', '0856', '4');
INSERT INTO `district` VALUES ('2674', '石阡', '401', 's', 'sq', 'shiqian', '', '县', '520623', '0856', '5');
INSERT INTO `district` VALUES ('2675', '思南', '401', 's', 'sn', 'sinan', '', '县', '520624', '0856', '6');
INSERT INTO `district` VALUES ('2676', '印江', '401', 'y', 'yj', 'yinjiang', '土家族苗族', '自治县', '520625', '0856', '7');
INSERT INTO `district` VALUES ('2677', '德江', '401', 'd', 'dj', 'dejiang', '', '县', '520626', '0856', '8');
INSERT INTO `district` VALUES ('2678', '沿河', '401', 'y', 'yh', 'yanhe', '土家族', '自治县', '520627', '0856', '9');
INSERT INTO `district` VALUES ('2679', '松桃', '401', 's', 'st', 'songtao', '苗族', '自治县', '520628', '0856', '10');
INSERT INTO `district` VALUES ('2680', '兴义', '402', 'x', 'xy', 'xingyi', '', '市', '522301', '0859', '1');
INSERT INTO `district` VALUES ('2681', '兴仁', '402', 'x', 'xr', 'xingren', '', '县', '522322', '0859', '2');
INSERT INTO `district` VALUES ('2682', '普安', '402', 'p', 'pa', 'puan', '', '县', '522323', '0859', '3');
INSERT INTO `district` VALUES ('2683', '晴隆', '402', 'q', 'ql', 'qinglong', '', '县', '522324', '0859', '4');
INSERT INTO `district` VALUES ('2684', '贞丰', '402', 'z', 'zf', 'zhenfeng', '', '县', '522325', '0859', '5');
INSERT INTO `district` VALUES ('2685', '望谟', '402', 'w', 'wm', 'wangmo', '', '县', '522326', '0859', '6');
INSERT INTO `district` VALUES ('2686', '册亨', '402', 'c', 'ch', 'ceheng', '', '县', '522327', '0859', '7');
INSERT INTO `district` VALUES ('2687', '安龙', '402', 'a', 'al', 'anlong', '', '县', '522328', '0859', '8');
INSERT INTO `district` VALUES ('2688', '凯里', '403', 'k', 'kl', 'kaili', '', '市', '522601', '0855', '1');
INSERT INTO `district` VALUES ('2689', '黄平', '403', 'h', 'hp', 'huangping', '', '县', '522622', '0855', '2');
INSERT INTO `district` VALUES ('2690', '施秉', '403', 's', 'sb', 'shibing', '', '县', '522623', '0855', '3');
INSERT INTO `district` VALUES ('2691', '三穗', '403', 's', 'ss', 'sansui', '', '县', '522624', '0855', '4');
INSERT INTO `district` VALUES ('2692', '镇远', '403', 'z', 'zy', 'zhenyuan', '', '县', '522625', '0855', '5');
INSERT INTO `district` VALUES ('2693', '岑巩', '403', 'c', 'cg', 'cengong', '', '县', '522626', '0855', '6');
INSERT INTO `district` VALUES ('2694', '天柱', '403', 't', 'tz', 'tianzhu', '', '县', '522627', '0855', '7');
INSERT INTO `district` VALUES ('2695', '锦屏', '403', 'j', 'jp', 'jinping', '', '县', '522628', '0855', '8');
INSERT INTO `district` VALUES ('2696', '剑河', '403', 'j', 'jh', 'jianhe', '', '县', '522629', '0855', '9');
INSERT INTO `district` VALUES ('2697', '台江', '403', 't', 'tj', 'taijiang', '', '县', '522630', '0855', '10');
INSERT INTO `district` VALUES ('2698', '黎平', '403', 'l', 'lp', 'liping', '', '县', '522631', '0855', '11');
INSERT INTO `district` VALUES ('2699', '榕江', '403', 'r', 'rj', 'rongjiang', '', '县', '522632', '0855', '12');
INSERT INTO `district` VALUES ('2700', '从江', '403', 'c', 'cj', 'congjiang', '', '县', '522633', '0855', '13');
INSERT INTO `district` VALUES ('2701', '雷山', '403', 'l', 'ls', 'leishan', '', '县', '522634', '0855', '14');
INSERT INTO `district` VALUES ('2702', '麻江', '403', 'm', 'mj', 'majiang', '', '县', '522635', '0855', '15');
INSERT INTO `district` VALUES ('2703', '丹寨', '403', 'd', 'dz', 'danzhai', '', '县', '522636', '0855', '16');
INSERT INTO `district` VALUES ('2704', '都匀', '404', 'd', 'dy', 'douyun', '', '市', '522701', '0854', '1');
INSERT INTO `district` VALUES ('2705', '福泉', '404', 'f', 'fq', 'fuquan', '', '市', '522702', '0854', '2');
INSERT INTO `district` VALUES ('2706', '荔波', '404', 'l', 'lb', 'libo', '', '县', '522722', '0854', '3');
INSERT INTO `district` VALUES ('2707', '贵定', '404', 'g', 'gd', 'guiding', '', '县', '522723', '0854', '4');
INSERT INTO `district` VALUES ('2708', '瓮安', '404', 'w', 'wa', 'wengan', '', '县', '522725', '0854', '5');
INSERT INTO `district` VALUES ('2709', '独山', '404', 'd', 'ds', 'dushan', '', '县', '522726', '0854', '6');
INSERT INTO `district` VALUES ('2710', '平塘', '404', 'p', 'pt', 'pingtang', '', '县', '522727', '0854', '7');
INSERT INTO `district` VALUES ('2711', '罗甸', '404', 'l', 'ld', 'luodian', '', '县', '522728', '0854', '8');
INSERT INTO `district` VALUES ('2712', '长顺', '404', 'z', 'zs', 'zhangshun', '', '县', '522729', '0854', '9');
INSERT INTO `district` VALUES ('2713', '龙里', '404', 'l', 'll', 'longli', '', '县', '522730', '0854', '10');
INSERT INTO `district` VALUES ('2714', '惠水', '404', 'h', 'hs', 'huishui', '', '县', '522731', '0854', '11');
INSERT INTO `district` VALUES ('2715', '三都', '404', 's', 'sd', 'sandou', '水族', '自治县', '522732', '0854', '12');
INSERT INTO `district` VALUES ('2716', '五华', '405', 'w', 'wh', 'wuhua', '', '区', '530102', '0871', '1');
INSERT INTO `district` VALUES ('2717', '盘龙', '405', 'p', 'pl', 'panlong', '', '区', '530103', '0871', '2');
INSERT INTO `district` VALUES ('2718', '官渡', '405', 'g', 'gd', 'guandu', '', '区', '530111', '0871', '3');
INSERT INTO `district` VALUES ('2719', '西山', '405', 'x', 'xs', 'xishan', '', '区', '530112', '0871', '4');
INSERT INTO `district` VALUES ('2720', '东川', '405', 'd', 'dc', 'dongchuan', '', '区', '530113', '0871', '5');
INSERT INTO `district` VALUES ('2721', '呈贡', '405', 'c', 'cg', 'chenggong', '', '区', '530114', '0871', '6');
INSERT INTO `district` VALUES ('2722', '晋宁', '405', 'j', 'jn', 'jinning', '', '区', '530122', '0871', '7');
INSERT INTO `district` VALUES ('2723', '富民', '405', 'f', 'fm', 'fumin', '', '县', '530124', '0871', '8');
INSERT INTO `district` VALUES ('2724', '宜良', '405', 'y', 'yl', 'yiliang', '', '县', '530125', '0871', '9');
INSERT INTO `district` VALUES ('2725', '石林', '405', 's', 'sl', 'shilin', '彝族', '自治县', '530126', '0871', '10');
INSERT INTO `district` VALUES ('2726', '嵩明', '405', 's', 'sm', 'songming', '', '县', '530127', '0871', '11');
INSERT INTO `district` VALUES ('2727', '禄劝', '405', 'l', 'lq', 'luquan', '彝族苗族', '自治县', '530128', '0871', '12');
INSERT INTO `district` VALUES ('2728', '寻甸', '405', 'x', 'xd', 'xundian', '回族彝族', '自治县', '530129', '0871', '13');
INSERT INTO `district` VALUES ('2729', '安宁', '405', 'a', 'an', 'anning', '', '市', '530181', '0871', '14');
INSERT INTO `district` VALUES ('2730', '麒麟', '406', 'q', 'ql', 'qilin', '', '区', '530302', '0874', '1');
INSERT INTO `district` VALUES ('2731', '马龙', '406', 'm', 'ml', 'malong', '', '县', '530321', '0874', '2');
INSERT INTO `district` VALUES ('2732', '陆良', '406', 'l', 'll', 'luliang', '', '县', '530322', '0874', '3');
INSERT INTO `district` VALUES ('2733', '师宗', '406', 's', 'sz', 'shizong', '', '县', '530323', '0874', '4');
INSERT INTO `district` VALUES ('2734', '罗平', '406', 'l', 'lp', 'luoping', '', '县', '530324', '0874', '5');
INSERT INTO `district` VALUES ('2735', '富源', '406', 'f', 'fy', 'fuyuan', '', '县', '530325', '0874', '6');
INSERT INTO `district` VALUES ('2736', '会泽', '406', 'h', 'hz', 'huize', '', '县', '530326', '0874', '7');
INSERT INTO `district` VALUES ('2737', '沾益', '406', 'z', 'zy', 'zhanyi', '', '区', '530328', '0874', '8');
INSERT INTO `district` VALUES ('2738', '宣威', '406', 'x', 'xw', 'xuanwei', '', '市', '530381', '0874', '9');
INSERT INTO `district` VALUES ('2739', '红塔', '407', 'h', 'ht', 'hongta', '', '区', '530402', '0877', '1');
INSERT INTO `district` VALUES ('2740', '江川', '407', 'j', 'jc', 'jiangchuan', '', '区', '530421', '0877', '2');
INSERT INTO `district` VALUES ('2741', '澄江', '407', 'c', 'cj', 'chengjiang', '', '县', '530422', '0877', '3');
INSERT INTO `district` VALUES ('2742', '通海', '407', 't', 'th', 'tonghai', '', '县', '530423', '0877', '4');
INSERT INTO `district` VALUES ('2743', '华宁', '407', 'h', 'hn', 'huaning', '', '县', '530424', '0877', '5');
INSERT INTO `district` VALUES ('2744', '易门', '407', 'y', 'ym', 'yimen', '', '县', '530425', '0877', '6');
INSERT INTO `district` VALUES ('2745', '峨山', '407', 'e', 'es', 'eshan', '彝族', '自治县', '530426', '0877', '7');
INSERT INTO `district` VALUES ('2746', '新平', '407', 'x', 'xp', 'xinping', '彝族傣族', '自治县', '530427', '0877', '8');
INSERT INTO `district` VALUES ('2747', '元江', '407', 'y', 'yj', 'yuanjiang', '哈尼族彝族傣族', '自治县', '530428', '0877', '9');
INSERT INTO `district` VALUES ('2748', '昭阳', '408', 'z', 'zy', 'zhaoyang', '', '区', '530602', '0870', '1');
INSERT INTO `district` VALUES ('2749', '鲁甸', '408', 'l', 'ld', 'ludian', '', '县', '530621', '0870', '2');
INSERT INTO `district` VALUES ('2750', '巧家', '408', 'q', 'qj', 'qiaojia', '', '县', '530622', '0870', '3');
INSERT INTO `district` VALUES ('2751', '盐津', '408', 'y', 'yj', 'yanjin', '', '县', '530623', '0870', '4');
INSERT INTO `district` VALUES ('2752', '大关', '408', 'd', 'dg', 'daguan', '', '县', '530624', '0870', '5');
INSERT INTO `district` VALUES ('2753', '永善', '408', 'y', 'ys', 'yongshan', '', '县', '530625', '0870', '6');
INSERT INTO `district` VALUES ('2754', '绥江', '408', 's', 'sj', 'suijiang', '', '县', '530626', '0870', '7');
INSERT INTO `district` VALUES ('2755', '镇雄', '408', 'z', 'zx', 'zhenxiong', '', '县', '530627', '0870', '8');
INSERT INTO `district` VALUES ('2756', '彝良', '408', 'y', 'yl', 'yiliang', '', '县', '530628', '0870', '9');
INSERT INTO `district` VALUES ('2757', '威信', '408', 'w', 'wx', 'weixin', '', '县', '530629', '0870', '10');
INSERT INTO `district` VALUES ('2758', '水富', '408', 's', 'sf', 'shuifu', '', '县', '530630', '0870', '11');
INSERT INTO `district` VALUES ('2759', '古城', '409', 'g', 'gc', 'gucheng', '', '区', '530702', '0888', '1');
INSERT INTO `district` VALUES ('2760', '玉龙', '409', 'y', 'yl', 'yulong', '纳西族', '自治县', '530721', '0888', '2');
INSERT INTO `district` VALUES ('2761', '永胜', '409', 'y', 'ys', 'yongsheng', '', '县', '530722', '0888', '3');
INSERT INTO `district` VALUES ('2762', '华坪', '409', 'h', 'hp', 'huaping', '', '县', '530723', '0888', '4');
INSERT INTO `district` VALUES ('2763', '宁蒗', '409', 'n', 'nl', 'ninglang', '彝族', '自治县', '530724', '0888', '5');
INSERT INTO `district` VALUES ('2764', '思茅', '410', 's', 'sm', 'simao', '', '区', '530802', '0879', '1');
INSERT INTO `district` VALUES ('2765', '宁洱', '410', 'n', 'ne', 'ninger', '哈尼族彝族', '县', '530821', '0879', '2');
INSERT INTO `district` VALUES ('2766', '墨江', '410', 'm', 'mj', 'mojiang', '哈尼族', '县', '530822', '0879', '3');
INSERT INTO `district` VALUES ('2767', '景东', '410', 'j', 'jd', 'jingdong', '彝族', '县', '530823', '0879', '4');
INSERT INTO `district` VALUES ('2768', '景谷', '410', 'j', 'jg', 'jinggu', '傣族彝族', '县', '530824', '0879', '5');
INSERT INTO `district` VALUES ('2769', '镇沅', '410', 'z', 'zy', 'zhenyuan', '彝族哈尼族拉祜族', '县', '530825', '0879', '6');
INSERT INTO `district` VALUES ('2770', '江城', '410', 'j', 'jc', 'jiangcheng', '哈尼族彝族', '县', '530826', '0879', '7');
INSERT INTO `district` VALUES ('2771', '孟连', '410', 'm', 'ml', 'menglian', '傣族拉祜族佤族', '县', '530827', '0879', '8');
INSERT INTO `district` VALUES ('2772', '澜沧', '410', 'l', 'lc', 'lancang', '拉祜族', '县', '530828', '0879', '9');
INSERT INTO `district` VALUES ('2773', '西盟', '410', 'x', 'xm', 'ximeng', '佤族', '县', '530829', '0879', '10');
INSERT INTO `district` VALUES ('2774', '临翔', '411', 'l', 'lx', 'linxiang', '', '区', '530902', '0883', '1');
INSERT INTO `district` VALUES ('2775', '凤庆', '411', 'f', 'fq', 'fengqing', '', '县', '530921', '0883', '2');
INSERT INTO `district` VALUES ('2776', '云县', '411', 'y', 'yx', 'yunxian', '', '', '530922', '0883', '3');
INSERT INTO `district` VALUES ('2777', '永德', '411', 'y', 'yd', 'yongde', '', '县', '530923', '0883', '4');
INSERT INTO `district` VALUES ('2778', '镇康', '411', 'z', 'zk', 'zhenkang', '', '县', '530924', '0883', '5');
INSERT INTO `district` VALUES ('2779', '双江', '411', 's', 'sj', 'shuangjiang', '拉祜族佤族布朗族傣族', '自治县', '530925', '0883', '6');
INSERT INTO `district` VALUES ('2780', '耿马', '411', 'g', 'gm', 'gengma', '傣族佤族', '自治县', '530926', '0883', '7');
INSERT INTO `district` VALUES ('2781', '沧源', '411', 'c', 'cy', 'cangyuan', '佤族', '自治县', '530927', '0883', '8');
INSERT INTO `district` VALUES ('2782', '楚雄', '412', 'c', 'cx', 'chuxiong', '', '市', '532301', '0878', '1');
INSERT INTO `district` VALUES ('2783', '双柏', '412', 's', 'sb', 'shuangbo', '', '县', '532322', '0878', '2');
INSERT INTO `district` VALUES ('2784', '牟定', '412', 'm', 'md', 'mouding', '', '县', '532323', '0878', '3');
INSERT INTO `district` VALUES ('2785', '南华', '412', 'n', 'nh', 'nanhua', '', '县', '532324', '0878', '4');
INSERT INTO `district` VALUES ('2786', '姚安', '412', 'y', 'ya', 'yaoan', '', '县', '532325', '0878', '5');
INSERT INTO `district` VALUES ('2787', '大姚', '412', 'd', 'dy', 'dayao', '', '县', '532326', '0878', '6');
INSERT INTO `district` VALUES ('2788', '永仁', '412', 'y', 'yr', 'yongren', '', '县', '532327', '0878', '7');
INSERT INTO `district` VALUES ('2789', '元谋', '412', 'y', 'ym', 'yuanmou', '', '县', '532328', '0878', '8');
INSERT INTO `district` VALUES ('2790', '武定', '412', 'w', 'wd', 'wuding', '', '县', '532329', '0878', '9');
INSERT INTO `district` VALUES ('2791', '禄丰', '412', 'l', 'lf', 'lufeng', '', '县', '532331', '0878', '10');
INSERT INTO `district` VALUES ('2792', '个旧', '413', 'g', 'gj', 'gejiu', '', '市', '532501', '0873', '1');
INSERT INTO `district` VALUES ('2793', '开远', '413', 'k', 'ky', 'kaiyuan', '', '市', '532502', '0873', '2');
INSERT INTO `district` VALUES ('2794', '蒙自', '413', 'm', 'mz', 'mengzi', '', '市', '532503', '0873', '3');
INSERT INTO `district` VALUES ('2795', '屏边', '413', 'p', 'pb', 'pingbian', '苗族', '自治县', '532523', '0873', '4');
INSERT INTO `district` VALUES ('2796', '建水', '413', 'j', 'js', 'jianshui', '', '县', '532524', '0873', '5');
INSERT INTO `district` VALUES ('2797', '石屏', '413', 's', 'sp', 'shiping', '', '县', '532525', '0873', '6');
INSERT INTO `district` VALUES ('2798', '弥勒', '413', 'm', 'ml', 'mile', '', '市', '532526', '0873', '7');
INSERT INTO `district` VALUES ('2799', '泸西', '413', 'l', 'lx', 'luxi', '', '县', '532527', '0873', '8');
INSERT INTO `district` VALUES ('2800', '元阳', '413', 'y', 'yy', 'yuanyang', '', '县', '532528', '0873', '9');
INSERT INTO `district` VALUES ('2801', '红河', '413', 'h', 'hh', 'honghe', '', '县', '532529', '0873', '10');
INSERT INTO `district` VALUES ('2802', '金平', '413', 'j', 'jp', 'jinping', '苗族瑶族傣族', '自治县', '532530', '0873', '11');
INSERT INTO `district` VALUES ('2803', '绿春', '413', 'l', 'lc', 'lu:chun', '', '县', '532531', '0873', '12');
INSERT INTO `district` VALUES ('2804', '河口', '413', 'h', 'hk', 'hekou', '瑶族', '自治县', '532532', '0873', '13');
INSERT INTO `district` VALUES ('2805', '文山', '414', 'w', 'ws', 'wenshan', '', '县', '532601', '0876', '1');
INSERT INTO `district` VALUES ('2806', '砚山', '414', 'y', 'ys', 'yanshan', '', '县', '532622', '0876', '2');
INSERT INTO `district` VALUES ('2807', '西畴', '414', 'x', 'xc', 'xichou', '', '县', '532623', '0876', '3');
INSERT INTO `district` VALUES ('2808', '麻栗坡', '414', 'm', 'mlp', 'malipo', '', '县', '532624', '0876', '4');
INSERT INTO `district` VALUES ('2809', '马关', '414', 'm', 'mg', 'maguan', '', '县', '532625', '0876', '5');
INSERT INTO `district` VALUES ('2810', '丘北', '414', 'q', 'qb', 'qiubei', '', '县', '532626', '0876', '6');
INSERT INTO `district` VALUES ('2811', '广南', '414', 'g', 'gn', 'guangnan', '', '县', '532627', '0876', '7');
INSERT INTO `district` VALUES ('2812', '富宁', '414', 'f', 'fn', 'funing', '', '县', '532628', '0876', '8');
INSERT INTO `district` VALUES ('2813', '景洪', '415', 'j', 'jh', 'jinghong', '', '市', '532801', '0691', '1');
INSERT INTO `district` VALUES ('2814', '勐海', '415', 'm', 'mh', 'menghai', '', '县', '532822', '0691', '2');
INSERT INTO `district` VALUES ('2815', '勐腊', '415', 'm', 'ml', 'mengla', '', '县', '532823', '0691', '3');
INSERT INTO `district` VALUES ('2816', '大理', '416', 'd', 'dl', 'dali', '', '市', '532901', '0872', '1');
INSERT INTO `district` VALUES ('2817', '漾濞', '416', 'y', 'yb', 'yangbi', '彝族', '自治县', '532922', '0872', '2');
INSERT INTO `district` VALUES ('2818', '祥云', '416', 'x', 'xy', 'xiangyun', '', '县', '532923', '0872', '3');
INSERT INTO `district` VALUES ('2819', '宾川', '416', 'b', 'bc', 'binchuan', '', '县', '532924', '0872', '4');
INSERT INTO `district` VALUES ('2820', '弥渡', '416', 'm', 'md', 'midu', '', '县', '532925', '0872', '5');
INSERT INTO `district` VALUES ('2821', '南涧', '416', 'n', 'nj', 'nanjian', '彝族', '自治县', '532926', '0872', '6');
INSERT INTO `district` VALUES ('2822', '巍山', '416', 'w', 'ws', 'weishan', '彝族回族', '自治县', '532927', '0872', '7');
INSERT INTO `district` VALUES ('2823', '永平', '416', 'y', 'yp', 'yongping', '', '县', '532928', '0872', '8');
INSERT INTO `district` VALUES ('2824', '云龙', '416', 'y', 'yl', 'yunlong', '', '县', '532929', '0872', '9');
INSERT INTO `district` VALUES ('2825', '洱源', '416', 'e', 'ey', 'eryuan', '', '县', '532930', '0872', '10');
INSERT INTO `district` VALUES ('2826', '剑川', '416', 'j', 'jc', 'jianchuan', '', '县', '532931', '0872', '11');
INSERT INTO `district` VALUES ('2827', '鹤庆', '416', 'h', 'hq', 'heqing', '', '县', '532932', '0872', '12');
INSERT INTO `district` VALUES ('2828', '瑞丽', '417', 'r', 'rl', 'ruili', '', '市', '533102', '0692', '1');
INSERT INTO `district` VALUES ('2829', '芒市', '417', 'm', 'ms', 'mangshi', '', '', '533103', '0692', '2');
INSERT INTO `district` VALUES ('2830', '梁河', '417', 'l', 'lh', 'lianghe', '', '县', '533122', '0692', '3');
INSERT INTO `district` VALUES ('2831', '盈江', '417', 'y', 'yj', 'yingjiang', '', '县', '533123', '0692', '4');
INSERT INTO `district` VALUES ('2832', '陇川', '417', 'l', 'lc', 'longchuan', '', '县', '533124', '0692', '5');
INSERT INTO `district` VALUES ('2833', '泸水', '418', 'l', 'ls', 'lushui', '', '市', '533321', '0886', '1');
INSERT INTO `district` VALUES ('2834', '福贡', '418', 'f', 'fg', 'fugong', '', '县', '533323', '0886', '2');
INSERT INTO `district` VALUES ('2835', '贡山', '418', 'g', 'gs', 'gongshan', '独龙族怒族', '县', '533324', '0886', '3');
INSERT INTO `district` VALUES ('2836', '兰坪', '418', 'l', 'lp', 'lanping', '白族普米族', '县', '533325', '0886', '4');
INSERT INTO `district` VALUES ('2837', '香格里拉', '419', 'x', 'xgll', 'xianggelila', '', '市', '533421', '0887', '1');
INSERT INTO `district` VALUES ('2838', '德钦', '419', 'd', 'dq', 'deqin', '', '县', '533422', '0887', '2');
INSERT INTO `district` VALUES ('2839', '维西', '419', 'w', 'wx', 'weixi', '', '县', '533423', '0887', '3');
INSERT INTO `district` VALUES ('2840', '隆阳', '420', 'l', 'ly', 'longyang', '', '区', '530502', '0875', '1');
INSERT INTO `district` VALUES ('2841', '施甸', '420', 's', 'sd', 'shidian', '', '县', '530521', '0875', '2');
INSERT INTO `district` VALUES ('2842', '腾冲', '420', 't', 'tc', 'tengchong', '', '市', '530522', '0875', '3');
INSERT INTO `district` VALUES ('2843', '龙陵', '420', 'l', 'll', 'longling', '', '县', '530523', '0875', '4');
INSERT INTO `district` VALUES ('2844', '昌宁', '420', 'c', 'cn', 'changning', '', '县', '530524', '0875', '5');
INSERT INTO `district` VALUES ('2845', '城关', '421', 'c', 'cg', 'chengguan', '', '区', '540102', '0891', '1');
INSERT INTO `district` VALUES ('2846', '林周', '421', 'l', 'lz', 'linzhou', '', '县', '540121', '0891', '2');
INSERT INTO `district` VALUES ('2847', '当雄', '421', 'd', 'dx', 'dangxiong', '', '县', '540122', '0891', '3');
INSERT INTO `district` VALUES ('2848', '尼木', '421', 'n', 'nm', 'nimu', '', '县', '540123', '0891', '4');
INSERT INTO `district` VALUES ('2849', '曲水', '421', 'q', 'qs', 'qushui', '', '县', '540124', '0891', '5');
INSERT INTO `district` VALUES ('2850', '堆龙德庆', '421', 'd', 'dldq', 'duilongdeqing', '', '区', '540125', '0891', '6');
INSERT INTO `district` VALUES ('2851', '达孜', '421', 'd', 'dz', 'dazi', '', '县', '540126', '0891', '7');
INSERT INTO `district` VALUES ('2852', '墨竹工卡', '421', 'm', 'mzgk', 'mozhugongka', '', '县', '540127', '0891', '8');
INSERT INTO `district` VALUES ('2853', '卡若', '422', 'k', 'kr', 'karuo', '', '区', '542121', '0895', '1');
INSERT INTO `district` VALUES ('2854', '江达', '422', 'j', 'jd', 'jiangda', '', '县', '542122', '0895', '2');
INSERT INTO `district` VALUES ('2855', '贡觉', '422', 'g', 'gj', 'gongjue', '', '县', '542123', '0895', '3');
INSERT INTO `district` VALUES ('2856', '类乌齐', '422', 'l', 'lwq', 'leiwuqi', '', '县', '542124', '0895', '4');
INSERT INTO `district` VALUES ('2857', '丁青', '422', 'd', 'dq', 'dingqing', '', '县', '542125', '0895', '5');
INSERT INTO `district` VALUES ('2858', '察雅', '422', 'c', 'cy', 'chaya', '', '县', '542126', '0895', '6');
INSERT INTO `district` VALUES ('2859', '八宿', '422', 'b', 'bs', 'basu', '', '县', '542127', '0895', '7');
INSERT INTO `district` VALUES ('2860', '左贡', '422', 'z', 'zg', 'zuogong', '', '县', '542128', '0895', '8');
INSERT INTO `district` VALUES ('2861', '芒康', '422', 'm', 'mk', 'mangkang', '', '县', '542129', '0895', '9');
INSERT INTO `district` VALUES ('2862', '洛隆', '422', 'l', 'll', 'luolong', '', '县', '542132', '0895', '10');
INSERT INTO `district` VALUES ('2863', '边坝', '422', 'b', 'bb', 'bianba', '', '县', '542133', '0895', '11');
INSERT INTO `district` VALUES ('2864', '乃东', '423', 'n', 'nd', 'naidong', '', '区', '542221', '0893', '1');
INSERT INTO `district` VALUES ('2865', '扎囊', '423', 'z', 'zn', 'zhanang', '', '县', '542222', '0893', '2');
INSERT INTO `district` VALUES ('2866', '贡嘎', '423', 'g', 'gg', 'gongga', '', '县', '542223', '0893', '3');
INSERT INTO `district` VALUES ('2867', '桑日', '423', 's', 'sr', 'sangri', '', '县', '542224', '0893', '4');
INSERT INTO `district` VALUES ('2868', '琼结', '423', 'q', 'qj', 'qiongjie', '', '县', '542225', '0893', '5');
INSERT INTO `district` VALUES ('2869', '曲松', '423', 'q', 'qs', 'qusong', '', '县', '542226', '0893', '6');
INSERT INTO `district` VALUES ('2870', '措美', '423', 'c', 'cm', 'cuomei', '', '县', '542227', '0893', '7');
INSERT INTO `district` VALUES ('2871', '洛扎', '423', 'l', 'lz', 'luozha', '', '县', '542228', '0893', '8');
INSERT INTO `district` VALUES ('2872', '加查', '423', 'j', 'jc', 'jiacha', '', '县', '542229', '0893', '9');
INSERT INTO `district` VALUES ('2873', '隆子', '423', 'l', 'lz', 'longzi', '', '县', '542231', '0893', '10');
INSERT INTO `district` VALUES ('2874', '错那', '423', 'c', 'cn', 'cuonei', '', '县', '542232', '0893', '11');
INSERT INTO `district` VALUES ('2875', '浪卡子', '423', 'l', 'lkz', 'langkazi', '', '县', '542233', '0893', '12');
INSERT INTO `district` VALUES ('2876', '桑珠孜', '424', 's', 'szz', 'sangzhuzi', '', '区', '542301', '0892', '1');
INSERT INTO `district` VALUES ('2877', '南木林', '424', 'n', 'nml', 'nanmulin', '', '县', '542322', '0892', '2');
INSERT INTO `district` VALUES ('2878', '江孜', '424', 'j', 'jz', 'jiangzi', '', '县', '542323', '0892', '3');
INSERT INTO `district` VALUES ('2879', '定日', '424', 'd', 'dr', 'dingri', '', '县', '542324', '0892', '4');
INSERT INTO `district` VALUES ('2880', '萨迦', '424', 's', 'sj', 'sajia', '', '县', '542325', '0892', '5');
INSERT INTO `district` VALUES ('2881', '拉孜', '424', 'l', 'lz', 'lazi', '', '县', '542326', '0892', '6');
INSERT INTO `district` VALUES ('2882', '昂仁', '424', 'a', 'ar', 'angren', '', '县', '542327', '0892', '7');
INSERT INTO `district` VALUES ('2883', '谢通门', '424', 'x', 'xtm', 'xietongmen', '', '县', '542328', '0892', '8');
INSERT INTO `district` VALUES ('2884', '白朗', '424', 'b', 'bl', 'bailang', '', '县', '542329', '0892', '9');
INSERT INTO `district` VALUES ('2885', '仁布', '424', 'r', 'rb', 'renbu', '', '县', '542330', '0892', '10');
INSERT INTO `district` VALUES ('2886', '康马', '424', 'k', 'km', 'kangma', '', '县', '542331', '0892', '11');
INSERT INTO `district` VALUES ('2887', '定结', '424', 'd', 'dj', 'dingjie', '', '县', '542332', '0892', '12');
INSERT INTO `district` VALUES ('2888', '仲巴', '424', 'z', 'zb', 'zhongba', '', '县', '542333', '0892', '13');
INSERT INTO `district` VALUES ('2889', '亚东', '424', 'y', 'yd', 'yadong', '', '县', '542334', '0892', '14');
INSERT INTO `district` VALUES ('2890', '吉隆', '424', 'j', 'jl', 'jilong', '', '县', '542335', '0892', '15');
INSERT INTO `district` VALUES ('2891', '聂拉木', '424', 'n', 'nlm', 'nielamu', '', '县', '542336', '0892', '16');
INSERT INTO `district` VALUES ('2892', '萨嘎', '424', 's', 'sg', 'saga', '', '县', '542337', '0892', '17');
INSERT INTO `district` VALUES ('2893', '岗巴', '424', 'g', 'gb', 'gangba', '', '县', '542338', '0892', '18');
INSERT INTO `district` VALUES ('2894', '双湖', '425', 's', 'sh', 'shuanghu', '', '县', '542431', '0896', '1');
INSERT INTO `district` VALUES ('2895', '那曲', '425', 'n', 'nq', 'neiqu', '', '县', '542421', '0896', '2');
INSERT INTO `district` VALUES ('2896', '嘉黎', '425', 'j', 'jl', 'jiali', '', '县', '542421', '0896', '3');
INSERT INTO `district` VALUES ('2897', '比如', '425', 'b', 'br', 'biru', '', '县', '542423', '0896', '4');
INSERT INTO `district` VALUES ('2898', '聂荣', '425', 'n', 'nr', 'nierong', '', '县', '542424', '0896', '5');
INSERT INTO `district` VALUES ('2899', '安多', '425', 'a', 'ad', 'anduo', '', '县', '542425', '0896', '6');
INSERT INTO `district` VALUES ('2900', '申扎', '425', 's', 'sz', 'shenzha', '', '县', '542426', '0896', '7');
INSERT INTO `district` VALUES ('2901', '索县', '425', 's', 'sx', 'suoxian', '', '', '542427', '0896', '8');
INSERT INTO `district` VALUES ('2902', '班戈', '425', 'b', 'bg', 'bange', '', '县', '542428', '0896', '9');
INSERT INTO `district` VALUES ('2903', '巴青', '425', 'b', 'bq', 'baqing', '', '县', '542429', '0896', '10');
INSERT INTO `district` VALUES ('2904', '尼玛', '425', 'n', 'nm', 'nima', '', '县', '542430', '0896', '11');
INSERT INTO `district` VALUES ('2905', '普兰', '426', 'p', 'pl', 'pulan', '', '县', '542521', '0897', '1');
INSERT INTO `district` VALUES ('2906', '札达', '426', 'z', 'zd', 'zhada', '', '县', '542522', '0897', '2');
INSERT INTO `district` VALUES ('2907', '噶尔', '426', 'g', 'ge', 'gaer', '', '县', '542523', '0897', '3');
INSERT INTO `district` VALUES ('2908', '日土', '426', 'r', 'rt', 'ritu', '', '县', '542524', '0897', '4');
INSERT INTO `district` VALUES ('2909', '革吉', '426', 'g', 'gj', 'geji', '', '县', '542525', '0897', '5');
INSERT INTO `district` VALUES ('2910', '改则', '426', 'g', 'gz', 'gaize', '', '县', '542526', '0897', '6');
INSERT INTO `district` VALUES ('2911', '措勤', '426', 'c', 'cq', 'cuoqin', '', '县', '542527', '0897', '7');
INSERT INTO `district` VALUES ('2912', '巴宜', '427', 'b', 'by', 'bayi', '', '区', '540402', '0894', '1');
INSERT INTO `district` VALUES ('2913', '工布江达', '427', 'g', 'gbjd', 'gongbujiangda', '', '县', '542621', '0894', '2');
INSERT INTO `district` VALUES ('2914', '米林', '427', 'm', 'ml', 'milin', '', '县', '542621', '0894', '3');
INSERT INTO `district` VALUES ('2915', '墨脱', '427', 'm', 'mt', 'motuo', '', '县', '542621', '0894', '4');
INSERT INTO `district` VALUES ('2916', '波密', '427', 'b', 'bm', 'bomi', '', '县', '542621', '0894', '5');
INSERT INTO `district` VALUES ('2917', '察隅', '427', 'c', 'cy', 'chayu', '', '县', '542621', '0894', '6');
INSERT INTO `district` VALUES ('2918', '朗县', '427', 'l', 'lx', 'langxian', '', '', '542621', '0894', '7');
INSERT INTO `district` VALUES ('2919', '新城', '428', 'x', 'xc', 'xincheng', '', '区', '610102', '029', '1');
INSERT INTO `district` VALUES ('2920', '碑林', '428', 'b', 'bl', 'beilin', '', '区', '610103', '029', '2');
INSERT INTO `district` VALUES ('2921', '莲湖', '428', 'l', 'lh', 'lianhu', '', '区', '610104', '029', '3');
INSERT INTO `district` VALUES ('2922', '灞桥', '428', 'b', 'bq', 'baqiao', '', '区', '610111', '029', '4');
INSERT INTO `district` VALUES ('2923', '未央', '428', 'w', 'wy', 'weiyang', '', '区', '610112', '029', '5');
INSERT INTO `district` VALUES ('2924', '雁塔', '428', 'y', 'yt', 'yanta', '', '区', '610113', '029', '6');
INSERT INTO `district` VALUES ('2925', '阎良', '428', 'y', 'yl', 'yanliang', '', '区', '610114', '029', '7');
INSERT INTO `district` VALUES ('2926', '临潼', '428', 'l', 'lt', 'lintong', '', '区', '610115', '029', '8');
INSERT INTO `district` VALUES ('2927', '长安', '428', 'z', 'za', 'zhangan', '', '区', '610116', '029', '9');
INSERT INTO `district` VALUES ('2928', '蓝田', '428', 'l', 'lt', 'lantian', '', '县', '610122', '029', '11');
INSERT INTO `district` VALUES ('2929', '周至', '428', 'z', 'zz', 'zhouzhi', '', '县', '610124', '029', '12');
INSERT INTO `district` VALUES ('2930', '鄠邑', '428', 'h', 'hy', 'huyi', '', '区', '610125', '029', '13');
INSERT INTO `district` VALUES ('2931', '高陵', '428', 'g', 'gl', 'gaoling', '', '区', '610117', '029', '10');
INSERT INTO `district` VALUES ('2932', '王益', '429', 'w', 'wy', 'wangyi', '', '区', '610202', '0919', '1');
INSERT INTO `district` VALUES ('2933', '印台', '429', 'y', 'yt', 'yintai', '', '区', '610203', '0919', '2');
INSERT INTO `district` VALUES ('2934', '耀州', '429', 'y', 'yz', 'yaozhou', '', '区', '610204', '0919', '3');
INSERT INTO `district` VALUES ('2935', '宜君', '429', 'y', 'yj', 'yijun', '', '县', '610222', '0919', '4');
INSERT INTO `district` VALUES ('2936', '渭滨', '430', 'w', 'wb', 'weibin', '', '区', '610302', '0917', '1');
INSERT INTO `district` VALUES ('2937', '金台', '430', 'j', 'jt', 'jintai', '', '区', '610303', '0917', '2');
INSERT INTO `district` VALUES ('2938', '陈仓', '430', 'c', 'cc', 'chencang', '', '区', '610304', '0917', '3');
INSERT INTO `district` VALUES ('2939', '凤翔', '430', 'f', 'fx', 'fengxiang', '', '县', '610322', '0917', '4');
INSERT INTO `district` VALUES ('2940', '岐山', '430', 'q', 'qs', 'qishan', '', '县', '610323', '0917', '5');
INSERT INTO `district` VALUES ('2941', '扶风', '430', 'f', 'ff', 'fufeng', '', '县', '610324', '0917', '6');
INSERT INTO `district` VALUES ('2942', '眉县', '430', 'm', 'mx', 'meixian', '', '', '610326', '0917', '7');
INSERT INTO `district` VALUES ('2943', '陇县', '430', 'l', 'lx', 'longxian', '', '', '610327', '0917', '8');
INSERT INTO `district` VALUES ('2944', '千阳', '430', 'q', 'qy', 'qianyang', '', '县', '610328', '0917', '9');
INSERT INTO `district` VALUES ('2945', '麟游', '430', 'l', 'ly', 'linyou', '', '县', '610329', '0917', '10');
INSERT INTO `district` VALUES ('2946', '凤县', '430', 'f', 'fx', 'fengxian', '', '', '610330', '0917', '11');
INSERT INTO `district` VALUES ('2947', '太白', '430', 't', 'tb', 'taibai', '', '县', '610331', '0917', '12');
INSERT INTO `district` VALUES ('2948', '秦都', '431', 'q', 'qd', 'qindou', '', '区', '610402', '029', '1');
INSERT INTO `district` VALUES ('2949', '杨陵', '431', 'y', 'yl', 'yangling', '', '区', '610403', '029', '2');
INSERT INTO `district` VALUES ('2950', '渭城', '431', 'w', 'wc', 'weicheng', '', '区', '610404', '029', '3');
INSERT INTO `district` VALUES ('2951', '三原', '431', 's', 'sy', 'sanyuan', '', '县', '610422', '029', '4');
INSERT INTO `district` VALUES ('2952', '泾阳', '431', 'j', 'jy', 'jingyang', '', '县', '610423', '029', '5');
INSERT INTO `district` VALUES ('2953', '乾县', '431', 'q', 'qx', 'qianxian', '', '', '610424', '029', '6');
INSERT INTO `district` VALUES ('2954', '礼泉', '431', 'l', 'lq', 'liquan', '', '县', '610425', '029', '7');
INSERT INTO `district` VALUES ('2955', '永寿', '431', 'y', 'ys', 'yongshou', '', '县', '610426', '029', '8');
INSERT INTO `district` VALUES ('2956', '彬县', '431', 'b', 'bx', 'binxian', '', '', '610427', '029', '9');
INSERT INTO `district` VALUES ('2957', '长武', '431', 'z', 'zw', 'zhangwu', '', '县', '610428', '029', '10');
INSERT INTO `district` VALUES ('2958', '旬邑', '431', 'x', 'xy', 'xunyi', '', '县', '610429', '029', '11');
INSERT INTO `district` VALUES ('2959', '淳化', '431', 'c', 'ch', 'chunhua', '', '县', '610430', '029', '12');
INSERT INTO `district` VALUES ('2960', '武功', '431', 'w', 'wg', 'wugong', '', '县', '610431', '029', '13');
INSERT INTO `district` VALUES ('2961', '兴平', '431', 'x', 'xp', 'xingping', '', '市', '610481', '029', '14');
INSERT INTO `district` VALUES ('2962', '临渭', '432', 'l', 'lw', 'linwei', '', '区', '610502', '0913', '1');
INSERT INTO `district` VALUES ('2963', '华州', '432', 'h', 'hz', 'huazhou', '', '区', '610521', '0913', '2');
INSERT INTO `district` VALUES ('2964', '潼关', '432', 't', 'tg', 'tongguan', '', '县', '610522', '0913', '3');
INSERT INTO `district` VALUES ('2965', '大荔', '432', 'd', 'dl', 'dali', '', '县', '610523', '0913', '4');
INSERT INTO `district` VALUES ('2966', '合阳', '432', 'h', 'hy', 'heyang', '', '县', '610524', '0913', '5');
INSERT INTO `district` VALUES ('2967', '澄城', '432', 'c', 'cc', 'chengcheng', '', '县', '610525', '0913', '6');
INSERT INTO `district` VALUES ('2968', '蒲城', '432', 'p', 'pc', 'pucheng', '', '县', '610526', '0913', '7');
INSERT INTO `district` VALUES ('2969', '白水', '432', 'b', 'bs', 'baishui', '', '县', '610527', '0913', '8');
INSERT INTO `district` VALUES ('2970', '富平', '432', 'f', 'fp', 'fuping', '', '县', '610528', '0913', '9');
INSERT INTO `district` VALUES ('2971', '韩城', '432', 'h', 'hc', 'hancheng', '', '市', '610581', '0913', '10');
INSERT INTO `district` VALUES ('2972', '华阴', '432', 'h', 'hy', 'huayin', '', '市', '610582', '0913', '11');
INSERT INTO `district` VALUES ('2973', '宝塔', '433', 'b', 'bt', 'baota', '', '区', '610602', '0911', '1');
INSERT INTO `district` VALUES ('2974', '延长', '433', 'y', 'yz', 'yanzhang', '', '县', '610621', '0911', '2');
INSERT INTO `district` VALUES ('2975', '延川', '433', 'y', 'yc', 'yanchuan', '', '县', '610622', '0911', '3');
INSERT INTO `district` VALUES ('2976', '子长', '433', 'z', 'zz', 'zizhang', '', '县', '610623', '0911', '4');
INSERT INTO `district` VALUES ('2977', '安塞', '433', 'a', 'as', 'ansai', '', '区', '610624', '0911', '5');
INSERT INTO `district` VALUES ('2978', '志丹', '433', 'z', 'zd', 'zhidan', '', '县', '610625', '0911', '6');
INSERT INTO `district` VALUES ('2979', '吴起', '433', 'w', 'wq', 'wuqi', '', '县', '610626', '0911', '7');
INSERT INTO `district` VALUES ('2980', '甘泉', '433', 'g', 'gq', 'ganquan', '', '县', '610627', '0911', '8');
INSERT INTO `district` VALUES ('2981', '富县', '433', 'f', 'fx', 'fuxian', '', '', '610628', '0911', '9');
INSERT INTO `district` VALUES ('2982', '洛川', '433', 'l', 'lc', 'luochuan', '', '县', '610629', '0911', '10');
INSERT INTO `district` VALUES ('2983', '宜川', '433', 'y', 'yc', 'yichuan', '', '县', '610630', '0911', '11');
INSERT INTO `district` VALUES ('2984', '黄龙', '433', 'h', 'hl', 'huanglong', '', '县', '610631', '0911', '12');
INSERT INTO `district` VALUES ('2985', '黄陵', '433', 'h', 'hl', 'huangling', '', '县', '610632', '0911', '13');
INSERT INTO `district` VALUES ('2986', '汉台', '434', 'h', 'ht', 'hantai', '', '区', '610702', '0916', '1');
INSERT INTO `district` VALUES ('2987', '南郑', '434', 'n', 'nz', 'nanzheng', '', '县', '610721', '0916', '2');
INSERT INTO `district` VALUES ('2988', '城固', '434', 'c', 'cg', 'chenggu', '', '县', '610722', '0916', '3');
INSERT INTO `district` VALUES ('2989', '洋县', '434', 'y', 'yx', 'yangxian', '', '', '610723', '0916', '4');
INSERT INTO `district` VALUES ('2990', '西乡', '434', 'x', 'xx', 'xixiang', '', '县', '610724', '0916', '5');
INSERT INTO `district` VALUES ('2991', '勉县', '434', 'm', 'mx', 'mianxian', '', '', '610725', '0916', '6');
INSERT INTO `district` VALUES ('2992', '宁强', '434', 'n', 'nq', 'ningqiang', '', '县', '610726', '0916', '7');
INSERT INTO `district` VALUES ('2993', '略阳', '434', 'l', 'ly', 'lu:eyang', '', '县', '610727', '0916', '8');
INSERT INTO `district` VALUES ('2994', '镇巴', '434', 'z', 'zb', 'zhenba', '', '县', '610728', '0916', '9');
INSERT INTO `district` VALUES ('2995', '留坝', '434', 'l', 'lb', 'liuba', '', '县', '610729', '0916', '10');
INSERT INTO `district` VALUES ('2996', '佛坪', '434', 'f', 'fp', 'foping', '', '县', '610730', '0916', '11');
INSERT INTO `district` VALUES ('2997', '榆阳', '435', 'y', 'yy', 'yuyang', '', '区', '610802', '0912', '1');
INSERT INTO `district` VALUES ('2998', '神木', '435', 's', 'sm', 'shenmu', '', '县', '610821', '0912', '2');
INSERT INTO `district` VALUES ('2999', '府谷', '435', 'f', 'fg', 'fugu', '', '县', '610822', '0912', '3');
INSERT INTO `district` VALUES ('3000', '横山', '435', 'h', 'hs', 'hengshan', '', '区', '610823', '0912', '4');
INSERT INTO `district` VALUES ('3001', '靖边', '435', 'j', 'jb', 'jingbian', '', '县', '610824', '0912', '5');
INSERT INTO `district` VALUES ('3002', '定边', '435', 'd', 'db', 'dingbian', '', '县', '610825', '0912', '6');
INSERT INTO `district` VALUES ('3003', '绥德', '435', 's', 'sd', 'suide', '', '县', '610826', '0912', '7');
INSERT INTO `district` VALUES ('3004', '米脂', '435', 'm', 'mz', 'mizhi', '', '县', '610827', '0912', '8');
INSERT INTO `district` VALUES ('3005', '佳县', '435', 'j', 'jx', 'jiaxian', '', '', '610828', '0912', '9');
INSERT INTO `district` VALUES ('3006', '吴堡', '435', 'w', 'wb', 'wubao', '', '县', '610829', '0912', '10');
INSERT INTO `district` VALUES ('3007', '清涧', '435', 'q', 'qj', 'qingjian', '', '县', '610830', '0912', '11');
INSERT INTO `district` VALUES ('3008', '子洲', '435', 'z', 'zz', 'zizhou', '', '县', '610831', '0912', '12');
INSERT INTO `district` VALUES ('3009', '汉滨', '436', 'h', 'hb', 'hanbin', '', '区', '610902', '0915', '1');
INSERT INTO `district` VALUES ('3010', '汉阴', '436', 'h', 'hy', 'hanyin', '', '县', '610921', '0915', '2');
INSERT INTO `district` VALUES ('3011', '石泉', '436', 's', 'sq', 'shiquan', '', '县', '610922', '0915', '3');
INSERT INTO `district` VALUES ('3012', '宁陕', '436', 'n', 'ns', 'ningshan', '', '县', '610923', '0915', '4');
INSERT INTO `district` VALUES ('3013', '紫阳', '436', 'z', 'zy', 'ziyang', '', '县', '610924', '0915', '5');
INSERT INTO `district` VALUES ('3014', '岚皋', '436', 'l', 'lg', 'langao', '', '县', '610925', '0915', '6');
INSERT INTO `district` VALUES ('3015', '平利', '436', 'p', 'pl', 'pingli', '', '县', '610926', '0915', '7');
INSERT INTO `district` VALUES ('3016', '镇坪', '436', 'z', 'zp', 'zhenping', '', '县', '610927', '0915', '8');
INSERT INTO `district` VALUES ('3017', '旬阳', '436', 'x', 'xy', 'xunyang', '', '县', '610928', '0915', '9');
INSERT INTO `district` VALUES ('3018', '白河', '436', 'b', 'bh', 'baihe', '', '县', '610929', '0915', '10');
INSERT INTO `district` VALUES ('3019', '商州', '437', 's', 'sz', 'shangzhou', '', '区', '611002', '0914', '1');
INSERT INTO `district` VALUES ('3020', '洛南', '437', 'l', 'ln', 'luonan', '', '县', '611021', '0914', '2');
INSERT INTO `district` VALUES ('3021', '丹凤', '437', 'd', 'df', 'danfeng', '', '县', '611022', '0914', '3');
INSERT INTO `district` VALUES ('3022', '商南', '437', 's', 'sn', 'shangnan', '', '县', '611023', '0914', '4');
INSERT INTO `district` VALUES ('3023', '山阳', '437', 's', 'sy', 'shanyang', '', '县', '611024', '0914', '5');
INSERT INTO `district` VALUES ('3024', '镇安', '437', 'z', 'za', 'zhenan', '', '县', '611025', '0914', '6');
INSERT INTO `district` VALUES ('3025', '柞水', '437', 'z', 'zs', 'zuoshui', '', '县', '611026', '0914', '7');
INSERT INTO `district` VALUES ('3026', '城关', '438', 'c', 'cg', 'chengguan', '', '区', '620102', '0931', '1');
INSERT INTO `district` VALUES ('3027', '七里河', '438', 'q', 'qlh', 'qilihe', '', '区', '620103', '0931', '2');
INSERT INTO `district` VALUES ('3028', '西固', '438', 'x', 'xg', 'xigu', '', '区', '620104', '0931', '3');
INSERT INTO `district` VALUES ('3029', '安宁', '438', 'a', 'an', 'anning', '', '区', '620105', '0931', '4');
INSERT INTO `district` VALUES ('3030', '红古', '438', 'h', 'hg', 'honggu', '', '区', '620111', '0931', '5');
INSERT INTO `district` VALUES ('3031', '永登', '438', 'y', 'yd', 'yongdeng', '', '县', '620121', '0931', '6');
INSERT INTO `district` VALUES ('3032', '皋兰', '438', 'g', 'gl', 'gaolan', '', '县', '620122', '0931', '7');
INSERT INTO `district` VALUES ('3033', '榆中', '438', 'y', 'yz', 'yuzhong', '', '县', '620123', '0931', '8');
INSERT INTO `district` VALUES ('3034', '镜铁', '439', 'j', 'jt', 'jingtie', '', '区', '620201', '0937', '1');
INSERT INTO `district` VALUES ('3035', '长城', '439', 'z', 'zc', 'zhangcheng', '', '区', '620201', '0937', '2');
INSERT INTO `district` VALUES ('3036', '雄关', '439', 'x', 'xg', 'xiongguan', '', '区', '620201', '0937', '3');
INSERT INTO `district` VALUES ('3037', '金川', '440', 'j', 'jc', 'jinchuan', '', '区', '620302', '0935', '1');
INSERT INTO `district` VALUES ('3038', '永昌', '440', 'y', 'yc', 'yongchang', '', '县', '620321', '0935', '2');
INSERT INTO `district` VALUES ('3039', '白银', '441', 'b', 'by', 'baiyin', '', '区', '620402', '0943', '1');
INSERT INTO `district` VALUES ('3040', '平川', '441', 'p', 'pc', 'pingchuan', '', '区', '620403', '0943', '2');
INSERT INTO `district` VALUES ('3041', '靖远', '441', 'j', 'jy', 'jingyuan', '', '县', '620421', '0943', '3');
INSERT INTO `district` VALUES ('3042', '会宁', '441', 'h', 'hn', 'huining', '', '县', '620422', '0943', '4');
INSERT INTO `district` VALUES ('3043', '景泰', '441', 'j', 'jt', 'jingtai', '', '县', '620423', '0943', '5');
INSERT INTO `district` VALUES ('3044', '秦州', '442', 'q', 'qz', 'qinzhou', '', '区', '620502', '0938', '1');
INSERT INTO `district` VALUES ('3045', '麦积', '442', 'm', 'mj', 'maiji', '', '区', '620503', '0938', '2');
INSERT INTO `district` VALUES ('3046', '清水', '442', 'q', 'qs', 'qingshui', '', '县', '620521', '0938', '3');
INSERT INTO `district` VALUES ('3047', '秦安', '442', 'q', 'qa', 'qinan', '', '县', '620522', '0938', '4');
INSERT INTO `district` VALUES ('3048', '甘谷', '442', 'g', 'gg', 'gangu', '', '县', '620523', '0938', '5');
INSERT INTO `district` VALUES ('3049', '武山', '442', 'w', 'ws', 'wushan', '', '县', '620524', '0938', '6');
INSERT INTO `district` VALUES ('3050', '张家川', '442', 'z', 'zjc', 'zhangjiachuan', '回族', '自治县', '620525', '0938', '7');
INSERT INTO `district` VALUES ('3051', '凉州', '443', 'l', 'lz', 'liangzhou', '', '区', '620602', '0935', '1');
INSERT INTO `district` VALUES ('3052', '民勤', '443', 'm', 'mq', 'minqin', '', '县', '620621', '0935', '2');
INSERT INTO `district` VALUES ('3053', '古浪', '443', 'g', 'gl', 'gulang', '', '县', '620622', '0935', '3');
INSERT INTO `district` VALUES ('3054', '天祝', '443', 't', 'tz', 'tianzhu', '藏族', '自治县', '620623', '0935', '4');
INSERT INTO `district` VALUES ('3055', '甘州', '444', 'g', 'gz', 'ganzhou', '', '区', '620702', '0936', '1');
INSERT INTO `district` VALUES ('3056', '肃南', '444', 's', 'sn', 'sunan', '裕固族', '自治县', '620721', '0936', '2');
INSERT INTO `district` VALUES ('3057', '民乐', '444', 'm', 'ml', 'minle', '', '县', '620722', '0936', '3');
INSERT INTO `district` VALUES ('3058', '临泽', '444', 'l', 'lz', 'linze', '', '县', '620723', '0936', '4');
INSERT INTO `district` VALUES ('3059', '高台', '444', 'g', 'gt', 'gaotai', '', '县', '620724', '0936', '5');
INSERT INTO `district` VALUES ('3060', '山丹', '444', 's', 'sd', 'shandan', '', '县', '620725', '0936', '6');
INSERT INTO `district` VALUES ('3061', '崆峒', '445', 'k', 'kt', 'kongtong', '', '区', '620802', '0933', '1');
INSERT INTO `district` VALUES ('3062', '泾川', '445', 'j', 'jc', 'jingchuan', '', '县', '620821', '0933', '2');
INSERT INTO `district` VALUES ('3063', '灵台', '445', 'l', 'lt', 'lingtai', '', '县', '620822', '0933', '3');
INSERT INTO `district` VALUES ('3064', '崇信', '445', 'c', 'cx', 'chongxin', '', '县', '620823', '0933', '4');
INSERT INTO `district` VALUES ('3065', '华亭', '445', 'h', 'ht', 'huating', '', '县', '620824', '0933', '5');
INSERT INTO `district` VALUES ('3066', '庄浪', '445', 'z', 'zl', 'zhuanglang', '', '县', '620825', '0933', '6');
INSERT INTO `district` VALUES ('3067', '静宁', '445', 'j', 'jn', 'jingning', '', '县', '620826', '0933', '7');
INSERT INTO `district` VALUES ('3068', '肃州', '446', 's', 'sz', 'suzhou', '', '区', '620902', '0937', '1');
INSERT INTO `district` VALUES ('3069', '金塔', '446', 'j', 'jt', 'jinta', '', '县', '620921', '0937', '2');
INSERT INTO `district` VALUES ('3070', '瓜州', '446', 'g', 'gz', 'guazhou', '', '县', '620922', '0937', '3');
INSERT INTO `district` VALUES ('3071', '肃北', '446', 's', 'sb', 'subei', '蒙古族', '自治县', '620923', '0937', '4');
INSERT INTO `district` VALUES ('3072', '阿克塞', '446', 'a', 'aks', 'akesai', '哈萨克族', '自治县', '620924', '0937', '5');
INSERT INTO `district` VALUES ('3073', '玉门', '446', 'y', 'ym', 'yumen', '', '市', '620981', '0937', '6');
INSERT INTO `district` VALUES ('3074', '敦煌', '446', 'd', 'dh', 'dunhuang', '', '市', '620982', '0937', '7');
INSERT INTO `district` VALUES ('3075', '西峰', '447', 'x', 'xf', 'xifeng', '', '区', '621002', '0934', '1');
INSERT INTO `district` VALUES ('3076', '庆城', '447', 'q', 'qc', 'qingcheng', '', '县', '621021', '0934', '2');
INSERT INTO `district` VALUES ('3077', '环县', '447', 'h', 'hx', 'huanxian', '', '', '621022', '0934', '3');
INSERT INTO `district` VALUES ('3078', '华池', '447', 'h', 'hc', 'huachi', '', '县', '621023', '0934', '4');
INSERT INTO `district` VALUES ('3079', '合水', '447', 'h', 'hs', 'heshui', '', '县', '621024', '0934', '5');
INSERT INTO `district` VALUES ('3080', '正宁', '447', 'z', 'zn', 'zhengning', '', '县', '621025', '0934', '6');
INSERT INTO `district` VALUES ('3081', '宁县', '447', 'n', 'nx', 'ningxian', '', '', '621026', '0934', '7');
INSERT INTO `district` VALUES ('3082', '镇原', '447', 'z', 'zy', 'zhenyuan', '', '县', '621027', '0934', '8');
INSERT INTO `district` VALUES ('3083', '安定', '448', 'a', 'ad', 'anding', '', '区', '621102', '0932', '1');
INSERT INTO `district` VALUES ('3084', '通渭', '448', 't', 'tw', 'tongwei', '', '县', '621121', '0932', '2');
INSERT INTO `district` VALUES ('3085', '陇西', '448', 'l', 'lx', 'longxi', '', '县', '621122', '0932', '3');
INSERT INTO `district` VALUES ('3086', '渭源', '448', 'w', 'wy', 'weiyuan', '', '县', '621123', '0932', '4');
INSERT INTO `district` VALUES ('3087', '临洮', '448', 'l', 'lt', 'lintao', '', '县', '621124', '0932', '5');
INSERT INTO `district` VALUES ('3088', '漳县', '448', 'z', 'zx', 'zhangxian', '', '', '621125', '0932', '6');
INSERT INTO `district` VALUES ('3089', '岷县', '448', 'm', 'mx', 'minxian', '', '', '621126', '0932', '7');
INSERT INTO `district` VALUES ('3090', '武都', '449', 'w', 'wd', 'wudou', '', '区', '621202', '0939', '1');
INSERT INTO `district` VALUES ('3091', '成县', '449', 'c', 'cx', 'chengxian', '', '', '621221', '0939', '2');
INSERT INTO `district` VALUES ('3092', '文县', '449', 'w', 'wx', 'wenxian', '', '', '621222', '0939', '3');
INSERT INTO `district` VALUES ('3093', '宕昌', '449', 'd', 'dc', 'dangchang', '', '县', '621223', '0939', '4');
INSERT INTO `district` VALUES ('3094', '康县', '449', 'k', 'kx', 'kangxian', '', '', '621224', '0939', '5');
INSERT INTO `district` VALUES ('3095', '西和', '449', 'x', 'xh', 'xihe', '', '县', '621225', '0939', '6');
INSERT INTO `district` VALUES ('3096', '礼县', '449', 'l', 'lx', 'lixian', '', '', '621226', '0939', '7');
INSERT INTO `district` VALUES ('3097', '徽县', '449', 'h', 'hx', 'huixian', '', '', '621227', '0939', '8');
INSERT INTO `district` VALUES ('3098', '两当', '449', 'l', 'ld', 'liangdang', '', '县', '621228', '0939', '9');
INSERT INTO `district` VALUES ('3099', '临夏', '450', 'l', 'lx', 'linxia', '', '市', '622901', '0930', '1');
INSERT INTO `district` VALUES ('3100', '临夏', '450', 'l', 'lx', 'linxia', '', '县', '622921', '0930', '2');
INSERT INTO `district` VALUES ('3101', '康乐', '450', 'k', 'kl', 'kangle', '', '县', '622922', '0930', '3');
INSERT INTO `district` VALUES ('3102', '永靖', '450', 'y', 'yj', 'yongjing', '', '县', '622923', '0930', '4');
INSERT INTO `district` VALUES ('3103', '广河', '450', 'g', 'gh', 'guanghe', '', '县', '622924', '0930', '5');
INSERT INTO `district` VALUES ('3104', '和政', '450', 'h', 'hz', 'hezheng', '', '县', '622925', '0930', '6');
INSERT INTO `district` VALUES ('3105', '东乡族', '450', 'd', 'dxz', 'dongxiangzu', '', '自治县', '622926', '0930', '7');
INSERT INTO `district` VALUES ('3106', '积石山', '450', 'j', 'jss', 'jishishan', '保安族东乡族撒拉族', '自治县', '622927', '0930', '8');
INSERT INTO `district` VALUES ('3107', '合作', '451', 'h', 'hz', 'hezuo', '', '市', '623001', '0941', '1');
INSERT INTO `district` VALUES ('3108', '临潭', '451', 'l', 'lt', 'lintan', '', '县', '623021', '0941', '2');
INSERT INTO `district` VALUES ('3109', '卓尼', '451', 'z', 'zn', 'zhuoni', '', '县', '623022', '0941', '3');
INSERT INTO `district` VALUES ('3110', '舟曲', '451', 'z', 'zq', 'zhouqu', '', '县', '623023', '0941', '4');
INSERT INTO `district` VALUES ('3111', '迭部', '451', 'd', 'db', 'diebu', '', '县', '623024', '0941', '5');
INSERT INTO `district` VALUES ('3112', '玛曲', '451', 'm', 'mq', 'maqu', '', '县', '623025', '0941', '6');
INSERT INTO `district` VALUES ('3113', '碌曲', '451', 'l', 'lq', 'liuqu', '', '县', '623026', '0941', '7');
INSERT INTO `district` VALUES ('3114', '夏河', '451', 'x', 'xh', 'xiahe', '', '县', '623027', '0941', '8');
INSERT INTO `district` VALUES ('3115', '城东', '452', 'c', 'cd', 'chengdong', '', '区', '630102', '0971', '1');
INSERT INTO `district` VALUES ('3116', '城中', '452', 'c', 'cz', 'chengzhong', '', '区', '630103', '0971', '2');
INSERT INTO `district` VALUES ('3117', '城西', '452', 'c', 'cx', 'chengxi', '', '区', '630104', '0971', '3');
INSERT INTO `district` VALUES ('3118', '城北', '452', 'c', 'cb', 'chengbei', '', '区', '630105', '0971', '4');
INSERT INTO `district` VALUES ('3119', '大通', '452', 'd', 'dt', 'datong', '回族土族', '自治县', '630121', '0971', '5');
INSERT INTO `district` VALUES ('3120', '湟中', '452', 'h', 'hz', 'huangzhong', '', '县', '630122', '0971', '6');
INSERT INTO `district` VALUES ('3121', '湟源', '452', 'h', 'hy', 'huangyuan', '', '县', '630123', '0971', '7');
INSERT INTO `district` VALUES ('3122', '乐都', '453', 'l', 'ld', 'ledou', '', '区', '630202', '0972', '1');
INSERT INTO `district` VALUES ('3123', '平安', '453', 'p', 'pa', 'pingan', '', '区', '632121', '0972', '2');
INSERT INTO `district` VALUES ('3124', '民和', '453', 'm', 'mh', 'minhe', '回族土族', '自治县', '632122', '0972', '3');
INSERT INTO `district` VALUES ('3125', '互助', '453', 'h', 'hz', 'huzhu', '土族', '自治县', '632126', '0972', '4');
INSERT INTO `district` VALUES ('3126', '化隆', '453', 'h', 'hl', 'hualong', '回族', '自治县', '632127', '0972', '5');
INSERT INTO `district` VALUES ('3127', '循化', '453', 'x', 'xh', 'xunhua', '撒拉族', '自治县', '632128', '0972', '6');
INSERT INTO `district` VALUES ('3128', '门源', '454', 'm', 'my', 'menyuan', '回族', '自治县', '632221', '0970', '1');
INSERT INTO `district` VALUES ('3129', '祁连', '454', 'q', 'ql', 'qilian', '', '县', '632222', '0970', '2');
INSERT INTO `district` VALUES ('3130', '海晏', '454', 'h', 'hy', 'haiyan', '', '县', '632223', '0970', '3');
INSERT INTO `district` VALUES ('3131', '刚察', '454', 'g', 'gc', 'gangcha', '', '县', '632224', '0970', '4');
INSERT INTO `district` VALUES ('3132', '同仁', '455', 't', 'tr', 'tongren', '', '县', '632321', '0973', '1');
INSERT INTO `district` VALUES ('3133', '尖扎', '455', 'j', 'jz', 'jianzha', '', '县', '632322', '0973', '2');
INSERT INTO `district` VALUES ('3134', '泽库', '455', 'z', 'zk', 'zeku', '', '县', '632323', '0973', '3');
INSERT INTO `district` VALUES ('3135', '河南', '455', 'h', 'hn', 'henan', '蒙古族', '自治县', '632324', '0973', '4');
INSERT INTO `district` VALUES ('3136', '共和', '456', 'g', 'gh', 'gonghe', '', '县', '632521', '0974', '1');
INSERT INTO `district` VALUES ('3137', '同德', '456', 't', 'td', 'tongde', '', '县', '632522', '0974', '2');
INSERT INTO `district` VALUES ('3138', '贵德', '456', 'g', 'gd', 'guide', '', '县', '632523', '0974', '3');
INSERT INTO `district` VALUES ('3139', '兴海', '456', 'x', 'xh', 'xinghai', '', '县', '632524', '0974', '4');
INSERT INTO `district` VALUES ('3140', '贵南', '456', 'g', 'gn', 'guinan', '', '县', '632525', '0974', '5');
INSERT INTO `district` VALUES ('3141', '玛沁', '457', 'm', 'mq', 'maqin', '', '县', '632621', '0975', '1');
INSERT INTO `district` VALUES ('3142', '班玛', '457', 'b', 'bm', 'banma', '', '县', '632622', '0975', '2');
INSERT INTO `district` VALUES ('3143', '甘德', '457', 'g', 'gd', 'gande', '', '县', '632623', '0975', '3');
INSERT INTO `district` VALUES ('3144', '达日', '457', 'd', 'dr', 'dari', '', '县', '632624', '0975', '4');
INSERT INTO `district` VALUES ('3145', '久治', '457', 'j', 'jz', 'jiuzhi', '', '县', '632625', '0975', '5');
INSERT INTO `district` VALUES ('3146', '玛多', '457', 'm', 'md', 'maduo', '', '县', '632626', '0975', '6');
INSERT INTO `district` VALUES ('3147', '玉树', '458', 'y', 'ys', 'yushu', '', '市', '632721', '0976', '1');
INSERT INTO `district` VALUES ('3148', '杂多', '458', 'z', 'zd', 'zaduo', '', '县', '632722', '0976', '2');
INSERT INTO `district` VALUES ('3149', '治多', '458', 'z', 'zd', 'zhiduo', '', '县', '632724', '0976', '3');
INSERT INTO `district` VALUES ('3150', '囊谦', '458', 'n', 'nq', 'nangqian', '', '县', '632725', '0976', '4');
INSERT INTO `district` VALUES ('3151', '曲麻莱', '458', 'q', 'qml', 'qumalai', '', '县', '632726', '0976', '5');
INSERT INTO `district` VALUES ('3152', '大柴旦', '459', 'd', 'dcd', 'dachaidan', '', '行委', '', '0977', '1');
INSERT INTO `district` VALUES ('3153', '冷湖', '459', 'l', 'lh', 'lenghu', '', '行委', '', '0977', '2');
INSERT INTO `district` VALUES ('3154', '茫崖', '459', 'm', 'my', 'mangya', '', '行委', '', '0977', '3');
INSERT INTO `district` VALUES ('3155', '格尔木', '459', 'g', 'gem', 'geermu', '', '市', '632801', '0977', '4');
INSERT INTO `district` VALUES ('3156', '德令哈', '459', 'd', 'dlh', 'delingha', '', '市', '632802', '0977', '5');
INSERT INTO `district` VALUES ('3157', '乌兰', '459', 'w', 'wl', 'wulan', '', '县', '632821', '0977', '6');
INSERT INTO `district` VALUES ('3158', '都兰', '459', 'd', 'dl', 'doulan', '', '县', '632822', '0977', '7');
INSERT INTO `district` VALUES ('3159', '天峻', '459', 't', 'tj', 'tianjun', '', '县', '632823', '0977', '8');
INSERT INTO `district` VALUES ('3160', '兴庆', '460', 'x', 'xq', 'xingqing', '', '区', '640104', '0951', '1');
INSERT INTO `district` VALUES ('3161', '西夏', '460', 'x', 'xx', 'xixia', '', '区', '640105', '0951', '2');
INSERT INTO `district` VALUES ('3162', '金凤', '460', 'j', 'jf', 'jinfeng', '', '区', '640106', '0951', '3');
INSERT INTO `district` VALUES ('3163', '永宁', '460', 'y', 'yn', 'yongning', '', '县', '640121', '0951', '4');
INSERT INTO `district` VALUES ('3164', '贺兰', '460', 'h', 'hl', 'helan', '', '县', '640122', '0951', '5');
INSERT INTO `district` VALUES ('3165', '灵武', '460', 'l', 'lw', 'lingwu', '', '市', '640181', '0951', '6');
INSERT INTO `district` VALUES ('3166', '大武口', '461', 'd', 'dwk', 'dawukou', '', '区', '640202', '0952', '1');
INSERT INTO `district` VALUES ('3167', '惠农', '461', 'h', 'hn', 'huinong', '', '区', '640205', '0952', '2');
INSERT INTO `district` VALUES ('3168', '平罗', '461', 'p', 'pl', 'pingluo', '', '县', '640221', '0952', '3');
INSERT INTO `district` VALUES ('3169', '红寺堡', '462', 'h', 'hsb', 'hongsibao', '', '区', '', '0953', '1');
INSERT INTO `district` VALUES ('3170', '利通', '462', 'l', 'lt', 'litong', '', '区', '640302', '0953', '2');
INSERT INTO `district` VALUES ('3171', '盐池', '462', 'y', 'yc', 'yanchi', '', '县', '640323', '0953', '3');
INSERT INTO `district` VALUES ('3172', '同心', '462', 't', 'tx', 'tongxin', '', '县', '640324', '0953', '4');
INSERT INTO `district` VALUES ('3173', '青铜峡', '462', 'q', 'qtx', 'qingtongxia', '', '市', '640381', '0953', '5');
INSERT INTO `district` VALUES ('3174', '原州', '463', 'y', 'yz', 'yuanzhou', '', '区', '640402', '0954', '1');
INSERT INTO `district` VALUES ('3175', '西吉', '463', 'x', 'xj', 'xiji', '', '县', '640422', '0954', '2');
INSERT INTO `district` VALUES ('3176', '隆德', '463', 'l', 'ld', 'longde', '', '县', '640423', '0954', '3');
INSERT INTO `district` VALUES ('3177', '泾源', '463', 'j', 'jy', 'jingyuan', '', '县', '640424', '0954', '4');
INSERT INTO `district` VALUES ('3178', '彭阳', '463', 'p', 'py', 'pengyang', '', '县', '640425', '0954', '5');
INSERT INTO `district` VALUES ('3179', '沙坡头', '464', 's', 'spt', 'shapotou', '', '区', '640502', '', '1');
INSERT INTO `district` VALUES ('3180', '中宁', '464', 'z', 'zn', 'zhongning', '', '县', '640521', '', '2');
INSERT INTO `district` VALUES ('3181', '海原', '464', 'h', 'hy', 'haiyuan', '', '县', '640522', '', '3');
INSERT INTO `district` VALUES ('3182', '天山', '465', 't', 'ts', 'tianshan', '', '区', '650102', '0991', '1');
INSERT INTO `district` VALUES ('3183', '沙依巴克', '465', 's', 'sybk', 'shayibake', '', '区', '650103', '0991', '2');
INSERT INTO `district` VALUES ('3184', '新市', '465', 'x', 'xs', 'xinshi', '', '区', '650104', '0991', '3');
INSERT INTO `district` VALUES ('3185', '水磨沟', '465', 's', 'smg', 'shuimogou', '', '区', '650105', '0991', '4');
INSERT INTO `district` VALUES ('3186', '头屯河', '465', 't', 'tth', 'toutunhe', '', '区', '650106', '0991', '5');
INSERT INTO `district` VALUES ('3187', '达坂城', '465', 'd', 'dbc', 'dabancheng', '', '区', '650107', '0991', '6');
INSERT INTO `district` VALUES ('3188', '米东', '465', 'm', 'md', 'midong', '', '区', '650109', '0991', '7');
INSERT INTO `district` VALUES ('3189', '乌鲁木齐', '465', 'w', 'wlmq', 'wulumuqi', '', '县', '650121', '0991', '8');
INSERT INTO `district` VALUES ('3190', '独山子', '466', 'd', 'dsz', 'dushanzi', '', '区', '650202', '0990', '1');
INSERT INTO `district` VALUES ('3191', '克拉玛依', '466', 'k', 'klmy', 'kelamayi', '', '区', '650203', '0990', '2');
INSERT INTO `district` VALUES ('3192', '白碱滩', '466', 'b', 'bjt', 'baijiantan', '', '区', '650204', '0990', '3');
INSERT INTO `district` VALUES ('3193', '乌尔禾', '466', 'w', 'weh', 'wuerhe', '', '区', '650205', '0990', '4');
INSERT INTO `district` VALUES ('3194', '高昌', '467', 'g', 'gc', 'gaochang', '', '区', '652101', '0995', '1');
INSERT INTO `district` VALUES ('3195', '鄯善', '467', 's', 'ss', 'shanshan', '', '县', '652122', '0995', '2');
INSERT INTO `district` VALUES ('3196', '托克逊', '467', 't', 'tkx', 'tuokexun', '', '县', '652123', '0995', '3');
INSERT INTO `district` VALUES ('3197', '伊州', '468', 'y', 'yz', 'yizhou', '', '区', '652201', '0902', '1');
INSERT INTO `district` VALUES ('3198', '巴里坤', '468', 'b', 'blk', 'balikun', '哈萨克', '自治县', '652222', '0902', '2');
INSERT INTO `district` VALUES ('3199', '伊吾', '468', 'y', 'yw', 'yiwu', '', '县', '652223', '0902', '3');
INSERT INTO `district` VALUES ('3200', '昌吉', '469', 'c', 'cj', 'changji', '', '市', '652301', '0994', '1');
INSERT INTO `district` VALUES ('3201', '阜康', '469', 'f', 'fk', 'fukang', '', '市', '652302', '0994', '2');
INSERT INTO `district` VALUES ('3202', '呼图壁', '469', 'h', 'htb', 'hutubi', '', '县', '652323', '0994', '3');
INSERT INTO `district` VALUES ('3203', '玛纳斯', '469', 'm', 'mns', 'manasi', '', '县', '652324', '0994', '4');
INSERT INTO `district` VALUES ('3204', '奇台', '469', 'q', 'qt', 'qitai', '', '县', '652325', '0994', '5');
INSERT INTO `district` VALUES ('3205', '吉木萨尔', '469', 'j', 'jmse', 'jimusaer', '', '县', '652327', '0994', '6');
INSERT INTO `district` VALUES ('3206', '木垒', '469', 'm', 'ml', 'mulei', '哈萨克', '自治县', '652328', '0994', '7');
INSERT INTO `district` VALUES ('3207', '阿拉山口', '470', 'a', 'alsk', 'alashankou', '', '市', '', '0909', '1');
INSERT INTO `district` VALUES ('3208', '博乐', '470', 'b', 'bl', 'bole', '', '市', '652701', '0909', '2');
INSERT INTO `district` VALUES ('3209', '精河', '470', 'j', 'jh', 'jinghe', '', '县', '652722', '0909', '3');
INSERT INTO `district` VALUES ('3210', '温泉', '470', 'w', 'wq', 'wenquan', '', '县', '652723', '0909', '4');
INSERT INTO `district` VALUES ('3211', '库尔勒', '471', 'k', 'kel', 'kuerle', '', '市', '652801', '0996', '1');
INSERT INTO `district` VALUES ('3212', '轮台', '471', 'l', 'lt', 'luntai', '', '县', '652822', '0996', '2');
INSERT INTO `district` VALUES ('3213', '尉犁', '471', 'w', 'wl', 'weili', '', '县', '652823', '0996', '3');
INSERT INTO `district` VALUES ('3214', '若羌', '471', 'r', 'rq', 'ruoqiang', '', '县', '652824', '0996', '4');
INSERT INTO `district` VALUES ('3215', '且末', '471', 'q', 'qm', 'qiemo', '', '县', '652825', '0996', '5');
INSERT INTO `district` VALUES ('3216', '焉耆', '471', 'y', 'yq', 'yanqi', '回族', '自治县', '652826', '0996', '6');
INSERT INTO `district` VALUES ('3217', '和静', '471', 'h', 'hj', 'hejing', '', '县', '652827', '0996', '7');
INSERT INTO `district` VALUES ('3218', '和硕', '471', 'h', 'hs', 'heshuo', '', '县', '652828', '0996', '8');
INSERT INTO `district` VALUES ('3219', '博湖', '471', 'b', 'bh', 'bohu', '', '县', '652829', '0996', '9');
INSERT INTO `district` VALUES ('3220', '阿克苏', '472', 'a', 'aks', 'akesu', '', '市', '652901', '', '1');
INSERT INTO `district` VALUES ('3221', '温宿', '472', 'w', 'ws', 'wensu', '', '县', '652922', '', '2');
INSERT INTO `district` VALUES ('3222', '库车', '472', 'k', 'kc', 'kuche', '', '县', '652923', '', '3');
INSERT INTO `district` VALUES ('3223', '沙雅', '472', 's', 'sy', 'shaya', '', '县', '652924', '', '4');
INSERT INTO `district` VALUES ('3224', '新和', '472', 'x', 'xh', 'xinhe', '', '县', '652925', '', '5');
INSERT INTO `district` VALUES ('3225', '拜城', '472', 'b', 'bc', 'baicheng', '', '县', '652926', '', '6');
INSERT INTO `district` VALUES ('3226', '乌什', '472', 'w', 'ws', 'wushen', '', '县', '652927', '', '7');
INSERT INTO `district` VALUES ('3227', '阿瓦提', '472', 'a', 'awt', 'awati', '', '县', '652928', '', '8');
INSERT INTO `district` VALUES ('3228', '柯坪', '472', 'k', 'kp', 'keping', '', '县', '652929', '', '9');
INSERT INTO `district` VALUES ('3229', '阿图什', '473', 'a', 'ats', 'atushen', '', '市', '653001', '0908', '1');
INSERT INTO `district` VALUES ('3230', '阿克陶', '473', 'a', 'akt', 'aketao', '', '县', '653022', '0908', '2');
INSERT INTO `district` VALUES ('3231', '阿合奇', '473', 'a', 'ahq', 'aheqi', '', '县', '653023', '0997', '3');
INSERT INTO `district` VALUES ('3232', '乌恰', '473', 'w', 'wq', 'wuqia', '', '县', '653024', '0908', '4');
INSERT INTO `district` VALUES ('3233', '喀什', '474', 'k', 'ks', 'kashen', '', '市', '653101', '0998', '1');
INSERT INTO `district` VALUES ('3234', '疏附', '474', 's', 'sf', 'shufu', '', '县', '653121', '0998', '2');
INSERT INTO `district` VALUES ('3235', '疏勒', '474', 's', 'sl', 'shule', '', '县', '653122', '0998', '3');
INSERT INTO `district` VALUES ('3236', '英吉沙', '474', 'y', 'yjs', 'yingjisha', '', '县', '653123', '0998', '4');
INSERT INTO `district` VALUES ('3237', '泽普', '474', 'z', 'zp', 'zepu', '', '县', '653124', '0998', '5');
INSERT INTO `district` VALUES ('3238', '莎车', '474', 's', 'sc', 'shache', '', '县', '653125', '0998', '6');
INSERT INTO `district` VALUES ('3239', '叶城', '474', 'y', 'yc', 'yecheng', '', '县', '653126', '0998', '7');
INSERT INTO `district` VALUES ('3240', '麦盖提', '474', 'm', 'mgt', 'maigaiti', '', '县', '653127', '0998', '8');
INSERT INTO `district` VALUES ('3241', '岳普湖', '474', 'y', 'yph', 'yuepuhu', '', '县', '653128', '0998', '9');
INSERT INTO `district` VALUES ('3242', '伽师', '474', 'j', 'js', 'jiashi', '', '县', '653129', '0998', '10');
INSERT INTO `district` VALUES ('3243', '巴楚', '474', 'b', 'bc', 'bachu', '', '县', '653130', '0998', '11');
INSERT INTO `district` VALUES ('3244', '塔什库尔干', '474', 't', 'tskeg', 'tashenkuergan', '塔吉克', '自治县', '653131', '0998', '12');
INSERT INTO `district` VALUES ('3245', '和田', '475', 'h', 'ht', 'hetian', '', '市', '653201', '0903', '1');
INSERT INTO `district` VALUES ('3246', '和田', '475', 'h', 'ht', 'hetian', '', '县', '653221', '0903', '2');
INSERT INTO `district` VALUES ('3247', '墨玉', '475', 'm', 'my', 'moyu', '', '县', '653222', '0903', '3');
INSERT INTO `district` VALUES ('3248', '皮山', '475', 'p', 'ps', 'pishan', '', '县', '653223', '0903', '4');
INSERT INTO `district` VALUES ('3249', '洛浦', '475', 'l', 'lp', 'luopu', '', '县', '653224', '0903', '5');
INSERT INTO `district` VALUES ('3250', '策勒', '475', 'c', 'cl', 'cele', '', '县', '653225', '0903', '6');
INSERT INTO `district` VALUES ('3251', '于田', '475', 'y', 'yt', 'yutian', '', '县', '653226', '0903', '7');
INSERT INTO `district` VALUES ('3252', '民丰', '475', 'm', 'mf', 'minfeng', '', '县', '653227', '0903', '8');
INSERT INTO `district` VALUES ('3253', '伊宁', '476', 'y', 'yn', 'yining', '', '市', '654002', '0999', '1');
INSERT INTO `district` VALUES ('3254', '奎屯', '476', 'k', 'kt', 'kuitun', '', '市', '654003', '0999', '2');
INSERT INTO `district` VALUES ('3255', '伊宁', '476', 'y', 'yn', 'yining', '', '县', '654021', '0999', '4');
INSERT INTO `district` VALUES ('3256', '察布查尔锡伯', '476', 'c', 'cbcexb', 'chabuchaerxibo', '', '自治县', '654022', '0999', '5');
INSERT INTO `district` VALUES ('3257', '霍城', '476', 'h', 'hc', 'huocheng', '', '县', '654023', '0999', '6');
INSERT INTO `district` VALUES ('3258', '巩留', '476', 'g', 'gl', 'gongliu', '', '县', '654024', '0999', '7');
INSERT INTO `district` VALUES ('3259', '新源', '476', 'x', 'xy', 'xinyuan', '', '县', '654025', '0999', '8');
INSERT INTO `district` VALUES ('3260', '昭苏', '476', 'z', 'zs', 'zhaosu', '', '县', '654026', '0999', '9');
INSERT INTO `district` VALUES ('3261', '特克斯', '476', 't', 'tks', 'tekesi', '', '县', '654027', '0999', '10');
INSERT INTO `district` VALUES ('3262', '尼勒克', '476', 'n', 'nlk', 'nileke', '', '县', '654028', '0999', '11');
INSERT INTO `district` VALUES ('3263', '塔城', '477', 't', 'tc', 'tacheng', '', '市', '654201', '0901', '1');
INSERT INTO `district` VALUES ('3264', '乌苏', '477', 'w', 'ws', 'wusu', '', '市', '654202', '0901', '2');
INSERT INTO `district` VALUES ('3265', '额敏', '477', 'e', 'em', 'emin', '', '县', '654221', '0901', '3');
INSERT INTO `district` VALUES ('3266', '沙湾', '477', 's', 'sw', 'shawan', '', '县', '654223', '0901', '4');
INSERT INTO `district` VALUES ('3267', '托里', '477', 't', 'tl', 'tuoli', '', '县', '654224', '0901', '5');
INSERT INTO `district` VALUES ('3268', '裕民', '477', 'y', 'ym', 'yumin', '', '县', '654225', '0901', '6');
INSERT INTO `district` VALUES ('3269', '和布克赛尔', '477', 'h', 'hbkse', 'hebukesaier', '蒙古', '自治县', '654226', '0901', '7');
INSERT INTO `district` VALUES ('3270', '阿勒泰', '478', 'a', 'alt', 'aletai', '', '市', '654301', '0906', '1');
INSERT INTO `district` VALUES ('3271', '布尔津', '478', 'b', 'bej', 'buerjin', '', '县', '654321', '0906', '2');
INSERT INTO `district` VALUES ('3272', '富蕴', '478', 'f', 'fy', 'fuyun', '', '县', '654322', '0906', '3');
INSERT INTO `district` VALUES ('3273', '福海', '478', 'f', 'fh', 'fuhai', '', '县', '654323', '0906', '4');
INSERT INTO `district` VALUES ('3274', '哈巴河', '478', 'h', 'hbh', 'habahe', '', '县', '654324', '0906', '5');
INSERT INTO `district` VALUES ('3275', '青河', '478', 'q', 'qh', 'qinghe', '', '县', '654325', '0906', '6');
INSERT INTO `district` VALUES ('3276', '吉木乃', '478', 'j', 'jmn', 'jimunai', '', '县', '654326', '0906', '7');
INSERT INTO `district` VALUES ('3277', '松山', '485', 's', 'ss', 'songshan', '', '区', '6300100', '02', '1');
INSERT INTO `district` VALUES ('3278', '信义', '485', 'x', 'xy', 'xinyi', '', '区', '6300200', '02', '2');
INSERT INTO `district` VALUES ('3279', '大安', '485', 'd', 'da', 'daan', '', '区', '6300300', '02', '3');
INSERT INTO `district` VALUES ('3280', '中山', '485', 'z', 'zs', 'zhongshan', '', '区', '6300400', '02', '4');
INSERT INTO `district` VALUES ('3281', '中正', '485', 'z', 'zz', 'zhongzheng', '', '区', '6300500', '02', '5');
INSERT INTO `district` VALUES ('3282', '大同', '485', 'd', 'dt', 'datong', '', '区', '6300600', '02', '6');
INSERT INTO `district` VALUES ('3283', '万华', '485', 'w', 'wh', 'wanhua', '', '区', '6300700', '02', '7');
INSERT INTO `district` VALUES ('3284', '文山', '485', 'w', 'ws', 'wenshan', '', '区', '6300800', '02', '8');
INSERT INTO `district` VALUES ('3285', '南港', '485', 'n', 'ng', 'nangang', '', '区', '6300900', '02', '9');
INSERT INTO `district` VALUES ('3286', '内湖', '485', 'n', 'nh', 'neihu', '', '区', '6301000', '02', '10');
INSERT INTO `district` VALUES ('3287', '士林', '485', 's', 'sl', 'shilin', '', '区', '6301100', '02', '11');
INSERT INTO `district` VALUES ('3288', '北投', '485', 'b', 'bt', 'beitou', '', '区', '6301200', '02', '12');
INSERT INTO `district` VALUES ('3289', '盐埕', '486', 'y', 'yc', 'yancheng', '', '区', '6400100', '07', '1');
INSERT INTO `district` VALUES ('3290', '鼓山', '486', 'g', 'gs', 'gushan', '', '区', '6400200', '07', '2');
INSERT INTO `district` VALUES ('3291', '左营', '486', 'z', 'zy', 'zuoying', '', '区', '6400300', '07', '3');
INSERT INTO `district` VALUES ('3292', '楠梓', '486', 'n', 'nz', 'nanzi', '', '区', '6400400', '07', '4');
INSERT INTO `district` VALUES ('3293', '三民', '486', 's', 'sm', 'sanmin', '', '区', '6400500', '07', '5');
INSERT INTO `district` VALUES ('3294', '新兴', '486', 'x', 'xx', 'xinxing', '', '区', '6400600', '07', '6');
INSERT INTO `district` VALUES ('3295', '前金', '486', 'q', 'qj', 'qianjin', '', '区', '6400700', '07', '7');
INSERT INTO `district` VALUES ('3296', '苓雅', '486', 'l', 'ly', 'lingya', '', '区', '6400800', '07', '8');
INSERT INTO `district` VALUES ('3297', '前镇', '486', 'q', 'qz', 'qianzhen', '', '区', '6400900', '07', '9');
INSERT INTO `district` VALUES ('3298', '旗津', '486', 'q', 'qj', 'qijin', '', '区', '6401000', '07', '10');
INSERT INTO `district` VALUES ('3299', '小港', '486', 'x', 'xg', 'xiaogang', '', '区', '6401100', '07', '11');
INSERT INTO `district` VALUES ('3300', '中正', '487', 'z', 'zz', 'zhongzheng', '', '区', '1001701', '02', '1');
INSERT INTO `district` VALUES ('3301', '七堵', '487', 'q', 'qd', 'qidu', '', '区', '1001702', '02', '2');
INSERT INTO `district` VALUES ('3302', '暖暖', '487', 'n', 'nn', 'nuannuan', '', '区', '1001703', '02', '3');
INSERT INTO `district` VALUES ('3303', '仁爱', '487', 'r', 'ra', 'renai', '', '区', '1001704', '02', '4');
INSERT INTO `district` VALUES ('3304', '中山', '487', 'z', 'zs', 'zhongshan', '', '区', '1001705', '02', '5');
INSERT INTO `district` VALUES ('3305', '安乐', '487', 'a', 'al', 'anle', '', '区', '1001706', '02', '6');
INSERT INTO `district` VALUES ('3306', '信义', '487', 'x', 'xy', 'xinyi', '', '区', '1001707', '02', '7');
INSERT INTO `district` VALUES ('3307', '大安', '488', 'd', 'da', 'daan', '', '区', '', '04', '1');
INSERT INTO `district` VALUES ('3308', '神冈', '488', 's', 'sg', 'shengang', '', '区', '', '04', '2');
INSERT INTO `district` VALUES ('3309', '石冈', '488', 's', 'sg', 'shigang', '', '区', '', '04', '3');
INSERT INTO `district` VALUES ('3310', '东势', '488', 'd', 'ds', 'dongshi', '', '区', '', '04', '4');
INSERT INTO `district` VALUES ('3311', '新社', '488', 'x', 'xs', 'xinshe', '', '区', '', '04', '5');
INSERT INTO `district` VALUES ('3312', '和平', '488', 'h', 'hp', 'heping', '', '区', '', '04', '6');
INSERT INTO `district` VALUES ('3313', '大肚', '488', 'd', 'dd', 'dadu', '', '区', '', '04', '7');
INSERT INTO `district` VALUES ('3314', '沙鹿', '488', 's', 'sl', 'shalu', '', '区', '', '04', '8');
INSERT INTO `district` VALUES ('3315', '龙井', '488', 'l', 'lj', 'longjing', '', '区', '', '04', '9');
INSERT INTO `district` VALUES ('3316', '梧栖', '488', 'w', 'wq', 'wuqi', '', '区', '', '04', '10');
INSERT INTO `district` VALUES ('3317', '清水', '488', 'q', 'qs', 'qingshui', '', '区', '', '04', '11');
INSERT INTO `district` VALUES ('3318', '大甲', '488', 'd', 'dj', 'dajia', '', '区', '', '04', '12');
INSERT INTO `district` VALUES ('3319', '外埔', '488', 'w', 'wp', 'waipu', '', '区', '', '04', '13');
INSERT INTO `district` VALUES ('3320', '大雅', '488', 'd', 'dy', 'daya', '', '区', '', '04', '14');
INSERT INTO `district` VALUES ('3321', '潭子', '488', 't', 'tz', 'tanzi', '', '区', '', '04', '15');
INSERT INTO `district` VALUES ('3322', '后里', '488', 'h', 'hl', 'houli', '', '区', '', '04', '16');
INSERT INTO `district` VALUES ('3323', '丰原', '488', 'f', 'fy', 'fengyuan', '', '区', '', '04', '17');
INSERT INTO `district` VALUES ('3324', '乌日', '488', 'w', 'wr', 'wuri', '', '区', '', '04', '18');
INSERT INTO `district` VALUES ('3325', '雾峰', '488', 'w', 'wf', 'wufeng', '', '区', '', '04', '19');
INSERT INTO `district` VALUES ('3326', '大里', '488', 'd', 'dl', 'dali', '', '区', '', '04', '20');
INSERT INTO `district` VALUES ('3327', '太平', '488', 't', 'tp', 'taiping', '', '区', '', '04', '21');
INSERT INTO `district` VALUES ('3328', '中区', '488', 'z', 'zq', 'zhongqu', '', '', '1001901', '04', '22');
INSERT INTO `district` VALUES ('3329', '东区', '488', 'd', 'dq', 'dongqu', '', '', '1001902', '04', '23');
INSERT INTO `district` VALUES ('3330', '南区', '488', 'n', 'nq', 'nanqu', '', '', '1001903', '04', '24');
INSERT INTO `district` VALUES ('3331', '西区', '488', 'x', 'xq', 'xiqu', '', '', '1001904', '04', '25');
INSERT INTO `district` VALUES ('3332', '北区', '488', 'b', 'bq', 'beiqu', '', '', '1001905', '04', '26');
INSERT INTO `district` VALUES ('3333', '西屯', '488', 'x', 'xt', 'xitun', '', '区', '1001906', '04', '27');
INSERT INTO `district` VALUES ('3334', '南屯', '488', 'n', 'nt', 'nantun', '', '区', '1001907', '04', '28');
INSERT INTO `district` VALUES ('3335', '北屯', '488', 'b', 'bt', 'beitun', '', '区', '1001908', '04', '29');
INSERT INTO `district` VALUES ('3336', '东区', '489', 'd', 'dq', 'dongqu', '', '', '1002101', '06', '1');
INSERT INTO `district` VALUES ('3337', '南区', '489', 'n', 'nq', 'nanqu', '', '', '1002102', '06', '2');
INSERT INTO `district` VALUES ('3338', '北区', '489', 'b', 'bq', 'beiqu', '', '', '1002104', '06', '3');
INSERT INTO `district` VALUES ('3339', '安南', '489', 'a', 'an', 'annan', '', '区', '1002106', '06', '4');
INSERT INTO `district` VALUES ('3340', '安平', '489', 'a', 'ap', 'anping', '', '区', '1002107', '06', '5');
INSERT INTO `district` VALUES ('3341', '中西', '489', 'z', 'zx', 'zhongxi', '', '区', '1002108', '06', '6');
INSERT INTO `district` VALUES ('3342', '东区', '490', 'd', 'dq', 'dongqu', '', '', '1001801', '', '1');
INSERT INTO `district` VALUES ('3343', '北区', '490', 'b', 'bq', 'beiqu', '', '', '1001802', '', '2');
INSERT INTO `district` VALUES ('3344', '香山', '490', 'x', 'xs', 'xiangshan', '', '区', '1001803', '', '3');
INSERT INTO `district` VALUES ('3345', '东区', '491', 'd', 'dq', 'dongqu', '', '', '1002001', '05', '1');
INSERT INTO `district` VALUES ('3346', '西区', '491', 'x', 'xq', 'xiqu', '', '', '1002002', '05', '2');
INSERT INTO `district` VALUES ('3347', '板桥', '492', 'b', 'bq', 'banqiao', '', '区', '', '', '1');
INSERT INTO `district` VALUES ('3348', '瑞芳', '492', 'r', 'rf', 'ruifang', '', '区', '', '', '2');
INSERT INTO `district` VALUES ('3349', '八里', '492', 'b', 'bl', 'bali', '', '区', '', '', '3');
INSERT INTO `district` VALUES ('3350', '深坑', '492', 's', 'sk', 'shenkeng', '', '区', '', '', '4');
INSERT INTO `district` VALUES ('3351', '三芝', '492', 's', 'sz', 'sanzhi', '', '区', '', '', '5');
INSERT INTO `district` VALUES ('3352', '金山', '492', 'j', 'js', 'jinshan', '', '区', '', '', '6');
INSERT INTO `district` VALUES ('3353', '万里', '492', 'w', 'wl', 'wanli', '', '区', '', '', '7');
INSERT INTO `district` VALUES ('3354', '贡寮', '492', 'g', 'gl', 'gongliao', '', '区', '', '', '8');
INSERT INTO `district` VALUES ('3355', '石门', '492', 's', 'sm', 'shimen', '', '区', '', '', '9');
INSERT INTO `district` VALUES ('3356', '双溪', '492', 's', 'sx', 'shuangxi', '', '区', '', '', '10');
INSERT INTO `district` VALUES ('3357', '石碇', '492', 's', 'sd', 'shiding', '', '区', '', '', '11');
INSERT INTO `district` VALUES ('3358', '坪林', '492', 'p', 'pl', 'pinglin', '', '区', '', '', '12');
INSERT INTO `district` VALUES ('3359', '乌来', '492', 'w', 'wl', 'wulai', '', '区', '', '', '13');
INSERT INTO `district` VALUES ('3360', '泰山', '492', 't', 'ts', 'taishan', '', '区', '', '', '14');
INSERT INTO `district` VALUES ('3361', '五股', '492', 'w', 'wg', 'wugu', '', '区', '', '', '15');
INSERT INTO `district` VALUES ('3362', '莺歌', '492', 'y', 'yg', 'yingge', '', '区', '', '', '16');
INSERT INTO `district` VALUES ('3363', '中和', '492', 'z', 'zh', 'zhonghe', '', '区', '', '', '17');
INSERT INTO `district` VALUES ('3364', '新庄', '492', 'x', 'xz', 'xinzhuang', '', '区', '', '', '18');
INSERT INTO `district` VALUES ('3365', '三重', '492', 's', 'sz', 'sanzhong', '', '区', '', '', '19');
INSERT INTO `district` VALUES ('3366', '新店', '492', 'x', 'xd', 'xindian', '', '区', '', '', '20');
INSERT INTO `district` VALUES ('3367', '土城', '492', 't', 'tc', 'tucheng', '', '区', '', '', '21');
INSERT INTO `district` VALUES ('3368', '永和', '492', 'y', 'yh', 'yonghe', '', '区', '', '', '22');
INSERT INTO `district` VALUES ('3369', '芦洲', '492', 'l', 'lz', 'luzhou', '', '区', '', '', '23');
INSERT INTO `district` VALUES ('3370', '汐止', '492', 'x', 'xz', 'xizhi', '', '区', '', '', '24');
INSERT INTO `district` VALUES ('3371', '树林', '492', 's', 'sl', 'shulin', '', '区', '', '', '25');
INSERT INTO `district` VALUES ('3372', '淡水', '492', 'd', 'ds', 'danshui', '', '区', '', '', '26');
INSERT INTO `district` VALUES ('3373', '三峡', '492', 's', 'sx', 'sanxia', '', '区', '', '', '27');
INSERT INTO `district` VALUES ('3374', '林口', '492', 'l', 'lk', 'linkou', '', '区', '', '', '28');
INSERT INTO `district` VALUES ('3375', '平溪', '492', 'p', 'px', 'pingxi', '', '区', '', '', '29');
INSERT INTO `district` VALUES ('3376', '宜兰', '493', 'y', 'yl', 'yilan', '', '市', '1000201', '', '1');
INSERT INTO `district` VALUES ('3377', '罗东', '493', 'l', 'ld', 'luodong', '', '镇', '1000202', '', '2');
INSERT INTO `district` VALUES ('3378', '苏澳', '493', 's', 'sa', 'suao', '', '镇', '1000203', '', '3');
INSERT INTO `district` VALUES ('3379', '头城', '493', 't', 'tc', 'toucheng', '', '乡', '1000204', '', '4');
INSERT INTO `district` VALUES ('3380', '礁溪', '493', 'j', 'jx', 'jiaoxi', '', '乡', '1000205', '', '5');
INSERT INTO `district` VALUES ('3381', '壮围', '493', 'z', 'zw', 'zhuangwei', '', '乡', '1000206', '', '6');
INSERT INTO `district` VALUES ('3382', '员山', '493', 'y', 'ys', 'yuanshan', '', '乡', '1000207', '', '7');
INSERT INTO `district` VALUES ('3383', '冬山', '493', 'd', 'ds', 'dongshan', '', '乡', '1000208', '', '8');
INSERT INTO `district` VALUES ('3384', '五结', '493', 'w', 'wj', 'wujie', '', '乡', '1000209', '', '9');
INSERT INTO `district` VALUES ('3385', '三星', '493', 's', 'sx', 'sanxing', '', '乡', '1000210', '', '10');
INSERT INTO `district` VALUES ('3386', '大同', '493', 'd', 'dt', 'datong', '', '乡', '1000211', '', '11');
INSERT INTO `district` VALUES ('3387', '南澳', '493', 'n', 'na', 'nanao', '', '乡', '1000212', '', '12');
INSERT INTO `district` VALUES ('3388', '桃园', '494', 't', 'ty', 'taoyuan', '', '市', '1000301', '', '1');
INSERT INTO `district` VALUES ('3389', '中坜', '494', 'z', 'zl', 'zhongli', '', '市', '1000302', '', '2');
INSERT INTO `district` VALUES ('3390', '大溪', '494', 'd', 'dx', 'daxi', '', '镇', '1000303', '', '3');
INSERT INTO `district` VALUES ('3391', '杨梅', '494', 'y', 'ym', 'yangmei', '', '镇', '1000304', '', '4');
INSERT INTO `district` VALUES ('3392', '芦竹', '494', 'l', 'lz', 'luzhu', '', '乡', '1000305', '', '5');
INSERT INTO `district` VALUES ('3393', '大园', '494', 'd', 'dy', 'dayuan', '', '乡', '1000306', '', '6');
INSERT INTO `district` VALUES ('3394', '龟山', '494', 'g', 'gs', 'guishan', '', '乡', '1000307', '', '7');
INSERT INTO `district` VALUES ('3395', '八德', '494', 'b', 'bd', 'bade', '', '市', '1000308', '', '8');
INSERT INTO `district` VALUES ('3396', '龙潭', '494', 'l', 'lt', 'longtan', '', '乡', '1000309', '', '9');
INSERT INTO `district` VALUES ('3397', '平镇', '494', 'p', 'pz', 'pingzhen', '', '市', '1000310', '', '10');
INSERT INTO `district` VALUES ('3398', '新屋', '494', 'x', 'xw', 'xinwu', '', '乡', '1000311', '', '11');
INSERT INTO `district` VALUES ('3399', '观音', '494', 'g', 'gy', 'guanyin', '', '乡', '1000312', '', '12');
INSERT INTO `district` VALUES ('3400', '复兴', '494', 'f', 'fx', 'fuxing', '', '乡', '1000313', '', '13');
INSERT INTO `district` VALUES ('3401', '竹北', '495', 'z', 'zb', 'zhubei', '', '市', '1000401', '', '1');
INSERT INTO `district` VALUES ('3402', '竹东', '495', 'z', 'zd', 'zhudong', '', '镇', '1000402', '', '2');
INSERT INTO `district` VALUES ('3403', '新埔', '495', 'x', 'xp', 'xinpu', '', '镇', '1000403', '', '3');
INSERT INTO `district` VALUES ('3404', '关西', '495', 'g', 'gx', 'guanxi', '', '镇', '1000404', '', '4');
INSERT INTO `district` VALUES ('3405', '湖口', '495', 'h', 'hk', 'hukou', '', '乡', '1000405', '', '5');
INSERT INTO `district` VALUES ('3406', '新丰', '495', 'x', 'xf', 'xinfeng', '', '乡', '1000406', '', '6');
INSERT INTO `district` VALUES ('3407', '芎林', '495', 'x', 'xl', 'xionglin', '', '乡', '1000407', '', '7');
INSERT INTO `district` VALUES ('3408', '横山', '495', 'h', 'hs', 'hengshan', '', '乡', '1000408', '', '8');
INSERT INTO `district` VALUES ('3409', '北埔', '495', 'b', 'bp', 'beipu', '', '乡', '1000409', '', '9');
INSERT INTO `district` VALUES ('3410', '宝山', '495', 'b', 'bs', 'baoshan', '', '乡', '1000410', '', '10');
INSERT INTO `district` VALUES ('3411', '峨眉', '495', 'e', 'em', 'emei', '', '乡', '1000411', '', '11');
INSERT INTO `district` VALUES ('3412', '尖石', '495', 'j', 'js', 'jianshi', '', '乡', '1000412', '', '12');
INSERT INTO `district` VALUES ('3413', '五峰', '495', 'w', 'wf', 'wufeng', '', '乡', '1000413', '', '13');
INSERT INTO `district` VALUES ('3414', '苗栗', '496', 'm', 'ml', 'miaoli', '', '市', '1000501', '', '1');
INSERT INTO `district` VALUES ('3415', '苑里', '496', 'y', 'yl', 'yuanli', '', '镇', '1000502', '', '2');
INSERT INTO `district` VALUES ('3416', '通霄', '496', 't', 'tx', 'tongxiao', '', '镇', '1000503', '', '3');
INSERT INTO `district` VALUES ('3417', '竹南', '496', 'z', 'zn', 'zhunan', '', '镇', '1000504', '', '4');
INSERT INTO `district` VALUES ('3418', '头份', '496', 't', 'tf', 'toufen', '', '镇', '1000505', '', '5');
INSERT INTO `district` VALUES ('3419', '后龙', '496', 'h', 'hl', 'houlong', '', '镇', '1000506', '', '6');
INSERT INTO `district` VALUES ('3420', '卓兰', '496', 'z', 'zl', 'zhuolan', '', '镇', '1000507', '', '7');
INSERT INTO `district` VALUES ('3421', '大湖', '496', 'd', 'dh', 'dahu', '', '乡', '1000508', '', '8');
INSERT INTO `district` VALUES ('3422', '公馆', '496', 'g', 'gg', 'gongguan', '', '乡', '1000509', '', '9');
INSERT INTO `district` VALUES ('3423', '铜锣', '496', 't', 'tl', 'tongluo', '', '乡', '1000510', '', '10');
INSERT INTO `district` VALUES ('3424', '南庄', '496', 'n', 'nz', 'nanzhuang', '', '乡', '1000511', '', '11');
INSERT INTO `district` VALUES ('3425', '头屋', '496', 't', 'tw', 'touwu', '', '乡', '1000512', '', '12');
INSERT INTO `district` VALUES ('3426', '三义', '496', 's', 'sy', 'sanyi', '', '乡', '1000513', '', '13');
INSERT INTO `district` VALUES ('3427', '西湖', '496', 'x', 'xh', 'xihu', '', '乡', '1000514', '', '14');
INSERT INTO `district` VALUES ('3428', '造桥', '496', 'z', 'zq', 'zaoqiao', '', '乡', '1000515', '', '15');
INSERT INTO `district` VALUES ('3429', '三湾', '496', 's', 'sw', 'sanwan', '', '乡', '1000516', '', '16');
INSERT INTO `district` VALUES ('3430', '狮潭', '496', 's', 'st', 'shitan', '', '乡', '1000517', '', '17');
INSERT INTO `district` VALUES ('3431', '泰安', '496', 't', 'ta', 'taian', '', '乡', '1000518', '', '18');
INSERT INTO `district` VALUES ('3432', '彰化', '497', 'z', 'zh', 'zhanghua', '', '市', '1000701', '', '1');
INSERT INTO `district` VALUES ('3433', '鹿港', '497', 'l', 'lg', 'lugang', '', '镇', '1000702', '', '2');
INSERT INTO `district` VALUES ('3434', '和美', '497', 'h', 'hm', 'hemei', '', '镇', '1000703', '', '3');
INSERT INTO `district` VALUES ('3435', '线西', '497', 'x', 'xx', 'xianxi', '', '乡', '1000704', '', '4');
INSERT INTO `district` VALUES ('3436', '伸港', '497', 's', 'sg', 'shengang', '', '乡', '1000705', '', '5');
INSERT INTO `district` VALUES ('3437', '福兴', '497', 'f', 'fx', 'fuxing', '', '乡', '1000706', '', '6');
INSERT INTO `district` VALUES ('3438', '秀水', '497', 'x', 'xs', 'xiushui', '', '乡', '1000707', '', '7');
INSERT INTO `district` VALUES ('3439', '花坛', '497', 'h', 'ht', 'huatan', '', '乡', '1000708', '', '8');
INSERT INTO `district` VALUES ('3440', '芬园', '497', 'f', 'fy', 'fenyuan', '', '乡', '1000709', '', '9');
INSERT INTO `district` VALUES ('3441', '员林', '497', 'y', 'yl', 'yuanlin', '', '镇', '1000710', '', '10');
INSERT INTO `district` VALUES ('3442', '溪湖', '497', 'x', 'xh', 'xihu', '', '镇', '1000711', '', '11');
INSERT INTO `district` VALUES ('3443', '田中', '497', 't', 'tz', 'tianzhong', '', '镇', '1000712', '', '12');
INSERT INTO `district` VALUES ('3444', '大村', '497', 'd', 'dc', 'dacun', '', '乡', '1000713', '', '13');
INSERT INTO `district` VALUES ('3445', '埔盐', '497', 'p', 'py', 'puyan', '', '乡', '1000714', '', '14');
INSERT INTO `district` VALUES ('3446', '埔心', '497', 'p', 'px', 'puxin', '', '乡', '1000715', '', '15');
INSERT INTO `district` VALUES ('3447', '永靖', '497', 'y', 'yj', 'yongjing', '', '乡', '1000716', '', '16');
INSERT INTO `district` VALUES ('3448', '社头', '497', 's', 'st', 'shetou', '', '乡', '1000717', '', '17');
INSERT INTO `district` VALUES ('3449', '二水', '497', 'e', 'es', 'ershui', '', '乡', '1000718', '', '18');
INSERT INTO `district` VALUES ('3450', '北斗', '497', 'b', 'bd', 'beidou', '', '镇', '1000719', '', '19');
INSERT INTO `district` VALUES ('3451', '二林', '497', 'e', 'el', 'erlin', '', '镇', '1000720', '', '20');
INSERT INTO `district` VALUES ('3452', '田尾', '497', 't', 'tw', 'tianwei', '', '乡', '1000721', '', '21');
INSERT INTO `district` VALUES ('3453', '埤头', '497', 'p', 'pt', 'pitou', '', '乡', '1000722', '', '22');
INSERT INTO `district` VALUES ('3454', '芳苑', '497', 'f', 'fy', 'fangyuan', '', '乡', '1000723', '', '23');
INSERT INTO `district` VALUES ('3455', '大城', '497', 'd', 'dc', 'dacheng', '', '乡', '1000724', '', '24');
INSERT INTO `district` VALUES ('3456', '竹塘', '497', 'z', 'zt', 'zhutang', '', '乡', '1000725', '', '25');
INSERT INTO `district` VALUES ('3457', '溪州', '497', 'x', 'xz', 'xizhou', '', '乡', '1000726', '', '26');
INSERT INTO `district` VALUES ('3458', '南投', '498', 'n', 'nt', 'nantou', '', '市', '1000801', '', '1');
INSERT INTO `district` VALUES ('3459', '南投', '498', 'n', 'nt', 'nantou', '', '镇', '1000802', '', '2');
INSERT INTO `district` VALUES ('3460', '草屯', '498', 'c', 'ct', 'caotun', '', '镇', '1000803', '', '3');
INSERT INTO `district` VALUES ('3461', '竹山', '498', 'z', 'zs', 'zhushan', '', '镇', '1000804', '', '4');
INSERT INTO `district` VALUES ('3462', '集集', '498', 'j', 'jj', 'jiji', '', '镇', '1000805', '', '5');
INSERT INTO `district` VALUES ('3463', '名间', '498', 'm', 'mj', 'mingjian', '', '乡', '1000806', '', '6');
INSERT INTO `district` VALUES ('3464', '鹿谷', '498', 'l', 'lg', 'lugu', '', '乡', '1000807', '', '7');
INSERT INTO `district` VALUES ('3465', '中寮', '498', 'z', 'zl', 'zhongliao', '', '乡', '1000808', '', '8');
INSERT INTO `district` VALUES ('3466', '鱼池', '498', 'y', 'yc', 'yuchi', '', '乡', '1000809', '', '9');
INSERT INTO `district` VALUES ('3467', '国姓', '498', 'g', 'gx', 'guoxing', '', '乡', '1000810', '', '10');
INSERT INTO `district` VALUES ('3468', '水里', '498', 's', 'sl', 'shuili', '', '乡', '1000811', '', '11');
INSERT INTO `district` VALUES ('3469', '信义', '498', 'x', 'xy', 'xinyi', '', '乡', '1000812', '', '12');
INSERT INTO `district` VALUES ('3470', '仁爱', '498', 'r', 'ra', 'renai', '', '乡', '1000813', '', '13');
INSERT INTO `district` VALUES ('3471', '斗六', '499', 'd', 'dl', 'douliu', '', '市', '1000901', '', '1');
INSERT INTO `district` VALUES ('3472', '斗南', '499', 'd', 'dn', 'dounan', '', '镇', '1000902', '', '2');
INSERT INTO `district` VALUES ('3473', '虎尾', '499', 'h', 'hw', 'huwei', '', '镇', '1000903', '', '3');
INSERT INTO `district` VALUES ('3474', '西螺', '499', 'x', 'xl', 'xiluo', '', '镇', '1000904', '', '4');
INSERT INTO `district` VALUES ('3475', '土库', '499', 't', 'tk', 'tuku', '', '镇', '1000905', '', '5');
INSERT INTO `district` VALUES ('3476', '北港', '499', 'b', 'bg', 'beigang', '', '镇', '1000906', '', '6');
INSERT INTO `district` VALUES ('3477', '古坑', '499', 'g', 'gk', 'gukeng', '', '乡', '1000907', '', '7');
INSERT INTO `district` VALUES ('3478', '大埤', '499', 'd', 'dp', 'dapi', '', '乡', '1000908', '', '8');
INSERT INTO `district` VALUES ('3479', '莿桐', '499', 'c', 'ct', 'citong', '', '乡', '1000909', '', '9');
INSERT INTO `district` VALUES ('3480', '林内', '499', 'l', 'ln', 'linnei', '', '乡', '1000910', '', '10');
INSERT INTO `district` VALUES ('3481', '二仑', '499', 'e', 'el', 'erlun', '', '乡', '1000911', '', '11');
INSERT INTO `district` VALUES ('3482', '仑背', '499', 'l', 'lb', 'lunbei', '', '乡', '1000912', '', '12');
INSERT INTO `district` VALUES ('3483', '麦寮', '499', 'm', 'ml', 'mailiao', '', '乡', '1000913', '', '13');
INSERT INTO `district` VALUES ('3484', '东势', '499', 'd', 'ds', 'dongshi', '', '乡', '1000914', '', '14');
INSERT INTO `district` VALUES ('3485', '褒忠', '499', 'b', 'bz', 'baozhong', '', '乡', '1000915', '', '15');
INSERT INTO `district` VALUES ('3486', '台西', '499', 't', 'tx', 'taixi', '', '乡', '1000916', '', '16');
INSERT INTO `district` VALUES ('3487', '元长', '499', 'y', 'yz', 'yuanzhang', '', '乡', '1000917', '', '17');
INSERT INTO `district` VALUES ('3488', '四湖', '499', 's', 'sh', 'sihu', '', '乡', '1000918', '', '18');
INSERT INTO `district` VALUES ('3489', '口湖', '499', 'k', 'kh', 'kouhu', '', '乡', '1000919', '', '19');
INSERT INTO `district` VALUES ('3490', '水林', '499', 's', 'sl', 'shuilin', '', '乡', '1000920', '', '20');
INSERT INTO `district` VALUES ('3491', '太保', '500', 't', 'tb', 'taibao', '', '市', '', '', '1');
INSERT INTO `district` VALUES ('3492', '朴子', '500', 'p', 'pz', 'pozi', '', '市', '', '', '2');
INSERT INTO `district` VALUES ('3493', '布袋', '500', 'b', 'bd', 'budai', '', '镇', '', '', '3');
INSERT INTO `district` VALUES ('3494', '大林', '500', 'd', 'dl', 'dalin', '', '镇', '10010', '', '4');
INSERT INTO `district` VALUES ('3495', '民雄', '500', 'm', 'mx', 'minxiong', '', '乡', '1001001', '', '5');
INSERT INTO `district` VALUES ('3496', '溪口', '500', 'x', 'xk', 'xikou', '', '乡', '1001002', '', '6');
INSERT INTO `district` VALUES ('3497', '新港', '500', 'x', 'xg', 'xingang', '', '乡', '1001003', '', '7');
INSERT INTO `district` VALUES ('3498', '六脚', '500', 'l', 'lj', 'liujiao', '', '乡', '1001004', '', '8');
INSERT INTO `district` VALUES ('3499', '东石', '500', 'd', 'ds', 'dongshi', '', '乡', '1001005', '', '9');
INSERT INTO `district` VALUES ('3500', '义竹', '500', 'y', 'yz', 'yizhu', '', '乡', '1001006', '', '10');
INSERT INTO `district` VALUES ('3501', '鹿草', '500', 'l', 'lc', 'lucao', '', '乡', '1001007', '', '11');
INSERT INTO `district` VALUES ('3502', '水上', '500', 's', 'ss', 'shuishang', '', '乡', '1001008', '', '12');
INSERT INTO `district` VALUES ('3503', '中埔', '500', 'z', 'zp', 'zhongpu', '', '乡', '1001009', '', '13');
INSERT INTO `district` VALUES ('3504', '竹崎', '500', 'z', 'zq', 'zhuqi', '', '乡', '1001010', '', '14');
INSERT INTO `district` VALUES ('3505', '梅山', '500', 'm', 'ms', 'meishan', '', '乡', '1001011', '', '15');
INSERT INTO `district` VALUES ('3506', '番路', '500', 'f', 'fl', 'fanlu', '', '乡', '1001012', '', '16');
INSERT INTO `district` VALUES ('3507', '大埔', '500', 'd', 'dp', 'dapu', '', '乡', '1001013', '', '17');
INSERT INTO `district` VALUES ('3508', '阿里山', '500', 'a', 'als', 'alishan', '', '乡', '1001014', '', '18');
INSERT INTO `district` VALUES ('3509', '屏东', '501', 'p', 'pd', 'pingdong', '', '市', '1001301', '', '1');
INSERT INTO `district` VALUES ('3510', '潮州', '501', 'c', 'cz', 'chaozhou', '', '镇', '1001302', '', '2');
INSERT INTO `district` VALUES ('3511', '东港', '501', 'd', 'dg', 'donggang', '', '镇', '1001303', '', '3');
INSERT INTO `district` VALUES ('3512', '恒春', '501', 'h', 'hc', 'hengchun', '', '镇', '1001304', '', '4');
INSERT INTO `district` VALUES ('3513', '万丹', '501', 'w', 'wd', 'wandan', '', '乡', '1001305', '', '5');
INSERT INTO `district` VALUES ('3514', '长治', '501', 'z', 'zz', 'zhangzhi', '', '乡', '1001306', '', '6');
INSERT INTO `district` VALUES ('3515', '麟洛', '501', 'l', 'll', 'linluo', '', '乡', '1001307', '', '7');
INSERT INTO `district` VALUES ('3516', '九如', '501', 'j', 'jr', 'jiuru', '', '乡', '1001308', '', '8');
INSERT INTO `district` VALUES ('3517', '里港', '501', 'l', 'lg', 'ligang', '', '乡', '1001309', '', '9');
INSERT INTO `district` VALUES ('3518', '盐埔', '501', 'y', 'yp', 'yanpu', '', '乡', '1001310', '', '10');
INSERT INTO `district` VALUES ('3519', '高树', '501', 'g', 'gs', 'gaoshu', '', '乡', '1001311', '', '11');
INSERT INTO `district` VALUES ('3520', '万峦', '501', 'w', 'wl', 'wanluan', '', '乡', '1001312', '', '12');
INSERT INTO `district` VALUES ('3521', '内埔', '501', 'n', 'np', 'neipu', '', '乡', '1001313', '', '13');
INSERT INTO `district` VALUES ('3522', '竹田', '501', 'z', 'zt', 'zhutian', '', '乡', '1001314', '', '14');
INSERT INTO `district` VALUES ('3523', '新埤', '501', 'x', 'xp', 'xinpi', '', '乡', '1001315', '', '15');
INSERT INTO `district` VALUES ('3524', '枋寮', '501', 'f', 'fl', 'fangliao', '', '乡', '1001316', '', '16');
INSERT INTO `district` VALUES ('3525', '新园', '501', 'x', 'xy', 'xinyuan', '', '乡', '1001317', '', '17');
INSERT INTO `district` VALUES ('3526', '崁顶', '501', 'k', 'kd', 'kanding', '', '乡', '1001318', '', '18');
INSERT INTO `district` VALUES ('3527', '林边', '501', 'l', 'lb', 'linbian', '', '乡', '1001319', '', '19');
INSERT INTO `district` VALUES ('3528', '南州', '501', 'n', 'nz', 'nanzhou', '', '乡', '1001320', '', '20');
INSERT INTO `district` VALUES ('3529', '佳冬', '501', 'j', 'jd', 'jiadong', '', '乡', '1001321', '', '21');
INSERT INTO `district` VALUES ('3530', '琉球', '501', 'l', 'lq', 'liuqiu', '', '乡', '1001322', '', '22');
INSERT INTO `district` VALUES ('3531', '车城', '501', 'c', 'cc', 'checheng', '', '乡', '1001323', '', '23');
INSERT INTO `district` VALUES ('3532', '满州', '501', 'm', 'mz', 'manzhou', '', '乡', '1001324', '', '24');
INSERT INTO `district` VALUES ('3533', '枋山', '501', 'f', 'fs', 'fangshan', '', '乡', '1001325', '', '25');
INSERT INTO `district` VALUES ('3534', '三地门', '501', 's', 'sdm', 'sandimen', '', '乡', '1001326', '', '26');
INSERT INTO `district` VALUES ('3535', '雾台', '501', 'w', 'wt', 'wutai', '', '乡', '1001327', '', '27');
INSERT INTO `district` VALUES ('3536', '玛家', '501', 'm', 'mj', 'majia', '', '乡', '1001328', '', '28');
INSERT INTO `district` VALUES ('3537', '泰武', '501', 't', 'tw', 'taiwu', '', '乡', '1001329', '', '29');
INSERT INTO `district` VALUES ('3538', '来义', '501', 'l', 'ly', 'laiyi', '', '乡', '1001330', '', '30');
INSERT INTO `district` VALUES ('3539', '春日', '501', 'c', 'cr', 'chunri', '', '乡', '1001331', '', '31');
INSERT INTO `district` VALUES ('3540', '狮子', '501', 's', 'sz', 'shizi', '', '乡', '1001332', '', '32');
INSERT INTO `district` VALUES ('3541', '牡丹', '501', 'm', 'md', 'mudan', '', '乡', '1001333', '', '33');
INSERT INTO `district` VALUES ('3542', '卑南', '502', 'b', 'bn', 'beinan', '', '乡', '', '', '1');
INSERT INTO `district` VALUES ('3543', '台东', '502', 't', 'td', 'taidong', '', '市', '1001401', '', '2');
INSERT INTO `district` VALUES ('3544', '成功', '502', 'c', 'cg', 'chenggong', '', '镇', '1001402', '', '3');
INSERT INTO `district` VALUES ('3545', '关山', '502', 'g', 'gs', 'guanshan', '', '镇', '1001403', '', '4');
INSERT INTO `district` VALUES ('3546', '鹿野', '502', 'l', 'ly', 'luye', '', '乡', '1001405', '', '5');
INSERT INTO `district` VALUES ('3547', '池上', '502', 'c', 'cs', 'chishang', '', '乡', '1001406', '', '6');
INSERT INTO `district` VALUES ('3548', '东河', '502', 'd', 'dh', 'donghe', '', '乡', '1001407', '', '7');
INSERT INTO `district` VALUES ('3549', '长滨', '502', 'z', 'zb', 'zhangbin', '', '乡', '1001408', '', '8');
INSERT INTO `district` VALUES ('3550', '太麻里', '502', 't', 'tml', 'taimali', '', '乡', '1001409', '', '9');
INSERT INTO `district` VALUES ('3551', '大武', '502', 'd', 'dw', 'dawu', '', '乡', '1001410', '', '10');
INSERT INTO `district` VALUES ('3552', '绿岛', '502', 'l', 'ld', 'lu:dao', '', '乡', '1001411', '', '11');
INSERT INTO `district` VALUES ('3553', '海端', '502', 'h', 'hd', 'haiduan', '', '乡', '1001412', '', '12');
INSERT INTO `district` VALUES ('3554', '延平', '502', 'y', 'yp', 'yanping', '', '乡', '1001413', '', '13');
INSERT INTO `district` VALUES ('3555', '金峰', '502', 'j', 'jf', 'jinfeng', '', '乡', '1001414', '', '14');
INSERT INTO `district` VALUES ('3556', '达仁', '502', 'd', 'dr', 'daren', '', '乡', '1001415', '', '15');
INSERT INTO `district` VALUES ('3557', '兰屿', '502', 'l', 'ly', 'lanyu', '', '乡', '1001416', '', '16');
INSERT INTO `district` VALUES ('3558', '花莲', '503', 'h', 'hl', 'hualian', '', '市', '1001501', '', '1');
INSERT INTO `district` VALUES ('3559', '凤林', '503', 'f', 'fl', 'fenglin', '', '镇', '1001502', '', '2');
INSERT INTO `district` VALUES ('3560', '玉里', '503', 'y', 'yl', 'yuli', '', '镇', '1001503', '', '3');
INSERT INTO `district` VALUES ('3561', '新城', '503', 'x', 'xc', 'xincheng', '', '乡', '1001504', '', '4');
INSERT INTO `district` VALUES ('3562', '吉安', '503', 'j', 'ja', 'jian', '', '乡', '1001505', '', '5');
INSERT INTO `district` VALUES ('3563', '寿丰', '503', 's', 'sf', 'shoufeng', '', '乡', '1001506', '', '6');
INSERT INTO `district` VALUES ('3564', '光复', '503', 'g', 'gf', 'guangfu', '', '乡', '1001507', '', '7');
INSERT INTO `district` VALUES ('3565', '丰滨', '503', 'f', 'fb', 'fengbin', '', '乡', '1001508', '', '8');
INSERT INTO `district` VALUES ('3566', '瑞穗', '503', 'r', 'rs', 'ruisui', '', '乡', '1001509', '', '9');
INSERT INTO `district` VALUES ('3567', '富里', '503', 'f', 'fl', 'fuli', '', '乡', '1001510', '', '10');
INSERT INTO `district` VALUES ('3568', '秀林', '503', 'x', 'xl', 'xiulin', '', '乡', '1001511', '', '11');
INSERT INTO `district` VALUES ('3569', '万荣', '503', 'w', 'wr', 'wanrong', '', '乡', '1001512', '', '12');
INSERT INTO `district` VALUES ('3570', '卓溪', '503', 'z', 'zx', 'zhuoxi', '', '乡', '1001513', '', '13');
INSERT INTO `district` VALUES ('3571', '马公', '504', 'm', 'mg', 'magong', '', '市', '1001601', '07', '1');
INSERT INTO `district` VALUES ('3572', '湖西', '504', 'h', 'hx', 'huxi', '', '乡', '1001602', '07', '2');
INSERT INTO `district` VALUES ('3573', '白沙', '504', 'b', 'bs', 'baisha', '', '乡', '1001603', '07', '3');
INSERT INTO `district` VALUES ('3574', '西屿', '504', 'x', 'xy', 'xiyu', '', '乡', '1001604', '07', '4');
INSERT INTO `district` VALUES ('3575', '望安', '504', 'w', 'wa', 'wangan', '', '乡', '1001605', '07', '5');
INSERT INTO `district` VALUES ('3576', '七美', '504', 'q', 'qm', 'qimei', '', '乡', '1001606', '07', '6');
INSERT INTO `district` VALUES ('3577', '双河', '31', 's', 'sh', 'shuanghe', '', '市', '659007', '0909', '21');
INSERT INTO `district` VALUES ('3578', '海棠', '357', 'h', 'ht', 'haitang', '', '区', '', '0898', '1');
INSERT INTO `district` VALUES ('3579', '吉阳', '357', 'j', 'jy', 'jiyang', '', '区', '', '0898', '2');
INSERT INTO `district` VALUES ('3580', '天涯', '357', 't', 'ty', 'tianya', '', '区', '', '0898', '3');
INSERT INTO `district` VALUES ('3581', '崖州', '357', 'y', 'yz', 'yazhou', '', '区', '', '0898', '4');
INSERT INTO `district` VALUES ('3582', '霍尔果斯', '476', 'h', 'hegs', 'huoerguosi', '', '市', '654004', '0999', '3');
INSERT INTO `district` VALUES ('3583', '前锋', '388', 'q', 'qf', 'qianfeng', '', '区', '', '0826', '2');
INSERT INTO `district` VALUES ('3584', '福绵', '350', 'f', 'fm', 'fumian', '', '区', '450903', '0775', '2');
INSERT INTO `district` VALUES ('3585', '可克达拉', '31', 'k', 'kdkl', 'kedakela', '', '市', '659008', '0999', '22');
INSERT INTO `district` VALUES ('7036', '龙华', '323', 'l', 'lh', 'longhua', '', '区', '', '0755', '7');
INSERT INTO `district` VALUES ('7037', '坪山', '323', 'p', 'ps', 'pingshan', '', '区', '', '0755', '8');
INSERT INTO `district` VALUES ('7038', '昆玉', '31', 'k', 'ky', 'kunyu', '', '市', '659009', '0903', '23');
INSERT INTO `district` VALUES ('7039', '平桂', '352', 'p', 'pg', 'pinggui', '', '区', '', '0774', '2');
INSERT INTO `district` VALUES ('7040', '巴什', '152', 'b', 'bs', 'bashi', '', '区', '', '0477', '9');
INSERT INTO `district` VALUES ('7041', '叶集', '231', 'y', 'yj', 'yeji', '', '区', '', '0564', '8');

-- ----------------------------
-- Table structure for error_logs
-- ----------------------------
DROP TABLE IF EXISTS `error_logs`;
CREATE TABLE `error_logs` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '唯一ID',
  `user_id` varchar(64) COLLATE utf8_bin DEFAULT '' COMMENT '用户唯一码',
  `platform` varchar(50) COLLATE utf8_bin DEFAULT '' COMMENT '应用平台 Android iOS HTML5 Weixin',
  `app_code` varchar(50) COLLATE utf8_bin DEFAULT '' COMMENT 'APP唯一编号 0000为后端注册用户',
  `version` varchar(20) COLLATE utf8_bin DEFAULT '' COMMENT '使用APP版本号',
  `error_level` varchar(10) COLLATE utf8_bin DEFAULT '' COMMENT '日志界别 DEBUG INFO ERROR',
  `access_token` varchar(64) COLLATE utf8_bin DEFAULT '' COMMENT '授权码',
  `clientip` varchar(50) COLLATE utf8_bin DEFAULT '' COMMENT '调用接口者IP',
  `request_uri` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '请求地址',
  `request_content` mediumtext COLLATE utf8_bin COMMENT '请求数据',
  `request_content_md5` varchar(64) COLLATE utf8_bin DEFAULT '' COMMENT '请求数据MD5',
  `response_content` mediumtext COLLATE utf8_bin COMMENT '返回数据',
  `response_status` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT '返回',
  `response_message` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '返回说明信息',
  `stack_trace` mediumtext COLLATE utf8_bin COMMENT '错误堆栈信息',
  `stack_trace_md5` varchar(64) COLLATE utf8_bin DEFAULT '' COMMENT '错误堆栈信息MD5',
  `fixed_by` varchar(64) COLLATE utf8_bin DEFAULT '' COMMENT '用户唯一码',
  `fixed_date` datetime DEFAULT NULL COMMENT '修复确认时间',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `platform` (`platform`),
  KEY `app_code` (`app_code`),
  KEY `version` (`version`),
  KEY `create_date` (`create_date`),
  KEY `fixed_by` (`fixed_by`),
  KEY `fixed_date` (`fixed_date`),
  KEY `request_uri` (`request_uri`),
  KEY `response_status` (`response_status`),
  KEY `request_content_md5` (`request_content_md5`),
  KEY `stack_trace_md5` (`stack_trace_md5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='错误日志记录表';

-- ----------------------------
-- Records of error_logs
-- ----------------------------

-- ----------------------------
-- Table structure for qrcode_records
-- ----------------------------
DROP TABLE IF EXISTS `qrcode_records`;
CREATE TABLE `qrcode_records` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '唯一ID',
  `record_code` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '自动生成',
  `qrcode_type` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT 'UF' COMMENT '文件类型 LOGIN 登录',
  `user_id` varchar(64) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '用户唯一码',
  `platform` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '应用平台 Android iOS HTML5 Weixin',
  `app_code` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'APP唯一编号 0000为后端注册用户',
  `version` varchar(20) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '使用APP版本号',
  `confirme_date` datetime DEFAULT NULL COMMENT '确认时间',
  `confirme_ip` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '调用接口者IP',
  `expire_time` datetime NOT NULL COMMENT '失效时间',
  `create_ip` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '调用接口者IP',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `record_code` (`record_code`),
  KEY `user_id` (`user_id`),
  KEY `create_date` (`create_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='二维码扫描记录表';

-- ----------------------------
-- Records of qrcode_records
-- ----------------------------

-- ----------------------------
-- Table structure for region_areas
-- ----------------------------
DROP TABLE IF EXISTS `region_areas`;
CREATE TABLE `region_areas` (
  `id` varchar(64) NOT NULL COMMENT '主键',
  `area_code` varchar(20) NOT NULL DEFAULT '' COMMENT '地区代码',
  `area` varchar(50) NOT NULL DEFAULT '' COMMENT '地区名称',
  `city_id` int(11) NOT NULL DEFAULT '0' COMMENT '城市ID',
  `initial` varchar(20) NOT NULL DEFAULT '' COMMENT '地区拼音首写字母',
  `initials` varchar(60) NOT NULL DEFAULT '' COMMENT '地区拼音首写字母组合',
  `pinyin` varchar(300) NOT NULL DEFAULT '' COMMENT '地区拼音全拼',
  PRIMARY KEY (`id`),
  KEY `fk_citys_areas` (`city_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='地区表';

-- ----------------------------
-- Records of region_areas
-- ----------------------------
INSERT INTO `region_areas` VALUES ('1', '130102', '长安区', '33', 'z', 'zaq', 'zhanganqu');
INSERT INTO `region_areas` VALUES ('10', '130123', '正定县', '33', 'z', 'zdx', 'zhengdingxian');
INSERT INTO `region_areas` VALUES ('100', '130636', '顺平县', '38', 's', 'spx', 'shunpingxian');
INSERT INTO `region_areas` VALUES ('1000', '350403', '三元区', '163', 's', 'syq', 'sanyuanqu');
INSERT INTO `region_areas` VALUES ('1001', '350421', '明溪县', '163', 'm', 'mxx', 'mingxixian');
INSERT INTO `region_areas` VALUES ('1002', '350423', '清流县', '163', 'q', 'qlx', 'qingliuxian');
INSERT INTO `region_areas` VALUES ('1003', '350424', '宁化县', '163', 'n', 'nhx', 'ninghuaxian');
INSERT INTO `region_areas` VALUES ('1004', '350425', '大田县', '163', 'd', 'dtx', 'datianxian');
INSERT INTO `region_areas` VALUES ('1005', '350426', '尤溪县', '163', 'y', 'yxx', 'youxixian');
INSERT INTO `region_areas` VALUES ('1006', '350427', '沙县', '163', 's', 'sx', 'shaxian');
INSERT INTO `region_areas` VALUES ('1007', '350428', '将乐县', '163', 'j', 'jlx', 'jianglexian');
INSERT INTO `region_areas` VALUES ('1008', '350429', '泰宁县', '163', 't', 'tnx', 'tainingxian');
INSERT INTO `region_areas` VALUES ('1009', '350430', '建宁县', '163', 'j', 'jnx', 'jianningxian');
INSERT INTO `region_areas` VALUES ('101', '130637', '博野县', '38', 'b', 'byx', 'boyexian');
INSERT INTO `region_areas` VALUES ('1010', '350481', '永安市', '163', 'y', 'yas', 'yonganshi');
INSERT INTO `region_areas` VALUES ('1011', '350502', '鲤城区', '164', 'l', 'lcq', 'lichengqu');
INSERT INTO `region_areas` VALUES ('1012', '350503', '丰泽区', '164', 'f', 'fzq', 'fengzequ');
INSERT INTO `region_areas` VALUES ('1013', '350504', '洛江区', '164', 'l', 'ljq', 'luojiangqu');
INSERT INTO `region_areas` VALUES ('1014', '350505', '泉港区', '164', 'q', 'qgq', 'quangangqu');
INSERT INTO `region_areas` VALUES ('1015', '350521', '惠安县', '164', 'h', 'hax', 'huianxian');
INSERT INTO `region_areas` VALUES ('1016', '350524', '安溪县', '164', 'a', 'axx', 'anxixian');
INSERT INTO `region_areas` VALUES ('1017', '350525', '永春县', '164', 'y', 'ycx', 'yongchunxian');
INSERT INTO `region_areas` VALUES ('1018', '350526', '德化县', '164', 'd', 'dhx', 'dehuaxian');
INSERT INTO `region_areas` VALUES ('1019', '350527', '金门县', '164', 'j', 'jmx', 'jinmenxian');
INSERT INTO `region_areas` VALUES ('102', '130638', '雄县', '38', 'x', 'xx', 'xiongxian');
INSERT INTO `region_areas` VALUES ('1020', '350581', '石狮市', '164', 's', 'sss', 'shishishi');
INSERT INTO `region_areas` VALUES ('1021', '350582', '晋江市', '164', 'j', 'jjs', 'jinjiangshi');
INSERT INTO `region_areas` VALUES ('1022', '350583', '南安市', '164', 'n', 'nas', 'nananshi');
INSERT INTO `region_areas` VALUES ('1023', '350602', '芗城区', '165', 'x', 'xcq', 'xiangchengqu');
INSERT INTO `region_areas` VALUES ('1024', '350603', '龙文区', '165', 'l', 'lwq', 'longwenqu');
INSERT INTO `region_areas` VALUES ('1025', '350622', '云霄县', '165', 'y', 'yxx', 'yunxiaoxian');
INSERT INTO `region_areas` VALUES ('1026', '350623', '漳浦县', '165', 'z', 'zpx', 'zhangpuxian');
INSERT INTO `region_areas` VALUES ('1027', '350624', '诏安县', '165', 'z', 'zax', 'zhaoanxian');
INSERT INTO `region_areas` VALUES ('1028', '350625', '长泰县', '165', 'z', 'ztx', 'zhangtaixian');
INSERT INTO `region_areas` VALUES ('1029', '350626', '东山县', '165', 'd', 'dsx', 'dongshanxian');
INSERT INTO `region_areas` VALUES ('103', '130681', '涿州市', '38', 'z', 'zzs', 'zhuozhoushi');
INSERT INTO `region_areas` VALUES ('1030', '350627', '南靖县', '165', 'n', 'njx', 'nanjingxian');
INSERT INTO `region_areas` VALUES ('1031', '350628', '平和县', '165', 'p', 'phx', 'pinghexian');
INSERT INTO `region_areas` VALUES ('1032', '350629', '华安县', '165', 'h', 'hax', 'huaanxian');
INSERT INTO `region_areas` VALUES ('1033', '350681', '龙海市', '165', 'l', 'lhs', 'longhaishi');
INSERT INTO `region_areas` VALUES ('1034', '350702', '延平区', '166', 'y', 'ypq', 'yanpingqu');
INSERT INTO `region_areas` VALUES ('1035', '350721', '顺昌县', '166', 's', 'scx', 'shunchangxian');
INSERT INTO `region_areas` VALUES ('1036', '350722', '浦城县', '166', 'p', 'pcx', 'puchengxian');
INSERT INTO `region_areas` VALUES ('1037', '350723', '光泽县', '166', 'g', 'gzx', 'guangzexian');
INSERT INTO `region_areas` VALUES ('1038', '350724', '松溪县', '166', 's', 'sxx', 'songxixian');
INSERT INTO `region_areas` VALUES ('1039', '350725', '政和县', '166', 'z', 'zhx', 'zhenghexian');
INSERT INTO `region_areas` VALUES ('104', '130682', '定州市', '38', 'd', 'dzs', 'dingzhoushi');
INSERT INTO `region_areas` VALUES ('1040', '350781', '邵武市', '166', 's', 'sws', 'shaowushi');
INSERT INTO `region_areas` VALUES ('1041', '350782', '武夷山市', '166', 'w', 'wyss', 'wuyishanshi');
INSERT INTO `region_areas` VALUES ('1042', '350783', '建瓯市', '166', 'j', 'jos', 'jianoushi');
INSERT INTO `region_areas` VALUES ('1043', '350784', '建阳市', '166', 'j', 'jys', 'jianyangshi');
INSERT INTO `region_areas` VALUES ('1044', '350802', '新罗区', '167', 'x', 'xlq', 'xinluoqu');
INSERT INTO `region_areas` VALUES ('1045', '350821', '长汀县', '167', 'z', 'ztx', 'zhangtingxian');
INSERT INTO `region_areas` VALUES ('1046', '350822', '永定县', '167', 'y', 'ydx', 'yongdingxian');
INSERT INTO `region_areas` VALUES ('1047', '350823', '上杭县', '167', 's', 'shx', 'shanghangxian');
INSERT INTO `region_areas` VALUES ('1048', '350824', '武平县', '167', 'w', 'wpx', 'wupingxian');
INSERT INTO `region_areas` VALUES ('1049', '350825', '连城县', '167', 'l', 'lcx', 'lianchengxian');
INSERT INTO `region_areas` VALUES ('105', '130683', '安国市', '38', 'a', 'ags', 'anguoshi');
INSERT INTO `region_areas` VALUES ('1050', '350881', '漳平市', '167', 'z', 'zps', 'zhangpingshi');
INSERT INTO `region_areas` VALUES ('1051', '350902', '蕉城区', '168', 'j', 'jcq', 'jiaochengqu');
INSERT INTO `region_areas` VALUES ('1052', '350921', '霞浦县', '168', 'x', 'xpx', 'xiapuxian');
INSERT INTO `region_areas` VALUES ('1053', '350922', '古田县', '168', 'g', 'gtx', 'gutianxian');
INSERT INTO `region_areas` VALUES ('1054', '350923', '屏南县', '168', 'p', 'pnx', 'pingnanxian');
INSERT INTO `region_areas` VALUES ('1055', '350924', '寿宁县', '168', 's', 'snx', 'shouningxian');
INSERT INTO `region_areas` VALUES ('1056', '350925', '周宁县', '168', 'z', 'znx', 'zhouningxian');
INSERT INTO `region_areas` VALUES ('1057', '350926', '柘荣县', '168', 'z', 'zrx', 'zherongxian');
INSERT INTO `region_areas` VALUES ('1058', '350981', '福安市', '168', 'f', 'fas', 'fuanshi');
INSERT INTO `region_areas` VALUES ('1059', '350982', '福鼎市', '168', 'f', 'fds', 'fudingshi');
INSERT INTO `region_areas` VALUES ('106', '130684', '高碑店市', '38', 'g', 'gbds', 'gaobeidianshi');
INSERT INTO `region_areas` VALUES ('1060', '360102', '东湖区', '169', 'd', 'dhq', 'donghuqu');
INSERT INTO `region_areas` VALUES ('1061', '360103', '西湖区', '169', 'x', 'xhq', 'xihuqu');
INSERT INTO `region_areas` VALUES ('1062', '360104', '青云谱区', '169', 'q', 'qypq', 'qingyunpuqu');
INSERT INTO `region_areas` VALUES ('1063', '360105', '湾里区', '169', 'w', 'wlq', 'wanliqu');
INSERT INTO `region_areas` VALUES ('1064', '360111', '青山湖区', '169', 'q', 'qshq', 'qingshanhuqu');
INSERT INTO `region_areas` VALUES ('1065', '360121', '南昌县', '169', 'n', 'ncx', 'nanchangxian');
INSERT INTO `region_areas` VALUES ('1066', '360122', '新建县', '169', 'x', 'xjx', 'xinjianxian');
INSERT INTO `region_areas` VALUES ('1067', '360123', '安义县', '169', 'a', 'ayx', 'anyixian');
INSERT INTO `region_areas` VALUES ('1068', '360124', '进贤县', '169', 'j', 'jxx', 'jinxianxian');
INSERT INTO `region_areas` VALUES ('1069', '360202', '昌江区', '170', 'c', 'cjq', 'changjiangqu');
INSERT INTO `region_areas` VALUES ('107', '130702', '桥东区', '39', 'q', 'qdq', 'qiaodongqu');
INSERT INTO `region_areas` VALUES ('1070', '360203', '珠山区', '170', 'z', 'zsq', 'zhushanqu');
INSERT INTO `region_areas` VALUES ('1071', '360222', '浮梁县', '170', 'f', 'flx', 'fuliangxian');
INSERT INTO `region_areas` VALUES ('1072', '360281', '乐平市', '170', 'l', 'lps', 'lepingshi');
INSERT INTO `region_areas` VALUES ('1073', '360302', '安源区', '171', 'a', 'ayq', 'anyuanqu');
INSERT INTO `region_areas` VALUES ('1074', '360313', '湘东区', '171', 'x', 'xdq', 'xiangdongqu');
INSERT INTO `region_areas` VALUES ('1075', '360321', '莲花县', '171', 'l', 'lhx', 'lianhuaxian');
INSERT INTO `region_areas` VALUES ('1076', '360322', '上栗县', '171', 's', 'slx', 'shanglixian');
INSERT INTO `region_areas` VALUES ('1077', '360323', '芦溪县', '171', 'l', 'lxx', 'luxixian');
INSERT INTO `region_areas` VALUES ('1078', '360402', '庐山区', '172', 'l', 'lsq', 'lushanqu');
INSERT INTO `region_areas` VALUES ('1079', '360403', '浔阳区', '172', 'x', 'xyq', 'xunyangqu');
INSERT INTO `region_areas` VALUES ('108', '130703', '桥西区', '39', 'q', 'qxq', 'qiaoxiqu');
INSERT INTO `region_areas` VALUES ('1080', '360421', '九江县', '172', 'j', 'jjx', 'jiujiangxian');
INSERT INTO `region_areas` VALUES ('1081', '360423', '武宁县', '172', 'w', 'wnx', 'wuningxian');
INSERT INTO `region_areas` VALUES ('1082', '360424', '修水县', '172', 'x', 'xsx', 'xiushuixian');
INSERT INTO `region_areas` VALUES ('1083', '360425', '永修县', '172', 'y', 'yxx', 'yongxiuxian');
INSERT INTO `region_areas` VALUES ('1084', '360426', '德安县', '172', 'd', 'dax', 'deanxian');
INSERT INTO `region_areas` VALUES ('1085', '360427', '星子县', '172', 'x', 'xzx', 'xingzixian');
INSERT INTO `region_areas` VALUES ('1086', '360428', '都昌县', '172', 'd', 'dcx', 'douchangxian');
INSERT INTO `region_areas` VALUES ('1087', '360429', '湖口县', '172', 'h', 'hkx', 'hukouxian');
INSERT INTO `region_areas` VALUES ('1088', '360430', '彭泽县', '172', 'p', 'pzx', 'pengzexian');
INSERT INTO `region_areas` VALUES ('1089', '360481', '瑞昌市', '172', 'r', 'rcs', 'ruichangshi');
INSERT INTO `region_areas` VALUES ('109', '130705', '宣化区', '39', 'x', 'xhq', 'xuanhuaqu');
INSERT INTO `region_areas` VALUES ('1090', '360482', '共青城市', '172', 'g', 'gqcs', 'gongqingchengshi');
INSERT INTO `region_areas` VALUES ('1091', '360502', '渝水区', '173', 'y', 'ysq', 'yushuiqu');
INSERT INTO `region_areas` VALUES ('1092', '360521', '分宜县', '173', 'f', 'fyx', 'fenyixian');
INSERT INTO `region_areas` VALUES ('1093', '360602', '月湖区', '174', 'y', 'yhq', 'yuehuqu');
INSERT INTO `region_areas` VALUES ('1094', '360622', '余江县', '174', 'y', 'yjx', 'yujiangxian');
INSERT INTO `region_areas` VALUES ('1095', '360681', '贵溪市', '174', 'g', 'gxs', 'guixishi');
INSERT INTO `region_areas` VALUES ('1096', '360702', '章贡区', '175', 'z', 'zgq', 'zhanggongqu');
INSERT INTO `region_areas` VALUES ('1097', '360703', '南康区', '175', 'n', 'nkq', 'nankangqu');
INSERT INTO `region_areas` VALUES ('1098', '360721', '赣县', '175', 'g', 'gx', 'ganxian');
INSERT INTO `region_areas` VALUES ('1099', '360722', '信丰县', '175', 'x', 'xfx', 'xinfengxian');
INSERT INTO `region_areas` VALUES ('11', '130125', '行唐县', '33', 'x', 'xtx', 'xingtangxian');
INSERT INTO `region_areas` VALUES ('110', '130706', '下花园区', '39', 'x', 'xhyq', 'xiahuayuanqu');
INSERT INTO `region_areas` VALUES ('1100', '360723', '大余县', '175', 'd', 'dyx', 'dayuxian');
INSERT INTO `region_areas` VALUES ('1101', '360724', '上犹县', '175', 's', 'syx', 'shangyouxian');
INSERT INTO `region_areas` VALUES ('1102', '360725', '崇义县', '175', 'c', 'cyx', 'chongyixian');
INSERT INTO `region_areas` VALUES ('1103', '360726', '安远县', '175', 'a', 'ayx', 'anyuanxian');
INSERT INTO `region_areas` VALUES ('1104', '360727', '龙南县', '175', 'l', 'lnx', 'longnanxian');
INSERT INTO `region_areas` VALUES ('1105', '360728', '定南县', '175', 'd', 'dnx', 'dingnanxian');
INSERT INTO `region_areas` VALUES ('1106', '360729', '全南县', '175', 'q', 'qnx', 'quannanxian');
INSERT INTO `region_areas` VALUES ('1107', '360730', '宁都县', '175', 'n', 'ndx', 'ningdouxian');
INSERT INTO `region_areas` VALUES ('1108', '360731', '于都县', '175', 'y', 'ydx', 'yudouxian');
INSERT INTO `region_areas` VALUES ('1109', '360732', '兴国县', '175', 'x', 'xgx', 'xingguoxian');
INSERT INTO `region_areas` VALUES ('111', '130721', '宣化县', '39', 'x', 'xhx', 'xuanhuaxian');
INSERT INTO `region_areas` VALUES ('1110', '360733', '会昌县', '175', 'h', 'hcx', 'huichangxian');
INSERT INTO `region_areas` VALUES ('1111', '360734', '寻乌县', '175', 'x', 'xwx', 'xunwuxian');
INSERT INTO `region_areas` VALUES ('1112', '360735', '石城县', '175', 's', 'scx', 'shichengxian');
INSERT INTO `region_areas` VALUES ('1113', '360781', '瑞金市', '175', 'r', 'rjs', 'ruijinshi');
INSERT INTO `region_areas` VALUES ('1114', '360802', '吉州区', '176', 'j', 'jzq', 'jizhouqu');
INSERT INTO `region_areas` VALUES ('1115', '360803', '青原区', '176', 'q', 'qyq', 'qingyuanqu');
INSERT INTO `region_areas` VALUES ('1116', '360821', '吉安县', '176', 'j', 'jax', 'jianxian');
INSERT INTO `region_areas` VALUES ('1117', '360822', '吉水县', '176', 'j', 'jsx', 'jishuixian');
INSERT INTO `region_areas` VALUES ('1118', '360823', '峡江县', '176', 'x', 'xjx', 'xiajiangxian');
INSERT INTO `region_areas` VALUES ('1119', '360824', '新干县', '176', 'x', 'xgx', 'xinganxian');
INSERT INTO `region_areas` VALUES ('112', '130722', '张北县', '39', 'z', 'zbx', 'zhangbeixian');
INSERT INTO `region_areas` VALUES ('1120', '360825', '永丰县', '176', 'y', 'yfx', 'yongfengxian');
INSERT INTO `region_areas` VALUES ('1121', '360826', '泰和县', '176', 't', 'thx', 'taihexian');
INSERT INTO `region_areas` VALUES ('1122', '360827', '遂川县', '176', 's', 'scx', 'suichuanxian');
INSERT INTO `region_areas` VALUES ('1123', '360828', '万安县', '176', 'w', 'wax', 'wananxian');
INSERT INTO `region_areas` VALUES ('1124', '360829', '安福县', '176', 'a', 'afx', 'anfuxian');
INSERT INTO `region_areas` VALUES ('1125', '360830', '永新县', '176', 'y', 'yxx', 'yongxinxian');
INSERT INTO `region_areas` VALUES ('1126', '360881', '井冈山市', '176', 'j', 'jgss', 'jinggangshanshi');
INSERT INTO `region_areas` VALUES ('1127', '360902', '袁州区', '177', 'y', 'yzq', 'yuanzhouqu');
INSERT INTO `region_areas` VALUES ('1128', '360921', '奉新县', '177', 'f', 'fxx', 'fengxinxian');
INSERT INTO `region_areas` VALUES ('1129', '360922', '万载县', '177', 'w', 'wzx', 'wanzaixian');
INSERT INTO `region_areas` VALUES ('113', '130723', '康保县', '39', 'k', 'kbx', 'kangbaoxian');
INSERT INTO `region_areas` VALUES ('1130', '360923', '上高县', '177', 's', 'sgx', 'shanggaoxian');
INSERT INTO `region_areas` VALUES ('1131', '360924', '宜丰县', '177', 'y', 'yfx', 'yifengxian');
INSERT INTO `region_areas` VALUES ('1132', '360925', '靖安县', '177', 'j', 'jax', 'jinganxian');
INSERT INTO `region_areas` VALUES ('1133', '360926', '铜鼓县', '177', 't', 'tgx', 'tongguxian');
INSERT INTO `region_areas` VALUES ('1134', '360981', '丰城市', '177', 'f', 'fcs', 'fengchengshi');
INSERT INTO `region_areas` VALUES ('1135', '360982', '樟树市', '177', 'z', 'zss', 'zhangshushi');
INSERT INTO `region_areas` VALUES ('1136', '360983', '高安市', '177', 'g', 'gas', 'gaoanshi');
INSERT INTO `region_areas` VALUES ('1137', '361002', '临川区', '178', 'l', 'lcq', 'linchuanqu');
INSERT INTO `region_areas` VALUES ('1138', '361021', '南城县', '178', 'n', 'ncx', 'nanchengxian');
INSERT INTO `region_areas` VALUES ('1139', '361022', '黎川县', '178', 'l', 'lcx', 'lichuanxian');
INSERT INTO `region_areas` VALUES ('114', '130724', '沽源县', '39', 'g', 'gyx', 'guyuanxian');
INSERT INTO `region_areas` VALUES ('1140', '361023', '南丰县', '178', 'n', 'nfx', 'nanfengxian');
INSERT INTO `region_areas` VALUES ('1141', '361024', '崇仁县', '178', 'c', 'crx', 'chongrenxian');
INSERT INTO `region_areas` VALUES ('1142', '361025', '乐安县', '178', 'l', 'lax', 'leanxian');
INSERT INTO `region_areas` VALUES ('1143', '361026', '宜黄县', '178', 'y', 'yhx', 'yihuangxian');
INSERT INTO `region_areas` VALUES ('1144', '361027', '金溪县', '178', 'j', 'jxx', 'jinxixian');
INSERT INTO `region_areas` VALUES ('1145', '361028', '资溪县', '178', 'z', 'zxx', 'zixixian');
INSERT INTO `region_areas` VALUES ('1146', '361029', '东乡县', '178', 'd', 'dxx', 'dongxiangxian');
INSERT INTO `region_areas` VALUES ('1147', '361030', '广昌县', '178', 'g', 'gcx', 'guangchangxian');
INSERT INTO `region_areas` VALUES ('1148', '361102', '信州区', '179', 'x', 'xzq', 'xinzhouqu');
INSERT INTO `region_areas` VALUES ('1149', '361121', '上饶县', '179', 's', 'srx', 'shangraoxian');
INSERT INTO `region_areas` VALUES ('115', '130725', '尚义县', '39', 's', 'syx', 'shangyixian');
INSERT INTO `region_areas` VALUES ('1150', '361122', '广丰县', '179', 'g', 'gfx', 'guangfengxian');
INSERT INTO `region_areas` VALUES ('1151', '361123', '玉山县', '179', 'y', 'ysx', 'yushanxian');
INSERT INTO `region_areas` VALUES ('1152', '361124', '铅山县', '179', 'q', 'qsx', 'qianshanxian');
INSERT INTO `region_areas` VALUES ('1153', '361125', '横峰县', '179', 'h', 'hfx', 'hengfengxian');
INSERT INTO `region_areas` VALUES ('1154', '361126', '弋阳县', '179', 'y', 'yyx', 'yiyangxian');
INSERT INTO `region_areas` VALUES ('1155', '361127', '余干县', '179', 'y', 'ygx', 'yuganxian');
INSERT INTO `region_areas` VALUES ('1156', '361128', '鄱阳县', '179', 'p', 'pyx', 'poyangxian');
INSERT INTO `region_areas` VALUES ('1157', '361129', '万年县', '179', 'w', 'wnx', 'wannianxian');
INSERT INTO `region_areas` VALUES ('1158', '361130', '婺源县', '179', 'w', 'wyx', 'wuyuanxian');
INSERT INTO `region_areas` VALUES ('1159', '361181', '德兴市', '179', 'd', 'dxs', 'dexingshi');
INSERT INTO `region_areas` VALUES ('116', '130726', '蔚县', '39', 'y', 'yx', 'yuxian');
INSERT INTO `region_areas` VALUES ('1160', '370102', '历下区', '180', 'l', 'lxq', 'lixiaqu');
INSERT INTO `region_areas` VALUES ('1161', '370103', '市中区', '180', 's', 'szq', 'shizhongqu');
INSERT INTO `region_areas` VALUES ('1162', '370104', '槐荫区', '180', 'h', 'hyq', 'huaiyinqu');
INSERT INTO `region_areas` VALUES ('1163', '370105', '天桥区', '180', 't', 'tqq', 'tianqiaoqu');
INSERT INTO `region_areas` VALUES ('1164', '370112', '历城区', '180', 'l', 'lcq', 'lichengqu');
INSERT INTO `region_areas` VALUES ('1165', '370113', '长清区', '180', 'z', 'zqq', 'zhangqingqu');
INSERT INTO `region_areas` VALUES ('1166', '370124', '平阴县', '180', 'p', 'pyx', 'pingyinxian');
INSERT INTO `region_areas` VALUES ('1167', '370125', '济阳县', '180', 'j', 'jyx', 'jiyangxian');
INSERT INTO `region_areas` VALUES ('1168', '370126', '商河县', '180', 's', 'shx', 'shanghexian');
INSERT INTO `region_areas` VALUES ('1169', '370181', '章丘市', '180', 'z', 'zqs', 'zhangqiushi');
INSERT INTO `region_areas` VALUES ('117', '130727', '阳原县', '39', 'y', 'yyx', 'yangyuanxian');
INSERT INTO `region_areas` VALUES ('1170', '370202', '市南区', '181', 's', 'snq', 'shinanqu');
INSERT INTO `region_areas` VALUES ('1171', '370203', '市北区', '181', 's', 'sbq', 'shibeiqu');
INSERT INTO `region_areas` VALUES ('1172', '370211', '黄岛区', '181', 'h', 'hdq', 'huangdaoqu');
INSERT INTO `region_areas` VALUES ('1173', '370212', '崂山区', '181', 'l', 'lsq', 'laoshanqu');
INSERT INTO `region_areas` VALUES ('1174', '370213', '李沧区', '181', 'l', 'lcq', 'licangqu');
INSERT INTO `region_areas` VALUES ('1175', '370214', '城阳区', '181', 'c', 'cyq', 'chengyangqu');
INSERT INTO `region_areas` VALUES ('1176', '370281', '胶州市', '181', 'j', 'jzs', 'jiaozhoushi');
INSERT INTO `region_areas` VALUES ('1177', '370282', '即墨市', '181', 'j', 'jms', 'jimoshi');
INSERT INTO `region_areas` VALUES ('1178', '370283', '平度市', '181', 'p', 'pds', 'pingdushi');
INSERT INTO `region_areas` VALUES ('1179', '370285', '莱西市', '181', 'l', 'lxs', 'laixishi');
INSERT INTO `region_areas` VALUES ('118', '130728', '怀安县', '39', 'h', 'hax', 'huaianxian');
INSERT INTO `region_areas` VALUES ('1180', '370302', '淄川区', '182', 'z', 'zcq', 'zichuanqu');
INSERT INTO `region_areas` VALUES ('1181', '370303', '张店区', '182', 'z', 'zdq', 'zhangdianqu');
INSERT INTO `region_areas` VALUES ('1182', '370304', '博山区', '182', 'b', 'bsq', 'boshanqu');
INSERT INTO `region_areas` VALUES ('1183', '370305', '临淄区', '182', 'l', 'lzq', 'linziqu');
INSERT INTO `region_areas` VALUES ('1184', '370306', '周村区', '182', 'z', 'zcq', 'zhoucunqu');
INSERT INTO `region_areas` VALUES ('1185', '370321', '桓台县', '182', 'h', 'htx', 'huantaixian');
INSERT INTO `region_areas` VALUES ('1186', '370322', '高青县', '182', 'g', 'gqx', 'gaoqingxian');
INSERT INTO `region_areas` VALUES ('1187', '370323', '沂源县', '182', 'y', 'yyx', 'yiyuanxian');
INSERT INTO `region_areas` VALUES ('1188', '370402', '市中区', '183', 's', 'szq', 'shizhongqu');
INSERT INTO `region_areas` VALUES ('1189', '370403', '薛城区', '183', 'x', 'xcq', 'xuechengqu');
INSERT INTO `region_areas` VALUES ('119', '130729', '万全县', '39', 'w', 'wqx', 'wanquanxian');
INSERT INTO `region_areas` VALUES ('1190', '370404', '峄城区', '183', 'y', 'ycq', 'yichengqu');
INSERT INTO `region_areas` VALUES ('1191', '370405', '台儿庄区', '183', 't', 'tezq', 'taierzhuangqu');
INSERT INTO `region_areas` VALUES ('1192', '370406', '山亭区', '183', 's', 'stq', 'shantingqu');
INSERT INTO `region_areas` VALUES ('1193', '370481', '滕州市', '183', 't', 'tzs', 'tengzhoushi');
INSERT INTO `region_areas` VALUES ('1194', '370502', '东营区', '184', 'd', 'dyq', 'dongyingqu');
INSERT INTO `region_areas` VALUES ('1195', '370503', '河口区', '184', 'h', 'hkq', 'hekouqu');
INSERT INTO `region_areas` VALUES ('1196', '370521', '垦利县', '184', 'k', 'klx', 'kenlixian');
INSERT INTO `region_areas` VALUES ('1197', '370522', '利津县', '184', 'l', 'ljx', 'lijinxian');
INSERT INTO `region_areas` VALUES ('1198', '370523', '广饶县', '184', 'g', 'grx', 'guangraoxian');
INSERT INTO `region_areas` VALUES ('1199', '370602', '芝罘区', '185', 'z', 'zfq', 'zhifuqu');
INSERT INTO `region_areas` VALUES ('12', '130126', '灵寿县', '33', 'l', 'lsx', 'lingshouxian');
INSERT INTO `region_areas` VALUES ('120', '130730', '怀来县', '39', 'h', 'hlx', 'huailaixian');
INSERT INTO `region_areas` VALUES ('1200', '370611', '福山区', '185', 'f', 'fsq', 'fushanqu');
INSERT INTO `region_areas` VALUES ('1201', '370612', '牟平区', '185', 'm', 'mpq', 'moupingqu');
INSERT INTO `region_areas` VALUES ('1202', '370613', '莱山区', '185', 'l', 'lsq', 'laishanqu');
INSERT INTO `region_areas` VALUES ('1203', '370634', '长岛县', '185', 'z', 'zdx', 'zhangdaoxian');
INSERT INTO `region_areas` VALUES ('1204', '370681', '龙口市', '185', 'l', 'lks', 'longkoushi');
INSERT INTO `region_areas` VALUES ('1205', '370682', '莱阳市', '185', 'l', 'lys', 'laiyangshi');
INSERT INTO `region_areas` VALUES ('1206', '370683', '莱州市', '185', 'l', 'lzs', 'laizhoushi');
INSERT INTO `region_areas` VALUES ('1207', '370684', '蓬莱市', '185', 'p', 'pls', 'penglaishi');
INSERT INTO `region_areas` VALUES ('1208', '370685', '招远市', '185', 'z', 'zys', 'zhaoyuanshi');
INSERT INTO `region_areas` VALUES ('1209', '370686', '栖霞市', '185', 'q', 'qxs', 'qixiashi');
INSERT INTO `region_areas` VALUES ('121', '130731', '涿鹿县', '39', 'z', 'zlx', 'zhuoluxian');
INSERT INTO `region_areas` VALUES ('1210', '370687', '海阳市', '185', 'h', 'hys', 'haiyangshi');
INSERT INTO `region_areas` VALUES ('1211', '370702', '潍城区', '186', 'w', 'wcq', 'weichengqu');
INSERT INTO `region_areas` VALUES ('1212', '370703', '寒亭区', '186', 'h', 'htq', 'hantingqu');
INSERT INTO `region_areas` VALUES ('1213', '370704', '坊子区', '186', 'f', 'fzq', 'fangziqu');
INSERT INTO `region_areas` VALUES ('1214', '370705', '奎文区', '186', 'k', 'kwq', 'kuiwenqu');
INSERT INTO `region_areas` VALUES ('1215', '370724', '临朐县', '186', 'l', 'lqx', 'linquxian');
INSERT INTO `region_areas` VALUES ('1216', '370725', '昌乐县', '186', 'c', 'clx', 'changlexian');
INSERT INTO `region_areas` VALUES ('1217', '370781', '青州市', '186', 'q', 'qzs', 'qingzhoushi');
INSERT INTO `region_areas` VALUES ('1218', '370782', '诸城市', '186', 'z', 'zcs', 'zhuchengshi');
INSERT INTO `region_areas` VALUES ('1219', '370783', '寿光市', '186', 's', 'sgs', 'shouguangshi');
INSERT INTO `region_areas` VALUES ('122', '130732', '赤城县', '39', 'c', 'ccx', 'chichengxian');
INSERT INTO `region_areas` VALUES ('1220', '370784', '安丘市', '186', 'a', 'aqs', 'anqiushi');
INSERT INTO `region_areas` VALUES ('1221', '370785', '高密市', '186', 'g', 'gms', 'gaomishi');
INSERT INTO `region_areas` VALUES ('1222', '370786', '昌邑市', '186', 'c', 'cys', 'changyishi');
INSERT INTO `region_areas` VALUES ('1223', '370811', '任城区', '187', 'r', 'rcq', 'renchengqu');
INSERT INTO `region_areas` VALUES ('1224', '370812', '兖州区', '187', 'y', 'yzq', 'yanzhouqu');
INSERT INTO `region_areas` VALUES ('1225', '370826', '微山县', '187', 'w', 'wsx', 'weishanxian');
INSERT INTO `region_areas` VALUES ('1226', '370827', '鱼台县', '187', 'y', 'ytx', 'yutaixian');
INSERT INTO `region_areas` VALUES ('1227', '370828', '金乡县', '187', 'j', 'jxx', 'jinxiangxian');
INSERT INTO `region_areas` VALUES ('1228', '370829', '嘉祥县', '187', 'j', 'jxx', 'jiaxiangxian');
INSERT INTO `region_areas` VALUES ('1229', '370830', '汶上县', '187', 'w', 'wsx', 'wenshangxian');
INSERT INTO `region_areas` VALUES ('123', '130733', '崇礼县', '39', 'c', 'clx', 'chonglixian');
INSERT INTO `region_areas` VALUES ('1230', '370831', '泗水县', '187', 's', 'ssx', 'sishuixian');
INSERT INTO `region_areas` VALUES ('1231', '370832', '梁山县', '187', 'l', 'lsx', 'liangshanxian');
INSERT INTO `region_areas` VALUES ('1232', '370881', '曲阜市', '187', 'q', 'qfs', 'qufushi');
INSERT INTO `region_areas` VALUES ('1233', '370883', '邹城市', '187', 'z', 'zcs', 'zouchengshi');
INSERT INTO `region_areas` VALUES ('1234', '370902', '泰山区', '188', 't', 'tsq', 'taishanqu');
INSERT INTO `region_areas` VALUES ('1235', '370911', '岱岳区', '188', 'd', 'dyq', 'daiyuequ');
INSERT INTO `region_areas` VALUES ('1236', '370921', '宁阳县', '188', 'n', 'nyx', 'ningyangxian');
INSERT INTO `region_areas` VALUES ('1237', '370923', '东平县', '188', 'd', 'dpx', 'dongpingxian');
INSERT INTO `region_areas` VALUES ('1238', '370982', '新泰市', '188', 'x', 'xts', 'xintaishi');
INSERT INTO `region_areas` VALUES ('1239', '370983', '肥城市', '188', 'f', 'fcs', 'feichengshi');
INSERT INTO `region_areas` VALUES ('124', '130802', '双桥区', '40', 's', 'sqq', 'shuangqiaoqu');
INSERT INTO `region_areas` VALUES ('1240', '371002', '环翠区', '189', 'h', 'hcq', 'huancuiqu');
INSERT INTO `region_areas` VALUES ('1241', '371003', '文登区', '189', 'w', 'wdq', 'wendengqu');
INSERT INTO `region_areas` VALUES ('1242', '371082', '荣成市', '189', 'r', 'rcs', 'rongchengshi');
INSERT INTO `region_areas` VALUES ('1243', '371083', '乳山市', '189', 'r', 'rss', 'rushanshi');
INSERT INTO `region_areas` VALUES ('1244', '371102', '东港区', '190', 'd', 'dgq', 'donggangqu');
INSERT INTO `region_areas` VALUES ('1245', '371103', '岚山区', '190', 'l', 'lsq', 'lanshanqu');
INSERT INTO `region_areas` VALUES ('1246', '371121', '五莲县', '190', 'w', 'wlx', 'wulianxian');
INSERT INTO `region_areas` VALUES ('1247', '371122', '莒县', '190', 'j', 'jx', 'juxian');
INSERT INTO `region_areas` VALUES ('1248', '371202', '莱城区', '191', 'l', 'lcq', 'laichengqu');
INSERT INTO `region_areas` VALUES ('1249', '371203', '钢城区', '191', 'g', 'gcq', 'gangchengqu');
INSERT INTO `region_areas` VALUES ('125', '130803', '双滦区', '40', 's', 'slq', 'shuangluanqu');
INSERT INTO `region_areas` VALUES ('1250', '371302', '兰山区', '192', 'l', 'lsq', 'lanshanqu');
INSERT INTO `region_areas` VALUES ('1251', '371311', '罗庄区', '192', 'l', 'lzq', 'luozhuangqu');
INSERT INTO `region_areas` VALUES ('1252', '371312', '河东区', '192', 'h', 'hdq', 'hedongqu');
INSERT INTO `region_areas` VALUES ('1253', '371321', '沂南县', '192', 'y', 'ynx', 'yinanxian');
INSERT INTO `region_areas` VALUES ('1254', '371322', '郯城县', '192', 't', 'tcx', 'tanchengxian');
INSERT INTO `region_areas` VALUES ('1255', '371323', '沂水县', '192', 'y', 'ysx', 'yishuixian');
INSERT INTO `region_areas` VALUES ('1256', '371324', '兰陵县', '192', 'l', 'llx', 'lanlingxian');
INSERT INTO `region_areas` VALUES ('1257', '371325', '费县', '192', 'f', 'fx', 'feixian');
INSERT INTO `region_areas` VALUES ('1258', '371326', '平邑县', '192', 'p', 'pyx', 'pingyixian');
INSERT INTO `region_areas` VALUES ('1259', '371327', '莒南县', '192', 'j', 'jnx', 'junanxian');
INSERT INTO `region_areas` VALUES ('126', '130804', '鹰手营子矿区', '40', 'y', 'ysyzkq', 'yingshouyingzikuangqu');
INSERT INTO `region_areas` VALUES ('1260', '371328', '蒙阴县', '192', 'm', 'myx', 'mengyinxian');
INSERT INTO `region_areas` VALUES ('1261', '371329', '临沭县', '192', 'l', 'lsx', 'linshuxian');
INSERT INTO `region_areas` VALUES ('1262', '371402', '德城区', '193', 'd', 'dcq', 'dechengqu');
INSERT INTO `region_areas` VALUES ('1263', '371403', '陵城区', '193', 'l', 'lcq', 'lingchengqu');
INSERT INTO `region_areas` VALUES ('1264', '371422', '宁津县', '193', 'n', 'njx', 'ningjinxian');
INSERT INTO `region_areas` VALUES ('1265', '371423', '庆云县', '193', 'q', 'qyx', 'qingyunxian');
INSERT INTO `region_areas` VALUES ('1266', '371424', '临邑县', '193', 'l', 'lyx', 'linyixian');
INSERT INTO `region_areas` VALUES ('1267', '371425', '齐河县', '193', 'q', 'qhx', 'qihexian');
INSERT INTO `region_areas` VALUES ('1268', '371426', '平原县', '193', 'p', 'pyx', 'pingyuanxian');
INSERT INTO `region_areas` VALUES ('1269', '371427', '夏津县', '193', 'x', 'xjx', 'xiajinxian');
INSERT INTO `region_areas` VALUES ('127', '130821', '承德县', '40', 'c', 'cdx', 'chengdexian');
INSERT INTO `region_areas` VALUES ('1270', '371428', '武城县', '193', 'w', 'wcx', 'wuchengxian');
INSERT INTO `region_areas` VALUES ('1271', '371481', '乐陵市', '193', 'l', 'lls', 'lelingshi');
INSERT INTO `region_areas` VALUES ('1272', '371482', '禹城市', '193', 'y', 'ycs', 'yuchengshi');
INSERT INTO `region_areas` VALUES ('1273', '371502', '东昌府区', '194', 'd', 'dcfq', 'dongchangfuqu');
INSERT INTO `region_areas` VALUES ('1274', '371521', '阳谷县', '194', 'y', 'ygx', 'yangguxian');
INSERT INTO `region_areas` VALUES ('1275', '371522', '莘县', '194', 'x', 'xx', 'xinxian');
INSERT INTO `region_areas` VALUES ('1276', '371523', '茌平县', '194', 'c', 'cpx', 'chipingxian');
INSERT INTO `region_areas` VALUES ('1277', '371524', '东阿县', '194', 'd', 'dax', 'dongaxian');
INSERT INTO `region_areas` VALUES ('1278', '371525', '冠县', '194', 'g', 'gx', 'guanxian');
INSERT INTO `region_areas` VALUES ('1279', '371526', '高唐县', '194', 'g', 'gtx', 'gaotangxian');
INSERT INTO `region_areas` VALUES ('128', '130822', '兴隆县', '40', 'x', 'xlx', 'xinglongxian');
INSERT INTO `region_areas` VALUES ('1280', '371581', '临清市', '194', 'l', 'lqs', 'linqingshi');
INSERT INTO `region_areas` VALUES ('1281', '371602', '滨城区', '195', 'b', 'bcq', 'binchengqu');
INSERT INTO `region_areas` VALUES ('1282', '371603', '沾化区', '195', 'z', 'zhq', 'zhanhuaqu');
INSERT INTO `region_areas` VALUES ('1283', '371621', '惠民县', '195', 'h', 'hmx', 'huiminxian');
INSERT INTO `region_areas` VALUES ('1284', '371622', '阳信县', '195', 'y', 'yxx', 'yangxinxian');
INSERT INTO `region_areas` VALUES ('1285', '371623', '无棣县', '195', 'w', 'wdx', 'wudixian');
INSERT INTO `region_areas` VALUES ('1286', '371625', '博兴县', '195', 'b', 'bxx', 'boxingxian');
INSERT INTO `region_areas` VALUES ('1287', '371626', '邹平县', '195', 'z', 'zpx', 'zoupingxian');
INSERT INTO `region_areas` VALUES ('1288', '371702', '牡丹区', '196', 'm', 'mdq', 'mudanqu');
INSERT INTO `region_areas` VALUES ('1289', '371721', '曹县', '196', 'c', 'cx', 'caoxian');
INSERT INTO `region_areas` VALUES ('129', '130823', '平泉县', '40', 'p', 'pqx', 'pingquanxian');
INSERT INTO `region_areas` VALUES ('1290', '371722', '单县', '196', 'd', 'dx', 'danxian');
INSERT INTO `region_areas` VALUES ('1291', '371723', '成武县', '196', 'c', 'cwx', 'chengwuxian');
INSERT INTO `region_areas` VALUES ('1292', '371724', '巨野县', '196', 'j', 'jyx', 'juyexian');
INSERT INTO `region_areas` VALUES ('1293', '371725', '郓城县', '196', 'y', 'ycx', 'yunchengxian');
INSERT INTO `region_areas` VALUES ('1294', '371726', '鄄城县', '196', 'j', 'jcx', 'juanchengxian');
INSERT INTO `region_areas` VALUES ('1295', '371727', '定陶县', '196', 'd', 'dtx', 'dingtaoxian');
INSERT INTO `region_areas` VALUES ('1296', '371728', '东明县', '196', 'd', 'dmx', 'dongmingxian');
INSERT INTO `region_areas` VALUES ('1297', '410102', '中原区', '197', 'z', 'zyq', 'zhongyuanqu');
INSERT INTO `region_areas` VALUES ('1298', '410103', '二七区', '197', 'e', 'eqq', 'erqiqu');
INSERT INTO `region_areas` VALUES ('1299', '410104', '管城回族区', '197', 'g', 'gchzq', 'guanchenghuizuqu');
INSERT INTO `region_areas` VALUES ('13', '130127', '高邑县', '33', 'g', 'gyx', 'gaoyixian');
INSERT INTO `region_areas` VALUES ('130', '130824', '滦平县', '40', 'l', 'lpx', 'luanpingxian');
INSERT INTO `region_areas` VALUES ('1300', '410105', '金水区', '197', 'j', 'jsq', 'jinshuiqu');
INSERT INTO `region_areas` VALUES ('1301', '410106', '上街区', '197', 's', 'sjq', 'shangjiequ');
INSERT INTO `region_areas` VALUES ('1302', '410108', '惠济区', '197', 'h', 'hjq', 'huijiqu');
INSERT INTO `region_areas` VALUES ('1303', '410122', '中牟县', '197', 'z', 'zmx', 'zhongmouxian');
INSERT INTO `region_areas` VALUES ('1304', '410181', '巩义市', '197', 'g', 'gys', 'gongyishi');
INSERT INTO `region_areas` VALUES ('1305', '410182', '荥阳市', '197', 'y', 'yys', 'yingyangshi');
INSERT INTO `region_areas` VALUES ('1306', '410183', '新密市', '197', 'x', 'xms', 'xinmishi');
INSERT INTO `region_areas` VALUES ('1307', '410184', '新郑市', '197', 'x', 'xzs', 'xinzhengshi');
INSERT INTO `region_areas` VALUES ('1308', '410185', '登封市', '197', 'd', 'dfs', 'dengfengshi');
INSERT INTO `region_areas` VALUES ('1309', '410202', '龙亭区', '198', 'l', 'ltq', 'longtingqu');
INSERT INTO `region_areas` VALUES ('131', '130825', '隆化县', '40', 'l', 'lhx', 'longhuaxian');
INSERT INTO `region_areas` VALUES ('1310', '410203', '顺河回族区', '198', 's', 'shhzq', 'shunhehuizuqu');
INSERT INTO `region_areas` VALUES ('1311', '410204', '鼓楼区', '198', 'g', 'glq', 'gulouqu');
INSERT INTO `region_areas` VALUES ('1312', '410205', '禹王台区', '198', 'y', 'ywtq', 'yuwangtaiqu');
INSERT INTO `region_areas` VALUES ('1313', '410211', '金明区', '198', 'j', 'jmq', 'jinmingqu');
INSERT INTO `region_areas` VALUES ('1314', '410221', '杞县', '198', 'q', 'qx', 'qixian');
INSERT INTO `region_areas` VALUES ('1315', '410222', '通许县', '198', 't', 'txx', 'tongxuxian');
INSERT INTO `region_areas` VALUES ('1316', '410223', '尉氏县', '198', 'w', 'wsx', 'weishixian');
INSERT INTO `region_areas` VALUES ('1317', '410224', '开封县', '198', 'k', 'kfx', 'kaifengxian');
INSERT INTO `region_areas` VALUES ('1318', '410225', '兰考县', '198', 'l', 'lkx', 'lankaoxian');
INSERT INTO `region_areas` VALUES ('1319', '410302', '老城区', '199', 'l', 'lcq', 'laochengqu');
INSERT INTO `region_areas` VALUES ('132', '130826', '丰宁满族自治县', '40', 'f', 'fnmzzzx', 'fengningmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('1320', '410303', '西工区', '199', 'x', 'xgq', 'xigongqu');
INSERT INTO `region_areas` VALUES ('1321', '410304', '瀍河回族区', '199', 'c', 'chhzq', 'chanhehuizuqu');
INSERT INTO `region_areas` VALUES ('1322', '410305', '涧西区', '199', 'j', 'jxq', 'jianxiqu');
INSERT INTO `region_areas` VALUES ('1323', '410306', '吉利区', '199', 'j', 'jlq', 'jiliqu');
INSERT INTO `region_areas` VALUES ('1324', '410311', '洛龙区', '199', 'l', 'llq', 'luolongqu');
INSERT INTO `region_areas` VALUES ('1325', '410322', '孟津县', '199', 'm', 'mjx', 'mengjinxian');
INSERT INTO `region_areas` VALUES ('1326', '410323', '新安县', '199', 'x', 'xax', 'xinanxian');
INSERT INTO `region_areas` VALUES ('1327', '410324', '栾川县', '199', 'l', 'lcx', 'luanchuanxian');
INSERT INTO `region_areas` VALUES ('1328', '410325', '嵩县', '199', 's', 'sx', 'songxian');
INSERT INTO `region_areas` VALUES ('1329', '410326', '汝阳县', '199', 'r', 'ryx', 'ruyangxian');
INSERT INTO `region_areas` VALUES ('133', '130827', '宽城满族自治县', '40', 'k', 'kcmzzzx', 'kuanchengmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('1330', '410327', '宜阳县', '199', 'y', 'yyx', 'yiyangxian');
INSERT INTO `region_areas` VALUES ('1331', '410328', '洛宁县', '199', 'l', 'lnx', 'luoningxian');
INSERT INTO `region_areas` VALUES ('1332', '410329', '伊川县', '199', 'y', 'ycx', 'yichuanxian');
INSERT INTO `region_areas` VALUES ('1333', '410381', '偃师市', '199', 'y', 'yss', 'yanshishi');
INSERT INTO `region_areas` VALUES ('1334', '410402', '新华区', '200', 'x', 'xhq', 'xinhuaqu');
INSERT INTO `region_areas` VALUES ('1335', '410403', '卫东区', '200', 'w', 'wdq', 'weidongqu');
INSERT INTO `region_areas` VALUES ('1336', '410404', '石龙区', '200', 's', 'slq', 'shilongqu');
INSERT INTO `region_areas` VALUES ('1337', '410411', '湛河区', '200', 'z', 'zhq', 'zhanhequ');
INSERT INTO `region_areas` VALUES ('1338', '410421', '宝丰县', '200', 'b', 'bfx', 'baofengxian');
INSERT INTO `region_areas` VALUES ('1339', '410422', '叶县', '200', 'y', 'yx', 'yexian');
INSERT INTO `region_areas` VALUES ('134', '130828', '围场满族蒙古族自治县', '40', 'w', 'wcmzmgzzzx', 'weichangmanzumengguzuzizhixian');
INSERT INTO `region_areas` VALUES ('1340', '410423', '鲁山县', '200', 'l', 'lsx', 'lushanxian');
INSERT INTO `region_areas` VALUES ('1341', '410425', '郏县', '200', 'j', 'jx', 'jiaxian');
INSERT INTO `region_areas` VALUES ('1342', '410481', '舞钢市', '200', 'w', 'wgs', 'wugangshi');
INSERT INTO `region_areas` VALUES ('1343', '410482', '汝州市', '200', 'r', 'rzs', 'ruzhoushi');
INSERT INTO `region_areas` VALUES ('1344', '410502', '文峰区', '201', 'w', 'wfq', 'wenfengqu');
INSERT INTO `region_areas` VALUES ('1345', '410503', '北关区', '201', 'b', 'bgq', 'beiguanqu');
INSERT INTO `region_areas` VALUES ('1346', '410505', '殷都区', '201', 'y', 'ydq', 'yindouqu');
INSERT INTO `region_areas` VALUES ('1347', '410506', '龙安区', '201', 'l', 'laq', 'longanqu');
INSERT INTO `region_areas` VALUES ('1348', '410522', '安阳县', '201', 'a', 'ayx', 'anyangxian');
INSERT INTO `region_areas` VALUES ('1349', '410523', '汤阴县', '201', 't', 'tyx', 'tangyinxian');
INSERT INTO `region_areas` VALUES ('135', '130902', '新华区', '41', 'x', 'xhq', 'xinhuaqu');
INSERT INTO `region_areas` VALUES ('1350', '410526', '滑县', '201', 'h', 'hx', 'huaxian');
INSERT INTO `region_areas` VALUES ('1351', '410527', '内黄县', '201', 'n', 'nhx', 'neihuangxian');
INSERT INTO `region_areas` VALUES ('1352', '410581', '林州市', '201', 'l', 'lzs', 'linzhoushi');
INSERT INTO `region_areas` VALUES ('1353', '410602', '鹤山区', '202', 'h', 'hsq', 'heshanqu');
INSERT INTO `region_areas` VALUES ('1354', '410603', '山城区', '202', 's', 'scq', 'shanchengqu');
INSERT INTO `region_areas` VALUES ('1355', '410611', '淇滨区', '202', 'q', 'qbq', 'qibinqu');
INSERT INTO `region_areas` VALUES ('1356', '410621', '浚县', '202', 'j', 'jx', 'junxian');
INSERT INTO `region_areas` VALUES ('1357', '410622', '淇县', '202', 'q', 'qx', 'qixian');
INSERT INTO `region_areas` VALUES ('1358', '410702', '红旗区', '203', 'h', 'hqq', 'hongqiqu');
INSERT INTO `region_areas` VALUES ('1359', '410703', '卫滨区', '203', 'w', 'wbq', 'weibinqu');
INSERT INTO `region_areas` VALUES ('136', '130903', '运河区', '41', 'y', 'yhq', 'yunhequ');
INSERT INTO `region_areas` VALUES ('1360', '410704', '凤泉区', '203', 'f', 'fqq', 'fengquanqu');
INSERT INTO `region_areas` VALUES ('1361', '410711', '牧野区', '203', 'm', 'myq', 'muyequ');
INSERT INTO `region_areas` VALUES ('1362', '410721', '新乡县', '203', 'x', 'xxx', 'xinxiangxian');
INSERT INTO `region_areas` VALUES ('1363', '410724', '获嘉县', '203', 'h', 'hjx', 'huojiaxian');
INSERT INTO `region_areas` VALUES ('1364', '410725', '原阳县', '203', 'y', 'yyx', 'yuanyangxian');
INSERT INTO `region_areas` VALUES ('1365', '410726', '延津县', '203', 'y', 'yjx', 'yanjinxian');
INSERT INTO `region_areas` VALUES ('1366', '410727', '封丘县', '203', 'f', 'fqx', 'fengqiuxian');
INSERT INTO `region_areas` VALUES ('1367', '410728', '长垣县', '203', 'z', 'zyx', 'zhangyuanxian');
INSERT INTO `region_areas` VALUES ('1368', '410781', '卫辉市', '203', 'w', 'whs', 'weihuishi');
INSERT INTO `region_areas` VALUES ('1369', '410782', '辉县市', '203', 'h', 'hxs', 'huixianshi');
INSERT INTO `region_areas` VALUES ('137', '130921', '沧县', '41', 'c', 'cx', 'cangxian');
INSERT INTO `region_areas` VALUES ('1370', '410802', '解放区', '204', 'j', 'jfq', 'jiefangqu');
INSERT INTO `region_areas` VALUES ('1371', '410803', '中站区', '204', 'z', 'zzq', 'zhongzhanqu');
INSERT INTO `region_areas` VALUES ('1372', '410804', '马村区', '204', 'm', 'mcq', 'macunqu');
INSERT INTO `region_areas` VALUES ('1373', '410811', '山阳区', '204', 's', 'syq', 'shanyangqu');
INSERT INTO `region_areas` VALUES ('1374', '410821', '修武县', '204', 'x', 'xwx', 'xiuwuxian');
INSERT INTO `region_areas` VALUES ('1375', '410822', '博爱县', '204', 'b', 'bax', 'boaixian');
INSERT INTO `region_areas` VALUES ('1376', '410823', '武陟县', '204', 'w', 'wzx', 'wuzhixian');
INSERT INTO `region_areas` VALUES ('1377', '410825', '温县', '204', 'w', 'wx', 'wenxian');
INSERT INTO `region_areas` VALUES ('1378', '410882', '沁阳市', '204', 'q', 'qys', 'qinyangshi');
INSERT INTO `region_areas` VALUES ('1379', '410883', '孟州市', '204', 'm', 'mzs', 'mengzhoushi');
INSERT INTO `region_areas` VALUES ('138', '130922', '青县', '41', 'q', 'qx', 'qingxian');
INSERT INTO `region_areas` VALUES ('1380', '410902', '华龙区', '205', 'h', 'hlq', 'hualongqu');
INSERT INTO `region_areas` VALUES ('1381', '410922', '清丰县', '205', 'q', 'qfx', 'qingfengxian');
INSERT INTO `region_areas` VALUES ('1382', '410923', '南乐县', '205', 'n', 'nlx', 'nanlexian');
INSERT INTO `region_areas` VALUES ('1383', '410926', '范县', '205', 'f', 'fx', 'fanxian');
INSERT INTO `region_areas` VALUES ('1384', '410927', '台前县', '205', 't', 'tqx', 'taiqianxian');
INSERT INTO `region_areas` VALUES ('1385', '410928', '濮阳县', '205', 'p', 'pyx', 'puyangxian');
INSERT INTO `region_areas` VALUES ('1386', '411002', '魏都区', '206', 'w', 'wdq', 'weidouqu');
INSERT INTO `region_areas` VALUES ('1387', '411023', '许昌县', '206', 'x', 'xcx', 'xuchangxian');
INSERT INTO `region_areas` VALUES ('1388', '411024', '鄢陵县', '206', 'y', 'ylx', 'yanlingxian');
INSERT INTO `region_areas` VALUES ('1389', '411025', '襄城县', '206', 'x', 'xcx', 'xiangchengxian');
INSERT INTO `region_areas` VALUES ('139', '130923', '东光县', '41', 'd', 'dgx', 'dongguangxian');
INSERT INTO `region_areas` VALUES ('1390', '411081', '禹州市', '206', 'y', 'yzs', 'yuzhoushi');
INSERT INTO `region_areas` VALUES ('1391', '411082', '长葛市', '206', 'z', 'zgs', 'zhanggeshi');
INSERT INTO `region_areas` VALUES ('1392', '411102', '源汇区', '207', 'y', 'yhq', 'yuanhuiqu');
INSERT INTO `region_areas` VALUES ('1393', '411103', '郾城区', '207', 'y', 'ycq', 'yanchengqu');
INSERT INTO `region_areas` VALUES ('1394', '411104', '召陵区', '207', 'z', 'zlq', 'zhaolingqu');
INSERT INTO `region_areas` VALUES ('1395', '411121', '舞阳县', '207', 'w', 'wyx', 'wuyangxian');
INSERT INTO `region_areas` VALUES ('1396', '411122', '临颍县', '207', 'l', 'lyx', 'linyingxian');
INSERT INTO `region_areas` VALUES ('1397', '411202', '湖滨区', '208', 'h', 'hbq', 'hubinqu');
INSERT INTO `region_areas` VALUES ('1398', '411221', '渑池县', '208', 'm', 'mcx', 'mianchixian');
INSERT INTO `region_areas` VALUES ('1399', '411222', '陕县', '208', 's', 'sx', 'shanxian');
INSERT INTO `region_areas` VALUES ('14', '130128', '深泽县', '33', 's', 'szx', 'shenzexian');
INSERT INTO `region_areas` VALUES ('140', '130924', '海兴县', '41', 'h', 'hxx', 'haixingxian');
INSERT INTO `region_areas` VALUES ('1400', '411224', '卢氏县', '208', 'l', 'lsx', 'lushixian');
INSERT INTO `region_areas` VALUES ('1401', '411281', '义马市', '208', 'y', 'yms', 'yimashi');
INSERT INTO `region_areas` VALUES ('1402', '411282', '灵宝市', '208', 'l', 'lbs', 'lingbaoshi');
INSERT INTO `region_areas` VALUES ('1403', '411302', '宛城区', '209', 'w', 'wcq', 'wanchengqu');
INSERT INTO `region_areas` VALUES ('1404', '411303', '卧龙区', '209', 'w', 'wlq', 'wolongqu');
INSERT INTO `region_areas` VALUES ('1405', '411321', '南召县', '209', 'n', 'nzx', 'nanzhaoxian');
INSERT INTO `region_areas` VALUES ('1406', '411322', '方城县', '209', 'f', 'fcx', 'fangchengxian');
INSERT INTO `region_areas` VALUES ('1407', '411323', '西峡县', '209', 'x', 'xxx', 'xixiaxian');
INSERT INTO `region_areas` VALUES ('1408', '411324', '镇平县', '209', 'z', 'zpx', 'zhenpingxian');
INSERT INTO `region_areas` VALUES ('1409', '411325', '内乡县', '209', 'n', 'nxx', 'neixiangxian');
INSERT INTO `region_areas` VALUES ('141', '130925', '盐山县', '41', 'y', 'ysx', 'yanshanxian');
INSERT INTO `region_areas` VALUES ('1410', '411326', '淅川县', '209', 'x', 'xcx', 'xichuanxian');
INSERT INTO `region_areas` VALUES ('1411', '411327', '社旗县', '209', 's', 'sqx', 'sheqixian');
INSERT INTO `region_areas` VALUES ('1412', '411328', '唐河县', '209', 't', 'thx', 'tanghexian');
INSERT INTO `region_areas` VALUES ('1413', '411329', '新野县', '209', 'x', 'xyx', 'xinyexian');
INSERT INTO `region_areas` VALUES ('1414', '411330', '桐柏县', '209', 't', 'tbx', 'tongboxian');
INSERT INTO `region_areas` VALUES ('1415', '411381', '邓州市', '209', 'd', 'dzs', 'dengzhoushi');
INSERT INTO `region_areas` VALUES ('1416', '411402', '梁园区', '210', 'l', 'lyq', 'liangyuanqu');
INSERT INTO `region_areas` VALUES ('1417', '411403', '睢阳区', '210', 's', 'syq', 'suiyangqu');
INSERT INTO `region_areas` VALUES ('1418', '411421', '民权县', '210', 'm', 'mqx', 'minquanxian');
INSERT INTO `region_areas` VALUES ('1419', '411422', '睢县', '210', 's', 'sx', 'suixian');
INSERT INTO `region_areas` VALUES ('142', '130926', '肃宁县', '41', 's', 'snx', 'suningxian');
INSERT INTO `region_areas` VALUES ('1420', '411423', '宁陵县', '210', 'n', 'nlx', 'ninglingxian');
INSERT INTO `region_areas` VALUES ('1421', '411424', '柘城县', '210', 'z', 'zcx', 'zhechengxian');
INSERT INTO `region_areas` VALUES ('1422', '411425', '虞城县', '210', 'y', 'ycx', 'yuchengxian');
INSERT INTO `region_areas` VALUES ('1423', '411426', '夏邑县', '210', 'x', 'xyx', 'xiayixian');
INSERT INTO `region_areas` VALUES ('1424', '411481', '永城市', '210', 'y', 'ycs', 'yongchengshi');
INSERT INTO `region_areas` VALUES ('1425', '411502', '浉河区', '211', 's', 'shq', 'shihequ');
INSERT INTO `region_areas` VALUES ('1426', '411503', '平桥区', '211', 'p', 'pqq', 'pingqiaoqu');
INSERT INTO `region_areas` VALUES ('1427', '411521', '罗山县', '211', 'l', 'lsx', 'luoshanxian');
INSERT INTO `region_areas` VALUES ('1428', '411522', '光山县', '211', 'g', 'gsx', 'guangshanxian');
INSERT INTO `region_areas` VALUES ('1429', '411523', '新县', '211', 'x', 'xx', 'xinxian');
INSERT INTO `region_areas` VALUES ('143', '130927', '南皮县', '41', 'n', 'npx', 'nanpixian');
INSERT INTO `region_areas` VALUES ('1430', '411524', '商城县', '211', 's', 'scx', 'shangchengxian');
INSERT INTO `region_areas` VALUES ('1431', '411525', '固始县', '211', 'g', 'gsx', 'gushixian');
INSERT INTO `region_areas` VALUES ('1432', '411526', '潢川县', '211', 'h', 'hcx', 'huangchuanxian');
INSERT INTO `region_areas` VALUES ('1433', '411527', '淮滨县', '211', 'h', 'hbx', 'huaibinxian');
INSERT INTO `region_areas` VALUES ('1434', '411528', '息县', '211', 'x', 'xx', 'xixian');
INSERT INTO `region_areas` VALUES ('1435', '411602', '川汇区', '212', 'c', 'chq', 'chuanhuiqu');
INSERT INTO `region_areas` VALUES ('1436', '411621', '扶沟县', '212', 'f', 'fgx', 'fugouxian');
INSERT INTO `region_areas` VALUES ('1437', '411622', '西华县', '212', 'x', 'xhx', 'xihuaxian');
INSERT INTO `region_areas` VALUES ('1438', '411623', '商水县', '212', 's', 'ssx', 'shangshuixian');
INSERT INTO `region_areas` VALUES ('1439', '411624', '沈丘县', '212', 's', 'sqx', 'shenqiuxian');
INSERT INTO `region_areas` VALUES ('144', '130928', '吴桥县', '41', 'w', 'wqx', 'wuqiaoxian');
INSERT INTO `region_areas` VALUES ('1440', '411625', '郸城县', '212', 'd', 'dcx', 'danchengxian');
INSERT INTO `region_areas` VALUES ('1441', '411626', '淮阳县', '212', 'h', 'hyx', 'huaiyangxian');
INSERT INTO `region_areas` VALUES ('1442', '411627', '太康县', '212', 't', 'tkx', 'taikangxian');
INSERT INTO `region_areas` VALUES ('1443', '411628', '鹿邑县', '212', 'l', 'lyx', 'luyixian');
INSERT INTO `region_areas` VALUES ('1444', '411681', '项城市', '212', 'x', 'xcs', 'xiangchengshi');
INSERT INTO `region_areas` VALUES ('1445', '411702', '驿城区', '213', 'y', 'ycq', 'yichengqu');
INSERT INTO `region_areas` VALUES ('1446', '411721', '西平县', '213', 'x', 'xpx', 'xipingxian');
INSERT INTO `region_areas` VALUES ('1447', '411722', '上蔡县', '213', 's', 'scx', 'shangcaixian');
INSERT INTO `region_areas` VALUES ('1448', '411723', '平舆县', '213', 'p', 'pyx', 'pingyuxian');
INSERT INTO `region_areas` VALUES ('1449', '411724', '正阳县', '213', 'z', 'zyx', 'zhengyangxian');
INSERT INTO `region_areas` VALUES ('145', '130929', '献县', '41', 'x', 'xx', 'xianxian');
INSERT INTO `region_areas` VALUES ('1450', '411725', '确山县', '213', 'q', 'qsx', 'queshanxian');
INSERT INTO `region_areas` VALUES ('1451', '411726', '泌阳县', '213', 'm', 'myx', 'miyangxian');
INSERT INTO `region_areas` VALUES ('1452', '411727', '汝南县', '213', 'r', 'rnx', 'runanxian');
INSERT INTO `region_areas` VALUES ('1453', '411728', '遂平县', '213', 's', 'spx', 'suipingxian');
INSERT INTO `region_areas` VALUES ('1454', '411729', '新蔡县', '213', 'x', 'xcx', 'xincaixian');
INSERT INTO `region_areas` VALUES ('1455', '419001', '济源市', '214', 'j', 'jys', 'jiyuanshi');
INSERT INTO `region_areas` VALUES ('1456', '420102', '江岸区', '215', 'j', 'jaq', 'jianganqu');
INSERT INTO `region_areas` VALUES ('1457', '420103', '江汉区', '215', 'j', 'jhq', 'jianghanqu');
INSERT INTO `region_areas` VALUES ('1458', '420104', '硚口区', '215', 'q', 'qkq', 'qiaokouqu');
INSERT INTO `region_areas` VALUES ('1459', '420105', '汉阳区', '215', 'h', 'hyq', 'hanyangqu');
INSERT INTO `region_areas` VALUES ('146', '130930', '孟村回族自治县', '41', 'm', 'mchzzzx', 'mengcunhuizuzizhixian');
INSERT INTO `region_areas` VALUES ('1460', '420106', '武昌区', '215', 'w', 'wcq', 'wuchangqu');
INSERT INTO `region_areas` VALUES ('1461', '420107', '青山区', '215', 'q', 'qsq', 'qingshanqu');
INSERT INTO `region_areas` VALUES ('1462', '420111', '洪山区', '215', 'h', 'hsq', 'hongshanqu');
INSERT INTO `region_areas` VALUES ('1463', '420112', '东西湖区', '215', 'd', 'dxhq', 'dongxihuqu');
INSERT INTO `region_areas` VALUES ('1464', '420113', '汉南区', '215', 'h', 'hnq', 'hannanqu');
INSERT INTO `region_areas` VALUES ('1465', '420114', '蔡甸区', '215', 'c', 'cdq', 'caidianqu');
INSERT INTO `region_areas` VALUES ('1466', '420115', '江夏区', '215', 'j', 'jxq', 'jiangxiaqu');
INSERT INTO `region_areas` VALUES ('1467', '420116', '黄陂区', '215', 'h', 'hpq', 'huangpoqu');
INSERT INTO `region_areas` VALUES ('1468', '420117', '新洲区', '215', 'x', 'xzq', 'xinzhouqu');
INSERT INTO `region_areas` VALUES ('1469', '420202', '黄石港区', '216', 'h', 'hsgq', 'huangshigangqu');
INSERT INTO `region_areas` VALUES ('147', '130981', '泊头市', '41', 'b', 'bts', 'botoushi');
INSERT INTO `region_areas` VALUES ('1470', '420203', '西塞山区', '216', 'x', 'xssq', 'xisaishanqu');
INSERT INTO `region_areas` VALUES ('1471', '420204', '下陆区', '216', 'x', 'xlq', 'xialuqu');
INSERT INTO `region_areas` VALUES ('1472', '420205', '铁山区', '216', 't', 'tsq', 'tieshanqu');
INSERT INTO `region_areas` VALUES ('1473', '420222', '阳新县', '216', 'y', 'yxx', 'yangxinxian');
INSERT INTO `region_areas` VALUES ('1474', '420281', '大冶市', '216', 'd', 'dys', 'dayeshi');
INSERT INTO `region_areas` VALUES ('1475', '420302', '茅箭区', '217', 'm', 'mjq', 'maojianqu');
INSERT INTO `region_areas` VALUES ('1476', '420303', '张湾区', '217', 'z', 'zwq', 'zhangwanqu');
INSERT INTO `region_areas` VALUES ('1477', '420304', '郧阳区', '217', 'y', 'yyq', 'yunyangqu');
INSERT INTO `region_areas` VALUES ('1478', '420322', '郧西县', '217', 'y', 'yxx', 'yunxixian');
INSERT INTO `region_areas` VALUES ('1479', '420323', '竹山县', '217', 'z', 'zsx', 'zhushanxian');
INSERT INTO `region_areas` VALUES ('148', '130982', '任丘市', '41', 'r', 'rqs', 'renqiushi');
INSERT INTO `region_areas` VALUES ('1480', '420324', '竹溪县', '217', 'z', 'zxx', 'zhuxixian');
INSERT INTO `region_areas` VALUES ('1481', '420325', '房县', '217', 'f', 'fx', 'fangxian');
INSERT INTO `region_areas` VALUES ('1482', '420381', '丹江口市', '217', 'd', 'djks', 'danjiangkoushi');
INSERT INTO `region_areas` VALUES ('1483', '420502', '西陵区', '218', 'x', 'xlq', 'xilingqu');
INSERT INTO `region_areas` VALUES ('1484', '420503', '伍家岗区', '218', 'w', 'wjgq', 'wujiagangqu');
INSERT INTO `region_areas` VALUES ('1485', '420504', '点军区', '218', 'd', 'djq', 'dianjunqu');
INSERT INTO `region_areas` VALUES ('1486', '420505', '猇亭区', '218', 'y', 'ytq', 'yaotingqu');
INSERT INTO `region_areas` VALUES ('1487', '420506', '夷陵区', '218', 'y', 'ylq', 'yilingqu');
INSERT INTO `region_areas` VALUES ('1488', '420525', '远安县', '218', 'y', 'yax', 'yuananxian');
INSERT INTO `region_areas` VALUES ('1489', '420526', '兴山县', '218', 'x', 'xsx', 'xingshanxian');
INSERT INTO `region_areas` VALUES ('149', '130983', '黄骅市', '41', 'h', 'hhs', 'huanghuashi');
INSERT INTO `region_areas` VALUES ('1490', '420527', '秭归县', '218', 'z', 'zgx', 'ziguixian');
INSERT INTO `region_areas` VALUES ('1491', '420528', '长阳土家族自治县', '218', 'z', 'zytjzzzx', 'zhangyangtujiazuzizhixian');
INSERT INTO `region_areas` VALUES ('1492', '420529', '五峰土家族自治县', '218', 'w', 'wftjzzzx', 'wufengtujiazuzizhixian');
INSERT INTO `region_areas` VALUES ('1493', '420581', '宜都市', '218', 'y', 'yds', 'yidoushi');
INSERT INTO `region_areas` VALUES ('1494', '420582', '当阳市', '218', 'd', 'dys', 'dangyangshi');
INSERT INTO `region_areas` VALUES ('1495', '420583', '枝江市', '218', 'z', 'zjs', 'zhijiangshi');
INSERT INTO `region_areas` VALUES ('1496', '420602', '襄城区', '219', 'x', 'xcq', 'xiangchengqu');
INSERT INTO `region_areas` VALUES ('1497', '420606', '樊城区', '219', 'f', 'fcq', 'fanchengqu');
INSERT INTO `region_areas` VALUES ('1498', '420607', '襄州区', '219', 'x', 'xzq', 'xiangzhouqu');
INSERT INTO `region_areas` VALUES ('1499', '420624', '南漳县', '219', 'n', 'nzx', 'nanzhangxian');
INSERT INTO `region_areas` VALUES ('15', '130129', '赞皇县', '33', 'z', 'zhx', 'zanhuangxian');
INSERT INTO `region_areas` VALUES ('150', '130984', '河间市', '41', 'h', 'hjs', 'hejianshi');
INSERT INTO `region_areas` VALUES ('1500', '420625', '谷城县', '219', 'g', 'gcx', 'guchengxian');
INSERT INTO `region_areas` VALUES ('1501', '420626', '保康县', '219', 'b', 'bkx', 'baokangxian');
INSERT INTO `region_areas` VALUES ('1502', '420682', '老河口市', '219', 'l', 'lhks', 'laohekoushi');
INSERT INTO `region_areas` VALUES ('1503', '420683', '枣阳市', '219', 'z', 'zys', 'zaoyangshi');
INSERT INTO `region_areas` VALUES ('1504', '420684', '宜城市', '219', 'y', 'ycs', 'yichengshi');
INSERT INTO `region_areas` VALUES ('1505', '420702', '梁子湖区', '220', 'l', 'lzhq', 'liangzihuqu');
INSERT INTO `region_areas` VALUES ('1506', '420703', '华容区', '220', 'h', 'hrq', 'huarongqu');
INSERT INTO `region_areas` VALUES ('1507', '420704', '鄂城区', '220', 'e', 'ecq', 'echengqu');
INSERT INTO `region_areas` VALUES ('1508', '420802', '东宝区', '221', 'd', 'dbq', 'dongbaoqu');
INSERT INTO `region_areas` VALUES ('1509', '420804', '掇刀区', '221', 'd', 'ddq', 'duodaoqu');
INSERT INTO `region_areas` VALUES ('151', '131002', '安次区', '42', 'a', 'acq', 'anciqu');
INSERT INTO `region_areas` VALUES ('1510', '420821', '京山县', '221', 'j', 'jsx', 'jingshanxian');
INSERT INTO `region_areas` VALUES ('1511', '420822', '沙洋县', '221', 's', 'syx', 'shayangxian');
INSERT INTO `region_areas` VALUES ('1512', '420881', '钟祥市', '221', 'z', 'zxs', 'zhongxiangshi');
INSERT INTO `region_areas` VALUES ('1513', '420902', '孝南区', '222', 'x', 'xnq', 'xiaonanqu');
INSERT INTO `region_areas` VALUES ('1514', '420921', '孝昌县', '222', 'x', 'xcx', 'xiaochangxian');
INSERT INTO `region_areas` VALUES ('1515', '420922', '大悟县', '222', 'd', 'dwx', 'dawuxian');
INSERT INTO `region_areas` VALUES ('1516', '420923', '云梦县', '222', 'y', 'ymx', 'yunmengxian');
INSERT INTO `region_areas` VALUES ('1517', '420981', '应城市', '222', 'y', 'ycs', 'yingchengshi');
INSERT INTO `region_areas` VALUES ('1518', '420982', '安陆市', '222', 'a', 'als', 'anlushi');
INSERT INTO `region_areas` VALUES ('1519', '420984', '汉川市', '222', 'h', 'hcs', 'hanchuanshi');
INSERT INTO `region_areas` VALUES ('152', '131003', '广阳区', '42', 'g', 'gyq', 'guangyangqu');
INSERT INTO `region_areas` VALUES ('1520', '421002', '沙市区', '223', 's', 'ssq', 'shashiqu');
INSERT INTO `region_areas` VALUES ('1521', '421003', '荆州区', '223', 'j', 'jzq', 'jingzhouqu');
INSERT INTO `region_areas` VALUES ('1522', '421022', '公安县', '223', 'g', 'gax', 'gonganxian');
INSERT INTO `region_areas` VALUES ('1523', '421023', '监利县', '223', 'j', 'jlx', 'jianlixian');
INSERT INTO `region_areas` VALUES ('1524', '421024', '江陵县', '223', 'j', 'jlx', 'jianglingxian');
INSERT INTO `region_areas` VALUES ('1525', '421081', '石首市', '223', 's', 'sss', 'shishoushi');
INSERT INTO `region_areas` VALUES ('1526', '421083', '洪湖市', '223', 'h', 'hhs', 'honghushi');
INSERT INTO `region_areas` VALUES ('1527', '421087', '松滋市', '223', 's', 'szs', 'songzishi');
INSERT INTO `region_areas` VALUES ('1528', '421102', '黄州区', '224', 'h', 'hzq', 'huangzhouqu');
INSERT INTO `region_areas` VALUES ('1529', '421121', '团风县', '224', 't', 'tfx', 'tuanfengxian');
INSERT INTO `region_areas` VALUES ('153', '131022', '固安县', '42', 'g', 'gax', 'guanxian');
INSERT INTO `region_areas` VALUES ('1530', '421122', '红安县', '224', 'h', 'hax', 'honganxian');
INSERT INTO `region_areas` VALUES ('1531', '421123', '罗田县', '224', 'l', 'ltx', 'luotianxian');
INSERT INTO `region_areas` VALUES ('1532', '421124', '英山县', '224', 'y', 'ysx', 'yingshanxian');
INSERT INTO `region_areas` VALUES ('1533', '421125', '浠水县', '224', 'x', 'xsx', 'xishuixian');
INSERT INTO `region_areas` VALUES ('1534', '421126', '蕲春县', '224', 'q', 'qcx', 'qichunxian');
INSERT INTO `region_areas` VALUES ('1535', '421127', '黄梅县', '224', 'h', 'hmx', 'huangmeixian');
INSERT INTO `region_areas` VALUES ('1536', '421181', '麻城市', '224', 'm', 'mcs', 'machengshi');
INSERT INTO `region_areas` VALUES ('1537', '421182', '武穴市', '224', 'w', 'wxs', 'wuxueshi');
INSERT INTO `region_areas` VALUES ('1538', '421202', '咸安区', '225', 'x', 'xaq', 'xiananqu');
INSERT INTO `region_areas` VALUES ('1539', '421221', '嘉鱼县', '225', 'j', 'jyx', 'jiayuxian');
INSERT INTO `region_areas` VALUES ('154', '131023', '永清县', '42', 'y', 'yqx', 'yongqingxian');
INSERT INTO `region_areas` VALUES ('1540', '421222', '通城县', '225', 't', 'tcx', 'tongchengxian');
INSERT INTO `region_areas` VALUES ('1541', '421223', '崇阳县', '225', 'c', 'cyx', 'chongyangxian');
INSERT INTO `region_areas` VALUES ('1542', '421224', '通山县', '225', 't', 'tsx', 'tongshanxian');
INSERT INTO `region_areas` VALUES ('1543', '421281', '赤壁市', '225', 'c', 'cbs', 'chibishi');
INSERT INTO `region_areas` VALUES ('1544', '421303', '曾都区', '226', 'c', 'cdq', 'cengdouqu');
INSERT INTO `region_areas` VALUES ('1545', '421321', '随县', '226', 's', 'sx', 'suixian');
INSERT INTO `region_areas` VALUES ('1546', '421381', '广水市', '226', 'g', 'gss', 'guangshuishi');
INSERT INTO `region_areas` VALUES ('1547', '422801', '恩施市', '227', 'e', 'ess', 'enshishi');
INSERT INTO `region_areas` VALUES ('1548', '422802', '利川市', '227', 'l', 'lcs', 'lichuanshi');
INSERT INTO `region_areas` VALUES ('1549', '422822', '建始县', '227', 'j', 'jsx', 'jianshixian');
INSERT INTO `region_areas` VALUES ('155', '131024', '香河县', '42', 'x', 'xhx', 'xianghexian');
INSERT INTO `region_areas` VALUES ('1550', '422823', '巴东县', '227', 'b', 'bdx', 'badongxian');
INSERT INTO `region_areas` VALUES ('1551', '422825', '宣恩县', '227', 'x', 'xex', 'xuanenxian');
INSERT INTO `region_areas` VALUES ('1552', '422826', '咸丰县', '227', 'x', 'xfx', 'xianfengxian');
INSERT INTO `region_areas` VALUES ('1553', '422827', '来凤县', '227', 'l', 'lfx', 'laifengxian');
INSERT INTO `region_areas` VALUES ('1554', '422828', '鹤峰县', '227', 'h', 'hfx', 'hefengxian');
INSERT INTO `region_areas` VALUES ('1555', '429004', '仙桃市', '228', 'x', 'xts', 'xiantaoshi');
INSERT INTO `region_areas` VALUES ('1556', '429005', '潜江市', '228', 'q', 'qjs', 'qianjiangshi');
INSERT INTO `region_areas` VALUES ('1557', '429006', '天门市', '228', 't', 'tms', 'tianmenshi');
INSERT INTO `region_areas` VALUES ('1558', '429021', '神农架林区', '228', 's', 'snjlq', 'shennongjialinqu');
INSERT INTO `region_areas` VALUES ('1559', '430102', '芙蓉区', '229', 'f', 'frq', 'furongqu');
INSERT INTO `region_areas` VALUES ('156', '131025', '大城县', '42', 'd', 'dcx', 'dachengxian');
INSERT INTO `region_areas` VALUES ('1560', '430103', '天心区', '229', 't', 'txq', 'tianxinqu');
INSERT INTO `region_areas` VALUES ('1561', '430104', '岳麓区', '229', 'y', 'ylq', 'yueluqu');
INSERT INTO `region_areas` VALUES ('1562', '430105', '开福区', '229', 'k', 'kfq', 'kaifuqu');
INSERT INTO `region_areas` VALUES ('1563', '430111', '雨花区', '229', 'y', 'yhq', 'yuhuaqu');
INSERT INTO `region_areas` VALUES ('1564', '430112', '望城区', '229', 'w', 'wcq', 'wangchengqu');
INSERT INTO `region_areas` VALUES ('1565', '430121', '长沙县', '229', 'z', 'zsx', 'zhangshaxian');
INSERT INTO `region_areas` VALUES ('1566', '430124', '宁乡县', '229', 'n', 'nxx', 'ningxiangxian');
INSERT INTO `region_areas` VALUES ('1567', '430181', '浏阳市', '229', 'l', 'lys', 'liuyangshi');
INSERT INTO `region_areas` VALUES ('1568', '430202', '荷塘区', '230', 'h', 'htq', 'hetangqu');
INSERT INTO `region_areas` VALUES ('1569', '430203', '芦淞区', '230', 'l', 'lsq', 'lusongqu');
INSERT INTO `region_areas` VALUES ('157', '131026', '文安县', '42', 'w', 'wax', 'wenanxian');
INSERT INTO `region_areas` VALUES ('1570', '430204', '石峰区', '230', 's', 'sfq', 'shifengqu');
INSERT INTO `region_areas` VALUES ('1571', '430211', '天元区', '230', 't', 'tyq', 'tianyuanqu');
INSERT INTO `region_areas` VALUES ('1572', '430221', '株洲县', '230', 'z', 'zzx', 'zhuzhouxian');
INSERT INTO `region_areas` VALUES ('1573', '430223', '攸县', '230', 'y', 'yx', 'youxian');
INSERT INTO `region_areas` VALUES ('1574', '430224', '茶陵县', '230', 'c', 'clx', 'chalingxian');
INSERT INTO `region_areas` VALUES ('1575', '430225', '炎陵县', '230', 'y', 'ylx', 'yanlingxian');
INSERT INTO `region_areas` VALUES ('1576', '430281', '醴陵市', '230', 'l', 'lls', 'lilingshi');
INSERT INTO `region_areas` VALUES ('1577', '430302', '雨湖区', '231', 'y', 'yhq', 'yuhuqu');
INSERT INTO `region_areas` VALUES ('1578', '430304', '岳塘区', '231', 'y', 'ytq', 'yuetangqu');
INSERT INTO `region_areas` VALUES ('1579', '430321', '湘潭县', '231', 'x', 'xtx', 'xiangtanxian');
INSERT INTO `region_areas` VALUES ('158', '131028', '大厂回族自治县', '42', 'd', 'dchzzzx', 'dachanghuizuzizhixian');
INSERT INTO `region_areas` VALUES ('1580', '430381', '湘乡市', '231', 'x', 'xxs', 'xiangxiangshi');
INSERT INTO `region_areas` VALUES ('1581', '430382', '韶山市', '231', 's', 'sss', 'shaoshanshi');
INSERT INTO `region_areas` VALUES ('1582', '430405', '珠晖区', '232', 'z', 'zhq', 'zhuhuiqu');
INSERT INTO `region_areas` VALUES ('1583', '430406', '雁峰区', '232', 'y', 'yfq', 'yanfengqu');
INSERT INTO `region_areas` VALUES ('1584', '430407', '石鼓区', '232', 's', 'sgq', 'shiguqu');
INSERT INTO `region_areas` VALUES ('1585', '430408', '蒸湘区', '232', 'z', 'zxq', 'zhengxiangqu');
INSERT INTO `region_areas` VALUES ('1586', '430412', '南岳区', '232', 'n', 'nyq', 'nanyuequ');
INSERT INTO `region_areas` VALUES ('1587', '430421', '衡阳县', '232', 'h', 'hyx', 'hengyangxian');
INSERT INTO `region_areas` VALUES ('1588', '430422', '衡南县', '232', 'h', 'hnx', 'hengnanxian');
INSERT INTO `region_areas` VALUES ('1589', '430423', '衡山县', '232', 'h', 'hsx', 'hengshanxian');
INSERT INTO `region_areas` VALUES ('159', '131081', '霸州市', '42', 'b', 'bzs', 'bazhoushi');
INSERT INTO `region_areas` VALUES ('1590', '430424', '衡东县', '232', 'h', 'hdx', 'hengdongxian');
INSERT INTO `region_areas` VALUES ('1591', '430426', '祁东县', '232', 'q', 'qdx', 'qidongxian');
INSERT INTO `region_areas` VALUES ('1592', '430481', '耒阳市', '232', 'l', 'lys', 'leiyangshi');
INSERT INTO `region_areas` VALUES ('1593', '430482', '常宁市', '232', 'c', 'cns', 'changningshi');
INSERT INTO `region_areas` VALUES ('1594', '430502', '双清区', '233', 's', 'sqq', 'shuangqingqu');
INSERT INTO `region_areas` VALUES ('1595', '430503', '大祥区', '233', 'd', 'dxq', 'daxiangqu');
INSERT INTO `region_areas` VALUES ('1596', '430511', '北塔区', '233', 'b', 'btq', 'beitaqu');
INSERT INTO `region_areas` VALUES ('1597', '430521', '邵东县', '233', 's', 'sdx', 'shaodongxian');
INSERT INTO `region_areas` VALUES ('1598', '430522', '新邵县', '233', 'x', 'xsx', 'xinshaoxian');
INSERT INTO `region_areas` VALUES ('1599', '430523', '邵阳县', '233', 's', 'syx', 'shaoyangxian');
INSERT INTO `region_areas` VALUES ('16', '130130', '无极县', '33', 'w', 'wjx', 'wujixian');
INSERT INTO `region_areas` VALUES ('160', '131082', '三河市', '42', 's', 'shs', 'sanheshi');
INSERT INTO `region_areas` VALUES ('1600', '430524', '隆回县', '233', 'l', 'lhx', 'longhuixian');
INSERT INTO `region_areas` VALUES ('1601', '430525', '洞口县', '233', 'd', 'dkx', 'dongkouxian');
INSERT INTO `region_areas` VALUES ('1602', '430527', '绥宁县', '233', 's', 'snx', 'suiningxian');
INSERT INTO `region_areas` VALUES ('1603', '430528', '新宁县', '233', 'x', 'xnx', 'xinningxian');
INSERT INTO `region_areas` VALUES ('1604', '430529', '城步苗族自治县', '233', 'c', 'cbmzzzx', 'chengbumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1605', '430581', '武冈市', '233', 'w', 'wgs', 'wugangshi');
INSERT INTO `region_areas` VALUES ('1606', '430602', '岳阳楼区', '234', 'y', 'yylq', 'yueyanglouqu');
INSERT INTO `region_areas` VALUES ('1607', '430603', '云溪区', '234', 'y', 'yxq', 'yunxiqu');
INSERT INTO `region_areas` VALUES ('1608', '430611', '君山区', '234', 'j', 'jsq', 'junshanqu');
INSERT INTO `region_areas` VALUES ('1609', '430621', '岳阳县', '234', 'y', 'yyx', 'yueyangxian');
INSERT INTO `region_areas` VALUES ('161', '131102', '桃城区', '43', 't', 'tcq', 'taochengqu');
INSERT INTO `region_areas` VALUES ('1610', '430623', '华容县', '234', 'h', 'hrx', 'huarongxian');
INSERT INTO `region_areas` VALUES ('1611', '430624', '湘阴县', '234', 'x', 'xyx', 'xiangyinxian');
INSERT INTO `region_areas` VALUES ('1612', '430626', '平江县', '234', 'p', 'pjx', 'pingjiangxian');
INSERT INTO `region_areas` VALUES ('1613', '430681', '汨罗市', '234', 'm', 'mls', 'miluoshi');
INSERT INTO `region_areas` VALUES ('1614', '430682', '临湘市', '234', 'l', 'lxs', 'linxiangshi');
INSERT INTO `region_areas` VALUES ('1615', '430702', '武陵区', '235', 'w', 'wlq', 'wulingqu');
INSERT INTO `region_areas` VALUES ('1616', '430703', '鼎城区', '235', 'd', 'dcq', 'dingchengqu');
INSERT INTO `region_areas` VALUES ('1617', '430721', '安乡县', '235', 'a', 'axx', 'anxiangxian');
INSERT INTO `region_areas` VALUES ('1618', '430722', '汉寿县', '235', 'h', 'hsx', 'hanshouxian');
INSERT INTO `region_areas` VALUES ('1619', '430723', '澧县', '235', 'l', 'lx', 'lixian');
INSERT INTO `region_areas` VALUES ('162', '131121', '枣强县', '43', 'z', 'zqx', 'zaoqiangxian');
INSERT INTO `region_areas` VALUES ('1620', '430724', '临澧县', '235', 'l', 'llx', 'linlixian');
INSERT INTO `region_areas` VALUES ('1621', '430725', '桃源县', '235', 't', 'tyx', 'taoyuanxian');
INSERT INTO `region_areas` VALUES ('1622', '430726', '石门县', '235', 's', 'smx', 'shimenxian');
INSERT INTO `region_areas` VALUES ('1623', '430781', '津市市', '235', 'j', 'jss', 'jinshishi');
INSERT INTO `region_areas` VALUES ('1624', '430802', '永定区', '236', 'y', 'ydq', 'yongdingqu');
INSERT INTO `region_areas` VALUES ('1625', '430811', '武陵源区', '236', 'w', 'wlyq', 'wulingyuanqu');
INSERT INTO `region_areas` VALUES ('1626', '430821', '慈利县', '236', 'c', 'clx', 'cilixian');
INSERT INTO `region_areas` VALUES ('1627', '430822', '桑植县', '236', 's', 'szx', 'sangzhixian');
INSERT INTO `region_areas` VALUES ('1628', '430902', '资阳区', '237', 'z', 'zyq', 'ziyangqu');
INSERT INTO `region_areas` VALUES ('1629', '430903', '赫山区', '237', 'h', 'hsq', 'heshanqu');
INSERT INTO `region_areas` VALUES ('163', '131122', '武邑县', '43', 'w', 'wyx', 'wuyixian');
INSERT INTO `region_areas` VALUES ('1630', '430921', '南县', '237', 'n', 'nx', 'nanxian');
INSERT INTO `region_areas` VALUES ('1631', '430922', '桃江县', '237', 't', 'tjx', 'taojiangxian');
INSERT INTO `region_areas` VALUES ('1632', '430923', '安化县', '237', 'a', 'ahx', 'anhuaxian');
INSERT INTO `region_areas` VALUES ('1633', '430981', '沅江市', '237', 'y', 'yjs', 'yuanjiangshi');
INSERT INTO `region_areas` VALUES ('1634', '431002', '北湖区', '238', 'b', 'bhq', 'beihuqu');
INSERT INTO `region_areas` VALUES ('1635', '431003', '苏仙区', '238', 's', 'sxq', 'suxianqu');
INSERT INTO `region_areas` VALUES ('1636', '431021', '桂阳县', '238', 'g', 'gyx', 'guiyangxian');
INSERT INTO `region_areas` VALUES ('1637', '431022', '宜章县', '238', 'y', 'yzx', 'yizhangxian');
INSERT INTO `region_areas` VALUES ('1638', '431023', '永兴县', '238', 'y', 'yxx', 'yongxingxian');
INSERT INTO `region_areas` VALUES ('1639', '431024', '嘉禾县', '238', 'j', 'jhx', 'jiahexian');
INSERT INTO `region_areas` VALUES ('164', '131123', '武强县', '43', 'w', 'wqx', 'wuqiangxian');
INSERT INTO `region_areas` VALUES ('1640', '431025', '临武县', '238', 'l', 'lwx', 'linwuxian');
INSERT INTO `region_areas` VALUES ('1641', '431026', '汝城县', '238', 'r', 'rcx', 'ruchengxian');
INSERT INTO `region_areas` VALUES ('1642', '431027', '桂东县', '238', 'g', 'gdx', 'guidongxian');
INSERT INTO `region_areas` VALUES ('1643', '431028', '安仁县', '238', 'a', 'arx', 'anrenxian');
INSERT INTO `region_areas` VALUES ('1644', '431081', '资兴市', '238', 'z', 'zxs', 'zixingshi');
INSERT INTO `region_areas` VALUES ('1645', '431102', '零陵区', '239', 'l', 'llq', 'linglingqu');
INSERT INTO `region_areas` VALUES ('1646', '431103', '冷水滩区', '239', 'l', 'lstq', 'lengshuitanqu');
INSERT INTO `region_areas` VALUES ('1647', '431121', '祁阳县', '239', 'q', 'qyx', 'qiyangxian');
INSERT INTO `region_areas` VALUES ('1648', '431122', '东安县', '239', 'd', 'dax', 'donganxian');
INSERT INTO `region_areas` VALUES ('1649', '431123', '双牌县', '239', 's', 'spx', 'shuangpaixian');
INSERT INTO `region_areas` VALUES ('165', '131124', '饶阳县', '43', 'r', 'ryx', 'raoyangxian');
INSERT INTO `region_areas` VALUES ('1650', '431124', '道县', '239', 'd', 'dx', 'daoxian');
INSERT INTO `region_areas` VALUES ('1651', '431125', '江永县', '239', 'j', 'jyx', 'jiangyongxian');
INSERT INTO `region_areas` VALUES ('1652', '431126', '宁远县', '239', 'n', 'nyx', 'ningyuanxian');
INSERT INTO `region_areas` VALUES ('1653', '431127', '蓝山县', '239', 'l', 'lsx', 'lanshanxian');
INSERT INTO `region_areas` VALUES ('1654', '431128', '新田县', '239', 'x', 'xtx', 'xintianxian');
INSERT INTO `region_areas` VALUES ('1655', '431129', '江华瑶族自治县', '239', 'j', 'jhyzzzx', 'jianghuayaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1656', '431202', '鹤城区', '240', 'h', 'hcq', 'hechengqu');
INSERT INTO `region_areas` VALUES ('1657', '431221', '中方县', '240', 'z', 'zfx', 'zhongfangxian');
INSERT INTO `region_areas` VALUES ('1658', '431222', '沅陵县', '240', 'y', 'ylx', 'yuanlingxian');
INSERT INTO `region_areas` VALUES ('1659', '431223', '辰溪县', '240', 'c', 'cxx', 'chenxixian');
INSERT INTO `region_areas` VALUES ('166', '131125', '安平县', '43', 'a', 'apx', 'anpingxian');
INSERT INTO `region_areas` VALUES ('1660', '431224', '溆浦县', '240', 'x', 'xpx', 'xupuxian');
INSERT INTO `region_areas` VALUES ('1661', '431225', '会同县', '240', 'h', 'htx', 'huitongxian');
INSERT INTO `region_areas` VALUES ('1662', '431226', '麻阳苗族自治县', '240', 'm', 'mymzzzx', 'mayangmiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1663', '431227', '新晃侗族自治县', '240', 'x', 'xhdzzzx', 'xinhuangdongzuzizhixian');
INSERT INTO `region_areas` VALUES ('1664', '431228', '芷江侗族自治县', '240', 'z', 'zjdzzzx', 'zhijiangdongzuzizhixian');
INSERT INTO `region_areas` VALUES ('1665', '431229', '靖州苗族侗族自治县', '240', 'j', 'jzmzdzzzx', 'jingzhoumiaozudongzuzizhixian');
INSERT INTO `region_areas` VALUES ('1666', '431230', '通道侗族自治县', '240', 't', 'tddzzzx', 'tongdaodongzuzizhixian');
INSERT INTO `region_areas` VALUES ('1667', '431281', '洪江市', '240', 'h', 'hjs', 'hongjiangshi');
INSERT INTO `region_areas` VALUES ('1668', '431302', '娄星区', '241', 'l', 'lxq', 'louxingqu');
INSERT INTO `region_areas` VALUES ('1669', '431321', '双峰县', '241', 's', 'sfx', 'shuangfengxian');
INSERT INTO `region_areas` VALUES ('167', '131126', '故城县', '43', 'g', 'gcx', 'guchengxian');
INSERT INTO `region_areas` VALUES ('1670', '431322', '新化县', '241', 'x', 'xhx', 'xinhuaxian');
INSERT INTO `region_areas` VALUES ('1671', '431381', '冷水江市', '241', 'l', 'lsjs', 'lengshuijiangshi');
INSERT INTO `region_areas` VALUES ('1672', '431382', '涟源市', '241', 'l', 'lys', 'lianyuanshi');
INSERT INTO `region_areas` VALUES ('1673', '433101', '吉首市', '242', 'j', 'jss', 'jishoushi');
INSERT INTO `region_areas` VALUES ('1674', '433122', '泸溪县', '242', 'l', 'lxx', 'luxixian');
INSERT INTO `region_areas` VALUES ('1675', '433123', '凤凰县', '242', 'f', 'fhx', 'fenghuangxian');
INSERT INTO `region_areas` VALUES ('1676', '433124', '花垣县', '242', 'h', 'hyx', 'huayuanxian');
INSERT INTO `region_areas` VALUES ('1677', '433125', '保靖县', '242', 'b', 'bjx', 'baojingxian');
INSERT INTO `region_areas` VALUES ('1678', '433126', '古丈县', '242', 'g', 'gzx', 'guzhangxian');
INSERT INTO `region_areas` VALUES ('1679', '433127', '永顺县', '242', 'y', 'ysx', 'yongshunxian');
INSERT INTO `region_areas` VALUES ('168', '131127', '景县', '43', 'j', 'jx', 'jingxian');
INSERT INTO `region_areas` VALUES ('1680', '433130', '龙山县', '242', 'l', 'lsx', 'longshanxian');
INSERT INTO `region_areas` VALUES ('1681', '440103', '荔湾区', '243', 'l', 'lwq', 'liwanqu');
INSERT INTO `region_areas` VALUES ('1682', '440104', '越秀区', '243', 'y', 'yxq', 'yuexiuqu');
INSERT INTO `region_areas` VALUES ('1683', '440105', '海珠区', '243', 'h', 'hzq', 'haizhuqu');
INSERT INTO `region_areas` VALUES ('1684', '440106', '天河区', '243', 't', 'thq', 'tianhequ');
INSERT INTO `region_areas` VALUES ('1685', '440111', '白云区', '243', 'b', 'byq', 'baiyunqu');
INSERT INTO `region_areas` VALUES ('1686', '440112', '黄埔区', '243', 'h', 'hpq', 'huangpuqu');
INSERT INTO `region_areas` VALUES ('1687', '440113', '番禺区', '243', 'f', 'fyq', 'fanyuqu');
INSERT INTO `region_areas` VALUES ('1688', '440114', '花都区', '243', 'h', 'hdq', 'huadouqu');
INSERT INTO `region_areas` VALUES ('1689', '440115', '南沙区', '243', 'n', 'nsq', 'nanshaqu');
INSERT INTO `region_areas` VALUES ('169', '131128', '阜城县', '43', 'f', 'fcx', 'fuchengxian');
INSERT INTO `region_areas` VALUES ('1690', '440116', '萝岗区', '243', 'l', 'lgq', 'luogangqu');
INSERT INTO `region_areas` VALUES ('1691', '440117', '从化区', '243', 'c', 'chq', 'conghuaqu');
INSERT INTO `region_areas` VALUES ('1692', '440118', '增城区', '243', 'z', 'zcq', 'zengchengqu');
INSERT INTO `region_areas` VALUES ('1693', '440203', '武江区', '244', 'w', 'wjq', 'wujiangqu');
INSERT INTO `region_areas` VALUES ('1694', '440204', '浈江区', '244', 'z', 'zjq', 'zhenjiangqu');
INSERT INTO `region_areas` VALUES ('1695', '440205', '曲江区', '244', 'q', 'qjq', 'qujiangqu');
INSERT INTO `region_areas` VALUES ('1696', '440222', '始兴县', '244', 's', 'sxx', 'shixingxian');
INSERT INTO `region_areas` VALUES ('1697', '440224', '仁化县', '244', 'r', 'rhx', 'renhuaxian');
INSERT INTO `region_areas` VALUES ('1698', '440229', '翁源县', '244', 'w', 'wyx', 'wengyuanxian');
INSERT INTO `region_areas` VALUES ('1699', '440232', '乳源瑶族自治县', '244', 'r', 'ryyzzzx', 'ruyuanyaozuzizhixian');
INSERT INTO `region_areas` VALUES ('17', '130131', '平山县', '33', 'p', 'psx', 'pingshanxian');
INSERT INTO `region_areas` VALUES ('170', '131181', '冀州市', '43', 'j', 'jzs', 'jizhoushi');
INSERT INTO `region_areas` VALUES ('1700', '440233', '新丰县', '244', 'x', 'xfx', 'xinfengxian');
INSERT INTO `region_areas` VALUES ('1701', '440281', '乐昌市', '244', 'l', 'lcs', 'lechangshi');
INSERT INTO `region_areas` VALUES ('1702', '440282', '南雄市', '244', 'n', 'nxs', 'nanxiongshi');
INSERT INTO `region_areas` VALUES ('1703', '440303', '罗湖区', '245', 'l', 'lhq', 'luohuqu');
INSERT INTO `region_areas` VALUES ('1704', '440304', '福田区', '245', 'f', 'ftq', 'futianqu');
INSERT INTO `region_areas` VALUES ('1705', '440305', '南山区', '245', 'n', 'nsq', 'nanshanqu');
INSERT INTO `region_areas` VALUES ('1706', '440306', '宝安区', '245', 'b', 'baq', 'baoanqu');
INSERT INTO `region_areas` VALUES ('1707', '440307', '龙岗区', '245', 'l', 'lgq', 'longgangqu');
INSERT INTO `region_areas` VALUES ('1708', '440308', '盐田区', '245', 'y', 'ytq', 'yantianqu');
INSERT INTO `region_areas` VALUES ('1709', '440402', '香洲区', '246', 'x', 'xzq', 'xiangzhouqu');
INSERT INTO `region_areas` VALUES ('171', '131182', '深州市', '43', 's', 'szs', 'shenzhoushi');
INSERT INTO `region_areas` VALUES ('1710', '440403', '斗门区', '246', 'd', 'dmq', 'doumenqu');
INSERT INTO `region_areas` VALUES ('1711', '440404', '金湾区', '246', 'j', 'jwq', 'jinwanqu');
INSERT INTO `region_areas` VALUES ('1712', '440507', '龙湖区', '247', 'l', 'lhq', 'longhuqu');
INSERT INTO `region_areas` VALUES ('1713', '440511', '金平区', '247', 'j', 'jpq', 'jinpingqu');
INSERT INTO `region_areas` VALUES ('1714', '440512', '濠江区', '247', 'h', 'hjq', 'haojiangqu');
INSERT INTO `region_areas` VALUES ('1715', '440513', '潮阳区', '247', 'c', 'cyq', 'chaoyangqu');
INSERT INTO `region_areas` VALUES ('1716', '440514', '潮南区', '247', 'c', 'cnq', 'chaonanqu');
INSERT INTO `region_areas` VALUES ('1717', '440515', '澄海区', '247', 'c', 'chq', 'chenghaiqu');
INSERT INTO `region_areas` VALUES ('1718', '440523', '南澳县', '247', 'n', 'nax', 'nanaoxian');
INSERT INTO `region_areas` VALUES ('1719', '440604', '禅城区', '248', 's', 'scq', 'shanchengqu');
INSERT INTO `region_areas` VALUES ('172', '140105', '小店区', '44', 'x', 'xdq', 'xiaodianqu');
INSERT INTO `region_areas` VALUES ('1720', '440605', '南海区', '248', 'n', 'nhq', 'nanhaiqu');
INSERT INTO `region_areas` VALUES ('1721', '440606', '顺德区', '248', 's', 'sdq', 'shundequ');
INSERT INTO `region_areas` VALUES ('1722', '440607', '三水区', '248', 's', 'ssq', 'sanshuiqu');
INSERT INTO `region_areas` VALUES ('1723', '440608', '高明区', '248', 'g', 'gmq', 'gaomingqu');
INSERT INTO `region_areas` VALUES ('1724', '440703', '蓬江区', '249', 'p', 'pjq', 'pengjiangqu');
INSERT INTO `region_areas` VALUES ('1725', '440704', '江海区', '249', 'j', 'jhq', 'jianghaiqu');
INSERT INTO `region_areas` VALUES ('1726', '440705', '新会区', '249', 'x', 'xhq', 'xinhuiqu');
INSERT INTO `region_areas` VALUES ('1727', '440781', '台山市', '249', 't', 'tss', 'taishanshi');
INSERT INTO `region_areas` VALUES ('1728', '440783', '开平市', '249', 'k', 'kps', 'kaipingshi');
INSERT INTO `region_areas` VALUES ('1729', '440784', '鹤山市', '249', 'h', 'hss', 'heshanshi');
INSERT INTO `region_areas` VALUES ('173', '140106', '迎泽区', '44', 'y', 'yzq', 'yingzequ');
INSERT INTO `region_areas` VALUES ('1730', '440785', '恩平市', '249', 'e', 'eps', 'enpingshi');
INSERT INTO `region_areas` VALUES ('1731', '440802', '赤坎区', '250', 'c', 'ckq', 'chikanqu');
INSERT INTO `region_areas` VALUES ('1732', '440803', '霞山区', '250', 'x', 'xsq', 'xiashanqu');
INSERT INTO `region_areas` VALUES ('1733', '440804', '坡头区', '250', 'p', 'ptq', 'potouqu');
INSERT INTO `region_areas` VALUES ('1734', '440811', '麻章区', '250', 'm', 'mzq', 'mazhangqu');
INSERT INTO `region_areas` VALUES ('1735', '440823', '遂溪县', '250', 's', 'sxx', 'suixixian');
INSERT INTO `region_areas` VALUES ('1736', '440825', '徐闻县', '250', 'x', 'xwx', 'xuwenxian');
INSERT INTO `region_areas` VALUES ('1737', '440881', '廉江市', '250', 'l', 'ljs', 'lianjiangshi');
INSERT INTO `region_areas` VALUES ('1738', '440882', '雷州市', '250', 'l', 'lzs', 'leizhoushi');
INSERT INTO `region_areas` VALUES ('1739', '440883', '吴川市', '250', 'w', 'wcs', 'wuchuanshi');
INSERT INTO `region_areas` VALUES ('174', '140107', '杏花岭区', '44', 'x', 'xhlq', 'xinghualingqu');
INSERT INTO `region_areas` VALUES ('1740', '440902', '茂南区', '251', 'm', 'mnq', 'maonanqu');
INSERT INTO `region_areas` VALUES ('1741', '440904', '电白区', '251', 'd', 'dbq', 'dianbaiqu');
INSERT INTO `region_areas` VALUES ('1742', '440981', '高州市', '251', 'g', 'gzs', 'gaozhoushi');
INSERT INTO `region_areas` VALUES ('1743', '440982', '化州市', '251', 'h', 'hzs', 'huazhoushi');
INSERT INTO `region_areas` VALUES ('1744', '440983', '信宜市', '251', 'x', 'xys', 'xinyishi');
INSERT INTO `region_areas` VALUES ('1745', '441202', '端州区', '252', 'd', 'dzq', 'duanzhouqu');
INSERT INTO `region_areas` VALUES ('1746', '441203', '鼎湖区', '252', 'd', 'dhq', 'dinghuqu');
INSERT INTO `region_areas` VALUES ('1747', '441223', '广宁县', '252', 'g', 'gnx', 'guangningxian');
INSERT INTO `region_areas` VALUES ('1748', '441224', '怀集县', '252', 'h', 'hjx', 'huaijixian');
INSERT INTO `region_areas` VALUES ('1749', '441225', '封开县', '252', 'f', 'fkx', 'fengkaixian');
INSERT INTO `region_areas` VALUES ('175', '140108', '尖草坪区', '44', 'j', 'jcpq', 'jiancaopingqu');
INSERT INTO `region_areas` VALUES ('1750', '441226', '德庆县', '252', 'd', 'dqx', 'deqingxian');
INSERT INTO `region_areas` VALUES ('1751', '441283', '高要市', '252', 'g', 'gys', 'gaoyaoshi');
INSERT INTO `region_areas` VALUES ('1752', '441284', '四会市', '252', 's', 'shs', 'sihuishi');
INSERT INTO `region_areas` VALUES ('1753', '441302', '惠城区', '253', 'h', 'hcq', 'huichengqu');
INSERT INTO `region_areas` VALUES ('1754', '441303', '惠阳区', '253', 'h', 'hyq', 'huiyangqu');
INSERT INTO `region_areas` VALUES ('1755', '441322', '博罗县', '253', 'b', 'blx', 'boluoxian');
INSERT INTO `region_areas` VALUES ('1756', '441323', '惠东县', '253', 'h', 'hdx', 'huidongxian');
INSERT INTO `region_areas` VALUES ('1757', '441324', '龙门县', '253', 'l', 'lmx', 'longmenxian');
INSERT INTO `region_areas` VALUES ('1758', '441402', '梅江区', '254', 'm', 'mjq', 'meijiangqu');
INSERT INTO `region_areas` VALUES ('1759', '441403', '梅县区', '254', 'm', 'mxq', 'meixianqu');
INSERT INTO `region_areas` VALUES ('176', '140109', '万柏林区', '44', 'w', 'wblq', 'wanbolinqu');
INSERT INTO `region_areas` VALUES ('1760', '441422', '大埔县', '254', 'd', 'dpx', 'dapuxian');
INSERT INTO `region_areas` VALUES ('1761', '441423', '丰顺县', '254', 'f', 'fsx', 'fengshunxian');
INSERT INTO `region_areas` VALUES ('1762', '441424', '五华县', '254', 'w', 'whx', 'wuhuaxian');
INSERT INTO `region_areas` VALUES ('1763', '441426', '平远县', '254', 'p', 'pyx', 'pingyuanxian');
INSERT INTO `region_areas` VALUES ('1764', '441427', '蕉岭县', '254', 'j', 'jlx', 'jiaolingxian');
INSERT INTO `region_areas` VALUES ('1765', '441481', '兴宁市', '254', 'x', 'xns', 'xingningshi');
INSERT INTO `region_areas` VALUES ('1766', '441502', '城区', '255', 'c', 'cq', 'chengqu');
INSERT INTO `region_areas` VALUES ('1767', '441521', '海丰县', '255', 'h', 'hfx', 'haifengxian');
INSERT INTO `region_areas` VALUES ('1768', '441523', '陆河县', '255', 'l', 'lhx', 'luhexian');
INSERT INTO `region_areas` VALUES ('1769', '441581', '陆丰市', '255', 'l', 'lfs', 'lufengshi');
INSERT INTO `region_areas` VALUES ('177', '140110', '晋源区', '44', 'j', 'jyq', 'jinyuanqu');
INSERT INTO `region_areas` VALUES ('1770', '441602', '源城区', '256', 'y', 'ycq', 'yuanchengqu');
INSERT INTO `region_areas` VALUES ('1771', '441621', '紫金县', '256', 'z', 'zjx', 'zijinxian');
INSERT INTO `region_areas` VALUES ('1772', '441622', '龙川县', '256', 'l', 'lcx', 'longchuanxian');
INSERT INTO `region_areas` VALUES ('1773', '441623', '连平县', '256', 'l', 'lpx', 'lianpingxian');
INSERT INTO `region_areas` VALUES ('1774', '441624', '和平县', '256', 'h', 'hpx', 'hepingxian');
INSERT INTO `region_areas` VALUES ('1775', '441625', '东源县', '256', 'd', 'dyx', 'dongyuanxian');
INSERT INTO `region_areas` VALUES ('1776', '441702', '江城区', '257', 'j', 'jcq', 'jiangchengqu');
INSERT INTO `region_areas` VALUES ('1777', '441721', '阳西县', '257', 'y', 'yxx', 'yangxixian');
INSERT INTO `region_areas` VALUES ('1778', '441723', '阳东县', '257', 'y', 'ydx', 'yangdongxian');
INSERT INTO `region_areas` VALUES ('1779', '441781', '阳春市', '257', 'y', 'ycs', 'yangchunshi');
INSERT INTO `region_areas` VALUES ('178', '140121', '清徐县', '44', 'q', 'qxx', 'qingxuxian');
INSERT INTO `region_areas` VALUES ('1780', '441802', '清城区', '258', 'q', 'qcq', 'qingchengqu');
INSERT INTO `region_areas` VALUES ('1781', '441803', '清新区', '258', 'q', 'qxq', 'qingxinqu');
INSERT INTO `region_areas` VALUES ('1782', '441821', '佛冈县', '258', 'f', 'fgx', 'fogangxian');
INSERT INTO `region_areas` VALUES ('1783', '441823', '阳山县', '258', 'y', 'ysx', 'yangshanxian');
INSERT INTO `region_areas` VALUES ('1784', '441825', '连山壮族瑶族自治县', '258', 'l', 'lszzyzzzx', 'lianshanzhuangzuyaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1785', '441826', '连南瑶族自治县', '258', 'l', 'lnyzzzx', 'liannanyaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1786', '441881', '英德市', '258', 'y', 'yds', 'yingdeshi');
INSERT INTO `region_areas` VALUES ('1787', '441882', '连州市', '258', 'l', 'lzs', 'lianzhoushi');
INSERT INTO `region_areas` VALUES ('1788', '445102', '湘桥区', '261', 'x', 'xqq', 'xiangqiaoqu');
INSERT INTO `region_areas` VALUES ('1789', '445103', '潮安区', '261', 'c', 'caq', 'chaoanqu');
INSERT INTO `region_areas` VALUES ('179', '140122', '阳曲县', '44', 'y', 'yqx', 'yangquxian');
INSERT INTO `region_areas` VALUES ('1790', '445122', '饶平县', '261', 'r', 'rpx', 'raopingxian');
INSERT INTO `region_areas` VALUES ('1791', '445202', '榕城区', '262', 'r', 'rcq', 'rongchengqu');
INSERT INTO `region_areas` VALUES ('1792', '445203', '揭东区', '262', 'j', 'jdq', 'jiedongqu');
INSERT INTO `region_areas` VALUES ('1793', '445222', '揭西县', '262', 'j', 'jxx', 'jiexixian');
INSERT INTO `region_areas` VALUES ('1794', '445224', '惠来县', '262', 'h', 'hlx', 'huilaixian');
INSERT INTO `region_areas` VALUES ('1795', '445281', '普宁市', '262', 'p', 'pns', 'puningshi');
INSERT INTO `region_areas` VALUES ('1796', '445302', '云城区', '263', 'y', 'ycq', 'yunchengqu');
INSERT INTO `region_areas` VALUES ('1797', '445303', '云安区', '263', 'y', 'yaq', 'yunanqu');
INSERT INTO `region_areas` VALUES ('1798', '445321', '新兴县', '263', 'x', 'xxx', 'xinxingxian');
INSERT INTO `region_areas` VALUES ('1799', '445322', '郁南县', '263', 'y', 'ynx', 'yunanxian');
INSERT INTO `region_areas` VALUES ('18', '130132', '元氏县', '33', 'y', 'ysx', 'yuanshixian');
INSERT INTO `region_areas` VALUES ('180', '140123', '娄烦县', '44', 'l', 'lfx', 'loufanxian');
INSERT INTO `region_areas` VALUES ('1800', '445381', '罗定市', '263', 'l', 'lds', 'luodingshi');
INSERT INTO `region_areas` VALUES ('1801', '450102', '兴宁区', '264', 'x', 'xnq', 'xingningqu');
INSERT INTO `region_areas` VALUES ('1802', '450103', '青秀区', '264', 'q', 'qxq', 'qingxiuqu');
INSERT INTO `region_areas` VALUES ('1803', '450105', '江南区', '264', 'j', 'jnq', 'jiangnanqu');
INSERT INTO `region_areas` VALUES ('1804', '450107', '西乡塘区', '264', 'x', 'xxtq', 'xixiangtangqu');
INSERT INTO `region_areas` VALUES ('1805', '450108', '良庆区', '264', 'l', 'lqq', 'liangqingqu');
INSERT INTO `region_areas` VALUES ('1806', '450109', '邕宁区', '264', 'y', 'ynq', 'yongningqu');
INSERT INTO `region_areas` VALUES ('1807', '450122', '武鸣县', '264', 'w', 'wmx', 'wumingxian');
INSERT INTO `region_areas` VALUES ('1808', '450123', '隆安县', '264', 'l', 'lax', 'longanxian');
INSERT INTO `region_areas` VALUES ('1809', '450124', '马山县', '264', 'm', 'msx', 'mashanxian');
INSERT INTO `region_areas` VALUES ('181', '140181', '古交市', '44', 'g', 'gjs', 'gujiaoshi');
INSERT INTO `region_areas` VALUES ('1810', '450125', '上林县', '264', 's', 'slx', 'shanglinxian');
INSERT INTO `region_areas` VALUES ('1811', '450126', '宾阳县', '264', 'b', 'byx', 'binyangxian');
INSERT INTO `region_areas` VALUES ('1812', '450127', '横县', '264', 'h', 'hx', 'hengxian');
INSERT INTO `region_areas` VALUES ('1813', '450202', '城中区', '265', 'c', 'czq', 'chengzhongqu');
INSERT INTO `region_areas` VALUES ('1814', '450203', '鱼峰区', '265', 'y', 'yfq', 'yufengqu');
INSERT INTO `region_areas` VALUES ('1815', '450204', '柳南区', '265', 'l', 'lnq', 'liunanqu');
INSERT INTO `region_areas` VALUES ('1816', '450205', '柳北区', '265', 'l', 'lbq', 'liubeiqu');
INSERT INTO `region_areas` VALUES ('1817', '450221', '柳江县', '265', 'l', 'ljx', 'liujiangxian');
INSERT INTO `region_areas` VALUES ('1818', '450222', '柳城县', '265', 'l', 'lcx', 'liuchengxian');
INSERT INTO `region_areas` VALUES ('1819', '450223', '鹿寨县', '265', 'l', 'lzx', 'luzhaixian');
INSERT INTO `region_areas` VALUES ('182', '140202', '城区', '45', 'c', 'cq', 'chengqu');
INSERT INTO `region_areas` VALUES ('1820', '450224', '融安县', '265', 'r', 'rax', 'ronganxian');
INSERT INTO `region_areas` VALUES ('1821', '450225', '融水苗族自治县', '265', 'r', 'rsmzzzx', 'rongshuimiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1822', '450226', '三江侗族自治县', '265', 's', 'sjdzzzx', 'sanjiangdongzuzizhixian');
INSERT INTO `region_areas` VALUES ('1823', '450302', '秀峰区', '266', 'x', 'xfq', 'xiufengqu');
INSERT INTO `region_areas` VALUES ('1824', '450303', '叠彩区', '266', 'd', 'dcq', 'diecaiqu');
INSERT INTO `region_areas` VALUES ('1825', '450304', '象山区', '266', 'x', 'xsq', 'xiangshanqu');
INSERT INTO `region_areas` VALUES ('1826', '450305', '七星区', '266', 'q', 'qxq', 'qixingqu');
INSERT INTO `region_areas` VALUES ('1827', '450311', '雁山区', '266', 'y', 'ysq', 'yanshanqu');
INSERT INTO `region_areas` VALUES ('1828', '450312', '临桂区', '266', 'l', 'lgq', 'linguiqu');
INSERT INTO `region_areas` VALUES ('1829', '450321', '阳朔县', '266', 'y', 'ysx', 'yangshuoxian');
INSERT INTO `region_areas` VALUES ('183', '140203', '矿区', '45', 'k', 'kq', 'kuangqu');
INSERT INTO `region_areas` VALUES ('1830', '450323', '灵川县', '266', 'l', 'lcx', 'lingchuanxian');
INSERT INTO `region_areas` VALUES ('1831', '450324', '全州县', '266', 'q', 'qzx', 'quanzhouxian');
INSERT INTO `region_areas` VALUES ('1832', '450325', '兴安县', '266', 'x', 'xax', 'xinganxian');
INSERT INTO `region_areas` VALUES ('1833', '450326', '永福县', '266', 'y', 'yfx', 'yongfuxian');
INSERT INTO `region_areas` VALUES ('1834', '450327', '灌阳县', '266', 'g', 'gyx', 'guanyangxian');
INSERT INTO `region_areas` VALUES ('1835', '450328', '龙胜各族自治县', '266', 'l', 'lsgzzzx', 'longshenggezuzizhixian');
INSERT INTO `region_areas` VALUES ('1836', '450329', '资源县', '266', 'z', 'zyx', 'ziyuanxian');
INSERT INTO `region_areas` VALUES ('1837', '450330', '平乐县', '266', 'p', 'plx', 'pinglexian');
INSERT INTO `region_areas` VALUES ('1838', '450331', '荔浦县', '266', 'l', 'lpx', 'lipuxian');
INSERT INTO `region_areas` VALUES ('1839', '450332', '恭城瑶族自治县', '266', 'g', 'gcyzzzx', 'gongchengyaozuzizhixian');
INSERT INTO `region_areas` VALUES ('184', '140211', '南郊区', '45', 'n', 'njq', 'nanjiaoqu');
INSERT INTO `region_areas` VALUES ('1840', '450403', '万秀区', '267', 'w', 'wxq', 'wanxiuqu');
INSERT INTO `region_areas` VALUES ('1841', '450405', '长洲区', '267', 'z', 'zzq', 'zhangzhouqu');
INSERT INTO `region_areas` VALUES ('1842', '450406', '龙圩区', '267', 'l', 'lwq', 'longweiqu');
INSERT INTO `region_areas` VALUES ('1843', '450421', '苍梧县', '267', 'c', 'cwx', 'cangwuxian');
INSERT INTO `region_areas` VALUES ('1844', '450422', '藤县', '267', 't', 'tx', 'tengxian');
INSERT INTO `region_areas` VALUES ('1845', '450423', '蒙山县', '267', 'm', 'msx', 'mengshanxian');
INSERT INTO `region_areas` VALUES ('1846', '450481', '岑溪市', '267', 'c', 'cxs', 'cenxishi');
INSERT INTO `region_areas` VALUES ('1847', '450502', '海城区', '268', 'h', 'hcq', 'haichengqu');
INSERT INTO `region_areas` VALUES ('1848', '450503', '银海区', '268', 'y', 'yhq', 'yinhaiqu');
INSERT INTO `region_areas` VALUES ('1849', '450512', '铁山港区', '268', 't', 'tsgq', 'tieshangangqu');
INSERT INTO `region_areas` VALUES ('185', '140212', '新荣区', '45', 'x', 'xrq', 'xinrongqu');
INSERT INTO `region_areas` VALUES ('1850', '450521', '合浦县', '268', 'h', 'hpx', 'hepuxian');
INSERT INTO `region_areas` VALUES ('1851', '450602', '港口区', '269', 'g', 'gkq', 'gangkouqu');
INSERT INTO `region_areas` VALUES ('1852', '450603', '防城区', '269', 'f', 'fcq', 'fangchengqu');
INSERT INTO `region_areas` VALUES ('1853', '450621', '上思县', '269', 's', 'ssx', 'shangsixian');
INSERT INTO `region_areas` VALUES ('1854', '450681', '东兴市', '269', 'd', 'dxs', 'dongxingshi');
INSERT INTO `region_areas` VALUES ('1855', '450702', '钦南区', '270', 'q', 'qnq', 'qinnanqu');
INSERT INTO `region_areas` VALUES ('1856', '450703', '钦北区', '270', 'q', 'qbq', 'qinbeiqu');
INSERT INTO `region_areas` VALUES ('1857', '450721', '灵山县', '270', 'l', 'lsx', 'lingshanxian');
INSERT INTO `region_areas` VALUES ('1858', '450722', '浦北县', '270', 'p', 'pbx', 'pubeixian');
INSERT INTO `region_areas` VALUES ('1859', '450802', '港北区', '271', 'g', 'gbq', 'gangbeiqu');
INSERT INTO `region_areas` VALUES ('186', '140221', '阳高县', '45', 'y', 'ygx', 'yanggaoxian');
INSERT INTO `region_areas` VALUES ('1860', '450803', '港南区', '271', 'g', 'gnq', 'gangnanqu');
INSERT INTO `region_areas` VALUES ('1861', '450804', '覃塘区', '271', 't', 'ttq', 'tantangqu');
INSERT INTO `region_areas` VALUES ('1862', '450821', '平南县', '271', 'p', 'pnx', 'pingnanxian');
INSERT INTO `region_areas` VALUES ('1863', '450881', '桂平市', '271', 'g', 'gps', 'guipingshi');
INSERT INTO `region_areas` VALUES ('1864', '450902', '玉州区', '272', 'y', 'yzq', 'yuzhouqu');
INSERT INTO `region_areas` VALUES ('1865', '450903', '福绵区', '272', 'f', 'fmq', 'fumianqu');
INSERT INTO `region_areas` VALUES ('1866', '450921', '容县', '272', 'r', 'rx', 'rongxian');
INSERT INTO `region_areas` VALUES ('1867', '450922', '陆川县', '272', 'l', 'lcx', 'luchuanxian');
INSERT INTO `region_areas` VALUES ('1868', '450923', '博白县', '272', 'b', 'bbx', 'bobaixian');
INSERT INTO `region_areas` VALUES ('1869', '450924', '兴业县', '272', 'x', 'xyx', 'xingyexian');
INSERT INTO `region_areas` VALUES ('187', '140222', '天镇县', '45', 't', 'tzx', 'tianzhenxian');
INSERT INTO `region_areas` VALUES ('1870', '450981', '北流市', '272', 'b', 'bls', 'beiliushi');
INSERT INTO `region_areas` VALUES ('1871', '451002', '右江区', '273', 'y', 'yjq', 'youjiangqu');
INSERT INTO `region_areas` VALUES ('1872', '451021', '田阳县', '273', 't', 'tyx', 'tianyangxian');
INSERT INTO `region_areas` VALUES ('1873', '451022', '田东县', '273', 't', 'tdx', 'tiandongxian');
INSERT INTO `region_areas` VALUES ('1874', '451023', '平果县', '273', 'p', 'pgx', 'pingguoxian');
INSERT INTO `region_areas` VALUES ('1875', '451024', '德保县', '273', 'd', 'dbx', 'debaoxian');
INSERT INTO `region_areas` VALUES ('1876', '451025', '靖西县', '273', 'j', 'jxx', 'jingxixian');
INSERT INTO `region_areas` VALUES ('1877', '451026', '那坡县', '273', 'n', 'npx', 'neipoxian');
INSERT INTO `region_areas` VALUES ('1878', '451027', '凌云县', '273', 'l', 'lyx', 'lingyunxian');
INSERT INTO `region_areas` VALUES ('1879', '451028', '乐业县', '273', 'l', 'lyx', 'leyexian');
INSERT INTO `region_areas` VALUES ('188', '140223', '广灵县', '45', 'g', 'glx', 'guanglingxian');
INSERT INTO `region_areas` VALUES ('1880', '451029', '田林县', '273', 't', 'tlx', 'tianlinxian');
INSERT INTO `region_areas` VALUES ('1881', '451030', '西林县', '273', 'x', 'xlx', 'xilinxian');
INSERT INTO `region_areas` VALUES ('1882', '451031', '隆林各族自治县', '273', 'l', 'llgzzzx', 'longlingezuzizhixian');
INSERT INTO `region_areas` VALUES ('1883', '451102', '八步区', '274', 'b', 'bbq', 'babuqu');
INSERT INTO `region_areas` VALUES ('1884', '451121', '昭平县', '274', 'z', 'zpx', 'zhaopingxian');
INSERT INTO `region_areas` VALUES ('1885', '451122', '钟山县', '274', 'z', 'zsx', 'zhongshanxian');
INSERT INTO `region_areas` VALUES ('1886', '451123', '富川瑶族自治县', '274', 'f', 'fcyzzzx', 'fuchuanyaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1887', '451202', '金城江区', '275', 'j', 'jcjq', 'jinchengjiangqu');
INSERT INTO `region_areas` VALUES ('1888', '451221', '南丹县', '275', 'n', 'ndx', 'nandanxian');
INSERT INTO `region_areas` VALUES ('1889', '451222', '天峨县', '275', 't', 'tex', 'tianexian');
INSERT INTO `region_areas` VALUES ('189', '140224', '灵丘县', '45', 'l', 'lqx', 'lingqiuxian');
INSERT INTO `region_areas` VALUES ('1890', '451223', '凤山县', '275', 'f', 'fsx', 'fengshanxian');
INSERT INTO `region_areas` VALUES ('1891', '451224', '东兰县', '275', 'd', 'dlx', 'donglanxian');
INSERT INTO `region_areas` VALUES ('1892', '451225', '罗城仫佬族自治县', '275', 'l', 'lcmlzzzx', 'luochengmulaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1893', '451226', '环江毛南族自治县', '275', 'h', 'hjmnzzzx', 'huanjiangmaonanzuzizhixian');
INSERT INTO `region_areas` VALUES ('1894', '451227', '巴马瑶族自治县', '275', 'b', 'bmyzzzx', 'bamayaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1895', '451228', '都安瑶族自治县', '275', 'd', 'dayzzzx', 'douanyaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1896', '451229', '大化瑶族自治县', '275', 'd', 'dhyzzzx', 'dahuayaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1897', '451281', '宜州市', '275', 'y', 'yzs', 'yizhoushi');
INSERT INTO `region_areas` VALUES ('1898', '451302', '兴宾区', '276', 'x', 'xbq', 'xingbinqu');
INSERT INTO `region_areas` VALUES ('1899', '451321', '忻城县', '276', 'x', 'xcx', 'xinchengxian');
INSERT INTO `region_areas` VALUES ('19', '130133', '赵县', '33', 'z', 'zx', 'zhaoxian');
INSERT INTO `region_areas` VALUES ('190', '140225', '浑源县', '45', 'h', 'hyx', 'hunyuanxian');
INSERT INTO `region_areas` VALUES ('1900', '451322', '象州县', '276', 'x', 'xzx', 'xiangzhouxian');
INSERT INTO `region_areas` VALUES ('1901', '451323', '武宣县', '276', 'w', 'wxx', 'wuxuanxian');
INSERT INTO `region_areas` VALUES ('1902', '451324', '金秀瑶族自治县', '276', 'j', 'jxyzzzx', 'jinxiuyaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1903', '451381', '合山市', '276', 'h', 'hss', 'heshanshi');
INSERT INTO `region_areas` VALUES ('1904', '451402', '江州区', '277', 'j', 'jzq', 'jiangzhouqu');
INSERT INTO `region_areas` VALUES ('1905', '451421', '扶绥县', '277', 'f', 'fsx', 'fusuixian');
INSERT INTO `region_areas` VALUES ('1906', '451422', '宁明县', '277', 'n', 'nmx', 'ningmingxian');
INSERT INTO `region_areas` VALUES ('1907', '451423', '龙州县', '277', 'l', 'lzx', 'longzhouxian');
INSERT INTO `region_areas` VALUES ('1908', '451424', '大新县', '277', 'd', 'dxx', 'daxinxian');
INSERT INTO `region_areas` VALUES ('1909', '451425', '天等县', '277', 't', 'tdx', 'tiandengxian');
INSERT INTO `region_areas` VALUES ('191', '140226', '左云县', '45', 'z', 'zyx', 'zuoyunxian');
INSERT INTO `region_areas` VALUES ('1910', '451481', '凭祥市', '277', 'p', 'pxs', 'pingxiangshi');
INSERT INTO `region_areas` VALUES ('1911', '460105', '秀英区', '278', 'x', 'xyq', 'xiuyingqu');
INSERT INTO `region_areas` VALUES ('1912', '460106', '龙华区', '278', 'l', 'lhq', 'longhuaqu');
INSERT INTO `region_areas` VALUES ('1913', '460107', '琼山区', '278', 'q', 'qsq', 'qiongshanqu');
INSERT INTO `region_areas` VALUES ('1914', '460108', '美兰区', '278', 'm', 'mlq', 'meilanqu');
INSERT INTO `region_areas` VALUES ('1915', '460202', '海棠区', '279', 'h', 'htq', 'haitangqu');
INSERT INTO `region_areas` VALUES ('1916', '460203', '吉阳区', '279', 'j', 'jyq', 'jiyangqu');
INSERT INTO `region_areas` VALUES ('1917', '460204', '天涯区', '279', 't', 'tyq', 'tianyaqu');
INSERT INTO `region_areas` VALUES ('1918', '460205', '崖州区', '279', 'y', 'yzq', 'yazhouqu');
INSERT INTO `region_areas` VALUES ('1919', '469001', '五指山市', '281', 'w', 'wzss', 'wuzhishanshi');
INSERT INTO `region_areas` VALUES ('192', '140227', '大同县', '45', 'd', 'dtx', 'datongxian');
INSERT INTO `region_areas` VALUES ('1920', '469002', '琼海市', '281', 'q', 'qhs', 'qionghaishi');
INSERT INTO `region_areas` VALUES ('1921', '469003', '儋州市', '281', 'd', 'dzs', 'danzhoushi');
INSERT INTO `region_areas` VALUES ('1922', '469005', '文昌市', '281', 'w', 'wcs', 'wenchangshi');
INSERT INTO `region_areas` VALUES ('1923', '469006', '万宁市', '281', 'w', 'wns', 'wanningshi');
INSERT INTO `region_areas` VALUES ('1924', '469007', '东方市', '281', 'd', 'dfs', 'dongfangshi');
INSERT INTO `region_areas` VALUES ('1925', '469021', '定安县', '281', 'd', 'dax', 'dinganxian');
INSERT INTO `region_areas` VALUES ('1926', '469022', '屯昌县', '281', 't', 'tcx', 'tunchangxian');
INSERT INTO `region_areas` VALUES ('1927', '469023', '澄迈县', '281', 'c', 'cmx', 'chengmaixian');
INSERT INTO `region_areas` VALUES ('1928', '469024', '临高县', '281', 'l', 'lgx', 'lingaoxian');
INSERT INTO `region_areas` VALUES ('1929', '469025', '白沙黎族自治县', '281', 'b', 'bslzzzx', 'baishalizuzizhixian');
INSERT INTO `region_areas` VALUES ('193', '140302', '城区', '46', 'c', 'cq', 'chengqu');
INSERT INTO `region_areas` VALUES ('1930', '469026', '昌江黎族自治县', '281', 'c', 'cjlzzzx', 'changjianglizuzizhixian');
INSERT INTO `region_areas` VALUES ('1931', '469027', '乐东黎族自治县', '281', 'l', 'ldlzzzx', 'ledonglizuzizhixian');
INSERT INTO `region_areas` VALUES ('1932', '469028', '陵水黎族自治县', '281', 'l', 'lslzzzx', 'lingshuilizuzizhixian');
INSERT INTO `region_areas` VALUES ('1933', '469029', '保亭黎族苗族自治县', '281', 'b', 'btlzmzzzx', 'baotinglizumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1934', '469030', '琼中黎族苗族自治县', '281', 'q', 'qzlzmzzzx', 'qiongzhonglizumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('1935', '510104', '锦江区', '320', 'j', 'jjq', 'jinjiangqu');
INSERT INTO `region_areas` VALUES ('1936', '510105', '青羊区', '320', 'q', 'qyq', 'qingyangqu');
INSERT INTO `region_areas` VALUES ('1937', '510106', '金牛区', '320', 'j', 'jnq', 'jinniuqu');
INSERT INTO `region_areas` VALUES ('1938', '510107', '武侯区', '320', 'w', 'whq', 'wuhouqu');
INSERT INTO `region_areas` VALUES ('1939', '510108', '成华区', '320', 'c', 'chq', 'chenghuaqu');
INSERT INTO `region_areas` VALUES ('194', '140303', '矿区', '46', 'k', 'kq', 'kuangqu');
INSERT INTO `region_areas` VALUES ('1940', '510112', '龙泉驿区', '320', 'l', 'lqyq', 'longquanyiqu');
INSERT INTO `region_areas` VALUES ('1941', '510113', '青白江区', '320', 'q', 'qbjq', 'qingbaijiangqu');
INSERT INTO `region_areas` VALUES ('1942', '510114', '新都区', '320', 'x', 'xdq', 'xindouqu');
INSERT INTO `region_areas` VALUES ('1943', '510115', '温江区', '320', 'w', 'wjq', 'wenjiangqu');
INSERT INTO `region_areas` VALUES ('1944', '510121', '金堂县', '320', 'j', 'jtx', 'jintangxian');
INSERT INTO `region_areas` VALUES ('1945', '510122', '双流县', '320', 's', 'slx', 'shuangliuxian');
INSERT INTO `region_areas` VALUES ('1946', '510124', '郫县', '320', 'p', 'px', 'pixian');
INSERT INTO `region_areas` VALUES ('1947', '510129', '大邑县', '320', 'd', 'dyx', 'dayixian');
INSERT INTO `region_areas` VALUES ('1948', '510131', '蒲江县', '320', 'p', 'pjx', 'pujiangxian');
INSERT INTO `region_areas` VALUES ('1949', '510132', '新津县', '320', 'x', 'xjx', 'xinjinxian');
INSERT INTO `region_areas` VALUES ('195', '140311', '郊区', '46', 'j', 'jq', 'jiaoqu');
INSERT INTO `region_areas` VALUES ('1950', '510181', '都江堰市', '320', 'd', 'djys', 'doujiangyanshi');
INSERT INTO `region_areas` VALUES ('1951', '510182', '彭州市', '320', 'p', 'pzs', 'pengzhoushi');
INSERT INTO `region_areas` VALUES ('1952', '510183', '邛崃市', '320', 'q', 'qls', 'qionglaishi');
INSERT INTO `region_areas` VALUES ('1953', '510184', '崇州市', '320', 'c', 'czs', 'chongzhoushi');
INSERT INTO `region_areas` VALUES ('1954', '510302', '自流井区', '321', 'z', 'zljq', 'ziliujingqu');
INSERT INTO `region_areas` VALUES ('1955', '510303', '贡井区', '321', 'g', 'gjq', 'gongjingqu');
INSERT INTO `region_areas` VALUES ('1956', '510304', '大安区', '321', 'd', 'daq', 'daanqu');
INSERT INTO `region_areas` VALUES ('1957', '510311', '沿滩区', '321', 'y', 'ytq', 'yantanqu');
INSERT INTO `region_areas` VALUES ('1958', '510321', '荣县', '321', 'r', 'rx', 'rongxian');
INSERT INTO `region_areas` VALUES ('1959', '510322', '富顺县', '321', 'f', 'fsx', 'fushunxian');
INSERT INTO `region_areas` VALUES ('196', '140321', '平定县', '46', 'p', 'pdx', 'pingdingxian');
INSERT INTO `region_areas` VALUES ('1960', '510402', '东区', '322', 'd', 'dq', 'dongqu');
INSERT INTO `region_areas` VALUES ('1961', '510403', '西区', '322', 'x', 'xq', 'xiqu');
INSERT INTO `region_areas` VALUES ('1962', '510411', '仁和区', '322', 'r', 'rhq', 'renhequ');
INSERT INTO `region_areas` VALUES ('1963', '510421', '米易县', '322', 'm', 'myx', 'miyixian');
INSERT INTO `region_areas` VALUES ('1964', '510422', '盐边县', '322', 'y', 'ybx', 'yanbianxian');
INSERT INTO `region_areas` VALUES ('1965', '510502', '江阳区', '323', 'j', 'jyq', 'jiangyangqu');
INSERT INTO `region_areas` VALUES ('1966', '510503', '纳溪区', '323', 'n', 'nxq', 'naxiqu');
INSERT INTO `region_areas` VALUES ('1967', '510504', '龙马潭区', '323', 'l', 'lmtq', 'longmatanqu');
INSERT INTO `region_areas` VALUES ('1968', '510521', '泸县', '323', 'l', 'lx', 'luxian');
INSERT INTO `region_areas` VALUES ('1969', '510522', '合江县', '323', 'h', 'hjx', 'hejiangxian');
INSERT INTO `region_areas` VALUES ('197', '140322', '盂县', '46', 'y', 'yx', 'yuxian');
INSERT INTO `region_areas` VALUES ('1970', '510524', '叙永县', '323', 'x', 'xyx', 'xuyongxian');
INSERT INTO `region_areas` VALUES ('1971', '510525', '古蔺县', '323', 'g', 'glx', 'gulinxian');
INSERT INTO `region_areas` VALUES ('1972', '510603', '旌阳区', '324', 'j', 'jyq', 'jingyangqu');
INSERT INTO `region_areas` VALUES ('1973', '510623', '中江县', '324', 'z', 'zjx', 'zhongjiangxian');
INSERT INTO `region_areas` VALUES ('1974', '510626', '罗江县', '324', 'l', 'ljx', 'luojiangxian');
INSERT INTO `region_areas` VALUES ('1975', '510681', '广汉市', '324', 'g', 'ghs', 'guanghanshi');
INSERT INTO `region_areas` VALUES ('1976', '510682', '什邡市', '324', 's', 'sfs', 'shenfangshi');
INSERT INTO `region_areas` VALUES ('1977', '510683', '绵竹市', '324', 'm', 'mzs', 'mianzhushi');
INSERT INTO `region_areas` VALUES ('1978', '510703', '涪城区', '325', 'f', 'fcq', 'fuchengqu');
INSERT INTO `region_areas` VALUES ('1979', '510704', '游仙区', '325', 'y', 'yxq', 'youxianqu');
INSERT INTO `region_areas` VALUES ('198', '140402', '城区', '47', 'c', 'cq', 'chengqu');
INSERT INTO `region_areas` VALUES ('1980', '510722', '三台县', '325', 's', 'stx', 'santaixian');
INSERT INTO `region_areas` VALUES ('1981', '510723', '盐亭县', '325', 'y', 'ytx', 'yantingxian');
INSERT INTO `region_areas` VALUES ('1982', '510724', '安县', '325', 'a', 'ax', 'anxian');
INSERT INTO `region_areas` VALUES ('1983', '510725', '梓潼县', '325', 'z', 'ztx', 'zitongxian');
INSERT INTO `region_areas` VALUES ('1984', '510726', '北川羌族自治县', '325', 'b', 'bcqzzzx', 'beichuanqiangzuzizhixian');
INSERT INTO `region_areas` VALUES ('1985', '510727', '平武县', '325', 'p', 'pwx', 'pingwuxian');
INSERT INTO `region_areas` VALUES ('1986', '510781', '江油市', '325', 'j', 'jys', 'jiangyoushi');
INSERT INTO `region_areas` VALUES ('1987', '510802', '利州区', '326', 'l', 'lzq', 'lizhouqu');
INSERT INTO `region_areas` VALUES ('1988', '510811', '昭化区', '326', 'z', 'zhq', 'zhaohuaqu');
INSERT INTO `region_areas` VALUES ('1989', '510812', '朝天区', '326', 'c', 'ctq', 'chaotianqu');
INSERT INTO `region_areas` VALUES ('199', '140411', '郊区', '47', 'j', 'jq', 'jiaoqu');
INSERT INTO `region_areas` VALUES ('1990', '510821', '旺苍县', '326', 'w', 'wcx', 'wangcangxian');
INSERT INTO `region_areas` VALUES ('1991', '510822', '青川县', '326', 'q', 'qcx', 'qingchuanxian');
INSERT INTO `region_areas` VALUES ('1992', '510823', '剑阁县', '326', 'j', 'jgx', 'jiangexian');
INSERT INTO `region_areas` VALUES ('1993', '510824', '苍溪县', '326', 'c', 'cxx', 'cangxixian');
INSERT INTO `region_areas` VALUES ('1994', '510903', '船山区', '327', 'c', 'csq', 'chuanshanqu');
INSERT INTO `region_areas` VALUES ('1995', '510904', '安居区', '327', 'a', 'ajq', 'anjuqu');
INSERT INTO `region_areas` VALUES ('1996', '510921', '蓬溪县', '327', 'p', 'pxx', 'pengxixian');
INSERT INTO `region_areas` VALUES ('1997', '510922', '射洪县', '327', 's', 'shx', 'shehongxian');
INSERT INTO `region_areas` VALUES ('1998', '510923', '大英县', '327', 'd', 'dyx', 'dayingxian');
INSERT INTO `region_areas` VALUES ('1999', '511002', '市中区', '328', 's', 'szq', 'shizhongqu');
INSERT INTO `region_areas` VALUES ('2', '130104', '桥西区', '33', 'q', 'qxq', 'qiaoxiqu');
INSERT INTO `region_areas` VALUES ('20', '130181', '辛集市', '33', 'x', 'xjs', 'xinjishi');
INSERT INTO `region_areas` VALUES ('200', '140421', '长治县', '47', 'z', 'zzx', 'zhangzhixian');
INSERT INTO `region_areas` VALUES ('2000', '511011', '东兴区', '328', 'd', 'dxq', 'dongxingqu');
INSERT INTO `region_areas` VALUES ('2001', '511024', '威远县', '328', 'w', 'wyx', 'weiyuanxian');
INSERT INTO `region_areas` VALUES ('2002', '511025', '资中县', '328', 'z', 'zzx', 'zizhongxian');
INSERT INTO `region_areas` VALUES ('2003', '511028', '隆昌县', '328', 'l', 'lcx', 'longchangxian');
INSERT INTO `region_areas` VALUES ('2004', '511102', '市中区', '329', 's', 'szq', 'shizhongqu');
INSERT INTO `region_areas` VALUES ('2005', '511111', '沙湾区', '329', 's', 'swq', 'shawanqu');
INSERT INTO `region_areas` VALUES ('2006', '511112', '五通桥区', '329', 'w', 'wtqq', 'wutongqiaoqu');
INSERT INTO `region_areas` VALUES ('2007', '511113', '金口河区', '329', 'j', 'jkhq', 'jinkouhequ');
INSERT INTO `region_areas` VALUES ('2008', '511123', '犍为县', '329', 'j', 'jwx', 'jianweixian');
INSERT INTO `region_areas` VALUES ('2009', '511124', '井研县', '329', 'j', 'jyx', 'jingyanxian');
INSERT INTO `region_areas` VALUES ('201', '140423', '襄垣县', '47', 'x', 'xyx', 'xiangyuanxian');
INSERT INTO `region_areas` VALUES ('2010', '511126', '夹江县', '329', 'j', 'jjx', 'jiajiangxian');
INSERT INTO `region_areas` VALUES ('2011', '511129', '沐川县', '329', 'm', 'mcx', 'muchuanxian');
INSERT INTO `region_areas` VALUES ('2012', '511132', '峨边彝族自治县', '329', 'e', 'ebyzzzx', 'ebianyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2013', '511133', '马边彝族自治县', '329', 'm', 'mbyzzzx', 'mabianyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2014', '511181', '峨眉山市', '329', 'e', 'emss', 'emeishanshi');
INSERT INTO `region_areas` VALUES ('2015', '511302', '顺庆区', '330', 's', 'sqq', 'shunqingqu');
INSERT INTO `region_areas` VALUES ('2016', '511303', '高坪区', '330', 'g', 'gpq', 'gaopingqu');
INSERT INTO `region_areas` VALUES ('2017', '511304', '嘉陵区', '330', 'j', 'jlq', 'jialingqu');
INSERT INTO `region_areas` VALUES ('2018', '511321', '南部县', '330', 'n', 'nbx', 'nanbuxian');
INSERT INTO `region_areas` VALUES ('2019', '511322', '营山县', '330', 'y', 'ysx', 'yingshanxian');
INSERT INTO `region_areas` VALUES ('202', '140424', '屯留县', '47', 't', 'tlx', 'tunliuxian');
INSERT INTO `region_areas` VALUES ('2020', '511323', '蓬安县', '330', 'p', 'pax', 'penganxian');
INSERT INTO `region_areas` VALUES ('2021', '511324', '仪陇县', '330', 'y', 'ylx', 'yilongxian');
INSERT INTO `region_areas` VALUES ('2022', '511325', '西充县', '330', 'x', 'xcx', 'xichongxian');
INSERT INTO `region_areas` VALUES ('2023', '511381', '阆中市', '330', 'l', 'lzs', 'langzhongshi');
INSERT INTO `region_areas` VALUES ('2024', '511402', '东坡区', '331', 'd', 'dpq', 'dongpoqu');
INSERT INTO `region_areas` VALUES ('2025', '511421', '仁寿县', '331', 'r', 'rsx', 'renshouxian');
INSERT INTO `region_areas` VALUES ('2026', '511422', '彭山县', '331', 'p', 'psx', 'pengshanxian');
INSERT INTO `region_areas` VALUES ('2027', '511423', '洪雅县', '331', 'h', 'hyx', 'hongyaxian');
INSERT INTO `region_areas` VALUES ('2028', '511424', '丹棱县', '331', 'd', 'dlx', 'danlengxian');
INSERT INTO `region_areas` VALUES ('2029', '511425', '青神县', '331', 'q', 'qsx', 'qingshenxian');
INSERT INTO `region_areas` VALUES ('203', '140425', '平顺县', '47', 'p', 'psx', 'pingshunxian');
INSERT INTO `region_areas` VALUES ('2030', '511502', '翠屏区', '332', 'c', 'cpq', 'cuipingqu');
INSERT INTO `region_areas` VALUES ('2031', '511503', '南溪区', '332', 'n', 'nxq', 'nanxiqu');
INSERT INTO `region_areas` VALUES ('2032', '511521', '宜宾县', '332', 'y', 'ybx', 'yibinxian');
INSERT INTO `region_areas` VALUES ('2033', '511523', '江安县', '332', 'j', 'jax', 'jianganxian');
INSERT INTO `region_areas` VALUES ('2034', '511524', '长宁县', '332', 'z', 'znx', 'zhangningxian');
INSERT INTO `region_areas` VALUES ('2035', '511525', '高县', '332', 'g', 'gx', 'gaoxian');
INSERT INTO `region_areas` VALUES ('2036', '511526', '珙县', '332', 'g', 'gx', 'gongxian');
INSERT INTO `region_areas` VALUES ('2037', '511527', '筠连县', '332', 'y', 'ylx', 'yunlianxian');
INSERT INTO `region_areas` VALUES ('2038', '511528', '兴文县', '332', 'x', 'xwx', 'xingwenxian');
INSERT INTO `region_areas` VALUES ('2039', '511529', '屏山县', '332', 'p', 'psx', 'pingshanxian');
INSERT INTO `region_areas` VALUES ('204', '140426', '黎城县', '47', 'l', 'lcx', 'lichengxian');
INSERT INTO `region_areas` VALUES ('2040', '511602', '广安区', '333', 'g', 'gaq', 'guanganqu');
INSERT INTO `region_areas` VALUES ('2041', '511603', '前锋区', '333', 'q', 'qfq', 'qianfengqu');
INSERT INTO `region_areas` VALUES ('2042', '511621', '岳池县', '333', 'y', 'ycx', 'yuechixian');
INSERT INTO `region_areas` VALUES ('2043', '511622', '武胜县', '333', 'w', 'wsx', 'wushengxian');
INSERT INTO `region_areas` VALUES ('2044', '511623', '邻水县', '333', 'l', 'lsx', 'linshuixian');
INSERT INTO `region_areas` VALUES ('2045', '511681', '华蓥市', '333', 'h', 'hys', 'huayingshi');
INSERT INTO `region_areas` VALUES ('2046', '511702', '通川区', '334', 't', 'tcq', 'tongchuanqu');
INSERT INTO `region_areas` VALUES ('2047', '511703', '达川区', '334', 'd', 'dcq', 'dachuanqu');
INSERT INTO `region_areas` VALUES ('2048', '511722', '宣汉县', '334', 'x', 'xhx', 'xuanhanxian');
INSERT INTO `region_areas` VALUES ('2049', '511723', '开江县', '334', 'k', 'kjx', 'kaijiangxian');
INSERT INTO `region_areas` VALUES ('205', '140427', '壶关县', '47', 'h', 'hgx', 'huguanxian');
INSERT INTO `region_areas` VALUES ('2050', '511724', '大竹县', '334', 'd', 'dzx', 'dazhuxian');
INSERT INTO `region_areas` VALUES ('2051', '511725', '渠县', '334', 'q', 'qx', 'quxian');
INSERT INTO `region_areas` VALUES ('2052', '511781', '万源市', '334', 'w', 'wys', 'wanyuanshi');
INSERT INTO `region_areas` VALUES ('2053', '511802', '雨城区', '335', 'y', 'ycq', 'yuchengqu');
INSERT INTO `region_areas` VALUES ('2054', '511803', '名山区', '335', 'm', 'msq', 'mingshanqu');
INSERT INTO `region_areas` VALUES ('2055', '511822', '荥经县', '335', 'y', 'yjx', 'yingjingxian');
INSERT INTO `region_areas` VALUES ('2056', '511823', '汉源县', '335', 'h', 'hyx', 'hanyuanxian');
INSERT INTO `region_areas` VALUES ('2057', '511824', '石棉县', '335', 's', 'smx', 'shimianxian');
INSERT INTO `region_areas` VALUES ('2058', '511825', '天全县', '335', 't', 'tqx', 'tianquanxian');
INSERT INTO `region_areas` VALUES ('2059', '511826', '芦山县', '335', 'l', 'lsx', 'lushanxian');
INSERT INTO `region_areas` VALUES ('206', '140428', '长子县', '47', 'z', 'zzx', 'zhangzixian');
INSERT INTO `region_areas` VALUES ('2060', '511827', '宝兴县', '335', 'b', 'bxx', 'baoxingxian');
INSERT INTO `region_areas` VALUES ('2061', '511902', '巴州区', '336', 'b', 'bzq', 'bazhouqu');
INSERT INTO `region_areas` VALUES ('2062', '511903', '恩阳区', '336', 'e', 'eyq', 'enyangqu');
INSERT INTO `region_areas` VALUES ('2063', '511921', '通江县', '336', 't', 'tjx', 'tongjiangxian');
INSERT INTO `region_areas` VALUES ('2064', '511922', '南江县', '336', 'n', 'njx', 'nanjiangxian');
INSERT INTO `region_areas` VALUES ('2065', '511923', '平昌县', '336', 'p', 'pcx', 'pingchangxian');
INSERT INTO `region_areas` VALUES ('2066', '512002', '雁江区', '337', 'y', 'yjq', 'yanjiangqu');
INSERT INTO `region_areas` VALUES ('2067', '512021', '安岳县', '337', 'a', 'ayx', 'anyuexian');
INSERT INTO `region_areas` VALUES ('2068', '512022', '乐至县', '337', 'l', 'lzx', 'lezhixian');
INSERT INTO `region_areas` VALUES ('2069', '512081', '简阳市', '337', 'j', 'jys', 'jianyangshi');
INSERT INTO `region_areas` VALUES ('207', '140429', '武乡县', '47', 'w', 'wxx', 'wuxiangxian');
INSERT INTO `region_areas` VALUES ('2070', '513221', '汶川县', '338', 'w', 'wcx', 'wenchuanxian');
INSERT INTO `region_areas` VALUES ('2071', '513222', '理县', '338', 'l', 'lx', 'lixian');
INSERT INTO `region_areas` VALUES ('2072', '513223', '茂县', '338', 'm', 'mx', 'maoxian');
INSERT INTO `region_areas` VALUES ('2073', '513224', '松潘县', '338', 's', 'spx', 'songpanxian');
INSERT INTO `region_areas` VALUES ('2074', '513225', '九寨沟县', '338', 'j', 'jzgx', 'jiuzhaigouxian');
INSERT INTO `region_areas` VALUES ('2075', '513226', '金川县', '338', 'j', 'jcx', 'jinchuanxian');
INSERT INTO `region_areas` VALUES ('2076', '513227', '小金县', '338', 'x', 'xjx', 'xiaojinxian');
INSERT INTO `region_areas` VALUES ('2077', '513228', '黑水县', '338', 'h', 'hsx', 'heishuixian');
INSERT INTO `region_areas` VALUES ('2078', '513229', '马尔康县', '338', 'm', 'mekx', 'maerkangxian');
INSERT INTO `region_areas` VALUES ('2079', '513230', '壤塘县', '338', 'r', 'rtx', 'rangtangxian');
INSERT INTO `region_areas` VALUES ('208', '140430', '沁县', '47', 'q', 'qx', 'qinxian');
INSERT INTO `region_areas` VALUES ('2080', '513231', '阿坝县', '338', 'a', 'abx', 'abaxian');
INSERT INTO `region_areas` VALUES ('2081', '513232', '若尔盖县', '338', 'r', 'regx', 'ruoergaixian');
INSERT INTO `region_areas` VALUES ('2082', '513233', '红原县', '338', 'h', 'hyx', 'hongyuanxian');
INSERT INTO `region_areas` VALUES ('2083', '513321', '康定县', '339', 'k', 'kdx', 'kangdingxian');
INSERT INTO `region_areas` VALUES ('2084', '513322', '泸定县', '339', 'l', 'ldx', 'ludingxian');
INSERT INTO `region_areas` VALUES ('2085', '513323', '丹巴县', '339', 'd', 'dbx', 'danbaxian');
INSERT INTO `region_areas` VALUES ('2086', '513324', '九龙县', '339', 'j', 'jlx', 'jiulongxian');
INSERT INTO `region_areas` VALUES ('2087', '513325', '雅江县', '339', 'y', 'yjx', 'yajiangxian');
INSERT INTO `region_areas` VALUES ('2088', '513326', '道孚县', '339', 'd', 'dfx', 'daofuxian');
INSERT INTO `region_areas` VALUES ('2089', '513327', '炉霍县', '339', 'l', 'lhx', 'luhuoxian');
INSERT INTO `region_areas` VALUES ('209', '140431', '沁源县', '47', 'q', 'qyx', 'qinyuanxian');
INSERT INTO `region_areas` VALUES ('2090', '513328', '甘孜县', '339', 'g', 'gzx', 'ganzixian');
INSERT INTO `region_areas` VALUES ('2091', '513329', '新龙县', '339', 'x', 'xlx', 'xinlongxian');
INSERT INTO `region_areas` VALUES ('2092', '513330', '德格县', '339', 'd', 'dgx', 'degexian');
INSERT INTO `region_areas` VALUES ('2093', '513331', '白玉县', '339', 'b', 'byx', 'baiyuxian');
INSERT INTO `region_areas` VALUES ('2094', '513332', '石渠县', '339', 's', 'sqx', 'shiquxian');
INSERT INTO `region_areas` VALUES ('2095', '513333', '色达县', '339', 's', 'sdx', 'sedaxian');
INSERT INTO `region_areas` VALUES ('2096', '513334', '理塘县', '339', 'l', 'ltx', 'litangxian');
INSERT INTO `region_areas` VALUES ('2097', '513335', '巴塘县', '339', 'b', 'btx', 'batangxian');
INSERT INTO `region_areas` VALUES ('2098', '513336', '乡城县', '339', 'x', 'xcx', 'xiangchengxian');
INSERT INTO `region_areas` VALUES ('2099', '513337', '稻城县', '339', 'd', 'dcx', 'daochengxian');
INSERT INTO `region_areas` VALUES ('21', '130183', '晋州市', '33', 'j', 'jzs', 'jinzhoushi');
INSERT INTO `region_areas` VALUES ('210', '140481', '潞城市', '47', 'l', 'lcs', 'luchengshi');
INSERT INTO `region_areas` VALUES ('2100', '513338', '得荣县', '339', 'd', 'drx', 'derongxian');
INSERT INTO `region_areas` VALUES ('2101', '513401', '西昌市', '340', 'x', 'xcs', 'xichangshi');
INSERT INTO `region_areas` VALUES ('2102', '513422', '木里藏族自治县', '340', 'm', 'mlzzzzx', 'mulizangzuzizhixian');
INSERT INTO `region_areas` VALUES ('2103', '513423', '盐源县', '340', 'y', 'yyx', 'yanyuanxian');
INSERT INTO `region_areas` VALUES ('2104', '513424', '德昌县', '340', 'd', 'dcx', 'dechangxian');
INSERT INTO `region_areas` VALUES ('2105', '513425', '会理县', '340', 'h', 'hlx', 'huilixian');
INSERT INTO `region_areas` VALUES ('2106', '513426', '会东县', '340', 'h', 'hdx', 'huidongxian');
INSERT INTO `region_areas` VALUES ('2107', '513427', '宁南县', '340', 'n', 'nnx', 'ningnanxian');
INSERT INTO `region_areas` VALUES ('2108', '513428', '普格县', '340', 'p', 'pgx', 'pugexian');
INSERT INTO `region_areas` VALUES ('2109', '513429', '布拖县', '340', 'b', 'btx', 'butuoxian');
INSERT INTO `region_areas` VALUES ('211', '140502', '城区', '48', 'c', 'cq', 'chengqu');
INSERT INTO `region_areas` VALUES ('2110', '513430', '金阳县', '340', 'j', 'jyx', 'jinyangxian');
INSERT INTO `region_areas` VALUES ('2111', '513431', '昭觉县', '340', 'z', 'zjx', 'zhaojuexian');
INSERT INTO `region_areas` VALUES ('2112', '513432', '喜德县', '340', 'x', 'xdx', 'xidexian');
INSERT INTO `region_areas` VALUES ('2113', '513433', '冕宁县', '340', 'm', 'mnx', 'mianningxian');
INSERT INTO `region_areas` VALUES ('2114', '513434', '越西县', '340', 'y', 'yxx', 'yuexixian');
INSERT INTO `region_areas` VALUES ('2115', '513435', '甘洛县', '340', 'g', 'glx', 'ganluoxian');
INSERT INTO `region_areas` VALUES ('2116', '513436', '美姑县', '340', 'm', 'mgx', 'meiguxian');
INSERT INTO `region_areas` VALUES ('2117', '513437', '雷波县', '340', 'l', 'lbx', 'leiboxian');
INSERT INTO `region_areas` VALUES ('2118', '520102', '南明区', '341', 'n', 'nmq', 'nanmingqu');
INSERT INTO `region_areas` VALUES ('2119', '520103', '云岩区', '341', 'y', 'yyq', 'yunyanqu');
INSERT INTO `region_areas` VALUES ('212', '140521', '沁水县', '48', 'q', 'qsx', 'qinshuixian');
INSERT INTO `region_areas` VALUES ('2120', '520111', '花溪区', '341', 'h', 'hxq', 'huaxiqu');
INSERT INTO `region_areas` VALUES ('2121', '520112', '乌当区', '341', 'w', 'wdq', 'wudangqu');
INSERT INTO `region_areas` VALUES ('2122', '520113', '白云区', '341', 'b', 'byq', 'baiyunqu');
INSERT INTO `region_areas` VALUES ('2123', '520115', '观山湖区', '341', 'g', 'gshq', 'guanshanhuqu');
INSERT INTO `region_areas` VALUES ('2124', '520121', '开阳县', '341', 'k', 'kyx', 'kaiyangxian');
INSERT INTO `region_areas` VALUES ('2125', '520122', '息烽县', '341', 'x', 'xfx', 'xifengxian');
INSERT INTO `region_areas` VALUES ('2126', '520123', '修文县', '341', 'x', 'xwx', 'xiuwenxian');
INSERT INTO `region_areas` VALUES ('2127', '520181', '清镇市', '341', 'q', 'qzs', 'qingzhenshi');
INSERT INTO `region_areas` VALUES ('2128', '520201', '钟山区', '342', 'z', 'zsq', 'zhongshanqu');
INSERT INTO `region_areas` VALUES ('2129', '520203', '六枝特区', '342', 'l', 'lztq', 'liuzhitequ');
INSERT INTO `region_areas` VALUES ('213', '140522', '阳城县', '48', 'y', 'ycx', 'yangchengxian');
INSERT INTO `region_areas` VALUES ('2130', '520221', '水城县', '342', 's', 'scx', 'shuichengxian');
INSERT INTO `region_areas` VALUES ('2131', '520222', '盘县', '342', 'p', 'px', 'panxian');
INSERT INTO `region_areas` VALUES ('2132', '520302', '红花岗区', '343', 'h', 'hhgq', 'honghuagangqu');
INSERT INTO `region_areas` VALUES ('2133', '520303', '汇川区', '343', 'h', 'hcq', 'huichuanqu');
INSERT INTO `region_areas` VALUES ('2134', '520321', '遵义县', '343', 'z', 'zyx', 'zunyixian');
INSERT INTO `region_areas` VALUES ('2135', '520322', '桐梓县', '343', 't', 'tzx', 'tongzixian');
INSERT INTO `region_areas` VALUES ('2136', '520323', '绥阳县', '343', 's', 'syx', 'suiyangxian');
INSERT INTO `region_areas` VALUES ('2137', '520324', '正安县', '343', 'z', 'zax', 'zhenganxian');
INSERT INTO `region_areas` VALUES ('2138', '520325', '道真仡佬族苗族自治县', '343', 'd', 'dzglzmzzzx', 'daozhengelaozumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('2139', '520326', '务川仡佬族苗族自治县', '343', 'w', 'wcglzmzzzx', 'wuchuangelaozumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('214', '140524', '陵川县', '48', 'l', 'lcx', 'lingchuanxian');
INSERT INTO `region_areas` VALUES ('2140', '520327', '凤冈县', '343', 'f', 'fgx', 'fenggangxian');
INSERT INTO `region_areas` VALUES ('2141', '520328', '湄潭县', '343', 'm', 'mtx', 'meitanxian');
INSERT INTO `region_areas` VALUES ('2142', '520329', '余庆县', '343', 'y', 'yqx', 'yuqingxian');
INSERT INTO `region_areas` VALUES ('2143', '520330', '习水县', '343', 'x', 'xsx', 'xishuixian');
INSERT INTO `region_areas` VALUES ('2144', '520381', '赤水市', '343', 'c', 'css', 'chishuishi');
INSERT INTO `region_areas` VALUES ('2145', '520382', '仁怀市', '343', 'r', 'rhs', 'renhuaishi');
INSERT INTO `region_areas` VALUES ('2146', '520402', '西秀区', '344', 'x', 'xxq', 'xixiuqu');
INSERT INTO `region_areas` VALUES ('2147', '520421', '平坝县', '344', 'p', 'pbx', 'pingbaxian');
INSERT INTO `region_areas` VALUES ('2148', '520422', '普定县', '344', 'p', 'pdx', 'pudingxian');
INSERT INTO `region_areas` VALUES ('2149', '520423', '镇宁布依族苗族自治县', '344', 'z', 'znbyzmzzzx', 'zhenningbuyizumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('215', '140525', '泽州县', '48', 'z', 'zzx', 'zezhouxian');
INSERT INTO `region_areas` VALUES ('2150', '520424', '关岭布依族苗族自治县', '344', 'g', 'glbyzmzzzx', 'guanlingbuyizumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('2151', '520425', '紫云苗族布依族自治县', '344', 'z', 'zymzbyzzzx', 'ziyunmiaozubuyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2152', '520502', '七星关区', '345', 'q', 'qxgq', 'qixingguanqu');
INSERT INTO `region_areas` VALUES ('2153', '520521', '大方县', '345', 'd', 'dfx', 'dafangxian');
INSERT INTO `region_areas` VALUES ('2154', '520522', '黔西县', '345', 'q', 'qxx', 'qianxixian');
INSERT INTO `region_areas` VALUES ('2155', '520523', '金沙县', '345', 'j', 'jsx', 'jinshaxian');
INSERT INTO `region_areas` VALUES ('2156', '520524', '织金县', '345', 'z', 'zjx', 'zhijinxian');
INSERT INTO `region_areas` VALUES ('2157', '520525', '纳雍县', '345', 'n', 'nyx', 'nayongxian');
INSERT INTO `region_areas` VALUES ('2158', '520526', '威宁彝族回族苗族自治县', '345', 'w', 'wnyzhzmzzzx', 'weiningyizuhuizumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('2159', '520527', '赫章县', '345', 'h', 'hzx', 'hezhangxian');
INSERT INTO `region_areas` VALUES ('216', '140581', '高平市', '48', 'g', 'gps', 'gaopingshi');
INSERT INTO `region_areas` VALUES ('2160', '520602', '碧江区', '346', 'b', 'bjq', 'bijiangqu');
INSERT INTO `region_areas` VALUES ('2161', '520603', '万山区', '346', 'w', 'wsq', 'wanshanqu');
INSERT INTO `region_areas` VALUES ('2162', '520621', '江口县', '346', 'j', 'jkx', 'jiangkouxian');
INSERT INTO `region_areas` VALUES ('2163', '520622', '玉屏侗族自治县', '346', 'y', 'ypdzzzx', 'yupingdongzuzizhixian');
INSERT INTO `region_areas` VALUES ('2164', '520623', '石阡县', '346', 's', 'sqx', 'shiqianxian');
INSERT INTO `region_areas` VALUES ('2165', '520624', '思南县', '346', 's', 'snx', 'sinanxian');
INSERT INTO `region_areas` VALUES ('2166', '520625', '印江土家族苗族自治县', '346', 'y', 'yjtjzmzzzx', 'yinjiangtujiazumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('2167', '520626', '德江县', '346', 'd', 'djx', 'dejiangxian');
INSERT INTO `region_areas` VALUES ('2168', '520627', '沿河土家族自治县', '346', 'y', 'yhtjzzzx', 'yanhetujiazuzizhixian');
INSERT INTO `region_areas` VALUES ('2169', '520628', '松桃苗族自治县', '346', 's', 'stmzzzx', 'songtaomiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('217', '140602', '朔城区', '49', 's', 'scq', 'shuochengqu');
INSERT INTO `region_areas` VALUES ('2170', '522301', '兴义市', '347', 'x', 'xys', 'xingyishi');
INSERT INTO `region_areas` VALUES ('2171', '522322', '兴仁县', '347', 'x', 'xrx', 'xingrenxian');
INSERT INTO `region_areas` VALUES ('2172', '522323', '普安县', '347', 'p', 'pax', 'puanxian');
INSERT INTO `region_areas` VALUES ('2173', '522324', '晴隆县', '347', 'q', 'qlx', 'qinglongxian');
INSERT INTO `region_areas` VALUES ('2174', '522325', '贞丰县', '347', 'z', 'zfx', 'zhenfengxian');
INSERT INTO `region_areas` VALUES ('2175', '522326', '望谟县', '347', 'w', 'wmx', 'wangmoxian');
INSERT INTO `region_areas` VALUES ('2176', '522327', '册亨县', '347', 'c', 'chx', 'cehengxian');
INSERT INTO `region_areas` VALUES ('2177', '522328', '安龙县', '347', 'a', 'alx', 'anlongxian');
INSERT INTO `region_areas` VALUES ('2178', '522601', '凯里市', '348', 'k', 'kls', 'kailishi');
INSERT INTO `region_areas` VALUES ('2179', '522622', '黄平县', '348', 'h', 'hpx', 'huangpingxian');
INSERT INTO `region_areas` VALUES ('218', '140603', '平鲁区', '49', 'p', 'plq', 'pingluqu');
INSERT INTO `region_areas` VALUES ('2180', '522623', '施秉县', '348', 's', 'sbx', 'shibingxian');
INSERT INTO `region_areas` VALUES ('2181', '522624', '三穗县', '348', 's', 'ssx', 'sansuixian');
INSERT INTO `region_areas` VALUES ('2182', '522625', '镇远县', '348', 'z', 'zyx', 'zhenyuanxian');
INSERT INTO `region_areas` VALUES ('2183', '522626', '岑巩县', '348', 'c', 'cgx', 'cengongxian');
INSERT INTO `region_areas` VALUES ('2184', '522627', '天柱县', '348', 't', 'tzx', 'tianzhuxian');
INSERT INTO `region_areas` VALUES ('2185', '522628', '锦屏县', '348', 'j', 'jpx', 'jinpingxian');
INSERT INTO `region_areas` VALUES ('2186', '522629', '剑河县', '348', 'j', 'jhx', 'jianhexian');
INSERT INTO `region_areas` VALUES ('2187', '522630', '台江县', '348', 't', 'tjx', 'taijiangxian');
INSERT INTO `region_areas` VALUES ('2188', '522631', '黎平县', '348', 'l', 'lpx', 'lipingxian');
INSERT INTO `region_areas` VALUES ('2189', '522632', '榕江县', '348', 'r', 'rjx', 'rongjiangxian');
INSERT INTO `region_areas` VALUES ('219', '140621', '山阴县', '49', 's', 'syx', 'shanyinxian');
INSERT INTO `region_areas` VALUES ('2190', '522633', '从江县', '348', 'c', 'cjx', 'congjiangxian');
INSERT INTO `region_areas` VALUES ('2191', '522634', '雷山县', '348', 'l', 'lsx', 'leishanxian');
INSERT INTO `region_areas` VALUES ('2192', '522635', '麻江县', '348', 'm', 'mjx', 'majiangxian');
INSERT INTO `region_areas` VALUES ('2193', '522636', '丹寨县', '348', 'd', 'dzx', 'danzhaixian');
INSERT INTO `region_areas` VALUES ('2194', '522701', '都匀市', '349', 'd', 'dys', 'douyunshi');
INSERT INTO `region_areas` VALUES ('2195', '522702', '福泉市', '349', 'f', 'fqs', 'fuquanshi');
INSERT INTO `region_areas` VALUES ('2196', '522722', '荔波县', '349', 'l', 'lbx', 'liboxian');
INSERT INTO `region_areas` VALUES ('2197', '522723', '贵定县', '349', 'g', 'gdx', 'guidingxian');
INSERT INTO `region_areas` VALUES ('2198', '522725', '瓮安县', '349', 'w', 'wax', 'wenganxian');
INSERT INTO `region_areas` VALUES ('2199', '522726', '独山县', '349', 'd', 'dsx', 'dushanxian');
INSERT INTO `region_areas` VALUES ('22', '130184', '新乐市', '33', 'x', 'xls', 'xinleshi');
INSERT INTO `region_areas` VALUES ('220', '140622', '应县', '49', 'y', 'yx', 'yingxian');
INSERT INTO `region_areas` VALUES ('2200', '522727', '平塘县', '349', 'p', 'ptx', 'pingtangxian');
INSERT INTO `region_areas` VALUES ('2201', '522728', '罗甸县', '349', 'l', 'ldx', 'luodianxian');
INSERT INTO `region_areas` VALUES ('2202', '522729', '长顺县', '349', 'z', 'zsx', 'zhangshunxian');
INSERT INTO `region_areas` VALUES ('2203', '522730', '龙里县', '349', 'l', 'llx', 'longlixian');
INSERT INTO `region_areas` VALUES ('2204', '522731', '惠水县', '349', 'h', 'hsx', 'huishuixian');
INSERT INTO `region_areas` VALUES ('2205', '522732', '三都水族自治县', '349', 's', 'sdszzzx', 'sandoushuizuzizhixian');
INSERT INTO `region_areas` VALUES ('2206', '530102', '五华区', '350', 'w', 'whq', 'wuhuaqu');
INSERT INTO `region_areas` VALUES ('2207', '530103', '盘龙区', '350', 'p', 'plq', 'panlongqu');
INSERT INTO `region_areas` VALUES ('2208', '530111', '官渡区', '350', 'g', 'gdq', 'guanduqu');
INSERT INTO `region_areas` VALUES ('2209', '530112', '西山区', '350', 'x', 'xsq', 'xishanqu');
INSERT INTO `region_areas` VALUES ('221', '140623', '右玉县', '49', 'y', 'yyx', 'youyuxian');
INSERT INTO `region_areas` VALUES ('2210', '530113', '东川区', '350', 'd', 'dcq', 'dongchuanqu');
INSERT INTO `region_areas` VALUES ('2211', '530114', '呈贡区', '350', 'c', 'cgq', 'chenggongqu');
INSERT INTO `region_areas` VALUES ('2212', '530122', '晋宁县', '350', 'j', 'jnx', 'jinningxian');
INSERT INTO `region_areas` VALUES ('2213', '530124', '富民县', '350', 'f', 'fmx', 'fuminxian');
INSERT INTO `region_areas` VALUES ('2214', '530125', '宜良县', '350', 'y', 'ylx', 'yiliangxian');
INSERT INTO `region_areas` VALUES ('2215', '530126', '石林彝族自治县', '350', 's', 'slyzzzx', 'shilinyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2216', '530127', '嵩明县', '350', 's', 'smx', 'songmingxian');
INSERT INTO `region_areas` VALUES ('2217', '530128', '禄劝彝族苗族自治县', '350', 'l', 'lqyzmzzzx', 'luquanyizumiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('2218', '530129', '寻甸回族彝族自治县', '350', 'x', 'xdhzyzzzx', 'xundianhuizuyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2219', '530181', '安宁市', '350', 'a', 'ans', 'anningshi');
INSERT INTO `region_areas` VALUES ('222', '140624', '怀仁县', '49', 'h', 'hrx', 'huairenxian');
INSERT INTO `region_areas` VALUES ('2220', '530302', '麒麟区', '351', 'q', 'qlq', 'qilinqu');
INSERT INTO `region_areas` VALUES ('2221', '530321', '马龙县', '351', 'm', 'mlx', 'malongxian');
INSERT INTO `region_areas` VALUES ('2222', '530322', '陆良县', '351', 'l', 'llx', 'luliangxian');
INSERT INTO `region_areas` VALUES ('2223', '530323', '师宗县', '351', 's', 'szx', 'shizongxian');
INSERT INTO `region_areas` VALUES ('2224', '530324', '罗平县', '351', 'l', 'lpx', 'luopingxian');
INSERT INTO `region_areas` VALUES ('2225', '530325', '富源县', '351', 'f', 'fyx', 'fuyuanxian');
INSERT INTO `region_areas` VALUES ('2226', '530326', '会泽县', '351', 'h', 'hzx', 'huizexian');
INSERT INTO `region_areas` VALUES ('2227', '530328', '沾益县', '351', 'z', 'zyx', 'zhanyixian');
INSERT INTO `region_areas` VALUES ('2228', '530381', '宣威市', '351', 'x', 'xws', 'xuanweishi');
INSERT INTO `region_areas` VALUES ('2229', '530402', '红塔区', '352', 'h', 'htq', 'hongtaqu');
INSERT INTO `region_areas` VALUES ('223', '140702', '榆次区', '50', 'y', 'ycq', 'yuciqu');
INSERT INTO `region_areas` VALUES ('2230', '530421', '江川县', '352', 'j', 'jcx', 'jiangchuanxian');
INSERT INTO `region_areas` VALUES ('2231', '530422', '澄江县', '352', 'c', 'cjx', 'chengjiangxian');
INSERT INTO `region_areas` VALUES ('2232', '530423', '通海县', '352', 't', 'thx', 'tonghaixian');
INSERT INTO `region_areas` VALUES ('2233', '530424', '华宁县', '352', 'h', 'hnx', 'huaningxian');
INSERT INTO `region_areas` VALUES ('2234', '530425', '易门县', '352', 'y', 'ymx', 'yimenxian');
INSERT INTO `region_areas` VALUES ('2235', '530426', '峨山彝族自治县', '352', 'e', 'esyzzzx', 'eshanyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2236', '530427', '新平彝族傣族自治县', '352', 'x', 'xpyzdzzzx', 'xinpingyizudaizuzizhixian');
INSERT INTO `region_areas` VALUES ('2237', '530428', '元江哈尼族彝族傣族自治县', '352', 'y', 'yjhnzyzdzzzx', 'yuanjianghanizuyizudaizuzizhixian');
INSERT INTO `region_areas` VALUES ('2238', '530502', '隆阳区', '353', 'l', 'lyq', 'longyangqu');
INSERT INTO `region_areas` VALUES ('2239', '530521', '施甸县', '353', 's', 'sdx', 'shidianxian');
INSERT INTO `region_areas` VALUES ('224', '140721', '榆社县', '50', 'y', 'ysx', 'yushexian');
INSERT INTO `region_areas` VALUES ('2240', '530522', '腾冲县', '353', 't', 'tcx', 'tengchongxian');
INSERT INTO `region_areas` VALUES ('2241', '530523', '龙陵县', '353', 'l', 'llx', 'longlingxian');
INSERT INTO `region_areas` VALUES ('2242', '530524', '昌宁县', '353', 'c', 'cnx', 'changningxian');
INSERT INTO `region_areas` VALUES ('2243', '530602', '昭阳区', '354', 'z', 'zyq', 'zhaoyangqu');
INSERT INTO `region_areas` VALUES ('2244', '530621', '鲁甸县', '354', 'l', 'ldx', 'ludianxian');
INSERT INTO `region_areas` VALUES ('2245', '530622', '巧家县', '354', 'q', 'qjx', 'qiaojiaxian');
INSERT INTO `region_areas` VALUES ('2246', '530623', '盐津县', '354', 'y', 'yjx', 'yanjinxian');
INSERT INTO `region_areas` VALUES ('2247', '530624', '大关县', '354', 'd', 'dgx', 'daguanxian');
INSERT INTO `region_areas` VALUES ('2248', '530625', '永善县', '354', 'y', 'ysx', 'yongshanxian');
INSERT INTO `region_areas` VALUES ('2249', '530626', '绥江县', '354', 's', 'sjx', 'suijiangxian');
INSERT INTO `region_areas` VALUES ('225', '140722', '左权县', '50', 'z', 'zqx', 'zuoquanxian');
INSERT INTO `region_areas` VALUES ('2250', '530627', '镇雄县', '354', 'z', 'zxx', 'zhenxiongxian');
INSERT INTO `region_areas` VALUES ('2251', '530628', '彝良县', '354', 'y', 'ylx', 'yiliangxian');
INSERT INTO `region_areas` VALUES ('2252', '530629', '威信县', '354', 'w', 'wxx', 'weixinxian');
INSERT INTO `region_areas` VALUES ('2253', '530630', '水富县', '354', 's', 'sfx', 'shuifuxian');
INSERT INTO `region_areas` VALUES ('2254', '530702', '古城区', '355', 'g', 'gcq', 'guchengqu');
INSERT INTO `region_areas` VALUES ('2255', '530721', '玉龙纳西族自治县', '355', 'y', 'ylnxzzzx', 'yulongnaxizuzizhixian');
INSERT INTO `region_areas` VALUES ('2256', '530722', '永胜县', '355', 'y', 'ysx', 'yongshengxian');
INSERT INTO `region_areas` VALUES ('2257', '530723', '华坪县', '355', 'h', 'hpx', 'huapingxian');
INSERT INTO `region_areas` VALUES ('2258', '530724', '宁蒗彝族自治县', '355', 'n', 'nlyzzzx', 'ninglangyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2259', '530802', '思茅区', '356', 's', 'smq', 'simaoqu');
INSERT INTO `region_areas` VALUES ('226', '140723', '和顺县', '50', 'h', 'hsx', 'heshunxian');
INSERT INTO `region_areas` VALUES ('2260', '530821', '宁洱哈尼族彝族自治县', '356', 'n', 'nehnzyzzzx', 'ningerhanizuyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2261', '530822', '墨江哈尼族自治县', '356', 'm', 'mjhnzzzx', 'mojianghanizuzizhixian');
INSERT INTO `region_areas` VALUES ('2262', '530823', '景东彝族自治县', '356', 'j', 'jdyzzzx', 'jingdongyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2263', '530824', '景谷傣族彝族自治县', '356', 'j', 'jgdzyzzzx', 'jinggudaizuyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2264', '530825', '镇沅彝族哈尼族拉祜族自治县', '356', 'z', 'zyyzhnzlhzzzx', 'zhenyuanyizuhanizulahuzuzizhixian');
INSERT INTO `region_areas` VALUES ('2265', '530826', '江城哈尼族彝族自治县', '356', 'j', 'jchnzyzzzx', 'jiangchenghanizuyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2266', '530827', '孟连傣族拉祜族佤族自治县', '356', 'm', 'mldzlhzwzzzx', 'mengliandaizulahuzuwazuzizhixian');
INSERT INTO `region_areas` VALUES ('2267', '530828', '澜沧拉祜族自治县', '356', 'l', 'lclhzzzx', 'lancanglahuzuzizhixian');
INSERT INTO `region_areas` VALUES ('2268', '530829', '西盟佤族自治县', '356', 'x', 'xmwzzzx', 'ximengwazuzizhixian');
INSERT INTO `region_areas` VALUES ('2269', '530902', '临翔区', '357', 'l', 'lxq', 'linxiangqu');
INSERT INTO `region_areas` VALUES ('227', '140724', '昔阳县', '50', 'x', 'xyx', 'xiyangxian');
INSERT INTO `region_areas` VALUES ('2270', '530921', '凤庆县', '357', 'f', 'fqx', 'fengqingxian');
INSERT INTO `region_areas` VALUES ('2271', '530922', '云县', '357', 'y', 'yx', 'yunxian');
INSERT INTO `region_areas` VALUES ('2272', '530923', '永德县', '357', 'y', 'ydx', 'yongdexian');
INSERT INTO `region_areas` VALUES ('2273', '530924', '镇康县', '357', 'z', 'zkx', 'zhenkangxian');
INSERT INTO `region_areas` VALUES ('2274', '530925', '双江拉祜族佤族布朗族傣族自治县', '357', 's', 'sjlhzwzblzdzzzx', 'shuangjianglahuzuwazubulangzudaizuzizhixian');
INSERT INTO `region_areas` VALUES ('2275', '530926', '耿马傣族佤族自治县', '357', 'g', 'gmdzwzzzx', 'gengmadaizuwazuzizhixian');
INSERT INTO `region_areas` VALUES ('2276', '530927', '沧源佤族自治县', '357', 'c', 'cywzzzx', 'cangyuanwazuzizhixian');
INSERT INTO `region_areas` VALUES ('2277', '532301', '楚雄市', '358', 'c', 'cxs', 'chuxiongshi');
INSERT INTO `region_areas` VALUES ('2278', '532322', '双柏县', '358', 's', 'sbx', 'shuangboxian');
INSERT INTO `region_areas` VALUES ('2279', '532323', '牟定县', '358', 'm', 'mdx', 'moudingxian');
INSERT INTO `region_areas` VALUES ('228', '140725', '寿阳县', '50', 's', 'syx', 'shouyangxian');
INSERT INTO `region_areas` VALUES ('2280', '532324', '南华县', '358', 'n', 'nhx', 'nanhuaxian');
INSERT INTO `region_areas` VALUES ('2281', '532325', '姚安县', '358', 'y', 'yax', 'yaoanxian');
INSERT INTO `region_areas` VALUES ('2282', '532326', '大姚县', '358', 'd', 'dyx', 'dayaoxian');
INSERT INTO `region_areas` VALUES ('2283', '532327', '永仁县', '358', 'y', 'yrx', 'yongrenxian');
INSERT INTO `region_areas` VALUES ('2284', '532328', '元谋县', '358', 'y', 'ymx', 'yuanmouxian');
INSERT INTO `region_areas` VALUES ('2285', '532329', '武定县', '358', 'w', 'wdx', 'wudingxian');
INSERT INTO `region_areas` VALUES ('2286', '532331', '禄丰县', '358', 'l', 'lfx', 'lufengxian');
INSERT INTO `region_areas` VALUES ('2287', '532501', '个旧市', '359', 'g', 'gjs', 'gejiushi');
INSERT INTO `region_areas` VALUES ('2288', '532502', '开远市', '359', 'k', 'kys', 'kaiyuanshi');
INSERT INTO `region_areas` VALUES ('2289', '532503', '蒙自市', '359', 'm', 'mzs', 'mengzishi');
INSERT INTO `region_areas` VALUES ('229', '140726', '太谷县', '50', 't', 'tgx', 'taiguxian');
INSERT INTO `region_areas` VALUES ('2290', '532504', '弥勒市', '359', 'm', 'mls', 'mileshi');
INSERT INTO `region_areas` VALUES ('2291', '532523', '屏边苗族自治县', '359', 'p', 'pbmzzzx', 'pingbianmiaozuzizhixian');
INSERT INTO `region_areas` VALUES ('2292', '532524', '建水县', '359', 'j', 'jsx', 'jianshuixian');
INSERT INTO `region_areas` VALUES ('2293', '532525', '石屏县', '359', 's', 'spx', 'shipingxian');
INSERT INTO `region_areas` VALUES ('2294', '532527', '泸西县', '359', 'l', 'lxx', 'luxixian');
INSERT INTO `region_areas` VALUES ('2295', '532528', '元阳县', '359', 'y', 'yyx', 'yuanyangxian');
INSERT INTO `region_areas` VALUES ('2296', '532529', '红河县', '359', 'h', 'hhx', 'honghexian');
INSERT INTO `region_areas` VALUES ('2297', '532530', '金平苗族瑶族傣族自治县', '359', 'j', 'jpmzyzdzzzx', 'jinpingmiaozuyaozudaizuzizhixian');
INSERT INTO `region_areas` VALUES ('2298', '532531', '绿春县', '359', 'l', 'lcx', 'lu:chunxian');
INSERT INTO `region_areas` VALUES ('2299', '532532', '河口瑶族自治县', '359', 'h', 'hkyzzzx', 'hekouyaozuzizhixian');
INSERT INTO `region_areas` VALUES ('23', '130202', '路南区', '34', 'l', 'lnq', 'lunanqu');
INSERT INTO `region_areas` VALUES ('230', '140727', '祁县', '50', 'q', 'qx', 'qixian');
INSERT INTO `region_areas` VALUES ('2300', '532601', '文山市', '360', 'w', 'wss', 'wenshanshi');
INSERT INTO `region_areas` VALUES ('2301', '532622', '砚山县', '360', 'y', 'ysx', 'yanshanxian');
INSERT INTO `region_areas` VALUES ('2302', '532623', '西畴县', '360', 'x', 'xcx', 'xichouxian');
INSERT INTO `region_areas` VALUES ('2303', '532624', '麻栗坡县', '360', 'm', 'mlpx', 'malipoxian');
INSERT INTO `region_areas` VALUES ('2304', '532625', '马关县', '360', 'm', 'mgx', 'maguanxian');
INSERT INTO `region_areas` VALUES ('2305', '532626', '丘北县', '360', 'q', 'qbx', 'qiubeixian');
INSERT INTO `region_areas` VALUES ('2306', '532627', '广南县', '360', 'g', 'gnx', 'guangnanxian');
INSERT INTO `region_areas` VALUES ('2307', '532628', '富宁县', '360', 'f', 'fnx', 'funingxian');
INSERT INTO `region_areas` VALUES ('2308', '532801', '景洪市', '361', 'j', 'jhs', 'jinghongshi');
INSERT INTO `region_areas` VALUES ('2309', '532822', '勐海县', '361', 'm', 'mhx', 'menghaixian');
INSERT INTO `region_areas` VALUES ('231', '140728', '平遥县', '50', 'p', 'pyx', 'pingyaoxian');
INSERT INTO `region_areas` VALUES ('2310', '532823', '勐腊县', '361', 'm', 'mlx', 'menglaxian');
INSERT INTO `region_areas` VALUES ('2311', '532901', '大理市', '362', 'd', 'dls', 'dalishi');
INSERT INTO `region_areas` VALUES ('2312', '532922', '漾濞彝族自治县', '362', 'y', 'ybyzzzx', 'yangbiyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2313', '532923', '祥云县', '362', 'x', 'xyx', 'xiangyunxian');
INSERT INTO `region_areas` VALUES ('2314', '532924', '宾川县', '362', 'b', 'bcx', 'binchuanxian');
INSERT INTO `region_areas` VALUES ('2315', '532925', '弥渡县', '362', 'm', 'mdx', 'miduxian');
INSERT INTO `region_areas` VALUES ('2316', '532926', '南涧彝族自治县', '362', 'n', 'njyzzzx', 'nanjianyizuzizhixian');
INSERT INTO `region_areas` VALUES ('2317', '532927', '巍山彝族回族自治县', '362', 'w', 'wsyzhzzzx', 'weishanyizuhuizuzizhixian');
INSERT INTO `region_areas` VALUES ('2318', '532928', '永平县', '362', 'y', 'ypx', 'yongpingxian');
INSERT INTO `region_areas` VALUES ('2319', '532929', '云龙县', '362', 'y', 'ylx', 'yunlongxian');
INSERT INTO `region_areas` VALUES ('232', '140729', '灵石县', '50', 'l', 'lsx', 'lingshixian');
INSERT INTO `region_areas` VALUES ('2320', '532930', '洱源县', '362', 'e', 'eyx', 'eryuanxian');
INSERT INTO `region_areas` VALUES ('2321', '532931', '剑川县', '362', 'j', 'jcx', 'jianchuanxian');
INSERT INTO `region_areas` VALUES ('2322', '532932', '鹤庆县', '362', 'h', 'hqx', 'heqingxian');
INSERT INTO `region_areas` VALUES ('2323', '533102', '瑞丽市', '363', 'r', 'rls', 'ruilishi');
INSERT INTO `region_areas` VALUES ('2324', '533103', '芒市', '363', 'm', 'ms', 'mangshi');
INSERT INTO `region_areas` VALUES ('2325', '533122', '梁河县', '363', 'l', 'lhx', 'lianghexian');
INSERT INTO `region_areas` VALUES ('2326', '533123', '盈江县', '363', 'y', 'yjx', 'yingjiangxian');
INSERT INTO `region_areas` VALUES ('2327', '533124', '陇川县', '363', 'l', 'lcx', 'longchuanxian');
INSERT INTO `region_areas` VALUES ('2328', '533321', '泸水县', '364', 'l', 'lsx', 'lushuixian');
INSERT INTO `region_areas` VALUES ('2329', '533323', '福贡县', '364', 'f', 'fgx', 'fugongxian');
INSERT INTO `region_areas` VALUES ('233', '140781', '介休市', '50', 'j', 'jxs', 'jiexiushi');
INSERT INTO `region_areas` VALUES ('2330', '533324', '贡山独龙族怒族自治县', '364', 'g', 'gsdlznzzzx', 'gongshandulongzunuzuzizhixian');
INSERT INTO `region_areas` VALUES ('2331', '533325', '兰坪白族普米族自治县', '364', 'l', 'lpbzpmzzzx', 'lanpingbaizupumizuzizhixian');
INSERT INTO `region_areas` VALUES ('2332', '533421', '香格里拉县', '365', 'x', 'xgllx', 'xianggelilaxian');
INSERT INTO `region_areas` VALUES ('2333', '533422', '德钦县', '365', 'd', 'dqx', 'deqinxian');
INSERT INTO `region_areas` VALUES ('2334', '533423', '维西傈僳族自治县', '365', 'w', 'wxlszzzx', 'weixilisuzuzizhixian');
INSERT INTO `region_areas` VALUES ('2335', '540102', '城关区', '366', 'c', 'cgq', 'chengguanqu');
INSERT INTO `region_areas` VALUES ('2336', '540121', '林周县', '366', 'l', 'lzx', 'linzhouxian');
INSERT INTO `region_areas` VALUES ('2337', '540122', '当雄县', '366', 'd', 'dxx', 'dangxiongxian');
INSERT INTO `region_areas` VALUES ('2338', '540123', '尼木县', '366', 'n', 'nmx', 'nimuxian');
INSERT INTO `region_areas` VALUES ('2339', '540124', '曲水县', '366', 'q', 'qsx', 'qushuixian');
INSERT INTO `region_areas` VALUES ('234', '140802', '盐湖区', '51', 'y', 'yhq', 'yanhuqu');
INSERT INTO `region_areas` VALUES ('2340', '540125', '堆龙德庆县', '366', 'd', 'dldqx', 'duilongdeqingxian');
INSERT INTO `region_areas` VALUES ('2341', '540126', '达孜县', '366', 'd', 'dzx', 'dazixian');
INSERT INTO `region_areas` VALUES ('2342', '540127', '墨竹工卡县', '366', 'm', 'mzgkx', 'mozhugongkaxian');
INSERT INTO `region_areas` VALUES ('2343', '540202', '桑珠孜区', '367', 's', 'szzq', 'sangzhuziqu');
INSERT INTO `region_areas` VALUES ('2344', '540221', '南木林县', '367', 'n', 'nmlx', 'nanmulinxian');
INSERT INTO `region_areas` VALUES ('2345', '540222', '江孜县', '367', 'j', 'jzx', 'jiangzixian');
INSERT INTO `region_areas` VALUES ('2346', '540223', '定日县', '367', 'd', 'drx', 'dingrixian');
INSERT INTO `region_areas` VALUES ('2347', '540224', '萨迦县', '367', 's', 'sjx', 'sajiaxian');
INSERT INTO `region_areas` VALUES ('2348', '540225', '拉孜县', '367', 'l', 'lzx', 'lazixian');
INSERT INTO `region_areas` VALUES ('2349', '540226', '昂仁县', '367', 'a', 'arx', 'angrenxian');
INSERT INTO `region_areas` VALUES ('235', '140821', '临猗县', '51', 'l', 'lyx', 'linyixian');
INSERT INTO `region_areas` VALUES ('2350', '540227', '谢通门县', '367', 'x', 'xtmx', 'xietongmenxian');
INSERT INTO `region_areas` VALUES ('2351', '540228', '白朗县', '367', 'b', 'blx', 'bailangxian');
INSERT INTO `region_areas` VALUES ('2352', '540229', '仁布县', '367', 'r', 'rbx', 'renbuxian');
INSERT INTO `region_areas` VALUES ('2353', '540230', '康马县', '367', 'k', 'kmx', 'kangmaxian');
INSERT INTO `region_areas` VALUES ('2354', '540231', '定结县', '367', 'd', 'djx', 'dingjiexian');
INSERT INTO `region_areas` VALUES ('2355', '540232', '仲巴县', '367', 'z', 'zbx', 'zhongbaxian');
INSERT INTO `region_areas` VALUES ('2356', '540233', '亚东县', '367', 'y', 'ydx', 'yadongxian');
INSERT INTO `region_areas` VALUES ('2357', '540234', '吉隆县', '367', 'j', 'jlx', 'jilongxian');
INSERT INTO `region_areas` VALUES ('2358', '540235', '聂拉木县', '367', 'n', 'nlmx', 'nielamuxian');
INSERT INTO `region_areas` VALUES ('2359', '540236', '萨嘎县', '367', 's', 'sgx', 'sagaxian');
INSERT INTO `region_areas` VALUES ('236', '140822', '万荣县', '51', 'w', 'wrx', 'wanrongxian');
INSERT INTO `region_areas` VALUES ('2360', '540237', '岗巴县', '367', 'g', 'gbx', 'gangbaxian');
INSERT INTO `region_areas` VALUES ('2361', '542121', '昌都县', '368', 'c', 'cdx', 'changdouxian');
INSERT INTO `region_areas` VALUES ('2362', '542122', '江达县', '368', 'j', 'jdx', 'jiangdaxian');
INSERT INTO `region_areas` VALUES ('2363', '542123', '贡觉县', '368', 'g', 'gjx', 'gongjuexian');
INSERT INTO `region_areas` VALUES ('2364', '542124', '类乌齐县', '368', 'l', 'lwqx', 'leiwuqixian');
INSERT INTO `region_areas` VALUES ('2365', '542125', '丁青县', '368', 'd', 'dqx', 'dingqingxian');
INSERT INTO `region_areas` VALUES ('2366', '542126', '察雅县', '368', 'c', 'cyx', 'chayaxian');
INSERT INTO `region_areas` VALUES ('2367', '542127', '八宿县', '368', 'b', 'bsx', 'basuxian');
INSERT INTO `region_areas` VALUES ('2368', '542128', '左贡县', '368', 'z', 'zgx', 'zuogongxian');
INSERT INTO `region_areas` VALUES ('2369', '542129', '芒康县', '368', 'm', 'mkx', 'mangkangxian');
INSERT INTO `region_areas` VALUES ('237', '140823', '闻喜县', '51', 'w', 'wxx', 'wenxixian');
INSERT INTO `region_areas` VALUES ('2370', '542132', '洛隆县', '368', 'l', 'llx', 'luolongxian');
INSERT INTO `region_areas` VALUES ('2371', '542133', '边坝县', '368', 'b', 'bbx', 'bianbaxian');
INSERT INTO `region_areas` VALUES ('2372', '542221', '乃东县', '369', 'n', 'ndx', 'naidongxian');
INSERT INTO `region_areas` VALUES ('2373', '542222', '扎囊县', '369', 'z', 'znx', 'zhanangxian');
INSERT INTO `region_areas` VALUES ('2374', '542223', '贡嘎县', '369', 'g', 'ggx', 'gonggaxian');
INSERT INTO `region_areas` VALUES ('2375', '542224', '桑日县', '369', 's', 'srx', 'sangrixian');
INSERT INTO `region_areas` VALUES ('2376', '542225', '琼结县', '369', 'q', 'qjx', 'qiongjiexian');
INSERT INTO `region_areas` VALUES ('2377', '542226', '曲松县', '369', 'q', 'qsx', 'qusongxian');
INSERT INTO `region_areas` VALUES ('2378', '542227', '措美县', '369', 'c', 'cmx', 'cuomeixian');
INSERT INTO `region_areas` VALUES ('2379', '542228', '洛扎县', '369', 'l', 'lzx', 'luozhaxian');
INSERT INTO `region_areas` VALUES ('238', '140824', '稷山县', '51', 'j', 'jsx', 'jishanxian');
INSERT INTO `region_areas` VALUES ('2380', '542229', '加查县', '369', 'j', 'jcx', 'jiachaxian');
INSERT INTO `region_areas` VALUES ('2381', '542231', '隆子县', '369', 'l', 'lzx', 'longzixian');
INSERT INTO `region_areas` VALUES ('2382', '542232', '错那县', '369', 'c', 'cnx', 'cuoneixian');
INSERT INTO `region_areas` VALUES ('2383', '542233', '浪卡子县', '369', 'l', 'lkzx', 'langkazixian');
INSERT INTO `region_areas` VALUES ('2384', '542421', '那曲县', '370', 'n', 'nqx', 'neiquxian');
INSERT INTO `region_areas` VALUES ('2385', '542422', '嘉黎县', '370', 'j', 'jlx', 'jialixian');
INSERT INTO `region_areas` VALUES ('2386', '542423', '比如县', '370', 'b', 'brx', 'biruxian');
INSERT INTO `region_areas` VALUES ('2387', '542424', '聂荣县', '370', 'n', 'nrx', 'nierongxian');
INSERT INTO `region_areas` VALUES ('2388', '542425', '安多县', '370', 'a', 'adx', 'anduoxian');
INSERT INTO `region_areas` VALUES ('2389', '542426', '申扎县', '370', 's', 'szx', 'shenzhaxian');
INSERT INTO `region_areas` VALUES ('239', '140825', '新绛县', '51', 'x', 'xjx', 'xinjiangxian');
INSERT INTO `region_areas` VALUES ('2390', '542427', '索县', '370', 's', 'sx', 'suoxian');
INSERT INTO `region_areas` VALUES ('2391', '542428', '班戈县', '370', 'b', 'bgx', 'bangexian');
INSERT INTO `region_areas` VALUES ('2392', '542429', '巴青县', '370', 'b', 'bqx', 'baqingxian');
INSERT INTO `region_areas` VALUES ('2393', '542430', '尼玛县', '370', 'n', 'nmx', 'nimaxian');
INSERT INTO `region_areas` VALUES ('2394', '542431', '双湖县', '370', 's', 'shx', 'shuanghuxian');
INSERT INTO `region_areas` VALUES ('2395', '542521', '普兰县', '371', 'p', 'plx', 'pulanxian');
INSERT INTO `region_areas` VALUES ('2396', '542522', '札达县', '371', 'z', 'zdx', 'zhadaxian');
INSERT INTO `region_areas` VALUES ('2397', '542523', '噶尔县', '371', 'g', 'gex', 'gaerxian');
INSERT INTO `region_areas` VALUES ('2398', '542524', '日土县', '371', 'r', 'rtx', 'rituxian');
INSERT INTO `region_areas` VALUES ('2399', '542525', '革吉县', '371', 'g', 'gjx', 'gejixian');
INSERT INTO `region_areas` VALUES ('24', '130203', '路北区', '34', 'l', 'lbq', 'lubeiqu');
INSERT INTO `region_areas` VALUES ('240', '140826', '绛县', '51', 'j', 'jx', 'jiangxian');
INSERT INTO `region_areas` VALUES ('2400', '542526', '改则县', '371', 'g', 'gzx', 'gaizexian');
INSERT INTO `region_areas` VALUES ('2401', '542527', '措勤县', '371', 'c', 'cqx', 'cuoqinxian');
INSERT INTO `region_areas` VALUES ('2402', '542621', '林芝县', '372', 'l', 'lzx', 'linzhixian');
INSERT INTO `region_areas` VALUES ('2403', '542622', '工布江达县', '372', 'g', 'gbjdx', 'gongbujiangdaxian');
INSERT INTO `region_areas` VALUES ('2404', '542623', '米林县', '372', 'm', 'mlx', 'milinxian');
INSERT INTO `region_areas` VALUES ('2405', '542624', '墨脱县', '372', 'm', 'mtx', 'motuoxian');
INSERT INTO `region_areas` VALUES ('2406', '542625', '波密县', '372', 'b', 'bmx', 'bomixian');
INSERT INTO `region_areas` VALUES ('2407', '542626', '察隅县', '372', 'c', 'cyx', 'chayuxian');
INSERT INTO `region_areas` VALUES ('2408', '542627', '朗县', '372', 'l', 'lx', 'langxian');
INSERT INTO `region_areas` VALUES ('2409', '610102', '新城区', '373', 'x', 'xcq', 'xinchengqu');
INSERT INTO `region_areas` VALUES ('241', '140827', '垣曲县', '51', 'y', 'yqx', 'yuanquxian');
INSERT INTO `region_areas` VALUES ('2410', '610103', '碑林区', '373', 'b', 'blq', 'beilinqu');
INSERT INTO `region_areas` VALUES ('2411', '610104', '莲湖区', '373', 'l', 'lhq', 'lianhuqu');
INSERT INTO `region_areas` VALUES ('2412', '610111', '灞桥区', '373', 'b', 'bqq', 'baqiaoqu');
INSERT INTO `region_areas` VALUES ('2413', '610112', '未央区', '373', 'w', 'wyq', 'weiyangqu');
INSERT INTO `region_areas` VALUES ('2414', '610113', '雁塔区', '373', 'y', 'ytq', 'yantaqu');
INSERT INTO `region_areas` VALUES ('2415', '610114', '阎良区', '373', 'y', 'ylq', 'yanliangqu');
INSERT INTO `region_areas` VALUES ('2416', '610115', '临潼区', '373', 'l', 'ltq', 'lintongqu');
INSERT INTO `region_areas` VALUES ('2417', '610116', '长安区', '373', 'z', 'zaq', 'zhanganqu');
INSERT INTO `region_areas` VALUES ('2418', '610122', '蓝田县', '373', 'l', 'ltx', 'lantianxian');
INSERT INTO `region_areas` VALUES ('2419', '610124', '周至县', '373', 'z', 'zzx', 'zhouzhixian');
INSERT INTO `region_areas` VALUES ('242', '140828', '夏县', '51', 'x', 'xx', 'xiaxian');
INSERT INTO `region_areas` VALUES ('2420', '610125', '户县', '373', 'h', 'hx', 'huxian');
INSERT INTO `region_areas` VALUES ('2421', '610126', '高陵县', '373', 'g', 'glx', 'gaolingxian');
INSERT INTO `region_areas` VALUES ('2422', '610202', '王益区', '374', 'w', 'wyq', 'wangyiqu');
INSERT INTO `region_areas` VALUES ('2423', '610203', '印台区', '374', 'y', 'ytq', 'yintaiqu');
INSERT INTO `region_areas` VALUES ('2424', '610204', '耀州区', '374', 'y', 'yzq', 'yaozhouqu');
INSERT INTO `region_areas` VALUES ('2425', '610222', '宜君县', '374', 'y', 'yjx', 'yijunxian');
INSERT INTO `region_areas` VALUES ('2426', '610302', '渭滨区', '375', 'w', 'wbq', 'weibinqu');
INSERT INTO `region_areas` VALUES ('2427', '610303', '金台区', '375', 'j', 'jtq', 'jintaiqu');
INSERT INTO `region_areas` VALUES ('2428', '610304', '陈仓区', '375', 'c', 'ccq', 'chencangqu');
INSERT INTO `region_areas` VALUES ('2429', '610322', '凤翔县', '375', 'f', 'fxx', 'fengxiangxian');
INSERT INTO `region_areas` VALUES ('243', '140829', '平陆县', '51', 'p', 'plx', 'pingluxian');
INSERT INTO `region_areas` VALUES ('2430', '610323', '岐山县', '375', 'q', 'qsx', 'qishanxian');
INSERT INTO `region_areas` VALUES ('2431', '610324', '扶风县', '375', 'f', 'ffx', 'fufengxian');
INSERT INTO `region_areas` VALUES ('2432', '610326', '眉县', '375', 'm', 'mx', 'meixian');
INSERT INTO `region_areas` VALUES ('2433', '610327', '陇县', '375', 'l', 'lx', 'longxian');
INSERT INTO `region_areas` VALUES ('2434', '610328', '千阳县', '375', 'q', 'qyx', 'qianyangxian');
INSERT INTO `region_areas` VALUES ('2435', '610329', '麟游县', '375', 'l', 'lyx', 'linyouxian');
INSERT INTO `region_areas` VALUES ('2436', '610330', '凤县', '375', 'f', 'fx', 'fengxian');
INSERT INTO `region_areas` VALUES ('2437', '610331', '太白县', '375', 't', 'tbx', 'taibaixian');
INSERT INTO `region_areas` VALUES ('2438', '610402', '秦都区', '376', 'q', 'qdq', 'qindouqu');
INSERT INTO `region_areas` VALUES ('2439', '610403', '杨陵区', '376', 'y', 'ylq', 'yanglingqu');
INSERT INTO `region_areas` VALUES ('244', '140830', '芮城县', '51', 'r', 'rcx', 'ruichengxian');
INSERT INTO `region_areas` VALUES ('2440', '610404', '渭城区', '376', 'w', 'wcq', 'weichengqu');
INSERT INTO `region_areas` VALUES ('2441', '610422', '三原县', '376', 's', 'syx', 'sanyuanxian');
INSERT INTO `region_areas` VALUES ('2442', '610423', '泾阳县', '376', 'j', 'jyx', 'jingyangxian');
INSERT INTO `region_areas` VALUES ('2443', '610424', '乾县', '376', 'q', 'qx', 'qianxian');
INSERT INTO `region_areas` VALUES ('2444', '610425', '礼泉县', '376', 'l', 'lqx', 'liquanxian');
INSERT INTO `region_areas` VALUES ('2445', '610426', '永寿县', '376', 'y', 'ysx', 'yongshouxian');
INSERT INTO `region_areas` VALUES ('2446', '610427', '彬县', '376', 'b', 'bx', 'binxian');
INSERT INTO `region_areas` VALUES ('2447', '610428', '长武县', '376', 'z', 'zwx', 'zhangwuxian');
INSERT INTO `region_areas` VALUES ('2448', '610429', '旬邑县', '376', 'x', 'xyx', 'xunyixian');
INSERT INTO `region_areas` VALUES ('2449', '610430', '淳化县', '376', 'c', 'chx', 'chunhuaxian');
INSERT INTO `region_areas` VALUES ('245', '140881', '永济市', '51', 'y', 'yjs', 'yongjishi');
INSERT INTO `region_areas` VALUES ('2450', '610431', '武功县', '376', 'w', 'wgx', 'wugongxian');
INSERT INTO `region_areas` VALUES ('2451', '610481', '兴平市', '376', 'x', 'xps', 'xingpingshi');
INSERT INTO `region_areas` VALUES ('2452', '610502', '临渭区', '377', 'l', 'lwq', 'linweiqu');
INSERT INTO `region_areas` VALUES ('2453', '610521', '华县', '377', 'h', 'hx', 'huaxian');
INSERT INTO `region_areas` VALUES ('2454', '610522', '潼关县', '377', 't', 'tgx', 'tongguanxian');
INSERT INTO `region_areas` VALUES ('2455', '610523', '大荔县', '377', 'd', 'dlx', 'dalixian');
INSERT INTO `region_areas` VALUES ('2456', '610524', '合阳县', '377', 'h', 'hyx', 'heyangxian');
INSERT INTO `region_areas` VALUES ('2457', '610525', '澄城县', '377', 'c', 'ccx', 'chengchengxian');
INSERT INTO `region_areas` VALUES ('2458', '610526', '蒲城县', '377', 'p', 'pcx', 'puchengxian');
INSERT INTO `region_areas` VALUES ('2459', '610527', '白水县', '377', 'b', 'bsx', 'baishuixian');
INSERT INTO `region_areas` VALUES ('246', '140882', '河津市', '51', 'h', 'hjs', 'hejinshi');
INSERT INTO `region_areas` VALUES ('2460', '610528', '富平县', '377', 'f', 'fpx', 'fupingxian');
INSERT INTO `region_areas` VALUES ('2461', '610581', '韩城市', '377', 'h', 'hcs', 'hanchengshi');
INSERT INTO `region_areas` VALUES ('2462', '610582', '华阴市', '377', 'h', 'hys', 'huayinshi');
INSERT INTO `region_areas` VALUES ('2463', '610602', '宝塔区', '378', 'b', 'btq', 'baotaqu');
INSERT INTO `region_areas` VALUES ('2464', '610621', '延长县', '378', 'y', 'yzx', 'yanzhangxian');
INSERT INTO `region_areas` VALUES ('2465', '610622', '延川县', '378', 'y', 'ycx', 'yanchuanxian');
INSERT INTO `region_areas` VALUES ('2466', '610623', '子长县', '378', 'z', 'zzx', 'zizhangxian');
INSERT INTO `region_areas` VALUES ('2467', '610624', '安塞县', '378', 'a', 'asx', 'ansaixian');
INSERT INTO `region_areas` VALUES ('2468', '610625', '志丹县', '378', 'z', 'zdx', 'zhidanxian');
INSERT INTO `region_areas` VALUES ('2469', '610626', '吴起县', '378', 'w', 'wqx', 'wuqixian');
INSERT INTO `region_areas` VALUES ('247', '140902', '忻府区', '52', 'x', 'xfq', 'xinfuqu');
INSERT INTO `region_areas` VALUES ('2470', '610627', '甘泉县', '378', 'g', 'gqx', 'ganquanxian');
INSERT INTO `region_areas` VALUES ('2471', '610628', '富县', '378', 'f', 'fx', 'fuxian');
INSERT INTO `region_areas` VALUES ('2472', '610629', '洛川县', '378', 'l', 'lcx', 'luochuanxian');
INSERT INTO `region_areas` VALUES ('2473', '610630', '宜川县', '378', 'y', 'ycx', 'yichuanxian');
INSERT INTO `region_areas` VALUES ('2474', '610631', '黄龙县', '378', 'h', 'hlx', 'huanglongxian');
INSERT INTO `region_areas` VALUES ('2475', '610632', '黄陵县', '378', 'h', 'hlx', 'huanglingxian');
INSERT INTO `region_areas` VALUES ('2476', '610702', '汉台区', '379', 'h', 'htq', 'hantaiqu');
INSERT INTO `region_areas` VALUES ('2477', '610721', '南郑县', '379', 'n', 'nzx', 'nanzhengxian');
INSERT INTO `region_areas` VALUES ('2478', '610722', '城固县', '379', 'c', 'cgx', 'chengguxian');
INSERT INTO `region_areas` VALUES ('2479', '610723', '洋县', '379', 'y', 'yx', 'yangxian');
INSERT INTO `region_areas` VALUES ('248', '140921', '定襄县', '52', 'd', 'dxx', 'dingxiangxian');
INSERT INTO `region_areas` VALUES ('2480', '610724', '西乡县', '379', 'x', 'xxx', 'xixiangxian');
INSERT INTO `region_areas` VALUES ('2481', '610725', '勉县', '379', 'm', 'mx', 'mianxian');
INSERT INTO `region_areas` VALUES ('2482', '610726', '宁强县', '379', 'n', 'nqx', 'ningqiangxian');
INSERT INTO `region_areas` VALUES ('2483', '610727', '略阳县', '379', 'l', 'lyx', 'lu:eyangxian');
INSERT INTO `region_areas` VALUES ('2484', '610728', '镇巴县', '379', 'z', 'zbx', 'zhenbaxian');
INSERT INTO `region_areas` VALUES ('2485', '610729', '留坝县', '379', 'l', 'lbx', 'liubaxian');
INSERT INTO `region_areas` VALUES ('2486', '610730', '佛坪县', '379', 'f', 'fpx', 'fopingxian');
INSERT INTO `region_areas` VALUES ('2487', '610802', '榆阳区', '380', 'y', 'yyq', 'yuyangqu');
INSERT INTO `region_areas` VALUES ('2488', '610821', '神木县', '380', 's', 'smx', 'shenmuxian');
INSERT INTO `region_areas` VALUES ('2489', '610822', '府谷县', '380', 'f', 'fgx', 'fuguxian');
INSERT INTO `region_areas` VALUES ('249', '140922', '五台县', '52', 'w', 'wtx', 'wutaixian');
INSERT INTO `region_areas` VALUES ('2490', '610823', '横山县', '380', 'h', 'hsx', 'hengshanxian');
INSERT INTO `region_areas` VALUES ('2491', '610824', '靖边县', '380', 'j', 'jbx', 'jingbianxian');
INSERT INTO `region_areas` VALUES ('2492', '610825', '定边县', '380', 'd', 'dbx', 'dingbianxian');
INSERT INTO `region_areas` VALUES ('2493', '610826', '绥德县', '380', 's', 'sdx', 'suidexian');
INSERT INTO `region_areas` VALUES ('2494', '610827', '米脂县', '380', 'm', 'mzx', 'mizhixian');
INSERT INTO `region_areas` VALUES ('2495', '610828', '佳县', '380', 'j', 'jx', 'jiaxian');
INSERT INTO `region_areas` VALUES ('2496', '610829', '吴堡县', '380', 'w', 'wbx', 'wubaoxian');
INSERT INTO `region_areas` VALUES ('2497', '610830', '清涧县', '380', 'q', 'qjx', 'qingjianxian');
INSERT INTO `region_areas` VALUES ('2498', '610831', '子洲县', '380', 'z', 'zzx', 'zizhouxian');
INSERT INTO `region_areas` VALUES ('2499', '610902', '汉滨区', '381', 'h', 'hbq', 'hanbinqu');
INSERT INTO `region_areas` VALUES ('25', '130204', '古冶区', '34', 'g', 'gyq', 'guyequ');
INSERT INTO `region_areas` VALUES ('250', '140923', '代县', '52', 'd', 'dx', 'daixian');
INSERT INTO `region_areas` VALUES ('2500', '610921', '汉阴县', '381', 'h', 'hyx', 'hanyinxian');
INSERT INTO `region_areas` VALUES ('2501', '610922', '石泉县', '381', 's', 'sqx', 'shiquanxian');
INSERT INTO `region_areas` VALUES ('2502', '610923', '宁陕县', '381', 'n', 'nsx', 'ningshanxian');
INSERT INTO `region_areas` VALUES ('2503', '610924', '紫阳县', '381', 'z', 'zyx', 'ziyangxian');
INSERT INTO `region_areas` VALUES ('2504', '610925', '岚皋县', '381', 'l', 'lgx', 'langaoxian');
INSERT INTO `region_areas` VALUES ('2505', '610926', '平利县', '381', 'p', 'plx', 'pinglixian');
INSERT INTO `region_areas` VALUES ('2506', '610927', '镇坪县', '381', 'z', 'zpx', 'zhenpingxian');
INSERT INTO `region_areas` VALUES ('2507', '610928', '旬阳县', '381', 'x', 'xyx', 'xunyangxian');
INSERT INTO `region_areas` VALUES ('2508', '610929', '白河县', '381', 'b', 'bhx', 'baihexian');
INSERT INTO `region_areas` VALUES ('2509', '611002', '商州区', '382', 's', 'szq', 'shangzhouqu');
INSERT INTO `region_areas` VALUES ('251', '140924', '繁峙县', '52', 'f', 'fzx', 'fanzhixian');
INSERT INTO `region_areas` VALUES ('2510', '611021', '洛南县', '382', 'l', 'lnx', 'luonanxian');
INSERT INTO `region_areas` VALUES ('2511', '611022', '丹凤县', '382', 'd', 'dfx', 'danfengxian');
INSERT INTO `region_areas` VALUES ('2512', '611023', '商南县', '382', 's', 'snx', 'shangnanxian');
INSERT INTO `region_areas` VALUES ('2513', '611024', '山阳县', '382', 's', 'syx', 'shanyangxian');
INSERT INTO `region_areas` VALUES ('2514', '611025', '镇安县', '382', 'z', 'zax', 'zhenanxian');
INSERT INTO `region_areas` VALUES ('2515', '611026', '柞水县', '382', 'z', 'zsx', 'zuoshuixian');
INSERT INTO `region_areas` VALUES ('2516', '620102', '城关区', '383', 'c', 'cgq', 'chengguanqu');
INSERT INTO `region_areas` VALUES ('2517', '620103', '七里河区', '383', 'q', 'qlhq', 'qilihequ');
INSERT INTO `region_areas` VALUES ('2518', '620104', '西固区', '383', 'x', 'xgq', 'xiguqu');
INSERT INTO `region_areas` VALUES ('2519', '620105', '安宁区', '383', 'a', 'anq', 'anningqu');
INSERT INTO `region_areas` VALUES ('252', '140925', '宁武县', '52', 'n', 'nwx', 'ningwuxian');
INSERT INTO `region_areas` VALUES ('2520', '620111', '红古区', '383', 'h', 'hgq', 'hongguqu');
INSERT INTO `region_areas` VALUES ('2521', '620121', '永登县', '383', 'y', 'ydx', 'yongdengxian');
INSERT INTO `region_areas` VALUES ('2522', '620122', '皋兰县', '383', 'g', 'glx', 'gaolanxian');
INSERT INTO `region_areas` VALUES ('2523', '620123', '榆中县', '383', 'y', 'yzx', 'yuzhongxian');
INSERT INTO `region_areas` VALUES ('2524', '620302', '金川区', '385', 'j', 'jcq', 'jinchuanqu');
INSERT INTO `region_areas` VALUES ('2525', '620321', '永昌县', '385', 'y', 'ycx', 'yongchangxian');
INSERT INTO `region_areas` VALUES ('2526', '620402', '白银区', '386', 'b', 'byq', 'baiyinqu');
INSERT INTO `region_areas` VALUES ('2527', '620403', '平川区', '386', 'p', 'pcq', 'pingchuanqu');
INSERT INTO `region_areas` VALUES ('2528', '620421', '靖远县', '386', 'j', 'jyx', 'jingyuanxian');
INSERT INTO `region_areas` VALUES ('2529', '620422', '会宁县', '386', 'h', 'hnx', 'huiningxian');
INSERT INTO `region_areas` VALUES ('253', '140926', '静乐县', '52', 'j', 'jlx', 'jinglexian');
INSERT INTO `region_areas` VALUES ('2530', '620423', '景泰县', '386', 'j', 'jtx', 'jingtaixian');
INSERT INTO `region_areas` VALUES ('2531', '620502', '秦州区', '387', 'q', 'qzq', 'qinzhouqu');
INSERT INTO `region_areas` VALUES ('2532', '620503', '麦积区', '387', 'm', 'mjq', 'maijiqu');
INSERT INTO `region_areas` VALUES ('2533', '620521', '清水县', '387', 'q', 'qsx', 'qingshuixian');
INSERT INTO `region_areas` VALUES ('2534', '620522', '秦安县', '387', 'q', 'qax', 'qinanxian');
INSERT INTO `region_areas` VALUES ('2535', '620523', '甘谷县', '387', 'g', 'ggx', 'ganguxian');
INSERT INTO `region_areas` VALUES ('2536', '620524', '武山县', '387', 'w', 'wsx', 'wushanxian');
INSERT INTO `region_areas` VALUES ('2537', '620525', '张家川回族自治县', '387', 'z', 'zjchzzzx', 'zhangjiachuanhuizuzizhixian');
INSERT INTO `region_areas` VALUES ('2538', '620602', '凉州区', '388', 'l', 'lzq', 'liangzhouqu');
INSERT INTO `region_areas` VALUES ('2539', '620621', '民勤县', '388', 'm', 'mqx', 'minqinxian');
INSERT INTO `region_areas` VALUES ('254', '140927', '神池县', '52', 's', 'scx', 'shenchixian');
INSERT INTO `region_areas` VALUES ('2540', '620622', '古浪县', '388', 'g', 'glx', 'gulangxian');
INSERT INTO `region_areas` VALUES ('2541', '620623', '天祝藏族自治县', '388', 't', 'tzzzzzx', 'tianzhuzangzuzizhixian');
INSERT INTO `region_areas` VALUES ('2542', '620702', '甘州区', '389', 'g', 'gzq', 'ganzhouqu');
INSERT INTO `region_areas` VALUES ('2543', '620721', '肃南裕固族自治县', '389', 's', 'snygzzzx', 'sunanyuguzuzizhixian');
INSERT INTO `region_areas` VALUES ('2544', '620722', '民乐县', '389', 'm', 'mlx', 'minlexian');
INSERT INTO `region_areas` VALUES ('2545', '620723', '临泽县', '389', 'l', 'lzx', 'linzexian');
INSERT INTO `region_areas` VALUES ('2546', '620724', '高台县', '389', 'g', 'gtx', 'gaotaixian');
INSERT INTO `region_areas` VALUES ('2547', '620725', '山丹县', '389', 's', 'sdx', 'shandanxian');
INSERT INTO `region_areas` VALUES ('2548', '620802', '崆峒区', '390', 'k', 'ktq', 'kongtongqu');
INSERT INTO `region_areas` VALUES ('2549', '620821', '泾川县', '390', 'j', 'jcx', 'jingchuanxian');
INSERT INTO `region_areas` VALUES ('255', '140928', '五寨县', '52', 'w', 'wzx', 'wuzhaixian');
INSERT INTO `region_areas` VALUES ('2550', '620822', '灵台县', '390', 'l', 'ltx', 'lingtaixian');
INSERT INTO `region_areas` VALUES ('2551', '620823', '崇信县', '390', 'c', 'cxx', 'chongxinxian');
INSERT INTO `region_areas` VALUES ('2552', '620824', '华亭县', '390', 'h', 'htx', 'huatingxian');
INSERT INTO `region_areas` VALUES ('2553', '620825', '庄浪县', '390', 'z', 'zlx', 'zhuanglangxian');
INSERT INTO `region_areas` VALUES ('2554', '620826', '静宁县', '390', 'j', 'jnx', 'jingningxian');
INSERT INTO `region_areas` VALUES ('2555', '620902', '肃州区', '391', 's', 'szq', 'suzhouqu');
INSERT INTO `region_areas` VALUES ('2556', '620921', '金塔县', '391', 'j', 'jtx', 'jintaxian');
INSERT INTO `region_areas` VALUES ('2557', '620922', '瓜州县', '391', 'g', 'gzx', 'guazhouxian');
INSERT INTO `region_areas` VALUES ('2558', '620923', '肃北蒙古族自治县', '391', 's', 'sbmgzzzx', 'subeimengguzuzizhixian');
INSERT INTO `region_areas` VALUES ('2559', '620924', '阿克塞哈萨克族自治县', '391', 'a', 'akshskzzzx', 'akesaihasakezuzizhixian');
INSERT INTO `region_areas` VALUES ('256', '140929', '岢岚县', '52', 'k', 'klx', 'kelanxian');
INSERT INTO `region_areas` VALUES ('2560', '620981', '玉门市', '391', 'y', 'yms', 'yumenshi');
INSERT INTO `region_areas` VALUES ('2561', '620982', '敦煌市', '391', 'd', 'dhs', 'dunhuangshi');
INSERT INTO `region_areas` VALUES ('2562', '621002', '西峰区', '392', 'x', 'xfq', 'xifengqu');
INSERT INTO `region_areas` VALUES ('2563', '621021', '庆城县', '392', 'q', 'qcx', 'qingchengxian');
INSERT INTO `region_areas` VALUES ('2564', '621022', '环县', '392', 'h', 'hx', 'huanxian');
INSERT INTO `region_areas` VALUES ('2565', '621023', '华池县', '392', 'h', 'hcx', 'huachixian');
INSERT INTO `region_areas` VALUES ('2566', '621024', '合水县', '392', 'h', 'hsx', 'heshuixian');
INSERT INTO `region_areas` VALUES ('2567', '621025', '正宁县', '392', 'z', 'znx', 'zhengningxian');
INSERT INTO `region_areas` VALUES ('2568', '621026', '宁县', '392', 'n', 'nx', 'ningxian');
INSERT INTO `region_areas` VALUES ('2569', '621027', '镇原县', '392', 'z', 'zyx', 'zhenyuanxian');
INSERT INTO `region_areas` VALUES ('257', '140930', '河曲县', '52', 'h', 'hqx', 'hequxian');
INSERT INTO `region_areas` VALUES ('2570', '621102', '安定区', '393', 'a', 'adq', 'andingqu');
INSERT INTO `region_areas` VALUES ('2571', '621121', '通渭县', '393', 't', 'twx', 'tongweixian');
INSERT INTO `region_areas` VALUES ('2572', '621122', '陇西县', '393', 'l', 'lxx', 'longxixian');
INSERT INTO `region_areas` VALUES ('2573', '621123', '渭源县', '393', 'w', 'wyx', 'weiyuanxian');
INSERT INTO `region_areas` VALUES ('2574', '621124', '临洮县', '393', 'l', 'ltx', 'lintaoxian');
INSERT INTO `region_areas` VALUES ('2575', '621125', '漳县', '393', 'z', 'zx', 'zhangxian');
INSERT INTO `region_areas` VALUES ('2576', '621126', '岷县', '393', 'm', 'mx', 'minxian');
INSERT INTO `region_areas` VALUES ('2577', '621202', '武都区', '394', 'w', 'wdq', 'wudouqu');
INSERT INTO `region_areas` VALUES ('2578', '621221', '成县', '394', 'c', 'cx', 'chengxian');
INSERT INTO `region_areas` VALUES ('2579', '621222', '文县', '394', 'w', 'wx', 'wenxian');
INSERT INTO `region_areas` VALUES ('258', '140931', '保德县', '52', 'b', 'bdx', 'baodexian');
INSERT INTO `region_areas` VALUES ('2580', '621223', '宕昌县', '394', 'd', 'dcx', 'dangchangxian');
INSERT INTO `region_areas` VALUES ('2581', '621224', '康县', '394', 'k', 'kx', 'kangxian');
INSERT INTO `region_areas` VALUES ('2582', '621225', '西和县', '394', 'x', 'xhx', 'xihexian');
INSERT INTO `region_areas` VALUES ('2583', '621226', '礼县', '394', 'l', 'lx', 'lixian');
INSERT INTO `region_areas` VALUES ('2584', '621227', '徽县', '394', 'h', 'hx', 'huixian');
INSERT INTO `region_areas` VALUES ('2585', '621228', '两当县', '394', 'l', 'ldx', 'liangdangxian');
INSERT INTO `region_areas` VALUES ('2586', '622901', '临夏市', '395', 'l', 'lxs', 'linxiashi');
INSERT INTO `region_areas` VALUES ('2587', '622921', '临夏县', '395', 'l', 'lxx', 'linxiaxian');
INSERT INTO `region_areas` VALUES ('2588', '622922', '康乐县', '395', 'k', 'klx', 'kanglexian');
INSERT INTO `region_areas` VALUES ('2589', '622923', '永靖县', '395', 'y', 'yjx', 'yongjingxian');
INSERT INTO `region_areas` VALUES ('259', '140932', '偏关县', '52', 'p', 'pgx', 'pianguanxian');
INSERT INTO `region_areas` VALUES ('2590', '622924', '广河县', '395', 'g', 'ghx', 'guanghexian');
INSERT INTO `region_areas` VALUES ('2591', '622925', '和政县', '395', 'h', 'hzx', 'hezhengxian');
INSERT INTO `region_areas` VALUES ('2592', '622926', '东乡族自治县', '395', 'd', 'dxzzzx', 'dongxiangzuzizhixian');
INSERT INTO `region_areas` VALUES ('2593', '622927', '积石山保安族东乡族撒拉族自治县', '395', 'j', 'jssbazdxzslzzzx', 'jishishanbaoanzudongxiangzusalazuzizhixian');
INSERT INTO `region_areas` VALUES ('2594', '623001', '合作市', '396', 'h', 'hzs', 'hezuoshi');
INSERT INTO `region_areas` VALUES ('2595', '623021', '临潭县', '396', 'l', 'ltx', 'lintanxian');
INSERT INTO `region_areas` VALUES ('2596', '623022', '卓尼县', '396', 'z', 'znx', 'zhuonixian');
INSERT INTO `region_areas` VALUES ('2597', '623023', '舟曲县', '396', 'z', 'zqx', 'zhouquxian');
INSERT INTO `region_areas` VALUES ('2598', '623024', '迭部县', '396', 'd', 'dbx', 'diebuxian');
INSERT INTO `region_areas` VALUES ('2599', '623025', '玛曲县', '396', 'm', 'mqx', 'maquxian');
INSERT INTO `region_areas` VALUES ('26', '130205', '开平区', '34', 'k', 'kpq', 'kaipingqu');
INSERT INTO `region_areas` VALUES ('260', '140981', '原平市', '52', 'y', 'yps', 'yuanpingshi');
INSERT INTO `region_areas` VALUES ('2600', '623026', '碌曲县', '396', 'l', 'lqx', 'liuquxian');
INSERT INTO `region_areas` VALUES ('2601', '623027', '夏河县', '396', 'x', 'xhx', 'xiahexian');
INSERT INTO `region_areas` VALUES ('2602', '630102', '城东区', '397', 'c', 'cdq', 'chengdongqu');
INSERT INTO `region_areas` VALUES ('2603', '630103', '城中区', '397', 'c', 'czq', 'chengzhongqu');
INSERT INTO `region_areas` VALUES ('2604', '630104', '城西区', '397', 'c', 'cxq', 'chengxiqu');
INSERT INTO `region_areas` VALUES ('2605', '630105', '城北区', '397', 'c', 'cbq', 'chengbeiqu');
INSERT INTO `region_areas` VALUES ('2606', '630121', '大通回族土族自治县', '397', 'd', 'dthztzzzx', 'datonghuizutuzuzizhixian');
INSERT INTO `region_areas` VALUES ('2607', '630122', '湟中县', '397', 'h', 'hzx', 'huangzhongxian');
INSERT INTO `region_areas` VALUES ('2608', '630123', '湟源县', '397', 'h', 'hyx', 'huangyuanxian');
INSERT INTO `region_areas` VALUES ('2609', '630202', '乐都区', '398', 'l', 'ldq', 'ledouqu');
INSERT INTO `region_areas` VALUES ('261', '141002', '尧都区', '53', 'y', 'ydq', 'yaodouqu');
INSERT INTO `region_areas` VALUES ('2610', '630221', '平安县', '398', 'p', 'pax', 'pinganxian');
INSERT INTO `region_areas` VALUES ('2611', '630222', '民和回族土族自治县', '398', 'm', 'mhhztzzzx', 'minhehuizutuzuzizhixian');
INSERT INTO `region_areas` VALUES ('2612', '630223', '互助土族自治县', '398', 'h', 'hztzzzx', 'huzhutuzuzizhixian');
INSERT INTO `region_areas` VALUES ('2613', '630224', '化隆回族自治县', '398', 'h', 'hlhzzzx', 'hualonghuizuzizhixian');
INSERT INTO `region_areas` VALUES ('2614', '630225', '循化撒拉族自治县', '398', 'x', 'xhslzzzx', 'xunhuasalazuzizhixian');
INSERT INTO `region_areas` VALUES ('2615', '632221', '门源回族自治县', '399', 'm', 'myhzzzx', 'menyuanhuizuzizhixian');
INSERT INTO `region_areas` VALUES ('2616', '632222', '祁连县', '399', 'q', 'qlx', 'qilianxian');
INSERT INTO `region_areas` VALUES ('2617', '632223', '海晏县', '399', 'h', 'hyx', 'haiyanxian');
INSERT INTO `region_areas` VALUES ('2618', '632224', '刚察县', '399', 'g', 'gcx', 'gangchaxian');
INSERT INTO `region_areas` VALUES ('2619', '632321', '同仁县', '400', 't', 'trx', 'tongrenxian');
INSERT INTO `region_areas` VALUES ('262', '141021', '曲沃县', '53', 'q', 'qwx', 'quwoxian');
INSERT INTO `region_areas` VALUES ('2620', '632322', '尖扎县', '400', 'j', 'jzx', 'jianzhaxian');
INSERT INTO `region_areas` VALUES ('2621', '632323', '泽库县', '400', 'z', 'zkx', 'zekuxian');
INSERT INTO `region_areas` VALUES ('2622', '632324', '河南蒙古族自治县', '400', 'h', 'hnmgzzzx', 'henanmengguzuzizhixian');
INSERT INTO `region_areas` VALUES ('2623', '632521', '共和县', '401', 'g', 'ghx', 'gonghexian');
INSERT INTO `region_areas` VALUES ('2624', '632522', '同德县', '401', 't', 'tdx', 'tongdexian');
INSERT INTO `region_areas` VALUES ('2625', '632523', '贵德县', '401', 'g', 'gdx', 'guidexian');
INSERT INTO `region_areas` VALUES ('2626', '632524', '兴海县', '401', 'x', 'xhx', 'xinghaixian');
INSERT INTO `region_areas` VALUES ('2627', '632525', '贵南县', '401', 'g', 'gnx', 'guinanxian');
INSERT INTO `region_areas` VALUES ('2628', '632621', '玛沁县', '402', 'm', 'mqx', 'maqinxian');
INSERT INTO `region_areas` VALUES ('2629', '632622', '班玛县', '402', 'b', 'bmx', 'banmaxian');
INSERT INTO `region_areas` VALUES ('263', '141022', '翼城县', '53', 'y', 'ycx', 'yichengxian');
INSERT INTO `region_areas` VALUES ('2630', '632623', '甘德县', '402', 'g', 'gdx', 'gandexian');
INSERT INTO `region_areas` VALUES ('2631', '632624', '达日县', '402', 'd', 'drx', 'darixian');
INSERT INTO `region_areas` VALUES ('2632', '632625', '久治县', '402', 'j', 'jzx', 'jiuzhixian');
INSERT INTO `region_areas` VALUES ('2633', '632626', '玛多县', '402', 'm', 'mdx', 'maduoxian');
INSERT INTO `region_areas` VALUES ('2634', '632701', '玉树市', '403', 'y', 'yss', 'yushushi');
INSERT INTO `region_areas` VALUES ('2635', '632722', '杂多县', '403', 'z', 'zdx', 'zaduoxian');
INSERT INTO `region_areas` VALUES ('2636', '632723', '称多县', '403', 'c', 'cdx', 'chengduoxian');
INSERT INTO `region_areas` VALUES ('2637', '632724', '治多县', '403', 'z', 'zdx', 'zhiduoxian');
INSERT INTO `region_areas` VALUES ('2638', '632725', '囊谦县', '403', 'n', 'nqx', 'nangqianxian');
INSERT INTO `region_areas` VALUES ('2639', '632726', '曲麻莱县', '403', 'q', 'qmlx', 'qumalaixian');
INSERT INTO `region_areas` VALUES ('264', '141023', '襄汾县', '53', 'x', 'xfx', 'xiangfenxian');
INSERT INTO `region_areas` VALUES ('2640', '632801', '格尔木市', '404', 'g', 'gems', 'geermushi');
INSERT INTO `region_areas` VALUES ('2641', '632802', '德令哈市', '404', 'd', 'dlhs', 'delinghashi');
INSERT INTO `region_areas` VALUES ('2642', '632821', '乌兰县', '404', 'w', 'wlx', 'wulanxian');
INSERT INTO `region_areas` VALUES ('2643', '632822', '都兰县', '404', 'd', 'dlx', 'doulanxian');
INSERT INTO `region_areas` VALUES ('2644', '632823', '天峻县', '404', 't', 'tjx', 'tianjunxian');
INSERT INTO `region_areas` VALUES ('2645', '640104', '兴庆区', '405', 'x', 'xqq', 'xingqingqu');
INSERT INTO `region_areas` VALUES ('2646', '640105', '西夏区', '405', 'x', 'xxq', 'xixiaqu');
INSERT INTO `region_areas` VALUES ('2647', '640106', '金凤区', '405', 'j', 'jfq', 'jinfengqu');
INSERT INTO `region_areas` VALUES ('2648', '640121', '永宁县', '405', 'y', 'ynx', 'yongningxian');
INSERT INTO `region_areas` VALUES ('2649', '640122', '贺兰县', '405', 'h', 'hlx', 'helanxian');
INSERT INTO `region_areas` VALUES ('265', '141024', '洪洞县', '53', 'h', 'hdx', 'hongdongxian');
INSERT INTO `region_areas` VALUES ('2650', '640181', '灵武市', '405', 'l', 'lws', 'lingwushi');
INSERT INTO `region_areas` VALUES ('2651', '640202', '大武口区', '406', 'd', 'dwkq', 'dawukouqu');
INSERT INTO `region_areas` VALUES ('2652', '640205', '惠农区', '406', 'h', 'hnq', 'huinongqu');
INSERT INTO `region_areas` VALUES ('2653', '640221', '平罗县', '406', 'p', 'plx', 'pingluoxian');
INSERT INTO `region_areas` VALUES ('2654', '640302', '利通区', '407', 'l', 'ltq', 'litongqu');
INSERT INTO `region_areas` VALUES ('2655', '640303', '红寺堡区', '407', 'h', 'hsbq', 'hongsibaoqu');
INSERT INTO `region_areas` VALUES ('2656', '640323', '盐池县', '407', 'y', 'ycx', 'yanchixian');
INSERT INTO `region_areas` VALUES ('2657', '640324', '同心县', '407', 't', 'txx', 'tongxinxian');
INSERT INTO `region_areas` VALUES ('2658', '640381', '青铜峡市', '407', 'q', 'qtxs', 'qingtongxiashi');
INSERT INTO `region_areas` VALUES ('2659', '640402', '原州区', '408', 'y', 'yzq', 'yuanzhouqu');
INSERT INTO `region_areas` VALUES ('266', '141025', '古县', '53', 'g', 'gx', 'guxian');
INSERT INTO `region_areas` VALUES ('2660', '640422', '西吉县', '408', 'x', 'xjx', 'xijixian');
INSERT INTO `region_areas` VALUES ('2661', '640423', '隆德县', '408', 'l', 'ldx', 'longdexian');
INSERT INTO `region_areas` VALUES ('2662', '640424', '泾源县', '408', 'j', 'jyx', 'jingyuanxian');
INSERT INTO `region_areas` VALUES ('2663', '640425', '彭阳县', '408', 'p', 'pyx', 'pengyangxian');
INSERT INTO `region_areas` VALUES ('2664', '640502', '沙坡头区', '409', 's', 'sptq', 'shapotouqu');
INSERT INTO `region_areas` VALUES ('2665', '640521', '中宁县', '409', 'z', 'znx', 'zhongningxian');
INSERT INTO `region_areas` VALUES ('2666', '640522', '海原县', '409', 'h', 'hyx', 'haiyuanxian');
INSERT INTO `region_areas` VALUES ('2667', '650102', '天山区', '410', 't', 'tsq', 'tianshanqu');
INSERT INTO `region_areas` VALUES ('2668', '650103', '沙依巴克区', '410', 's', 'sybkq', 'shayibakequ');
INSERT INTO `region_areas` VALUES ('2669', '650104', '新市区', '410', 'x', 'xsq', 'xinshiqu');
INSERT INTO `region_areas` VALUES ('267', '141026', '安泽县', '53', 'a', 'azx', 'anzexian');
INSERT INTO `region_areas` VALUES ('2670', '650105', '水磨沟区', '410', 's', 'smgq', 'shuimogouqu');
INSERT INTO `region_areas` VALUES ('2671', '650106', '头屯河区', '410', 't', 'tthq', 'toutunhequ');
INSERT INTO `region_areas` VALUES ('2672', '650107', '达坂城区', '410', 'd', 'dbcq', 'dabanchengqu');
INSERT INTO `region_areas` VALUES ('2673', '650109', '米东区', '410', 'm', 'mdq', 'midongqu');
INSERT INTO `region_areas` VALUES ('2674', '650121', '乌鲁木齐县', '410', 'w', 'wlmqx', 'wulumuqixian');
INSERT INTO `region_areas` VALUES ('2675', '650202', '独山子区', '411', 'd', 'dszq', 'dushanziqu');
INSERT INTO `region_areas` VALUES ('2676', '650203', '克拉玛依区', '411', 'k', 'klmyq', 'kelamayiqu');
INSERT INTO `region_areas` VALUES ('2677', '650204', '白碱滩区', '411', 'b', 'bjtq', 'baijiantanqu');
INSERT INTO `region_areas` VALUES ('2678', '650205', '乌尔禾区', '411', 'w', 'wehq', 'wuerhequ');
INSERT INTO `region_areas` VALUES ('2679', '652101', '吐鲁番市', '412', 't', 'tlfs', 'tulufanshi');
INSERT INTO `region_areas` VALUES ('268', '141027', '浮山县', '53', 'f', 'fsx', 'fushanxian');
INSERT INTO `region_areas` VALUES ('2680', '652122', '鄯善县', '412', 's', 'ssx', 'shanshanxian');
INSERT INTO `region_areas` VALUES ('2681', '652123', '托克逊县', '412', 't', 'tkxx', 'tuokexunxian');
INSERT INTO `region_areas` VALUES ('2682', '652201', '哈密市', '413', 'h', 'hms', 'hamishi');
INSERT INTO `region_areas` VALUES ('2683', '652222', '巴里坤哈萨克自治县', '413', 'b', 'blkhskzzx', 'balikunhasakezizhixian');
INSERT INTO `region_areas` VALUES ('2684', '652223', '伊吾县', '413', 'y', 'ywx', 'yiwuxian');
INSERT INTO `region_areas` VALUES ('2685', '652301', '昌吉市', '414', 'c', 'cjs', 'changjishi');
INSERT INTO `region_areas` VALUES ('2686', '652302', '阜康市', '414', 'f', 'fks', 'fukangshi');
INSERT INTO `region_areas` VALUES ('2687', '652323', '呼图壁县', '414', 'h', 'htbx', 'hutubixian');
INSERT INTO `region_areas` VALUES ('2688', '652324', '玛纳斯县', '414', 'm', 'mnsx', 'manasixian');
INSERT INTO `region_areas` VALUES ('2689', '652325', '奇台县', '414', 'q', 'qtx', 'qitaixian');
INSERT INTO `region_areas` VALUES ('269', '141028', '吉县', '53', 'j', 'jx', 'jixian');
INSERT INTO `region_areas` VALUES ('2690', '652327', '吉木萨尔县', '414', 'j', 'jmsex', 'jimusaerxian');
INSERT INTO `region_areas` VALUES ('2691', '652328', '木垒哈萨克自治县', '414', 'm', 'mlhskzzx', 'muleihasakezizhixian');
INSERT INTO `region_areas` VALUES ('2692', '652701', '博乐市', '415', 'b', 'bls', 'boleshi');
INSERT INTO `region_areas` VALUES ('2693', '652702', '阿拉山口市', '415', 'a', 'alsks', 'alashankoushi');
INSERT INTO `region_areas` VALUES ('2694', '652722', '精河县', '415', 'j', 'jhx', 'jinghexian');
INSERT INTO `region_areas` VALUES ('2695', '652723', '温泉县', '415', 'w', 'wqx', 'wenquanxian');
INSERT INTO `region_areas` VALUES ('2696', '652801', '库尔勒市', '416', 'k', 'kels', 'kuerleshi');
INSERT INTO `region_areas` VALUES ('2697', '652822', '轮台县', '416', 'l', 'ltx', 'luntaixian');
INSERT INTO `region_areas` VALUES ('2698', '652823', '尉犁县', '416', 'w', 'wlx', 'weilixian');
INSERT INTO `region_areas` VALUES ('2699', '652824', '若羌县', '416', 'r', 'rqx', 'ruoqiangxian');
INSERT INTO `region_areas` VALUES ('27', '130207', '丰南区', '34', 'f', 'fnq', 'fengnanqu');
INSERT INTO `region_areas` VALUES ('270', '141029', '乡宁县', '53', 'x', 'xnx', 'xiangningxian');
INSERT INTO `region_areas` VALUES ('2700', '652825', '且末县', '416', 'q', 'qmx', 'qiemoxian');
INSERT INTO `region_areas` VALUES ('2701', '652826', '焉耆回族自治县', '416', 'y', 'yqhzzzx', 'yanqihuizuzizhixian');
INSERT INTO `region_areas` VALUES ('2702', '652827', '和静县', '416', 'h', 'hjx', 'hejingxian');
INSERT INTO `region_areas` VALUES ('2703', '652828', '和硕县', '416', 'h', 'hsx', 'heshuoxian');
INSERT INTO `region_areas` VALUES ('2704', '652829', '博湖县', '416', 'b', 'bhx', 'bohuxian');
INSERT INTO `region_areas` VALUES ('2705', '652901', '阿克苏市', '417', 'a', 'akss', 'akesushi');
INSERT INTO `region_areas` VALUES ('2706', '652922', '温宿县', '417', 'w', 'wsx', 'wensuxian');
INSERT INTO `region_areas` VALUES ('2707', '652923', '库车县', '417', 'k', 'kcx', 'kuchexian');
INSERT INTO `region_areas` VALUES ('2708', '652924', '沙雅县', '417', 's', 'syx', 'shayaxian');
INSERT INTO `region_areas` VALUES ('2709', '652925', '新和县', '417', 'x', 'xhx', 'xinhexian');
INSERT INTO `region_areas` VALUES ('271', '141030', '大宁县', '53', 'd', 'dnx', 'daningxian');
INSERT INTO `region_areas` VALUES ('2710', '652926', '拜城县', '417', 'b', 'bcx', 'baichengxian');
INSERT INTO `region_areas` VALUES ('2711', '652927', '乌什县', '417', 'w', 'wsx', 'wushenxian');
INSERT INTO `region_areas` VALUES ('2712', '652928', '阿瓦提县', '417', 'a', 'awtx', 'awatixian');
INSERT INTO `region_areas` VALUES ('2713', '652929', '柯坪县', '417', 'k', 'kpx', 'kepingxian');
INSERT INTO `region_areas` VALUES ('2714', '653001', '阿图什市', '418', 'a', 'atss', 'atushenshi');
INSERT INTO `region_areas` VALUES ('2715', '653022', '阿克陶县', '418', 'a', 'aktx', 'aketaoxian');
INSERT INTO `region_areas` VALUES ('2716', '653023', '阿合奇县', '418', 'a', 'ahqx', 'aheqixian');
INSERT INTO `region_areas` VALUES ('2717', '653024', '乌恰县', '418', 'w', 'wqx', 'wuqiaxian');
INSERT INTO `region_areas` VALUES ('2718', '653101', '喀什市', '419', 'k', 'kss', 'kashenshi');
INSERT INTO `region_areas` VALUES ('2719', '653121', '疏附县', '419', 's', 'sfx', 'shufuxian');
INSERT INTO `region_areas` VALUES ('272', '141031', '隰县', '53', 'x', 'xx', 'xixian');
INSERT INTO `region_areas` VALUES ('2720', '653122', '疏勒县', '419', 's', 'slx', 'shulexian');
INSERT INTO `region_areas` VALUES ('2721', '653123', '英吉沙县', '419', 'y', 'yjsx', 'yingjishaxian');
INSERT INTO `region_areas` VALUES ('2722', '653124', '泽普县', '419', 'z', 'zpx', 'zepuxian');
INSERT INTO `region_areas` VALUES ('2723', '653125', '莎车县', '419', 's', 'scx', 'shachexian');
INSERT INTO `region_areas` VALUES ('2724', '653126', '叶城县', '419', 'y', 'ycx', 'yechengxian');
INSERT INTO `region_areas` VALUES ('2725', '653127', '麦盖提县', '419', 'm', 'mgtx', 'maigaitixian');
INSERT INTO `region_areas` VALUES ('2726', '653128', '岳普湖县', '419', 'y', 'yphx', 'yuepuhuxian');
INSERT INTO `region_areas` VALUES ('2727', '653129', '伽师县', '419', 'j', 'jsx', 'jiashixian');
INSERT INTO `region_areas` VALUES ('2728', '653130', '巴楚县', '419', 'b', 'bcx', 'bachuxian');
INSERT INTO `region_areas` VALUES ('2729', '653131', '塔什库尔干塔吉克自治县', '419', 't', 'tskegtjkzzx', 'tashenkuergantajikezizhixian');
INSERT INTO `region_areas` VALUES ('273', '141032', '永和县', '53', 'y', 'yhx', 'yonghexian');
INSERT INTO `region_areas` VALUES ('2730', '653201', '和田市', '420', 'h', 'hts', 'hetianshi');
INSERT INTO `region_areas` VALUES ('2731', '653221', '和田县', '420', 'h', 'htx', 'hetianxian');
INSERT INTO `region_areas` VALUES ('2732', '653222', '墨玉县', '420', 'm', 'myx', 'moyuxian');
INSERT INTO `region_areas` VALUES ('2733', '653223', '皮山县', '420', 'p', 'psx', 'pishanxian');
INSERT INTO `region_areas` VALUES ('2734', '653224', '洛浦县', '420', 'l', 'lpx', 'luopuxian');
INSERT INTO `region_areas` VALUES ('2735', '653225', '策勒县', '420', 'c', 'clx', 'celexian');
INSERT INTO `region_areas` VALUES ('2736', '653226', '于田县', '420', 'y', 'ytx', 'yutianxian');
INSERT INTO `region_areas` VALUES ('2737', '653227', '民丰县', '420', 'm', 'mfx', 'minfengxian');
INSERT INTO `region_areas` VALUES ('2738', '654002', '伊宁市', '421', 'y', 'yns', 'yiningshi');
INSERT INTO `region_areas` VALUES ('2739', '654003', '奎屯市', '421', 'k', 'kts', 'kuitunshi');
INSERT INTO `region_areas` VALUES ('274', '141033', '蒲县', '53', 'p', 'px', 'puxian');
INSERT INTO `region_areas` VALUES ('2740', '654021', '伊宁县', '421', 'y', 'ynx', 'yiningxian');
INSERT INTO `region_areas` VALUES ('2741', '654022', '察布查尔锡伯自治县', '421', 'c', 'cbcexbzzx', 'chabuchaerxibozizhixian');
INSERT INTO `region_areas` VALUES ('2742', '654023', '霍城县', '421', 'h', 'hcx', 'huochengxian');
INSERT INTO `region_areas` VALUES ('2743', '654024', '巩留县', '421', 'g', 'glx', 'gongliuxian');
INSERT INTO `region_areas` VALUES ('2744', '654025', '新源县', '421', 'x', 'xyx', 'xinyuanxian');
INSERT INTO `region_areas` VALUES ('2745', '654026', '昭苏县', '421', 'z', 'zsx', 'zhaosuxian');
INSERT INTO `region_areas` VALUES ('2746', '654027', '特克斯县', '421', 't', 'tksx', 'tekesixian');
INSERT INTO `region_areas` VALUES ('2747', '654028', '尼勒克县', '421', 'n', 'nlkx', 'nilekexian');
INSERT INTO `region_areas` VALUES ('2748', '654201', '塔城市', '422', 't', 'tcs', 'tachengshi');
INSERT INTO `region_areas` VALUES ('2749', '654202', '乌苏市', '422', 'w', 'wss', 'wusushi');
INSERT INTO `region_areas` VALUES ('275', '141034', '汾西县', '53', 'f', 'fxx', 'fenxixian');
INSERT INTO `region_areas` VALUES ('2750', '654221', '额敏县', '422', 'e', 'emx', 'eminxian');
INSERT INTO `region_areas` VALUES ('2751', '654223', '沙湾县', '422', 's', 'swx', 'shawanxian');
INSERT INTO `region_areas` VALUES ('2752', '654224', '托里县', '422', 't', 'tlx', 'tuolixian');
INSERT INTO `region_areas` VALUES ('2753', '654225', '裕民县', '422', 'y', 'ymx', 'yuminxian');
INSERT INTO `region_areas` VALUES ('2754', '654226', '和布克赛尔蒙古自治县', '422', 'h', 'hbksemgzzx', 'hebukesaiermengguzizhixian');
INSERT INTO `region_areas` VALUES ('2755', '654301', '阿勒泰市', '423', 'a', 'alts', 'aletaishi');
INSERT INTO `region_areas` VALUES ('2756', '654321', '布尔津县', '423', 'b', 'bejx', 'buerjinxian');
INSERT INTO `region_areas` VALUES ('2757', '654322', '富蕴县', '423', 'f', 'fyx', 'fuyunxian');
INSERT INTO `region_areas` VALUES ('2758', '654323', '福海县', '423', 'f', 'fhx', 'fuhaixian');
INSERT INTO `region_areas` VALUES ('2759', '654324', '哈巴河县', '423', 'h', 'hbhx', 'habahexian');
INSERT INTO `region_areas` VALUES ('276', '141081', '侯马市', '53', 'h', 'hms', 'houmashi');
INSERT INTO `region_areas` VALUES ('2760', '654325', '青河县', '423', 'q', 'qhx', 'qinghexian');
INSERT INTO `region_areas` VALUES ('2761', '654326', '吉木乃县', '423', 'j', 'jmnx', 'jimunaixian');
INSERT INTO `region_areas` VALUES ('2762', '659001', '石河子市', '424', 's', 'shzs', 'shihezishi');
INSERT INTO `region_areas` VALUES ('2763', '659002', '阿拉尔市', '424', 'a', 'ales', 'alaershi');
INSERT INTO `region_areas` VALUES ('2764', '659003', '图木舒克市', '424', 't', 'tmsks', 'tumushukeshi');
INSERT INTO `region_areas` VALUES ('2765', '659004', '五家渠市', '424', 'w', 'wjqs', 'wujiaqushi');
INSERT INTO `region_areas` VALUES ('2766', '110660', '全境', '1', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2767', '110661', '全境', '2', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2768', '110662', '全境', '3', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2769', '110663', '全境', '4', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('277', '141082', '霍州市', '53', 'h', 'hzs', 'huozhoushi');
INSERT INTO `region_areas` VALUES ('2770', '110664', '全境', '5', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2771', '110665', '全境', '6', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2772', '110666', '全境', '7', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2773', '110667', '全境', '8', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2774', '110668', '全境', '9', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2775', '110669', '全境', '10', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2776', '110670', '全境', '11', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2777', '110671', '全境', '12', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2778', '110672', '全境', '13', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2779', '110673', '全境', '14', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('278', '141102', '离石区', '54', 'l', 'lsq', 'lishiqu');
INSERT INTO `region_areas` VALUES ('2780', '110674', '全境', '15', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2781', '110675', '全境', '16', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2782', '120660', '全境', '17', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2783', '120661', '全境', '18', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2784', '120662', '全境', '19', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2785', '120663', '全境', '20', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2786', '120664', '全境', '21', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2787', '120665', '全境', '22', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2788', '120666', '全境', '23', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2789', '120667', '全境', '24', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('279', '141121', '文水县', '54', 'w', 'wsx', 'wenshuixian');
INSERT INTO `region_areas` VALUES ('2790', '120668', '全境', '25', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2791', '120669', '全境', '26', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2792', '120670', '全境', '27', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2793', '120671', '全境', '28', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2794', '120672', '全境', '29', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2795', '120673', '全境', '30', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2796', '120674', '全境', '31', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2797', '120675', '全境', '32', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2798', '310660', '全境', '103', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2799', '310661', '全境', '104', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('28', '130208', '丰润区', '34', 'f', 'frq', 'fengrunqu');
INSERT INTO `region_areas` VALUES ('280', '141122', '交城县', '54', 'j', 'jcx', 'jiaochengxian');
INSERT INTO `region_areas` VALUES ('2800', '310662', '全境', '105', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2801', '310663', '全境', '106', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2802', '310664', '全境', '107', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2803', '310665', '全境', '108', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2804', '310666', '全境', '109', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2805', '310667', '全境', '110', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2806', '310668', '全境', '111', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2807', '310669', '全境', '112', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2808', '310670', '全境', '113', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2809', '310671', '全境', '114', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('281', '141123', '兴县', '54', 'x', 'xx', 'xingxian');
INSERT INTO `region_areas` VALUES ('2810', '310672', '全境', '115', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2811', '310673', '全境', '116', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2812', '310674', '全境', '117', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2813', '310675', '全境', '118', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2814', '310676', '全境', '119', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2815', '441660', '全境', '259', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2816', '442660', '全境', '260', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2817', '460660', '全境', '280', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2818', '500660', '全境', '282', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2819', '500661', '全境', '283', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('282', '141124', '临县', '54', 'l', 'lx', 'linxian');
INSERT INTO `region_areas` VALUES ('2820', '500662', '全境', '284', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2821', '500663', '全境', '285', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2822', '500664', '全境', '286', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2823', '500665', '全境', '287', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2824', '500666', '全境', '288', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2825', '500667', '全境', '289', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2826', '500668', '全境', '290', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2827', '500669', '全境', '291', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2828', '500670', '全境', '292', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2829', '500671', '全境', '293', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('283', '141125', '柳林县', '54', 'l', 'llx', 'liulinxian');
INSERT INTO `region_areas` VALUES ('2830', '500672', '全境', '294', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2831', '500673', '全境', '295', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2832', '500674', '全境', '296', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2833', '500675', '全境', '297', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2834', '500676', '全境', '298', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2835', '500677', '全境', '299', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2836', '500678', '全境', '300', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2837', '500679', '全境', '301', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2838', '500680', '全境', '302', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2839', '500681', '全境', '303', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('284', '141126', '石楼县', '54', 's', 'slx', 'shilouxian');
INSERT INTO `region_areas` VALUES ('2840', '500682', '全境', '304', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2841', '500683', '全境', '305', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2842', '500684', '全境', '306', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2843', '500685', '全境', '307', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2844', '500686', '全境', '308', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2845', '500687', '全境', '309', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2846', '500688', '全境', '310', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2847', '500689', '全境', '311', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2848', '500690', '全境', '312', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2849', '500691', '全境', '313', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('285', '141127', '岚县', '54', 'l', 'lx', 'lanxian');
INSERT INTO `region_areas` VALUES ('2850', '500692', '全境', '314', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2851', '500693', '全境', '315', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2852', '500694', '全境', '316', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2853', '500695', '全境', '317', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2854', '500696', '全境', '318', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2855', '500697', '全境', '319', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('2856', '620660', '全境', '384', 'q', 'qj', 'quanjing');
INSERT INTO `region_areas` VALUES ('286', '141128', '方山县', '54', 'f', 'fsx', 'fangshanxian');
INSERT INTO `region_areas` VALUES ('287', '141129', '中阳县', '54', 'z', 'zyx', 'zhongyangxian');
INSERT INTO `region_areas` VALUES ('288', '141130', '交口县', '54', 'j', 'jkx', 'jiaokouxian');
INSERT INTO `region_areas` VALUES ('289', '141181', '孝义市', '54', 'x', 'xys', 'xiaoyishi');
INSERT INTO `region_areas` VALUES ('29', '130209', '曹妃甸区', '34', 'c', 'cfdq', 'caofeidianqu');
INSERT INTO `region_areas` VALUES ('290', '141182', '汾阳市', '54', 'f', 'fys', 'fenyangshi');
INSERT INTO `region_areas` VALUES ('291', '150102', '新城区', '55', 'x', 'xcq', 'xinchengqu');
INSERT INTO `region_areas` VALUES ('292', '150103', '回民区', '55', 'h', 'hmq', 'huiminqu');
INSERT INTO `region_areas` VALUES ('293', '150104', '玉泉区', '55', 'y', 'yqq', 'yuquanqu');
INSERT INTO `region_areas` VALUES ('294', '150105', '赛罕区', '55', 's', 'shq', 'saihanqu');
INSERT INTO `region_areas` VALUES ('295', '150121', '土默特左旗', '55', 't', 'tmtzq', 'tumotezuoqi');
INSERT INTO `region_areas` VALUES ('296', '150122', '托克托县', '55', 't', 'tktx', 'tuoketuoxian');
INSERT INTO `region_areas` VALUES ('297', '150123', '和林格尔县', '55', 'h', 'hlgex', 'helingeerxian');
INSERT INTO `region_areas` VALUES ('298', '150124', '清水河县', '55', 'q', 'qshx', 'qingshuihexian');
INSERT INTO `region_areas` VALUES ('299', '150125', '武川县', '55', 'w', 'wcx', 'wuchuanxian');
INSERT INTO `region_areas` VALUES ('3', '130105', '新华区', '33', 'x', 'xhq', 'xinhuaqu');
INSERT INTO `region_areas` VALUES ('30', '130223', '滦县', '34', 'l', 'lx', 'luanxian');
INSERT INTO `region_areas` VALUES ('300', '150202', '东河区', '56', 'd', 'dhq', 'donghequ');
INSERT INTO `region_areas` VALUES ('301', '150203', '昆都仑区', '56', 'k', 'kdlq', 'kundoulunqu');
INSERT INTO `region_areas` VALUES ('302', '150204', '青山区', '56', 'q', 'qsq', 'qingshanqu');
INSERT INTO `region_areas` VALUES ('303', '150205', '石拐区', '56', 's', 'sgq', 'shiguaiqu');
INSERT INTO `region_areas` VALUES ('304', '150206', '白云鄂博矿区', '56', 'b', 'byebkq', 'baiyunebokuangqu');
INSERT INTO `region_areas` VALUES ('305', '150207', '九原区', '56', 'j', 'jyq', 'jiuyuanqu');
INSERT INTO `region_areas` VALUES ('306', '150221', '土默特右旗', '56', 't', 'tmtyq', 'tumoteyouqi');
INSERT INTO `region_areas` VALUES ('307', '150222', '固阳县', '56', 'g', 'gyx', 'guyangxian');
INSERT INTO `region_areas` VALUES ('308', '150223', '达尔罕茂明安联合旗', '56', 'd', 'dehmmalhq', 'daerhanmaominganlianheqi');
INSERT INTO `region_areas` VALUES ('309', '150302', '海勃湾区', '57', 'h', 'hbwq', 'haibowanqu');
INSERT INTO `region_areas` VALUES ('31', '130224', '滦南县', '34', 'l', 'lnx', 'luannanxian');
INSERT INTO `region_areas` VALUES ('310', '150303', '海南区', '57', 'h', 'hnq', 'hainanqu');
INSERT INTO `region_areas` VALUES ('311', '150304', '乌达区', '57', 'w', 'wdq', 'wudaqu');
INSERT INTO `region_areas` VALUES ('312', '150402', '红山区', '58', 'h', 'hsq', 'hongshanqu');
INSERT INTO `region_areas` VALUES ('313', '150403', '元宝山区', '58', 'y', 'ybsq', 'yuanbaoshanqu');
INSERT INTO `region_areas` VALUES ('314', '150404', '松山区', '58', 's', 'ssq', 'songshanqu');
INSERT INTO `region_areas` VALUES ('315', '150421', '阿鲁科尔沁旗', '58', 'a', 'alkeqq', 'alukeerqinqi');
INSERT INTO `region_areas` VALUES ('316', '150422', '巴林左旗', '58', 'b', 'blzq', 'balinzuoqi');
INSERT INTO `region_areas` VALUES ('317', '150423', '巴林右旗', '58', 'b', 'blyq', 'balinyouqi');
INSERT INTO `region_areas` VALUES ('318', '150424', '林西县', '58', 'l', 'lxx', 'linxixian');
INSERT INTO `region_areas` VALUES ('319', '150425', '克什克腾旗', '58', 'k', 'ksktq', 'keshenketengqi');
INSERT INTO `region_areas` VALUES ('32', '130225', '乐亭县', '34', 'l', 'ltx', 'letingxian');
INSERT INTO `region_areas` VALUES ('320', '150426', '翁牛特旗', '58', 'w', 'wntq', 'wengniuteqi');
INSERT INTO `region_areas` VALUES ('321', '150428', '喀喇沁旗', '58', 'k', 'klqq', 'kalaqinqi');
INSERT INTO `region_areas` VALUES ('322', '150429', '宁城县', '58', 'n', 'ncx', 'ningchengxian');
INSERT INTO `region_areas` VALUES ('323', '150430', '敖汉旗', '58', 'a', 'ahq', 'aohanqi');
INSERT INTO `region_areas` VALUES ('324', '150502', '科尔沁区', '59', 'k', 'keqq', 'keerqinqu');
INSERT INTO `region_areas` VALUES ('325', '150521', '科尔沁左翼中旗', '59', 'k', 'keqzyzq', 'keerqinzuoyizhongqi');
INSERT INTO `region_areas` VALUES ('326', '150522', '科尔沁左翼后旗', '59', 'k', 'keqzyhq', 'keerqinzuoyihouqi');
INSERT INTO `region_areas` VALUES ('327', '150523', '开鲁县', '59', 'k', 'klx', 'kailuxian');
INSERT INTO `region_areas` VALUES ('328', '150524', '库伦旗', '59', 'k', 'klq', 'kulunqi');
INSERT INTO `region_areas` VALUES ('329', '150525', '奈曼旗', '59', 'n', 'nmq', 'naimanqi');
INSERT INTO `region_areas` VALUES ('33', '130227', '迁西县', '34', 'q', 'qxx', 'qianxixian');
INSERT INTO `region_areas` VALUES ('330', '150526', '扎鲁特旗', '59', 'z', 'zltq', 'zhaluteqi');
INSERT INTO `region_areas` VALUES ('331', '150581', '霍林郭勒市', '59', 'h', 'hlgls', 'huolinguoleshi');
INSERT INTO `region_areas` VALUES ('332', '150602', '东胜区', '60', 'd', 'dsq', 'dongshengqu');
INSERT INTO `region_areas` VALUES ('333', '150621', '达拉特旗', '60', 'd', 'dltq', 'dalateqi');
INSERT INTO `region_areas` VALUES ('334', '150622', '准格尔旗', '60', 'z', 'zgeq', 'zhungeerqi');
INSERT INTO `region_areas` VALUES ('335', '150623', '鄂托克前旗', '60', 'e', 'etkqq', 'etuokeqianqi');
INSERT INTO `region_areas` VALUES ('336', '150624', '鄂托克旗', '60', 'e', 'etkq', 'etuokeqi');
INSERT INTO `region_areas` VALUES ('337', '150625', '杭锦旗', '60', 'h', 'hjq', 'hangjinqi');
INSERT INTO `region_areas` VALUES ('338', '150626', '乌审旗', '60', 'w', 'wsq', 'wushenqi');
INSERT INTO `region_areas` VALUES ('339', '150627', '伊金霍洛旗', '60', 'y', 'yjhlq', 'yijinhuoluoqi');
INSERT INTO `region_areas` VALUES ('34', '130229', '玉田县', '34', 'y', 'ytx', 'yutianxian');
INSERT INTO `region_areas` VALUES ('340', '150702', '海拉尔区', '61', 'h', 'hleq', 'hailaerqu');
INSERT INTO `region_areas` VALUES ('341', '150703', '扎赉诺尔区', '61', 'z', 'zlneq', 'zhalainuoerqu');
INSERT INTO `region_areas` VALUES ('342', '150721', '阿荣旗', '61', 'a', 'arq', 'arongqi');
INSERT INTO `region_areas` VALUES ('343', '150722', '莫力达瓦达斡尔族自治旗', '61', 'm', 'mldwdwezzzq', 'molidawadawoerzuzizhiqi');
INSERT INTO `region_areas` VALUES ('344', '150723', '鄂伦春自治旗', '61', 'e', 'elczzq', 'elunchunzizhiqi');
INSERT INTO `region_areas` VALUES ('345', '150724', '鄂温克族自治旗', '61', 'e', 'ewkzzzq', 'ewenkezuzizhiqi');
INSERT INTO `region_areas` VALUES ('346', '150725', '陈巴尔虎旗', '61', 'c', 'cbehq', 'chenbaerhuqi');
INSERT INTO `region_areas` VALUES ('347', '150726', '新巴尔虎左旗', '61', 'x', 'xbehzq', 'xinbaerhuzuoqi');
INSERT INTO `region_areas` VALUES ('348', '150727', '新巴尔虎右旗', '61', 'x', 'xbehyq', 'xinbaerhuyouqi');
INSERT INTO `region_areas` VALUES ('349', '150781', '满洲里市', '61', 'm', 'mzls', 'manzhoulishi');
INSERT INTO `region_areas` VALUES ('35', '130281', '遵化市', '34', 'z', 'zhs', 'zunhuashi');
INSERT INTO `region_areas` VALUES ('350', '150782', '牙克石市', '61', 'y', 'ykss', 'yakeshishi');
INSERT INTO `region_areas` VALUES ('351', '150783', '扎兰屯市', '61', 'z', 'zlts', 'zhalantunshi');
INSERT INTO `region_areas` VALUES ('352', '150784', '额尔古纳市', '61', 'e', 'eegns', 'eergunashi');
INSERT INTO `region_areas` VALUES ('353', '150785', '根河市', '61', 'g', 'ghs', 'genheshi');
INSERT INTO `region_areas` VALUES ('354', '150802', '临河区', '62', 'l', 'lhq', 'linhequ');
INSERT INTO `region_areas` VALUES ('355', '150821', '五原县', '62', 'w', 'wyx', 'wuyuanxian');
INSERT INTO `region_areas` VALUES ('356', '150822', '磴口县', '62', 'd', 'dkx', 'dengkouxian');
INSERT INTO `region_areas` VALUES ('357', '150823', '乌拉特前旗', '62', 'w', 'wltqq', 'wulateqianqi');
INSERT INTO `region_areas` VALUES ('358', '150824', '乌拉特中旗', '62', 'w', 'wltzq', 'wulatezhongqi');
INSERT INTO `region_areas` VALUES ('359', '150825', '乌拉特后旗', '62', 'w', 'wlthq', 'wulatehouqi');
INSERT INTO `region_areas` VALUES ('36', '130283', '迁安市', '34', 'q', 'qas', 'qiananshi');
INSERT INTO `region_areas` VALUES ('360', '150826', '杭锦后旗', '62', 'h', 'hjhq', 'hangjinhouqi');
INSERT INTO `region_areas` VALUES ('361', '150902', '集宁区', '63', 'j', 'jnq', 'jiningqu');
INSERT INTO `region_areas` VALUES ('362', '150921', '卓资县', '63', 'z', 'zzx', 'zhuozixian');
INSERT INTO `region_areas` VALUES ('363', '150922', '化德县', '63', 'h', 'hdx', 'huadexian');
INSERT INTO `region_areas` VALUES ('364', '150923', '商都县', '63', 's', 'sdx', 'shangdouxian');
INSERT INTO `region_areas` VALUES ('365', '150924', '兴和县', '63', 'x', 'xhx', 'xinghexian');
INSERT INTO `region_areas` VALUES ('366', '150925', '凉城县', '63', 'l', 'lcx', 'liangchengxian');
INSERT INTO `region_areas` VALUES ('367', '150926', '察哈尔右翼前旗', '63', 'c', 'cheyyqq', 'chahaeryouyiqianqi');
INSERT INTO `region_areas` VALUES ('368', '150927', '察哈尔右翼中旗', '63', 'c', 'cheyyzq', 'chahaeryouyizhongqi');
INSERT INTO `region_areas` VALUES ('369', '150928', '察哈尔右翼后旗', '63', 'c', 'cheyyhq', 'chahaeryouyihouqi');
INSERT INTO `region_areas` VALUES ('37', '130302', '海港区', '35', 'h', 'hgq', 'haigangqu');
INSERT INTO `region_areas` VALUES ('370', '150929', '四子王旗', '63', 's', 'szwq', 'siziwangqi');
INSERT INTO `region_areas` VALUES ('371', '150981', '丰镇市', '63', 'f', 'fzs', 'fengzhenshi');
INSERT INTO `region_areas` VALUES ('372', '152201', '乌兰浩特市', '64', 'w', 'wlhts', 'wulanhaoteshi');
INSERT INTO `region_areas` VALUES ('373', '152202', '阿尔山市', '64', 'a', 'aess', 'aershanshi');
INSERT INTO `region_areas` VALUES ('374', '152221', '科尔沁右翼前旗', '64', 'k', 'keqyyqq', 'keerqinyouyiqianqi');
INSERT INTO `region_areas` VALUES ('375', '152222', '科尔沁右翼中旗', '64', 'k', 'keqyyzq', 'keerqinyouyizhongqi');
INSERT INTO `region_areas` VALUES ('376', '152223', '扎赉特旗', '64', 'z', 'zltq', 'zhalaiteqi');
INSERT INTO `region_areas` VALUES ('377', '152224', '突泉县', '64', 't', 'tqx', 'tuquanxian');
INSERT INTO `region_areas` VALUES ('378', '152501', '二连浩特市', '65', 'e', 'elhts', 'erlianhaoteshi');
INSERT INTO `region_areas` VALUES ('379', '152502', '锡林浩特市', '65', 'x', 'xlhts', 'xilinhaoteshi');
INSERT INTO `region_areas` VALUES ('38', '130303', '山海关区', '35', 's', 'shgq', 'shanhaiguanqu');
INSERT INTO `region_areas` VALUES ('380', '152522', '阿巴嘎旗', '65', 'a', 'abgq', 'abagaqi');
INSERT INTO `region_areas` VALUES ('381', '152523', '苏尼特左旗', '65', 's', 'sntzq', 'sunitezuoqi');
INSERT INTO `region_areas` VALUES ('382', '152524', '苏尼特右旗', '65', 's', 'sntyq', 'suniteyouqi');
INSERT INTO `region_areas` VALUES ('383', '152525', '东乌珠穆沁旗', '65', 'd', 'dwzmqq', 'dongwuzhumuqinqi');
INSERT INTO `region_areas` VALUES ('384', '152526', '西乌珠穆沁旗', '65', 'x', 'xwzmqq', 'xiwuzhumuqinqi');
INSERT INTO `region_areas` VALUES ('385', '152527', '太仆寺旗', '65', 't', 'tpsq', 'taipusiqi');
INSERT INTO `region_areas` VALUES ('386', '152528', '镶黄旗', '65', 'x', 'xhq', 'xianghuangqi');
INSERT INTO `region_areas` VALUES ('387', '152529', '正镶白旗', '65', 'z', 'zxbq', 'zhengxiangbaiqi');
INSERT INTO `region_areas` VALUES ('388', '152530', '正蓝旗', '65', 'z', 'zlq', 'zhenglanqi');
INSERT INTO `region_areas` VALUES ('389', '152531', '多伦县', '65', 'd', 'dlx', 'duolunxian');
INSERT INTO `region_areas` VALUES ('39', '130304', '北戴河区', '35', 'b', 'bdhq', 'beidaihequ');
INSERT INTO `region_areas` VALUES ('390', '152921', '阿拉善左旗', '66', 'a', 'alszq', 'alashanzuoqi');
INSERT INTO `region_areas` VALUES ('391', '152922', '阿拉善右旗', '66', 'a', 'alsyq', 'alashanyouqi');
INSERT INTO `region_areas` VALUES ('392', '152923', '额济纳旗', '66', 'e', 'ejnq', 'ejinaqi');
INSERT INTO `region_areas` VALUES ('393', '210102', '和平区', '67', 'h', 'hpq', 'hepingqu');
INSERT INTO `region_areas` VALUES ('394', '210103', '沈河区', '67', 's', 'shq', 'shenhequ');
INSERT INTO `region_areas` VALUES ('395', '210104', '大东区', '67', 'd', 'ddq', 'dadongqu');
INSERT INTO `region_areas` VALUES ('396', '210105', '皇姑区', '67', 'h', 'hgq', 'huangguqu');
INSERT INTO `region_areas` VALUES ('397', '210106', '铁西区', '67', 't', 'txq', 'tiexiqu');
INSERT INTO `region_areas` VALUES ('398', '210111', '苏家屯区', '67', 's', 'sjtq', 'sujiatunqu');
INSERT INTO `region_areas` VALUES ('399', '210112', '浑南区', '67', 'h', 'hnq', 'hunnanqu');
INSERT INTO `region_areas` VALUES ('4', '130107', '井陉矿区', '33', 'j', 'jxkq', 'jingxingkuangqu');
INSERT INTO `region_areas` VALUES ('40', '130321', '青龙满族自治县', '35', 'q', 'qlmzzzx', 'qinglongmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('400', '210113', '沈北新区', '67', 's', 'sbxq', 'shenbeixinqu');
INSERT INTO `region_areas` VALUES ('401', '210114', '于洪区', '67', 'y', 'yhq', 'yuhongqu');
INSERT INTO `region_areas` VALUES ('402', '210122', '辽中县', '67', 'l', 'lzx', 'liaozhongxian');
INSERT INTO `region_areas` VALUES ('403', '210123', '康平县', '67', 'k', 'kpx', 'kangpingxian');
INSERT INTO `region_areas` VALUES ('404', '210124', '法库县', '67', 'f', 'fkx', 'fakuxian');
INSERT INTO `region_areas` VALUES ('405', '210181', '新民市', '67', 'x', 'xms', 'xinminshi');
INSERT INTO `region_areas` VALUES ('406', '210202', '中山区', '68', 'z', 'zsq', 'zhongshanqu');
INSERT INTO `region_areas` VALUES ('407', '210203', '西岗区', '68', 'x', 'xgq', 'xigangqu');
INSERT INTO `region_areas` VALUES ('408', '210204', '沙河口区', '68', 's', 'shkq', 'shahekouqu');
INSERT INTO `region_areas` VALUES ('409', '210211', '甘井子区', '68', 'g', 'gjzq', 'ganjingziqu');
INSERT INTO `region_areas` VALUES ('41', '130322', '昌黎县', '35', 'c', 'clx', 'changlixian');
INSERT INTO `region_areas` VALUES ('410', '210212', '旅顺口区', '68', 'l', 'lskq', 'lu:shunkouqu');
INSERT INTO `region_areas` VALUES ('411', '210213', '金州区', '68', 'j', 'jzq', 'jinzhouqu');
INSERT INTO `region_areas` VALUES ('412', '210224', '长海县', '68', 'z', 'zhx', 'zhanghaixian');
INSERT INTO `region_areas` VALUES ('413', '210281', '瓦房店市', '68', 'w', 'wfds', 'wafangdianshi');
INSERT INTO `region_areas` VALUES ('414', '210282', '普兰店市', '68', 'p', 'plds', 'pulandianshi');
INSERT INTO `region_areas` VALUES ('415', '210283', '庄河市', '68', 'z', 'zhs', 'zhuangheshi');
INSERT INTO `region_areas` VALUES ('416', '210302', '铁东区', '69', 't', 'tdq', 'tiedongqu');
INSERT INTO `region_areas` VALUES ('417', '210303', '铁西区', '69', 't', 'txq', 'tiexiqu');
INSERT INTO `region_areas` VALUES ('418', '210304', '立山区', '69', 'l', 'lsq', 'lishanqu');
INSERT INTO `region_areas` VALUES ('419', '210311', '千山区', '69', 'q', 'qsq', 'qianshanqu');
INSERT INTO `region_areas` VALUES ('42', '130323', '抚宁县', '35', 'f', 'fnx', 'funingxian');
INSERT INTO `region_areas` VALUES ('420', '210321', '台安县', '69', 't', 'tax', 'taianxian');
INSERT INTO `region_areas` VALUES ('421', '210323', '岫岩满族自治县', '69', 'x', 'xymzzzx', 'xiuyanmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('422', '210381', '海城市', '69', 'h', 'hcs', 'haichengshi');
INSERT INTO `region_areas` VALUES ('423', '210402', '新抚区', '70', 'x', 'xfq', 'xinfuqu');
INSERT INTO `region_areas` VALUES ('424', '210403', '东洲区', '70', 'd', 'dzq', 'dongzhouqu');
INSERT INTO `region_areas` VALUES ('425', '210404', '望花区', '70', 'w', 'whq', 'wanghuaqu');
INSERT INTO `region_areas` VALUES ('426', '210411', '顺城区', '70', 's', 'scq', 'shunchengqu');
INSERT INTO `region_areas` VALUES ('427', '210421', '抚顺县', '70', 'f', 'fsx', 'fushunxian');
INSERT INTO `region_areas` VALUES ('428', '210422', '新宾满族自治县', '70', 'x', 'xbmzzzx', 'xinbinmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('429', '210423', '清原满族自治县', '70', 'q', 'qymzzzx', 'qingyuanmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('43', '130324', '卢龙县', '35', 'l', 'llx', 'lulongxian');
INSERT INTO `region_areas` VALUES ('430', '210502', '平山区', '71', 'p', 'psq', 'pingshanqu');
INSERT INTO `region_areas` VALUES ('431', '210503', '溪湖区', '71', 'x', 'xhq', 'xihuqu');
INSERT INTO `region_areas` VALUES ('432', '210504', '明山区', '71', 'm', 'msq', 'mingshanqu');
INSERT INTO `region_areas` VALUES ('433', '210505', '南芬区', '71', 'n', 'nfq', 'nanfenqu');
INSERT INTO `region_areas` VALUES ('434', '210521', '本溪满族自治县', '71', 'b', 'bxmzzzx', 'benximanzuzizhixian');
INSERT INTO `region_areas` VALUES ('435', '210522', '桓仁满族自治县', '71', 'h', 'hrmzzzx', 'huanrenmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('436', '210602', '元宝区', '72', 'y', 'ybq', 'yuanbaoqu');
INSERT INTO `region_areas` VALUES ('437', '210603', '振兴区', '72', 'z', 'zxq', 'zhenxingqu');
INSERT INTO `region_areas` VALUES ('438', '210604', '振安区', '72', 'z', 'zaq', 'zhenanqu');
INSERT INTO `region_areas` VALUES ('439', '210624', '宽甸满族自治县', '72', 'k', 'kdmzzzx', 'kuandianmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('44', '130402', '邯山区', '36', 'h', 'hsq', 'hanshanqu');
INSERT INTO `region_areas` VALUES ('440', '210681', '东港市', '72', 'd', 'dgs', 'donggangshi');
INSERT INTO `region_areas` VALUES ('441', '210682', '凤城市', '72', 'f', 'fcs', 'fengchengshi');
INSERT INTO `region_areas` VALUES ('442', '210702', '古塔区', '73', 'g', 'gtq', 'gutaqu');
INSERT INTO `region_areas` VALUES ('443', '210703', '凌河区', '73', 'l', 'lhq', 'linghequ');
INSERT INTO `region_areas` VALUES ('444', '210711', '太和区', '73', 't', 'thq', 'taihequ');
INSERT INTO `region_areas` VALUES ('445', '210726', '黑山县', '73', 'h', 'hsx', 'heishanxian');
INSERT INTO `region_areas` VALUES ('446', '210727', '义县', '73', 'y', 'yx', 'yixian');
INSERT INTO `region_areas` VALUES ('447', '210781', '凌海市', '73', 'l', 'lhs', 'linghaishi');
INSERT INTO `region_areas` VALUES ('448', '210782', '北镇市', '73', 'b', 'bzs', 'beizhenshi');
INSERT INTO `region_areas` VALUES ('449', '210802', '站前区', '74', 'z', 'zqq', 'zhanqianqu');
INSERT INTO `region_areas` VALUES ('45', '130403', '丛台区', '36', 'c', 'ctq', 'congtaiqu');
INSERT INTO `region_areas` VALUES ('450', '210803', '西市区', '74', 'x', 'xsq', 'xishiqu');
INSERT INTO `region_areas` VALUES ('451', '210804', '鲅鱼圈区', '74', 'b', 'byqq', 'bayuquanqu');
INSERT INTO `region_areas` VALUES ('452', '210811', '老边区', '74', 'l', 'lbq', 'laobianqu');
INSERT INTO `region_areas` VALUES ('453', '210881', '盖州市', '74', 'g', 'gzs', 'gaizhoushi');
INSERT INTO `region_areas` VALUES ('454', '210882', '大石桥市', '74', 'd', 'dsqs', 'dashiqiaoshi');
INSERT INTO `region_areas` VALUES ('455', '210902', '海州区', '75', 'h', 'hzq', 'haizhouqu');
INSERT INTO `region_areas` VALUES ('456', '210903', '新邱区', '75', 'x', 'xqq', 'xinqiuqu');
INSERT INTO `region_areas` VALUES ('457', '210904', '太平区', '75', 't', 'tpq', 'taipingqu');
INSERT INTO `region_areas` VALUES ('458', '210905', '清河门区', '75', 'q', 'qhmq', 'qinghemenqu');
INSERT INTO `region_areas` VALUES ('459', '210911', '细河区', '75', 'x', 'xhq', 'xihequ');
INSERT INTO `region_areas` VALUES ('46', '130404', '复兴区', '36', 'f', 'fxq', 'fuxingqu');
INSERT INTO `region_areas` VALUES ('460', '210921', '阜新蒙古族自治县', '75', 'f', 'fxmgzzzx', 'fuxinmengguzuzizhixian');
INSERT INTO `region_areas` VALUES ('461', '210922', '彰武县', '75', 'z', 'zwx', 'zhangwuxian');
INSERT INTO `region_areas` VALUES ('462', '211002', '白塔区', '76', 'b', 'btq', 'baitaqu');
INSERT INTO `region_areas` VALUES ('463', '211003', '文圣区', '76', 'w', 'wsq', 'wenshengqu');
INSERT INTO `region_areas` VALUES ('464', '211004', '宏伟区', '76', 'h', 'hwq', 'hongweiqu');
INSERT INTO `region_areas` VALUES ('465', '211005', '弓长岭区', '76', 'g', 'gzlq', 'gongzhanglingqu');
INSERT INTO `region_areas` VALUES ('466', '211011', '太子河区', '76', 't', 'tzhq', 'taizihequ');
INSERT INTO `region_areas` VALUES ('467', '211021', '辽阳县', '76', 'l', 'lyx', 'liaoyangxian');
INSERT INTO `region_areas` VALUES ('468', '211081', '灯塔市', '76', 'd', 'dts', 'dengtashi');
INSERT INTO `region_areas` VALUES ('469', '211102', '双台子区', '77', 's', 'stzq', 'shuangtaiziqu');
INSERT INTO `region_areas` VALUES ('47', '130406', '峰峰矿区', '36', 'f', 'ffkq', 'fengfengkuangqu');
INSERT INTO `region_areas` VALUES ('470', '211103', '兴隆台区', '77', 'x', 'xltq', 'xinglongtaiqu');
INSERT INTO `region_areas` VALUES ('471', '211121', '大洼县', '77', 'd', 'dwx', 'dawaxian');
INSERT INTO `region_areas` VALUES ('472', '211122', '盘山县', '77', 'p', 'psx', 'panshanxian');
INSERT INTO `region_areas` VALUES ('473', '211202', '银州区', '78', 'y', 'yzq', 'yinzhouqu');
INSERT INTO `region_areas` VALUES ('474', '211204', '清河区', '78', 'q', 'qhq', 'qinghequ');
INSERT INTO `region_areas` VALUES ('475', '211221', '铁岭县', '78', 't', 'tlx', 'tielingxian');
INSERT INTO `region_areas` VALUES ('476', '211223', '西丰县', '78', 'x', 'xfx', 'xifengxian');
INSERT INTO `region_areas` VALUES ('477', '211224', '昌图县', '78', 'c', 'ctx', 'changtuxian');
INSERT INTO `region_areas` VALUES ('478', '211281', '调兵山市', '78', 'd', 'dbss', 'diaobingshanshi');
INSERT INTO `region_areas` VALUES ('479', '211282', '开原市', '78', 'k', 'kys', 'kaiyuanshi');
INSERT INTO `region_areas` VALUES ('48', '130421', '邯郸县', '36', 'h', 'hdx', 'handanxian');
INSERT INTO `region_areas` VALUES ('480', '211302', '双塔区', '79', 's', 'stq', 'shuangtaqu');
INSERT INTO `region_areas` VALUES ('481', '211303', '龙城区', '79', 'l', 'lcq', 'longchengqu');
INSERT INTO `region_areas` VALUES ('482', '211321', '朝阳县', '79', 'c', 'cyx', 'chaoyangxian');
INSERT INTO `region_areas` VALUES ('483', '211322', '建平县', '79', 'j', 'jpx', 'jianpingxian');
INSERT INTO `region_areas` VALUES ('484', '211324', '喀喇沁左翼蒙古族自治县', '79', 'k', 'klqzymgzzzx', 'kalaqinzuoyimengguzuzizhixian');
INSERT INTO `region_areas` VALUES ('485', '211381', '北票市', '79', 'b', 'bps', 'beipiaoshi');
INSERT INTO `region_areas` VALUES ('486', '211382', '凌源市', '79', 'l', 'lys', 'lingyuanshi');
INSERT INTO `region_areas` VALUES ('487', '211402', '连山区', '80', 'l', 'lsq', 'lianshanqu');
INSERT INTO `region_areas` VALUES ('488', '211403', '龙港区', '80', 'l', 'lgq', 'longgangqu');
INSERT INTO `region_areas` VALUES ('489', '211404', '南票区', '80', 'n', 'npq', 'nanpiaoqu');
INSERT INTO `region_areas` VALUES ('49', '130423', '临漳县', '36', 'l', 'lzx', 'linzhangxian');
INSERT INTO `region_areas` VALUES ('490', '211421', '绥中县', '80', 's', 'szx', 'suizhongxian');
INSERT INTO `region_areas` VALUES ('491', '211422', '建昌县', '80', 'j', 'jcx', 'jianchangxian');
INSERT INTO `region_areas` VALUES ('492', '211481', '兴城市', '80', 'x', 'xcs', 'xingchengshi');
INSERT INTO `region_areas` VALUES ('493', '220102', '南关区', '81', 'n', 'ngq', 'nanguanqu');
INSERT INTO `region_areas` VALUES ('494', '220103', '宽城区', '81', 'k', 'kcq', 'kuanchengqu');
INSERT INTO `region_areas` VALUES ('495', '220104', '朝阳区', '81', 'c', 'cyq', 'chaoyangqu');
INSERT INTO `region_areas` VALUES ('496', '220105', '二道区', '81', 'e', 'edq', 'erdaoqu');
INSERT INTO `region_areas` VALUES ('497', '220106', '绿园区', '81', 'l', 'lyq', 'lu:yuanqu');
INSERT INTO `region_areas` VALUES ('498', '220112', '双阳区', '81', 's', 'syq', 'shuangyangqu');
INSERT INTO `region_areas` VALUES ('499', '220113', '九台区', '81', 'j', 'jtq', 'jiutaiqu');
INSERT INTO `region_areas` VALUES ('5', '130108', '裕华区', '33', 'y', 'yhq', 'yuhuaqu');
INSERT INTO `region_areas` VALUES ('50', '130424', '成安县', '36', 'c', 'cax', 'chenganxian');
INSERT INTO `region_areas` VALUES ('500', '220122', '农安县', '81', 'n', 'nax', 'nonganxian');
INSERT INTO `region_areas` VALUES ('501', '220182', '榆树市', '81', 'y', 'yss', 'yushushi');
INSERT INTO `region_areas` VALUES ('502', '220183', '德惠市', '81', 'd', 'dhs', 'dehuishi');
INSERT INTO `region_areas` VALUES ('503', '220202', '昌邑区', '82', 'c', 'cyq', 'changyiqu');
INSERT INTO `region_areas` VALUES ('504', '220203', '龙潭区', '82', 'l', 'ltq', 'longtanqu');
INSERT INTO `region_areas` VALUES ('505', '220204', '船营区', '82', 'c', 'cyq', 'chuanyingqu');
INSERT INTO `region_areas` VALUES ('506', '220211', '丰满区', '82', 'f', 'fmq', 'fengmanqu');
INSERT INTO `region_areas` VALUES ('507', '220221', '永吉县', '82', 'y', 'yjx', 'yongjixian');
INSERT INTO `region_areas` VALUES ('508', '220281', '蛟河市', '82', 'j', 'jhs', 'jiaoheshi');
INSERT INTO `region_areas` VALUES ('509', '220282', '桦甸市', '82', 'h', 'hds', 'huadianshi');
INSERT INTO `region_areas` VALUES ('51', '130425', '大名县', '36', 'd', 'dmx', 'damingxian');
INSERT INTO `region_areas` VALUES ('510', '220283', '舒兰市', '82', 's', 'sls', 'shulanshi');
INSERT INTO `region_areas` VALUES ('511', '220284', '磐石市', '82', 'p', 'pss', 'panshishi');
INSERT INTO `region_areas` VALUES ('512', '220302', '铁西区', '83', 't', 'txq', 'tiexiqu');
INSERT INTO `region_areas` VALUES ('513', '220303', '铁东区', '83', 't', 'tdq', 'tiedongqu');
INSERT INTO `region_areas` VALUES ('514', '220322', '梨树县', '83', 'l', 'lsx', 'lishuxian');
INSERT INTO `region_areas` VALUES ('515', '220323', '伊通满族自治县', '83', 'y', 'ytmzzzx', 'yitongmanzuzizhixian');
INSERT INTO `region_areas` VALUES ('516', '220381', '公主岭市', '83', 'g', 'gzls', 'gongzhulingshi');
INSERT INTO `region_areas` VALUES ('517', '220382', '双辽市', '83', 's', 'sls', 'shuangliaoshi');
INSERT INTO `region_areas` VALUES ('518', '220402', '龙山区', '84', 'l', 'lsq', 'longshanqu');
INSERT INTO `region_areas` VALUES ('519', '220403', '西安区', '84', 'x', 'xaq', 'xianqu');
INSERT INTO `region_areas` VALUES ('52', '130426', '涉县', '36', 's', 'sx', 'shexian');
INSERT INTO `region_areas` VALUES ('520', '220421', '东丰县', '84', 'd', 'dfx', 'dongfengxian');
INSERT INTO `region_areas` VALUES ('521', '220422', '东辽县', '84', 'd', 'dlx', 'dongliaoxian');
INSERT INTO `region_areas` VALUES ('522', '220502', '东昌区', '85', 'd', 'dcq', 'dongchangqu');
INSERT INTO `region_areas` VALUES ('523', '220503', '二道江区', '85', 'e', 'edjq', 'erdaojiangqu');
INSERT INTO `region_areas` VALUES ('524', '220521', '通化县', '85', 't', 'thx', 'tonghuaxian');
INSERT INTO `region_areas` VALUES ('525', '220523', '辉南县', '85', 'h', 'hnx', 'huinanxian');
INSERT INTO `region_areas` VALUES ('526', '220524', '柳河县', '85', 'l', 'lhx', 'liuhexian');
INSERT INTO `region_areas` VALUES ('527', '220581', '梅河口市', '85', 'm', 'mhks', 'meihekoushi');
INSERT INTO `region_areas` VALUES ('528', '220582', '集安市', '85', 'j', 'jas', 'jianshi');
INSERT INTO `region_areas` VALUES ('529', '220602', '浑江区', '86', 'h', 'hjq', 'hunjiangqu');
INSERT INTO `region_areas` VALUES ('53', '130427', '磁县', '36', 'c', 'cx', 'cixian');
INSERT INTO `region_areas` VALUES ('530', '220605', '江源区', '86', 'j', 'jyq', 'jiangyuanqu');
INSERT INTO `region_areas` VALUES ('531', '220621', '抚松县', '86', 'f', 'fsx', 'fusongxian');
INSERT INTO `region_areas` VALUES ('532', '220622', '靖宇县', '86', 'j', 'jyx', 'jingyuxian');
INSERT INTO `region_areas` VALUES ('533', '220623', '长白朝鲜族自治县', '86', 'z', 'zbcxzzzx', 'zhangbaichaoxianzuzizhixian');
INSERT INTO `region_areas` VALUES ('534', '220681', '临江市', '86', 'l', 'ljs', 'linjiangshi');
INSERT INTO `region_areas` VALUES ('535', '220702', '宁江区', '87', 'n', 'njq', 'ningjiangqu');
INSERT INTO `region_areas` VALUES ('536', '220721', '前郭尔罗斯蒙古族自治县', '87', 'q', 'qgelsmgzzzx', 'qianguoerluosimengguzuzizhixian');
INSERT INTO `region_areas` VALUES ('537', '220722', '长岭县', '87', 'z', 'zlx', 'zhanglingxian');
INSERT INTO `region_areas` VALUES ('538', '220723', '乾安县', '87', 'q', 'qax', 'qiananxian');
INSERT INTO `region_areas` VALUES ('539', '220781', '扶余市', '87', 'f', 'fys', 'fuyushi');
INSERT INTO `region_areas` VALUES ('54', '130428', '肥乡县', '36', 'f', 'fxx', 'feixiangxian');
INSERT INTO `region_areas` VALUES ('540', '220802', '洮北区', '88', 't', 'tbq', 'taobeiqu');
INSERT INTO `region_areas` VALUES ('541', '220821', '镇赉县', '88', 'z', 'zlx', 'zhenlaixian');
INSERT INTO `region_areas` VALUES ('542', '220822', '通榆县', '88', 't', 'tyx', 'tongyuxian');
INSERT INTO `region_areas` VALUES ('543', '220881', '洮南市', '88', 't', 'tns', 'taonanshi');
INSERT INTO `region_areas` VALUES ('544', '220882', '大安市', '88', 'd', 'das', 'daanshi');
INSERT INTO `region_areas` VALUES ('545', '222401', '延吉市', '89', 'y', 'yjs', 'yanjishi');
INSERT INTO `region_areas` VALUES ('546', '222402', '图们市', '89', 't', 'tms', 'tumenshi');
INSERT INTO `region_areas` VALUES ('547', '222403', '敦化市', '89', 'd', 'dhs', 'dunhuashi');
INSERT INTO `region_areas` VALUES ('548', '222404', '珲春市', '89', 'h', 'hcs', 'hunchunshi');
INSERT INTO `region_areas` VALUES ('549', '222405', '龙井市', '89', 'l', 'ljs', 'longjingshi');
INSERT INTO `region_areas` VALUES ('55', '130429', '永年县', '36', 'y', 'ynx', 'yongnianxian');
INSERT INTO `region_areas` VALUES ('550', '222406', '和龙市', '89', 'h', 'hls', 'helongshi');
INSERT INTO `region_areas` VALUES ('551', '222424', '汪清县', '89', 'w', 'wqx', 'wangqingxian');
INSERT INTO `region_areas` VALUES ('552', '222426', '安图县', '89', 'a', 'atx', 'antuxian');
INSERT INTO `region_areas` VALUES ('553', '230102', '道里区', '90', 'd', 'dlq', 'daoliqu');
INSERT INTO `region_areas` VALUES ('554', '230103', '南岗区', '90', 'n', 'ngq', 'nangangqu');
INSERT INTO `region_areas` VALUES ('555', '230104', '道外区', '90', 'd', 'dwq', 'daowaiqu');
INSERT INTO `region_areas` VALUES ('556', '230108', '平房区', '90', 'p', 'pfq', 'pingfangqu');
INSERT INTO `region_areas` VALUES ('557', '230109', '松北区', '90', 's', 'sbq', 'songbeiqu');
INSERT INTO `region_areas` VALUES ('558', '230110', '香坊区', '90', 'x', 'xfq', 'xiangfangqu');
INSERT INTO `region_areas` VALUES ('559', '230111', '呼兰区', '90', 'h', 'hlq', 'hulanqu');
INSERT INTO `region_areas` VALUES ('56', '130430', '邱县', '36', 'q', 'qx', 'qiuxian');
INSERT INTO `region_areas` VALUES ('560', '230112', '阿城区', '90', 'a', 'acq', 'achengqu');
INSERT INTO `region_areas` VALUES ('561', '230123', '依兰县', '90', 'y', 'ylx', 'yilanxian');
INSERT INTO `region_areas` VALUES ('562', '230124', '方正县', '90', 'f', 'fzx', 'fangzhengxian');
INSERT INTO `region_areas` VALUES ('563', '230125', '宾县', '90', 'b', 'bx', 'binxian');
INSERT INTO `region_areas` VALUES ('564', '230126', '巴彦县', '90', 'b', 'byx', 'bayanxian');
INSERT INTO `region_areas` VALUES ('565', '230127', '木兰县', '90', 'm', 'mlx', 'mulanxian');
INSERT INTO `region_areas` VALUES ('566', '230128', '通河县', '90', 't', 'thx', 'tonghexian');
INSERT INTO `region_areas` VALUES ('567', '230129', '延寿县', '90', 'y', 'ysx', 'yanshouxian');
INSERT INTO `region_areas` VALUES ('568', '230182', '双城市', '90', 's', 'scs', 'shuangchengshi');
INSERT INTO `region_areas` VALUES ('569', '230183', '尚志市', '90', 's', 'szs', 'shangzhishi');
INSERT INTO `region_areas` VALUES ('57', '130431', '鸡泽县', '36', 'j', 'jzx', 'jizexian');
INSERT INTO `region_areas` VALUES ('570', '230184', '五常市', '90', 'w', 'wcs', 'wuchangshi');
INSERT INTO `region_areas` VALUES ('571', '230202', '龙沙区', '91', 'l', 'lsq', 'longshaqu');
INSERT INTO `region_areas` VALUES ('572', '230203', '建华区', '91', 'j', 'jhq', 'jianhuaqu');
INSERT INTO `region_areas` VALUES ('573', '230204', '铁锋区', '91', 't', 'tfq', 'tiefengqu');
INSERT INTO `region_areas` VALUES ('574', '230205', '昂昂溪区', '91', 'a', 'aaxq', 'angangxiqu');
INSERT INTO `region_areas` VALUES ('575', '230206', '富拉尔基区', '91', 'f', 'flejq', 'fulaerjiqu');
INSERT INTO `region_areas` VALUES ('576', '230207', '碾子山区', '91', 'n', 'nzsq', 'nianzishanqu');
INSERT INTO `region_areas` VALUES ('577', '230208', '梅里斯达斡尔族区', '91', 'm', 'mlsdwezq', 'meilisidawoerzuqu');
INSERT INTO `region_areas` VALUES ('578', '230221', '龙江县', '91', 'l', 'ljx', 'longjiangxian');
INSERT INTO `region_areas` VALUES ('579', '230223', '依安县', '91', 'y', 'yax', 'yianxian');
INSERT INTO `region_areas` VALUES ('58', '130432', '广平县', '36', 'g', 'gpx', 'guangpingxian');
INSERT INTO `region_areas` VALUES ('580', '230224', '泰来县', '91', 't', 'tlx', 'tailaixian');
INSERT INTO `region_areas` VALUES ('581', '230225', '甘南县', '91', 'g', 'gnx', 'gannanxian');
INSERT INTO `region_areas` VALUES ('582', '230227', '富裕县', '91', 'f', 'fyx', 'fuyuxian');
INSERT INTO `region_areas` VALUES ('583', '230229', '克山县', '91', 'k', 'ksx', 'keshanxian');
INSERT INTO `region_areas` VALUES ('584', '230230', '克东县', '91', 'k', 'kdx', 'kedongxian');
INSERT INTO `region_areas` VALUES ('585', '230231', '拜泉县', '91', 'b', 'bqx', 'baiquanxian');
INSERT INTO `region_areas` VALUES ('586', '230281', '讷河市', '91', 'n', 'nhs', 'neheshi');
INSERT INTO `region_areas` VALUES ('587', '230302', '鸡冠区', '92', 'j', 'jgq', 'jiguanqu');
INSERT INTO `region_areas` VALUES ('588', '230303', '恒山区', '92', 'h', 'hsq', 'hengshanqu');
INSERT INTO `region_areas` VALUES ('589', '230304', '滴道区', '92', 'd', 'ddq', 'didaoqu');
INSERT INTO `region_areas` VALUES ('59', '130433', '馆陶县', '36', 'g', 'gtx', 'guantaoxian');
INSERT INTO `region_areas` VALUES ('590', '230305', '梨树区', '92', 'l', 'lsq', 'lishuqu');
INSERT INTO `region_areas` VALUES ('591', '230306', '城子河区', '92', 'c', 'czhq', 'chengzihequ');
INSERT INTO `region_areas` VALUES ('592', '230307', '麻山区', '92', 'm', 'msq', 'mashanqu');
INSERT INTO `region_areas` VALUES ('593', '230321', '鸡东县', '92', 'j', 'jdx', 'jidongxian');
INSERT INTO `region_areas` VALUES ('594', '230381', '虎林市', '92', 'h', 'hls', 'hulinshi');
INSERT INTO `region_areas` VALUES ('595', '230382', '密山市', '92', 'm', 'mss', 'mishanshi');
INSERT INTO `region_areas` VALUES ('596', '230402', '向阳区', '93', 'x', 'xyq', 'xiangyangqu');
INSERT INTO `region_areas` VALUES ('597', '230403', '工农区', '93', 'g', 'gnq', 'gongnongqu');
INSERT INTO `region_areas` VALUES ('598', '230404', '南山区', '93', 'n', 'nsq', 'nanshanqu');
INSERT INTO `region_areas` VALUES ('599', '230405', '兴安区', '93', 'x', 'xaq', 'xinganqu');
INSERT INTO `region_areas` VALUES ('6', '130109', '藁城区', '33', 'g', 'gcq', 'gaochengqu');
INSERT INTO `region_areas` VALUES ('60', '130434', '魏县', '36', 'w', 'wx', 'weixian');
INSERT INTO `region_areas` VALUES ('600', '230406', '东山区', '93', 'd', 'dsq', 'dongshanqu');
INSERT INTO `region_areas` VALUES ('601', '230407', '兴山区', '93', 'x', 'xsq', 'xingshanqu');
INSERT INTO `region_areas` VALUES ('602', '230421', '萝北县', '93', 'l', 'lbx', 'luobeixian');
INSERT INTO `region_areas` VALUES ('603', '230422', '绥滨县', '93', 's', 'sbx', 'suibinxian');
INSERT INTO `region_areas` VALUES ('604', '230502', '尖山区', '94', 'j', 'jsq', 'jianshanqu');
INSERT INTO `region_areas` VALUES ('605', '230503', '岭东区', '94', 'l', 'ldq', 'lingdongqu');
INSERT INTO `region_areas` VALUES ('606', '230505', '四方台区', '94', 's', 'sftq', 'sifangtaiqu');
INSERT INTO `region_areas` VALUES ('607', '230506', '宝山区', '94', 'b', 'bsq', 'baoshanqu');
INSERT INTO `region_areas` VALUES ('608', '230521', '集贤县', '94', 'j', 'jxx', 'jixianxian');
INSERT INTO `region_areas` VALUES ('609', '230522', '友谊县', '94', 'y', 'yyx', 'youyixian');
INSERT INTO `region_areas` VALUES ('61', '130435', '曲周县', '36', 'q', 'qzx', 'quzhouxian');
INSERT INTO `region_areas` VALUES ('610', '230523', '宝清县', '94', 'b', 'bqx', 'baoqingxian');
INSERT INTO `region_areas` VALUES ('611', '230524', '饶河县', '94', 'r', 'rhx', 'raohexian');
INSERT INTO `region_areas` VALUES ('612', '230602', '萨尔图区', '95', 's', 'setq', 'saertuqu');
INSERT INTO `region_areas` VALUES ('613', '230603', '龙凤区', '95', 'l', 'lfq', 'longfengqu');
INSERT INTO `region_areas` VALUES ('614', '230604', '让胡路区', '95', 'r', 'rhlq', 'ranghuluqu');
INSERT INTO `region_areas` VALUES ('615', '230605', '红岗区', '95', 'h', 'hgq', 'honggangqu');
INSERT INTO `region_areas` VALUES ('616', '230606', '大同区', '95', 'd', 'dtq', 'datongqu');
INSERT INTO `region_areas` VALUES ('617', '230621', '肇州县', '95', 'z', 'zzx', 'zhaozhouxian');
INSERT INTO `region_areas` VALUES ('618', '230622', '肇源县', '95', 'z', 'zyx', 'zhaoyuanxian');
INSERT INTO `region_areas` VALUES ('619', '230623', '林甸县', '95', 'l', 'ldx', 'lindianxian');
INSERT INTO `region_areas` VALUES ('62', '130481', '武安市', '36', 'w', 'was', 'wuanshi');
INSERT INTO `region_areas` VALUES ('620', '230624', '杜尔伯特蒙古族自治县', '95', 'd', 'debtmgzzzx', 'duerbotemengguzuzizhixian');
INSERT INTO `region_areas` VALUES ('621', '230702', '伊春区', '96', 'y', 'ycq', 'yichunqu');
INSERT INTO `region_areas` VALUES ('622', '230703', '南岔区', '96', 'n', 'ncq', 'nanchaqu');
INSERT INTO `region_areas` VALUES ('623', '230704', '友好区', '96', 'y', 'yhq', 'youhaoqu');
INSERT INTO `region_areas` VALUES ('624', '230705', '西林区', '96', 'x', 'xlq', 'xilinqu');
INSERT INTO `region_areas` VALUES ('625', '230706', '翠峦区', '96', 'c', 'clq', 'cuiluanqu');
INSERT INTO `region_areas` VALUES ('626', '230707', '新青区', '96', 'x', 'xqq', 'xinqingqu');
INSERT INTO `region_areas` VALUES ('627', '230708', '美溪区', '96', 'm', 'mxq', 'meixiqu');
INSERT INTO `region_areas` VALUES ('628', '230709', '金山屯区', '96', 'j', 'jstq', 'jinshantunqu');
INSERT INTO `region_areas` VALUES ('629', '230710', '五营区', '96', 'w', 'wyq', 'wuyingqu');
INSERT INTO `region_areas` VALUES ('63', '130502', '桥东区', '37', 'q', 'qdq', 'qiaodongqu');
INSERT INTO `region_areas` VALUES ('630', '230711', '乌马河区', '96', 'w', 'wmhq', 'wumahequ');
INSERT INTO `region_areas` VALUES ('631', '230712', '汤旺河区', '96', 't', 'twhq', 'tangwanghequ');
INSERT INTO `region_areas` VALUES ('632', '230713', '带岭区', '96', 'd', 'dlq', 'dailingqu');
INSERT INTO `region_areas` VALUES ('633', '230714', '乌伊岭区', '96', 'w', 'wylq', 'wuyilingqu');
INSERT INTO `region_areas` VALUES ('634', '230715', '红星区', '96', 'h', 'hxq', 'hongxingqu');
INSERT INTO `region_areas` VALUES ('635', '230716', '上甘岭区', '96', 's', 'sglq', 'shangganlingqu');
INSERT INTO `region_areas` VALUES ('636', '230722', '嘉荫县', '96', 'j', 'jyx', 'jiayinxian');
INSERT INTO `region_areas` VALUES ('637', '230781', '铁力市', '96', 't', 'tls', 'tielishi');
INSERT INTO `region_areas` VALUES ('638', '230803', '向阳区', '97', 'x', 'xyq', 'xiangyangqu');
INSERT INTO `region_areas` VALUES ('639', '230804', '前进区', '97', 'q', 'qjq', 'qianjinqu');
INSERT INTO `region_areas` VALUES ('64', '130503', '桥西区', '37', 'q', 'qxq', 'qiaoxiqu');
INSERT INTO `region_areas` VALUES ('640', '230805', '东风区', '97', 'd', 'dfq', 'dongfengqu');
INSERT INTO `region_areas` VALUES ('641', '230811', '郊区', '97', 'j', 'jq', 'jiaoqu');
INSERT INTO `region_areas` VALUES ('642', '230822', '桦南县', '97', 'h', 'hnx', 'huananxian');
INSERT INTO `region_areas` VALUES ('643', '230826', '桦川县', '97', 'h', 'hcx', 'huachuanxian');
INSERT INTO `region_areas` VALUES ('644', '230828', '汤原县', '97', 't', 'tyx', 'tangyuanxian');
INSERT INTO `region_areas` VALUES ('645', '230833', '抚远县', '97', 'f', 'fyx', 'fuyuanxian');
INSERT INTO `region_areas` VALUES ('646', '230881', '同江市', '97', 't', 'tjs', 'tongjiangshi');
INSERT INTO `region_areas` VALUES ('647', '230882', '富锦市', '97', 'f', 'fjs', 'fujinshi');
INSERT INTO `region_areas` VALUES ('648', '230902', '新兴区', '98', 'x', 'xxq', 'xinxingqu');
INSERT INTO `region_areas` VALUES ('649', '230903', '桃山区', '98', 't', 'tsq', 'taoshanqu');
INSERT INTO `region_areas` VALUES ('65', '130521', '邢台县', '37', 'x', 'xtx', 'xingtaixian');
INSERT INTO `region_areas` VALUES ('650', '230904', '茄子河区', '98', 'q', 'qzhq', 'qiezihequ');
INSERT INTO `region_areas` VALUES ('651', '230921', '勃利县', '98', 'b', 'blx', 'bolixian');
INSERT INTO `region_areas` VALUES ('652', '231002', '东安区', '99', 'd', 'daq', 'donganqu');
INSERT INTO `region_areas` VALUES ('653', '231003', '阳明区', '99', 'y', 'ymq', 'yangmingqu');
INSERT INTO `region_areas` VALUES ('654', '231004', '爱民区', '99', 'a', 'amq', 'aiminqu');
INSERT INTO `region_areas` VALUES ('655', '231005', '西安区', '99', 'x', 'xaq', 'xianqu');
INSERT INTO `region_areas` VALUES ('656', '231024', '东宁县', '99', 'd', 'dnx', 'dongningxian');
INSERT INTO `region_areas` VALUES ('657', '231025', '林口县', '99', 'l', 'lkx', 'linkouxian');
INSERT INTO `region_areas` VALUES ('658', '231081', '绥芬河市', '99', 's', 'sfhs', 'suifenheshi');
INSERT INTO `region_areas` VALUES ('659', '231083', '海林市', '99', 'h', 'hls', 'hailinshi');
INSERT INTO `region_areas` VALUES ('66', '130522', '临城县', '37', 'l', 'lcx', 'linchengxian');
INSERT INTO `region_areas` VALUES ('660', '231084', '宁安市', '99', 'n', 'nas', 'ninganshi');
INSERT INTO `region_areas` VALUES ('661', '231085', '穆棱市', '99', 'm', 'mls', 'mulengshi');
INSERT INTO `region_areas` VALUES ('662', '231102', '爱辉区', '100', 'a', 'ahq', 'aihuiqu');
INSERT INTO `region_areas` VALUES ('663', '231121', '嫩江县', '100', 'n', 'njx', 'nenjiangxian');
INSERT INTO `region_areas` VALUES ('664', '231123', '逊克县', '100', 'x', 'xkx', 'xunkexian');
INSERT INTO `region_areas` VALUES ('665', '231124', '孙吴县', '100', 's', 'swx', 'sunwuxian');
INSERT INTO `region_areas` VALUES ('666', '231181', '北安市', '100', 'b', 'bas', 'beianshi');
INSERT INTO `region_areas` VALUES ('667', '231182', '五大连池市', '100', 'w', 'wdlcs', 'wudalianchishi');
INSERT INTO `region_areas` VALUES ('668', '231202', '北林区', '101', 'b', 'blq', 'beilinqu');
INSERT INTO `region_areas` VALUES ('669', '231221', '望奎县', '101', 'w', 'wkx', 'wangkuixian');
INSERT INTO `region_areas` VALUES ('67', '130523', '内丘县', '37', 'n', 'nqx', 'neiqiuxian');
INSERT INTO `region_areas` VALUES ('670', '231222', '兰西县', '101', 'l', 'lxx', 'lanxixian');
INSERT INTO `region_areas` VALUES ('671', '231223', '青冈县', '101', 'q', 'qgx', 'qinggangxian');
INSERT INTO `region_areas` VALUES ('672', '231224', '庆安县', '101', 'q', 'qax', 'qinganxian');
INSERT INTO `region_areas` VALUES ('673', '231225', '明水县', '101', 'm', 'msx', 'mingshuixian');
INSERT INTO `region_areas` VALUES ('674', '231226', '绥棱县', '101', 's', 'slx', 'suilengxian');
INSERT INTO `region_areas` VALUES ('675', '231281', '安达市', '101', 'a', 'ads', 'andashi');
INSERT INTO `region_areas` VALUES ('676', '231282', '肇东市', '101', 'z', 'zds', 'zhaodongshi');
INSERT INTO `region_areas` VALUES ('677', '231283', '海伦市', '101', 'h', 'hls', 'hailunshi');
INSERT INTO `region_areas` VALUES ('678', '232721', '呼玛县', '102', 'h', 'hmx', 'humaxian');
INSERT INTO `region_areas` VALUES ('679', '232722', '塔河县', '102', 't', 'thx', 'tahexian');
INSERT INTO `region_areas` VALUES ('68', '130524', '柏乡县', '37', 'b', 'bxx', 'boxiangxian');
INSERT INTO `region_areas` VALUES ('680', '232723', '漠河县', '102', 'm', 'mhx', 'mohexian');
INSERT INTO `region_areas` VALUES ('681', '320102', '玄武区', '120', 'x', 'xwq', 'xuanwuqu');
INSERT INTO `region_areas` VALUES ('682', '320104', '秦淮区', '120', 'q', 'qhq', 'qinhuaiqu');
INSERT INTO `region_areas` VALUES ('683', '320105', '建邺区', '120', 'j', 'jyq', 'jianyequ');
INSERT INTO `region_areas` VALUES ('684', '320106', '鼓楼区', '120', 'g', 'glq', 'gulouqu');
INSERT INTO `region_areas` VALUES ('685', '320111', '浦口区', '120', 'p', 'pkq', 'pukouqu');
INSERT INTO `region_areas` VALUES ('686', '320113', '栖霞区', '120', 'q', 'qxq', 'qixiaqu');
INSERT INTO `region_areas` VALUES ('687', '320114', '雨花台区', '120', 'y', 'yhtq', 'yuhuataiqu');
INSERT INTO `region_areas` VALUES ('688', '320115', '江宁区', '120', 'j', 'jnq', 'jiangningqu');
INSERT INTO `region_areas` VALUES ('689', '320116', '六合区', '120', 'l', 'lhq', 'liuhequ');
INSERT INTO `region_areas` VALUES ('69', '130525', '隆尧县', '37', 'l', 'lyx', 'longyaoxian');
INSERT INTO `region_areas` VALUES ('690', '320117', '溧水区', '120', 'l', 'lsq', 'lishuiqu');
INSERT INTO `region_areas` VALUES ('691', '320118', '高淳区', '120', 'g', 'gcq', 'gaochunqu');
INSERT INTO `region_areas` VALUES ('692', '320202', '崇安区', '121', 'c', 'caq', 'chonganqu');
INSERT INTO `region_areas` VALUES ('693', '320203', '南长区', '121', 'n', 'nzq', 'nanzhangqu');
INSERT INTO `region_areas` VALUES ('694', '320204', '北塘区', '121', 'b', 'btq', 'beitangqu');
INSERT INTO `region_areas` VALUES ('695', '320205', '锡山区', '121', 'x', 'xsq', 'xishanqu');
INSERT INTO `region_areas` VALUES ('696', '320206', '惠山区', '121', 'h', 'hsq', 'huishanqu');
INSERT INTO `region_areas` VALUES ('697', '320211', '滨湖区', '121', 'b', 'bhq', 'binhuqu');
INSERT INTO `region_areas` VALUES ('698', '320281', '江阴市', '121', 'j', 'jys', 'jiangyinshi');
INSERT INTO `region_areas` VALUES ('699', '320282', '宜兴市', '121', 'y', 'yxs', 'yixingshi');
INSERT INTO `region_areas` VALUES ('7', '130110', '鹿泉区', '33', 'l', 'lqq', 'luquanqu');
INSERT INTO `region_areas` VALUES ('70', '130526', '任县', '37', 'r', 'rx', 'renxian');
INSERT INTO `region_areas` VALUES ('700', '320302', '鼓楼区', '122', 'g', 'glq', 'gulouqu');
INSERT INTO `region_areas` VALUES ('701', '320303', '云龙区', '122', 'y', 'ylq', 'yunlongqu');
INSERT INTO `region_areas` VALUES ('702', '320305', '贾汪区', '122', 'j', 'jwq', 'jiawangqu');
INSERT INTO `region_areas` VALUES ('703', '320311', '泉山区', '122', 'q', 'qsq', 'quanshanqu');
INSERT INTO `region_areas` VALUES ('704', '320312', '铜山区', '122', 't', 'tsq', 'tongshanqu');
INSERT INTO `region_areas` VALUES ('705', '320321', '丰县', '122', 'f', 'fx', 'fengxian');
INSERT INTO `region_areas` VALUES ('706', '320322', '沛县', '122', 'p', 'px', 'peixian');
INSERT INTO `region_areas` VALUES ('707', '320324', '睢宁县', '122', 's', 'snx', 'suiningxian');
INSERT INTO `region_areas` VALUES ('708', '320381', '新沂市', '122', 'x', 'xys', 'xinyishi');
INSERT INTO `region_areas` VALUES ('709', '320382', '邳州市', '122', 'p', 'pzs', 'pizhoushi');
INSERT INTO `region_areas` VALUES ('71', '130527', '南和县', '37', 'n', 'nhx', 'nanhexian');
INSERT INTO `region_areas` VALUES ('710', '320402', '天宁区', '123', 't', 'tnq', 'tianningqu');
INSERT INTO `region_areas` VALUES ('711', '320404', '钟楼区', '123', 'z', 'zlq', 'zhonglouqu');
INSERT INTO `region_areas` VALUES ('712', '320405', '戚墅堰区', '123', 'q', 'qsyq', 'qishuyanqu');
INSERT INTO `region_areas` VALUES ('713', '320411', '新北区', '123', 'x', 'xbq', 'xinbeiqu');
INSERT INTO `region_areas` VALUES ('714', '320412', '武进区', '123', 'w', 'wjq', 'wujinqu');
INSERT INTO `region_areas` VALUES ('715', '320481', '溧阳市', '123', 'l', 'lys', 'liyangshi');
INSERT INTO `region_areas` VALUES ('716', '320482', '金坛市', '123', 'j', 'jts', 'jintanshi');
INSERT INTO `region_areas` VALUES ('717', '320505', '虎丘区', '124', 'h', 'hqq', 'huqiuqu');
INSERT INTO `region_areas` VALUES ('718', '320506', '吴中区', '124', 'w', 'wzq', 'wuzhongqu');
INSERT INTO `region_areas` VALUES ('719', '320507', '相城区', '124', 'x', 'xcq', 'xiangchengqu');
INSERT INTO `region_areas` VALUES ('72', '130528', '宁晋县', '37', 'n', 'njx', 'ningjinxian');
INSERT INTO `region_areas` VALUES ('720', '320508', '姑苏区', '124', 'g', 'gsq', 'gusuqu');
INSERT INTO `region_areas` VALUES ('721', '320509', '吴江区', '124', 'w', 'wjq', 'wujiangqu');
INSERT INTO `region_areas` VALUES ('722', '320581', '常熟市', '124', 'c', 'css', 'changshushi');
INSERT INTO `region_areas` VALUES ('723', '320582', '张家港市', '124', 'z', 'zjgs', 'zhangjiagangshi');
INSERT INTO `region_areas` VALUES ('724', '320583', '昆山市', '124', 'k', 'kss', 'kunshanshi');
INSERT INTO `region_areas` VALUES ('725', '320585', '太仓市', '124', 't', 'tcs', 'taicangshi');
INSERT INTO `region_areas` VALUES ('726', '320602', '崇川区', '125', 'c', 'ccq', 'chongchuanqu');
INSERT INTO `region_areas` VALUES ('727', '320611', '港闸区', '125', 'g', 'gzq', 'gangzhaqu');
INSERT INTO `region_areas` VALUES ('728', '320612', '通州区', '125', 't', 'tzq', 'tongzhouqu');
INSERT INTO `region_areas` VALUES ('729', '320621', '海安县', '125', 'h', 'hax', 'haianxian');
INSERT INTO `region_areas` VALUES ('73', '130529', '巨鹿县', '37', 'j', 'jlx', 'juluxian');
INSERT INTO `region_areas` VALUES ('730', '320623', '如东县', '125', 'r', 'rdx', 'rudongxian');
INSERT INTO `region_areas` VALUES ('731', '320681', '启东市', '125', 'q', 'qds', 'qidongshi');
INSERT INTO `region_areas` VALUES ('732', '320682', '如皋市', '125', 'r', 'rgs', 'rugaoshi');
INSERT INTO `region_areas` VALUES ('733', '320684', '海门市', '125', 'h', 'hms', 'haimenshi');
INSERT INTO `region_areas` VALUES ('734', '320703', '连云区', '126', 'l', 'lyq', 'lianyunqu');
INSERT INTO `region_areas` VALUES ('735', '320706', '海州区', '126', 'h', 'hzq', 'haizhouqu');
INSERT INTO `region_areas` VALUES ('736', '320707', '赣榆区', '126', 'g', 'gyq', 'ganyuqu');
INSERT INTO `region_areas` VALUES ('737', '320722', '东海县', '126', 'd', 'dhx', 'donghaixian');
INSERT INTO `region_areas` VALUES ('738', '320723', '灌云县', '126', 'g', 'gyx', 'guanyunxian');
INSERT INTO `region_areas` VALUES ('739', '320724', '灌南县', '126', 'g', 'gnx', 'guannanxian');
INSERT INTO `region_areas` VALUES ('74', '130530', '新河县', '37', 'x', 'xhx', 'xinhexian');
INSERT INTO `region_areas` VALUES ('740', '320802', '清河区', '127', 'q', 'qhq', 'qinghequ');
INSERT INTO `region_areas` VALUES ('741', '320803', '淮安区', '127', 'h', 'haq', 'huaianqu');
INSERT INTO `region_areas` VALUES ('742', '320804', '淮阴区', '127', 'h', 'hyq', 'huaiyinqu');
INSERT INTO `region_areas` VALUES ('743', '320811', '清浦区', '127', 'q', 'qpq', 'qingpuqu');
INSERT INTO `region_areas` VALUES ('744', '320826', '涟水县', '127', 'l', 'lsx', 'lianshuixian');
INSERT INTO `region_areas` VALUES ('745', '320829', '洪泽县', '127', 'h', 'hzx', 'hongzexian');
INSERT INTO `region_areas` VALUES ('746', '320830', '盱眙县', '127', 'x', 'xyx', 'xuyixian');
INSERT INTO `region_areas` VALUES ('747', '320831', '金湖县', '127', 'j', 'jhx', 'jinhuxian');
INSERT INTO `region_areas` VALUES ('748', '320902', '亭湖区', '128', 't', 'thq', 'tinghuqu');
INSERT INTO `region_areas` VALUES ('749', '320903', '盐都区', '128', 'y', 'ydq', 'yandouqu');
INSERT INTO `region_areas` VALUES ('75', '130531', '广宗县', '37', 'g', 'gzx', 'guangzongxian');
INSERT INTO `region_areas` VALUES ('750', '320921', '响水县', '128', 'x', 'xsx', 'xiangshuixian');
INSERT INTO `region_areas` VALUES ('751', '320922', '滨海县', '128', 'b', 'bhx', 'binhaixian');
INSERT INTO `region_areas` VALUES ('752', '320923', '阜宁县', '128', 'f', 'fnx', 'funingxian');
INSERT INTO `region_areas` VALUES ('753', '320924', '射阳县', '128', 's', 'syx', 'sheyangxian');
INSERT INTO `region_areas` VALUES ('754', '320925', '建湖县', '128', 'j', 'jhx', 'jianhuxian');
INSERT INTO `region_areas` VALUES ('755', '320981', '东台市', '128', 'd', 'dts', 'dongtaishi');
INSERT INTO `region_areas` VALUES ('756', '320982', '大丰市', '128', 'd', 'dfs', 'dafengshi');
INSERT INTO `region_areas` VALUES ('757', '321002', '广陵区', '129', 'g', 'glq', 'guanglingqu');
INSERT INTO `region_areas` VALUES ('758', '321003', '邗江区', '129', 'h', 'hjq', 'hanjiangqu');
INSERT INTO `region_areas` VALUES ('759', '321012', '江都区', '129', 'j', 'jdq', 'jiangdouqu');
INSERT INTO `region_areas` VALUES ('76', '130532', '平乡县', '37', 'p', 'pxx', 'pingxiangxian');
INSERT INTO `region_areas` VALUES ('760', '321023', '宝应县', '129', 'b', 'byx', 'baoyingxian');
INSERT INTO `region_areas` VALUES ('761', '321081', '仪征市', '129', 'y', 'yzs', 'yizhengshi');
INSERT INTO `region_areas` VALUES ('762', '321084', '高邮市', '129', 'g', 'gys', 'gaoyoushi');
INSERT INTO `region_areas` VALUES ('763', '321102', '京口区', '130', 'j', 'jkq', 'jingkouqu');
INSERT INTO `region_areas` VALUES ('764', '321111', '润州区', '130', 'r', 'rzq', 'runzhouqu');
INSERT INTO `region_areas` VALUES ('765', '321112', '丹徒区', '130', 'd', 'dtq', 'dantuqu');
INSERT INTO `region_areas` VALUES ('766', '321181', '丹阳市', '130', 'd', 'dys', 'danyangshi');
INSERT INTO `region_areas` VALUES ('767', '321182', '扬中市', '130', 'y', 'yzs', 'yangzhongshi');
INSERT INTO `region_areas` VALUES ('768', '321183', '句容市', '130', 'j', 'jrs', 'jurongshi');
INSERT INTO `region_areas` VALUES ('769', '321202', '海陵区', '131', 'h', 'hlq', 'hailingqu');
INSERT INTO `region_areas` VALUES ('77', '130533', '威县', '37', 'w', 'wx', 'weixian');
INSERT INTO `region_areas` VALUES ('770', '321203', '高港区', '131', 'g', 'ggq', 'gaogangqu');
INSERT INTO `region_areas` VALUES ('771', '321204', '姜堰区', '131', 'j', 'jyq', 'jiangyanqu');
INSERT INTO `region_areas` VALUES ('772', '321281', '兴化市', '131', 'x', 'xhs', 'xinghuashi');
INSERT INTO `region_areas` VALUES ('773', '321282', '靖江市', '131', 'j', 'jjs', 'jingjiangshi');
INSERT INTO `region_areas` VALUES ('774', '321283', '泰兴市', '131', 't', 'txs', 'taixingshi');
INSERT INTO `region_areas` VALUES ('775', '321302', '宿城区', '132', 's', 'scq', 'suchengqu');
INSERT INTO `region_areas` VALUES ('776', '321311', '宿豫区', '132', 's', 'syq', 'suyuqu');
INSERT INTO `region_areas` VALUES ('777', '321322', '沭阳县', '132', 's', 'syx', 'shuyangxian');
INSERT INTO `region_areas` VALUES ('778', '321323', '泗阳县', '132', 's', 'syx', 'siyangxian');
INSERT INTO `region_areas` VALUES ('779', '321324', '泗洪县', '132', 's', 'shx', 'sihongxian');
INSERT INTO `region_areas` VALUES ('78', '130534', '清河县', '37', 'q', 'qhx', 'qinghexian');
INSERT INTO `region_areas` VALUES ('780', '330102', '上城区', '133', 's', 'scq', 'shangchengqu');
INSERT INTO `region_areas` VALUES ('781', '330103', '下城区', '133', 'x', 'xcq', 'xiachengqu');
INSERT INTO `region_areas` VALUES ('782', '330104', '江干区', '133', 'j', 'jgq', 'jiangganqu');
INSERT INTO `region_areas` VALUES ('783', '330105', '拱墅区', '133', 'g', 'gsq', 'gongshuqu');
INSERT INTO `region_areas` VALUES ('784', '330106', '西湖区', '133', 'x', 'xhq', 'xihuqu');
INSERT INTO `region_areas` VALUES ('785', '330108', '滨江区', '133', 'b', 'bjq', 'binjiangqu');
INSERT INTO `region_areas` VALUES ('786', '330109', '萧山区', '133', 'x', 'xsq', 'xiaoshanqu');
INSERT INTO `region_areas` VALUES ('787', '330110', '余杭区', '133', 'y', 'yhq', 'yuhangqu');
INSERT INTO `region_areas` VALUES ('788', '330122', '桐庐县', '133', 't', 'tlx', 'tongluxian');
INSERT INTO `region_areas` VALUES ('789', '330127', '淳安县', '133', 'c', 'cax', 'chunanxian');
INSERT INTO `region_areas` VALUES ('79', '130535', '临西县', '37', 'l', 'lxx', 'linxixian');
INSERT INTO `region_areas` VALUES ('790', '330182', '建德市', '133', 'j', 'jds', 'jiandeshi');
INSERT INTO `region_areas` VALUES ('791', '330183', '富阳市', '133', 'f', 'fys', 'fuyangshi');
INSERT INTO `region_areas` VALUES ('792', '330185', '临安市', '133', 'l', 'las', 'linanshi');
INSERT INTO `region_areas` VALUES ('793', '330203', '海曙区', '134', 'h', 'hsq', 'haishuqu');
INSERT INTO `region_areas` VALUES ('794', '330204', '江东区', '134', 'j', 'jdq', 'jiangdongqu');
INSERT INTO `region_areas` VALUES ('795', '330205', '江北区', '134', 'j', 'jbq', 'jiangbeiqu');
INSERT INTO `region_areas` VALUES ('796', '330206', '北仑区', '134', 'b', 'blq', 'beilunqu');
INSERT INTO `region_areas` VALUES ('797', '330211', '镇海区', '134', 'z', 'zhq', 'zhenhaiqu');
INSERT INTO `region_areas` VALUES ('798', '330212', '鄞州区', '134', 'y', 'yzq', 'yinzhouqu');
INSERT INTO `region_areas` VALUES ('799', '330225', '象山县', '134', 'x', 'xsx', 'xiangshanxian');
INSERT INTO `region_areas` VALUES ('8', '130111', '栾城区', '33', 'l', 'lcq', 'luanchengqu');
INSERT INTO `region_areas` VALUES ('80', '130581', '南宫市', '37', 'n', 'ngs', 'nangongshi');
INSERT INTO `region_areas` VALUES ('800', '330226', '宁海县', '134', 'n', 'nhx', 'ninghaixian');
INSERT INTO `region_areas` VALUES ('801', '330281', '余姚市', '134', 'y', 'yys', 'yuyaoshi');
INSERT INTO `region_areas` VALUES ('802', '330282', '慈溪市', '134', 'c', 'cxs', 'cixishi');
INSERT INTO `region_areas` VALUES ('803', '330283', '奉化市', '134', 'f', 'fhs', 'fenghuashi');
INSERT INTO `region_areas` VALUES ('804', '330302', '鹿城区', '135', 'l', 'lcq', 'luchengqu');
INSERT INTO `region_areas` VALUES ('805', '330303', '龙湾区', '135', 'l', 'lwq', 'longwanqu');
INSERT INTO `region_areas` VALUES ('806', '330304', '瓯海区', '135', 'o', 'ohq', 'ouhaiqu');
INSERT INTO `region_areas` VALUES ('807', '330322', '洞头县', '135', 'd', 'dtx', 'dongtouxian');
INSERT INTO `region_areas` VALUES ('808', '330324', '永嘉县', '135', 'y', 'yjx', 'yongjiaxian');
INSERT INTO `region_areas` VALUES ('809', '330326', '平阳县', '135', 'p', 'pyx', 'pingyangxian');
INSERT INTO `region_areas` VALUES ('81', '130582', '沙河市', '37', 's', 'shs', 'shaheshi');
INSERT INTO `region_areas` VALUES ('810', '330327', '苍南县', '135', 'c', 'cnx', 'cangnanxian');
INSERT INTO `region_areas` VALUES ('811', '330328', '文成县', '135', 'w', 'wcx', 'wenchengxian');
INSERT INTO `region_areas` VALUES ('812', '330329', '泰顺县', '135', 't', 'tsx', 'taishunxian');
INSERT INTO `region_areas` VALUES ('813', '330381', '瑞安市', '135', 'r', 'ras', 'ruianshi');
INSERT INTO `region_areas` VALUES ('814', '330382', '乐清市', '135', 'l', 'lqs', 'leqingshi');
INSERT INTO `region_areas` VALUES ('815', '330402', '南湖区', '136', 'n', 'nhq', 'nanhuqu');
INSERT INTO `region_areas` VALUES ('816', '330411', '秀洲区', '136', 'x', 'xzq', 'xiuzhouqu');
INSERT INTO `region_areas` VALUES ('817', '330421', '嘉善县', '136', 'j', 'jsx', 'jiashanxian');
INSERT INTO `region_areas` VALUES ('818', '330424', '海盐县', '136', 'h', 'hyx', 'haiyanxian');
INSERT INTO `region_areas` VALUES ('819', '330481', '海宁市', '136', 'h', 'hns', 'hainingshi');
INSERT INTO `region_areas` VALUES ('82', '130602', '新市区', '38', 'x', 'xsq', 'xinshiqu');
INSERT INTO `region_areas` VALUES ('820', '330482', '平湖市', '136', 'p', 'phs', 'pinghushi');
INSERT INTO `region_areas` VALUES ('821', '330483', '桐乡市', '136', 't', 'txs', 'tongxiangshi');
INSERT INTO `region_areas` VALUES ('822', '330502', '吴兴区', '137', 'w', 'wxq', 'wuxingqu');
INSERT INTO `region_areas` VALUES ('823', '330503', '南浔区', '137', 'n', 'nxq', 'nanxunqu');
INSERT INTO `region_areas` VALUES ('824', '330521', '德清县', '137', 'd', 'dqx', 'deqingxian');
INSERT INTO `region_areas` VALUES ('825', '330522', '长兴县', '137', 'z', 'zxx', 'zhangxingxian');
INSERT INTO `region_areas` VALUES ('826', '330523', '安吉县', '137', 'a', 'ajx', 'anjixian');
INSERT INTO `region_areas` VALUES ('827', '330602', '越城区', '138', 'y', 'ycq', 'yuechengqu');
INSERT INTO `region_areas` VALUES ('828', '330603', '柯桥区', '138', 'k', 'kqq', 'keqiaoqu');
INSERT INTO `region_areas` VALUES ('829', '330604', '上虞区', '138', 's', 'syq', 'shangyuqu');
INSERT INTO `region_areas` VALUES ('83', '130603', '北市区', '38', 'b', 'bsq', 'beishiqu');
INSERT INTO `region_areas` VALUES ('830', '330624', '新昌县', '138', 'x', 'xcx', 'xinchangxian');
INSERT INTO `region_areas` VALUES ('831', '330681', '诸暨市', '138', 'z', 'zjs', 'zhujishi');
INSERT INTO `region_areas` VALUES ('832', '330683', '嵊州市', '138', 's', 'szs', 'shengzhoushi');
INSERT INTO `region_areas` VALUES ('833', '330702', '婺城区', '139', 'w', 'wcq', 'wuchengqu');
INSERT INTO `region_areas` VALUES ('834', '330703', '金东区', '139', 'j', 'jdq', 'jindongqu');
INSERT INTO `region_areas` VALUES ('835', '330723', '武义县', '139', 'w', 'wyx', 'wuyixian');
INSERT INTO `region_areas` VALUES ('836', '330726', '浦江县', '139', 'p', 'pjx', 'pujiangxian');
INSERT INTO `region_areas` VALUES ('837', '330727', '磐安县', '139', 'p', 'pax', 'pananxian');
INSERT INTO `region_areas` VALUES ('838', '330781', '兰溪市', '139', 'l', 'lxs', 'lanxishi');
INSERT INTO `region_areas` VALUES ('839', '330782', '义乌市', '139', 'y', 'yws', 'yiwushi');
INSERT INTO `region_areas` VALUES ('84', '130604', '南市区', '38', 'n', 'nsq', 'nanshiqu');
INSERT INTO `region_areas` VALUES ('840', '330783', '东阳市', '139', 'd', 'dys', 'dongyangshi');
INSERT INTO `region_areas` VALUES ('841', '330784', '永康市', '139', 'y', 'yks', 'yongkangshi');
INSERT INTO `region_areas` VALUES ('842', '330802', '柯城区', '140', 'k', 'kcq', 'kechengqu');
INSERT INTO `region_areas` VALUES ('843', '330803', '衢江区', '140', 'q', 'qjq', 'qujiangqu');
INSERT INTO `region_areas` VALUES ('844', '330822', '常山县', '140', 'c', 'csx', 'changshanxian');
INSERT INTO `region_areas` VALUES ('845', '330824', '开化县', '140', 'k', 'khx', 'kaihuaxian');
INSERT INTO `region_areas` VALUES ('846', '330825', '龙游县', '140', 'l', 'lyx', 'longyouxian');
INSERT INTO `region_areas` VALUES ('847', '330881', '江山市', '140', 'j', 'jss', 'jiangshanshi');
INSERT INTO `region_areas` VALUES ('848', '330902', '定海区', '141', 'd', 'dhq', 'dinghaiqu');
INSERT INTO `region_areas` VALUES ('849', '330903', '普陀区', '141', 'p', 'ptq', 'putuoqu');
INSERT INTO `region_areas` VALUES ('85', '130621', '满城县', '38', 'm', 'mcx', 'manchengxian');
INSERT INTO `region_areas` VALUES ('850', '330921', '岱山县', '141', 'd', 'dsx', 'daishanxian');
INSERT INTO `region_areas` VALUES ('851', '330922', '嵊泗县', '141', 's', 'ssx', 'shengsixian');
INSERT INTO `region_areas` VALUES ('852', '331002', '椒江区', '142', 'j', 'jjq', 'jiaojiangqu');
INSERT INTO `region_areas` VALUES ('853', '331003', '黄岩区', '142', 'h', 'hyq', 'huangyanqu');
INSERT INTO `region_areas` VALUES ('854', '331004', '路桥区', '142', 'l', 'lqq', 'luqiaoqu');
INSERT INTO `region_areas` VALUES ('855', '331021', '玉环县', '142', 'y', 'yhx', 'yuhuanxian');
INSERT INTO `region_areas` VALUES ('856', '331022', '三门县', '142', 's', 'smx', 'sanmenxian');
INSERT INTO `region_areas` VALUES ('857', '331023', '天台县', '142', 't', 'ttx', 'tiantaixian');
INSERT INTO `region_areas` VALUES ('858', '331024', '仙居县', '142', 'x', 'xjx', 'xianjuxian');
INSERT INTO `region_areas` VALUES ('859', '331081', '温岭市', '142', 'w', 'wls', 'wenlingshi');
INSERT INTO `region_areas` VALUES ('86', '130622', '清苑县', '38', 'q', 'qyx', 'qingyuanxian');
INSERT INTO `region_areas` VALUES ('860', '331082', '临海市', '142', 'l', 'lhs', 'linhaishi');
INSERT INTO `region_areas` VALUES ('861', '331102', '莲都区', '143', 'l', 'ldq', 'liandouqu');
INSERT INTO `region_areas` VALUES ('862', '331121', '青田县', '143', 'q', 'qtx', 'qingtianxian');
INSERT INTO `region_areas` VALUES ('863', '331122', '缙云县', '143', 'j', 'jyx', 'jinyunxian');
INSERT INTO `region_areas` VALUES ('864', '331123', '遂昌县', '143', 's', 'scx', 'suichangxian');
INSERT INTO `region_areas` VALUES ('865', '331124', '松阳县', '143', 's', 'syx', 'songyangxian');
INSERT INTO `region_areas` VALUES ('866', '331125', '云和县', '143', 'y', 'yhx', 'yunhexian');
INSERT INTO `region_areas` VALUES ('867', '331126', '庆元县', '143', 'q', 'qyx', 'qingyuanxian');
INSERT INTO `region_areas` VALUES ('868', '331127', '景宁畲族自治县', '143', 'j', 'jnszzzx', 'jingningshezuzizhixian');
INSERT INTO `region_areas` VALUES ('869', '331181', '龙泉市', '143', 'l', 'lqs', 'longquanshi');
INSERT INTO `region_areas` VALUES ('87', '130623', '涞水县', '38', 'l', 'lsx', 'laishuixian');
INSERT INTO `region_areas` VALUES ('870', '340102', '瑶海区', '144', 'y', 'yhq', 'yaohaiqu');
INSERT INTO `region_areas` VALUES ('871', '340103', '庐阳区', '144', 'l', 'lyq', 'luyangqu');
INSERT INTO `region_areas` VALUES ('872', '340104', '蜀山区', '144', 's', 'ssq', 'shushanqu');
INSERT INTO `region_areas` VALUES ('873', '340111', '包河区', '144', 'b', 'bhq', 'baohequ');
INSERT INTO `region_areas` VALUES ('874', '340121', '长丰县', '144', 'z', 'zfx', 'zhangfengxian');
INSERT INTO `region_areas` VALUES ('875', '340122', '肥东县', '144', 'f', 'fdx', 'feidongxian');
INSERT INTO `region_areas` VALUES ('876', '340123', '肥西县', '144', 'f', 'fxx', 'feixixian');
INSERT INTO `region_areas` VALUES ('877', '340124', '庐江县', '144', 'l', 'ljx', 'lujiangxian');
INSERT INTO `region_areas` VALUES ('878', '340181', '巢湖市', '144', 'c', 'chs', 'chaohushi');
INSERT INTO `region_areas` VALUES ('879', '340202', '镜湖区', '145', 'j', 'jhq', 'jinghuqu');
INSERT INTO `region_areas` VALUES ('88', '130624', '阜平县', '38', 'f', 'fpx', 'fupingxian');
INSERT INTO `region_areas` VALUES ('880', '340203', '弋江区', '145', 'y', 'yjq', 'yijiangqu');
INSERT INTO `region_areas` VALUES ('881', '340207', '鸠江区', '145', 'j', 'jjq', 'jiujiangqu');
INSERT INTO `region_areas` VALUES ('882', '340208', '三山区', '145', 's', 'ssq', 'sanshanqu');
INSERT INTO `region_areas` VALUES ('883', '340221', '芜湖县', '145', 'w', 'whx', 'wuhuxian');
INSERT INTO `region_areas` VALUES ('884', '340222', '繁昌县', '145', 'f', 'fcx', 'fanchangxian');
INSERT INTO `region_areas` VALUES ('885', '340223', '南陵县', '145', 'n', 'nlx', 'nanlingxian');
INSERT INTO `region_areas` VALUES ('886', '340225', '无为县', '145', 'w', 'wwx', 'wuweixian');
INSERT INTO `region_areas` VALUES ('887', '340302', '龙子湖区', '146', 'l', 'lzhq', 'longzihuqu');
INSERT INTO `region_areas` VALUES ('888', '340303', '蚌山区', '146', 'b', 'bsq', 'bangshanqu');
INSERT INTO `region_areas` VALUES ('889', '340304', '禹会区', '146', 'y', 'yhq', 'yuhuiqu');
INSERT INTO `region_areas` VALUES ('89', '130625', '徐水县', '38', 'x', 'xsx', 'xushuixian');
INSERT INTO `region_areas` VALUES ('890', '340311', '淮上区', '146', 'h', 'hsq', 'huaishangqu');
INSERT INTO `region_areas` VALUES ('891', '340321', '怀远县', '146', 'h', 'hyx', 'huaiyuanxian');
INSERT INTO `region_areas` VALUES ('892', '340322', '五河县', '146', 'w', 'whx', 'wuhexian');
INSERT INTO `region_areas` VALUES ('893', '340323', '固镇县', '146', 'g', 'gzx', 'guzhenxian');
INSERT INTO `region_areas` VALUES ('894', '340402', '大通区', '147', 'd', 'dtq', 'datongqu');
INSERT INTO `region_areas` VALUES ('895', '340403', '田家庵区', '147', 't', 'tjaq', 'tianjiaanqu');
INSERT INTO `region_areas` VALUES ('896', '340404', '谢家集区', '147', 'x', 'xjjq', 'xiejiajiqu');
INSERT INTO `region_areas` VALUES ('897', '340405', '八公山区', '147', 'b', 'bgsq', 'bagongshanqu');
INSERT INTO `region_areas` VALUES ('898', '340406', '潘集区', '147', 'p', 'pjq', 'panjiqu');
INSERT INTO `region_areas` VALUES ('899', '340421', '凤台县', '147', 'f', 'ftx', 'fengtaixian');
INSERT INTO `region_areas` VALUES ('9', '130121', '井陉县', '33', 'j', 'jxx', 'jingxingxian');
INSERT INTO `region_areas` VALUES ('90', '130626', '定兴县', '38', 'd', 'dxx', 'dingxingxian');
INSERT INTO `region_areas` VALUES ('900', '340503', '花山区', '148', 'h', 'hsq', 'huashanqu');
INSERT INTO `region_areas` VALUES ('901', '340504', '雨山区', '148', 'y', 'ysq', 'yushanqu');
INSERT INTO `region_areas` VALUES ('902', '340506', '博望区', '148', 'b', 'bwq', 'bowangqu');
INSERT INTO `region_areas` VALUES ('903', '340521', '当涂县', '148', 'd', 'dtx', 'dangtuxian');
INSERT INTO `region_areas` VALUES ('904', '340522', '含山县', '148', 'h', 'hsx', 'hanshanxian');
INSERT INTO `region_areas` VALUES ('905', '340523', '和县', '148', 'h', 'hx', 'hexian');
INSERT INTO `region_areas` VALUES ('906', '340602', '杜集区', '149', 'd', 'djq', 'dujiqu');
INSERT INTO `region_areas` VALUES ('907', '340603', '相山区', '149', 'x', 'xsq', 'xiangshanqu');
INSERT INTO `region_areas` VALUES ('908', '340604', '烈山区', '149', 'l', 'lsq', 'lieshanqu');
INSERT INTO `region_areas` VALUES ('909', '340621', '濉溪县', '149', 's', 'sxx', 'suixixian');
INSERT INTO `region_areas` VALUES ('91', '130627', '唐县', '38', 't', 'tx', 'tangxian');
INSERT INTO `region_areas` VALUES ('910', '340702', '铜官山区', '150', 't', 'tgsq', 'tongguanshanqu');
INSERT INTO `region_areas` VALUES ('911', '340703', '狮子山区', '150', 's', 'szsq', 'shizishanqu');
INSERT INTO `region_areas` VALUES ('912', '340711', '郊区', '150', 'j', 'jq', 'jiaoqu');
INSERT INTO `region_areas` VALUES ('913', '340721', '铜陵县', '150', 't', 'tlx', 'tonglingxian');
INSERT INTO `region_areas` VALUES ('914', '340802', '迎江区', '151', 'y', 'yjq', 'yingjiangqu');
INSERT INTO `region_areas` VALUES ('915', '340803', '大观区', '151', 'd', 'dgq', 'daguanqu');
INSERT INTO `region_areas` VALUES ('916', '340811', '宜秀区', '151', 'y', 'yxq', 'yixiuqu');
INSERT INTO `region_areas` VALUES ('917', '340822', '怀宁县', '151', 'h', 'hnx', 'huainingxian');
INSERT INTO `region_areas` VALUES ('918', '340823', '枞阳县', '151', 'z', 'zyx', 'zongyangxian');
INSERT INTO `region_areas` VALUES ('919', '340824', '潜山县', '151', 'q', 'qsx', 'qianshanxian');
INSERT INTO `region_areas` VALUES ('92', '130628', '高阳县', '38', 'g', 'gyx', 'gaoyangxian');
INSERT INTO `region_areas` VALUES ('920', '340825', '太湖县', '151', 't', 'thx', 'taihuxian');
INSERT INTO `region_areas` VALUES ('921', '340826', '宿松县', '151', 's', 'ssx', 'susongxian');
INSERT INTO `region_areas` VALUES ('922', '340827', '望江县', '151', 'w', 'wjx', 'wangjiangxian');
INSERT INTO `region_areas` VALUES ('923', '340828', '岳西县', '151', 'y', 'yxx', 'yuexixian');
INSERT INTO `region_areas` VALUES ('924', '340881', '桐城市', '151', 't', 'tcs', 'tongchengshi');
INSERT INTO `region_areas` VALUES ('925', '341002', '屯溪区', '152', 't', 'txq', 'tunxiqu');
INSERT INTO `region_areas` VALUES ('926', '341003', '黄山区', '152', 'h', 'hsq', 'huangshanqu');
INSERT INTO `region_areas` VALUES ('927', '341004', '徽州区', '152', 'h', 'hzq', 'huizhouqu');
INSERT INTO `region_areas` VALUES ('928', '341021', '歙县', '152', 's', 'sx', 'shexian');
INSERT INTO `region_areas` VALUES ('929', '341022', '休宁县', '152', 'x', 'xnx', 'xiuningxian');
INSERT INTO `region_areas` VALUES ('93', '130629', '容城县', '38', 'r', 'rcx', 'rongchengxian');
INSERT INTO `region_areas` VALUES ('930', '341023', '黟县', '152', 'y', 'yx', 'yixian');
INSERT INTO `region_areas` VALUES ('931', '341024', '祁门县', '152', 'q', 'qmx', 'qimenxian');
INSERT INTO `region_areas` VALUES ('932', '341102', '琅琊区', '153', 'l', 'lyq', 'langyaqu');
INSERT INTO `region_areas` VALUES ('933', '341103', '南谯区', '153', 'n', 'nqq', 'nanqiaoqu');
INSERT INTO `region_areas` VALUES ('934', '341122', '来安县', '153', 'l', 'lax', 'laianxian');
INSERT INTO `region_areas` VALUES ('935', '341124', '全椒县', '153', 'q', 'qjx', 'quanjiaoxian');
INSERT INTO `region_areas` VALUES ('936', '341125', '定远县', '153', 'd', 'dyx', 'dingyuanxian');
INSERT INTO `region_areas` VALUES ('937', '341126', '凤阳县', '153', 'f', 'fyx', 'fengyangxian');
INSERT INTO `region_areas` VALUES ('938', '341181', '天长市', '153', 't', 'tzs', 'tianzhangshi');
INSERT INTO `region_areas` VALUES ('939', '341182', '明光市', '153', 'm', 'mgs', 'mingguangshi');
INSERT INTO `region_areas` VALUES ('94', '130630', '涞源县', '38', 'l', 'lyx', 'laiyuanxian');
INSERT INTO `region_areas` VALUES ('940', '341202', '颍州区', '154', 'y', 'yzq', 'yingzhouqu');
INSERT INTO `region_areas` VALUES ('941', '341203', '颍东区', '154', 'y', 'ydq', 'yingdongqu');
INSERT INTO `region_areas` VALUES ('942', '341204', '颍泉区', '154', 'y', 'yqq', 'yingquanqu');
INSERT INTO `region_areas` VALUES ('943', '341221', '临泉县', '154', 'l', 'lqx', 'linquanxian');
INSERT INTO `region_areas` VALUES ('944', '341222', '太和县', '154', 't', 'thx', 'taihexian');
INSERT INTO `region_areas` VALUES ('945', '341225', '阜南县', '154', 'f', 'fnx', 'funanxian');
INSERT INTO `region_areas` VALUES ('946', '341226', '颍上县', '154', 'y', 'ysx', 'yingshangxian');
INSERT INTO `region_areas` VALUES ('947', '341282', '界首市', '154', 'j', 'jss', 'jieshoushi');
INSERT INTO `region_areas` VALUES ('948', '341302', '埇桥区', '155', 'y', 'yqq', 'yongqiaoqu');
INSERT INTO `region_areas` VALUES ('949', '341321', '砀山县', '155', 'd', 'dsx', 'dangshanxian');
INSERT INTO `region_areas` VALUES ('95', '130631', '望都县', '38', 'w', 'wdx', 'wangdouxian');
INSERT INTO `region_areas` VALUES ('950', '341322', '萧县', '155', 'x', 'xx', 'xiaoxian');
INSERT INTO `region_areas` VALUES ('951', '341323', '灵璧县', '155', 'l', 'lbx', 'lingbixian');
INSERT INTO `region_areas` VALUES ('952', '341324', '泗县', '155', 's', 'sx', 'sixian');
INSERT INTO `region_areas` VALUES ('953', '341502', '金安区', '156', 'j', 'jaq', 'jinanqu');
INSERT INTO `region_areas` VALUES ('954', '341503', '裕安区', '156', 'y', 'yaq', 'yuanqu');
INSERT INTO `region_areas` VALUES ('955', '341521', '寿县', '156', 's', 'sx', 'shouxian');
INSERT INTO `region_areas` VALUES ('956', '341522', '霍邱县', '156', 'h', 'hqx', 'huoqiuxian');
INSERT INTO `region_areas` VALUES ('957', '341523', '舒城县', '156', 's', 'scx', 'shuchengxian');
INSERT INTO `region_areas` VALUES ('958', '341524', '金寨县', '156', 'j', 'jzx', 'jinzhaixian');
INSERT INTO `region_areas` VALUES ('959', '341525', '霍山县', '156', 'h', 'hsx', 'huoshanxian');
INSERT INTO `region_areas` VALUES ('96', '130632', '安新县', '38', 'a', 'axx', 'anxinxian');
INSERT INTO `region_areas` VALUES ('960', '341602', '谯城区', '157', 'q', 'qcq', 'qiaochengqu');
INSERT INTO `region_areas` VALUES ('961', '341621', '涡阳县', '157', 'w', 'wyx', 'woyangxian');
INSERT INTO `region_areas` VALUES ('962', '341622', '蒙城县', '157', 'm', 'mcx', 'mengchengxian');
INSERT INTO `region_areas` VALUES ('963', '341623', '利辛县', '157', 'l', 'lxx', 'lixinxian');
INSERT INTO `region_areas` VALUES ('964', '341702', '贵池区', '158', 'g', 'gcq', 'guichiqu');
INSERT INTO `region_areas` VALUES ('965', '341721', '东至县', '158', 'd', 'dzx', 'dongzhixian');
INSERT INTO `region_areas` VALUES ('966', '341722', '石台县', '158', 's', 'stx', 'shitaixian');
INSERT INTO `region_areas` VALUES ('967', '341723', '青阳县', '158', 'q', 'qyx', 'qingyangxian');
INSERT INTO `region_areas` VALUES ('968', '341802', '宣州区', '159', 'x', 'xzq', 'xuanzhouqu');
INSERT INTO `region_areas` VALUES ('969', '341821', '郎溪县', '159', 'l', 'lxx', 'langxixian');
INSERT INTO `region_areas` VALUES ('97', '130633', '易县', '38', 'y', 'yx', 'yixian');
INSERT INTO `region_areas` VALUES ('970', '341822', '广德县', '159', 'g', 'gdx', 'guangdexian');
INSERT INTO `region_areas` VALUES ('971', '341823', '泾县', '159', 'j', 'jx', 'jingxian');
INSERT INTO `region_areas` VALUES ('972', '341824', '绩溪县', '159', 'j', 'jxx', 'jixixian');
INSERT INTO `region_areas` VALUES ('973', '341825', '旌德县', '159', 'j', 'jdx', 'jingdexian');
INSERT INTO `region_areas` VALUES ('974', '341881', '宁国市', '159', 'n', 'ngs', 'ningguoshi');
INSERT INTO `region_areas` VALUES ('975', '350102', '鼓楼区', '160', 'g', 'glq', 'gulouqu');
INSERT INTO `region_areas` VALUES ('976', '350103', '台江区', '160', 't', 'tjq', 'taijiangqu');
INSERT INTO `region_areas` VALUES ('977', '350104', '仓山区', '160', 'c', 'csq', 'cangshanqu');
INSERT INTO `region_areas` VALUES ('978', '350105', '马尾区', '160', 'm', 'mwq', 'maweiqu');
INSERT INTO `region_areas` VALUES ('979', '350111', '晋安区', '160', 'j', 'jaq', 'jinanqu');
INSERT INTO `region_areas` VALUES ('98', '130634', '曲阳县', '38', 'q', 'qyx', 'quyangxian');
INSERT INTO `region_areas` VALUES ('980', '350121', '闽侯县', '160', 'm', 'mhx', 'minhouxian');
INSERT INTO `region_areas` VALUES ('981', '350122', '连江县', '160', 'l', 'ljx', 'lianjiangxian');
INSERT INTO `region_areas` VALUES ('982', '350123', '罗源县', '160', 'l', 'lyx', 'luoyuanxian');
INSERT INTO `region_areas` VALUES ('983', '350124', '闽清县', '160', 'm', 'mqx', 'minqingxian');
INSERT INTO `region_areas` VALUES ('984', '350125', '永泰县', '160', 'y', 'ytx', 'yongtaixian');
INSERT INTO `region_areas` VALUES ('985', '350128', '平潭县', '160', 'p', 'ptx', 'pingtanxian');
INSERT INTO `region_areas` VALUES ('986', '350181', '福清市', '160', 'f', 'fqs', 'fuqingshi');
INSERT INTO `region_areas` VALUES ('987', '350182', '长乐市', '160', 'z', 'zls', 'zhangleshi');
INSERT INTO `region_areas` VALUES ('988', '350203', '思明区', '161', 's', 'smq', 'simingqu');
INSERT INTO `region_areas` VALUES ('989', '350205', '海沧区', '161', 'h', 'hcq', 'haicangqu');
INSERT INTO `region_areas` VALUES ('99', '130635', '蠡县', '38', 'l', 'lx', 'lixian');
INSERT INTO `region_areas` VALUES ('990', '350206', '湖里区', '161', 'h', 'hlq', 'huliqu');
INSERT INTO `region_areas` VALUES ('991', '350211', '集美区', '161', 'j', 'jmq', 'jimeiqu');
INSERT INTO `region_areas` VALUES ('992', '350212', '同安区', '161', 't', 'taq', 'tonganqu');
INSERT INTO `region_areas` VALUES ('993', '350213', '翔安区', '161', 'x', 'xaq', 'xianganqu');
INSERT INTO `region_areas` VALUES ('994', '350302', '城厢区', '162', 'c', 'cxq', 'chengxiangqu');
INSERT INTO `region_areas` VALUES ('995', '350303', '涵江区', '162', 'h', 'hjq', 'hanjiangqu');
INSERT INTO `region_areas` VALUES ('996', '350304', '荔城区', '162', 'l', 'lcq', 'lichengqu');
INSERT INTO `region_areas` VALUES ('997', '350305', '秀屿区', '162', 'x', 'xyq', 'xiuyuqu');
INSERT INTO `region_areas` VALUES ('998', '350322', '仙游县', '162', 'x', 'xyx', 'xianyouxian');
INSERT INTO `region_areas` VALUES ('999', '350402', '梅列区', '163', 'm', 'mlq', 'meiliequ');

-- ----------------------------
-- Table structure for region_cities
-- ----------------------------
DROP TABLE IF EXISTS `region_cities`;
CREATE TABLE `region_cities` (
  `id` varchar(64) NOT NULL COMMENT '主键',
  `city_code` varchar(20) NOT NULL DEFAULT '' COMMENT '地区代码',
  `city` varchar(50) NOT NULL DEFAULT '' COMMENT '城市名称',
  `province_id` int(11) NOT NULL DEFAULT '0' COMMENT '省份ID',
  `initial` varchar(20) NOT NULL DEFAULT '' COMMENT '地区拼音首写字母',
  `initials` varchar(60) NOT NULL DEFAULT '' COMMENT '地区拼音首写字母组合',
  `pinyin` varchar(300) NOT NULL DEFAULT '' COMMENT '地区拼音全拼',
  PRIMARY KEY (`id`),
  KEY `fk_provinces_cities` (`province_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='城市表';

-- ----------------------------
-- Records of region_cities
-- ----------------------------
INSERT INTO `region_cities` VALUES ('1', '110101', '东城区', '1', 'd', 'dcq', 'dongchengqu');
INSERT INTO `region_cities` VALUES ('10', '110113', '顺义区', '1', 's', 'syq', 'shunyiqu');
INSERT INTO `region_cities` VALUES ('100', '231100', '黑河市', '8', 'h', 'hhs', 'heiheshi');
INSERT INTO `region_cities` VALUES ('101', '231200', '绥化市', '8', 's', 'shs', 'suihuashi');
INSERT INTO `region_cities` VALUES ('102', '232700', '大兴安岭地区', '8', 'd', 'dxaldq', 'daxinganlingdiqu');
INSERT INTO `region_cities` VALUES ('103', '310101', '黄浦区', '9', 'h', 'hpq', 'huangpuqu');
INSERT INTO `region_cities` VALUES ('104', '310104', '徐汇区', '9', 'x', 'xhq', 'xuhuiqu');
INSERT INTO `region_cities` VALUES ('105', '310105', '长宁区', '9', 'z', 'znq', 'zhangningqu');
INSERT INTO `region_cities` VALUES ('106', '310106', '静安区', '9', 'j', 'jaq', 'jinganqu');
INSERT INTO `region_cities` VALUES ('107', '310107', '普陀区', '9', 'p', 'ptq', 'putuoqu');
INSERT INTO `region_cities` VALUES ('108', '310108', '闸北区', '9', 'z', 'zbq', 'zhabeiqu');
INSERT INTO `region_cities` VALUES ('109', '310109', '虹口区', '9', 'h', 'hkq', 'hongkouqu');
INSERT INTO `region_cities` VALUES ('11', '110114', '昌平区', '1', 'c', 'cpq', 'changpingqu');
INSERT INTO `region_cities` VALUES ('110', '310110', '杨浦区', '9', 'y', 'ypq', 'yangpuqu');
INSERT INTO `region_cities` VALUES ('111', '310112', '闵行区', '9', 'm', 'mxq', 'minxingqu');
INSERT INTO `region_cities` VALUES ('112', '310113', '宝山区', '9', 'b', 'bsq', 'baoshanqu');
INSERT INTO `region_cities` VALUES ('113', '310114', '嘉定区', '9', 'j', 'jdq', 'jiadingqu');
INSERT INTO `region_cities` VALUES ('114', '310115', '浦东新区', '9', 'p', 'pdxq', 'pudongxinqu');
INSERT INTO `region_cities` VALUES ('115', '310116', '金山区', '9', 'j', 'jsq', 'jinshanqu');
INSERT INTO `region_cities` VALUES ('116', '310117', '松江区', '9', 's', 'sjq', 'songjiangqu');
INSERT INTO `region_cities` VALUES ('117', '310118', '青浦区', '9', 'q', 'qpq', 'qingpuqu');
INSERT INTO `region_cities` VALUES ('118', '310120', '奉贤区', '9', 'f', 'fxq', 'fengxianqu');
INSERT INTO `region_cities` VALUES ('119', '310230', '崇明县', '9', 'c', 'cmx', 'chongmingxian');
INSERT INTO `region_cities` VALUES ('12', '110115', '大兴区', '1', 'd', 'dxq', 'daxingqu');
INSERT INTO `region_cities` VALUES ('120', '320100', '南京市', '10', 'n', 'njs', 'nanjingshi');
INSERT INTO `region_cities` VALUES ('121', '320200', '无锡市', '10', 'w', 'wxs', 'wuxishi');
INSERT INTO `region_cities` VALUES ('122', '320300', '徐州市', '10', 'x', 'xzs', 'xuzhoushi');
INSERT INTO `region_cities` VALUES ('123', '320400', '常州市', '10', 'c', 'czs', 'changzhoushi');
INSERT INTO `region_cities` VALUES ('124', '320500', '苏州市', '10', 's', 'szs', 'suzhoushi');
INSERT INTO `region_cities` VALUES ('125', '320600', '南通市', '10', 'n', 'nts', 'nantongshi');
INSERT INTO `region_cities` VALUES ('126', '320700', '连云港市', '10', 'l', 'lygs', 'lianyungangshi');
INSERT INTO `region_cities` VALUES ('127', '320800', '淮安市', '10', 'h', 'has', 'huaianshi');
INSERT INTO `region_cities` VALUES ('128', '320900', '盐城市', '10', 'y', 'ycs', 'yanchengshi');
INSERT INTO `region_cities` VALUES ('129', '321000', '扬州市', '10', 'y', 'yzs', 'yangzhoushi');
INSERT INTO `region_cities` VALUES ('13', '110116', '怀柔区', '1', 'h', 'hrq', 'huairouqu');
INSERT INTO `region_cities` VALUES ('130', '321100', '镇江市', '10', 'z', 'zjs', 'zhenjiangshi');
INSERT INTO `region_cities` VALUES ('131', '321200', '泰州市', '10', 't', 'tzs', 'taizhoushi');
INSERT INTO `region_cities` VALUES ('132', '321300', '宿迁市', '10', 's', 'sqs', 'suqianshi');
INSERT INTO `region_cities` VALUES ('133', '330100', '杭州市', '11', 'h', 'hzs', 'hangzhoushi');
INSERT INTO `region_cities` VALUES ('134', '330200', '宁波市', '11', 'n', 'nbs', 'ningboshi');
INSERT INTO `region_cities` VALUES ('135', '330300', '温州市', '11', 'w', 'wzs', 'wenzhoushi');
INSERT INTO `region_cities` VALUES ('136', '330400', '嘉兴市', '11', 'j', 'jxs', 'jiaxingshi');
INSERT INTO `region_cities` VALUES ('137', '330500', '湖州市', '11', 'h', 'hzs', 'huzhoushi');
INSERT INTO `region_cities` VALUES ('138', '330600', '绍兴市', '11', 's', 'sxs', 'shaoxingshi');
INSERT INTO `region_cities` VALUES ('139', '330700', '金华市', '11', 'j', 'jhs', 'jinhuashi');
INSERT INTO `region_cities` VALUES ('14', '110117', '平谷区', '1', 'p', 'pgq', 'pingguqu');
INSERT INTO `region_cities` VALUES ('140', '330800', '衢州市', '11', 'q', 'qzs', 'quzhoushi');
INSERT INTO `region_cities` VALUES ('141', '330900', '舟山市', '11', 'z', 'zss', 'zhoushanshi');
INSERT INTO `region_cities` VALUES ('142', '331000', '台州市', '11', 't', 'tzs', 'taizhoushi');
INSERT INTO `region_cities` VALUES ('143', '331100', '丽水市', '11', 'l', 'lss', 'lishuishi');
INSERT INTO `region_cities` VALUES ('144', '340100', '合肥市', '12', 'h', 'hfs', 'hefeishi');
INSERT INTO `region_cities` VALUES ('145', '340200', '芜湖市', '12', 'w', 'whs', 'wuhushi');
INSERT INTO `region_cities` VALUES ('146', '340300', '蚌埠市', '12', 'b', 'bbs', 'bangbushi');
INSERT INTO `region_cities` VALUES ('147', '340400', '淮南市', '12', 'h', 'hns', 'huainanshi');
INSERT INTO `region_cities` VALUES ('148', '340500', '马鞍山市', '12', 'm', 'mass', 'maanshanshi');
INSERT INTO `region_cities` VALUES ('149', '340600', '淮北市', '12', 'h', 'hbs', 'huaibeishi');
INSERT INTO `region_cities` VALUES ('15', '110228', '密云县', '1', 'm', 'myx', 'miyunxian');
INSERT INTO `region_cities` VALUES ('150', '340700', '铜陵市', '12', 't', 'tls', 'tonglingshi');
INSERT INTO `region_cities` VALUES ('151', '340800', '安庆市', '12', 'a', 'aqs', 'anqingshi');
INSERT INTO `region_cities` VALUES ('152', '341000', '黄山市', '12', 'h', 'hss', 'huangshanshi');
INSERT INTO `region_cities` VALUES ('153', '341100', '滁州市', '12', 'c', 'czs', 'chuzhoushi');
INSERT INTO `region_cities` VALUES ('154', '341200', '阜阳市', '12', 'f', 'fys', 'fuyangshi');
INSERT INTO `region_cities` VALUES ('155', '341300', '宿州市', '12', 's', 'szs', 'suzhoushi');
INSERT INTO `region_cities` VALUES ('156', '341500', '六安市', '12', 'l', 'las', 'liuanshi');
INSERT INTO `region_cities` VALUES ('157', '341600', '亳州市', '12', 'b', 'bzs', 'bozhoushi');
INSERT INTO `region_cities` VALUES ('158', '341700', '池州市', '12', 'c', 'czs', 'chizhoushi');
INSERT INTO `region_cities` VALUES ('159', '341800', '宣城市', '12', 'x', 'xcs', 'xuanchengshi');
INSERT INTO `region_cities` VALUES ('16', '110229', '延庆县', '1', 'y', 'yqx', 'yanqingxian');
INSERT INTO `region_cities` VALUES ('160', '350100', '福州市', '13', 'f', 'fzs', 'fuzhoushi');
INSERT INTO `region_cities` VALUES ('161', '350200', '厦门市', '13', 's', 'sms', 'shamenshi');
INSERT INTO `region_cities` VALUES ('162', '350300', '莆田市', '13', 'p', 'pts', 'putianshi');
INSERT INTO `region_cities` VALUES ('163', '350400', '三明市', '13', 's', 'sms', 'sanmingshi');
INSERT INTO `region_cities` VALUES ('164', '350500', '泉州市', '13', 'q', 'qzs', 'quanzhoushi');
INSERT INTO `region_cities` VALUES ('165', '350600', '漳州市', '13', 'z', 'zzs', 'zhangzhoushi');
INSERT INTO `region_cities` VALUES ('166', '350700', '南平市', '13', 'n', 'nps', 'nanpingshi');
INSERT INTO `region_cities` VALUES ('167', '350800', '龙岩市', '13', 'l', 'lys', 'longyanshi');
INSERT INTO `region_cities` VALUES ('168', '350900', '宁德市', '13', 'n', 'nds', 'ningdeshi');
INSERT INTO `region_cities` VALUES ('169', '360100', '南昌市', '14', 'n', 'ncs', 'nanchangshi');
INSERT INTO `region_cities` VALUES ('17', '120101', '和平区', '2', 'h', 'hpq', 'hepingqu');
INSERT INTO `region_cities` VALUES ('170', '360200', '景德镇市', '14', 'j', 'jdzs', 'jingdezhenshi');
INSERT INTO `region_cities` VALUES ('171', '360300', '萍乡市', '14', 'p', 'pxs', 'pingxiangshi');
INSERT INTO `region_cities` VALUES ('172', '360400', '九江市', '14', 'j', 'jjs', 'jiujiangshi');
INSERT INTO `region_cities` VALUES ('173', '360500', '新余市', '14', 'x', 'xys', 'xinyushi');
INSERT INTO `region_cities` VALUES ('174', '360600', '鹰潭市', '14', 'y', 'yts', 'yingtanshi');
INSERT INTO `region_cities` VALUES ('175', '360700', '赣州市', '14', 'g', 'gzs', 'ganzhoushi');
INSERT INTO `region_cities` VALUES ('176', '360800', '吉安市', '14', 'j', 'jas', 'jianshi');
INSERT INTO `region_cities` VALUES ('177', '360900', '宜春市', '14', 'y', 'ycs', 'yichunshi');
INSERT INTO `region_cities` VALUES ('178', '361000', '抚州市', '14', 'f', 'fzs', 'fuzhoushi');
INSERT INTO `region_cities` VALUES ('179', '361100', '上饶市', '14', 's', 'srs', 'shangraoshi');
INSERT INTO `region_cities` VALUES ('18', '120102', '河东区', '2', 'h', 'hdq', 'hedongqu');
INSERT INTO `region_cities` VALUES ('180', '370100', '济南市', '15', 'j', 'jns', 'jinanshi');
INSERT INTO `region_cities` VALUES ('181', '370200', '青岛市', '15', 'q', 'qds', 'qingdaoshi');
INSERT INTO `region_cities` VALUES ('182', '370300', '淄博市', '15', 'z', 'zbs', 'ziboshi');
INSERT INTO `region_cities` VALUES ('183', '370400', '枣庄市', '15', 'z', 'zzs', 'zaozhuangshi');
INSERT INTO `region_cities` VALUES ('184', '370500', '东营市', '15', 'd', 'dys', 'dongyingshi');
INSERT INTO `region_cities` VALUES ('185', '370600', '烟台市', '15', 'y', 'yts', 'yantaishi');
INSERT INTO `region_cities` VALUES ('186', '370700', '潍坊市', '15', 'w', 'wfs', 'weifangshi');
INSERT INTO `region_cities` VALUES ('187', '370800', '济宁市', '15', 'j', 'jns', 'jiningshi');
INSERT INTO `region_cities` VALUES ('188', '370900', '泰安市', '15', 't', 'tas', 'taianshi');
INSERT INTO `region_cities` VALUES ('189', '371000', '威海市', '15', 'w', 'whs', 'weihaishi');
INSERT INTO `region_cities` VALUES ('19', '120103', '河西区', '2', 'h', 'hxq', 'hexiqu');
INSERT INTO `region_cities` VALUES ('190', '371100', '日照市', '15', 'r', 'rzs', 'rizhaoshi');
INSERT INTO `region_cities` VALUES ('191', '371200', '莱芜市', '15', 'l', 'lws', 'laiwushi');
INSERT INTO `region_cities` VALUES ('192', '371300', '临沂市', '15', 'l', 'lys', 'linyishi');
INSERT INTO `region_cities` VALUES ('193', '371400', '德州市', '15', 'd', 'dzs', 'dezhoushi');
INSERT INTO `region_cities` VALUES ('194', '371500', '聊城市', '15', 'l', 'lcs', 'liaochengshi');
INSERT INTO `region_cities` VALUES ('195', '371600', '滨州市', '15', 'b', 'bzs', 'binzhoushi');
INSERT INTO `region_cities` VALUES ('196', '371700', '菏泽市', '15', 'h', 'hzs', 'hezeshi');
INSERT INTO `region_cities` VALUES ('197', '410100', '郑州市', '16', 'z', 'zzs', 'zhengzhoushi');
INSERT INTO `region_cities` VALUES ('198', '410200', '开封市', '16', 'k', 'kfs', 'kaifengshi');
INSERT INTO `region_cities` VALUES ('199', '410300', '洛阳市', '16', 'l', 'lys', 'luoyangshi');
INSERT INTO `region_cities` VALUES ('2', '110102', '西城区', '1', 'x', 'xcq', 'xichengqu');
INSERT INTO `region_cities` VALUES ('20', '120104', '南开区', '2', 'n', 'nkq', 'nankaiqu');
INSERT INTO `region_cities` VALUES ('200', '410400', '平顶山市', '16', 'p', 'pdss', 'pingdingshanshi');
INSERT INTO `region_cities` VALUES ('201', '410500', '安阳市', '16', 'a', 'ays', 'anyangshi');
INSERT INTO `region_cities` VALUES ('202', '410600', '鹤壁市', '16', 'h', 'hbs', 'hebishi');
INSERT INTO `region_cities` VALUES ('203', '410700', '新乡市', '16', 'x', 'xxs', 'xinxiangshi');
INSERT INTO `region_cities` VALUES ('204', '410800', '焦作市', '16', 'j', 'jzs', 'jiaozuoshi');
INSERT INTO `region_cities` VALUES ('205', '410900', '濮阳市', '16', 'p', 'pys', 'puyangshi');
INSERT INTO `region_cities` VALUES ('206', '411000', '许昌市', '16', 'x', 'xcs', 'xuchangshi');
INSERT INTO `region_cities` VALUES ('207', '411100', '漯河市', '16', 'l', 'lhs', 'luoheshi');
INSERT INTO `region_cities` VALUES ('208', '411200', '三门峡市', '16', 's', 'smxs', 'sanmenxiashi');
INSERT INTO `region_cities` VALUES ('209', '411300', '南阳市', '16', 'n', 'nys', 'nanyangshi');
INSERT INTO `region_cities` VALUES ('21', '120105', '河北区', '2', 'h', 'hbq', 'hebeiqu');
INSERT INTO `region_cities` VALUES ('210', '411400', '商丘市', '16', 's', 'sqs', 'shangqiushi');
INSERT INTO `region_cities` VALUES ('211', '411500', '信阳市', '16', 'x', 'xys', 'xinyangshi');
INSERT INTO `region_cities` VALUES ('212', '411600', '周口市', '16', 'z', 'zks', 'zhoukoushi');
INSERT INTO `region_cities` VALUES ('213', '411700', '驻马店市', '16', 'z', 'zmds', 'zhumadianshi');
INSERT INTO `region_cities` VALUES ('214', '419000', '省直辖县级行政区划', '16', 's', 'szxxjxzqh', 'shengzhixiaxianjixingzhengquhua');
INSERT INTO `region_cities` VALUES ('215', '420100', '武汉市', '17', 'w', 'whs', 'wuhanshi');
INSERT INTO `region_cities` VALUES ('216', '420200', '黄石市', '17', 'h', 'hss', 'huangshishi');
INSERT INTO `region_cities` VALUES ('217', '420300', '十堰市', '17', 's', 'sys', 'shiyanshi');
INSERT INTO `region_cities` VALUES ('218', '420500', '宜昌市', '17', 'y', 'ycs', 'yichangshi');
INSERT INTO `region_cities` VALUES ('219', '420600', '襄阳市', '17', 'x', 'xys', 'xiangyangshi');
INSERT INTO `region_cities` VALUES ('22', '120106', '红桥区', '2', 'h', 'hqq', 'hongqiaoqu');
INSERT INTO `region_cities` VALUES ('220', '420700', '鄂州市', '17', 'e', 'ezs', 'ezhoushi');
INSERT INTO `region_cities` VALUES ('221', '420800', '荆门市', '17', 'j', 'jms', 'jingmenshi');
INSERT INTO `region_cities` VALUES ('222', '420900', '孝感市', '17', 'x', 'xgs', 'xiaoganshi');
INSERT INTO `region_cities` VALUES ('223', '421000', '荆州市', '17', 'j', 'jzs', 'jingzhoushi');
INSERT INTO `region_cities` VALUES ('224', '421100', '黄冈市', '17', 'h', 'hgs', 'huanggangshi');
INSERT INTO `region_cities` VALUES ('225', '421200', '咸宁市', '17', 'x', 'xns', 'xianningshi');
INSERT INTO `region_cities` VALUES ('226', '421300', '随州市', '17', 's', 'szs', 'suizhoushi');
INSERT INTO `region_cities` VALUES ('227', '422800', '恩施土家族苗族自治州', '17', 'e', 'estjzmzzzz', 'enshitujiazumiaozuzizhizhou');
INSERT INTO `region_cities` VALUES ('228', '429000', '省直辖县级行政区划', '17', 's', 'szxxjxzqh', 'shengzhixiaxianjixingzhengquhua');
INSERT INTO `region_cities` VALUES ('229', '430100', '长沙市', '18', 'z', 'zss', 'zhangshashi');
INSERT INTO `region_cities` VALUES ('23', '120110', '东丽区', '2', 'd', 'dlq', 'dongliqu');
INSERT INTO `region_cities` VALUES ('230', '430200', '株洲市', '18', 'z', 'zzs', 'zhuzhoushi');
INSERT INTO `region_cities` VALUES ('231', '430300', '湘潭市', '18', 'x', 'xts', 'xiangtanshi');
INSERT INTO `region_cities` VALUES ('232', '430400', '衡阳市', '18', 'h', 'hys', 'hengyangshi');
INSERT INTO `region_cities` VALUES ('233', '430500', '邵阳市', '18', 's', 'sys', 'shaoyangshi');
INSERT INTO `region_cities` VALUES ('234', '430600', '岳阳市', '18', 'y', 'yys', 'yueyangshi');
INSERT INTO `region_cities` VALUES ('235', '430700', '常德市', '18', 'c', 'cds', 'changdeshi');
INSERT INTO `region_cities` VALUES ('236', '430800', '张家界市', '18', 'z', 'zjjs', 'zhangjiajieshi');
INSERT INTO `region_cities` VALUES ('237', '430900', '益阳市', '18', 'y', 'yys', 'yiyangshi');
INSERT INTO `region_cities` VALUES ('238', '431000', '郴州市', '18', 'c', 'czs', 'chenzhoushi');
INSERT INTO `region_cities` VALUES ('239', '431100', '永州市', '18', 'y', 'yzs', 'yongzhoushi');
INSERT INTO `region_cities` VALUES ('24', '120111', '西青区', '2', 'x', 'xqq', 'xiqingqu');
INSERT INTO `region_cities` VALUES ('240', '431200', '怀化市', '18', 'h', 'hhs', 'huaihuashi');
INSERT INTO `region_cities` VALUES ('241', '431300', '娄底市', '18', 'l', 'lds', 'loudishi');
INSERT INTO `region_cities` VALUES ('242', '433100', '湘西土家族苗族自治州', '18', 'x', 'xxtjzmzzzz', 'xiangxitujiazumiaozuzizhizhou');
INSERT INTO `region_cities` VALUES ('243', '440100', '广州市', '19', 'g', 'gzs', 'guangzhoushi');
INSERT INTO `region_cities` VALUES ('244', '440200', '韶关市', '19', 's', 'sgs', 'shaoguanshi');
INSERT INTO `region_cities` VALUES ('245', '440300', '深圳市', '19', 's', 'szs', 'shenzhenshi');
INSERT INTO `region_cities` VALUES ('246', '440400', '珠海市', '19', 'z', 'zhs', 'zhuhaishi');
INSERT INTO `region_cities` VALUES ('247', '440500', '汕头市', '19', 's', 'sts', 'shantoushi');
INSERT INTO `region_cities` VALUES ('248', '440600', '佛山市', '19', 'f', 'fss', 'foshanshi');
INSERT INTO `region_cities` VALUES ('249', '440700', '江门市', '19', 'j', 'jms', 'jiangmenshi');
INSERT INTO `region_cities` VALUES ('25', '120112', '津南区', '2', 'j', 'jnq', 'jinnanqu');
INSERT INTO `region_cities` VALUES ('250', '440800', '湛江市', '19', 'z', 'zjs', 'zhanjiangshi');
INSERT INTO `region_cities` VALUES ('251', '440900', '茂名市', '19', 'm', 'mms', 'maomingshi');
INSERT INTO `region_cities` VALUES ('252', '441200', '肇庆市', '19', 'z', 'zqs', 'zhaoqingshi');
INSERT INTO `region_cities` VALUES ('253', '441300', '惠州市', '19', 'h', 'hzs', 'huizhoushi');
INSERT INTO `region_cities` VALUES ('254', '441400', '梅州市', '19', 'm', 'mzs', 'meizhoushi');
INSERT INTO `region_cities` VALUES ('255', '441500', '汕尾市', '19', 's', 'sws', 'shanweishi');
INSERT INTO `region_cities` VALUES ('256', '441600', '河源市', '19', 'h', 'hys', 'heyuanshi');
INSERT INTO `region_cities` VALUES ('257', '441700', '阳江市', '19', 'y', 'yjs', 'yangjiangshi');
INSERT INTO `region_cities` VALUES ('258', '441800', '清远市', '19', 'q', 'qys', 'qingyuanshi');
INSERT INTO `region_cities` VALUES ('259', '441900', '东莞市', '19', 'd', 'dgs', 'dongguanshi');
INSERT INTO `region_cities` VALUES ('26', '120113', '北辰区', '2', 'b', 'bcq', 'beichenqu');
INSERT INTO `region_cities` VALUES ('260', '442000', '中山市', '19', 'z', 'zss', 'zhongshanshi');
INSERT INTO `region_cities` VALUES ('261', '445100', '潮州市', '19', 'c', 'czs', 'chaozhoushi');
INSERT INTO `region_cities` VALUES ('262', '445200', '揭阳市', '19', 'j', 'jys', 'jieyangshi');
INSERT INTO `region_cities` VALUES ('263', '445300', '云浮市', '19', 'y', 'yfs', 'yunfushi');
INSERT INTO `region_cities` VALUES ('264', '450100', '南宁市', '20', 'n', 'nns', 'nanningshi');
INSERT INTO `region_cities` VALUES ('265', '450200', '柳州市', '20', 'l', 'lzs', 'liuzhoushi');
INSERT INTO `region_cities` VALUES ('266', '450300', '桂林市', '20', 'g', 'gls', 'guilinshi');
INSERT INTO `region_cities` VALUES ('267', '450400', '梧州市', '20', 'w', 'wzs', 'wuzhoushi');
INSERT INTO `region_cities` VALUES ('268', '450500', '北海市', '20', 'b', 'bhs', 'beihaishi');
INSERT INTO `region_cities` VALUES ('269', '450600', '防城港市', '20', 'f', 'fcgs', 'fangchenggangshi');
INSERT INTO `region_cities` VALUES ('27', '120114', '武清区', '2', 'w', 'wqq', 'wuqingqu');
INSERT INTO `region_cities` VALUES ('270', '450700', '钦州市', '20', 'q', 'qzs', 'qinzhoushi');
INSERT INTO `region_cities` VALUES ('271', '450800', '贵港市', '20', 'g', 'ggs', 'guigangshi');
INSERT INTO `region_cities` VALUES ('272', '450900', '玉林市', '20', 'y', 'yls', 'yulinshi');
INSERT INTO `region_cities` VALUES ('273', '451000', '百色市', '20', 'b', 'bss', 'baiseshi');
INSERT INTO `region_cities` VALUES ('274', '451100', '贺州市', '20', 'h', 'hzs', 'hezhoushi');
INSERT INTO `region_cities` VALUES ('275', '451200', '河池市', '20', 'h', 'hcs', 'hechishi');
INSERT INTO `region_cities` VALUES ('276', '451300', '来宾市', '20', 'l', 'lbs', 'laibinshi');
INSERT INTO `region_cities` VALUES ('277', '451400', '崇左市', '20', 'c', 'czs', 'chongzuoshi');
INSERT INTO `region_cities` VALUES ('278', '460100', '海口市', '21', 'h', 'hks', 'haikoushi');
INSERT INTO `region_cities` VALUES ('279', '460200', '三亚市', '21', 's', 'sys', 'sanyashi');
INSERT INTO `region_cities` VALUES ('28', '120115', '宝坻区', '2', 'b', 'bcq', 'baochiqu');
INSERT INTO `region_cities` VALUES ('280', '460300', '三沙市', '21', 's', 'sss', 'sanshashi');
INSERT INTO `region_cities` VALUES ('281', '469000', '省直辖县级行政区划', '21', 's', 'szxxjxzqh', 'shengzhixiaxianjixingzhengquhua');
INSERT INTO `region_cities` VALUES ('282', '500101', '万州区', '22', 'w', 'wzq', 'wanzhouqu');
INSERT INTO `region_cities` VALUES ('283', '500102', '涪陵区', '22', 'f', 'flq', 'fulingqu');
INSERT INTO `region_cities` VALUES ('284', '500103', '渝中区', '22', 'y', 'yzq', 'yuzhongqu');
INSERT INTO `region_cities` VALUES ('285', '500104', '大渡口区', '22', 'd', 'ddkq', 'dadukouqu');
INSERT INTO `region_cities` VALUES ('286', '500105', '江北区', '22', 'j', 'jbq', 'jiangbeiqu');
INSERT INTO `region_cities` VALUES ('287', '500106', '沙坪坝区', '22', 's', 'spbq', 'shapingbaqu');
INSERT INTO `region_cities` VALUES ('288', '500107', '九龙坡区', '22', 'j', 'jlpq', 'jiulongpoqu');
INSERT INTO `region_cities` VALUES ('289', '500108', '南岸区', '22', 'n', 'naq', 'nananqu');
INSERT INTO `region_cities` VALUES ('29', '120116', '滨海新区', '2', 'b', 'bhxq', 'binhaixinqu');
INSERT INTO `region_cities` VALUES ('290', '500109', '北碚区', '22', 'b', 'bbq', 'beibeiqu');
INSERT INTO `region_cities` VALUES ('291', '500110', '綦江区', '22', 'q', 'qjq', 'qijiangqu');
INSERT INTO `region_cities` VALUES ('292', '500111', '大足区', '22', 'd', 'dzq', 'dazuqu');
INSERT INTO `region_cities` VALUES ('293', '500112', '渝北区', '22', 'y', 'ybq', 'yubeiqu');
INSERT INTO `region_cities` VALUES ('294', '500113', '巴南区', '22', 'b', 'bnq', 'bananqu');
INSERT INTO `region_cities` VALUES ('295', '500114', '黔江区', '22', 'q', 'qjq', 'qianjiangqu');
INSERT INTO `region_cities` VALUES ('296', '500115', '长寿区', '22', 'z', 'zsq', 'zhangshouqu');
INSERT INTO `region_cities` VALUES ('297', '500116', '江津区', '22', 'j', 'jjq', 'jiangjinqu');
INSERT INTO `region_cities` VALUES ('298', '500117', '合川区', '22', 'h', 'hcq', 'hechuanqu');
INSERT INTO `region_cities` VALUES ('299', '500118', '永川区', '22', 'y', 'ycq', 'yongchuanqu');
INSERT INTO `region_cities` VALUES ('3', '110105', '朝阳区', '1', 'c', 'cyq', 'chaoyangqu');
INSERT INTO `region_cities` VALUES ('30', '120221', '宁河县', '2', 'n', 'nhx', 'ninghexian');
INSERT INTO `region_cities` VALUES ('300', '500119', '南川区', '22', 'n', 'ncq', 'nanchuanqu');
INSERT INTO `region_cities` VALUES ('301', '500120', '璧山区', '22', 'b', 'bsq', 'bishanqu');
INSERT INTO `region_cities` VALUES ('302', '500151', '铜梁区', '22', 't', 'tlq', 'tongliangqu');
INSERT INTO `region_cities` VALUES ('303', '500223', '潼南县', '22', 't', 'tnx', 'tongnanxian');
INSERT INTO `region_cities` VALUES ('304', '500226', '荣昌县', '22', 'r', 'rcx', 'rongchangxian');
INSERT INTO `region_cities` VALUES ('305', '500228', '梁平县', '22', 'l', 'lpx', 'liangpingxian');
INSERT INTO `region_cities` VALUES ('306', '500229', '城口县', '22', 'c', 'ckx', 'chengkouxian');
INSERT INTO `region_cities` VALUES ('307', '500230', '丰都县', '22', 'f', 'fdx', 'fengdouxian');
INSERT INTO `region_cities` VALUES ('308', '500231', '垫江县', '22', 'd', 'djx', 'dianjiangxian');
INSERT INTO `region_cities` VALUES ('309', '500232', '武隆县', '22', 'w', 'wlx', 'wulongxian');
INSERT INTO `region_cities` VALUES ('31', '120223', '静海县', '2', 'j', 'jhx', 'jinghaixian');
INSERT INTO `region_cities` VALUES ('310', '500233', '忠县', '22', 'z', 'zx', 'zhongxian');
INSERT INTO `region_cities` VALUES ('311', '500234', '开县', '22', 'k', 'kx', 'kaixian');
INSERT INTO `region_cities` VALUES ('312', '500235', '云阳县', '22', 'y', 'yyx', 'yunyangxian');
INSERT INTO `region_cities` VALUES ('313', '500236', '奉节县', '22', 'f', 'fjx', 'fengjiexian');
INSERT INTO `region_cities` VALUES ('314', '500237', '巫山县', '22', 'w', 'wsx', 'wushanxian');
INSERT INTO `region_cities` VALUES ('315', '500238', '巫溪县', '22', 'w', 'wxx', 'wuxixian');
INSERT INTO `region_cities` VALUES ('316', '500240', '石柱土家族自治县', '22', 's', 'sztjzzzx', 'shizhutujiazuzizhixian');
INSERT INTO `region_cities` VALUES ('317', '500241', '秀山土家族苗族自治县', '22', 'x', 'xstjzmzzzx', 'xiushantujiazumiaozuzizhixian');
INSERT INTO `region_cities` VALUES ('318', '500242', '酉阳土家族苗族自治县', '22', 'y', 'yytjzmzzzx', 'youyangtujiazumiaozuzizhixian');
INSERT INTO `region_cities` VALUES ('319', '500243', '彭水苗族土家族自治县', '22', 'p', 'psmztjzzzx', 'pengshuimiaozutujiazuzizhixian');
INSERT INTO `region_cities` VALUES ('32', '120225', '蓟县', '2', 'j', 'jx', 'jixian');
INSERT INTO `region_cities` VALUES ('320', '510100', '成都市', '23', 'c', 'cds', 'chengdoushi');
INSERT INTO `region_cities` VALUES ('321', '510300', '自贡市', '23', 'z', 'zgs', 'zigongshi');
INSERT INTO `region_cities` VALUES ('322', '510400', '攀枝花市', '23', 'p', 'pzhs', 'panzhihuashi');
INSERT INTO `region_cities` VALUES ('323', '510500', '泸州市', '23', 'l', 'lzs', 'luzhoushi');
INSERT INTO `region_cities` VALUES ('324', '510600', '德阳市', '23', 'd', 'dys', 'deyangshi');
INSERT INTO `region_cities` VALUES ('325', '510700', '绵阳市', '23', 'm', 'mys', 'mianyangshi');
INSERT INTO `region_cities` VALUES ('326', '510800', '广元市', '23', 'g', 'gys', 'guangyuanshi');
INSERT INTO `region_cities` VALUES ('327', '510900', '遂宁市', '23', 's', 'sns', 'suiningshi');
INSERT INTO `region_cities` VALUES ('328', '511000', '内江市', '23', 'n', 'njs', 'neijiangshi');
INSERT INTO `region_cities` VALUES ('329', '511100', '乐山市', '23', 'l', 'lss', 'leshanshi');
INSERT INTO `region_cities` VALUES ('33', '130100', '石家庄市', '3', 's', 'sjzs', 'shijiazhuangshi');
INSERT INTO `region_cities` VALUES ('330', '511300', '南充市', '23', 'n', 'ncs', 'nanchongshi');
INSERT INTO `region_cities` VALUES ('331', '511400', '眉山市', '23', 'm', 'mss', 'meishanshi');
INSERT INTO `region_cities` VALUES ('332', '511500', '宜宾市', '23', 'y', 'ybs', 'yibinshi');
INSERT INTO `region_cities` VALUES ('333', '511600', '广安市', '23', 'g', 'gas', 'guanganshi');
INSERT INTO `region_cities` VALUES ('334', '511700', '达州市', '23', 'd', 'dzs', 'dazhoushi');
INSERT INTO `region_cities` VALUES ('335', '511800', '雅安市', '23', 'y', 'yas', 'yaanshi');
INSERT INTO `region_cities` VALUES ('336', '511900', '巴中市', '23', 'b', 'bzs', 'bazhongshi');
INSERT INTO `region_cities` VALUES ('337', '512000', '资阳市', '23', 'z', 'zys', 'ziyangshi');
INSERT INTO `region_cities` VALUES ('338', '513200', '阿坝藏族羌族自治州', '23', 'a', 'abzzqzzzz', 'abazangzuqiangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('339', '513300', '甘孜藏族自治州', '23', 'g', 'gzzzzzz', 'ganzizangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('34', '130200', '唐山市', '3', 't', 'tss', 'tangshanshi');
INSERT INTO `region_cities` VALUES ('340', '513400', '凉山彝族自治州', '23', 'l', 'lsyzzzz', 'liangshanyizuzizhizhou');
INSERT INTO `region_cities` VALUES ('341', '520100', '贵阳市', '24', 'g', 'gys', 'guiyangshi');
INSERT INTO `region_cities` VALUES ('342', '520200', '六盘水市', '24', 'l', 'lpss', 'liupanshuishi');
INSERT INTO `region_cities` VALUES ('343', '520300', '遵义市', '24', 'z', 'zys', 'zunyishi');
INSERT INTO `region_cities` VALUES ('344', '520400', '安顺市', '24', 'a', 'ass', 'anshunshi');
INSERT INTO `region_cities` VALUES ('345', '520500', '毕节市', '24', 'b', 'bjs', 'bijieshi');
INSERT INTO `region_cities` VALUES ('346', '520600', '铜仁市', '24', 't', 'trs', 'tongrenshi');
INSERT INTO `region_cities` VALUES ('347', '522300', '黔西南布依族苗族自治州', '24', 'q', 'qxnbyzmzzzz', 'qianxinanbuyizumiaozuzizhizhou');
INSERT INTO `region_cities` VALUES ('348', '522600', '黔东南苗族侗族自治州', '24', 'q', 'qdnmzdzzzz', 'qiandongnanmiaozudongzuzizhizhou');
INSERT INTO `region_cities` VALUES ('349', '522700', '黔南布依族苗族自治州', '24', 'q', 'qnbyzmzzzz', 'qiannanbuyizumiaozuzizhizhou');
INSERT INTO `region_cities` VALUES ('35', '130300', '秦皇岛市', '3', 'q', 'qhds', 'qinhuangdaoshi');
INSERT INTO `region_cities` VALUES ('350', '530100', '昆明市', '25', 'k', 'kms', 'kunmingshi');
INSERT INTO `region_cities` VALUES ('351', '530300', '曲靖市', '25', 'q', 'qjs', 'qujingshi');
INSERT INTO `region_cities` VALUES ('352', '530400', '玉溪市', '25', 'y', 'yxs', 'yuxishi');
INSERT INTO `region_cities` VALUES ('353', '530500', '保山市', '25', 'b', 'bss', 'baoshanshi');
INSERT INTO `region_cities` VALUES ('354', '530600', '昭通市', '25', 'z', 'zts', 'zhaotongshi');
INSERT INTO `region_cities` VALUES ('355', '530700', '丽江市', '25', 'l', 'ljs', 'lijiangshi');
INSERT INTO `region_cities` VALUES ('356', '530800', '普洱市', '25', 'p', 'pes', 'puershi');
INSERT INTO `region_cities` VALUES ('357', '530900', '临沧市', '25', 'l', 'lcs', 'lincangshi');
INSERT INTO `region_cities` VALUES ('358', '532300', '楚雄彝族自治州', '25', 'c', 'cxyzzzz', 'chuxiongyizuzizhizhou');
INSERT INTO `region_cities` VALUES ('359', '532500', '红河哈尼族彝族自治州', '25', 'h', 'hhhnzyzzzz', 'honghehanizuyizuzizhizhou');
INSERT INTO `region_cities` VALUES ('36', '130400', '邯郸市', '3', 'h', 'hds', 'handanshi');
INSERT INTO `region_cities` VALUES ('360', '532600', '文山壮族苗族自治州', '25', 'w', 'wszzmzzzz', 'wenshanzhuangzumiaozuzizhizhou');
INSERT INTO `region_cities` VALUES ('361', '532800', '西双版纳傣族自治州', '25', 'x', 'xsbndzzzz', 'xishuangbannadaizuzizhizhou');
INSERT INTO `region_cities` VALUES ('362', '532900', '大理白族自治州', '25', 'd', 'dlbzzzz', 'dalibaizuzizhizhou');
INSERT INTO `region_cities` VALUES ('363', '533100', '德宏傣族景颇族自治州', '25', 'd', 'dhdzjpzzzz', 'dehongdaizujingpozuzizhizhou');
INSERT INTO `region_cities` VALUES ('364', '533300', '怒江傈僳族自治州', '25', 'n', 'njlszzzz', 'nujianglisuzuzizhizhou');
INSERT INTO `region_cities` VALUES ('365', '533400', '迪庆藏族自治州', '25', 'd', 'dqzzzzz', 'diqingzangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('366', '540100', '拉萨市', '26', 'l', 'lss', 'lasashi');
INSERT INTO `region_cities` VALUES ('367', '540200', '日喀则市', '26', 'r', 'rkzs', 'rikazeshi');
INSERT INTO `region_cities` VALUES ('368', '542100', '昌都地区', '26', 'c', 'cddq', 'changdoudiqu');
INSERT INTO `region_cities` VALUES ('369', '542200', '山南地区', '26', 's', 'sndq', 'shannandiqu');
INSERT INTO `region_cities` VALUES ('37', '130500', '邢台市', '3', 'x', 'xts', 'xingtaishi');
INSERT INTO `region_cities` VALUES ('370', '542400', '那曲地区', '26', 'n', 'nqdq', 'neiqudiqu');
INSERT INTO `region_cities` VALUES ('371', '542500', '阿里地区', '26', 'a', 'aldq', 'alidiqu');
INSERT INTO `region_cities` VALUES ('372', '542600', '林芝地区', '26', 'l', 'lzdq', 'linzhidiqu');
INSERT INTO `region_cities` VALUES ('373', '610100', '西安市', '27', 'x', 'xas', 'xianshi');
INSERT INTO `region_cities` VALUES ('374', '610200', '铜川市', '27', 't', 'tcs', 'tongchuanshi');
INSERT INTO `region_cities` VALUES ('375', '610300', '宝鸡市', '27', 'b', 'bjs', 'baojishi');
INSERT INTO `region_cities` VALUES ('376', '610400', '咸阳市', '27', 'x', 'xys', 'xianyangshi');
INSERT INTO `region_cities` VALUES ('377', '610500', '渭南市', '27', 'w', 'wns', 'weinanshi');
INSERT INTO `region_cities` VALUES ('378', '610600', '延安市', '27', 'y', 'yas', 'yananshi');
INSERT INTO `region_cities` VALUES ('379', '610700', '汉中市', '27', 'h', 'hzs', 'hanzhongshi');
INSERT INTO `region_cities` VALUES ('38', '130600', '保定市', '3', 'b', 'bds', 'baodingshi');
INSERT INTO `region_cities` VALUES ('380', '610800', '榆林市', '27', 'y', 'yls', 'yulinshi');
INSERT INTO `region_cities` VALUES ('381', '610900', '安康市', '27', 'a', 'aks', 'ankangshi');
INSERT INTO `region_cities` VALUES ('382', '611000', '商洛市', '27', 's', 'sls', 'shangluoshi');
INSERT INTO `region_cities` VALUES ('383', '620100', '兰州市', '28', 'l', 'lzs', 'lanzhoushi');
INSERT INTO `region_cities` VALUES ('384', '620200', '嘉峪关市', '28', 'j', 'jygs', 'jiayuguanshi');
INSERT INTO `region_cities` VALUES ('385', '620300', '金昌市', '28', 'j', 'jcs', 'jinchangshi');
INSERT INTO `region_cities` VALUES ('386', '620400', '白银市', '28', 'b', 'bys', 'baiyinshi');
INSERT INTO `region_cities` VALUES ('387', '620500', '天水市', '28', 't', 'tss', 'tianshuishi');
INSERT INTO `region_cities` VALUES ('388', '620600', '武威市', '28', 'w', 'wws', 'wuweishi');
INSERT INTO `region_cities` VALUES ('389', '620700', '张掖市', '28', 'z', 'zys', 'zhangyeshi');
INSERT INTO `region_cities` VALUES ('39', '130700', '张家口市', '3', 'z', 'zjks', 'zhangjiakoushi');
INSERT INTO `region_cities` VALUES ('390', '620800', '平凉市', '28', 'p', 'pls', 'pingliangshi');
INSERT INTO `region_cities` VALUES ('391', '620900', '酒泉市', '28', 'j', 'jqs', 'jiuquanshi');
INSERT INTO `region_cities` VALUES ('392', '621000', '庆阳市', '28', 'q', 'qys', 'qingyangshi');
INSERT INTO `region_cities` VALUES ('393', '621100', '定西市', '28', 'd', 'dxs', 'dingxishi');
INSERT INTO `region_cities` VALUES ('394', '621200', '陇南市', '28', 'l', 'lns', 'longnanshi');
INSERT INTO `region_cities` VALUES ('395', '622900', '临夏回族自治州', '28', 'l', 'lxhzzzz', 'linxiahuizuzizhizhou');
INSERT INTO `region_cities` VALUES ('396', '623000', '甘南藏族自治州', '28', 'g', 'gnzzzzz', 'gannanzangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('397', '630100', '西宁市', '29', 'x', 'xns', 'xiningshi');
INSERT INTO `region_cities` VALUES ('398', '630200', '海东市', '29', 'h', 'hds', 'haidongshi');
INSERT INTO `region_cities` VALUES ('399', '632200', '海北藏族自治州', '29', 'h', 'hbzzzzz', 'haibeizangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('4', '110106', '丰台区', '1', 'f', 'ftq', 'fengtaiqu');
INSERT INTO `region_cities` VALUES ('40', '130800', '承德市', '3', 'c', 'cds', 'chengdeshi');
INSERT INTO `region_cities` VALUES ('400', '632300', '黄南藏族自治州', '29', 'h', 'hnzzzzz', 'huangnanzangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('401', '632500', '海南藏族自治州', '29', 'h', 'hnzzzzz', 'hainanzangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('402', '632600', '果洛藏族自治州', '29', 'g', 'glzzzzz', 'guoluozangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('403', '632700', '玉树藏族自治州', '29', 'y', 'yszzzzz', 'yushuzangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('404', '632800', '海西蒙古族藏族自治州', '29', 'h', 'hxmgzzzzzz', 'haiximengguzuzangzuzizhizhou');
INSERT INTO `region_cities` VALUES ('405', '640100', '银川市', '30', 'y', 'ycs', 'yinchuanshi');
INSERT INTO `region_cities` VALUES ('406', '640200', '石嘴山市', '30', 's', 'szss', 'shizuishanshi');
INSERT INTO `region_cities` VALUES ('407', '640300', '吴忠市', '30', 'w', 'wzs', 'wuzhongshi');
INSERT INTO `region_cities` VALUES ('408', '640400', '固原市', '30', 'g', 'gys', 'guyuanshi');
INSERT INTO `region_cities` VALUES ('409', '640500', '中卫市', '30', 'z', 'zws', 'zhongweishi');
INSERT INTO `region_cities` VALUES ('41', '130900', '沧州市', '3', 'c', 'czs', 'cangzhoushi');
INSERT INTO `region_cities` VALUES ('410', '650100', '乌鲁木齐市', '31', 'w', 'wlmqs', 'wulumuqishi');
INSERT INTO `region_cities` VALUES ('411', '650200', '克拉玛依市', '31', 'k', 'klmys', 'kelamayishi');
INSERT INTO `region_cities` VALUES ('412', '652100', '吐鲁番地区', '31', 't', 'tlfdq', 'tulufandiqu');
INSERT INTO `region_cities` VALUES ('413', '652200', '哈密地区', '31', 'h', 'hmdq', 'hamidiqu');
INSERT INTO `region_cities` VALUES ('414', '652300', '昌吉回族自治州', '31', 'c', 'cjhzzzz', 'changjihuizuzizhizhou');
INSERT INTO `region_cities` VALUES ('415', '652700', '博尔塔拉蒙古自治州', '31', 'b', 'betlmgzzz', 'boertalamengguzizhizhou');
INSERT INTO `region_cities` VALUES ('416', '652800', '巴音郭楞蒙古自治州', '31', 'b', 'byglmgzzz', 'bayinguolengmengguzizhizhou');
INSERT INTO `region_cities` VALUES ('417', '652900', '阿克苏地区', '31', 'a', 'aksdq', 'akesudiqu');
INSERT INTO `region_cities` VALUES ('418', '653000', '克孜勒苏柯尔克孜自治州', '31', 'k', 'kzlskekzzzz', 'kezilesukeerkezizizhizhou');
INSERT INTO `region_cities` VALUES ('419', '653100', '喀什地区', '31', 'k', 'ksdq', 'kashendiqu');
INSERT INTO `region_cities` VALUES ('42', '131000', '廊坊市', '3', 'l', 'lfs', 'langfangshi');
INSERT INTO `region_cities` VALUES ('420', '653200', '和田地区', '31', 'h', 'htdq', 'hetiandiqu');
INSERT INTO `region_cities` VALUES ('421', '654000', '伊犁哈萨克自治州', '31', 'y', 'ylhskzzz', 'yilihasakezizhizhou');
INSERT INTO `region_cities` VALUES ('422', '654200', '塔城地区', '31', 't', 'tcdq', 'tachengdiqu');
INSERT INTO `region_cities` VALUES ('423', '654300', '阿勒泰地区', '31', 'a', 'altdq', 'aletaidiqu');
INSERT INTO `region_cities` VALUES ('424', '659000', '自治区直辖县级行政区划', '31', 'z', 'zzqzxxjxzqh', 'zizhiquzhixiaxianjixingzhengquhua');
INSERT INTO `region_cities` VALUES ('43', '131100', '衡水市', '3', 'h', 'hss', 'hengshuishi');
INSERT INTO `region_cities` VALUES ('44', '140100', '太原市', '4', 't', 'tys', 'taiyuanshi');
INSERT INTO `region_cities` VALUES ('45', '140200', '大同市', '4', 'd', 'dts', 'datongshi');
INSERT INTO `region_cities` VALUES ('46', '140300', '阳泉市', '4', 'y', 'yqs', 'yangquanshi');
INSERT INTO `region_cities` VALUES ('47', '140400', '长治市', '4', 'z', 'zzs', 'zhangzhishi');
INSERT INTO `region_cities` VALUES ('48', '140500', '晋城市', '4', 'j', 'jcs', 'jinchengshi');
INSERT INTO `region_cities` VALUES ('49', '140600', '朔州市', '4', 's', 'szs', 'shuozhoushi');
INSERT INTO `region_cities` VALUES ('5', '110107', '石景山区', '1', 's', 'sjsq', 'shijingshanqu');
INSERT INTO `region_cities` VALUES ('50', '140700', '晋中市', '4', 'j', 'jzs', 'jinzhongshi');
INSERT INTO `region_cities` VALUES ('51', '140800', '运城市', '4', 'y', 'ycs', 'yunchengshi');
INSERT INTO `region_cities` VALUES ('52', '140900', '忻州市', '4', 'x', 'xzs', 'xinzhoushi');
INSERT INTO `region_cities` VALUES ('53', '141000', '临汾市', '4', 'l', 'lfs', 'linfenshi');
INSERT INTO `region_cities` VALUES ('54', '141100', '吕梁市', '4', 'l', 'lls', 'lu:liangshi');
INSERT INTO `region_cities` VALUES ('55', '150100', '呼和浩特市', '5', 'h', 'hhhts', 'huhehaoteshi');
INSERT INTO `region_cities` VALUES ('56', '150200', '包头市', '5', 'b', 'bts', 'baotoushi');
INSERT INTO `region_cities` VALUES ('57', '150300', '乌海市', '5', 'w', 'whs', 'wuhaishi');
INSERT INTO `region_cities` VALUES ('58', '150400', '赤峰市', '5', 'c', 'cfs', 'chifengshi');
INSERT INTO `region_cities` VALUES ('59', '150500', '通辽市', '5', 't', 'tls', 'tongliaoshi');
INSERT INTO `region_cities` VALUES ('6', '110108', '海淀区', '1', 'h', 'hdq', 'haidianqu');
INSERT INTO `region_cities` VALUES ('60', '150600', '鄂尔多斯市', '5', 'e', 'eedss', 'eerduosishi');
INSERT INTO `region_cities` VALUES ('61', '150700', '呼伦贝尔市', '5', 'h', 'hlbes', 'hulunbeiershi');
INSERT INTO `region_cities` VALUES ('62', '150800', '巴彦淖尔市', '5', 'b', 'bynes', 'bayannaoershi');
INSERT INTO `region_cities` VALUES ('63', '150900', '乌兰察布市', '5', 'w', 'wlcbs', 'wulanchabushi');
INSERT INTO `region_cities` VALUES ('64', '152200', '兴安盟', '5', 'x', 'xam', 'xinganmeng');
INSERT INTO `region_cities` VALUES ('65', '152500', '锡林郭勒盟', '5', 'x', 'xlglm', 'xilinguolemeng');
INSERT INTO `region_cities` VALUES ('66', '152900', '阿拉善盟', '5', 'a', 'alsm', 'alashanmeng');
INSERT INTO `region_cities` VALUES ('67', '210100', '沈阳市', '6', 's', 'sys', 'shenyangshi');
INSERT INTO `region_cities` VALUES ('68', '210200', '大连市', '6', 'd', 'dls', 'dalianshi');
INSERT INTO `region_cities` VALUES ('69', '210300', '鞍山市', '6', 'a', 'ass', 'anshanshi');
INSERT INTO `region_cities` VALUES ('7', '110109', '门头沟区', '1', 'm', 'mtgq', 'mentougouqu');
INSERT INTO `region_cities` VALUES ('70', '210400', '抚顺市', '6', 'f', 'fss', 'fushunshi');
INSERT INTO `region_cities` VALUES ('71', '210500', '本溪市', '6', 'b', 'bxs', 'benxishi');
INSERT INTO `region_cities` VALUES ('72', '210600', '丹东市', '6', 'd', 'dds', 'dandongshi');
INSERT INTO `region_cities` VALUES ('73', '210700', '锦州市', '6', 'j', 'jzs', 'jinzhoushi');
INSERT INTO `region_cities` VALUES ('74', '210800', '营口市', '6', 'y', 'yks', 'yingkoushi');
INSERT INTO `region_cities` VALUES ('75', '210900', '阜新市', '6', 'f', 'fxs', 'fuxinshi');
INSERT INTO `region_cities` VALUES ('76', '211000', '辽阳市', '6', 'l', 'lys', 'liaoyangshi');
INSERT INTO `region_cities` VALUES ('77', '211100', '盘锦市', '6', 'p', 'pjs', 'panjinshi');
INSERT INTO `region_cities` VALUES ('78', '211200', '铁岭市', '6', 't', 'tls', 'tielingshi');
INSERT INTO `region_cities` VALUES ('79', '211300', '朝阳市', '6', 'c', 'cys', 'chaoyangshi');
INSERT INTO `region_cities` VALUES ('8', '110111', '房山区', '1', 'f', 'fsq', 'fangshanqu');
INSERT INTO `region_cities` VALUES ('80', '211400', '葫芦岛市', '6', 'h', 'hlds', 'huludaoshi');
INSERT INTO `region_cities` VALUES ('81', '220100', '长春市', '7', 'z', 'zcs', 'zhangchunshi');
INSERT INTO `region_cities` VALUES ('82', '220200', '吉林市', '7', 'j', 'jls', 'jilinshi');
INSERT INTO `region_cities` VALUES ('83', '220300', '四平市', '7', 's', 'sps', 'sipingshi');
INSERT INTO `region_cities` VALUES ('84', '220400', '辽源市', '7', 'l', 'lys', 'liaoyuanshi');
INSERT INTO `region_cities` VALUES ('85', '220500', '通化市', '7', 't', 'ths', 'tonghuashi');
INSERT INTO `region_cities` VALUES ('86', '220600', '白山市', '7', 'b', 'bss', 'baishanshi');
INSERT INTO `region_cities` VALUES ('87', '220700', '松原市', '7', 's', 'sys', 'songyuanshi');
INSERT INTO `region_cities` VALUES ('88', '220800', '白城市', '7', 'b', 'bcs', 'baichengshi');
INSERT INTO `region_cities` VALUES ('89', '222400', '延边朝鲜族自治州', '7', 'y', 'ybcxzzzz', 'yanbianchaoxianzuzizhizhou');
INSERT INTO `region_cities` VALUES ('9', '110112', '通州区', '1', 't', 'tzq', 'tongzhouqu');
INSERT INTO `region_cities` VALUES ('90', '230100', '哈尔滨市', '8', 'h', 'hebs', 'haerbinshi');
INSERT INTO `region_cities` VALUES ('91', '230200', '齐齐哈尔市', '8', 'q', 'qqhes', 'qiqihaershi');
INSERT INTO `region_cities` VALUES ('92', '230300', '鸡西市', '8', 'j', 'jxs', 'jixishi');
INSERT INTO `region_cities` VALUES ('93', '230400', '鹤岗市', '8', 'h', 'hgs', 'hegangshi');
INSERT INTO `region_cities` VALUES ('94', '230500', '双鸭山市', '8', 's', 'syss', 'shuangyashanshi');
INSERT INTO `region_cities` VALUES ('95', '230600', '大庆市', '8', 'd', 'dqs', 'daqingshi');
INSERT INTO `region_cities` VALUES ('96', '230700', '伊春市', '8', 'y', 'ycs', 'yichunshi');
INSERT INTO `region_cities` VALUES ('97', '230800', '佳木斯市', '8', 'j', 'jmss', 'jiamusishi');
INSERT INTO `region_cities` VALUES ('98', '230900', '七台河市', '8', 'q', 'qths', 'qitaiheshi');
INSERT INTO `region_cities` VALUES ('99', '231000', '牡丹江市', '8', 'm', 'mdjs', 'mudanjiangshi');

-- ----------------------------
-- Table structure for region_countries
-- ----------------------------
DROP TABLE IF EXISTS `region_countries`;
CREATE TABLE `region_countries` (
  `id` varchar(64) NOT NULL COMMENT '主键',
  `country_code` varchar(20) NOT NULL DEFAULT '' COMMENT '地区代码',
  `country` varchar(50) NOT NULL DEFAULT '' COMMENT '城市名称',
  `initial` varchar(20) NOT NULL DEFAULT '' COMMENT '地区拼音首写字母',
  `initials` varchar(60) NOT NULL DEFAULT '' COMMENT '地区拼音首写字母组合',
  `pinyin` varchar(300) NOT NULL DEFAULT '' COMMENT '地区拼音全拼',
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_code` (`country_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='国家列表';

-- ----------------------------
-- Records of region_countries
-- ----------------------------
INSERT INTO `region_countries` VALUES ('1', 'CN', '中国', 'z', 'zg', 'zhongguo');

-- ----------------------------
-- Table structure for region_provinces
-- ----------------------------
DROP TABLE IF EXISTS `region_provinces`;
CREATE TABLE `region_provinces` (
  `id` varchar(64) NOT NULL COMMENT 'ID',
  `province_code` varchar(20) NOT NULL DEFAULT '' COMMENT '地区代码',
  `province` varchar(50) NOT NULL DEFAULT '' COMMENT '省份名称',
  `country_id` int(11) NOT NULL COMMENT '国家ID',
  `initial` varchar(20) NOT NULL DEFAULT '' COMMENT '地区拼音首写字母',
  `initials` varchar(60) NOT NULL DEFAULT '' COMMENT '地区拼音首写字母组合',
  `pinyin` varchar(300) NOT NULL DEFAULT '' COMMENT '地区拼音全拼',
  PRIMARY KEY (`id`),
  UNIQUE KEY `province_code` (`province_code`),
  KEY `fk_provinces_countries` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='省份表';

-- ----------------------------
-- Records of region_provinces
-- ----------------------------
INSERT INTO `region_provinces` VALUES ('1', '110000', '北京市', '1', 'b', 'bjs', 'beijingshi');
INSERT INTO `region_provinces` VALUES ('10', '320000', '江苏省', '1', 'j', 'jss', 'jiangsusheng');
INSERT INTO `region_provinces` VALUES ('11', '330000', '浙江省', '1', 'z', 'zjs', 'zhejiangsheng');
INSERT INTO `region_provinces` VALUES ('12', '340000', '安徽省', '1', 'a', 'ahs', 'anhuisheng');
INSERT INTO `region_provinces` VALUES ('13', '350000', '福建省', '1', 'f', 'fjs', 'fujiansheng');
INSERT INTO `region_provinces` VALUES ('14', '360000', '江西省', '1', 'j', 'jxs', 'jiangxisheng');
INSERT INTO `region_provinces` VALUES ('15', '370000', '山东省', '1', 's', 'sds', 'shandongsheng');
INSERT INTO `region_provinces` VALUES ('16', '410000', '河南省', '1', 'h', 'hns', 'henansheng');
INSERT INTO `region_provinces` VALUES ('17', '420000', '湖北省', '1', 'h', 'hbs', 'hubeisheng');
INSERT INTO `region_provinces` VALUES ('18', '430000', '湖南省', '1', 'h', 'hns', 'hunansheng');
INSERT INTO `region_provinces` VALUES ('19', '440000', '广东省', '1', 'g', 'gds', 'guangdongsheng');
INSERT INTO `region_provinces` VALUES ('2', '120000', '天津市', '1', 't', 'tjs', 'tianjinshi');
INSERT INTO `region_provinces` VALUES ('20', '450000', '广西壮族自治区', '1', 'g', 'gxzzzzq', 'guangxizhuangzuzizhiqu');
INSERT INTO `region_provinces` VALUES ('21', '460000', '海南省', '1', 'h', 'hns', 'hainansheng');
INSERT INTO `region_provinces` VALUES ('22', '500000', '重庆市', '1', 'c', 'cqs', 'chongqingshi');
INSERT INTO `region_provinces` VALUES ('23', '510000', '四川省', '1', 's', 'scs', 'sichuansheng');
INSERT INTO `region_provinces` VALUES ('24', '520000', '贵州省', '1', 'g', 'gzs', 'guizhousheng');
INSERT INTO `region_provinces` VALUES ('25', '530000', '云南省', '1', 'y', 'yns', 'yunnansheng');
INSERT INTO `region_provinces` VALUES ('26', '540000', '西藏自治区', '1', 'x', 'xzzzq', 'xizangzizhiqu');
INSERT INTO `region_provinces` VALUES ('27', '610000', '陕西省', '1', 's', 'sxs', 'shanxisheng');
INSERT INTO `region_provinces` VALUES ('28', '620000', '甘肃省', '1', 'g', 'gss', 'gansusheng');
INSERT INTO `region_provinces` VALUES ('29', '630000', '青海省', '1', 'q', 'qhs', 'qinghaisheng');
INSERT INTO `region_provinces` VALUES ('3', '130000', '河北省', '1', 'h', 'hbs', 'hebeisheng');
INSERT INTO `region_provinces` VALUES ('30', '640000', '宁夏回族自治区', '1', 'n', 'nxhzzzq', 'ningxiahuizuzizhiqu');
INSERT INTO `region_provinces` VALUES ('31', '650000', '新疆维吾尔自治区', '1', 'x', 'xjwwezzq', 'xinjiangweiwuerzizhiqu');
INSERT INTO `region_provinces` VALUES ('4', '140000', '山西省', '1', 's', 'sxs', 'shanxisheng');
INSERT INTO `region_provinces` VALUES ('5', '150000', '内蒙古自治区', '1', 'n', 'nmgzzq', 'neimengguzizhiqu');
INSERT INTO `region_provinces` VALUES ('6', '210000', '辽宁省', '1', 'l', 'lns', 'liaoningsheng');
INSERT INTO `region_provinces` VALUES ('7', '220000', '吉林省', '1', 'j', 'jls', 'jilinsheng');
INSERT INTO `region_provinces` VALUES ('8', '230000', '黑龙江省', '1', 'h', 'hljs', 'heilongjiangsheng');
INSERT INTO `region_provinces` VALUES ('9', '310000', '上海市', '1', 's', 'shs', 'shanghaishi');

-- ----------------------------
-- Table structure for sms_verif_codes
-- ----------------------------
DROP TABLE IF EXISTS `sms_verif_codes`;
CREATE TABLE `sms_verif_codes` (
  `id` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'ID',
  `app_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '0000' COMMENT 'APP唯一编号 0000为后端注册用户',
  `mobile` varchar(20) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '手机号',
  `verif_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '验证码',
  `clientip` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '注册IP',
  `send_status` varchar(10) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '用户状态 1 成功 0 失败',
  `create_time` datetime NOT NULL COMMENT '生成时间 秒数',
  PRIMARY KEY (`id`),
  KEY `mobile_verif_code` (`mobile`,`verif_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='验证发送记录表';

-- ----------------------------
-- Records of sms_verif_codes
-- ----------------------------
INSERT INTO `sms_verif_codes` VALUES ('14078752186965724191', '1001', '13357826761', '233456', '0:0:0:0:0:0:0:1', 'OK', '2017-11-05 22:40:31');
INSERT INTO `sms_verif_codes` VALUES ('14265292685778928264', '1001', '13357826761', '233456', '0:0:0:0:0:0:0:1', 'OK', '2017-11-05 22:43:37');
INSERT INTO `sms_verif_codes` VALUES ('14866316954449254830', '1001', '13357826761', '233456', '0:0:0:0:0:0:0:1', 'OK', '2017-11-05 22:53:38');

-- ----------------------------
-- Table structure for sys_area
-- ----------------------------
DROP TABLE IF EXISTS `sys_area`;
CREATE TABLE `sys_area` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `parent_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '父级编号',
  `parent_ids` varchar(2000) COLLATE utf8_bin NOT NULL COMMENT '所有父级编号',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '名称',
  `sort` decimal(10,0) NOT NULL COMMENT '排序',
  `code` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '区域编码',
  `type` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '区域类型',
  `create_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_area_parent_id` (`parent_id`),
  KEY `sys_area_del_flag` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='区域表';

-- ----------------------------
-- Records of sys_area
-- ----------------------------
INSERT INTO `sys_area` VALUES ('100000', '0', '0,', '中国', '10', '100000', '1', '1', '2016-07-11 19:24:14', '1', '2016-07-11 19:24:22', null, '0');

-- ----------------------------
-- Table structure for sys_dict
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict`;
CREATE TABLE `sys_dict` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `value` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '数据值',
  `label` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '标签名',
  `type` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '类型',
  `description` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '描述',
  `sort` decimal(10,0) NOT NULL COMMENT '排序（升序）',
  `parent_id` varchar(64) COLLATE utf8_bin DEFAULT '0' COMMENT '父级编号',
  `create_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_dict_value` (`value`),
  KEY `sys_dict_label` (`label`),
  KEY `sys_dict_del_flag` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='字典表';

-- ----------------------------
-- Records of sys_dict
-- ----------------------------
INSERT INTO `sys_dict` VALUES ('1', '0', '正常', 'del_flag', '删除标记', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('10', 'yellow', '黄色', 'color', '颜色值', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('105', '1', '会议通告\0\0\0\0', 'oa_notify_type', '通知通告类型', '10', '0', '1', '2013-11-08 08:00:00', '1', '2013-11-08 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('106', '2', '奖惩通告\0\0\0\0', 'oa_notify_type', '通知通告类型', '20', '0', '1', '2013-11-08 08:00:00', '1', '2013-11-08 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('107', '3', '活动通告\0\0\0\0', 'oa_notify_type', '通知通告类型', '30', '0', '1', '2013-11-08 08:00:00', '1', '2013-11-08 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('108', '0', '草稿', 'oa_notify_status', '通知通告状态', '10', '0', '1', '2013-11-08 08:00:00', '1', '2013-11-08 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('109', '1', '发布', 'oa_notify_status', '通知通告状态', '20', '0', '1', '2013-11-08 08:00:00', '1', '2013-11-08 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('11', 'orange', '橙色', 'color', '颜色值', '50', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('110', '0', '未读', 'oa_notify_read', '通知通告状态', '10', '0', '1', '2013-11-08 08:00:00', '1', '2013-11-08 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('111', '1', '已读', 'oa_notify_read', '通知通告状态', '20', '0', '1', '2013-11-08 08:00:00', '1', '2013-11-08 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('12', 'default', '默认主题', 'theme', '主题方案', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('13', 'cerulean', '天蓝主题', 'theme', '主题方案', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('14', 'readable', '橙色主题', 'theme', '主题方案', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('15', 'united', '红色主题', 'theme', '主题方案', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('16', 'flat', 'Flat主题', 'theme', '主题方案', '60', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('17', '1', '国家', 'sys_area_type', '区域类型', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('18', '2', '省份、直辖市', 'sys_area_type', '区域类型', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('19', '3', '地市', 'sys_area_type', '区域类型', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('2', '1', '删除', 'del_flag', '删除标记', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('20', '4', '区县', 'sys_area_type', '区域类型', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('21', '1', '公司', 'sys_office_type', '机构类型', '60', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('22', '2', '部门', 'sys_office_type', '机构类型', '70', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('23', '3', '小组', 'sys_office_type', '机构类型', '80', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('24', '4', '其它', 'sys_office_type', '机构类型', '90', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('25', '1', '综合部', 'sys_office_common', '快捷通用部门', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('26', '2', '开发部', 'sys_office_common', '快捷通用部门', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('27', '3', '人力部', 'sys_office_common', '快捷通用部门', '50', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('28', '1', '一级', 'sys_office_grade', '机构等级', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('29', '2', '二级', 'sys_office_grade', '机构等级', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('3', '1', '显示', 'show_hide', '显示/隐藏', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('30', '3', '三级', 'sys_office_grade', '机构等级', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('31', '4', '四级', 'sys_office_grade', '机构等级', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('32', '1', '所有数据', 'sys_data_scope', '数据范围', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('33', '2', '所在公司及以下数据', 'sys_data_scope', '数据范围', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('34', '3', '所在公司数据', 'sys_data_scope', '数据范围', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('35', '4', '所在部门及以下数据', 'sys_data_scope', '数据范围', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('36', '5', '所在部门数据', 'sys_data_scope', '数据范围', '50', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('37', '8', '仅本人数据', 'sys_data_scope', '数据范围', '90', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('38', '9', '按明细设置', 'sys_data_scope', '数据范围', '100', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('39', '1', '系统管理', 'sys_user_type', '用户类型', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('4', '0', '隐藏', 'show_hide', '显示/隐藏', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('40', '2', '部门经理', 'sys_user_type', '用户类型', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('41', '3', '普通用户', 'sys_user_type', '用户类型', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('42', 'basic', '基础主题', 'cms_theme', '站点主题', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('45', 'article', '文章模型', 'cms_module', '栏目模型', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('48', 'link', '链接模型', 'cms_module', '栏目模型', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('5', '1', '是', 'yes_no', '是/否', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('50', '0', '默认展现方式', 'cms_show_modes', '展现方式', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('51', '1', '首栏目内容列表', 'cms_show_modes', '展现方式', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('52', '2', '栏目第一条内容', 'cms_show_modes', '展现方式', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('53', '0', '发布', 'cms_del_flag', '内容状态', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('54', '1', '删除', 'cms_del_flag', '内容状态', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('55', '2', '审核', 'cms_del_flag', '内容状态', '15', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('56', '1', '首页焦点图', 'cms_posid', '推荐位', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('57', '2', '栏目页文章推荐', 'cms_posid', '推荐位', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('58', '1', '咨询', 'cms_guestbook', '留言板分类', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('59', '2', '建议', 'cms_guestbook', '留言板分类', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('6', '0', '否', 'yes_no', '是/否', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('60', '3', '投诉', 'cms_guestbook', '留言板分类', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('61', '4', '其它', 'cms_guestbook', '留言板分类', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('62', '1', '公休', 'oa_leave_type', '请假类型', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('63', '2', '病假', 'oa_leave_type', '请假类型', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('64', '3', '事假', 'oa_leave_type', '请假类型', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('65', '4', '调休', 'oa_leave_type', '请假类型', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('66', '5', '婚假', 'oa_leave_type', '请假类型', '60', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('67', '1', '接入日志', 'sys_log_type', '日志类型', '30', '0', '1', '2013-06-03 08:00:00', '1', '2013-06-03 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('68', '2', '异常日志', 'sys_log_type', '日志类型', '40', '0', '1', '2013-06-03 08:00:00', '1', '2013-06-03 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('69', 'leave', '请假流程', 'act_type', '流程类型', '10', '0', '1', '2013-06-03 08:00:00', '1', '2013-06-03 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('7', 'red', '红色', 'color', '颜色值', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('70', 'test_audit', '审批测试流程', 'act_type', '流程类型', '20', '0', '1', '2013-06-03 08:00:00', '1', '2013-06-03 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('71', '1', '分类1', 'act_category', '流程分类', '10', '0', '1', '2013-06-03 08:00:00', '1', '2013-06-03 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('72', '2', '分类2', 'act_category', '流程分类', '20', '0', '1', '2013-06-03 08:00:00', '1', '2013-06-03 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('8', 'green', '绿色', 'color', '颜色值', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('9', 'blue', '蓝色', 'color', '颜色值', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('96', '1', '男', 'sex', '性别', '10', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', null, '0');
INSERT INTO `sys_dict` VALUES ('97', '2', '女', 'sex', '性别', '20', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', null, '0');

-- ----------------------------
-- Table structure for sys_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_log`;
CREATE TABLE `sys_log` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `type` char(1) COLLATE utf8_bin DEFAULT '1' COMMENT '日志类型',
  `title` varchar(255) COLLATE utf8_bin DEFAULT '' COMMENT '日志标题',
  `create_by` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `remote_addr` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '操作IP地址',
  `user_agent` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '用户代理',
  `request_uri` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '请求URI',
  `method` varchar(5) COLLATE utf8_bin DEFAULT NULL COMMENT '操作方式',
  `params` text COLLATE utf8_bin COMMENT '操作提交的数据',
  `exception` text COLLATE utf8_bin COMMENT '异常信息',
  PRIMARY KEY (`id`),
  KEY `sys_log_create_by` (`create_by`),
  KEY `sys_log_request_uri` (`request_uri`),
  KEY `sys_log_type` (`type`),
  KEY `sys_log_create_date` (`create_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='日志表';

-- ----------------------------
-- Records of sys_log
-- ----------------------------
INSERT INTO `sys_log` VALUES ('168494377009233851337', '1', '系统登录', '1', '2017-05-03 14:45:23', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/ejweb-manage/admin;JSESSIONID=168493022639793001710', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('169109618983261105575', '1', '系统登录', '1', '2017-05-03 14:55:38', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/ejweb-manage/admin/sys/log', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('169717596484900090220', '1', '系统登录', '1', '2017-05-03 15:05:46', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/ejweb-manage/admin/cms/article/form', 'GET', 0x69643D3130, '');
INSERT INTO `sys_log` VALUES ('170327845580307508353', '1', '系统登录', '1', '2017-05-03 15:15:56', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/ejweb-manage/admin/sys/area/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('172325847933689373934', '1', '系统登录', '1', '2017-05-03 15:49:14', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/ejweb-manage/admin/cms/article/form', 'GET', 0x69643D3130, '');
INSERT INTO `sys_log` VALUES ('172942567392565332721', '1', '系统登录', '1', '2017-05-03 15:59:31', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/ejweb-manage/admin/cms/article/form', 'GET', 0x69643D3339, '');
INSERT INTO `sys_log` VALUES ('173623673950548528118', '1', '系统登录', '1', '2017-05-03 16:10:52', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/ejweb-manage/admin/cms/comment/', 'GET', 0x7374617475733D32, '');
INSERT INTO `sys_log` VALUES ('243445310560272482278', '1', '系统登录', '1', '2017-05-04 11:34:32', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', '/ejweb-manage/admin;JSESSIONID=243444169787192816066', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('248819574080958603529', '1', '系统登录', '1', '2017-05-04 13:04:05', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', '/ejweb-manage/admin;JSESSIONID=248818173480622855689', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('249277651817223557002', '1', '系统登录', '1', '2017-05-04 13:11:43', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', '/ejweb-manage/admin/cms/article/', 'GET', 0x63617465676F72792E69643D37, '');
INSERT INTO `sys_log` VALUES ('250009877779801519764', '1', '系统登录', '1', '2017-05-04 13:23:55', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', '/ejweb-manage/admin/cms/link/', 'GET', 0x63617465676F72792E69643D3139, '');
INSERT INTO `sys_log` VALUES ('250609449952612004988', '1', '系统登录', '1', '2017-05-04 13:33:55', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', '/ejweb-manage/admin/sys/menu/tree', 'GET', 0x706172656E7449643D32, '');
INSERT INTO `sys_log` VALUES ('264971335586632615864', '1', '系统登录', '1', '2017-05-04 17:33:17', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', '/ejweb-manage/admin;JSESSIONID=264970572898144272133', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('330159597448850677572', '1', '系统登录', '1', '2017-05-05 11:39:44', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', '/manage/admin', 'GET', 0x6C6F67696E3D, '');
INSERT INTO `sys_log` VALUES ('330254801397411703267', '1', '系统登录', '1', '2017-05-05 11:41:19', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', '/manage/admin', 'GET', 0x6C6F67696E3D, '');

-- ----------------------------
-- Table structure for sys_login_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_login_log`;
CREATE TABLE `sys_login_log` (
  `login_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `type` varchar(64) COLLATE utf8_bin DEFAULT 'LOGIN' COMMENT 'LOGIN 登录 LOGOUT 退出',
  `user_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '用户ID',
  `platform` varchar(50) COLLATE utf8_bin DEFAULT 'Unknown' COMMENT '应用平台 Android iOS HTML5 Weixin',
  `app_code` varchar(50) COLLATE utf8_bin DEFAULT '0000' COMMENT 'APP唯一编号',
  `version` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT 'APP版本号',
  `device_token` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '设备唯一TOKEN,用于推送',
  `device_name` varchar(100) COLLATE utf8_bin DEFAULT '' COMMENT '设备名称',
  `login_ip` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '最后登陆IP',
  `login_date` datetime DEFAULT NULL COMMENT '最后登陆时间',
  PRIMARY KEY (`login_id`),
  KEY `user_id` (`user_id`),
  KEY `login_date` (`login_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='用户登录记录';

-- ----------------------------
-- Records of sys_login_log
-- ----------------------------
INSERT INTO `sys_login_log` VALUES ('119405447127485117841', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '127.0.0.1', '2017-05-18 18:05:20');
INSERT INTO `sys_login_log` VALUES ('119529869009330153114', 'LOGOUT', '1', 'PC', '10001', '1.0', 'deviceToken', '', '127.0.0.1', '2017-05-18 18:07:25');
INSERT INTO `sys_login_log` VALUES ('1196901118380929700', 'REGISTER', 'U1196843039937187053', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-10-17 09:14:22');
INSERT INTO `sys_login_log` VALUES ('174244801328671351808', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:21:13');
INSERT INTO `sys_login_log` VALUES ('174492875562320144164', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:25:21');
INSERT INTO `sys_login_log` VALUES ('174494706332955880321', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:25:23');
INSERT INTO `sys_login_log` VALUES ('174551613287263294876', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:26:20');
INSERT INTO `sys_login_log` VALUES ('174745878529233643147', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:29:34');
INSERT INTO `sys_login_log` VALUES ('174847470410085348608', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:31:16');
INSERT INTO `sys_login_log` VALUES ('174902380945627810667', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:32:11');
INSERT INTO `sys_login_log` VALUES ('174966442742343366111', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:33:15');
INSERT INTO `sys_login_log` VALUES ('174979590314109584389', 'LOGIN', '1', 'Android', '10001', '1.0', '', '', '127.0.0.1', '2017-05-19 09:31:33');
INSERT INTO `sys_login_log` VALUES ('175020162159738787866', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:34:09');
INSERT INTO `sys_login_log` VALUES ('175051736237931804868', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:34:40');
INSERT INTO `sys_login_log` VALUES ('175068177248070214577', 'LOGOUT', '1', 'Android', '10001', '1.0', '', '', '127.0.0.1', '2017-05-19 09:33:02');
INSERT INTO `sys_login_log` VALUES ('175235998567111758815', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 16:37:44');
INSERT INTO `sys_login_log` VALUES ('180690546756129368993', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 18:08:39');
INSERT INTO `sys_login_log` VALUES ('180693926384226852034', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 18:08:42');
INSERT INTO `sys_login_log` VALUES ('181502293741711399762', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 18:22:11');
INSERT INTO `sys_login_log` VALUES ('181504535631590357550', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-03 18:22:13');
INSERT INTO `sys_login_log` VALUES ('204347594496629121576', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '127.0.0.1', '2017-05-19 17:40:59');
INSERT INTO `sys_login_log` VALUES ('2906944902694957448', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-08 15:34:46');
INSERT INTO `sys_login_log` VALUES ('3087869418615078069', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-08 15:37:47');
INSERT INTO `sys_login_log` VALUES ('790984976191026363', 'LOGIN', '1', 'Android', '30005', '1.0', '', '', '0:0:0:0:0:0:0:1', '2017-05-08 14:59:30');

-- ----------------------------
-- Table structure for sys_mdict
-- ----------------------------
DROP TABLE IF EXISTS `sys_mdict`;
CREATE TABLE `sys_mdict` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `parent_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '父级编号',
  `parent_ids` varchar(2000) COLLATE utf8_bin NOT NULL COMMENT '所有父级编号',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '名称',
  `sort` decimal(10,0) NOT NULL COMMENT '排序',
  `description` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '描述',
  `create_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_mdict_parent_id` (`parent_id`),
  KEY `sys_mdict_del_flag` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='多级字典表';

-- ----------------------------
-- Records of sys_mdict
-- ----------------------------

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `parent_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '父级编号',
  `parent_ids` varchar(2000) COLLATE utf8_bin NOT NULL COMMENT '所有父级编号',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '名称',
  `sort` decimal(10,0) NOT NULL COMMENT '排序',
  `href` varchar(2000) COLLATE utf8_bin DEFAULT NULL COMMENT '链接',
  `target` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT '目标',
  `icon` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '图标',
  `is_show` char(1) COLLATE utf8_bin NOT NULL COMMENT '是否在菜单中显示',
  `permission` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '权限标识',
  `create_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_menu_parent_id` (`parent_id`),
  KEY `sys_menu_del_flag` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='菜单表';

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
INSERT INTO `sys_menu` VALUES ('1', '0', '0,', '功能菜单', '0', null, null, null, '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('10', '3', '0,1,2,3,', '字典管理', '60', '/sys/dict/', null, 'th-list', '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('11', '10', '0,1,2,3,10,', '查看', '30', null, null, null, '0', 'sys:dict:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('12', '10', '0,1,2,3,10,', '修改', '40', null, null, null, '0', 'sys:dict:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('13', '2', '0,1,2,', '机构用户', '970', null, null, null, '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('14', '13', '0,1,2,13,', '区域管理', '50', '/sys/area/', null, 'th', '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('15', '14', '0,1,2,13,14,', '查看', '30', null, null, null, '0', 'sys:area:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('16', '14', '0,1,2,13,14,', '修改', '40', null, null, null, '0', 'sys:area:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('17', '13', '0,1,2,13,', '机构管理', '40', '/sys/office/', null, 'th-large', '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('18', '17', '0,1,2,13,17,', '查看', '30', null, null, null, '0', 'sys:office:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('19', '17', '0,1,2,13,17,', '修改', '40', null, null, null, '0', 'sys:office:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('2', '1', '0,1,', '系统设置', '900', null, null, null, '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('20', '13', '0,1,2,13,', '用户管理', '30', '/sys/user/index', null, 'user', '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('21', '20', '0,1,2,13,20,', '查看', '30', null, null, null, '0', 'sys:user:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('22', '20', '0,1,2,13,20,', '修改', '40', null, null, null, '0', 'sys:user:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('27', '1', '0,1,', '我的面板', '100', null, null, null, '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('28', '27', '0,1,27,', '个人信息', '30', null, null, null, '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('29', '28', '0,1,27,28,', '个人信息', '30', '/sys/user/info', null, 'user', '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('3', '2', '0,1,2,', '系统设置', '980', null, null, null, '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('30', '28', '0,1,27,28,', '修改密码', '40', '/sys/user/modifyPwd', null, 'lock', '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('4', '3', '0,1,2,3,', '菜单管理', '30', '/sys/menu/', null, 'list-alt', '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('5', '4', '0,1,2,3,4,', '查看', '30', null, null, null, '0', 'sys:menu:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('56', '71', '0,1,27,71,', '文件管理', '90', '/../assets/ckfinder/ckfinder.html', '', 'folder-open', '1', '', '1', '2013-05-27 08:00:00', '1', '2017-04-14 17:58:50', '', '0');
INSERT INTO `sys_menu` VALUES ('57', '56', '0,1,27,40,56,', '查看', '30', null, null, null, '0', 'cms:ckfinder:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('58', '56', '0,1,27,40,56,', '上传', '40', null, null, null, '0', 'cms:ckfinder:upload', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('59', '56', '0,1,27,40,56,', '修改', '50', null, null, null, '0', 'cms:ckfinder:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('6', '4', '0,1,2,3,4,', '修改', '40', null, null, null, '0', 'sys:menu:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('67', '2', '0,1,2,', '日志查询', '985', null, null, null, '1', null, '1', '2013-06-03 08:00:00', '1', '2013-06-03 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('68', '67', '0,1,2,67,', '日志查询', '30', '/sys/log', null, 'pencil', '1', 'sys:log:view', '1', '2013-06-03 08:00:00', '1', '2013-06-03 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('7', '3', '0,1,2,3,', '角色管理', '50', '/sys/role/', null, 'lock', '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('71', '27', '0,1,27,', '文件管理', '90', null, null, null, '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('8', '7', '0,1,2,3,7,', '查看', '30', null, null, null, '0', 'sys:role:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');
INSERT INTO `sys_menu` VALUES ('81611440864220520633', '1', '0,1,', '内容管理', '930', '', '', '', '1', '', '1', '2017-05-02 14:37:23', '1', '2017-05-02 14:37:23', '', '0');
INSERT INTO `sys_menu` VALUES ('81629337582483132352', '81611440864220520633', '0,1,81611440864220520633,', '内容管理', '960', '', '', '', '1', 'cms:view', '1', '2017-05-02 14:37:41', '1', '2017-05-02 14:37:52', '', '0');
INSERT INTO `sys_menu` VALUES ('81670965921988707579', '81629337582483132352', '0,1,81611440864220520633,81629337582483132352,', '内容发布', '30', '/cms/', '', '', '1', '', '1', '2017-05-02 14:38:22', '1', '2017-05-02 14:38:22', '', '0');
INSERT INTO `sys_menu` VALUES ('81687207761300463255', '81629337582483132352', '0,1,81611440864220520633,81629337582483132352,', '评论管理', '60', '/cms/comment/?status=2', '', '', '1', '', '1', '2017-05-02 14:38:39', '1', '2017-05-02 14:38:39', '', '0');
INSERT INTO `sys_menu` VALUES ('81704598876997258344', '81629337582483132352', '0,1,81611440864220520633,81629337582483132352,', '公共留言', '90', '/cms/guestbook/?status=2', '', '', '1', '', '1', '2017-05-02 14:38:56', '1', '2017-05-02 14:38:56', '', '0');
INSERT INTO `sys_menu` VALUES ('81963970662332622790', '81670965921988707579', '0,1,81611440864220520633,81629337582483132352,81670965921988707579,', '文章列表', '30', '/cms/article/', '', '', '0', '', '1', '2017-05-02 14:43:15', '1', '2017-05-02 14:43:15', '', '0');
INSERT INTO `sys_menu` VALUES ('81992155627000993971', '81963970662332622790', '0,1,81611440864220520633,81629337582483132352,81670965921988707579,81963970662332622790,', '查看', '30', '', '', '', '0', 'cms:article:view', '1', '2017-05-02 14:43:43', '1', '2017-05-02 14:43:43', '', '0');
INSERT INTO `sys_menu` VALUES ('82021850136157694505', '81963970662332622790', '0,1,81611440864220520633,81629337582483132352,81670965921988707579,81963970662332622790,', '修改', '60', '', '', '', '0', 'cms:article:edit', '1', '2017-05-02 14:44:13', '1', '2017-05-02 14:44:13', '', '0');
INSERT INTO `sys_menu` VALUES ('82041842674630390148', '81963970662332622790', '0,1,81611440864220520633,81629337582483132352,81670965921988707579,81963970662332622790,', '审核', '90', '', '', '', '0', 'cms:article:audit', '1', '2017-05-02 14:44:33', '1', '2017-05-02 14:44:33', '', '0');
INSERT INTO `sys_menu` VALUES ('82680300545856996090', '81687207761300463255', '0,1,81611440864220520633,81629337582483132352,81687207761300463255,', '查看', '30', '', '', '', '0', 'cms:comment:view', '1', '2017-05-02 14:55:12', '1', '2017-05-02 14:55:12', '', '0');
INSERT INTO `sys_menu` VALUES ('82698708148263890042', '81687207761300463255', '0,1,81611440864220520633,81629337582483132352,81687207761300463255,', '审核', '30', '', '', '', '0', 'cms:comment:edit', '1', '2017-05-02 14:55:30', '1', '2017-05-02 14:57:44', '', '0');
INSERT INTO `sys_menu` VALUES ('83429085883620023323', '81704598876997258344', '0,1,81611440864220520633,81629337582483132352,81704598876997258344,', '查看', '30', '', '', '', '0', 'cms:guestbook:view', '1', '2017-05-02 15:07:40', '1', '2017-05-02 15:07:40', '', '0');
INSERT INTO `sys_menu` VALUES ('83446313225752077398', '81704598876997258344', '0,1,81611440864220520633,81629337582483132352,81704598876997258344,', '审核', '60', '', '', '', '0', 'cms:guestbook:edit', '1', '2017-05-02 15:07:58', '1', '2017-05-02 15:07:58', '', '0');
INSERT INTO `sys_menu` VALUES ('83565306383681082720', '81629337582483132352', '0,1,81611440864220520633,81629337582483132352,', '栏目管理', '120', '/cms/category/', '', '', '1', '', '1', '2017-05-02 15:09:57', '1', '2017-05-02 15:09:57', '', '0');
INSERT INTO `sys_menu` VALUES ('83593673441709741840', '83565306383681082720', '0,1,81611440864220520633,81629337582483132352,83565306383681082720,', '查看', '30', '', '', '', '0', 'cms:category:view', '1', '2017-05-02 15:10:25', '1', '2017-05-02 15:10:25', '', '0');
INSERT INTO `sys_menu` VALUES ('83610789148132762458', '83565306383681082720', '0,1,81611440864220520633,81629337582483132352,83565306383681082720,', '修改', '60', '', '', '', '0', 'cms:category:edit', '1', '2017-05-02 15:10:42', '1', '2017-05-02 15:10:42', '', '0');
INSERT INTO `sys_menu` VALUES ('84', '67', '0,1,2,67,', '连接池监视', '40', '/../druid', '', 'bar-chart', '1', '', '1', '2013-10-18 08:00:00', '1', '2017-04-14 13:34:50', '', '0');
INSERT INTO `sys_menu` VALUES ('9', '7', '0,1,2,3,7,', '修改', '40', null, null, null, '0', 'sys:role:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');

-- ----------------------------
-- Table structure for sys_menu2role
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu2role`;
CREATE TABLE `sys_menu2role` (
  `role_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '角色编号',
  `menu_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '菜单编号',
  PRIMARY KEY (`role_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='角色-菜单';

-- ----------------------------
-- Records of sys_menu2role
-- ----------------------------

-- ----------------------------
-- Table structure for sys_office
-- ----------------------------
DROP TABLE IF EXISTS `sys_office`;
CREATE TABLE `sys_office` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `parent_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '父级编号',
  `parent_ids` varchar(2000) COLLATE utf8_bin NOT NULL COMMENT '所有父级编号',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '名称',
  `sort` decimal(10,0) NOT NULL COMMENT '排序',
  `area_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '归属区域',
  `code` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '区域编码',
  `type` char(1) COLLATE utf8_bin NOT NULL COMMENT '机构类型',
  `grade` char(1) COLLATE utf8_bin NOT NULL COMMENT '机构等级',
  `address` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '联系地址',
  `zip_code` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '邮政编码',
  `master` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '负责人',
  `phone` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '电话',
  `fax` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '传真',
  `email` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '邮箱',
  `USEABLE` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '是否启用',
  `PRIMARY_PERSON` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '主负责人',
  `DEPUTY_PERSON` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '副负责人',
  `create_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_office_parent_id` (`parent_id`),
  KEY `sys_office_del_flag` (`del_flag`),
  KEY `sys_office_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='机构表';

-- ----------------------------
-- Records of sys_office
-- ----------------------------

-- ----------------------------
-- Table structure for sys_office2role
-- ----------------------------
DROP TABLE IF EXISTS `sys_office2role`;
CREATE TABLE `sys_office2role` (
  `role_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '角色编号',
  `office_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '机构编号',
  PRIMARY KEY (`role_id`,`office_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='角色-机构';

-- ----------------------------
-- Records of sys_office2role
-- ----------------------------

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `office_id` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '归属机构',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '角色名称',
  `enname` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '英文名称',
  `role_type` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '角色类型',
  `data_scope` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '数据范围',
  `is_sys` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '是否系统数据',
  `useable` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '是否可用',
  `create_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_role_del_flag` (`del_flag`),
  KEY `sys_role_enname` (`enname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='角色表';

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES ('1', '', '系统管理员', 'admin', 'assignment', '1', null, '1', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', null, '0');

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '编号',
  `company_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '归属公司',
  `office_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '归属部门',
  `login_name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '登录名',
  `password` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '密码',
  `no` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '工号',
  `name` varchar(100) COLLATE utf8_bin NOT NULL COMMENT '姓名',
  `email` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '邮箱',
  `phone` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '电话',
  `mobile` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '手机',
  `user_type` char(1) COLLATE utf8_bin DEFAULT NULL COMMENT '用户类型',
  `photo` varchar(1000) COLLATE utf8_bin DEFAULT NULL COMMENT '用户头像',
  `login_ip` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '最后登陆IP',
  `login_date` datetime DEFAULT NULL COMMENT '最后登陆时间',
  `login_flag` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '是否可登录',
  `create_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注信息',
  `del_flag` char(1) COLLATE utf8_bin NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_user_office_id` (`office_id`),
  KEY `sys_user_login_name` (`login_name`),
  KEY `sys_user_company_id` (`company_id`),
  KEY `sys_user_update_date` (`update_date`),
  KEY `sys_user_del_flag` (`del_flag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='用户表';

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES ('1', '1', '2', 'root', '02a3f0772fcca9f415adc990734b45c6f059c7d33ee28362c4852032', '0001', '系统管理员', 'admin@bbdtek.com', '', '', '1', 'user/photo/renmb.png', '127.0.0.1', '2017-05-19 17:40:59', '1', '1', '2013-05-27 08:00:00', '1', '2017-04-14 19:00:23', '最高管理员', '0');
INSERT INTO `sys_user` VALUES ('U1196843039937187053', '', '', '13357826762', 'a9c11527e3f7d311528b068645540ab1e704eeff3b7c95e75e53b5dc', null, '测试用户1', null, null, null, '3', null, null, null, '1', 'U1196843039937187053', '2017-10-17 09:14:22', 'U1196843039937187053', '2017-10-17 09:14:22', '注册用户', '0');

-- ----------------------------
-- Table structure for sys_user2role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user2role`;
CREATE TABLE `sys_user2role` (
  `user_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '用户编号',
  `role_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '角色编号',
  PRIMARY KEY (`user_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='用户-角色';

-- ----------------------------
-- Records of sys_user2role
-- ----------------------------
INSERT INTO `sys_user2role` VALUES ('1', '1');

-- ----------------------------
-- Table structure for sys_user_profiles
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_profiles`;
CREATE TABLE `sys_user_profiles` (
  `user_id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '用户ID',
  `platform` varchar(50) COLLATE utf8_bin DEFAULT 'Unknown' COMMENT '应用平台 Android iOS HTML5 Weixin',
  `app_code` varchar(50) COLLATE utf8_bin DEFAULT '0000' COMMENT 'APP唯一编号',
  `version` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT 'APP版本号',
  `device_token` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '设备唯一TOKEN,用于推送',
  `device_name` varchar(100) COLLATE utf8_bin DEFAULT '' COMMENT '设备名称',
  `fax` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '传真',
  `gender` char(1) COLLATE utf8_bin DEFAULT '' COMMENT '性别 M(男) F(女)',
  `device_update` datetime NOT NULL COMMENT '更新时间',
  PRIMARY KEY (`user_id`),
  KEY `app_code` (`app_code`),
  KEY `device_update` (`device_update`),
  KEY `device_token` (`device_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='用户详细表';

-- ----------------------------
-- Records of sys_user_profiles
-- ----------------------------
INSERT INTO `sys_user_profiles` VALUES ('1', 'Android', '30005', '1.0', '', '', null, 'M', '2017-05-19 17:40:59');
INSERT INTO `sys_user_profiles` VALUES ('U1196843039937187053', 'Android', '30005', '1.0', '', '', null, '', '2017-10-17 09:14:22');

-- ----------------------------
-- Table structure for upload_files
-- ----------------------------
DROP TABLE IF EXISTS `upload_files`;
CREATE TABLE `upload_files` (
  `id` varchar(64) COLLATE utf8_bin NOT NULL COMMENT '文件ID',
  `app_code` varchar(32) COLLATE utf8_bin NOT NULL COMMENT '应用标识符',
  `session_id` varchar(32) COLLATE utf8_bin DEFAULT NULL COMMENT '记录一次提交记录',
  `clientip` varchar(32) COLLATE utf8_bin NOT NULL COMMENT '注册IP地址',
  `module` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT '模块名称',
  `md5` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '文件MD5编码',
  `name` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '文件原始名称',
  `input_name` varchar(100) COLLATE utf8_bin DEFAULT NULL COMMENT '文件表单名称原始名称',
  `path` varchar(255) COLLATE utf8_bin NOT NULL COMMENT '文件访问路径',
  `thumbs` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '文件缩略图访问路径',
  `extesion` varchar(10) COLLATE utf8_bin DEFAULT NULL COMMENT '文件扩展名称',
  `summary` varchar(300) COLLATE utf8_bin DEFAULT NULL COMMENT '文件简要描述',
  `size` int(11) NOT NULL DEFAULT '0' COMMENT '文件大小 bytes',
  `width` int(11) NOT NULL DEFAULT '0' COMMENT '图片宽带（图片特有属性）',
  `height` int(11) NOT NULL DEFAULT '0' COMMENT '图片高度（图片特有属性）',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `session_id` (`session_id`),
  KEY `created` (`created`),
  KEY `module_name` (`module`),
  KEY `path_name` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='上传文件记录表';

-- ----------------------------
-- Records of upload_files
-- ----------------------------
INSERT INTO `upload_files` VALUES ('35244299580562500227', '20001', '7029928aa5aab8be1cf50760a90e1bfd', '0:0:0:0:0:0:0:1', 'sunrise', '40166b4782ce34c83b771ad2038684ae.png', 'a46f5125dd_23065718-DUFj.png', 'file', '2017/05/17/actuals/sunrise/png/40166b4782ce34c83b771ad2038684ae.png', null, '.png', null, '79299', '1580', '940', '2017-05-17 18:42:43');
INSERT INTO `upload_files` VALUES ('35244450673560678371', '20001', '7029928aa5aab8be1cf50760a90e1bfd', '0:0:0:0:0:0:0:1', 'sunrise', '5bb8321370c7dc36ec6dad624a3674b6.png', 'default_female_avatar.png', 'file', '2017/05/17/actuals/sunrise/png/5bb8321370c7dc36ec6dad624a3674b6.png', null, '.png', null, '9941', '206', '206', '2017-05-17 18:42:43');
INSERT INTO `upload_files` VALUES ('35619775288009874493', '20001', '7c2887ff325a0d8a9a3a705e05669ef3', '0:0:0:0:0:0:0:1', 'sunrise', '40166b4782ce34c83b771ad2038684ae.png', 'a46f5125dd_23065718-DUFj.png', 'file', '2017/05/17/actuals/sunrise/png/40166b4782ce34c83b771ad2038684ae.png', null, '.png', null, '79299', '1580', '940', '2017-05-17 18:48:59');
INSERT INTO `upload_files` VALUES ('35619872967851143920', '20001', '7c2887ff325a0d8a9a3a705e05669ef3', '0:0:0:0:0:0:0:1', 'sunrise', '5bb8321370c7dc36ec6dad624a3674b6.png', 'default_female_avatar.png', 'file', '2017/05/17/actuals/sunrise/png/5bb8321370c7dc36ec6dad624a3674b6.png', null, '.png', null, '9941', '206', '206', '2017-05-17 18:48:59');
INSERT INTO `upload_files` VALUES ('36335200871585011678', '20001', '997476f54e71e2ea119b351ec3d36f8f', '0:0:0:0:0:0:0:1', 'sunrise', 'c99f4324aa2b657f0b08f6d26e1530dd.png', 'expert_avator_male_default_square.png', 'file', '2017/05/17/actuals/sunrise/png/c99f4324aa2b657f0b08f6d26e1530dd.png', null, '.png', null, '7180', '206', '206', '2017-05-17 19:00:54');
INSERT INTO `upload_files` VALUES ('36335348068878857312', '20001', '997476f54e71e2ea119b351ec3d36f8f', '0:0:0:0:0:0:0:1', 'sunrise', '5bb8321370c7dc36ec6dad624a3674b6.png', 'default_female_avatar.png', 'file', '2017/05/17/actuals/sunrise/png/5bb8321370c7dc36ec6dad624a3674b6.png', null, '.png', null, '9941', '206', '206', '2017-05-17 19:00:54');
INSERT INTO `upload_files` VALUES ('37102499833086844774', '20001', '31dec32221d497cefbfa4e8471eac004', '0:0:0:0:0:0:0:1', 'sunrise', 'c99f4324aa2b657f0b08f6d26e1530dd.png', 'expert_avator_male_default_square.png', 'file', '2017/05/17/actuals/sunrise/png/c99f4324aa2b657f0b08f6d26e1530dd.png', null, '.png', null, '7180', '206', '206', '2017-05-17 19:13:41');
INSERT INTO `upload_files` VALUES ('37152360057031085949', '20001', '994c0509121173b20b7b6a9208b15217', '0:0:0:0:0:0:0:1', 'sunrise', 'c99f4324aa2b657f0b08f6d26e1530dd.png', 'expert_avator_male_default_square.png', 'file', '2017/05/17/actuals/sunrise/png/c99f4324aa2b657f0b08f6d26e1530dd.png', null, '.png', null, '7180', '206', '206', '2017-05-17 19:14:31');
INSERT INTO `upload_files` VALUES ('37152384793040597023', '20001', '994c0509121173b20b7b6a9208b15217', '0:0:0:0:0:0:0:1', 'sunrise', '0d7ed36548c9ea6586363d4de5cb322c.png', '5e804c9d63_23065717-uqRR.png', 'file', '2017/05/17/actuals/sunrise/png/0d7ed36548c9ea6586363d4de5cb322c.png', null, '.png', null, '49438', '1590', '498', '2017-05-17 19:14:31');
INSERT INTO `upload_files` VALUES ('37423267848797780527', '20001', '3d6b869fd278f331d97dca6916caa23d', '0:0:0:0:0:0:0:1', 'sunrise', 'c99f4324aa2b657f0b08f6d26e1530dd.png', 'expert_avator_male_default_square.png', 'file', '2017/05/17/actuals/sunrise/png/c99f4324aa2b657f0b08f6d26e1530dd.png', '2017/05/17/actuals/sunrise/png/c99f4324aa2b657f0b08f6d26e1530dd.png', '.png', null, '7180', '206', '206', '2017-05-17 19:19:02');
INSERT INTO `upload_files` VALUES ('37423732980042771292', '20001', '3d6b869fd278f331d97dca6916caa23d', '0:0:0:0:0:0:0:1', 'sunrise', '40166b4782ce34c83b771ad2038684ae.png', 'a46f5125dd_23065718-DUFj.png', 'file', '2017/05/17/actuals/sunrise/png/40166b4782ce34c83b771ad2038684ae.png', '2017/05/17/thumbs/sunrise/png/40166b4782ce34c83b771ad2038684ae.png', '.png', null, '79299', '1580', '940', '2017-05-17 19:19:03');
INSERT INTO `upload_files` VALUES ('F35428928031181253670', '20001', 'cd221a9cddf71d67772ad46c5ae695c8', '0:0:0:0:0:0:0:1', 'sunrise', '40166b4782ce34c83b771ad2038684ae.png', 'a46f5125dd_23065718-DUFj.png', 'file', '2017/05/17/actuals/sunrise/png/40166b4782ce34c83b771ad2038684ae.png', null, '.png', null, '79299', '1580', '940', '2017-05-17 18:45:48');
INSERT INTO `upload_files` VALUES ('F35428996410862290654', '20001', 'cd221a9cddf71d67772ad46c5ae695c8', '0:0:0:0:0:0:0:1', 'sunrise', '5bb8321370c7dc36ec6dad624a3674b6.png', 'default_female_avatar.png', 'file', '2017/05/17/actuals/sunrise/png/5bb8321370c7dc36ec6dad624a3674b6.png', null, '.png', null, '9941', '206', '206', '2017-05-17 18:45:48');
