# app

* ## Create an app

    ```python
    python manage.py startapp myapp
    ```

* ## Change app name appeared in django admin app

    1. Modify `./myapp/app.py`, in the config class (which subclasses `AppConfig`) add `verbose_name`attribute to indicate the name
    
        ```python
        from django.apps import Appconfig
        
        class MyAppConfig(AppConfig):
            name = 'myapp'
            verbose_name = 'A Greate App'
        ```
    1. Indicate the config class in `__init__.py` in the app folder throuth `default_app_config`

        ```python
        default_app_config = 'myproject.myapp.MyAppConfig'
        ```
