function ResourceGroupVersion(resource, group, version) {
return this.resource = resource, this.group = group, this.version = version, this;
}

angular.module("openshiftCommonServices", [ "ab-base64" ]).config([ "AuthServiceProvider", function(AuthServiceProvider) {
AuthServiceProvider.UserStore("MemoryUserStore");
} ]).constant("API_CFG", _.get(window.OPENSHIFT_CONFIG, "api", {})).constant("APIS_CFG", _.get(window.OPENSHIFT_CONFIG, "apis", {})).constant("AUTH_CFG", _.get(window.OPENSHIFT_CONFIG, "auth", {})).config([ "$httpProvider", "AuthServiceProvider", "RedirectLoginServiceProvider", "AUTH_CFG", function($httpProvider, AuthServiceProvider, RedirectLoginServiceProvider, AUTH_CFG) {
$httpProvider.interceptors.push("AuthInterceptor"), AuthServiceProvider.LoginService("RedirectLoginService"), AuthServiceProvider.LogoutService("DeleteTokenLogoutService"), AuthServiceProvider.UserStore("LocalStorageUserStore"), RedirectLoginServiceProvider.OAuthClientID(AUTH_CFG.oauth_client_id), RedirectLoginServiceProvider.OAuthAuthorizeURI(AUTH_CFG.oauth_authorize_uri), RedirectLoginServiceProvider.OAuthTokenURI(AUTH_CFG.oauth_token_uri), RedirectLoginServiceProvider.OAuthRedirectURI(URI(AUTH_CFG.oauth_redirect_base).segment("oauth").toString());
} ]), hawtioPluginLoader.addModule("openshiftCommonServices"), hawtioPluginLoader.registerPreBootstrapTask(function(next) {
if (_.get(window, "OPENSHIFT_CONFIG.api.k8s.resources")) return void next();
var api = {
k8s:{},
openshift:{}
}, apis = {}, API_DISCOVERY_ERRORS = [], protocol = window.location.protocol + "//", k8sBaseURL = protocol + window.OPENSHIFT_CONFIG.api.k8s.hostPort + window.OPENSHIFT_CONFIG.api.k8s.prefix, k8sDeferred = $.get(k8sBaseURL + "/v1").done(function(data) {
api.k8s.v1 = _.keyBy(data.resources, "name");
}).fail(function(data, textStatus, jqXHR) {
API_DISCOVERY_ERRORS.push({
data:data,
textStatus:textStatus,
xhr:jqXHR,
fatal:!0
});
}), osBaseURL = protocol + window.OPENSHIFT_CONFIG.api.openshift.hostPort + window.OPENSHIFT_CONFIG.api.openshift.prefix, osDeferred = $.get(osBaseURL + "/v1").done(function(data) {
api.openshift.v1 = _.keyBy(data.resources, "name");
}).fail(function(data, textStatus, jqXHR) {
API_DISCOVERY_ERRORS.push({
data:data,
textStatus:textStatus,
xhr:jqXHR,
fatal:!0
});
}), apisBaseURL = protocol + window.OPENSHIFT_CONFIG.apis.hostPort + window.OPENSHIFT_CONFIG.apis.prefix, getGroups = function(baseURL, hostPrefix, data) {
var apisDeferredVersions = [];
return _.each(data.groups, function(apiGroup) {
var group = {
name:apiGroup.name,
preferredVersion:apiGroup.preferredVersion.version,
versions:{},
hostPrefix:hostPrefix
};
apis[group.name] = group, _.each(apiGroup.versions, function(apiVersion) {
var versionStr = apiVersion.version;
group.versions[versionStr] = {
version:versionStr,
groupVersion:apiVersion.groupVersion
}, apisDeferredVersions.push($.get(baseURL + "/" + apiVersion.groupVersion).done(function(data) {
group.versions[versionStr].resources = _.keyBy(data.resources, "name");
}).fail(function(data, textStatus, jqXHR) {
API_DISCOVERY_ERRORS.push({
data:data,
textStatus:textStatus,
xhr:jqXHR
});
}));
});
}), $.when.apply(this, apisDeferredVersions);
}, apisDeferred = $.get(apisBaseURL).then(_.partial(getGroups, apisBaseURL, null), function(data, textStatus, jqXHR) {
API_DISCOVERY_ERRORS.push({
data:data,
textStatus:textStatus,
xhr:jqXHR,
fatal:!0
});
}), discoveryFinished = function() {
window.OPENSHIFT_CONFIG.api.k8s.resources = api.k8s, window.OPENSHIFT_CONFIG.api.openshift.resources = api.openshift, window.OPENSHIFT_CONFIG.apis.groups = apis, API_DISCOVERY_ERRORS.length && (window.OPENSHIFT_CONFIG.apis.API_DISCOVERY_ERRORS = API_DISCOVERY_ERRORS), next();
}, allDeferreds = [ k8sDeferred, osDeferred, apisDeferred ];
$.when.apply(this, allDeferreds).always(discoveryFinished);
}), angular.module("openshiftCommonUI", []).constant("BREAKPOINTS", {
screenXsMin:480,
screenSmMin:768,
screenMdMin:992,
screenLgMin:1200,
screenXlgMin:1600
}).constant("DNS1123_SUBDOMAIN_VALIDATION", {
pattern:/^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$/,
maxlength:253,
description:"Name must consist of lower-case letters, numbers, periods, and hyphens. It must start and end with a letter or a number."
}).constant("IS_IOS", /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream), hawtioPluginLoader.addModule("openshiftCommonUI"), angular.module("openshiftCommonUI").run([ "$templateCache", function($templateCache) {
"use strict";
$templateCache.put("src/components/binding/bindApplicationForm.html", '<div class="bind-form">\n  <form>\n    <div class="form-group">\n      <label>\n        <h3>Create a binding for application <strong>{{ctrl.applicationName}}</strong></h3>\n      </label>\n      <span class="help-block">\n        Bindings create a secret containing the necessary information for an application to use a service.\n      </span>\n    </div>\n  </form>\n\n  <label ng-if="!ctrl.allowNoBinding">\n    Select a service:\n  </label>\n  <form name="ctrl.formName">\n    <fieldset>\n      <div class="radio">\n        <div ng-if="ctrl.allowNoBinding" class="bind-service-selection">\n          <label>\n            <input type="radio" ng-model="ctrl.serviceToBind" ng-value="null">\n            Do not bind at this time.\n          </label>\n          <div class="bind-description">\n          <span class="help-block service-instance-name">\n            Bindings can be created later from within a project.\n          </span>\n          </div>\n        </div>\n        <div ng-repeat="serviceInstance in ctrl.bindableServiceInstances" class="bind-service-selection">\n          <label>\n            <input type="radio" ng-model="ctrl.serviceToBind" ng-value="serviceInstance">\n            {{ctrl.serviceClasses[serviceInstance.spec.clusterServiceClassRef.name].spec.externalMetadata.displayName || serviceInstance.spec.clusterServiceClassRef.name}}\n          </label>\n          <div class="bind-description">\n            <span class="pficon pficon-info"\n                  ng-if="!(serviceInstance | isServiceInstanceReady)"\n                  data-content="This service is not yet ready. If you bind to it, then the binding will be pending until the service is ready."\n                  data-toggle="popover"\n                  data-trigger="hover">\n            </span>\n            <span class="help-block service-instance-name">\n              {{serviceInstance.metadata.name}}\n            </span>\n          </div>\n        </div>\n        <h4 ng-if="!ctrl.bindableServiceInstances.length">\n          <span class="pficon pficon-info" aria-hidden="true"></span>\n          <span class="help-block service-instance-name">\n            There are no bindable services in this project\n          </span>\n        </h4>\n      </div>\n    </fieldset>\n  </form>\n</div>\n'), 
$templateCache.put("src/components/binding/bindResults.html", '<div ng-if="!ctrl.error && !(ctrl.binding | isBindingFailed)">\n  <div ng-if="ctrl.binding && !(ctrl.binding | isBindingReady)" class="results-status">\n    <span class="fa fa-clock-o text-muted" aria-hidden="true"></span>\n    <span class="sr-only">Pending</span>\n    <div class="results-message">\n      <h3>\n        The binding is being created.\n      </h3>\n      <p class="results-message-details">This may take several minutes.</p>\n    </div>\n  </div>\n  <div ng-if="(ctrl.binding | isBindingReady)">\n    <div class="results-status">\n      <span class="pficon pficon-ok" aria-hidden="true"></span>\n      <span class="sr-only">Success</span>\n      <div class="results-message">\n        <h3>\n          <span ng-if="ctrl.bindType === \'application\'">\n            <strong>{{ctrl.serviceToBind}}</strong> has been bound to\n            <strong>{{ctrl.applicationToBind}}</strong> successfully.\n          </span>\n          <span ng-if="ctrl.bindType !== \'application\'">\n            The binding <strong>{{ctrl.binding.metadata.name}}</strong> has been created successfully.\n          </span>\n        </h3>\n        <p class="results-message-details">\n          The binding operation created the secret\n          <a ng-if="ctrl.secretHref" ng-href="{{ctrl.secretHref}}">{{ctrl.binding.spec.secretName}}</a>\n          <span ng-if="!ctrl.secretHref">{{ctrl.binding.spec.secretName}}</span>\n          that you may need to reference in your application.\n          <span ng-if="ctrl.showPodPresets">Its data will be available to your application as environment variables.</span>\n        </p>\n      </div>\n    </div>\n    <div class="alert alert-info results-info" ng-if="ctrl.bindType === \'application\'">\n      <span class="pficon pficon-info" aria-hidden="true"></span>\n      <span class="sr-only">Info</span>\n      The binding secret will only be available to new pods. You will need to redeploy your application.\n    </div>\n  </div>\n</div>\n<div ng-if="ctrl.error || (ctrl.binding | isBindingFailed)">\n  <div class="results-status">\n    <span class="pficon pficon-error-circle-o text-danger" aria-hidden="true"></span>\n    <span class="sr-only">Error</span>\n    <div class="results-message">\n      <h3>\n        The binding could not be created.\n      </h3>\n    </div>\n  </div>\n  <div ng-if="ctrl.error" class="sub-title">\n    <span ng-if="ctrl.error.data.message">\n      {{ctrl.error.data.message | upperFirst}}\n    </span>\n    <span ng-if="!ctrl.error.data.message">\n      An error occurred creating the binding.\n    </span>\n  </div>\n  <div ng-if="!ctrl.error" class="sub-title">\n    {{ctrl.binding | bindingFailedMessage}}\n  </div>\n</div>\n'), 
$templateCache.put("src/components/binding/bindServiceForm.html", '<div class="bind-form">\n  <form>\n    <div class="form-group">\n      <label>\n        <h3>Create a binding for <strong>{{ctrl.serviceClass.spec.externalMetadata.displayName || ctrl.serviceClass.spec.externalName}}</strong></h3>\n      </label>\n      <span class="help-block">Bindings create a secret containing the necessary information for an application to use this service.</span>\n    </div>\n  </form>\n\n  <form ng-if="ctrl.allowNoBinding || ctrl.showPodPresets" name="ctrl.formName" class="mar-bottom-lg">\n    <fieldset>\n      <div class="radio">\n        <label ng-if="ctrl.showPodPresets" class="bind-choice" ng-disabled="!ctrl.applications.length">\n          <input type="radio" ng-model="ctrl.bindType" value="application" ng-disabled="!ctrl.applications.length">\n          Create a secret and inject it into an application\n        </label>\n        <div ng-if="ctrl.showPodPresets" class="application-select">\n          <ui-select ng-model="ctrl.appToBind"\n                     ng-disabled="ctrl.bindType !== \'application\'"\n                     ng-required="ctrl.bindType === \'application\'">\n            <ui-select-match placeholder="{{ctrl.applications.length ? \'Select an application\' : \'There are no applications in this project\'}}">\n              <span>\n                {{$select.selected.metadata.name}}\n                <small class="text-muted">&ndash; {{$select.selected.kind | humanizeKind : true}}</small>\n              </span>\n            </ui-select-match>\n            <ui-select-choices\n              repeat="application in (ctrl.applications) | filter : { metadata: { name: $select.search } } track by (application | uid)"\n              group-by="ctrl.groupByKind">\n              <span ng-bind-html="application.metadata.name | highlight : $select.search"></span>\n            </ui-select-choices>\n          </ui-select>\n        </div>\n        <label class="bind-choice">\n          <input type="radio" ng-model="ctrl.bindType" value="secret-only">\n          Create a secret in <strong>{{ctrl.projectName}}</strong> to be used later\n        </label>\n        <div class="help-block bind-description">\n          Secrets can be referenced later from an application.\n        </div>\n        <label ng-if="ctrl.allowNoBinding" class="bind-choice">\n          <input type="radio" ng-model="ctrl.bindType" value="none">\n          Do not bind at this time\n        </label>\n        <div ng-if="ctrl.allowNoBinding" class="help-block bind-description">\n          Bindings can be created later from within a project.\n        </div>\n      </div>\n    </fieldset>\n  </form>\n</div>\n'), 
$templateCache.put("src/components/create-project/createProject.html", '<form name="createProjectForm" novalidate>\n  <fieldset ng-disabled="disableInputs">\n    <div class="form-group">\n      <label for="name" class="required">Name</label>\n      <span ng-class="{\'has-error\': (createProjectForm.name.$error.pattern && createProjectForm.name.$touched) || nameTaken}">\n        <input class="form-control"\n            name="name"\n            id="name"\n            placeholder="my-project"\n            type="text"\n            required\n            take-focus\n            minlength="2"\n            maxlength="63"\n            pattern="[a-z0-9]([-a-z0-9]*[a-z0-9])?"\n            aria-describedby="nameHelp"\n            ng-model="name"\n            ng-model-options="{ updateOn: \'default blur\' }"\n            ng-change="nameTaken = false"\n            autocorrect="off"\n            autocapitalize="off"\n            spellcheck="false">\n      </span>\n      <div>\n        <span class="help-block">A unique name for the project.</span>\n      </div>\n      <div class="has-error">\n        <span id="nameHelp" class="help-block" ng-if="createProjectForm.name.$error.required && createProjectForm.name.$dirty">\n          Name is required.\n        </span>\n      </div>\n      <div class="has-error">\n        <span id="nameHelp" class="help-block" ng-if="createProjectForm.name.$error.minlength && createProjectForm.name.$touched">\n          Name must have at least two characters.\n        </span>\n      </div>\n      <div class="has-error">\n        <span id="nameHelp" class="help-block" ng-if="createProjectForm.name.$error.pattern && createProjectForm.name.$touched">\n          Project names may only contain lower-case letters, numbers, and dashes.\n          They may not start or end with a dash.\n        </span>\n      </div>\n      <div class="has-error">\n        <span class="help-block" ng-if="nameTaken">\n          This name is already in use. Please choose a different name.\n        </span>\n      </div>\n    </div>\n\n    <div class="form-group">\n      <label for="displayName">Display Name</label>\n      <input class="form-control"\n          name="displayName"\n          id="displayName"\n          placeholder="My Project"\n          type="text"\n          ng-model="displayName">\n    </div>\n\n    <div class="form-group">\n      <label for="description">Description</label>\n      <textarea class="form-control"\n          name="description"\n          id="description"\n          placeholder="A short description."\n          ng-model="description"></textarea>\n    </div>\n\n    <div class="button-group">\n      <button type="submit"\n          class="btn btn-primary"\n          ng-class="{\'dialog-btn\': isDialog}"\n          ng-click="createProject()"\n          ng-disabled="createProjectForm.$invalid || nameTaken || disableInputs"\n          value="">\n        Create\n      </button>\n      <button\n          class="btn btn-default"\n          ng-class="{\'dialog-btn\': isDialog}"\n          ng-click="cancelCreateProject()">\n        Cancel\n      </button>\n    </div>\n  </fieldset>\n</form>\n'), 
$templateCache.put("src/components/delete-project/delete-project-button.html", '<div class="actions">\n  <!-- Avoid whitespace inside the link -->\n  <a href=""\n     ng-click="$event.stopPropagation(); openDeleteModal()"\n     role="button"\n     class="action-button"\n     ng-attr-aria-disabled="{{disableDelete ? \'true\' : undefined}}"\n     ng-class="{ \'disabled-link\': disableDelete }"\n    ><i class="fa fa-trash-o" aria-hidden="true"\n    ></i><span class="sr-only">Delete Project {{projectName}}</span></a>\n</div>\n'), $templateCache.put("src/components/delete-project/delete-project-modal.html", '<div class="delete-resource-modal">\n  <!-- Use a form so that the enter key submits when typing a project name to confirm. -->\n  <form>\n    <div class="modal-body">\n      <h1>Are you sure you want to delete the project \'<strong>{{project | displayName}}</strong>\'?</h1>\n      <p>\n        This will <strong>delete all resources</strong> associated with\n        the project {{project | displayName}} and <strong>cannot be\n        undone</strong>.  Make sure this is something you really want to do!\n      </p>\n      <div ng-show="typeNameToConfirm">\n        <p>Type the name of the project to confirm.</p>\n        <p>\n          <label class="sr-only" for="resource-to-delete">project to delete</label>\n          <input\n              ng-model="confirmName"\n              id="resource-to-delete"\n              type="text"\n              class="form-control input-lg"\n              autocorrect="off"\n              autocapitalize="off"\n              spellcheck="false"\n              autofocus>\n        </p>\n      </div>\n    </div>\n    <div class="modal-footer">\n      <button ng-disabled="typeNameToConfirm && confirmName !== project.metadata.name && confirmName !== (project | displayName : false)" class="btn btn-lg btn-danger" type="submit" ng-click="delete()">Delete</button>\n      <button class="btn btn-lg btn-default" type="button" ng-click="cancel()">Cancel</button>\n    </div>\n  </form>\n</div>\n'), 
$templateCache.put("src/components/delete-project/delete-project.html", '<a href="javascript:void(0)"\n   ng-click="openDeleteModal()"\n   role="button"\n   ng-attr-aria-disabled="{{disableDelete ? \'true\' : undefined}}"\n   ng-class="{ \'disabled-link\': disableDelete }"\n>{{label || \'Delete\'}}</a>\n'), $templateCache.put("src/components/edit-project/editProject.html", '<form name="editProjectForm">\n  <fieldset ng-disabled="disableInputs">\n    <div class="form-group">\n      <label for="displayName">Display Name</label>\n      <input class="form-control"\n             name="displayName"\n             id="displayName"\n             placeholder="My Project"\n             type="text"\n             ng-model="editableFields.displayName">\n    </div>\n\n    <div class="form-group">\n      <label for="description">Description</label>\n                    <textarea class="form-control"\n                              name="description"\n                              id="description"\n                              placeholder="A short description."\n                              ng-model="editableFields.description"></textarea>\n    </div>\n\n    <div class="button-group">\n      <button type="submit"\n              class="btn btn-primary"\n              ng-class="{\'dialog-btn\': isDialog}"\n              ng-click="update()"\n              ng-disabled="editProjectForm.$invalid || disableInputs"\n              value="">{{submitButtonLabel}}</button>\n      <button\n          class="btn btn-default"\n          ng-class="{\'dialog-btn\': isDialog}"\n          ng-click="cancelEditProject()">\n        Cancel\n      </button>\n    </div>\n  </fieldset>\n</form>\n'), 
$templateCache.put("src/components/origin-modal-popup/origin-modal-popup.html", '<div class="origin-modal-popup tile-click-prevent" ng-if="$ctrl.shown" ng-style="$ctrl.positionStyle"\n     ng-class="{\'position-above\': $ctrl.showAbove, \'position-left\': $ctrl.showLeft}">\n  <h4 class="origin-modal-popup-title">\n    {{$ctrl.modalTitle}}\n  </h4>\n  <div ng-transclude></div>\n  <a href="" class="origin-modal-popup-close" ng-click="$ctrl.onClose()">\n    <span class="pficon pficon-close"></span>\n  </a>\n</div>\n'), $templateCache.put("src/components/toast-notifications/toast-notifications.html", '<div class="toast-notifications-list-pf">\n  <div\n    ng-repeat="(notificationID, notification) in notifications track by notification.trackByID"\n    ng-if="!notification.hidden || notification.isHover"\n       ng-mouseenter="setHover(notification, true)" ng-mouseleave="setHover(notification, false)">\n    <div class="toast-pf alert {{notification.type | alertStatus}}" ng-class="{\'alert-dismissable\': !hideCloseButton}">\n      <button ng-if="!hideCloseButton" type="button" class="close" ng-click="close(notification)">\n        <span class="pficon pficon-close" aria-hidden="true"></span>\n        <span class="sr-only">Close</span>\n      </button>\n      <span class="{{notification.type | alertIcon}}" aria-hidden="true"></span>\n      <span class="sr-only">{{notification.type}}</span>\n      <span class="toast-notification-message" ng-if="notification.message">{{notification.message}}</span>\n      <div ng-if="notification.details" class="toast-notification-details">\n        <truncate-long-text\n          limit="200"\n          content="notification.details"\n          use-word-boundary="true"\n          expandable="true"\n          hide-collapse="true">\n        </truncate-long-text>\n      </div>\n      <span ng-repeat="link in notification.links">\n        <a ng-if="!link.href" href="" ng-click="onClick(notification, link)" role="button">{{link.label}}</a>\n        <a ng-if="link.href" ng-href="{{link.href}}" ng-attr-target="{{link.target}}">{{link.label}}</a>\n        <span ng-if="!$last" class="toast-action-divider">|</span>\n      </span>\n    </div>\n  </div>\n</div>\n'), 
$templateCache.put("src/components/truncate-long-text/truncateLongText.html", '<!--\n  Do not remove class `truncated-content` (here or below) even though it\'s not\n  styled directly in origin-web-common.  `truncated-content` is used by\n  origin-web-console in certain contexts.\n\n  highlightKeywords and linkify are mutually exclusive options\n-->\n<span ng-if="!truncated">\n  <span ng-if="!linkify || (highlightKeywords | size)" ng-bind-html="content | highlightKeywords : keywords" class="truncated-content"></span>\n  <span ng-if="linkify && !(highlightKeywords | size)" ng-bind-html="content | linkify : \'_blank\'" class="truncated-content"></span>\n</span>\n<!-- To avoid truncating in middle of a link, we only optionally apply linkify to expanded content -->\n<span ng-if="truncated">\n  <span ng-if="!toggles.expanded">\n    <span ng-attr-title="{{content}}" class="truncation-block">\n      <span ng-bind-html="truncatedContent | highlightKeywords : keywords" class="truncated-content"></span>&hellip;\n    </span>\n    <a ng-if="expandable" href="" ng-click="toggles.expanded = true" class="truncation-expand-link">See All</a>\n  </span>\n  <span ng-if="toggles.expanded">\n      <a href="" ng-if="!hideCollapse" ng-click="toggles.expanded = false" class="truncation-collapse-link">Collapse</a>\n      <span ng-if="!linkify || (highlightKeywords | size)"\n            ng-bind-html="content | highlightKeywords : keywords"\n            class="truncated-content"></span>\n      <span ng-if="linkify && !(highlightKeywords | size)"\n            ng-bind-html="content | linkify : \'_blank\'"\n            class="truncated-content"></span>\n  </span>\n</span>\n');
} ]), angular.module("openshiftCommonUI").component("bindApplicationForm", {
controllerAs:"ctrl",
bindings:{
allowNoBinding:"<?",
createBinding:"=",
applicationName:"=",
formName:"=",
serviceClasses:"<",
serviceInstances:"<",
serviceToBind:"="
},
templateUrl:"src/components/binding/bindApplicationForm.html",
controller:[ "BindingService", function(BindingService) {
function isBindable(serviceInstance) {
return BindingService.isServiceBindable(serviceInstance, ctrl.serviceClasses);
}
var ctrl = this;
ctrl.$onChanges = function(changeObj) {
(changeObj.serviceInstances || changeObj.serviceClasses) && (ctrl.bindableServiceInstances = _.filter(ctrl.serviceInstances, isBindable));
};
} ]
}), angular.module("openshiftCommonUI").component("bindResults", {
controllerAs:"ctrl",
bindings:{
error:"<",
binding:"<",
serviceToBind:"<",
bindType:"@",
applicationToBind:"<",
showPodPresets:"<",
secretHref:"<"
},
templateUrl:"src/components/binding/bindResults.html"
}), angular.module("openshiftCommonUI").component("bindServiceForm", {
controllerAs:"ctrl",
bindings:{
serviceClass:"<",
showPodPresets:"<",
applications:"<",
formName:"=",
allowNoBinding:"<?",
projectName:"<",
bindType:"=",
appToBind:"="
},
templateUrl:"src/components/binding/bindServiceForm.html",
controller:[ "$filter", function($filter) {
var ctrl = this, humanizeKind = $filter("humanizeKind");
ctrl.groupByKind = function(object) {
return humanizeKind(object.kind);
};
} ]
}), angular.module("openshiftCommonUI").directive("createProject", [ "$window", function($window) {
return {
restrict:"E",
scope:{
redirectAction:"&",
onCancel:"&?",
isDialog:"@"
},
templateUrl:"src/components/create-project/createProject.html",
controller:[ "$scope", "$location", "ProjectsService", "NotificationsService", "displayNameFilter", "Logger", function($scope, $location, ProjectsService, NotificationsService, displayNameFilter, Logger) {
$scope.submitButtonLabel || ($scope.submitButtonLabel = "Create"), $scope.isDialog = "true" === $scope.isDialog;
var hideErrorNotifications = function() {
NotificationsService.hideNotification("create-project-error");
};
$scope.createProject = function() {
if ($scope.disableInputs = !0, $scope.createProjectForm.$valid) {
var displayName = $scope.displayName || $scope.name;
ProjectsService.create($scope.name, $scope.displayName, $scope.description).then(function(project) {
var cb = $scope.redirectAction();
cb ? cb(encodeURIComponent(project.metadata.name)) :$location.path("project/" + encodeURIComponent(project.metadata.name) + "/create"), NotificationsService.addNotification({
type:"success",
message:"Project '" + displayNameFilter(project) + "' was successfully created."
});
}, function(result) {
$scope.disableInputs = !1;
var data = result.data || {};
if ("AlreadyExists" === data.reason) $scope.nameTaken = !0; else {
var msg = data.message || "An error occurred creating project '" + displayName + "'.";
NotificationsService.addNotification({
type:"error",
message:msg
}), Logger.error("Project '" + displayName + "' could not be created.", result);
}
});
}
}, $scope.cancelCreateProject = function() {
if ($scope.onCancel) {
var cb = $scope.onCancel();
cb && cb();
} else $window.history.back();
}, $scope.$on("$destroy", hideErrorNotifications);
} ]
};
} ]), angular.module("openshiftCommonUI").directive("deleteProject", [ "$uibModal", "$location", "$filter", "$q", "hashSizeFilter", "APIService", "NotificationsService", "ProjectsService", "Logger", function($uibModal, $location, $filter, $q, hashSizeFilter, APIService, NotificationsService, ProjectsService, Logger) {
return {
restrict:"E",
scope:{
project:"=",
disableDelete:"=?",
typeNameToConfirm:"=?",
label:"@?",
buttonOnly:"@",
stayOnCurrentPage:"=?",
success:"=?",
redirectUrl:"@?"
},
templateUrl:function(elem, attr) {
return angular.isDefined(attr.buttonOnly) ? "src/components/delete-project/delete-project-button.html" :"src/components/delete-project/delete-project.html";
},
replace:!0,
link:function(scope, element, attrs) {
var displayName = $filter("displayName"), navigateToList = function() {
if (!scope.stayOnCurrentPage) {
if (scope.redirectUrl) return void $location.url(scope.redirectUrl);
if ("/" === $location.path()) return void scope.$emit("deleteProject");
var homeRedirect = URI("/");
$location.url(homeRedirect);
}
};
scope.openDeleteModal = function() {
if (!scope.disableDelete) {
var modalInstance = $uibModal.open({
animation:!0,
templateUrl:"src/components/delete-project/delete-project-modal.html",
controller:"DeleteProjectModalController",
scope:scope
});
modalInstance.result.then(function() {
var formattedResource = "Project '" + displayName(scope.project) + "'";
ProjectsService["delete"](scope.project).then(function() {
NotificationsService.addNotification({
type:"success",
message:formattedResource + " was marked for deletion."
}), scope.success && scope.success(), navigateToList();
})["catch"](function(err) {
NotificationsService.addNotification({
type:"error",
message:formattedResource + " could not be deleted.",
details:$filter("getErrorDetails")(err)
}), Logger.error(formattedResource + " could not be deleted.", err);
});
});
}
};
}
};
} ]), angular.module("openshiftCommonUI").controller("DeleteProjectModalController", [ "$scope", "$uibModalInstance", function($scope, $uibModalInstance) {
$scope["delete"] = function() {
$uibModalInstance.close("delete");
}, $scope.cancel = function() {
$uibModalInstance.dismiss("cancel");
};
} ]), angular.module("openshiftCommonUI").directive("editProject", [ "$window", function($window) {
return {
restrict:"E",
scope:{
project:"=",
submitButtonLabel:"@",
redirectAction:"&",
onCancel:"&",
isDialog:"@"
},
templateUrl:"src/components/edit-project/editProject.html",
controller:[ "$scope", "$filter", "$location", "Logger", "NotificationsService", "ProjectsService", "annotationNameFilter", "displayNameFilter", function($scope, $filter, $location, Logger, NotificationsService, ProjectsService, annotationNameFilter, displayNameFilter) {
$scope.submitButtonLabel || ($scope.submitButtonLabel = "Save"), $scope.isDialog = "true" === $scope.isDialog;
var annotation = $filter("annotation"), annotationName = $filter("annotationName"), editableFields = function(resource) {
return {
description:annotation(resource, "description"),
displayName:annotation(resource, "displayName")
};
}, mergeEditable = function(project, editable) {
var toSubmit = angular.copy(project);
return toSubmit.metadata.annotations[annotationName("description")] = editable.description, toSubmit.metadata.annotations[annotationName("displayName")] = editable.displayName, toSubmit;
}, cleanEditableAnnotations = function(resource) {
var paths = [ annotationNameFilter("description"), annotationNameFilter("displayName") ];
return _.each(paths, function(path) {
resource.metadata.annotations[path] || delete resource.metadata.annotations[path];
}), resource;
};
$scope.editableFields = editableFields($scope.project), $scope.update = function() {
$scope.disableInputs = !0, $scope.editProjectForm.$valid && ProjectsService.update($scope.project.metadata.name, cleanEditableAnnotations(mergeEditable($scope.project, $scope.editableFields))).then(function(project) {
var cb = $scope.redirectAction();
cb && cb(encodeURIComponent($scope.project.metadata.name)), NotificationsService.addNotification({
type:"success",
message:"Project '" + displayNameFilter(project) + "' was successfully updated."
});
}, function(result) {
$scope.disableInputs = !1, $scope.editableFields = editableFields($scope.project), NotificationsService.addNotification({
type:"error",
message:"An error occurred while updating project '" + displayNameFilter($scope.project) + "'.",
details:$filter("getErrorDetails")(result)
}), Logger.error("Project '" + displayNameFilter($scope.project) + "' could not be updated.", result);
});
}, $scope.cancelEditProject = function() {
var cb = $scope.onCancel();
cb ? cb() :$window.history.back();
};
} ]
};
} ]), angular.module("openshiftCommonUI").component("originModalPopup", {
transclude:!0,
bindings:{
modalTitle:"@",
shown:"<",
position:"@",
referenceElement:"<?",
onClose:"<"
},
templateUrl:"src/components/origin-modal-popup/origin-modal-popup.html",
controller:[ "$scope", "HTMLService", "$element", "$window", function($scope, HTMLService, $element, $window) {
function updatePosition() {
var positionElement = ctrl.referenceElement || $element[0].parentNode;
if (positionElement && HTMLService.isWindowAboveBreakpoint(HTMLService.WINDOW_SIZE_SM)) {
var topPos, leftPos, posAbove = ctrl.position && ctrl.position.indexOf("top") > -1, posLeft = ctrl.position && ctrl.position.indexOf("left") > -1, elementRect = positionElement.getBoundingClientRect(), windowHeight = $window.innerHeight, modalElement = $element[0].children[0], modalHeight = _.get(modalElement, "offsetHeight", 0), modalWidth = _.get(modalElement, "offsetWidth", 0);
elementRect.top < modalHeight ? posAbove = !1 :elementRect.bottom + modalHeight > windowHeight && (posAbove = !0), topPos = posAbove ? elementRect.top - modalHeight + "px" :elementRect.bottom + "px", leftPos = posLeft ? elementRect.left + "px" :elementRect.right - modalWidth + "px", ctrl.showAbove = posAbove, ctrl.showLeft = posLeft, ctrl.positionStyle = {
left:leftPos,
top:topPos
};
} else ctrl.positionStyle = {};
}
function showModalBackdrop() {
var backdropElement = '<div class="origin-modal-popup-backdrop modal-backdrop fade in tile-click-prevent"></div>', parentNode = ctrl.referenceElement ? ctrl.referenceElement.parentNode :$element[0].parentNode;
$(parentNode).append(backdropElement);
}
function hideModalBackdrop() {
$(".origin-modal-popup-backdrop").remove();
}
function onWindowResize() {
$scope.$evalAsync(updatePosition);
}
function onShow() {
showModalBackdrop(), debounceResize = _.debounce(onWindowResize, 50, {
maxWait:250
}), angular.element($window).on("resize", debounceResize);
}
function onHide() {
hideModalBackdrop(), debounceResize && (angular.element($window).off("resize", debounceResize), debounceResize = null);
}
var debounceResize, ctrl = this;
ctrl.$onChanges = function(changeObj) {
changeObj.shown && (ctrl.shown ? onShow() :onHide()), (changeObj.shown || changeObj.referenceElement) && ctrl.shown && updatePosition();
}, ctrl.$onDestroy = function() {
ctrl.shown && onHide();
};
} ]
}), angular.module("openshiftCommonUI").directive("oscUnique", function() {
return {
restrict:"A",
scope:{
oscUnique:"=",
oscUniqueDisabled:"="
},
require:"ngModel",
link:function($scope, $elem, $attrs, ctrl) {
var list = [], isUnique = !0;
$scope.$watchCollection("oscUnique", function(newVal) {
list = _.isArray(newVal) ? newVal :_.keys(newVal);
});
var updateValidity = function() {
ctrl.$setValidity("oscUnique", $scope.oscUniqueDisabled || isUnique);
};
$scope.$watch("oscUniqueDisabled", updateValidity), ctrl.$parsers.unshift(function(value) {
return isUnique = !_.includes(list, value), updateValidity(), value;
});
}
};
}), angular.module("openshiftCommonUI").directive("toggle", [ "IS_IOS", function(IS_IOS) {
var setCursor = function(cursor) {
$("body").css("cursor", cursor);
}, setCursorPointer = _.partial(setCursor, "pointer"), setCursorAuto = _.partial(setCursor, "auto");
return IS_IOS && ($(document).on("shown.bs.popover", setCursorPointer), $(document).on("shown.bs.tooltip", setCursorPointer), $(document).on("hide.bs.popover", setCursorAuto), $(document).on("hide.bs.tooltip", setCursorAuto)), {
restrict:"A",
scope:{
dynamicContent:"@?"
},
link:function($scope, element, attrs) {
var popupConfig = {
container:attrs.container || "body",
placement:attrs.placement || "auto"
};
if (attrs) switch (attrs.toggle) {
case "popover":
(attrs.dynamicContent || "" === attrs.dynamicContent) && $scope.$watch("dynamicContent", function() {
$(element).popover("destroy"), setTimeout(function() {
$(element).attr("data-content", $scope.dynamicContent).popover(popupConfig);
}, 200);
}), $(element).popover(popupConfig), $scope.$on("$destroy", function() {
$(element).popover("destroy");
});
break;

case "tooltip":
(attrs.dynamicContent || "" === attrs.dynamicContent) && $scope.$watch("dynamicContent", function() {
$(element).tooltip("destroy"), setTimeout(function() {
$(element).attr("title", $scope.dynamicContent).tooltip(popupConfig);
}, 200);
}), $(element).tooltip(popupConfig), $scope.$on("$destroy", function() {
$(element).tooltip("destroy");
});
break;

case "dropdown":
"dropdown" === attrs.hover && ($(element).dropdownHover({
delay:200
}), $(element).dropdown());
}
}
};
} ]), angular.module("openshiftCommonUI").directive("takeFocus", [ "$timeout", function($timeout) {
return {
restrict:"A",
link:function(scope, element) {
$timeout(function() {
$(element).focus();
}, 300);
}
};
} ]), angular.module("openshiftCommonUI").directive("tileClick", function() {
return {
restrict:"AC",
link:function($scope, element) {
$(element).click(function(evt) {
var t = $(evt.target);
t && (t.closest("a", element).length || t.closest("button", element).length) || t.closest(".tile-click-prevent", element).length || angular.element($("a.tile-target", element))[0].click();
});
}
};
}), angular.module("openshiftCommonUI").directive("toastNotifications", [ "NotificationsService", "$rootScope", "$timeout", function(NotificationsService, $rootScope, $timeout) {
return {
restrict:"E",
scope:{},
templateUrl:"src/components/toast-notifications/toast-notifications.html",
link:function($scope) {
$scope.notifications = [];
var isRemoved = function(notification) {
return notification.hidden && !notification.isHover;
}, removeNotification = function(notification) {
notification.isHover = !1, notification.hidden = !0;
}, pruneRemovedNotifications = function() {
$scope.notifications = _.reject($scope.notifications, isRemoved);
};
$scope.close = function(notification) {
removeNotification(notification), _.isFunction(notification.onClose) && notification.onClose();
}, $scope.onClick = function(notification, link) {
if (_.isFunction(link.onClick)) {
var close = link.onClick();
close && removeNotification(notification);
}
}, $scope.setHover = function(notification, isHover) {
isRemoved(notification) || (notification.isHover = isHover);
};
var deregisterNotificationListener = $rootScope.$on("NotificationsService.onNotificationAdded", function(event, notification) {
notification.skipToast || $scope.$evalAsync(function() {
$scope.notifications.push(notification), NotificationsService.isAutoDismiss(notification) && $timeout(function() {
notification.hidden = !0;
}, NotificationsService.dismissDelay), pruneRemovedNotifications();
});
});
$scope.$on("$destroy", function() {
deregisterNotificationListener && (deregisterNotificationListener(), deregisterNotificationListener = null);
});
}
};
} ]), angular.module("openshiftCommonUI").directive("truncateLongText", [ "truncateFilter", function(truncateFilter) {
return {
restrict:"E",
scope:{
content:"=",
limit:"=",
newlineLimit:"=",
useWordBoundary:"=",
expandable:"=",
hideCollapse:"=",
keywords:"=highlightKeywords",
linkify:"=?"
},
templateUrl:"src/components/truncate-long-text/truncateLongText.html",
link:function(scope) {
scope.toggles = {
expanded:!1
}, scope.$watch("content", function(content) {
content ? (scope.truncatedContent = truncateFilter(content, scope.limit, scope.useWordBoundary, scope.newlineLimit), scope.truncated = scope.truncatedContent.length !== content.length) :(scope.truncatedContent = null, scope.truncated = !1);
});
}
};
} ]), angular.module("openshiftCommonServices").constant("API_PREFERRED_VERSIONS", {
appliedclusterresourcequotas:{
group:"quota.openshift.io",
version:"v1",
resource:"appliedclusterresourcequotas"
},
builds:{
group:"build.openshift.io",
version:"v1",
resource:"builds"
},
"builds/clone":{
group:"build.openshift.io",
version:"v1",
resource:"builds/clone"
},
"buildconfigs/instantiate":{
group:"build.openshift.io",
version:"v1",
resource:"buildconfigs/instantiate"
},
buildconfigs:{
group:"build.openshift.io",
version:"v1",
resource:"buildconfigs"
},
configmaps:{
version:"v1",
resource:"configmaps"
},
clusterserviceclasses:{
group:"servicecatalog.k8s.io",
version:"v1beta1",
resource:"clusterserviceclasses"
},
clusterserviceplans:{
group:"servicecatalog.k8s.io",
version:"v1beta1",
resource:"clusterserviceplans"
},
deployments:{
group:"apps",
version:"v1beta1",
resource:"deployments"
},
deploymentconfigs:{
group:"apps.openshift.io",
version:"v1",
resource:"deploymentconfigs"
},
"deploymentconfigs/instantiate":{
group:"apps.openshift.io",
version:"v1",
resource:"deploymentconfigs/instantiate"
},
"deploymentconfigs/rollback":{
group:"apps.openshift.io",
version:"v1",
resource:"deploymentconfigs/rollback"
},
events:{
version:"v1",
resource:"events"
},
horizontalpodautoscalers:{
group:"autoscaling",
version:"v1",
resource:"horizontalpodautoscalers"
},
imagestreams:{
group:"image.openshift.io",
version:"v1",
resource:"imagestreams"
},
imagestreamtags:{
group:"image.openshift.io",
version:"v1",
resource:"imagestreamtags"
},
limitranges:{
version:"v1",
resource:"limitranges"
},
pods:{
version:"v1",
resource:"pods"
},
projects:{
group:"project.openshift.io",
version:"v1",
resource:"projects"
},
projectrequests:{
group:"project.openshift.io",
version:"v1",
resource:"projectrequests"
},
persistentvolumeclaims:{
version:"v1",
resource:"persistentvolumeclaims"
},
replicasets:{
group:"extensions",
version:"v1beta1",
resource:"replicasets"
},
replicationcontrollers:{
version:"v1",
resource:"replicationcontrollers"
},
resourcequotas:{
version:"v1",
resource:"resourcequotas"
},
rolebindings:{
version:"v1",
resource:"rolebindings"
},
routes:{
group:"route.openshift.io",
version:"v1",
resource:"routes"
},
secrets:{
version:"v1",
resource:"secrets"
},
selfsubjectrulesreviews:{
group:"authorization.openshift.io",
version:"v1",
resource:"selfsubjectrulesreviews"
},
services:{
version:"v1",
resource:"services"
},
serviceaccounts:{
version:"v1",
resource:"serviceaccounts"
},
servicebindings:{
group:"servicecatalog.k8s.io",
version:"v1beta1",
resource:"servicebindings"
},
serviceinstances:{
group:"servicecatalog.k8s.io",
version:"v1beta1",
resource:"serviceinstances"
},
statefulsets:{
group:"apps",
version:"v1beta1",
resource:"statefulsets"
},
templates:{
group:"template.openshift.io",
verison:"v1",
resource:"templates"
}
}), angular.module("openshiftCommonUI").filter("alertStatus", function() {
return function(type) {
switch (type = type || "", type.toLowerCase()) {
case "error":
return "alert-danger";

case "warning":
return "alert-warning";

case "success":
return "alert-success";

case "normal":
return "alert-info";
}
return "alert-info";
};
}).filter("alertIcon", function() {
return function(type) {
switch (type = type || "", type.toLowerCase()) {
case "error":
return "pficon pficon-error-circle-o";

case "warning":
return "pficon pficon-warning-triangle-o";

case "success":
return "pficon pficon-ok";

case "normal":
return "pficon pficon-info";
}
return "pficon pficon-info";
};
}), angular.module("openshiftCommonUI").filter("annotationName", function() {
var annotationMap = {
buildConfig:[ "openshift.io/build-config.name" ],
deploymentConfig:[ "openshift.io/deployment-config.name" ],
deployment:[ "openshift.io/deployment.name" ],
pod:[ "openshift.io/deployer-pod.name" ],
deployerPod:[ "openshift.io/deployer-pod.name" ],
deployerPodFor:[ "openshift.io/deployer-pod-for.name" ],
deploymentStatus:[ "openshift.io/deployment.phase" ],
deploymentStatusReason:[ "openshift.io/deployment.status-reason" ],
deploymentCancelled:[ "openshift.io/deployment.cancelled" ],
encodedDeploymentConfig:[ "openshift.io/encoded-deployment-config" ],
deploymentVersion:[ "openshift.io/deployment-config.latest-version" ],
displayName:[ "openshift.io/display-name" ],
description:[ "openshift.io/description" ],
buildNumber:[ "openshift.io/build.number" ],
buildPod:[ "openshift.io/build.pod-name" ],
jenkinsBuildURL:[ "openshift.io/jenkins-build-uri" ],
jenkinsLogURL:[ "openshift.io/jenkins-log-url" ],
jenkinsStatus:[ "openshift.io/jenkins-status-json" ],
loggingUIHostname:[ "openshift.io/logging.ui.hostname" ],
idledAt:[ "idling.alpha.openshift.io/idled-at" ],
idledPreviousScale:[ "idling.alpha.openshift.io/previous-scale" ],
systemOnly:[ "authorization.openshift.io/system-only" ]
};
return function(annotationKey) {
return annotationMap[annotationKey] || null;
};
}).filter("annotation", [ "annotationNameFilter", function(annotationNameFilter) {
return function(resource, key) {
if (resource && resource.metadata && resource.metadata.annotations) {
if (void 0 !== resource.metadata.annotations[key]) return resource.metadata.annotations[key];
for (var mappings = annotationNameFilter(key) || [], i = 0; i < mappings.length; i++) {
var mappedKey = mappings[i];
if (void 0 !== resource.metadata.annotations[mappedKey]) return resource.metadata.annotations[mappedKey];
}
return null;
}
return null;
};
} ]).filter("imageStreamTagAnnotation", function() {
return function(resource, key, tagName) {
if (tagName = tagName || "latest", resource && resource.spec && resource.spec.tags) for (var tags = resource.spec.tags, i = 0; i < _.size(tags); ++i) {
var tag = tags[i];
if (tagName === tag.name && tag.annotations) return tag.annotations[key];
}
return null;
};
}).filter("imageStreamTagTags", [ "imageStreamTagAnnotationFilter", function(imageStreamTagAnnotationFilter) {
return function(resource, tagName) {
var imageTags = imageStreamTagAnnotationFilter(resource, "tags", tagName);
return imageTags ? imageTags.split(/\s*,\s*/) :[];
};
} ]).filter("imageStreamTagIconClass", [ "imageStreamTagAnnotationFilter", function(imageStreamTagAnnotationFilter) {
return function(resource, tagName) {
var icon = imageStreamTagAnnotationFilter(resource, "iconClass", tagName);
return icon ? icon :"fa fa-cube";
};
} ]), angular.module("openshiftCommonUI").filter("canI", [ "AuthorizationService", function(AuthorizationService) {
return function(resource, verb, projectName) {
return AuthorizationService.canI(resource, verb, projectName);
};
} ]).filter("canIAddToProject", [ "AuthorizationService", function(AuthorizationService) {
return function(namespace) {
return AuthorizationService.canIAddToProject(namespace);
};
} ]), angular.module("openshiftCommonUI").filter("isNewerResource", function() {
return function(candidate, other) {
var candidateCreation = _.get(candidate, "metadata.creationTimestamp");
if (!candidateCreation) return !1;
var otherCreation = _.get(other, "metadata.creationTimestamp");
return otherCreation ? candidateCreation > otherCreation :!0;
};
}).filter("mostRecent", [ "isNewerResourceFilter", function(isNewerResourceFilter) {
return function(objects) {
var mostRecent = null;
return _.each(objects, function(object) {
(!mostRecent || isNewerResourceFilter(object, mostRecent)) && (mostRecent = object);
}), mostRecent;
};
} ]).filter("orderObjectsByDate", [ "toArrayFilter", function(toArrayFilter) {
return function(items, reverse) {
return items = toArrayFilter(items), items.sort(function(a, b) {
if (!(a.metadata && a.metadata.creationTimestamp && b.metadata && b.metadata.creationTimestamp)) throw "orderObjectsByDate expects all objects to have the field metadata.creationTimestamp";
return a.metadata.creationTimestamp < b.metadata.creationTimestamp ? reverse ? 1 :-1 :a.metadata.creationTimestamp > b.metadata.creationTimestamp ? reverse ? -1 :1 :0;
}), items;
};
} ]), angular.module("openshiftCommonUI").filter("highlightKeywords", [ "KeywordService", function(KeywordService) {
return function(str, keywords, caseSensitive) {
if (!str) return str;
if (_.isEmpty(keywords)) return _.escape(str);
_.isString(keywords) && (keywords = KeywordService.generateKeywords(keywords));
for (var match, source = _.map(keywords, function(keyword) {
return _.isRegExp(keyword) ? keyword.source :_.escapeRegExp(keyword);
}).join("|"), result = "", lastIndex = 0, flags = caseSensitive ? "g" :"ig", regex = new RegExp(source, flags); null !== (match = regex.exec(str)); ) lastIndex < match.index && (result += _.escape(str.substring(lastIndex, match.index))), result += "<mark>" + _.escape(match[0]) + "</mark>", lastIndex = regex.lastIndex;
return lastIndex < str.length && (result += _.escape(str.substring(lastIndex))), result;
};
} ]), angular.module("openshiftCommonUI").filter("imageForIconClass", [ "$window", "isAbsoluteURLFilter", function($window, isAbsoluteURLFilter) {
return function(iconClass) {
if (!iconClass) return "";
var logoImage = _.get($window, [ "OPENSHIFT_CONSTANTS", "LOGOS", iconClass ]);
if (!logoImage) return "";
var logoBaseUrl = _.get($window, "OPENSHIFT_CONSTANTS.LOGO_BASE_URL");
return !logoBaseUrl || isAbsoluteURLFilter(logoImage) ? logoImage :(_.endsWith(logoBaseUrl, "/") || (logoBaseUrl += "/"), logoBaseUrl + logoImage);
};
} ]), angular.module("openshiftCommonUI").filter("isAbsoluteURL", function() {
return function(url) {
if (!url || !_.isString(url)) return !1;
var uri = new URI(url), protocol = uri.protocol();
return uri.is("absolute") && ("http" === protocol || "https" === protocol);
};
}), angular.module("openshiftCommonUI").filter("linkify", [ "HTMLService", function(HTMLService) {
return function(text, target, alreadyEscaped) {
return HTMLService.linkify(text, target, alreadyEscaped);
};
} ]), angular.module("openshiftCommonUI").filter("parseJSON", function() {
return function(json) {
if (!json) return null;
try {
var jsonObj = JSON.parse(json);
return "object" == typeof jsonObj ? jsonObj :null;
} catch (e) {
return null;
}
};
}), angular.module("openshiftCommonUI").filter("preferredVersion", [ "APIService", function(APIService) {
return APIService.getPreferredVersion;
} ]), angular.module("openshiftCommonUI").filter("prettifyJSON", [ "parseJSONFilter", function(parseJSONFilter) {
return function(json) {
var jsonObj = parseJSONFilter(json);
return jsonObj ? JSON.stringify(jsonObj, null, 4) :json;
};
} ]), angular.module("openshiftCommonUI").filter("uid", function() {
return function(resource) {
return resource && resource.metadata && resource.metadata.uid ? resource.metadata.uid :resource;
};
}).filter("labelName", function() {
var labelMap = {
buildConfig:[ "openshift.io/build-config.name" ],
deploymentConfig:[ "openshift.io/deployment-config.name" ]
};
return function(labelKey) {
return labelMap[labelKey];
};
}).filter("description", [ "annotationFilter", function(annotationFilter) {
return function(resource) {
return annotationFilter(resource, "openshift.io/description") || annotationFilter(resource, "kubernetes.io/description") || annotationFilter(resource, "description");
};
} ]).filter("displayName", [ "annotationFilter", function(annotationFilter) {
return function(resource, annotationOnly) {
var displayName = annotationFilter(resource, "displayName");
return displayName || annotationOnly ? displayName :resource && resource.metadata ? resource.metadata.name :null;
};
} ]).filter("uniqueDisplayName", [ "displayNameFilter", function(displayNameFilter) {
function countNames(projects) {
var nameCount = {};
return angular.forEach(projects, function(project, key) {
var displayName = displayNameFilter(project);
nameCount[displayName] = (nameCount[displayName] || 0) + 1;
}), nameCount;
}
return function(resource, projects) {
if (!resource) return "";
var displayName = displayNameFilter(resource), name = resource.metadata.name;
return displayName !== name && countNames(projects)[displayName] > 1 ? displayName + " (" + name + ")" :displayName;
};
} ]).filter("searchProjects", [ "displayNameFilter", function(displayNameFilter) {
return function(projects, text) {
return text ? (text = text.toLowerCase(), _.filter(projects, function(project) {
if (_.includes(project.metadata.name, text)) return !0;
var displayName = displayNameFilter(project, !0);
return displayName && _.includes(displayName.toLowerCase(), text) ? !0 :!1;
})) :projects;
};
} ]).filter("label", function() {
return function(resource, key) {
return resource && resource.metadata && resource.metadata.labels ? resource.metadata.labels[key] :null;
};
}).filter("humanizeKind", [ "startCaseFilter", function(startCaseFilter) {
return function(kind, useTitleCase) {
if (!kind) return kind;
if ("ServiceInstance" === kind) return useTitleCase ? "Provisioned Service" :"provisioned service";
var humanized = _.startCase(kind);
return useTitleCase ? humanized :humanized.toLowerCase();
};
} ]).filter("statusCondition", function() {
return function(apiObject, type) {
return apiObject ? _.find(_.get(apiObject, "status.conditions"), {
type:type
}) :null;
};
}).filter("isServiceInstanceReady", [ "statusConditionFilter", function(statusConditionFilter) {
return function(apiObject) {
return "True" === _.get(statusConditionFilter(apiObject, "Ready"), "status");
};
} ]).filter("serviceInstanceReadyMessage", [ "statusConditionFilter", function(statusConditionFilter) {
return function(apiObject) {
return _.get(statusConditionFilter(apiObject, "Ready"), "message");
};
} ]).filter("isServiceInstanceFailed", [ "statusConditionFilter", function(statusConditionFilter) {
return function(apiObject) {
return "True" === _.get(statusConditionFilter(apiObject, "Failed"), "status");
};
} ]).filter("serviceInstanceFailedMessage", [ "isServiceInstanceFailedFilter", "statusConditionFilter", function(isServiceInstanceFailedFilter, statusConditionFilter) {
return function(apiObject) {
return isServiceInstanceFailedFilter(apiObject) ? _.get(statusConditionFilter(apiObject, "Failed"), "message") :void 0;
};
} ]).filter("isBindingReady", [ "isServiceInstanceReadyFilter", function(isServiceInstanceReadyFilter) {
return isServiceInstanceReadyFilter;
} ]).filter("isBindingFailed", [ "isServiceInstanceFailedFilter", function(isServiceInstanceFailedFilter) {
return isServiceInstanceFailedFilter;
} ]).filter("bindingFailedMessage", [ "serviceInstanceFailedMessageFilter", function(serviceInstanceFailedMessageFilter) {
return serviceInstanceFailedMessageFilter;
} ]).filter("bindingReadyMessage", [ "serviceInstanceReadyMessageFilter", function(serviceInstanceReadyMessageFilter) {
return serviceInstanceReadyMessageFilter;
} ]).filter("hasDeployment", [ "annotationFilter", function(annotationFilter) {
return function(object) {
return !!annotationFilter(object, "deployment.kubernetes.io/revision");
};
} ]).filter("hasDeploymentConfig", [ "annotationFilter", function(annotationFilter) {
return function(deployment) {
return !!annotationFilter(deployment, "deploymentConfig");
};
} ]).filter("serviceClassDisplayName", function() {
return function(serviceClass) {
var serviceClassDisplayName = _.get(serviceClass, "spec.externalMetadata.displayName");
return serviceClassDisplayName ? serviceClassDisplayName :_.get(serviceClass, "spec.externalName");
};
}).filter("serviceInstanceDisplayName", [ "serviceClassDisplayNameFilter", function(serviceClassDisplayNameFilter) {
return function(instance, serviceClass) {
if (serviceClass) return serviceClassDisplayNameFilter(serviceClass);
var serviceClassExternalName = _.get(instance, "spec.clusterServiceClassExternalName");
return serviceClassExternalName ? serviceClassExternalName :_.get(instance, "metadata.name");
};
} ]).filter("serviceInstanceStatus", [ "isServiceInstanceReadyFilter", function(isServiceInstanceReadyFilter) {
return function(instance) {
var status = "Pending", conditions = _.get(instance, "status.conditions"), instanceError = _.find(conditions, {
type:"Failed",
status:"True"
});
return instanceError ? status = "Failed" :isServiceInstanceReadyFilter(instance) && (status = "Ready"), status;
};
} ]), angular.module("openshiftCommonUI").filter("camelToLower", function() {
return function(str) {
return str ? _.startCase(str).toLowerCase() :"";
};
}).filter("upperFirst", function() {
return _.upperFirst;
}).filter("sentenceCase", [ "camelToLowerFilter", function(camelToLowerFilter) {
return function(str) {
var lower = camelToLowerFilter(str);
return _.upperFirst(lower);
};
} ]).filter("startCase", function() {
return _.startCase;
}).filter("capitalize", function() {
return _.capitalize;
}).filter("isMultiline", function() {
return function(str, ignoreTrailing) {
if (!str) return !1;
var index = str.search(/\r|\n/);
return -1 === index ? !1 :ignoreTrailing ? index !== str.length - 1 :!0;
};
}), angular.module("openshiftCommonUI").filter("truncate", function() {
return function(str, charLimit, useWordBoundary, newlineLimit) {
if ("string" != typeof str) return str;
var truncated = str;
if (charLimit && (truncated = truncated.substring(0, charLimit)), newlineLimit) {
var nthNewline = str.split("\n", newlineLimit).join("\n").length;
truncated = truncated.substring(0, nthNewline);
}
if (useWordBoundary !== !1) {
var startIndex = Math.max(4, charLimit - 10), lastSpace = truncated.lastIndexOf(" ");
lastSpace >= startIndex && -1 !== lastSpace && (truncated = truncated.substring(0, lastSpace));
}
return truncated;
};
}), angular.module("openshiftCommonUI").filter("toArray", function() {
return _.toArray;
}).filter("size", function() {
return _.size;
}).filter("hashSize", function() {
return function(hash) {
return hash ? Object.keys(hash).length :0;
};
}).filter("filterCollection", function() {
return function(collection, predicate) {
return collection && predicate ? _.filter(collection, predicate) :collection;
};
}).filter("generateName", function() {
return function(prefix, length) {
prefix || (prefix = ""), length || (length = 5);
var randomString = Math.round(Math.pow(36, length + 1) - Math.random() * Math.pow(36, length)).toString(36).slice(1);
return prefix + randomString;
};
}).filter("getErrorDetails", [ "upperFirstFilter", function(upperFirstFilter) {
return function(result, capitalize) {
if (!result) return "";
var error = result.data || {};
if (error.message) return capitalize ? upperFirstFilter(error.message) :error.message;
var status = result.status || error.status;
return status ? "Status: " + status :"";
};
} ]), angular.module("openshiftCommonServices").service("AlertMessageService", function() {
var alertHiddenKey = function(alertID, namespace) {
return namespace ? "hide/alert/" + namespace + "/" + alertID :"hide/alert/" + alertID;
};
return {
isAlertPermanentlyHidden:function(alertID, namespace) {
var key = alertHiddenKey(alertID, namespace);
return "true" === localStorage.getItem(key);
},
permanentlyHideAlert:function(alertID, namespace) {
var key = alertHiddenKey(alertID, namespace);
localStorage.setItem(key, "true");
}
};
}), ResourceGroupVersion.prototype.toString = function() {
var s = this.resource;
return this.group && (s += "/" + this.group), this.version && (s += "/" + this.version), s;
}, ResourceGroupVersion.prototype.primaryResource = function() {
if (!this.resource) return "";
var i = this.resource.indexOf("/");
return -1 === i ? this.resource :this.resource.substring(0, i);
}, ResourceGroupVersion.prototype.subresources = function() {
var segments = (this.resource || "").split("/");
return segments.shift(), segments;
}, ResourceGroupVersion.prototype.equals = function(resource, group, version) {
return this.resource !== resource ? !1 :1 === arguments.length ? !0 :this.group !== group ? !1 :2 === arguments.length ? !0 :this.version !== version ? !1 :!0;
}, angular.module("openshiftCommonServices").factory("APIService", [ "API_CFG", "APIS_CFG", "API_PREFERRED_VERSIONS", "AuthService", "Constants", "Logger", "$q", "$http", "$filter", "$window", function(API_CFG, APIS_CFG, API_PREFERRED_VERSIONS, AuthService, Constants, Logger, $q, $http, $filter, $window) {
function normalizeResource(resource) {
if (!resource) return resource;
var i = resource.indexOf("/");
return -1 === i ? resource.toLowerCase() :resource.substring(0, i).toLowerCase() + resource.substring(i);
}
function kindToResource(kind, humanize) {
if (!kind) return "";
var resource = kind;
if (humanize) {
var humanizeKind = $filter("humanizeKind");
resource = humanizeKind(resource);
}
return resource = String(resource).toLowerCase(), "endpoints" === resource || "securitycontextconstraints" === resource || ("s" === resource[resource.length - 1] ? resource += "es" :"y" === resource[resource.length - 1] ? resource = resource.substring(0, resource.length - 1) + "ies" :resource += "s"), resource;
}
function kindToResourceGroupVersion(kind) {
return toResourceGroupVersion({
resource:kindToResource(kind.kind),
group:kind.group
});
}
var defaultVersion = {
"":"v1",
extensions:"v1beta1"
}, toResourceGroupVersion = function(r) {
if (r instanceof ResourceGroupVersion) return r;
var resource, group, version;
return angular.isString(r) ? (resource = normalizeResource(r), group = "", version = defaultVersion[group]) :r && r.resource && (resource = normalizeResource(r.resource), group = r.group || "", version = r.version || defaultVersion[group] || _.get(APIS_CFG, [ "groups", group, "preferredVersion" ])), new ResourceGroupVersion(resource, group, version);
}, parseGroupVersion = function(apiVersion) {
if (!apiVersion) return void 0;
var parts = apiVersion.split("/");
return 1 === parts.length ? "v1" === parts[0] ? {
group:"",
version:parts[0]
} :{
group:parts[0],
version:""
} :2 === parts.length ? {
group:parts[0],
version:parts[1]
} :void Logger.warn('Invalid apiVersion "' + apiVersion + '"');
}, objectToResourceGroupVersion = function(apiObject) {
if (!apiObject || !apiObject.kind || !apiObject.apiVersion) return void 0;
var resource = kindToResource(apiObject.kind);
if (!resource) return void 0;
var groupVersion = parseGroupVersion(apiObject.apiVersion);
return groupVersion ? new ResourceGroupVersion(resource, groupVersion.group, groupVersion.version) :void 0;
}, deriveTargetResource = function(resource, object) {
if (!resource || !object) return void 0;
var objectResource = kindToResource(object.kind), objectGroupVersion = parseGroupVersion(object.apiVersion), resourceGroupVersion = toResourceGroupVersion(resource);
return objectResource && objectGroupVersion && resourceGroupVersion ? angular.isString(resource) ? (resourceGroupVersion.equals(objectResource) && (resourceGroupVersion.group = objectGroupVersion.group, resourceGroupVersion.version = objectGroupVersion.version), resourceGroupVersion) :(resourceGroupVersion.equals(objectResource, objectGroupVersion.group) && (resourceGroupVersion.version = objectGroupVersion.version), resourceGroupVersion) :void 0;
}, apiInfo = function(resource) {
if (APIS_CFG.API_DISCOVERY_ERRORS) {
var possibleCertFailure = _.every(APIS_CFG.API_DISCOVERY_ERRORS, function(error) {
return 0 === _.get(error, "data.status");
});
if (possibleCertFailure && !AuthService.isLoggedIn()) return void AuthService.withUser();
var fatal = !1;
if (_.each(APIS_CFG.API_DISCOVERY_ERRORS, function(discoveryError) {
return discoveryError.fatal ? (Logger.error("API discovery failed (fatal error)", discoveryError), void (fatal = !0)) :void Logger.warn("API discovery failed", discoveryError);
}), fatal) return void ($window.location.href = URI("error").query({
error_description:"Unable to load details about the server. If the problem continues, please contact your system administrator.",
error:"API_DISCOVERY"
}).toString());
}
resource = toResourceGroupVersion(resource);
var discoveredResource, primaryResource = resource.primaryResource();
if (resource.group) {
if (discoveredResource = _.get(APIS_CFG, [ "groups", resource.group, "versions", resource.version, "resources", primaryResource ]), !discoveredResource) return void 0;
var hostPrefixObj = _.get(APIS_CFG, [ "groups", resource.group, "hostPrefix" ]) || APIS_CFG;
return {
resource:resource.resource,
group:resource.group,
version:resource.version,
protocol:hostPrefixObj.protocol,
hostPort:hostPrefixObj.hostPort,
prefix:hostPrefixObj.prefix,
namespaced:discoveredResource.namespaced,
verbs:discoveredResource.verbs
};
}
var api;
for (var apiName in API_CFG) if (api = API_CFG[apiName], discoveredResource = _.get(api, [ "resources", resource.version, primaryResource ])) return {
resource:resource.resource,
version:resource.version,
hostPort:api.hostPort,
prefix:api.prefix,
namespaced:discoveredResource.namespaced,
verbs:discoveredResource.verbs
};
return void 0;
}, invalidObjectKindOrVersion = function(apiObject) {
var kind = "<none>", version = "<none>";
return apiObject && apiObject.kind && (kind = apiObject.kind), apiObject && apiObject.apiVersion && (version = apiObject.apiVersion), "Invalid kind (" + kind + ") or API version (" + version + ")";
}, unsupportedObjectKindOrVersion = function(apiObject) {
var kind = "<none>", version = "<none>";
return apiObject && apiObject.kind && (kind = apiObject.kind), apiObject && apiObject.apiVersion && (version = apiObject.apiVersion), "The API version " + version + " for kind " + kind + " is not supported by this server";
}, dedupeGroups = [ {
group:"authorization.openshift.io"
} ], dedupeKinds = [ {
group:"extensions",
kind:"HorizontalPodAutoscaler"
} ], excludeKindFromAPIGroupList = function(groupName, resourceKind) {
return !(!_.find(dedupeKinds, {
group:groupName,
kind:resourceKind
}) && !_.find(dedupeGroups, {
group:groupName
}));
}, calculateAvailableKinds = function(includeClusterScoped) {
var kinds = [], rejectedKinds = _.map(Constants.AVAILABLE_KINDS_BLACKLIST, function(kind) {
return _.isString(kind) ? {
kind:kind,
group:""
} :kind;
});
return _.each(_.pickBy(API_CFG, function(value, key) {
return "openshift" !== key;
}), function(api) {
_.each(api.resources.v1, function(resource) {
if (resource.namespaced || includeClusterScoped) {
if (_.includes(resource.name, "/") || _.find(rejectedKinds, {
kind:resource.kind,
group:""
})) return;
kinds.push({
kind:resource.kind,
group:""
});
}
});
}), _.each(APIS_CFG.groups, function(group) {
var preferredVersion = defaultVersion[group.name] || group.preferredVersion;
_.each(group.versions[preferredVersion].resources, function(resource) {
_.includes(resource.name, "/") || _.find(rejectedKinds, {
kind:resource.kind,
group:group.name
}) || excludeKindFromAPIGroupList(group.name, resource.kind) || (resource.namespaced || includeClusterScoped) && kinds.push({
kind:resource.kind,
group:group.name
});
});
}), _.uniqBy(kinds, function(value) {
return value.group + "/" + value.kind;
});
}, namespacedKinds = calculateAvailableKinds(!1), allKinds = calculateAvailableKinds(!0), availableKinds = function(includeClusterScoped) {
return includeClusterScoped ? allKinds :namespacedKinds;
}, getPreferredVersion = function(resource) {
var preferred = API_PREFERRED_VERSIONS[resource];
return preferred || Logger.log("No preferred version for ", resource), preferred;
};
return {
toResourceGroupVersion:toResourceGroupVersion,
parseGroupVersion:parseGroupVersion,
objectToResourceGroupVersion:objectToResourceGroupVersion,
deriveTargetResource:deriveTargetResource,
kindToResource:kindToResource,
kindToResourceGroupVersion:kindToResourceGroupVersion,
apiInfo:apiInfo,
invalidObjectKindOrVersion:invalidObjectKindOrVersion,
unsupportedObjectKindOrVersion:unsupportedObjectKindOrVersion,
availableKinds:availableKinds,
getPreferredVersion:getPreferredVersion
};
} ]), angular.module("openshiftCommonServices").service("ApplicationsService", [ "$q", "DataService", function($q, DataService) {
var listStandaloneReplicationControllers = function(context) {
return DataService.list("replicationcontrollers", context, null, {
http:{
params:{
labelSelector:"!openshift.io/deployment-config.name"
}
}
});
}, listStandaloneReplicaSets = function(context) {
return DataService.list({
group:"extensions",
resource:"replicasets"
}, context, null, {
http:{
params:{
labelSelector:"!pod-template-hash"
}
}
});
}, getApplications = function(context) {
var deferred = $q.defer(), promises = [];
return promises.push(DataService.list("deploymentconfigs", context)), promises.push(listStandaloneReplicationControllers(context)), promises.push(DataService.list({
group:"apps",
resource:"deployments"
}, context)), promises.push(listStandaloneReplicaSets(context)), promises.push(DataService.list({
group:"apps",
resource:"statefulsets"
}, context)), $q.all(promises).then(_.spread(function(deploymentConfigData, replicationControllerData, deploymentData, replicaSetData, statefulSetData) {
var deploymentConfigs = _.toArray(deploymentConfigData.by("metadata.name")), replicationControllers = _.toArray(replicationControllerData.by("metadata.name")), deployments = _.toArray(deploymentData.by("metadata.name")), replicaSets = _.toArray(replicaSetData.by("metadata.name")), statefulSets = _.toArray(statefulSetData.by("metadata.name")), apiObjects = deploymentConfigs.concat(deployments).concat(replicationControllers).concat(replicaSets).concat(statefulSets);
deferred.resolve(_.sortBy(apiObjects, [ "metadata.name", "kind" ]));
}), function(e) {
deferred.reject(e);
}), deferred.promise;
};
return {
listStandaloneReplicationControllers:listStandaloneReplicationControllers,
listStandaloneReplicaSets:listStandaloneReplicaSets,
getApplications:getApplications
};
} ]), angular.module("openshiftCommonServices").provider("AuthService", function() {
var _userStore = "";
this.UserStore = function(userStoreName) {
return userStoreName && (_userStore = userStoreName), _userStore;
};
var _loginService = "";
this.LoginService = function(loginServiceName) {
return loginServiceName && (_loginService = loginServiceName), _loginService;
};
var _logoutService = "";
this.LogoutService = function(logoutServiceName) {
return logoutServiceName && (_logoutService = logoutServiceName), _logoutService;
};
var loadService = function(injector, name, setter) {
if (name) return angular.isString(name) ? injector.get(name) :injector.invoke(name);
throw setter + " not set";
};
this.$get = [ "$q", "$injector", "$log", "$rootScope", "Logger", "base64", function($q, $injector, $log, $rootScope, Logger, base64) {
var authLogger = Logger.get("auth");
authLogger.log("AuthServiceProvider.$get", arguments);
var _loginCallbacks = $.Callbacks(), _logoutCallbacks = $.Callbacks(), _userChangedCallbacks = $.Callbacks(), _loginPromise = null, _logoutPromise = null, userStore = loadService($injector, _userStore, "AuthServiceProvider.UserStore()");
userStore.available() || Logger.error("AuthServiceProvider.$get user store " + _userStore + " not available");
var loginService = loadService($injector, _loginService, "AuthServiceProvider.LoginService()"), logoutService = loadService($injector, _logoutService, "AuthServiceProvider.LogoutService()");
return {
UserStore:function() {
return userStore;
},
isLoggedIn:function() {
return !!userStore.getUser();
},
withUser:function() {
var user = userStore.getUser();
return user ? ($rootScope.user = user, authLogger.log("AuthService.withUser()", user), $q.when(user)) :(authLogger.log("AuthService.withUser(), calling startLogin()"), this.startLogin());
},
setUser:function(user, token, ttl) {
authLogger.log("AuthService.setUser()", user, token, ttl);
var oldUser = userStore.getUser();
userStore.setUser(user, ttl), userStore.setToken(token, ttl), $rootScope.user = user;
var oldName = oldUser && oldUser.metadata && oldUser.metadata.name, newName = user && user.metadata && user.metadata.name;
oldName !== newName && (authLogger.log("AuthService.setUser(), user changed", oldUser, user), _userChangedCallbacks.fire(user));
},
requestRequiresAuth:function(config) {
var requiresAuth = !!config.auth;
return authLogger.log("AuthService.requestRequiresAuth()", config.url.toString(), requiresAuth), requiresAuth;
},
addAuthToRequest:function(config) {
var token = "";
return config && config.auth && config.auth.token ? (token = config.auth.token, authLogger.log("AuthService.addAuthToRequest(), using token from request config", token)) :(token = userStore.getToken(), authLogger.log("AuthService.addAuthToRequest(), using token from user store", token)), token ? ("WATCH" === config.method ? (config.protocols = config.protocols || [], _.isArray(config.protocols) || (config.protocols = [ config.protocols ]), 0 == config.protocols.length && config.protocols.unshift("undefined"), config.protocols.unshift("base64url.bearer.authorization.k8s.io." + base64.urlencode(token)), authLogger.log("AuthService.addAuthToRequest(), added token protocol", config.protocols)) :(config.headers.Authorization = "Bearer " + token, authLogger.log("AuthService.addAuthToRequest(), added token header", config.headers.Authorization)), !0) :(authLogger.log("AuthService.addAuthToRequest(), no token available"), !1);
},
startLogin:function() {
if (_loginPromise) return authLogger.log("Login already in progress"), _loginPromise;
var self = this;
return _loginPromise = loginService.login().then(function(result) {
self.setUser(result.user, result.token, result.ttl), _loginCallbacks.fire(result.user);
})["catch"](function(err) {
Logger.error(err);
})["finally"](function() {
_loginPromise = null;
});
},
startLogout:function() {
if (_logoutPromise) return authLogger.log("Logout already in progress"), _logoutPromise;
var self = this, user = userStore.getUser(), token = userStore.getToken(), wasLoggedIn = this.isLoggedIn();
return _logoutPromise = logoutService.logout(user, token).then(function() {
authLogger.log("Logout service success");
})["catch"](function(err) {
authLogger.error("Logout service error", err);
})["finally"](function() {
self.setUser(null, null);
var isLoggedIn = self.isLoggedIn();
wasLoggedIn && !isLoggedIn && _logoutCallbacks.fire(), _logoutPromise = null;
});
},
onLogin:function(callback) {
_loginCallbacks.add(callback);
},
onLogout:function(callback) {
_logoutCallbacks.add(callback);
},
onUserChanged:function(callback) {
_userChangedCallbacks.add(callback);
}
};
} ];
}).factory("AuthInterceptor", [ "$q", "AuthService", function($q, AuthService) {
var pendingRequestConfigs = [];
return {
request:function(config) {
if (!AuthService.requestRequiresAuth(config)) return config;
if (AuthService.addAuthToRequest(config)) return config;
if (config.auth && config.auth.triggerLogin === !1) return config;
var deferred = $q.defer();
return pendingRequestConfigs.push([ deferred, config, "request" ]), AuthService.startLogin(), deferred.promise;
},
responseError:function(rejection) {
var authConfig = rejection.config.auth || {};
if (!AuthService.requestRequiresAuth(rejection.config)) return $q.reject(rejection);
if (authConfig.triggerLogin === !1) return $q.reject(rejection);
var status = rejection.status;
switch (status) {
case 401:
var deferred = $q.defer();
return pendingRequestConfigs.push([ deferred, rejection.config, "responseError" ]), AuthService.startLogin(), deferred.promise;

default:
return $q.reject(rejection);
}
}
};
} ]), angular.module("openshiftCommonServices").factory("AuthorizationService", [ "$q", "$cacheFactory", "Logger", "$interval", "APIService", "DataService", function($q, $cacheFactory, Logger, $interval, APIService, DataService) {
var currentProject = null, cachedRulesByProject = $cacheFactory("rulesCache", {
number:10
}), permissiveMode = !1, REVIEW_RESOURCES = [ "localresourceaccessreviews", "localsubjectaccessreviews", "resourceaccessreviews", "selfsubjectaccessreviews", "selfsubjectrulesreviews", "subjectaccessreviews", "subjectrulesreviews", "podsecuritypolicyreviews", "podsecuritypolicysubjectreviews", "podsecuritypolicyselfsubjectreviews", "tokenreviews" ], normalizeRules = function(rules) {
var normalizedRules = {};
return _.each(rules, function(rule) {
_.each(rule.apiGroups, function(apiGroup) {
normalizedRules[apiGroup] || (normalizedRules[apiGroup] = {}), _.each(rule.resources, function(resource) {
normalizedRules[apiGroup][resource] = rule.verbs;
});
});
}), normalizedRules;
}, checkResource = function(resource) {
return "projectrequests" === resource || _.includes(resource, "/") || _.includes(REVIEW_RESOURCES, resource) ? !1 :!0;
}, canAddToProjectCheck = function(rules) {
return _.some(rules, function(rule) {
return _.some(rule.resources, function(resource) {
return checkResource(resource) && !_.isEmpty(_.intersection(rule.verbs, [ "*", "create", "update" ]));
});
});
}, inFlightRulesRequests = {}, getProjectRules = function(projectName, forceRefresh) {
var deferred = $q.defer();
currentProject = projectName;
var projectRules = cachedRulesByProject.get(projectName), rulesResource = "selfsubjectrulesreviews";
if (!projectRules || projectRules.forceRefresh || forceRefresh) if (APIService.apiInfo(rulesResource)) {
if (inFlightRulesRequests[projectName]) return inFlightRulesRequests[projectName];
Logger.log("AuthorizationService, loading user rules for " + projectName + " project"), inFlightRulesRequests[projectName] = deferred.promise;
var resourceGroupVersion = {
kind:"SelfSubjectRulesReview",
apiVersion:"v1"
};
DataService.create(rulesResource, null, resourceGroupVersion, {
namespace:projectName
}).then(function(data) {
var normalizedData = normalizeRules(data.status.rules), canUserAddToProject = canAddToProjectCheck(data.status.rules);
cachedRulesByProject.put(projectName, {
rules:normalizedData,
canAddToProject:canUserAddToProject,
forceRefresh:!1,
cacheTimestamp:_.now()
}), deferred.resolve();
}, function() {
permissiveMode = !0, deferred.resolve();
})["finally"](function() {
delete inFlightRulesRequests[projectName];
});
} else Logger.log("AuthorizationService, resource 'selfsubjectrulesreviews' is not part of APIserver. Switching into permissive mode."), permissiveMode = !0, deferred.resolve(); else Logger.log("AuthorizationService, using cached rules for " + projectName + " project"), _.now() - projectRules.cacheTimestamp >= 6e5 && (projectRules.forceRefresh = !0), deferred.resolve();
return deferred.promise;
}, getRulesForProject = function(projectName) {
return _.get(cachedRulesByProject.get(projectName || currentProject), [ "rules" ]);
}, _canI = function(rules, verb, group, resource) {
var resources = rules[group];
if (!resources) return !1;
var verbs = resources[resource];
return verbs ? _.includes(verbs, verb) || _.includes(verbs, "*") :!1;
}, canI = function(resource, verb, projectName) {
if (permissiveMode) return !0;
var r = APIService.toResourceGroupVersion(resource), rules = getRulesForProject(projectName || currentProject);
return rules ? _canI(rules, verb, r.group, r.resource) || _canI(rules, verb, "*", "*") || _canI(rules, verb, r.group, "*") || _canI(rules, verb, "*", r.resource) :!1;
}, canIAddToProject = function(projectName) {
return permissiveMode ? !0 :!!_.get(cachedRulesByProject.get(projectName || currentProject), [ "canAddToProject" ]);
};
return {
checkResource:checkResource,
getProjectRules:getProjectRules,
canI:canI,
canIAddToProject:canIAddToProject,
getRulesForProject:getRulesForProject
};
} ]), angular.module("openshiftCommonServices").factory("base64util", function() {
return {
pad:function(data) {
if (!data) return "";
switch (data.length % 4) {
case 1:
return data + "===";

case 2:
return data + "==";

case 3:
return data + "=";

default:
return data;
}
}
};
}), angular.module("openshiftCommonServices").service("BindingService", [ "$filter", "$q", "APIService", "AuthService", "DataService", "DNS1123_SUBDOMAIN_VALIDATION", function($filter, $q, APIService, AuthService, DataService, DNS1123_SUBDOMAIN_VALIDATION) {
var PARAMETERS_SECRET_KEY = "parameters", bindingResource = APIService.getPreferredVersion("servicebindings"), getServiceClassForInstance = function(serviceInstance, serviceClasses) {
if (!serviceClasses) return null;
var serviceClassName = _.get(serviceInstance, "spec.clusterServiceClassRef.name");
return serviceClassName ? serviceClasses[serviceClassName] :null;
}, generateName = $filter("generateName"), generateSecretName = function(prefix) {
var generateNameLength = 5, secretNamePrefix = _.truncate(prefix, {
length:DNS1123_SUBDOMAIN_VALIDATION.maxlength - generateNameLength - 1,
omission:""
});
return generateName(secretNamePrefix, generateNameLength);
}, makeParametersSecret = function(secretName, parameters, owner) {
var secret = {
apiVersion:"v1",
kind:"Secret",
metadata:{
name:secretName,
ownerReferences:[ {
apiVersion:owner.apiVersion,
kind:owner.kind,
name:owner.metadata.name,
uid:owner.metadata.uid,
controller:!1,
blockOwnerDeletion:!1
} ]
},
type:"Opaque",
stringData:{}
};
return secret.stringData[PARAMETERS_SECRET_KEY] = JSON.stringify(parameters), secret;
}, makeBinding = function(serviceInstance, application, parametersSecretName) {
var instanceName = serviceInstance.metadata.name, credentialSecretName = generateSecretName(serviceInstance.metadata.name + "-credentials-"), binding = {
kind:"ServiceBinding",
apiVersion:"servicecatalog.k8s.io/v1beta1",
metadata:{
generateName:instanceName + "-"
},
spec:{
instanceRef:{
name:instanceName
},
secretName:credentialSecretName
}
};
parametersSecretName && (binding.spec.parametersFrom = [ {
secretKeyRef:{
name:parametersSecretName,
key:PARAMETERS_SECRET_KEY
}
} ]);
var appSelector = _.get(application, "spec.selector");
return appSelector && (appSelector.matchLabels || appSelector.matchExpressions || (appSelector = {
matchLabels:appSelector
}), binding.spec.alphaPodPresetTemplate = {
name:credentialSecretName,
selector:appSelector
}), binding;
}, isServiceBindable = function(serviceInstance, serviceClass, servicePlan) {
if (!serviceInstance || !serviceClass || !servicePlan) return !1;
if (_.get(serviceInstance, "metadata.deletionTimestamp")) return !1;
if ($filter("isServiceInstanceFailed")(serviceInstance, "Failed")) return !1;
var planBindable = _.get(servicePlan, "spec.bindable");
return planBindable === !0 ? !0 :planBindable === !1 ? !1 :serviceClass.spec.bindable;
}, getPodPresetSelectorsForBindings = function(bindings) {
var podPresetSelectors = {};
return _.each(bindings, function(binding) {
var podPresetSelector = _.get(binding, "spec.alphaPodPresetTemplate.selector");
podPresetSelector && (podPresetSelectors[binding.metadata.name] = new LabelSelector(podPresetSelector));
}), podPresetSelectors;
}, getBindingsForResource = function(bindings, apiObject) {
if ("ServiceInstance" === _.get(apiObject, "kind")) return _.filter(bindings, [ "spec.instanceRef.name", _.get(apiObject, "metadata.name") ]);
var podPresetSelectors = getPodPresetSelectorsForBindings(bindings), applicationSelector = new LabelSelector(_.get(apiObject, "spec.selector")), resourceBindings = [];
return _.each(podPresetSelectors, function(podPresetSelector, bindingName) {
podPresetSelector.covers(applicationSelector) && resourceBindings.push(bindings[bindingName]);
}), resourceBindings;
}, filterBindableServiceInstances = function(serviceInstances, serviceClasses, servicePlans) {
return serviceInstances && serviceClasses && servicePlans ? _.filter(serviceInstances, function(serviceInstance) {
var serviceClassName = _.get(serviceInstance, "spec.clusterServiceClassRef.name"), servicePlanName = _.get(serviceInstance, "spec.clusterServicePlanRef.name");
return isServiceBindable(serviceInstance, serviceClasses[serviceClassName], servicePlans[servicePlanName]);
}) :null;
}, sortServiceInstances = function(serviceInstances, serviceClasses) {
var getServiceClassDisplayName = function(serviceInstance) {
var serviceClassName = _.get(serviceInstance, "spec.clusterServiceClassRef.name");
return _.get(serviceClasses, [ serviceClassName, "spec", "externalMetadata", "displayName" ]) || serviceInstance.spec.clusterServiceClassExternalName;
};
return _.sortBy(serviceInstances, [ getServiceClassDisplayName, "metadata.name" ]);
};
return {
bindingResource:bindingResource,
getServiceClassForInstance:getServiceClassForInstance,
makeParametersSecret:makeParametersSecret,
generateSecretName:generateSecretName,
bindService:function(serviceInstance, application, serviceClass, parameters) {
var parametersSecretName;
_.isEmpty(parameters) || (parametersSecretName = generateSecretName(serviceInstance.metadata.name + "-bind-parameters-"));
var newBinding = makeBinding(serviceInstance, application, parametersSecretName), context = {
namespace:serviceInstance.metadata.namespace
}, promise = DataService.create(bindingResource, null, newBinding, context);
return parametersSecretName ? promise.then(function(binding) {
var parametersSecret = makeParametersSecret(parametersSecretName, parameters, binding);
return DataService.create("secrets", null, parametersSecret, context).then(function() {
return binding;
});
}) :promise;
},
isServiceBindable:isServiceBindable,
getPodPresetSelectorsForBindings:getPodPresetSelectorsForBindings,
getBindingsForResource:getBindingsForResource,
filterBindableServiceInstances:filterBindableServiceInstances,
sortServiceInstances:sortServiceInstances
};
} ]), angular.module("openshiftCommonServices").factory("Constants", function() {
var constants = _.clone(window.OPENSHIFT_CONSTANTS || {}), version = _.clone(window.OPENSHIFT_VERSION || {});
return constants.VERSION = version, constants;
}), angular.module("openshiftCommonServices").factory("DataService", [ "$cacheFactory", "$http", "$ws", "$rootScope", "$q", "API_CFG", "APIService", "Logger", "$timeout", "base64", "base64util", function($cacheFactory, $http, $ws, $rootScope, $q, API_CFG, APIService, Logger, $timeout, base64, base64util) {
function Data(array) {
this._data = {}, this._objectsByAttribute(array, "metadata.name", this._data);
}
function _objectByAttribute(obj, attr, map, action) {
for (var subAttrs = attr.split("."), attrValue = obj, i = 0; i < subAttrs.length; i++) if (attrValue = attrValue[subAttrs[i]], void 0 === attrValue) return;
if ($.isArray(attrValue)) ; else if ($.isPlainObject(attrValue)) for (var key in attrValue) {
var val = attrValue[key];
map[key] || (map[key] = {}), "DELETED" === action ? delete map[key][val] :map[key][val] = obj;
} else "DELETED" === action ? delete map[attrValue] :map[attrValue] = obj;
}
function DataService() {
this._listDeferredMap = {}, this._watchCallbacksMap = {}, this._watchObjectCallbacksMap = {}, this._watchOperationMap = {}, this._listOperationMap = {}, this._resourceVersionMap = {}, this._dataCache = $cacheFactory("dataCache", {
number:25
}), this._immutableDataCache = $cacheFactory("immutableDataCache", {
number:50
}), this._watchOptionsMap = {}, this._watchWebsocketsMap = {}, this._watchPollTimeoutsMap = {}, this._websocketEventsMap = {};
var self = this;
$rootScope.$on("$routeChangeStart", function(event, next, current) {
self._websocketEventsMap = {};
});
}
function isTooManyRecentEvents(events) {
var recentDuration = 3e4;
return events.length >= maxWebsocketEvents && Date.now() - events[0].time < recentDuration;
}
function isTooManyConsecutiveCloses(events) {
var maxConsecutiveCloseEvents = 5;
if (events.length < maxConsecutiveCloseEvents) return !1;
for (var i = events.length - maxConsecutiveCloseEvents; i < events.length; i++) if ("close" !== events[i].type) return !1;
return !0;
}
var ACCEPT_PARTIAL_OBJECT_METADATA_LIST = "application/json;as=PartialObjectMetadataList;v=v1alpha1;g=meta.k8s.io";
Data.prototype.by = function(attr) {
if ("metadata.name" === attr) return this._data;
var map = {};
for (var key in this._data) _objectByAttribute(this._data[key], attr, map, null);
return map;
}, Data.prototype.update = function(object, action) {
_objectByAttribute(object, "metadata.name", this._data, action);
}, Data.prototype._objectsByAttribute = function(objects, attr, map, actions) {
angular.forEach(objects, function(obj, key) {
_objectByAttribute(obj, attr, map, actions ? actions[key] :null);
});
};
var queuedErrors = [], addQueuedNotifications = _.debounce(function() {
if (queuedErrors.length) {
var notification = {
type:"error",
message:"An error occurred connecting to the server.",
details:queuedErrors.join("\n"),
links:[ {
label:"Refresh",
onClick:function() {
window.location.reload();
}
} ]
};
$rootScope.$emit("NotificationsService.addNotification", notification), queuedErrors = [];
}
}, 300, {
maxWait:1e3
}), showRequestError = function(message, status) {
status && (message += " (status " + status + ")"), queuedErrors.push(message), addQueuedNotifications();
};
DataService.prototype.list = function(resource, context, callback, opts) {
resource = APIService.toResourceGroupVersion(resource);
var key = this._uniqueKey(resource, null, context, opts), deferred = this._listDeferred(key);
return callback && deferred.promise.then(callback), this._isCached(key) ? deferred.resolve(this._data(key)) :this._listInFlight(key) || this._startListOp(resource, context, opts), deferred.promise;
}, DataService.prototype["delete"] = function(resource, name, context, opts) {
resource = APIService.toResourceGroupVersion(resource), opts = opts || {};
var data, deferred = $q.defer(), self = this, headers = {}, data = {
kind:"DeleteOptions",
apiVersion:"v1"
};
_.has(opts, "propagationPolicy") ? data.propagationPolicy = opts.propagationPolicy :data.propagationPolicy = "Foreground";
var headers = {
"Content-Type":"application/json"
};
return _.has(opts, "gracePeriodSeconds") && (data.gracePeriodSeconds = opts.gracePeriodSeconds), this._getNamespace(resource, context, opts).then(function(ns) {
$http(angular.extend({
method:"DELETE",
auth:{},
data:data,
headers:headers,
url:self._urlForResource(resource, name, context, !1, ns)
}, opts.http || {})).success(function(data, status, headerFunc, config, statusText) {
deferred.resolve(data);
}).error(function(data, status, headers, config) {
deferred.reject({
data:data,
status:status,
headers:headers,
config:config
});
});
}), deferred.promise;
}, DataService.prototype.update = function(resource, name, object, context, opts) {
resource = APIService.deriveTargetResource(resource, object), opts = opts || {};
var deferred = $q.defer(), self = this;
return this._getNamespace(resource, context, opts).then(function(ns) {
$http(angular.extend({
method:"PUT",
auth:{},
data:object,
url:self._urlForResource(resource, name, context, !1, ns)
}, opts.http || {})).success(function(data, status, headerFunc, config, statusText) {
deferred.resolve(data);
}).error(function(data, status, headers, config) {
deferred.reject({
data:data,
status:status,
headers:headers,
config:config
});
});
}), deferred.promise;
}, DataService.prototype.create = function(resource, name, object, context, opts) {
resource = APIService.deriveTargetResource(resource, object), opts = opts || {};
var deferred = $q.defer(), self = this;
return this._getNamespace(resource, context, opts).then(function(ns) {
$http(angular.extend({
method:"POST",
auth:{},
data:object,
url:self._urlForResource(resource, name, context, !1, ns)
}, opts.http || {})).success(function(data, status, headerFunc, config, statusText) {
deferred.resolve(data);
}).error(function(data, status, headers, config) {
deferred.reject({
data:data,
status:status,
headers:headers,
config:config
});
});
}), deferred.promise;
}, DataService.prototype.batch = function(objects, context, action, opts) {
function _checkDone() {
0 === remaining && deferred.resolve({
success:successResults,
failure:failureResults
});
}
var deferred = $q.defer(), successResults = [], failureResults = [], self = this, remaining = objects.length;
return action = action || "create", _.each(objects, function(object) {
var resource = APIService.objectToResourceGroupVersion(object);
if (!resource) return failureResults.push({
object:object,
data:{
message:APIService.invalidObjectKindOrVersion(object)
}
}), remaining--, void _checkDone();
if (!APIService.apiInfo(resource)) return failureResults.push({
object:object,
data:{
message:APIService.unsupportedObjectKindOrVersion(object)
}
}), remaining--, void _checkDone();
var success = function(data) {
data.object = object, successResults.push(data), remaining--, _checkDone();
}, failure = function(data) {
data.object = object, failureResults.push(data), remaining--, _checkDone();
};
switch (action) {
case "create":
self.create(resource, null, object, context, opts).then(success, failure);
break;

case "update":
self.update(resource, object.metadata.name, object, context, opts).then(success, failure);
break;

default:
return deferred.reject({
data:"Invalid '" + action + "'  action.",
status:400,
headers:function() {
return null;
},
config:{},
object:object
});
}
}), deferred.promise;
}, DataService.prototype.get = function(resource, name, context, opts) {
resource = APIService.toResourceGroupVersion(resource), opts = opts || {};
var key = this._uniqueKey(resource, name, context, opts);
!!opts.force;
delete opts.force;
var deferred = $q.defer(), existingImmutableData = this._immutableData(key);
if (this._hasImmutable(resource, existingImmutableData, name)) $timeout(function() {
deferred.resolve(existingImmutableData.by("metadata.name")[name]);
}, 0); else {
var self = this;
this._getNamespace(resource, context, opts).then(function(ns) {
$http(angular.extend({
method:"GET",
auth:{},
url:self._urlForResource(resource, name, context, !1, ns)
}, opts.http || {})).success(function(data, status, headerFunc, config, statusText) {
self._isImmutable(resource) && (existingImmutableData ? existingImmutableData.update(data, "ADDED") :self._immutableData(key, [ data ])), deferred.resolve(data);
}).error(function(data, status, headers, config) {
opts.errorNotification !== !1 && showRequestError("Failed to get " + resource + "/" + name, status), deferred.reject({
data:data,
status:status,
headers:headers,
config:config
});
});
});
}
return deferred.promise;
}, DataService.prototype.createStream = function(resource, name, context, opts, isRaw) {
var self = this;
resource = APIService.toResourceGroupVersion(resource);
var stream, protocols = isRaw ? "binary.k8s.io" :"base64.binary.k8s.io", identifier = "stream_", openQueue = {}, messageQueue = {}, closeQueue = {}, errorQueue = {}, makeStream = function() {
return self._getNamespace(resource, context, {}).then(function(params) {
var cumulativeBytes = 0;
return $ws({
url:self._urlForResource(resource, name, context, !0, _.extend(params, opts)),
auth:{},
onopen:function(evt) {
_.each(openQueue, function(fn) {
fn(evt);
});
},
onmessage:function(evt) {
if (!_.isString(evt.data)) return void Logger.log("log stream response is not a string", evt.data);
var message;
isRaw || (message = base64.decode(base64util.pad(evt.data)), cumulativeBytes += message.length), _.each(messageQueue, function(fn) {
isRaw ? fn(evt.data) :fn(message, evt.data, cumulativeBytes);
});
},
onclose:function(evt) {
_.each(closeQueue, function(fn) {
fn(evt);
});
},
onerror:function(evt) {
_.each(errorQueue, function(fn) {
fn(evt);
});
},
protocols:protocols
}).then(function(ws) {
return Logger.log("Streaming pod log", ws), ws;
});
});
};
return {
onOpen:function(fn) {
if (_.isFunction(fn)) {
var id = _.uniqueId(identifier);
return openQueue[id] = fn, id;
}
},
onMessage:function(fn) {
if (_.isFunction(fn)) {
var id = _.uniqueId(identifier);
return messageQueue[id] = fn, id;
}
},
onClose:function(fn) {
if (_.isFunction(fn)) {
var id = _.uniqueId(identifier);
return closeQueue[id] = fn, id;
}
},
onError:function(fn) {
if (_.isFunction(fn)) {
var id = _.uniqueId(identifier);
return errorQueue[id] = fn, id;
}
},
remove:function(id) {
openQueue[id] && delete openQueue[id], messageQueue[id] && delete messageQueue[id], closeQueue[id] && delete closeQueue[id], errorQueue[id] && delete errorQueue[id];
},
start:function() {
return stream = makeStream();
},
stop:function() {
stream.then(function(ws) {
ws.close();
});
}
};
}, DataService.prototype.watch = function(resource, context, callback, opts) {
resource = APIService.toResourceGroupVersion(resource), opts = opts || {};
var invokeApply = !opts.skipDigest, key = this._uniqueKey(resource, null, context, opts);
if (callback) this._watchCallbacks(key).add(callback); else if (!this._watchCallbacks(key).has()) return {};
var existingWatchOpts = this._watchOptions(key);
if (existingWatchOpts) {
if (!!existingWatchOpts.poll != !!opts.poll) throw "A watch already exists for " + resource + " with a different polling option.";
} else this._watchOptions(key, opts);
var self = this;
if (this._isCached(key)) callback && $timeout(function() {
callback(self._data(key));
}, 0, invokeApply); else {
if (callback) {
var resourceVersion = this._resourceVersion(key);
this._data(key) && $timeout(function() {
resourceVersion === self._resourceVersion(key) && callback(self._data(key));
}, 0, invokeApply);
}
this._listInFlight(key) || this._startListOp(resource, context, opts);
}
return {
resource:resource,
context:context,
callback:callback,
opts:opts
};
}, DataService.prototype.watchObject = function(resource, name, context, callback, opts) {
resource = APIService.toResourceGroupVersion(resource), opts = opts || {};
var wrapperCallback, key = this._uniqueKey(resource, name, context, opts);
if (callback) {
this._watchObjectCallbacks(key).add(callback);
var self = this;
wrapperCallback = function(items, event, item) {
if (item && item.metadata.name === name) self._watchObjectCallbacks(key).fire(item, event); else if (!item) {
var itemsByName = items.by("metadata.name");
itemsByName[name] && self._watchObjectCallbacks(key).fire(itemsByName[name]);
}
};
} else if (!this._watchObjectCallbacks(key).has()) return {};
var handle = this.watch(resource, context, wrapperCallback, opts);
return handle.objectCallback = callback, handle.objectName = name, handle;
}, DataService.prototype.unwatch = function(handle) {
var resource = handle.resource, objectName = handle.objectName, context = handle.context, callback = handle.callback, objectCallback = handle.objectCallback, opts = handle.opts, key = this._uniqueKey(resource, null, context, opts);
if (objectCallback && objectName) {
var objectKey = this._uniqueKey(resource, objectName, context, opts), objCallbacks = this._watchObjectCallbacks(objectKey);
objCallbacks.remove(objectCallback);
}
var callbacks = this._watchCallbacks(key);
if (callback && callbacks.remove(callback), !callbacks.has()) {
if (opts && opts.poll) clearTimeout(this._watchPollTimeouts(key)), this._watchPollTimeouts(key, null); else if (this._watchWebsockets(key)) {
var ws = this._watchWebsockets(key);
ws.shouldClose = !0, ws.close(), this._watchWebsockets(key, null);
}
this._watchInFlight(key, !1), this._watchOptions(key, null);
}
}, DataService.prototype.unwatchAll = function(handles) {
for (var i = 0; i < handles.length; i++) this.unwatch(handles[i]);
}, DataService.prototype._watchCallbacks = function(key) {
return this._watchCallbacksMap[key] || (this._watchCallbacksMap[key] = $.Callbacks()), this._watchCallbacksMap[key];
}, DataService.prototype._watchObjectCallbacks = function(key) {
return this._watchObjectCallbacksMap[key] || (this._watchObjectCallbacksMap[key] = $.Callbacks()), this._watchObjectCallbacksMap[key];
}, DataService.prototype._listDeferred = function(key) {
return this._listDeferredMap[key] || (this._listDeferredMap[key] = $q.defer()), this._listDeferredMap[key];
}, DataService.prototype._watchInFlight = function(key, op) {
return op || op === !1 ? void (this._watchOperationMap[key] = op) :this._watchOperationMap[key];
}, DataService.prototype._listInFlight = function(key, op) {
return op || op === !1 ? void (this._listOperationMap[key] = op) :this._listOperationMap[key];
}, DataService.prototype._resourceVersion = function(key, rv) {
return rv ? void (this._resourceVersionMap[key] = rv) :this._resourceVersionMap[key];
}, DataService.prototype._data = function(key, data) {
return data ? this._dataCache.put(key, new Data(data)) :this._dataCache.get(key);
}, DataService.prototype._immutableData = function(key, data) {
return data ? this._immutableDataCache.put(key, new Data(data)) :this._immutableDataCache.get(key);
}, DataService.prototype._isCached = function(key) {
return this._watchInFlight(key) && this._resourceVersion(key) && !!this._data(key);
}, DataService.prototype._watchOptions = function(key, opts) {
return void 0 === opts ? this._watchOptionsMap[key] :void (this._watchOptionsMap[key] = opts);
}, DataService.prototype._watchPollTimeouts = function(key, timeout) {
return timeout ? void (this._watchPollTimeoutsMap[key] = timeout) :this._watchPollTimeoutsMap[key];
}, DataService.prototype._watchWebsockets = function(key, timeout) {
return timeout ? void (this._watchWebsocketsMap[key] = timeout) :this._watchWebsocketsMap[key];
};
var maxWebsocketEvents = 10;
DataService.prototype._addWebsocketEvent = function(key, eventType) {
var events = this._websocketEventsMap[key];
for (events || (events = this._websocketEventsMap[key] = []), events.push({
type:eventType,
time:Date.now()
}); events.length > maxWebsocketEvents; ) events.shift();
}, DataService.prototype._isTooManyWebsocketRetries = function(key) {
var events = this._websocketEventsMap[key];
return events ? isTooManyRecentEvents(events) ? (Logger.log("Too many websocket open or close events for resource/context in a short period", key, events), !0) :isTooManyConsecutiveCloses(events) ? (Logger.log("Too many consecutive websocket close events for resource/context", key, events), !0) :!1 :!1;
};
var paramsForKey = function(params) {
var keys = _.keysIn(_.pick(params, [ "fieldSelector", "labelSelector" ])).sort();
return _.reduce(keys, function(result, key, i) {
return result + key + "=" + encodeURIComponent(params[key]) + (i < keys.length - 1 ? "&" :"");
}, "?");
};
DataService.prototype._uniqueKey = function(resource, name, context, opts) {
var ns = context && context.namespace || _.get(context, "project.metadata.name") || context.projectName, params = _.get(opts, "http.params"), url = this._urlForResource(resource, name, context, null, angular.extend({}, {}, {
namespace:ns
})).toString() + paramsForKey(params || {});
return _.get(opts, "partialObjectMetadataList") ? url + "#" + ACCEPT_PARTIAL_OBJECT_METADATA_LIST :url;
}, DataService.prototype._startListOp = function(resource, context, opts) {
opts = opts || {};
var params = _.get(opts, "http.params") || {}, key = this._uniqueKey(resource, null, context, opts);
this._listInFlight(key, !0);
var headers = {};
opts.partialObjectMetadataList && (headers.Accept = ACCEPT_PARTIAL_OBJECT_METADATA_LIST);
var self = this;
context.projectPromise && !resource.equals("projects") ? context.projectPromise.done(function(project) {
$http(angular.extend({
method:"GET",
auth:{},
headers:headers,
url:self._urlForResource(resource, null, context, !1, _.assign({}, params, {
namespace:project.metadata.name
}))
}, opts.http || {})).success(function(data, status, headerFunc, config, statusText) {
self._listOpComplete(key, resource, context, opts, data);
}).error(function(data, status, headers, config) {
self._listInFlight(key, !1);
var deferred = self._listDeferred(key);
delete self._listDeferredMap[key], deferred.reject({
data:data,
status:status,
headers:headers,
config:config
}), _.get(opts, "errorNotification", !0) && showRequestError("Failed to list " + resource, status);
});
}) :$http({
method:"GET",
auth:{},
headers:headers,
url:this._urlForResource(resource, null, context, !1, params)
}).success(function(data, status, headerFunc, config, statusText) {
self._listOpComplete(key, resource, context, opts, data);
}).error(function(data, status, headers, config) {
self._listInFlight(key, !1);
var deferred = self._listDeferred(key);
delete self._listDeferredMap[key], deferred.reject({
data:data,
status:status,
headers:headers,
config:config
}), _.get(opts, "errorNotification", !0) && showRequestError("Failed to list " + resource, status);
});
}, DataService.prototype._listOpComplete = function(key, resource, context, opts, data) {
data.items || console.warn("List request for " + resource + " returned a null items array.  This is an invalid API response.");
var items = data.items || [];
data.kind && data.kind.indexOf("List") === data.kind.length - 4 && angular.forEach(items, function(item) {
item.kind || (item.kind = data.kind.slice(0, -4)), item.apiVersion || (item.apiVersion = data.apiVersion);
}), this._listInFlight(key, !1);
var deferred = this._listDeferred(key);
delete this._listDeferredMap[key];
var resourceVersion = _.get(data, "resourceVersion") || _.get(data, "metadata.resourceVersion");
if (this._resourceVersion(key, resourceVersion), this._data(key, items), deferred.resolve(this._data(key)), this._watchCallbacks(key).fire(this._data(key)), this._watchCallbacks(key).has()) {
var watchOpts = this._watchOptions(key) || {};
watchOpts.poll ? (this._watchInFlight(key, !0), this._watchPollTimeouts(key, setTimeout($.proxy(this, "_startListOp", resource, context), watchOpts.pollInterval || 5e3))) :this._watchInFlight(key) || this._startWatchOp(key, resource, context, opts, this._resourceVersion(key));
}
}, DataService.prototype._startWatchOp = function(key, resource, context, opts, resourceVersion) {
if (this._watchInFlight(key, !0), $ws.available()) {
var self = this, params = _.get(opts, "http.params") || {};
params.watch = !0, resourceVersion && (params.resourceVersion = resourceVersion), context.projectPromise && !resource.equals("projects") ? context.projectPromise.done(function(project) {
params.namespace = project.metadata.name, $ws({
method:"WATCH",
url:self._urlForResource(resource, null, context, !0, params),
auth:{},
onclose:$.proxy(self, "_watchOpOnClose", resource, context, opts),
onmessage:$.proxy(self, "_watchOpOnMessage", resource, context, opts),
onopen:$.proxy(self, "_watchOpOnOpen", resource, context, opts)
}).then(function(ws) {
Logger.log("Watching", ws), self._watchWebsockets(key, ws);
});
}) :$ws({
method:"WATCH",
url:self._urlForResource(resource, null, context, !0, params),
auth:{},
onclose:$.proxy(self, "_watchOpOnClose", resource, context, opts),
onmessage:$.proxy(self, "_watchOpOnMessage", resource, context, opts),
onopen:$.proxy(self, "_watchOpOnOpen", resource, context, opts)
}).then(function(ws) {
Logger.log("Watching", ws), self._watchWebsockets(key, ws);
});
}
}, DataService.prototype._watchOpOnOpen = function(resource, context, opts, event) {
Logger.log("Websocket opened for resource/context", resource, context);
var key = this._uniqueKey(resource, null, context, opts);
this._addWebsocketEvent(key, "open");
}, DataService.prototype._watchOpOnMessage = function(resource, context, opts, event) {
var key = this._uniqueKey(resource, null, context, opts);
opts = opts || {};
var invokeApply = !opts.skipDigest;
try {
var eventData = $.parseJSON(event.data);
if ("ERROR" == eventData.type) return Logger.log("Watch window expired for resource/context", resource, context), void (event.target && (event.target.shouldRelist = !0));
"DELETED" === eventData.type && eventData.object && eventData.object.metadata && !eventData.object.metadata.deletionTimestamp && (eventData.object.metadata.deletionTimestamp = new Date().toISOString()), eventData.object && this._resourceVersion(key, eventData.object.resourceVersion || eventData.object.metadata.resourceVersion), this._data(key).update(eventData.object, eventData.type);
var self = this;
$timeout(function() {
self._watchCallbacks(key).fire(self._data(key), eventData.type, eventData.object);
}, 0, invokeApply);
} catch (e) {
Logger.error("Error processing message", resource, event.data);
}
}, DataService.prototype._watchOpOnClose = function(resource, context, opts, event) {
var eventWS = event.target, key = this._uniqueKey(resource, null, context, opts);
if (!eventWS) return void Logger.log("Skipping reopen, no eventWS in event", event);
var registeredWS = this._watchWebsockets(key);
if (!registeredWS) return void Logger.log("Skipping reopen, no registeredWS for resource/context", resource, context);
if (eventWS !== registeredWS) return void Logger.log("Skipping reopen, eventWS does not match registeredWS", eventWS, registeredWS);
if (this._watchInFlight(key, !1), eventWS.shouldClose) return void Logger.log("Skipping reopen, eventWS was explicitly closed", eventWS);
if (event.wasClean) return void Logger.log("Skipping reopen, clean close", event);
if (!this._watchCallbacks(key).has()) return void Logger.log("Skipping reopen, no listeners registered for resource/context", resource, context);
if (this._isTooManyWebsocketRetries(key)) return void (_.get(opts, "errorNotification", !0) && $rootScope.$emit("NotificationsService.addNotification", {
id:"websocket_retry_halted",
type:"error",
message:"Server connection interrupted.",
links:[ {
label:"Refresh",
onClick:function() {
window.location.reload();
}
} ]
}));
if (this._addWebsocketEvent(key, "close"), eventWS.shouldRelist) {
Logger.log("Relisting for resource/context", resource, context);
var self = this;
return void setTimeout(function() {
self.watch(resource, context);
}, 2e3);
}
Logger.log("Rewatching for resource/context", resource, context), this._watchInFlight(key, !0), setTimeout($.proxy(this, "_startWatchOp", key, resource, context, opts, this._resourceVersion(key)), 2e3);
};
var URL_ROOT_TEMPLATE = "{protocol}://{+hostPort}{+prefix}{/group}/{version}/", URL_GET_LIST = URL_ROOT_TEMPLATE + "{resource}{?q*}", URL_OBJECT = URL_ROOT_TEMPLATE + "{resource}/{name}{/subresource*}{?q*}", URL_NAMESPACED_GET_LIST = URL_ROOT_TEMPLATE + "namespaces/{namespace}/{resource}{?q*}", URL_NAMESPACED_OBJECT = URL_ROOT_TEMPLATE + "namespaces/{namespace}/{resource}/{name}{/subresource*}{?q*}";
DataService.prototype._urlForResource = function(resource, name, context, isWebsocket, params) {
var apiInfo = APIService.apiInfo(resource);
if (!apiInfo) return Logger.error("_urlForResource called with unknown resource", resource, arguments), null;
var protocol, serviceProtocol = apiInfo.protocol || window.location.protocol;
if (params = params || {}, protocol = isWebsocket ? "http:" === serviceProtocol ? "ws" :"wss" :"http:" === serviceProtocol ? "http" :"https", context && context.namespace && !params.namespace && (params.namespace = context.namespace), apiInfo.namespaced && !params.namespace) return Logger.error("_urlForResource called for a namespaced resource but no namespace provided", resource, arguments), null;
var namespaceInPath = apiInfo.namespaced, namespace = null;
namespaceInPath && (namespace = params.namespace, params = angular.copy(params), delete params.namespace);
var template, templateOptions = {
protocol:protocol,
hostPort:apiInfo.hostPort,
prefix:apiInfo.prefix,
group:apiInfo.group,
version:apiInfo.version,
resource:resource.primaryResource(),
subresource:resource.subresources(),
name:name,
namespace:namespace,
q:params
};
return template = name ? namespaceInPath ? URL_NAMESPACED_OBJECT :URL_OBJECT :namespaceInPath ? URL_NAMESPACED_GET_LIST :URL_GET_LIST, URI.expand(template, templateOptions).toString();
}, DataService.prototype.url = function(options) {
if (options && options.resource) {
var opts = angular.copy(options);
delete opts.resource, delete opts.group, delete opts.version, delete opts.name, delete opts.isWebsocket;
var resource = APIService.toResourceGroupVersion({
resource:options.resource,
group:options.group,
version:options.version
});
return this._urlForResource(resource, options.name, null, !!options.isWebsocket, opts);
}
return null;
}, DataService.prototype.openshiftAPIBaseUrl = function() {
var protocol = "http:" === window.location.protocol ? "http" :"https", hostPort = API_CFG.openshift.hostPort;
return new URI({
protocol:protocol,
hostname:hostPort
}).toString();
}, DataService.prototype.createData = function(array) {
return new Data(array);
};
var IMMUTABLE_RESOURCE = {
imagestreamimages:!0
};
return DataService.prototype._isImmutable = function(resource) {
return !!IMMUTABLE_RESOURCE[resource.resource];
}, DataService.prototype._hasImmutable = function(resource, existingData, name) {
return this._isImmutable(resource) && existingData && existingData.by("metadata.name")[name];
}, DataService.prototype._getNamespace = function(resource, context, opts) {
var deferred = $q.defer();
return opts.namespace ? deferred.resolve({
namespace:opts.namespace
}) :context.projectPromise && !resource.equals("projects") ? context.projectPromise.done(function(project) {
deferred.resolve({
namespace:project.metadata.name
});
}) :deferred.resolve(null), deferred.promise;
}, new DataService();
} ]), angular.module("openshiftCommonServices").provider("DeleteTokenLogoutService", function() {
this.$get = [ "$q", "$injector", "Logger", function($q, $injector, Logger) {
var authLogger = Logger.get("auth");
return {
logout:function(user, token) {
if (authLogger.log("DeleteTokenLogoutService.logout()", user, token), !token) return authLogger.log("DeleteTokenLogoutService, no token, returning immediately"), $q.when({});
var DataService = $injector.get("DataService"), opts = {
http:{
auth:{
token:token,
triggerLogin:!1
}
}
};
return DataService["delete"]("oauthaccesstokens", token, {}, opts);
}
};
} ];
}), angular.module("openshiftCommonServices").service("KeywordService", function() {
var generateKeywords = function(filterText) {
if (!filterText) return [];
var keywords = _.uniq(filterText.match(/\S+/g));
return keywords.sort(function(a, b) {
return b.length - a.length;
}), _.map(keywords, function(keyword) {
return new RegExp(_.escapeRegExp(keyword), "i");
});
}, filterForKeywords = function(objects, filterFields, keywords) {
var filteredObjects = objects;
return _.isEmpty(keywords) ? filteredObjects :(angular.forEach(keywords, function(regex) {
var matchesKeyword = function(obj) {
var i;
for (i = 0; i < filterFields.length; i++) {
var value = _.get(obj, filterFields[i]);
if (value && regex.test(value)) return !0;
}
return !1;
};
filteredObjects = _.filter(filteredObjects, matchesKeyword);
}), filteredObjects);
};
return {
filterForKeywords:filterForKeywords,
generateKeywords:generateKeywords
};
}), angular.module("openshiftCommonServices").provider("Logger", function() {
this.$get = function() {
var OSLogger = Logger.get("OpenShift"), logger = {
get:function(name) {
var logger = Logger.get("OpenShift/" + name), logLevel = "OFF";
return localStorage && (logLevel = localStorage["OpenShiftLogLevel." + name] || logLevel), logger.setLevel(Logger[logLevel]), logger;
},
log:function() {
OSLogger.log.apply(OSLogger, arguments);
},
info:function() {
OSLogger.info.apply(OSLogger, arguments);
},
debug:function() {
OSLogger.debug.apply(OSLogger, arguments);
},
warn:function() {
OSLogger.warn.apply(OSLogger, arguments);
},
error:function() {
OSLogger.error.apply(OSLogger, arguments);
}
}, logLevel = "ERROR";
return localStorage && (logLevel = localStorage["OpenShiftLogLevel.main"] || logLevel), OSLogger.setLevel(Logger[logLevel]), logger;
};
}), angular.module("openshiftCommonServices").provider("MemoryUserStore", function() {
this.$get = [ "Logger", function(Logger) {
var authLogger = Logger.get("auth"), _user = null, _token = null;
return {
available:function() {
return !0;
},
getUser:function() {
return authLogger.log("MemoryUserStore.getUser", _user), _user;
},
setUser:function(user, ttl) {
authLogger.log("MemoryUserStore.setUser", user), _user = user;
},
getToken:function() {
return authLogger.log("MemoryUserStore.getToken", _token), _token;
},
setToken:function(token, ttl) {
authLogger.log("MemoryUserStore.setToken", token), _token = token;
}
};
} ];
}).provider("SessionStorageUserStore", function() {
this.$get = [ "Logger", function(Logger) {
var authLogger = Logger.get("auth"), userkey = "SessionStorageUserStore.user", tokenkey = "SessionStorageUserStore.token";
return {
available:function() {
try {
var x = String(new Date().getTime());
sessionStorage["SessionStorageUserStore.test"] = x;
var y = sessionStorage["SessionStorageUserStore.test"];
return sessionStorage.removeItem("SessionStorageUserStore.test"), x === y;
} catch (e) {
return !1;
}
},
getUser:function() {
try {
var user = JSON.parse(sessionStorage[userkey]);
return authLogger.log("SessionStorageUserStore.getUser", user), user;
} catch (e) {
return authLogger.error("SessionStorageUserStore.getUser", e), null;
}
},
setUser:function(user, ttl) {
user ? (authLogger.log("SessionStorageUserStore.setUser", user), sessionStorage[userkey] = JSON.stringify(user)) :(authLogger.log("SessionStorageUserStore.setUser", user, "deleting"), sessionStorage.removeItem(userkey));
},
getToken:function() {
try {
var token = sessionStorage[tokenkey];
return authLogger.log("SessionStorageUserStore.getToken", token), token;
} catch (e) {
return authLogger.error("SessionStorageUserStore.getToken", e), null;
}
},
setToken:function(token, ttl) {
token ? (authLogger.log("SessionStorageUserStore.setToken", token), sessionStorage[tokenkey] = token) :(authLogger.log("SessionStorageUserStore.setToken", token, "deleting"), sessionStorage.removeItem(tokenkey));
}
};
} ];
}).provider("LocalStorageUserStore", function() {
this.$get = [ "Logger", function(Logger) {
var authLogger = Logger.get("auth"), userkey = "LocalStorageUserStore.user", tokenkey = "LocalStorageUserStore.token", ttlKey = function(key) {
return key + ".ttl";
}, setTTL = function(key, ttl) {
if (ttl) {
var expires = new Date().getTime() + 1e3 * ttl;
localStorage[ttlKey(key)] = expires, authLogger.log("LocalStorageUserStore.setTTL", key, ttl, new Date(expires).toString());
} else localStorage.removeItem(ttlKey(key)), authLogger.log("LocalStorageUserStore.setTTL deleting", key);
}, isTTLExpired = function(key) {
var ttl = localStorage[ttlKey(key)];
if (!ttl) return !1;
var expired = parseInt(ttl) < new Date().getTime();
return authLogger.log("LocalStorageUserStore.isTTLExpired", key, expired), expired;
};
return {
available:function() {
try {
var x = String(new Date().getTime());
localStorage["LocalStorageUserStore.test"] = x;
var y = localStorage["LocalStorageUserStore.test"];
return localStorage.removeItem("LocalStorageUserStore.test"), x === y;
} catch (e) {
return !1;
}
},
getUser:function() {
try {
if (isTTLExpired(userkey)) return authLogger.log("LocalStorageUserStore.getUser expired"), localStorage.removeItem(userkey), setTTL(userkey, null), null;
var user = JSON.parse(localStorage[userkey]);
return authLogger.log("LocalStorageUserStore.getUser", user), user;
} catch (e) {
return authLogger.error("LocalStorageUserStore.getUser", e), null;
}
},
setUser:function(user, ttl) {
user ? (authLogger.log("LocalStorageUserStore.setUser", user, ttl), localStorage[userkey] = JSON.stringify(user), setTTL(userkey, ttl)) :(authLogger.log("LocalStorageUserStore.setUser", user, "deleting"), localStorage.removeItem(userkey), setTTL(userkey, null));
},
getToken:function() {
try {
if (isTTLExpired(tokenkey)) return authLogger.log("LocalStorageUserStore.getToken expired"), localStorage.removeItem(tokenkey), setTTL(tokenkey, null), null;
var token = localStorage[tokenkey];
return authLogger.log("LocalStorageUserStore.getToken", token), token;
} catch (e) {
return authLogger.error("LocalStorageUserStore.getToken", e), null;
}
},
setToken:function(token, ttl) {
token ? (authLogger.log("LocalStorageUserStore.setToken", token, ttl), localStorage[tokenkey] = token, setTTL(tokenkey, ttl)) :(authLogger.log("LocalStorageUserStore.setToken", token, ttl, "deleting"), localStorage.removeItem(tokenkey), setTTL(tokenkey, null));
}
};
} ];
}), angular.module("openshiftCommonServices").factory("ProjectsService", [ "$location", "$q", "$rootScope", "AuthService", "AuthorizationService", "DataService", "Logger", "RecentlyViewedProjectsService", "annotationNameFilter", function($location, $q, $rootScope, AuthService, AuthorizationService, DataService, Logger, RecentlyViewedProjectsService, annotationNameFilter) {
var cachedProjectData, cachedProjectDataIncomplete = !1, clearCachedProjectData = function() {
Logger.debug("ProjectsService: clearing project cache"), cachedProjectData = null, cachedProjectDataIncomplete = !1;
};
AuthService.onUserChanged(clearCachedProjectData), AuthService.onLogout(clearCachedProjectData);
var cleanEditableAnnotations = function(resource) {
var paths = [ annotationNameFilter("description"), annotationNameFilter("displayName") ];
return _.each(paths, function(path) {
resource.metadata.annotations[path] || delete resource.metadata.annotations[path];
}), resource;
};
return {
get:function(projectName) {
return AuthService.withUser().then(function() {
var context = {
projectPromise:$.Deferred(),
projectName:projectName,
project:void 0
};
return DataService.get("projects", projectName, context, {
errorNotification:!1
}).then(function(project) {
return AuthorizationService.getProjectRules(projectName).then(function() {
return context.project = project, context.projectPromise.resolve(project), RecentlyViewedProjectsService.addProjectUID(project.metadata.uid), cachedProjectData && cachedProjectData.update(project, "MODIFIED"), [ project, context ];
});
}, function(e) {
context.projectPromise.reject(e);
var description = "The project could not be loaded.", type = "error";
return 403 === e.status ? (description = "The project " + context.projectName + " does not exist or you are not authorized to view it.", type = "access_denied") :404 === e.status && (description = "The project " + context.projectName + " does not exist.", type = "not_found"), $location.url(URI("error").query({
error:type,
error_description:description
}).toString()), $q.reject();
});
});
},
list:function(forceRefresh) {
return cachedProjectData && !forceRefresh ? (Logger.debug("ProjectsService: returning cached project data"), $q.when(cachedProjectData)) :(Logger.debug("ProjectsService: listing projects, force refresh", forceRefresh), DataService.list("projects", {}).then(function(projectData) {
return cachedProjectData = projectData, projectData;
}, function(error) {
return cachedProjectData = DataService.createData([]), cachedProjectDataIncomplete = !0, $q.reject();
}));
},
isProjectListIncomplete:function() {
return cachedProjectDataIncomplete;
},
watch:function(context, callback) {
return DataService.watch("projects", context, function(projectData) {
cachedProjectData = projectData, callback(projectData);
});
},
update:function(projectName, data) {
return DataService.update("projects", projectName, cleanEditableAnnotations(data), {
projectName:projectName
}, {
errorNotification:!1
}).then(function(updatedProject) {
return cachedProjectData && cachedProjectData.update(updatedProject, "MODIFIED"), updatedProject;
});
},
create:function(name, displayName, description) {
var projectRequest = {
apiVersion:"v1",
kind:"ProjectRequest",
metadata:{
name:name
},
displayName:displayName,
description:description
};
return DataService.create("projectrequests", null, projectRequest, {}).then(function(project) {
return RecentlyViewedProjectsService.addProjectUID(project.metadata.uid), cachedProjectData && cachedProjectData.update(project, "ADDED"), project;
});
},
canCreate:function() {
return DataService.get("projectrequests", null, {}, {
errorNotification:!1
});
},
"delete":function(project) {
return DataService["delete"]("projects", project.metadata.name, {}).then(function(deletedProject) {
return cachedProjectData && cachedProjectData.update(project, "DELETED"), deletedProject;
});
}
};
} ]), angular.module("openshiftCommonServices").factory("PromiseUtils", [ "$q", function($q) {
return {
waitForAll:function(promises) {
var total = _.size(promises);
if (!total) return $q.when();
var deferred = $q.defer(), complete = 0, failed = !1, checkDone = function() {
total > complete || (failed ? deferred.reject() :deferred.resolve());
};
return _.each(promises, function(promise) {
return promise ? void promise["catch"](function() {
failed = !0;
})["finally"](function() {
complete++, checkDone();
}) :(complete++, void checkDone());
}), deferred.promise;
}
};
} ]), angular.module("openshiftCommonServices").service("RecentlyViewedProjectsService", [ "$filter", function($filter) {
var recentlyViewedProjsKey = "openshift/recently-viewed-project-uids", getProjectUIDs = function() {
var recentlyViewed = localStorage.getItem(recentlyViewedProjsKey);
return recentlyViewed ? JSON.parse(recentlyViewed) :[];
}, addProjectUID = function(uid) {
var recentlyViewed = getProjectUIDs();
recentlyViewed.unshift(uid), recentlyViewed = _.uniq(recentlyViewed), recentlyViewed = _.take(recentlyViewed, 5), setRecentlyViewedProjects(recentlyViewed);
}, clear = function() {
localStorage.removeItem(recentlyViewedProjsKey);
}, setRecentlyViewedProjects = function(recentlyViewed) {
localStorage.setItem(recentlyViewedProjsKey, JSON.stringify(recentlyViewed));
}, orderByMostRecentlyViewed = function(projects) {
var recentlyViewedProjects = [], recentlyViewedIds = getProjectUIDs();
return _.each(recentlyViewedIds, function(uid) {
var proj = _.remove(projects, function(project) {
return project.metadata.uid === uid;
})[0];
void 0 !== proj && recentlyViewedProjects.push(proj);
}), projects = _.sortBy(projects, function(project) {
return $filter("displayName")(project).toLowerCase();
}), recentlyViewedProjects.concat(projects);
}, isRecentlyViewed = function(uid) {
return _.includes(getProjectUIDs(), uid);
};
return {
getProjectUIDs:getProjectUIDs,
addProjectUID:addProjectUID,
orderByMostRecentlyViewed:orderByMostRecentlyViewed,
clear:clear,
isRecentlyViewed:isRecentlyViewed
};
} ]), angular.module("openshiftCommonServices").provider("RedirectLoginService", function() {
var _oauth_client_id = "", _oauth_authorize_uri = "", _oauth_token_uri = "", _oauth_redirect_uri = "", _oauth_scope = "";
this.OAuthClientID = function(id) {
return id && (_oauth_client_id = id), _oauth_client_id;
}, this.OAuthAuthorizeURI = function(uri) {
return uri && (_oauth_authorize_uri = uri), _oauth_authorize_uri;
}, this.OAuthTokenURI = function(uri) {
return uri && (_oauth_token_uri = uri), _oauth_token_uri;
}, this.OAuthRedirectURI = function(uri) {
return uri && (_oauth_redirect_uri = uri), _oauth_redirect_uri;
}, this.OAuthScope = function(scope) {
return scope && (_oauth_scope = scope), _oauth_scope;
}, this.$get = [ "$injector", "$location", "$q", "Logger", "base64", function($injector, $location, $q, Logger, base64) {
var authLogger = Logger.get("auth"), getRandomInts = function(length) {
var randomValues;
if (window.crypto && window.Uint32Array) try {
var r = new Uint32Array(length);
window.crypto.getRandomValues(r), randomValues = [];
for (var j = 0; length > j; j++) randomValues.push(r[j]);
} catch (e) {
authLogger.debug("RedirectLoginService.getRandomInts: ", e), randomValues = null;
}
if (!randomValues) {
randomValues = [];
for (var i = 0; length > i; i++) randomValues.push(Math.floor(4294967296 * Math.random()));
}
return randomValues;
}, nonceKey = "RedirectLoginService.nonce", makeState = function(then) {
var nonce = String(new Date().getTime()) + "-" + getRandomInts(8).join("");
try {
window.localStorage[nonceKey] = nonce;
} catch (e) {
authLogger.log("RedirectLoginService.makeState, localStorage error: ", e);
}
return base64.urlencode(JSON.stringify({
then:then,
nonce:nonce
}));
}, parseState = function(state) {
var retval = {
then:null,
verified:!1
}, nonce = "";
try {
nonce = window.localStorage[nonceKey], window.localStorage.removeItem(nonceKey);
} catch (e) {
authLogger.log("RedirectLoginService.parseState, localStorage error: ", e);
}
try {
var data = state ? JSON.parse(base64.urldecode(state)) :{};
data && data.nonce && nonce && data.nonce === nonce && (retval.verified = !0, retval.then = data.then);
} catch (e) {
authLogger.error("RedirectLoginService.parseState, state error: ", e);
}
return authLogger.error("RedirectLoginService.parseState", retval), retval;
};
return {
login:function() {
if ("" === _oauth_client_id) return $q.reject({
error:"invalid_request",
error_description:"RedirectLoginServiceProvider.OAuthClientID() not set"
});
if ("" === _oauth_authorize_uri) return $q.reject({
error:"invalid_request",
error_description:"RedirectLoginServiceProvider.OAuthAuthorizeURI() not set"
});
if ("" === _oauth_redirect_uri) return $q.reject({
error:"invalid_request",
error_description:"RedirectLoginServiceProvider.OAuthRedirectURI not set"
});
var returnUri = new URI($location.url()).fragment(""), authorizeParams = {
client_id:_oauth_client_id,
response_type:"token",
state:makeState(returnUri.toString()),
redirect_uri:_oauth_redirect_uri
};
_oauth_scope && (authorizeParams.scope = _oauth_scope), _oauth_token_uri && (authorizeParams.response_type = "code");
var deferred = $q.defer(), uri = new URI(_oauth_authorize_uri);
return uri.query(authorizeParams), authLogger.log("RedirectLoginService.login(), redirecting", uri.toString()), window.location.href = uri.toString(), deferred.promise;
},
finish:function() {
var http = $injector.get("$http"), handleParams = function(params, stateData) {
return params.error ? (authLogger.log("RedirectLoginService.finish(), error", params.error, params.error_description, params.error_uri), $q.reject({
error:params.error,
error_description:params.error_description,
error_uri:params.error_uri
})) :params.access_token ? $q.when({
token:params.access_token,
ttl:params.expires_in,
then:stateData.then,
verified:stateData.verified
}) :$q.reject({
error:"invalid_request",
error_description:"No API token returned"
});
}, u = new URI($location.url()), queryParams = u.query(!0), fragmentParams = new URI("?" + u.fragment()).query(!0);
if (authLogger.log("RedirectLoginService.finish()", queryParams, fragmentParams), queryParams.error) return handleParams(queryParams, parseState(queryParams.state));
if (fragmentParams.error) return handleParams(fragmentParams, parseState(fragmentParams.state));
if (fragmentParams.access_token) return handleParams(fragmentParams, parseState(fragmentParams.state));
if (_oauth_token_uri && queryParams.code) {
var stateData = parseState(queryParams.state);
if (!stateData.verified) return $q.reject({
error:"invalid_request",
error_description:"Client state could not be verified"
});
var tokenPostData = [ "grant_type=authorization_code", "code=" + encodeURIComponent(queryParams.code), "redirect_uri=" + encodeURIComponent(_oauth_redirect_uri), "client_id=" + encodeURIComponent(_oauth_client_id) ].join("&");
return _oauth_scope && (tokenPostData += "&scope=" + encodeURIComponent(_oauth_scope)), http({
method:"POST",
url:_oauth_token_uri,
headers:{
Authorization:"Basic " + window.btoa(_oauth_client_id + ":"),
"Content-Type":"application/x-www-form-urlencoded"
},
data:tokenPostData
}).then(function(response) {
return handleParams(response.data, stateData);
}, function(response) {
return authLogger.log("RedirectLoginService.finish(), error getting access token", response), handleParams(response.data, stateData);
});
}
return $q.reject({
error:"invalid_request",
error_description:"No API token returned"
});
}
};
} ];
}), angular.module("openshiftCommonServices").provider("$ws", [ "$httpProvider", function($httpProvider) {
this.$get = [ "$q", "$injector", "Logger", function($q, $injector, Logger) {
var authLogger = Logger.get("auth");
authLogger.log("$wsProvider.$get", arguments);
var _interceptors = [];
angular.forEach($httpProvider.interceptors, function(interceptorFactory) {
angular.isString(interceptorFactory) ? _interceptors.unshift($injector.get(interceptorFactory)) :_interceptors.unshift($injector.invoke(interceptorFactory));
});
var $ws = function(config) {
config.method = angular.uppercase(config.method || "WATCH"), authLogger.log("$ws (pre-intercept)", config.url.toString());
var serverRequest = function(config) {
authLogger.log("$ws (post-intercept)", config.url.toString());
var ws = new WebSocket(config.url, config.protocols);
return config.onclose && (ws.onclose = config.onclose), config.onmessage && (ws.onmessage = config.onmessage), config.onopen && (ws.onopen = config.onopen), config.onerror && (ws.onerror = config.onerror), ws;
}, chain = [ serverRequest, void 0 ], promise = $q.when(config);
for (angular.forEach(_interceptors, function(interceptor) {
(interceptor.request || interceptor.requestError) && chain.unshift(interceptor.request, interceptor.requestError);
}); chain.length; ) {
var thenFn = chain.shift(), rejectFn = chain.shift();
promise = promise.then(thenFn, rejectFn);
}
return promise;
};
return $ws.available = function() {
try {
return !!WebSocket;
} catch (e) {
return !1;
}
}, $ws;
} ];
} ]), angular.module("openshiftCommonUI").factory("GuidedTourService", function() {
function handleTourStart() {
$("#guided_tour_backdrop").click(cancelTour);
}
function handleTourEnd() {
$("#guided_tour_backdrop").remove(), angular.isFunction(hopscotchConfig.onTourEndCB) && hopscotchConfig.onTourEndCB();
}
function setupSteps() {
_.forEach(hopscotchConfig.steps, function(step) {
step.onNextOrig = step.onNext, step.onPrevOrig = step.onPrev, step.onNext = onStepNext, step.onPrev = onStepPrev, step.fixedElement = !0, !angular.isUndefined(step.yOffset) || "right" !== step.placement && "left" !== step.placement || (step.yOffset = -45), step.title = _.isFunction(step.title) ? step.title() :step.title, step.content = _.isFunction(step.content) ? step.content() :step.content, step.target = _.isFunction(step.target) ? step.target() :step.target, step.placement = _.isFunction(step.placement) ? step.placement() :step.placement;
});
}
function onStepNext() {
var stepNum = hopscotch.getCurrStepNum() - 1, stepConfig = hopscotchConfig.steps[stepNum];
stepConfig && (stepConfig.onNextOrig && stepConfig.onNextOrig(), makeStepTargetVisible(stepNum + 1));
}
function onStepPrev() {
var stepNum = hopscotch.getCurrStepNum() + 1, stepConfig = hopscotchConfig.steps[stepNum];
stepConfig && (stepConfig.onPrevOrig && stepConfig.onPrevOrig(), makeStepTargetVisible(stepNum - 1));
}
function makeStepTargetVisible(stepNum) {
var stepConfig = hopscotchConfig.steps[stepNum];
if (stepConfig && (stepConfig.preShow && stepConfig.preShow(), stepConfig.targetScrollElement)) {
var scrollElement = $("body").find(stepConfig.targetScrollElement)[0], targetElement = $("body").find(stepConfig.target)[0];
if (scrollElement && scrollElement) {
var offsetTop = getOffsetTopFromScrollElement(targetElement, scrollElement);
"top" === stepConfig.placement ? offsetTop -= bubbleHeight :offsetTop += bubbleHeight, offsetTop > scrollElement.clientHeight ? scrollElement.scrollTop = offsetTop :scrollElement.scrollTop = 0;
}
}
}
function getOffsetTopFromScrollElement(targetElement, scrollElement) {
return targetElement && targetElement !== scrollElement ? targetElement.offsetTop + getOffsetTopFromScrollElement(targetElement.offsetParent, scrollElement) :0;
}
var innerConfig, hopscotchConfig = {}, bubbleHeight = 175, startTour = function(tourConfig, onTourEndCB) {
$("body").append('<div id="guided_tour_backdrop" class="modal-backdrop fade guided-tour-backdrop"></div>'), innerConfig = {
onTourEndCB:onTourEndCB,
bubblePadding:5,
arrowWidth:10,
onStart:handleTourStart,
onEnd:handleTourEnd,
onClose:handleTourEnd,
showPrevButton:!0,
i18n:{
nextBtn:"Next >",
prevBtn:"< Back",
closeTooltip:"x"
}
}, hopscotchConfig = {}, angular.merge(hopscotchConfig, innerConfig, tourConfig), setupSteps(), makeStepTargetVisible(0), hopscotch.startTour(hopscotchConfig, 0);
}, cancelTour = function() {
hopscotch.endTour();
};
return {
startTour:startTour,
cancelTour:cancelTour
};
}), angular.module("openshiftCommonUI").factory("HTMLService", [ "BREAKPOINTS", function(BREAKPOINTS) {
var WINDOW_SIZE_XXS = "xxs", WINDOW_SIZE_XS = "xs", WINDOW_SIZE_SM = "sm", WINDOW_SIZE_MD = "md", WINDOW_SIZE_LG = "lg";
return {
WINDOW_SIZE_XXS:WINDOW_SIZE_XXS,
WINDOW_SIZE_XS:WINDOW_SIZE_XS,
WINDOW_SIZE_SM:WINDOW_SIZE_SM,
WINDOW_SIZE_MD:WINDOW_SIZE_MD,
WINDOW_SIZE_LG:WINDOW_SIZE_LG,
getBreakpoint:function() {
return window.innerWidth < BREAKPOINTS.screenXsMin ? WINDOW_SIZE_XXS :window.innerWidth < BREAKPOINTS.screenSmMin ? WINDOW_SIZE_XS :window.innerWidth < BREAKPOINTS.screenMdMin ? WINDOW_SIZE_SM :window.innerWidth < BREAKPOINTS.screenLgMin ? WINDOW_SIZE_MD :WINDOW_SIZE_LG;
},
isWindowBelowBreakpoint:function(size) {
switch (size) {
case WINDOW_SIZE_XXS:
return !1;

case WINDOW_SIZE_XS:
return window.innerWidth < BREAKPOINTS.screenXsMin;

case WINDOW_SIZE_SM:
return window.innerWidth < BREAKPOINTS.screenSmMin;

case WINDOW_SIZE_MD:
return window.innerWidth < BREAKPOINTS.screenMdMin;

case WINDOW_SIZE_LG:
return window.innerWidth < BREAKPOINTS.screenLgMin;

default:
return !0;
}
},
isWindowAboveBreakpoint:function(size) {
switch (size) {
case WINDOW_SIZE_XS:
return window.innerWidth >= BREAKPOINTS.screenXsMin;

case WINDOW_SIZE_SM:
return window.innerWidth >= BREAKPOINTS.screenSmMin;

case WINDOW_SIZE_MD:
return window.innerWidth >= BREAKPOINTS.screenMdMin;

case WINDOW_SIZE_LG:
return window.innerWidth >= BREAKPOINTS.screenLgMin;

default:
return !0;
}
},
linkify:function(text, target, alreadyEscaped) {
return text ? (alreadyEscaped || (text = _.escape(text)), text.replace(/https?:\/\/[A-Za-z0-9._%+-]+[^\s<]*[^\s.,()\[\]{}<>"\u201d\u2019]/gm, function(str) {
return target ? '<a href="' + str + '" target="' + target + '">' + str + ' <i class="fa fa-external-link" aria-hidden="true"></i></a>' :'<a href="' + str + '">' + str + "</a>";
})) :text;
}
};
} ]), angular.module("openshiftCommonUI").provider("NotificationsService", function() {
this.dismissDelay = 8e3, this.autoDismissTypes = [ "info", "success" ], this.$get = [ "$rootScope", function($rootScope) {
var notifications = [], dismissDelay = this.dismissDelay, autoDismissTypes = this.autoDismissTypes, notificationHiddenKey = function(notificationID, namespace) {
return namespace ? "hide/notification/" + namespace + "/" + notificationID :"hide/notification/" + notificationID;
}, addNotification = function(notification) {
notification.trackByID = _.uniqueId("notification-") + Date.now(), notification.skipToast = notification.skipToast || !1, notification.showInDrawer = notification.showInDrawer || !1, notification.timestamp = new Date().toISOString(), isNotificationPermanentlyHidden(notification) || isNotificationVisible(notification) || (notifications.push(notification), $rootScope.$emit("NotificationsService.onNotificationAdded", notification));
}, hideNotification = function(notificationID) {
notificationID && _.each(notifications, function(notification) {
notification.id === notificationID && (notification.hidden = !0);
});
}, getNotifications = function() {
return notifications;
}, clearNotifications = function() {
notifications.length = 0;
}, isNotificationPermanentlyHidden = function(notification) {
if (!notification.id) return !1;
var key = notificationHiddenKey(notification.id, notification.namespace);
return "true" === localStorage.getItem(key);
}, permanentlyHideNotification = function(notificationID, namespace) {
var key = notificationHiddenKey(notificationID, namespace);
localStorage.setItem(key, "true");
}, isNotificationVisible = function(notification) {
return notification.id ? _.some(notifications, function(next) {
return !next.hidden && notification.id === next.id;
}) :!1;
}, isAutoDismiss = function(notification) {
return _.includes(autoDismissTypes, notification.type);
};
return $rootScope.$on("NotificationsService.addNotification", function(event, data) {
addNotification(data);
}), {
addNotification:addNotification,
hideNotification:hideNotification,
getNotifications:getNotifications,
clearNotifications:clearNotifications,
isNotificationPermanentlyHidden:isNotificationPermanentlyHidden,
permanentlyHideNotification:permanentlyHideNotification,
isAutoDismiss:isAutoDismiss,
dismissDelay:dismissDelay,
autoDismissTypes:autoDismissTypes
};
} ], this.setDismissDelay = function(delayInMs) {
this.dismissDelay = delayInMs;
}, this.setAutoDismissTypes = function(arrayOfTypes) {
this.autoDismissTypes = arrayOfTypes;
};
});