// Mocked API discovery
window.OPENSHIFT_CONFIG.api.k8s.resources = {
   "v1":{
      "bindings":{
         "name":"bindings",
         "singularName":"",
         "namespaced":true,
         "kind":"Binding",
         "verbs":[
            "create"
         ]
      },
      "componentstatuses":{
         "name":"componentstatuses",
         "singularName":"",
         "namespaced":false,
         "kind":"ComponentStatus",
         "verbs":[
            "get",
            "list"
         ],
         "shortNames":[
            "cs"
         ]
      },
      "configmaps":{
         "name":"configmaps",
         "singularName":"",
         "namespaced":true,
         "kind":"ConfigMap",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "cm"
         ]
      },
      "endpoints":{
         "name":"endpoints",
         "singularName":"",
         "namespaced":true,
         "kind":"Endpoints",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "ep"
         ]
      },
      "events":{
         "name":"events",
         "singularName":"",
         "namespaced":true,
         "kind":"Event",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "ev"
         ]
      },
      "limitranges":{
         "name":"limitranges",
         "singularName":"",
         "namespaced":true,
         "kind":"LimitRange",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "limits"
         ]
      },
      "namespaces":{
         "name":"namespaces",
         "singularName":"",
         "namespaced":false,
         "kind":"Namespace",
         "verbs":[
            "create",
            "delete",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "ns"
         ]
      },
      "namespaces/finalize":{
         "name":"namespaces/finalize",
         "singularName":"",
         "namespaced":false,
         "kind":"Namespace",
         "verbs":[
            "update"
         ]
      },
      "namespaces/status":{
         "name":"namespaces/status",
         "singularName":"",
         "namespaced":false,
         "kind":"Namespace",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "nodes":{
         "name":"nodes",
         "singularName":"",
         "namespaced":false,
         "kind":"Node",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "proxy",
            "update",
            "watch"
         ],
         "shortNames":[
            "no"
         ]
      },
      "nodes/proxy":{
         "name":"nodes/proxy",
         "singularName":"",
         "namespaced":false,
         "kind":"Node",
         "verbs":[

         ]
      },
      "nodes/status":{
         "name":"nodes/status",
         "singularName":"",
         "namespaced":false,
         "kind":"Node",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "persistentvolumeclaims":{
         "name":"persistentvolumeclaims",
         "singularName":"",
         "namespaced":true,
         "kind":"PersistentVolumeClaim",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "pvc"
         ]
      },
      "persistentvolumeclaims/status":{
         "name":"persistentvolumeclaims/status",
         "singularName":"",
         "namespaced":true,
         "kind":"PersistentVolumeClaim",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "persistentvolumes":{
         "name":"persistentvolumes",
         "singularName":"",
         "namespaced":false,
         "kind":"PersistentVolume",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "pv"
         ]
      },
      "persistentvolumes/status":{
         "name":"persistentvolumes/status",
         "singularName":"",
         "namespaced":false,
         "kind":"PersistentVolume",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "pods":{
         "name":"pods",
         "singularName":"",
         "namespaced":true,
         "kind":"Pod",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "proxy",
            "update",
            "watch"
         ],
         "shortNames":[
            "po"
         ],
         "categories":[
            "all"
         ]
      },
      "pods/attach":{
         "name":"pods/attach",
         "singularName":"",
         "namespaced":true,
         "kind":"Pod",
         "verbs":[

         ]
      },
      "pods/binding":{
         "name":"pods/binding",
         "singularName":"",
         "namespaced":true,
         "kind":"Binding",
         "verbs":[
            "create"
         ]
      },
      "pods/eviction":{
         "name":"pods/eviction",
         "singularName":"",
         "namespaced":true,
         "group":"policy",
         "version":"v1beta1",
         "kind":"Eviction",
         "verbs":[
            "create"
         ]
      },
      "pods/exec":{
         "name":"pods/exec",
         "singularName":"",
         "namespaced":true,
         "kind":"Pod",
         "verbs":[

         ]
      },
      "pods/log":{
         "name":"pods/log",
         "singularName":"",
         "namespaced":true,
         "kind":"Pod",
         "verbs":[
            "get"
         ]
      },
      "pods/portforward":{
         "name":"pods/portforward",
         "singularName":"",
         "namespaced":true,
         "kind":"Pod",
         "verbs":[

         ]
      },
      "pods/proxy":{
         "name":"pods/proxy",
         "singularName":"",
         "namespaced":true,
         "kind":"Pod",
         "verbs":[

         ]
      },
      "pods/status":{
         "name":"pods/status",
         "singularName":"",
         "namespaced":true,
         "kind":"Pod",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "podtemplates":{
         "name":"podtemplates",
         "singularName":"",
         "namespaced":true,
         "kind":"PodTemplate",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "replicationcontrollers":{
         "name":"replicationcontrollers",
         "singularName":"",
         "namespaced":true,
         "kind":"ReplicationController",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "rc"
         ],
         "categories":[
            "all"
         ]
      },
      "replicationcontrollers/scale":{
         "name":"replicationcontrollers/scale",
         "singularName":"",
         "namespaced":true,
         "group":"autoscaling",
         "version":"v1",
         "kind":"Scale",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "replicationcontrollers/status":{
         "name":"replicationcontrollers/status",
         "singularName":"",
         "namespaced":true,
         "kind":"ReplicationController",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "resourcequotas":{
         "name":"resourcequotas",
         "singularName":"",
         "namespaced":true,
         "kind":"ResourceQuota",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "quota"
         ]
      },
      "resourcequotas/status":{
         "name":"resourcequotas/status",
         "singularName":"",
         "namespaced":true,
         "kind":"ResourceQuota",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "secrets":{
         "name":"secrets",
         "singularName":"",
         "namespaced":true,
         "kind":"Secret",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "securitycontextconstraints":{
         "name":"securitycontextconstraints",
         "singularName":"",
         "namespaced":false,
         "kind":"SecurityContextConstraints",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "scc"
         ]
      },
      "serviceaccounts":{
         "name":"serviceaccounts",
         "singularName":"",
         "namespaced":true,
         "kind":"ServiceAccount",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "sa"
         ]
      },
      "services":{
         "name":"services",
         "singularName":"",
         "namespaced":true,
         "kind":"Service",
         "verbs":[
            "create",
            "delete",
            "get",
            "list",
            "patch",
            "proxy",
            "update",
            "watch"
         ],
         "shortNames":[
            "svc"
         ],
         "categories":[
            "all"
         ]
      },
      "services/proxy":{
         "name":"services/proxy",
         "singularName":"",
         "namespaced":true,
         "kind":"Service",
         "verbs":[

         ]
      },
      "services/status":{
         "name":"services/status",
         "singularName":"",
         "namespaced":true,
         "kind":"Service",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      }
   }
};


window.OPENSHIFT_CONFIG.api.openshift.resources = {
   "v1":{
      "appliedclusterresourcequotas":{
         "name":"appliedclusterresourcequotas",
         "singularName":"",
         "namespaced":true,
         "kind":"AppliedClusterResourceQuota",
         "verbs":[
            "get",
            "list"
         ]
      },
      "buildconfigs":{
         "name":"buildconfigs",
         "singularName":"",
         "namespaced":true,
         "kind":"BuildConfig",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "bc"
         ]
      },
      "buildconfigs/instantiate":{
         "name":"buildconfigs/instantiate",
         "singularName":"",
         "namespaced":true,
         "kind":"BuildRequest",
         "verbs":[
            "create"
         ]
      },
      "buildconfigs/instantiatebinary":{
         "name":"buildconfigs/instantiatebinary",
         "singularName":"",
         "namespaced":true,
         "kind":"BinaryBuildRequestOptions",
         "verbs":[

         ]
      },
      "buildconfigs/webhooks":{
         "name":"buildconfigs/webhooks",
         "singularName":"",
         "namespaced":true,
         "kind":"Build",
         "verbs":[

         ]
      },
      "builds":{
         "name":"builds",
         "singularName":"",
         "namespaced":true,
         "kind":"Build",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "builds/clone":{
         "name":"builds/clone",
         "singularName":"",
         "namespaced":true,
         "kind":"BuildRequest",
         "verbs":[
            "create"
         ]
      },
      "builds/details":{
         "name":"builds/details",
         "singularName":"",
         "namespaced":true,
         "kind":"Build",
         "verbs":[
            "update"
         ]
      },
      "builds/log":{
         "name":"builds/log",
         "singularName":"",
         "namespaced":true,
         "kind":"BuildLog",
         "verbs":[
            "get"
         ]
      },
      "clusternetworks":{
         "name":"clusternetworks",
         "singularName":"",
         "namespaced":false,
         "kind":"ClusterNetwork",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "clusterresourcequotas":{
         "name":"clusterresourcequotas",
         "singularName":"",
         "namespaced":false,
         "kind":"ClusterResourceQuota",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "clusterquota"
         ]
      },
      "clusterresourcequotas/status":{
         "name":"clusterresourcequotas/status",
         "singularName":"",
         "namespaced":false,
         "kind":"ClusterResourceQuota",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "clusterrolebindings":{
         "name":"clusterrolebindings",
         "singularName":"",
         "namespaced":false,
         "kind":"ClusterRoleBinding",
         "verbs":[
            "create",
            "delete",
            "get",
            "list",
            "patch",
            "update"
         ]
      },
      "clusterroles":{
         "name":"clusterroles",
         "singularName":"",
         "namespaced":false,
         "kind":"ClusterRole",
         "verbs":[
            "create",
            "delete",
            "get",
            "list",
            "patch",
            "update"
         ]
      },
      "deploymentconfigs":{
         "name":"deploymentconfigs",
         "singularName":"",
         "namespaced":true,
         "kind":"DeploymentConfig",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "dc"
         ]
      },
      "deploymentconfigs/instantiate":{
         "name":"deploymentconfigs/instantiate",
         "singularName":"",
         "namespaced":true,
         "kind":"DeploymentRequest",
         "verbs":[
            "create"
         ]
      },
      "deploymentconfigs/log":{
         "name":"deploymentconfigs/log",
         "singularName":"",
         "namespaced":true,
         "kind":"DeploymentLog",
         "verbs":[
            "get"
         ]
      },
      "deploymentconfigs/rollback":{
         "name":"deploymentconfigs/rollback",
         "singularName":"",
         "namespaced":true,
         "kind":"DeploymentConfigRollback",
         "verbs":[
            "create"
         ]
      },
      "deploymentconfigs/scale":{
         "name":"deploymentconfigs/scale",
         "singularName":"",
         "namespaced":true,
         "group":"extensions",
         "version":"v1beta1",
         "kind":"Scale",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "deploymentconfigs/status":{
         "name":"deploymentconfigs/status",
         "singularName":"",
         "namespaced":true,
         "kind":"DeploymentConfig",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "egressnetworkpolicies":{
         "name":"egressnetworkpolicies",
         "singularName":"",
         "namespaced":true,
         "kind":"EgressNetworkPolicy",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "groups":{
         "name":"groups",
         "singularName":"",
         "namespaced":false,
         "kind":"Group",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "hostsubnets":{
         "name":"hostsubnets",
         "singularName":"",
         "namespaced":false,
         "kind":"HostSubnet",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "identities":{
         "name":"identities",
         "singularName":"",
         "namespaced":false,
         "kind":"Identity",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "images":{
         "name":"images",
         "singularName":"",
         "namespaced":false,
         "kind":"Image",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "imagesignatures":{
         "name":"imagesignatures",
         "singularName":"",
         "namespaced":false,
         "kind":"ImageSignature",
         "verbs":[
            "create",
            "delete"
         ]
      },
      "imagestreamimages":{
         "name":"imagestreamimages",
         "singularName":"",
         "namespaced":true,
         "kind":"ImageStreamImage",
         "verbs":[
            "get"
         ],
         "shortNames":[
            "isimage"
         ]
      },
      "imagestreamimports":{
         "name":"imagestreamimports",
         "singularName":"",
         "namespaced":true,
         "kind":"ImageStreamImport",
         "verbs":[
            "create"
         ]
      },
      "imagestreammappings":{
         "name":"imagestreammappings",
         "singularName":"",
         "namespaced":true,
         "kind":"ImageStreamMapping",
         "verbs":[
            "create"
         ]
      },
      "imagestreams":{
         "name":"imagestreams",
         "singularName":"",
         "namespaced":true,
         "kind":"ImageStream",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ],
         "shortNames":[
            "is"
         ]
      },
      "imagestreams/secrets":{
         "name":"imagestreams/secrets",
         "singularName":"",
         "namespaced":true,
         "kind":"SecretList",
         "verbs":[
            "get"
         ]
      },
      "imagestreams/status":{
         "name":"imagestreams/status",
         "singularName":"",
         "namespaced":true,
         "kind":"ImageStream",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "imagestreamtags":{
         "name":"imagestreamtags",
         "singularName":"",
         "namespaced":true,
         "kind":"ImageStreamTag",
         "verbs":[
            "create",
            "delete",
            "get",
            "list",
            "patch",
            "update"
         ],
         "shortNames":[
            "istag"
         ]
      },
      "localresourceaccessreviews":{
         "name":"localresourceaccessreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"LocalResourceAccessReview",
         "verbs":[
            "create"
         ]
      },
      "localsubjectaccessreviews":{
         "name":"localsubjectaccessreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"LocalSubjectAccessReview",
         "verbs":[
            "create"
         ]
      },
      "netnamespaces":{
         "name":"netnamespaces",
         "singularName":"",
         "namespaced":false,
         "kind":"NetNamespace",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "oauthaccesstokens":{
         "name":"oauthaccesstokens",
         "singularName":"",
         "namespaced":false,
         "kind":"OAuthAccessToken",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "oauthauthorizetokens":{
         "name":"oauthauthorizetokens",
         "singularName":"",
         "namespaced":false,
         "kind":"OAuthAuthorizeToken",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "oauthclientauthorizations":{
         "name":"oauthclientauthorizations",
         "singularName":"",
         "namespaced":false,
         "kind":"OAuthClientAuthorization",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "oauthclients":{
         "name":"oauthclients",
         "singularName":"",
         "namespaced":false,
         "kind":"OAuthClient",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "podsecuritypolicyreviews":{
         "name":"podsecuritypolicyreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"PodSecurityPolicyReview",
         "verbs":[
            "create"
         ]
      },
      "podsecuritypolicyselfsubjectreviews":{
         "name":"podsecuritypolicyselfsubjectreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"PodSecurityPolicySelfSubjectReview",
         "verbs":[
            "create"
         ]
      },
      "podsecuritypolicysubjectreviews":{
         "name":"podsecuritypolicysubjectreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"PodSecurityPolicySubjectReview",
         "verbs":[
            "create"
         ]
      },
      "processedtemplates":{
         "name":"processedtemplates",
         "singularName":"",
         "namespaced":true,
         "kind":"Template",
         "verbs":[
            "create"
         ]
      },
      "projectrequests":{
         "name":"projectrequests",
         "singularName":"",
         "namespaced":false,
         "kind":"ProjectRequest",
         "verbs":[
            "create",
            "list"
         ]
      },
      "projects":{
         "name":"projects",
         "singularName":"",
         "namespaced":false,
         "kind":"Project",
         "verbs":[
            "create",
            "delete",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "resourceaccessreviews":{
         "name":"resourceaccessreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"ResourceAccessReview",
         "verbs":[
            "create"
         ]
      },
      "rolebindingrestrictions":{
         "name":"rolebindingrestrictions",
         "singularName":"",
         "namespaced":true,
         "kind":"RoleBindingRestriction",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "rolebindings":{
         "name":"rolebindings",
         "singularName":"",
         "namespaced":true,
         "kind":"RoleBinding",
         "verbs":[
            "create",
            "delete",
            "get",
            "list",
            "patch",
            "update"
         ]
      },
      "roles":{
         "name":"roles",
         "singularName":"",
         "namespaced":true,
         "kind":"Role",
         "verbs":[
            "create",
            "delete",
            "get",
            "list",
            "patch",
            "update"
         ]
      },
      "routes":{
         "name":"routes",
         "singularName":"",
         "namespaced":true,
         "kind":"Route",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "routes/status":{
         "name":"routes/status",
         "singularName":"",
         "namespaced":true,
         "kind":"Route",
         "verbs":[
            "get",
            "patch",
            "update"
         ]
      },
      "selfsubjectrulesreviews":{
         "name":"selfsubjectrulesreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"SelfSubjectRulesReview",
         "verbs":[
            "create"
         ]
      },
      "subjectaccessreviews":{
         "name":"subjectaccessreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"SubjectAccessReview",
         "verbs":[
            "create"
         ]
      },
      "subjectrulesreviews":{
         "name":"subjectrulesreviews",
         "singularName":"",
         "namespaced":true,
         "kind":"SubjectRulesReview",
         "verbs":[
            "create"
         ]
      },
      "templates":{
         "name":"templates",
         "singularName":"",
         "namespaced":true,
         "kind":"Template",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      },
      "useridentitymappings":{
         "name":"useridentitymappings",
         "singularName":"",
         "namespaced":false,
         "kind":"UserIdentityMapping",
         "verbs":[
            "create",
            "delete",
            "get",
            "patch",
            "update"
         ]
      },
      "users":{
         "name":"users",
         "singularName":"",
         "namespaced":false,
         "kind":"User",
         "verbs":[
            "create",
            "delete",
            "deletecollection",
            "get",
            "list",
            "patch",
            "update",
            "watch"
         ]
      }
   }
};

window.OPENSHIFT_CONFIG.apis.groups = {
   "apiregistration.k8s.io":{
      "name":"apiregistration.k8s.io",
      "preferredVersion":"v1beta1",
      "versions":{
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"apiregistration.k8s.io/v1beta1",
            "resources":{
               "apiservices":{
                  "name":"apiservices",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"APIService",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "apiservices/status":{
                  "name":"apiservices/status",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"APIService",
                  "verbs":[
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "extensions":{
      "name":"extensions",
      "preferredVersion":"v1beta1",
      "versions":{
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"extensions/v1beta1",
            "resources":{
               "daemonsets":{
                  "name":"daemonsets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DaemonSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "ds"
                  ]
               },
               "daemonsets/status":{
                  "name":"daemonsets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DaemonSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "deployments":{
                  "name":"deployments",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Deployment",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "deploy"
                  ]
               },
               "deployments/rollback":{
                  "name":"deployments/rollback",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DeploymentRollback",
                  "verbs":[
                     "create"
                  ]
               },
               "deployments/scale":{
                  "name":"deployments/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"extensions",
                  "version":"v1beta1",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "deployments/status":{
                  "name":"deployments/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Deployment",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "ingresses":{
                  "name":"ingresses",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Ingress",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "ing"
                  ]
               },
               "ingresses/status":{
                  "name":"ingresses/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Ingress",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "networkpolicies":{
                  "name":"networkpolicies",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"NetworkPolicy",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "netpol"
                  ]
               },
               "podsecuritypolicies":{
                  "name":"podsecuritypolicies",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"PodSecurityPolicy",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "psp"
                  ]
               },
               "replicasets":{
                  "name":"replicasets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ReplicaSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "rs"
                  ]
               },
               "replicasets/scale":{
                  "name":"replicasets/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"extensions",
                  "version":"v1beta1",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "replicasets/status":{
                  "name":"replicasets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ReplicaSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "replicationcontrollers":{
                  "name":"replicationcontrollers",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ReplicationControllerDummy",
                  "verbs":[

                  ]
               },
               "replicationcontrollers/scale":{
                  "name":"replicationcontrollers/scale",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "apps":{
      "name":"apps",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"apps/v1",
            "resources":{
               "controllerrevisions":{
                  "name":"controllerrevisions",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ControllerRevision",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "daemonsets":{
                  "name":"daemonsets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DaemonSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "ds"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "daemonsets/status":{
                  "name":"daemonsets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DaemonSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "deployments":{
                  "name":"deployments",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Deployment",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "deploy"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "deployments/scale":{
                  "name":"deployments/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"autoscaling",
                  "version":"v1",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "deployments/status":{
                  "name":"deployments/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Deployment",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "replicasets":{
                  "name":"replicasets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ReplicaSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "rs"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "replicasets/scale":{
                  "name":"replicasets/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"autoscaling",
                  "version":"v1",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "replicasets/status":{
                  "name":"replicasets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ReplicaSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "statefulsets":{
                  "name":"statefulsets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"StatefulSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "sts"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "statefulsets/scale":{
                  "name":"statefulsets/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"autoscaling",
                  "version":"v1",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "statefulsets/status":{
                  "name":"statefulsets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"StatefulSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         },
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"apps/v1beta1",
            "resources":{
               "controllerrevisions":{
                  "name":"controllerrevisions",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ControllerRevision",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "deployments":{
                  "name":"deployments",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Deployment",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "deploy"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "deployments/rollback":{
                  "name":"deployments/rollback",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DeploymentRollback",
                  "verbs":[
                     "create"
                  ]
               },
               "deployments/scale":{
                  "name":"deployments/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"apps",
                  "version":"v1beta1",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "deployments/status":{
                  "name":"deployments/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Deployment",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "statefulsets":{
                  "name":"statefulsets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"StatefulSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "sts"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "statefulsets/scale":{
                  "name":"statefulsets/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"apps",
                  "version":"v1beta1",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "statefulsets/status":{
                  "name":"statefulsets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"StatefulSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         },
         "v1beta2":{
            "version":"v1beta2",
            "groupVersion":"apps/v1beta2",
            "resources":{
               "controllerrevisions":{
                  "name":"controllerrevisions",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ControllerRevision",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "daemonsets":{
                  "name":"daemonsets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DaemonSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "ds"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "daemonsets/status":{
                  "name":"daemonsets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DaemonSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "deployments":{
                  "name":"deployments",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Deployment",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "deploy"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "deployments/scale":{
                  "name":"deployments/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"apps",
                  "version":"v1beta2",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "deployments/status":{
                  "name":"deployments/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Deployment",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "replicasets":{
                  "name":"replicasets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ReplicaSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "rs"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "replicasets/scale":{
                  "name":"replicasets/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"apps",
                  "version":"v1beta2",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "replicasets/status":{
                  "name":"replicasets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ReplicaSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "statefulsets":{
                  "name":"statefulsets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"StatefulSet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "sts"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "statefulsets/scale":{
                  "name":"statefulsets/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"apps",
                  "version":"v1beta2",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "statefulsets/status":{
                  "name":"statefulsets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"StatefulSet",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "events.k8s.io":{
      "name":"events.k8s.io",
      "preferredVersion":"v1beta1",
      "versions":{
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"events.k8s.io/v1beta1",
            "resources":{
               "events":{
                  "name":"events",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Event",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "ev"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "authentication.k8s.io":{
      "name":"authentication.k8s.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"authentication.k8s.io/v1",
            "resources":{
               "tokenreviews":{
                  "name":"tokenreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"TokenReview",
                  "verbs":[
                     "create"
                  ]
               }
            }
         },
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"authentication.k8s.io/v1beta1",
            "resources":{
               "tokenreviews":{
                  "name":"tokenreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"TokenReview",
                  "verbs":[
                     "create"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "authorization.k8s.io":{
      "name":"authorization.k8s.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"authorization.k8s.io/v1",
            "resources":{
               "localsubjectaccessreviews":{
                  "name":"localsubjectaccessreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"LocalSubjectAccessReview",
                  "verbs":[
                     "create"
                  ]
               },
               "selfsubjectaccessreviews":{
                  "name":"selfsubjectaccessreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"SelfSubjectAccessReview",
                  "verbs":[
                     "create"
                  ]
               },
               "selfsubjectrulesreviews":{
                  "name":"selfsubjectrulesreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"SelfSubjectRulesReview",
                  "verbs":[
                     "create"
                  ]
               },
               "subjectaccessreviews":{
                  "name":"subjectaccessreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"SubjectAccessReview",
                  "verbs":[
                     "create"
                  ]
               }
            }
         },
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"authorization.k8s.io/v1beta1",
            "resources":{
               "localsubjectaccessreviews":{
                  "name":"localsubjectaccessreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"LocalSubjectAccessReview",
                  "verbs":[
                     "create"
                  ]
               },
               "selfsubjectaccessreviews":{
                  "name":"selfsubjectaccessreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"SelfSubjectAccessReview",
                  "verbs":[
                     "create"
                  ]
               },
               "selfsubjectrulesreviews":{
                  "name":"selfsubjectrulesreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"SelfSubjectRulesReview",
                  "verbs":[
                     "create"
                  ]
               },
               "subjectaccessreviews":{
                  "name":"subjectaccessreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"SubjectAccessReview",
                  "verbs":[
                     "create"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "autoscaling":{
      "name":"autoscaling",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"autoscaling/v1",
            "resources":{
               "horizontalpodautoscalers":{
                  "name":"horizontalpodautoscalers",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"HorizontalPodAutoscaler",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "hpa"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "horizontalpodautoscalers/status":{
                  "name":"horizontalpodautoscalers/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"HorizontalPodAutoscaler",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         },
         "v2beta1":{
            "version":"v2beta1",
            "groupVersion":"autoscaling/v2beta1",
            "resources":{
               "horizontalpodautoscalers":{
                  "name":"horizontalpodautoscalers",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"HorizontalPodAutoscaler",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "hpa"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "horizontalpodautoscalers/status":{
                  "name":"horizontalpodautoscalers/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"HorizontalPodAutoscaler",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "batch":{
      "name":"batch",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"batch/v1",
            "resources":{
               "jobs":{
                  "name":"jobs",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Job",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "jobs/status":{
                  "name":"jobs/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Job",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         },
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"batch/v1beta1",
            "resources":{
               "cronjobs":{
                  "name":"cronjobs",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"CronJob",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "cronjobs/status":{
                  "name":"cronjobs/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"CronJob",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         },
         "v2alpha1":{
            "version":"v2alpha1",
            "groupVersion":"batch/v2alpha1",
            "resources":{
               "cronjobs":{
                  "name":"cronjobs",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"CronJob",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "cronjobs/status":{
                  "name":"cronjobs/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"CronJob",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "certificates.k8s.io":{
      "name":"certificates.k8s.io",
      "preferredVersion":"v1beta1",
      "versions":{
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"certificates.k8s.io/v1beta1",
            "resources":{
               "certificatesigningrequests":{
                  "name":"certificatesigningrequests",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"CertificateSigningRequest",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "csr"
                  ]
               },
               "certificatesigningrequests/approval":{
                  "name":"certificatesigningrequests/approval",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"CertificateSigningRequest",
                  "verbs":[
                     "update"
                  ]
               },
               "certificatesigningrequests/status":{
                  "name":"certificatesigningrequests/status",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"CertificateSigningRequest",
                  "verbs":[
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "networking.k8s.io":{
      "name":"networking.k8s.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"networking.k8s.io/v1",
            "resources":{
               "networkpolicies":{
                  "name":"networkpolicies",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"NetworkPolicy",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "netpol"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "policy":{
      "name":"policy",
      "preferredVersion":"v1beta1",
      "versions":{
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"policy/v1beta1",
            "resources":{
               "poddisruptionbudgets":{
                  "name":"poddisruptionbudgets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"PodDisruptionBudget",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "pdb"
                  ]
               },
               "poddisruptionbudgets/status":{
                  "name":"poddisruptionbudgets/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"PodDisruptionBudget",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "authorization.openshift.io":{
      "name":"authorization.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"authorization.openshift.io/v1",
            "resources":{
               "clusterrolebindings":{
                  "name":"clusterrolebindings",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterRoleBinding",
                  "verbs":[
                     "create",
                     "delete",
                     "get",
                     "list",
                     "patch",
                     "update"
                  ]
               },
               "clusterroles":{
                  "name":"clusterroles",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterRole",
                  "verbs":[
                     "create",
                     "delete",
                     "get",
                     "list",
                     "patch",
                     "update"
                  ]
               },
               "localresourceaccessreviews":{
                  "name":"localresourceaccessreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"LocalResourceAccessReview",
                  "verbs":[
                     "create"
                  ]
               },
               "localsubjectaccessreviews":{
                  "name":"localsubjectaccessreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"LocalSubjectAccessReview",
                  "verbs":[
                     "create"
                  ]
               },
               "resourceaccessreviews":{
                  "name":"resourceaccessreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ResourceAccessReview",
                  "verbs":[
                     "create"
                  ]
               },
               "rolebindingrestrictions":{
                  "name":"rolebindingrestrictions",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"RoleBindingRestriction",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "rolebindings":{
                  "name":"rolebindings",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"RoleBinding",
                  "verbs":[
                     "create",
                     "delete",
                     "get",
                     "list",
                     "patch",
                     "update"
                  ]
               },
               "roles":{
                  "name":"roles",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Role",
                  "verbs":[
                     "create",
                     "delete",
                     "get",
                     "list",
                     "patch",
                     "update"
                  ]
               },
               "selfsubjectrulesreviews":{
                  "name":"selfsubjectrulesreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"SelfSubjectRulesReview",
                  "verbs":[
                     "create"
                  ]
               },
               "subjectaccessreviews":{
                  "name":"subjectaccessreviews",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"SubjectAccessReview",
                  "verbs":[
                     "create"
                  ]
               },
               "subjectrulesreviews":{
                  "name":"subjectrulesreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"SubjectRulesReview",
                  "verbs":[
                     "create"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "rbac.authorization.k8s.io":{
      "name":"rbac.authorization.k8s.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"rbac.authorization.k8s.io/v1",
            "resources":{
               "clusterrolebindings":{
                  "name":"clusterrolebindings",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterRoleBinding",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "clusterroles":{
                  "name":"clusterroles",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterRole",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "rolebindings":{
                  "name":"rolebindings",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"RoleBinding",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "roles":{
                  "name":"roles",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Role",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         },
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"rbac.authorization.k8s.io/v1beta1",
            "resources":{
               "clusterrolebindings":{
                  "name":"clusterrolebindings",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterRoleBinding",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "clusterroles":{
                  "name":"clusterroles",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterRole",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "rolebindings":{
                  "name":"rolebindings",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"RoleBinding",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "roles":{
                  "name":"roles",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Role",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "settings.k8s.io":{
      "name":"settings.k8s.io",
      "preferredVersion":"v1alpha1",
      "versions":{
         "v1alpha1":{
            "version":"v1alpha1",
            "groupVersion":"settings.k8s.io/v1alpha1",
            "resources":{
               "podpresets":{
                  "name":"podpresets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"PodPreset",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "storage.k8s.io":{
      "name":"storage.k8s.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"storage.k8s.io/v1",
            "resources":{
               "storageclasses":{
                  "name":"storageclasses",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"StorageClass",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "sc"
                  ]
               }
            }
         },
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"storage.k8s.io/v1beta1",
            "resources":{
               "storageclasses":{
                  "name":"storageclasses",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"StorageClass",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "sc"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "admissionregistration.k8s.io":{
      "name":"admissionregistration.k8s.io",
      "preferredVersion":"v1beta1",
      "versions":{
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"admissionregistration.k8s.io/v1beta1",
            "resources":{
               "mutatingwebhookconfigurations":{
                  "name":"mutatingwebhookconfigurations",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"MutatingWebhookConfiguration",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "validatingwebhookconfigurations":{
                  "name":"validatingwebhookconfigurations",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ValidatingWebhookConfiguration",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         },
         "v1alpha1":{
            "version":"v1alpha1",
            "groupVersion":"admissionregistration.k8s.io/v1alpha1",
            "resources":{
               "initializerconfigurations":{
                  "name":"initializerconfigurations",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"InitializerConfiguration",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "apiextensions.k8s.io":{
      "name":"apiextensions.k8s.io",
      "preferredVersion":"v1beta1",
      "versions":{
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"apiextensions.k8s.io/v1beta1",
            "resources":{
               "customresourcedefinitions":{
                  "name":"customresourcedefinitions",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"CustomResourceDefinition",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "crd"
                  ]
               },
               "customresourcedefinitions/status":{
                  "name":"customresourcedefinitions/status",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"CustomResourceDefinition",
                  "verbs":[
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "apps.openshift.io":{
      "name":"apps.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"apps.openshift.io/v1",
            "resources":{
               "deploymentconfigs":{
                  "name":"deploymentconfigs",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DeploymentConfig",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "dc"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "deploymentconfigs/instantiate":{
                  "name":"deploymentconfigs/instantiate",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DeploymentRequest",
                  "verbs":[
                     "create"
                  ]
               },
               "deploymentconfigs/log":{
                  "name":"deploymentconfigs/log",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DeploymentLog",
                  "verbs":[
                     "get"
                  ]
               },
               "deploymentconfigs/rollback":{
                  "name":"deploymentconfigs/rollback",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DeploymentConfigRollback",
                  "verbs":[
                     "create"
                  ]
               },
               "deploymentconfigs/scale":{
                  "name":"deploymentconfigs/scale",
                  "singularName":"",
                  "namespaced":true,
                  "group":"extensions",
                  "version":"v1beta1",
                  "kind":"Scale",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "deploymentconfigs/status":{
                  "name":"deploymentconfigs/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"DeploymentConfig",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "build.openshift.io":{
      "name":"build.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"build.openshift.io/v1",
            "resources":{
               "buildconfigs":{
                  "name":"buildconfigs",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"BuildConfig",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "bc"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "buildconfigs/instantiate":{
                  "name":"buildconfigs/instantiate",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"BuildRequest",
                  "verbs":[
                     "create"
                  ]
               },
               "buildconfigs/instantiatebinary":{
                  "name":"buildconfigs/instantiatebinary",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"BinaryBuildRequestOptions",
                  "verbs":[

                  ]
               },
               "buildconfigs/webhooks":{
                  "name":"buildconfigs/webhooks",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Build",
                  "verbs":[

                  ]
               },
               "builds":{
                  "name":"builds",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Build",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "builds/clone":{
                  "name":"builds/clone",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"BuildRequest",
                  "verbs":[
                     "create"
                  ]
               },
               "builds/details":{
                  "name":"builds/details",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Build",
                  "verbs":[
                     "update"
                  ]
               },
               "builds/log":{
                  "name":"builds/log",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"BuildLog",
                  "verbs":[
                     "get"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "image.openshift.io":{
      "name":"image.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"image.openshift.io/v1",
            "resources":{
               "images":{
                  "name":"images",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"Image",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "imagesignatures":{
                  "name":"imagesignatures",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ImageSignature",
                  "verbs":[
                     "create",
                     "delete"
                  ]
               },
               "imagestreamimages":{
                  "name":"imagestreamimages",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ImageStreamImage",
                  "verbs":[
                     "get"
                  ],
                  "shortNames":[
                     "isimage"
                  ]
               },
               "imagestreamimports":{
                  "name":"imagestreamimports",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ImageStreamImport",
                  "verbs":[
                     "create"
                  ]
               },
               "imagestreammappings":{
                  "name":"imagestreammappings",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ImageStreamMapping",
                  "verbs":[
                     "create"
                  ]
               },
               "imagestreams":{
                  "name":"imagestreams",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ImageStream",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "is"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "imagestreams/secrets":{
                  "name":"imagestreams/secrets",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"SecretList",
                  "verbs":[
                     "get"
                  ]
               },
               "imagestreams/status":{
                  "name":"imagestreams/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ImageStream",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "imagestreamtags":{
                  "name":"imagestreamtags",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ImageStreamTag",
                  "verbs":[
                     "create",
                     "delete",
                     "get",
                     "list",
                     "patch",
                     "update"
                  ],
                  "shortNames":[
                     "istag"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "network.openshift.io":{
      "name":"network.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"network.openshift.io/v1",
            "resources":{
               "clusternetworks":{
                  "name":"clusternetworks",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterNetwork",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "egressnetworkpolicies":{
                  "name":"egressnetworkpolicies",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"EgressNetworkPolicy",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "hostsubnets":{
                  "name":"hostsubnets",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"HostSubnet",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "netnamespaces":{
                  "name":"netnamespaces",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"NetNamespace",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "oauth.openshift.io":{
      "name":"oauth.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"oauth.openshift.io/v1",
            "resources":{
               "oauthaccesstokens":{
                  "name":"oauthaccesstokens",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"OAuthAccessToken",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "oauthauthorizetokens":{
                  "name":"oauthauthorizetokens",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"OAuthAuthorizeToken",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "oauthclientauthorizations":{
                  "name":"oauthclientauthorizations",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"OAuthClientAuthorization",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "oauthclients":{
                  "name":"oauthclients",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"OAuthClient",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "project.openshift.io":{
      "name":"project.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"project.openshift.io/v1",
            "resources":{
               "projectrequests":{
                  "name":"projectrequests",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ProjectRequest",
                  "verbs":[
                     "create",
                     "list"
                  ]
               },
               "projects":{
                  "name":"projects",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"Project",
                  "verbs":[
                     "create",
                     "delete",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "quota.openshift.io":{
      "name":"quota.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"quota.openshift.io/v1",
            "resources":{
               "appliedclusterresourcequotas":{
                  "name":"appliedclusterresourcequotas",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"AppliedClusterResourceQuota",
                  "verbs":[
                     "get",
                     "list"
                  ]
               },
               "clusterresourcequotas":{
                  "name":"clusterresourcequotas",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterResourceQuota",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "clusterquota"
                  ]
               },
               "clusterresourcequotas/status":{
                  "name":"clusterresourcequotas/status",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterResourceQuota",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "route.openshift.io":{
      "name":"route.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"route.openshift.io/v1",
            "resources":{
               "routes":{
                  "name":"routes",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Route",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "categories":[
                     "all"
                  ]
               },
               "routes/status":{
                  "name":"routes/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Route",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "security.openshift.io":{
      "name":"security.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"security.openshift.io/v1",
            "resources":{
               "podsecuritypolicyreviews":{
                  "name":"podsecuritypolicyreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"PodSecurityPolicyReview",
                  "verbs":[
                     "create"
                  ]
               },
               "podsecuritypolicyselfsubjectreviews":{
                  "name":"podsecuritypolicyselfsubjectreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"PodSecurityPolicySelfSubjectReview",
                  "verbs":[
                     "create"
                  ]
               },
               "podsecuritypolicysubjectreviews":{
                  "name":"podsecuritypolicysubjectreviews",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"PodSecurityPolicySubjectReview",
                  "verbs":[
                     "create"
                  ]
               },
               "securitycontextconstraints":{
                  "name":"securitycontextconstraints",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"SecurityContextConstraints",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ],
                  "shortNames":[
                     "scc"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "template.openshift.io":{
      "name":"template.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"template.openshift.io/v1",
            "resources":{
               "brokertemplateinstances":{
                  "name":"brokertemplateinstances",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"BrokerTemplateInstance",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "processedtemplates":{
                  "name":"processedtemplates",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Template",
                  "verbs":[
                     "create"
                  ]
               },
               "templateinstances":{
                  "name":"templateinstances",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"TemplateInstance",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "templateinstances/status":{
                  "name":"templateinstances/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"TemplateInstance",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "templates":{
                  "name":"templates",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"Template",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "user.openshift.io":{
      "name":"user.openshift.io",
      "preferredVersion":"v1",
      "versions":{
         "v1":{
            "version":"v1",
            "groupVersion":"user.openshift.io/v1",
            "resources":{
               "groups":{
                  "name":"groups",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"Group",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "identities":{
                  "name":"identities",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"Identity",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "useridentitymappings":{
                  "name":"useridentitymappings",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"UserIdentityMapping",
                  "verbs":[
                     "create",
                     "delete",
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "users":{
                  "name":"users",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"User",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   },
   "servicecatalog.k8s.io":{
      "name":"servicecatalog.k8s.io",
      "preferredVersion":"v1beta1",
      "versions":{
         "v1beta1":{
            "version":"v1beta1",
            "groupVersion":"servicecatalog.k8s.io/v1beta1",
            "resources":{
               "clusterservicebrokers":{
                  "name":"clusterservicebrokers",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterServiceBroker",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "clusterservicebrokers/status":{
                  "name":"clusterservicebrokers/status",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterServiceBroker",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "clusterserviceclasses":{
                  "name":"clusterserviceclasses",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterServiceClass",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "clusterserviceclasses/status":{
                  "name":"clusterserviceclasses/status",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterServiceClass",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "clusterserviceplans":{
                  "name":"clusterserviceplans",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterServicePlan",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "clusterserviceplans/status":{
                  "name":"clusterserviceplans/status",
                  "singularName":"",
                  "namespaced":false,
                  "kind":"ClusterServicePlan",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "servicebindings":{
                  "name":"servicebindings",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ServiceBinding",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "servicebindings/status":{
                  "name":"servicebindings/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ServiceBinding",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "serviceinstances":{
                  "name":"serviceinstances",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ServiceInstance",
                  "verbs":[
                     "create",
                     "delete",
                     "deletecollection",
                     "get",
                     "list",
                     "patch",
                     "update",
                     "watch"
                  ]
               },
               "serviceinstances/reference":{
                  "name":"serviceinstances/reference",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ServiceInstance",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               },
               "serviceinstances/status":{
                  "name":"serviceinstances/status",
                  "singularName":"",
                  "namespaced":true,
                  "kind":"ServiceInstance",
                  "verbs":[
                     "get",
                     "patch",
                     "update"
                  ]
               }
            }
         }
      },
      "hostPrefix":null
   }
};
