//
//  XLLTestCell.m
//  XLLDragCollectionView
//
//  Created by 肖乐 on 2018/3/22.
//  Copyright © 2018年 IMMoveMobile. All rights reserved.
//

#import "XLLTestCell.h"

@interface XLLTestCell ()

@property (nonatomic, weak) UILabel *descLabel;

@end

@implementation XLLTestCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        self.contentView.backgroundColor = [UIColor colorWithRed:(random()%256)/255.0 green:(random()%256)/255.0 blue:(random()%256)/255.0 alpha:1];
        
        UILabel *descLabel = [[UILabel alloc] init];
        descLabel.textColor = [UIColor blackColor];
        descLabel.textAlignment = NSTextAlignmentCenter;
        descLabel.font = [UIFont systemFontOfSize:15.0];
        [self.contentView addSubview:descLabel];
        self.descLabel = descLabel;
    }
    return self;
}

- (void)setContent:(NSString *)content
{
    _content = [content copy];
    self.descLabel.text = content;
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    self.descLabel.frame = CGRectMake((self.contentView.frame.size.width - 25)/2.0, (self.contentView.frame.size.height - 15)/2.0, 25, 15);
}

@end
