//
//  ViewController.m
//  XLLDragCollectionView
//
//  Created by 肖乐 on 2018/3/22.
//  Copyright © 2018年 IMMoveMobile. All rights reserved.
//

#import "ViewController.h"
#import "XLLDragCollectionView.h"
#import "XLLTestCell.h"

@interface ViewController () <XLLDragCollectionViewDelegate, XLLDragCollectionViewDataSource, UICollectionViewDelegateFlowLayout>

@property (nonatomic, weak) XLLDragCollectionView *collectionView;

@property (nonatomic, strong) NSMutableArray *sourceArray;

@end

@implementation ViewController

#pragma mark - lazy loading
- (NSMutableArray *)sourceArray
{
    if (_sourceArray == nil)
    {
        NSMutableArray *tempArr = [NSMutableArray array];
        for (NSInteger i = 0; i < 12; i++)
        {
            [tempArr addObject:@(i)];
        }
        _sourceArray = tempArr;
    }
    return _sourceArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    self.view.backgroundColor = [UIColor whiteColor];
    
    UICollectionViewFlowLayout *flowLayout = [[UICollectionViewFlowLayout alloc] init];
    flowLayout.scrollDirection = UICollectionViewScrollDirectionVertical;
    XLLDragCollectionView *collectionView = [[XLLDragCollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:flowLayout];
    collectionView.delegate = self;
    collectionView.dataSource = self;
    [collectionView registerClass:[XLLTestCell class] forCellWithReuseIdentifier:@"lalala"];
    [self.view addSubview:collectionView];
    self.collectionView = collectionView;
}

#pragma mark - XLLDragCollectionViewDelegate
- (void)dragCollectionView:(XLLDragCollectionView *)collectionView newDataArrayAfterMove:(NSArray *)newDataArray
{
    self.sourceArray = [newDataArray mutableCopy];
}



#pragma mark - XLLDragCollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.sourceArray.count;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(([UIScreen mainScreen].bounds.size.width - 5 * 15)/4.0, 90);
}

- (UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section
{
    return UIEdgeInsetsMake(15, 15, 15, 15);
}

- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumLineSpacingForSectionAtIndex:(NSInteger)section
{
    return 15.0;
}

- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section
{
    return 15.0;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    XLLTestCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"lalala" forIndexPath:indexPath];
    cell.content = [self.sourceArray[indexPath.item] stringValue];
    return cell;
}

- (void)viewDidLayoutSubviews
{
    [super viewDidLayoutSubviews];
    self.collectionView.frame = self.view.bounds;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
