//
//  XLLDragCollectionView.h
//  XLLDragCollectionView
//
//  Created by 肖乐 on 2018/3/22.
//  Copyright © 2018年 IMMoveMobile. All rights reserved.
//

#import <UIKit/UIKit.h>

@class XLLDragCollectionView;
@protocol XLLDragCollectionViewDataSource <UICollectionViewDataSource>

@required
- (NSArray *)dataSourceArrayOfCollectionView:(UICollectionView *)collectionView;

@end

@protocol XLLDragCollectionViewDelegate <UICollectionViewDelegate>

@required
- (void)dragCollectionView:(XLLDragCollectionView *)collectionView newDataArrayAfterMove:(NSArray *)newDataArray;

@end

@interface XLLDragCollectionView : UICollectionView

/**
 collectionView数据源代理
 */
@property (nonatomic, weak) id <XLLDragCollectionViewDataSource> dataSource;

/**
 collectionView回调代理
 */
@property (nonatomic, weak) id <XLLDragCollectionViewDelegate> delegate;

/**
 触发拖动的最小时间
 */
@property (nonatomic, assign) NSTimeInterval minimumTriggerTime;

@end
