package com.bbd.bpm.serviceImpl;

import com.bbd.bpm.base.PageBean;
import com.bbd.bpm.domain.BpmCompany;
import com.bbd.bpm.dao.UserInfoMapper;
import com.bbd.bpm.result.RespCode;
import com.bbd.bpm.result.Result;
import com.bbd.bpm.result.ResultUtil;
import com.bbd.bpm.service.UserInfoService;
import com.bbd.bpm.vo.BpmCompanyVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class UserInfoServiceImpl implements UserInfoService{

    @Autowired
    private UserInfoMapper userInfoMapper;

    @Override
    public Result getOrganization(PageBean pageBean) {
        try{
            PageHelper.startPage(pageBean.getPageNum(), pageBean.getPageSize());
            List<BpmCompanyVo> list = userInfoMapper.getOrganization();
            BpmCompanyVo bpmCompanyVo;
            for (int i=0;i<list.size();i++){
                Integer pId = list.get(i).getPId();
                bpmCompanyVo=userInfoMapper.getParentName(pId);
                //根据pid获取上级组织名称
                list.get(i).setParentName(bpmCompanyVo.getName());
            }
            PageInfo<BpmCompanyVo> pageInfo = new PageInfo<>(list);
            return ResultUtil.getResult(RespCode.Code.SUCCESS, pageInfo);
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.getResult(RespCode.Code.INTERNAL_SERVER_ERROR);
        }

    }

    @Override
    public Result getOrganizationList() {
        try {
            List<Map<String,Object>> organizations = userInfoMapper.getOrganizationList();
            return ResultUtil.getResult(RespCode.Code.SUCCESS,organizations);
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.getResult(RespCode.Code.INTERNAL_SERVER_ERROR);
        }
    }
}
