package com.bbd.bpm.controller.user;

import com.bbd.bpm.base.PageBean;
import com.bbd.bpm.result.Result;
import com.bbd.bpm.service.UserInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value = "/bpm/user")
public class userController {



    @Autowired
    private UserInfoService userInfoService;

    /**
     * @Author:cwd
     * @Description:进入组织管理
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "toOrganization")
    public String toOrganization(){
        return "user/organizationList";
    }


    /**
     * @Author:cwd
     * @Description:获取组织列表
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "getOrganization")
    @ResponseBody
    public Result getOrganization(Model model, PageBean pageBean){
        if(pageBean.getPageNum()==0){
            pageBean.setPageNum(1);
        }
        if (pageBean.getPageSize()==0) {
            pageBean.setPageSize(10);
        }
       Result result= userInfoService.getOrganization(pageBean);
       return result;
    }


    /**
     * @Author:cwd
     * @Description:加载ztree
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "getOrganizationList")
    @ResponseBody
    public Result getOrganization(){
        Result result = userInfoService.getOrganizationList();
        return result;
    }



}
