package com.bbd.bpm.controller.taskOperate;

import com.bbd.bpm.BpmResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by houkang on 2019/2/27.
 */
@RestController
@RequestMapping("/bpm/task")
@Api(tags = {"任务管理"})
public class TaskOperateController {
    private static final Logger Log = LoggerFactory.getLogger(TaskOperateController.class);

    @Autowired
    private TaskService taskService;

    ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();

    @ApiOperation(value = "查询待处理任务")
    @GetMapping("/pendingTaskList")
    public BpmResponse pendingTaskList(String assignee) {
        BpmResponse resp = new BpmResponse();
        //todo
        try{
            //任务办理人
            List<Task> taskList = taskService.createTaskQuery().taskAssignee(assignee).list();
            if(taskList!=null && taskList.size()>0){
                resp.setData(taskList);
                resp.setSuccess(true);
                resp.setMessage("查询待处理任务成功");
            }else{
                resp.setSuccess(true);
                resp.setData(null);
                resp.setMessage("查询待处理任务成功");
            }
        }catch (Exception e){
            Log.error("查询待处理任务失败",e);
            resp.setSuccess(false);
        }
        return resp;
    }

    @ApiOperation(value = "改变任务处理人")
    @GetMapping("/appointTaskTo")
    public BpmResponse appointTaskTo(String taskId,String userId) {
        BpmResponse resp = new BpmResponse();
        //todo
        try{
            //任务处理人id
            //String userId = UserUtil.getUserFromSession(session).getId();
            taskService.claim(taskId, userId);
            resp.setSuccess(true);
            resp.setMessage("改变任务处理人成功");
        }catch (Exception e){
            Log.error("改变任务处理人失败",e);
            resp.setSuccess(false);
        }

        return resp;
    }

    @ApiOperation(value = "删除任务")
    @GetMapping("/deleteTask")
    public BpmResponse deleteTask(String taskId) {
        BpmResponse resp = new BpmResponse();
        //todo
        try{
            taskService.deleteTask(taskId);
            resp.setSuccess(true);
            resp.setMessage("删除任务成功");
        }catch (Exception e){
            Log.error("删除任务失败",e);
            resp.setSuccess(false);
        }
        return resp;
    }

    @ApiOperation(value = "任务处理")
    @GetMapping("/completeTask")
    public BpmResponse completeTask(String taskId) {
        BpmResponse resp = new BpmResponse();
        //todo
        processEngine.getTaskService().complete(taskId);
        return resp;
    }
}
