package com.bbd.bpm.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.Date;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BpmCompanyVo {

    /**
     * 组织id
     */
    private Integer id;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createdTime;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 组织简写
     */
    private String abbreviationName;
    /**
     * 组织编码
     */
    private String code;

    /**
     * 组织关系
     */
    private String organizationRelation;

    /**
     * 上级id
     */
    private Integer pId;

    /**
     * 状态0.正常 1.异常  2删除
     */
    private Integer status;

    /**
     * 上级组织名称
     */
    private String parentName;
}
