package com.bbd.bpm.controller;


import com.bbd.bpm.domain.User;
import com.bbd.bpm.domain.VacationForm;
import com.bbd.bpm.service.MiaoService;
import com.bbd.bpm.util.ResultInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Controller
public class MiaoController {
	@Autowired
	private MiaoService miaoService;

	@GetMapping( "/")
	public String login(){
		return "login";
	}

	//申请者的首页
	@GetMapping( "/home")
	public String index(ModelMap model, HttpServletRequest request){
		List<VacationForm> forms = miaoService.formList();
		Cookie[] cookies = request.getCookies();
		String user = "";
		//从cookie中获取当前用户
		if (cookies != null) {
			for (Cookie cookie : cookies) {
				if (cookie.getName().equals("userInfo")) {
					user = cookie.getValue();
					break;
				}
			}
		}
		List<HashMap<String, Object>> formsMap = new ArrayList<HashMap<String, Object>>();
		for(VacationForm form : forms) {
			//申请者只能看到自己申请的请假单信息
			if(user.equals(form.getApplicant())) {
				HashMap<String, Object> map = new HashMap<String, Object>();
				map.put("id", form.getId());
				map.put("title", form.getTitle());
				map.put("content", form.getContent());
				map.put("applicant", form.getApplicant());
				map.put("days", form.getDays());
				map.put("state", form.getState());
				formsMap.add(map);
			}
		}
		//将forms参数返回
		model.addAttribute("forms",formsMap);
		return "index";
	}

	//审核者的首页
	@GetMapping( "/homeApprover")
	public String indexApprover(ModelMap model){
		List<VacationForm> forms = miaoService.formList();
		List<HashMap<String, Object>> formsMap = new ArrayList<HashMap<String, Object>>();
		for(VacationForm form : forms) {
			//审核者只能看到待审核状态的请假单
			if("领导审核".equals(form.getState())) {
				HashMap<String, Object> map = new HashMap<String, Object>();
				map.put("id", form.getId());
				map.put("title", form.getTitle());
				map.put("content", form.getContent());
				map.put("applicant", form.getApplicant());
				map.put("state", form.getState());
				formsMap.add(map);
			}
		}
		model.addAttribute("forms",formsMap);
		return "indexApprover";
	}


	//管理层的首页
	@GetMapping( "/homeApproverzjl")
	public String homeApproverzjl(ModelMap model){
		List<VacationForm> forms = miaoService.formList();
		List<HashMap<String, Object>> formsMap = new ArrayList<HashMap<String, Object>>();
		for(VacationForm form : forms) {
			//审核者只能看到待审核状态的请假单
			if("管理层审核".equals(form.getState())) {
				HashMap<String, Object> map = new HashMap<String, Object>();
				map.put("id", form.getId());
				map.put("title", form.getTitle());
				map.put("content", form.getContent());
				map.put("applicant", form.getApplicant());
				map.put("state", form.getState());
				formsMap.add(map);
			}
		}
		model.addAttribute("forms",formsMap);
		return "indexApproverzjl";
	}




	//人事的首页
	@GetMapping( "/homeApproverHr")
	public String homeApproverHr(ModelMap model){
		List<VacationForm> forms = miaoService.formList();
		List<HashMap<String, Object>> formsMap = new ArrayList<HashMap<String, Object>>();
		for(VacationForm form : forms) {
			//审核者只能看到待审核状态的请假单
			if("通知人事".equals(form.getState())||"已结束".equals(form.getState())) {
				HashMap<String, Object> map = new HashMap<String, Object>();
				map.put("id", form.getId());
				map.put("title", form.getTitle());
				map.put("content", form.getContent());
				map.put("applicant", form.getApplicant());
				map.put("state", form.getState());
				map.put("approver",form.getApprover());
				formsMap.add(map);
			}
		}
		model.addAttribute("forms",formsMap);
		return "indexApproverHr";
	}


	//请假单页面
	@GetMapping( "/form")
	public String form(){
		return "form";
	}



	@PostMapping( "/login")
	@ResponseBody
	public ResultInfo login(HttpServletRequest request, HttpServletResponse response){
		ResultInfo result = new ResultInfo();
		String username = request.getParameter("username");
		User user = miaoService.loginSuccess(username);
		if(user != null) {
			result.setCode(200);
			result.setMsg("登录成功");
			result.setInfo(user);
			//用户信息存放在Cookie中，实际情况下保存在Redis更佳
			Cookie cookie = new Cookie("userInfo", username);
			cookie.setPath("/");
			response.addCookie(cookie);
		}else {
			result.setCode(300);
			result.setMsg("登录名不存在，登录失败");
		}
		return result;
	}

	@GetMapping("/logout")
	@ResponseBody
	public ResultInfo logout(HttpServletRequest request, HttpServletResponse response) {
		ResultInfo result = new ResultInfo();
		Cookie[] cookies = request.getCookies();
		if (cookies != null) {
			for (Cookie cookie : cookies) {
				if (cookie.getName().equals("userInfo")) {
					cookie.setValue(null);
					// 立即销毁cookie
					cookie.setMaxAge(0);
					cookie.setPath("/");
					response.addCookie(cookie);
					break;
				}
			}
		}
		result.setCode(200);
		return result;
	}

	//添加请假单
	@GetMapping( "/writeForm")
	@ResponseBody
	public ResultInfo writeForm(HttpServletRequest request){
		ResultInfo result = new ResultInfo();
		String title = request.getParameter("title");
		String days = request.getParameter("days");
		String content = request.getParameter("content");
		String operator = request.getParameter("operator");
		VacationForm form = miaoService.writeForm(title,content,operator,days);
		result.setCode(200);
		result.setMsg("填写请假条成功");
		result.setInfo(form);
		return result;
	}

	//申请者放弃请假
	@GetMapping( "/giveup")
	@ResponseBody
	public ResultInfo giveup(HttpServletRequest request){
		ResultInfo result = new ResultInfo();
		String formId = request.getParameter("formId");
		String days = request.getParameter("days");
		String operator = request.getParameter("operator");
		miaoService.completeProcess(days,formId, operator, "giveup");
		result.setCode(200);
		result.setMsg("放弃请假成功");
		return result;
	}



	//申请未通过
	@GetMapping( "/giveups")
	@ResponseBody
	public ResultInfo giveups(HttpServletRequest request){
		ResultInfo result = new ResultInfo();
		String formId = request.getParameter("formId");
		String days = request.getParameter("days");
		String operator = request.getParameter("operator");
		miaoService.completeProcesss(days,formId, operator, "giveup");
		result.setCode(200);
		result.setMsg("放弃请假成功");
		return result;
	}


	//申请者申请请假
	@GetMapping( "/apply")
	@ResponseBody
	public ResultInfo apply(HttpServletRequest request){
		ResultInfo result = new ResultInfo();
		String formId = request.getParameter("formId");
		String operator = request.getParameter("operator");
		String days = request.getParameter("days");
		miaoService.completeProcess(days,formId, operator, "apply");
		result.setCode(200);
		result.setMsg("申请请假成功");
		return result;
	}

	//审批者审核请假信息
	@GetMapping( "/approve")
	@ResponseBody
	public ResultInfo approve(HttpServletRequest request){
		ResultInfo result = new ResultInfo();
		String formId = request.getParameter("formId");
		String operator = request.getParameter("operator");
		miaoService.approverVacation(formId, operator);
		result.setCode(200);
		result.setMsg("请假审核成功");
		return result;
	}

	//获取某条请假信息当前状态
	@GetMapping( "/currentState")
	public HashMap<String,String> currentState(HttpServletRequest request){
		String formId = request.getParameter("formId");
		HashMap<String,String> map = new HashMap<String,String>();
		map = miaoService.getCurrentState(formId);
		return map;
	}

	@GetMapping( "/historyState")
	@ResponseBody
	public ResultInfo queryHistoricTask(HttpServletRequest request){
		ResultInfo result = new ResultInfo();
		String formId = request.getParameter("formId");
		List process = miaoService.historyState(formId);
		result.setCode(200);
		result.setInfo(process);
		return result;
	}


}
