package com.bbd.bpm.controller;

import io.swagger.annotations.Api;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;

/**
 * Created by houkang on 2019/1/28.
 */
@RestController
@RequestMapping(value = "/api/bpm/userTask", produces = MediaType.APPLICATION_JSON_VALUE)
@ApiIgnore
public class UserTaskController {

    @Autowired
    private TaskService taskService;

    @Autowired
    private HistoryService historyService;

    @Autowired
    private RuntimeService runtimeService;

    //查询未处理的任务
    @GetMapping(value = "/queryUserTaskByAss")
    public void queryUserTaskByAss(String assignee){

        //任务办理人
        List<Task> taskList =  taskService.createTaskQuery().taskAssignee(assignee).list();

        String processInstanceId = null;
        if(taskList!=null && taskList.size()>0){
            for(Task task:taskList){
                System.out.println("任务ID："+task.getId());
                System.out.println("任务的办理人："+task.getAssignee());
                System.out.println("任务名称："+task.getName());
                System.out.println("任务的创建时间："+task.getCreateTime());
                System.out.println("流程实例ID："+task.getProcessInstanceId());
                System.out.println("#######################################");
                processInstanceId = task.getProcessInstanceId();
                ProcessInstance pi =runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                pi.getBusinessKey();
            }
        }

        //打印审批过程
        List<HistoricActivityInstance> list=historyService.createHistoricActivityInstanceQuery() // 创建历史活动实例查询
                .processInstanceId(processInstanceId) // 指定流程实例id
                .finished() // 查询已经完成的任务
                .list();
        for(HistoricActivityInstance hai:list){
            System.out.println("任务ID:"+hai.getTaskId());
            List<Comment> comments = taskService.getTaskComments(hai.getTaskId());
            // 4）如果当前任务有批注信息，添加到集合中
            if(comments!=null && comments.size()>0){

            }
            System.out.println("流程实例ID:"+hai.getProcessInstanceId());
            System.out.println("活动名称："+hai.getActivityName());
            System.out.println("办理人："+hai.getAssignee());
            System.out.println("开始时间："+hai.getStartTime());
            System.out.println("结束时间："+hai.getEndTime());
            System.out.println("===========================");
        }

    }
    @GetMapping(value = "/queryHistoryTask")
    public void historyActInstanceList(String assignee){

        List<HistoricTaskInstance>  list =  historyService.createHistoricTaskInstanceQuery().taskAssignee(assignee).list();

        for(HistoricTaskInstance histask:list){
            System.out.println("任务ID："+histask.getId());
            System.out.println("任务的办理人："+histask.getAssignee());
            System.out.println("任务名称："+histask.getName());
            System.out.println("任务的创建时间："+histask.getCreateTime());
            System.out.println("任务办理时间："+histask.getEndTime());
            System.out.println("流程实例ID："+histask.getProcessInstanceId());
            System.out.println("#######################################");
        }
    }



    /**
     * 查询流程状态看是否结束

     */
    @GetMapping(value = "/checkOver")
    public  void queryProcess(String processInstanceId ){
        ProcessInstance singleResult = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if(singleResult!=null){
            System.out.println(singleResult.getId());
        }
        else{
            System.out.println("已结束");
        }

    }
    /**
     * 根据发起人查询  个人发起的流程实例

     */
    @GetMapping(value = "/queryProcessInstanceByStartUser")
    public void queryProcessInstanceByStartUser(){
        List<HistoricProcessInstance> listPi =   historyService.createHistoricProcessInstanceQuery().involvedUser("hk").list();
        for(HistoricProcessInstance pi:listPi){

            System.out.println(pi.getName());
            System.out.println(pi.getStartTime());
            System.out.println(pi.getEndTime());

        }
    }


}
