package com.bbd.bpm.service;

import com.bbd.bpm.dao.AsminDaoImpl;
import com.bbd.bpm.domain.DemoTableEntity;
import com.bbd.bpm.repository.AsminRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by houkang on 2019/1/3.
 */
@Service
@Transactional
public class AsminService {

    @Autowired
    private AsminDaoImpl asminDaoImpl;
    @Autowired
    private AsminRepository asminRepository;

    public List<DemoTableEntity> queryAsmin(){

        return asminDaoImpl.queryAsmin();
    }

    public List<Map> queryAsminMap(){
        return  asminDaoImpl.queryAsminMap();
    }

    public void saveDemo(){
        DemoTableEntity entity = new DemoTableEntity();
        entity.setCreDate(new Date());
        entity.setDemoName("ceshi");
        entity.setDemoCode("cs");
        entity.setCreUser("test");
        asminRepository.save(entity);
    }

    public  List<DemoTableEntity> findAdminEntitiesByAdminNo(String demoCode){
        return asminRepository.findAllByDemoCode(demoCode);
    }
}
