package com.bbd.bpm.dao;

import com.bbd.bpm.domain.DemoTableEntity;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by houkang on 2019/1/3.
 */
@Repository
public class AsminDaoImpl {

    @PersistenceContext
    private EntityManager enm;

    public List<DemoTableEntity> queryAsmin(){
        String sql = " select demo_name as demoName,demo_code as demoCode    from demo_table ";
        Session session = enm.unwrap(Session.class);
        NativeQuery query = session.createNativeQuery(sql);
        query.addScalar("demoName", StandardBasicTypes.STRING);
        query.addScalar("demoCode", StandardBasicTypes.STRING);
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(DemoTableEntity.class));
        List<DemoTableEntity> list = query.getResultList();
        return list;
    }

    public List<Map> queryAsminMap(){
        String sql = " select demo_name ,demo_code     from demo_table ";
        Session session = enm.unwrap(Session.class);
        NativeQuery query = session.createNativeQuery(sql);

        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<Map> list = query.getResultList();
        return list;
    }
}
