package com.bbd.bpm.serviceImpl;

import com.bbd.bpm.base.PageBean;
import com.bbd.bpm.dao.MemberMapper;
import com.bbd.bpm.dao.UserInfoMapper;
import com.bbd.bpm.domain.BpmCompany;
import com.bbd.bpm.domain.BpmEmployee;
import com.bbd.bpm.result.RespCode;
import com.bbd.bpm.result.Result;
import com.bbd.bpm.result.ResultUtil;
import com.bbd.bpm.service.UserInfoService;
import com.bbd.bpm.vo.BpmCompanyVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class UserInfoServiceImpl implements UserInfoService{

    @Autowired
    private UserInfoMapper userInfoMapper;

    @Autowired
    private MemberMapper memberMapper;
    /**
     * @Author:cwd
     * @Description:获取组织列表
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @Override
    public Result getOrganization(PageBean pageBean, Integer id, Integer pId) {
        try{

            if(pId==null){
                PageHelper.startPage(pageBean.getPageNum(), pageBean.getPageSize());
                if(id==null){
                    id=1;
                }
                List<BpmCompanyVo> list = userInfoMapper.getOrganization(id);
                BpmCompanyVo bpmCompanyVo;
                for (int i=0;i<list.size();i++){
                    Integer pIds = list.get(i).getPId();
                    bpmCompanyVo=userInfoMapper.getParentName(pIds);
                    //根据pid获取上级组织名称
                    list.get(i).setParentName(bpmCompanyVo.getName());
                }
                PageInfo<BpmCompanyVo> pageInfo = new PageInfo<>(list);
                Map<String, Object> map = new HashMap<>(16);
                map.put("pageInfo", pageInfo);
                map.put("type", 1);
                return ResultUtil.getResult(RespCode.Code.SUCCESS, map);
            }else if(pId==1){
                PageHelper.startPage(pageBean.getPageNum(), pageBean.getPageSize());
                List<BpmCompanyVo> list = userInfoMapper.getOrganization(id);
                BpmCompanyVo bpmCompanyVo;
                for (int i=0;i<list.size();i++){
                    Integer pIds = list.get(i).getPId();
                    bpmCompanyVo=userInfoMapper.getParentName(pIds);
                    //根据pid获取上级组织名称
                    list.get(i).setParentName(bpmCompanyVo.getName());
                }
                PageInfo<BpmCompanyVo> pageInfo = new PageInfo<>(list);
                Map<String, Object> map = new HashMap<>(16);
                map.put("pageInfo", pageInfo);
                map.put("type", 1);
                return ResultUtil.getResult(RespCode.Code.SUCCESS, map);
            }else{
                PageHelper.startPage(pageBean.getPageNum(), pageBean.getPageSize());
                List<BpmCompanyVo> list = memberMapper.getMemberList(id);
                PageInfo<BpmCompanyVo> pageInfo = new PageInfo<>(list);
                Map<String, Object> map = new HashMap<>(16);
                map.put("pageInfo", pageInfo);
                map.put("type", 2);
                return ResultUtil.getResult(RespCode.Code.SUCCESS, map);
            }
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.getResult(RespCode.Code.INTERNAL_SERVER_ERROR);
        }

    }
    /**
     * @Author:cwd
     * @Description:加载ztree
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @Override
    public Result getOrganizationList() {
        try {
            List<Map<String,Object>> organizations = userInfoMapper.getOrganizationList();
            return ResultUtil.getResult(RespCode.Code.SUCCESS,organizations);
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.getResult(RespCode.Code.INTERNAL_SERVER_ERROR);
        }
    }
    /**
     * @Author:cwd
     * @Description:添加组织
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @Override
    public Result addOrganization(String name, String abbreviationName, Long pId, Integer id) {
        try{
            BpmCompany bpmCompany=new BpmCompany();
            //组织编号
            StringBuilder str=new StringBuilder();//定义变长字符串
            Random random=new Random();
            //随机生成数字，并添加到字符串
            for(int i=0;i<8;i++){
                str.append(random.nextInt(6));
            }
            String number = "zz"+str.toString();
            //通过pid获取上一级的组织关系
            String relation=userInfoMapper.getOrganizationRelation(id);
            //拼接
            String a=relation+"/"+number;

            bpmCompany.setName(name);
            bpmCompany.setCreateTime(new Date());
            bpmCompany.setUpdateTime(new Date());
            bpmCompany.setAbbreviationName(abbreviationName);
            bpmCompany.setCode(number);
            bpmCompany.setOrganizationRelation(a);
            if(pId==null){
                pId=1L;
            }
            bpmCompany.setPId(id);
            bpmCompany.setStatus(0);
            userInfoMapper.insertSelective(bpmCompany);
            return ResultUtil.getResult(RespCode.Code.SUCCESS);
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.getResult(RespCode.Code.INTERNAL_SERVER_ERROR);
        }
    }
    /**
     * @Author:cwd
     * @Description:部门下添加人员信息
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @Override
    public Result addOrganizationMember(String name, String position, Long pId, Integer id) {
        try {
            BpmEmployee bpmEmployee=new BpmEmployee();
            bpmEmployee.setCreateTime(new Date());
            bpmEmployee.setUpdateTime(new Date());
            bpmEmployee.setName(name);
            bpmEmployee.setCodeId(pId.intValue());
            bpmEmployee.setDepartment(id);
            bpmEmployee.setPosition(position);
            bpmEmployee.setStatus(0);
            memberMapper.insert(bpmEmployee);
            return ResultUtil.getResult(RespCode.Code.SUCCESS);
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.getResult(RespCode.Code.INTERNAL_SERVER_ERROR);
        }

    }
    /**
     * @Author:cwd
     * @Description:获取组织详情
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @Override
    public Result getOrganizationInfo(Integer id) {
        try {
            Map<String,Object> map = userInfoMapper.getOrganizationInfo(id);
            return ResultUtil.getResult(RespCode.Code.SUCCESS,map);
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.getResult(RespCode.Code.INTERNAL_SERVER_ERROR);
        }
    }
    /**
     * @Author:cwd
     * @Description:修改组织信息
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @Override
    public Result editOrganization(String name, String abbreviationName, Integer id) {
        try {
            BpmCompany bpmCompany=new BpmCompany();
            bpmCompany.setName(name);
            bpmCompany.setAbbreviationName(abbreviationName);
            bpmCompany.setId(id.longValue());
            userInfoMapper.updateByPrimaryKeySelective(bpmCompany);
            return ResultUtil.getResult(RespCode.Code.SUCCESS);
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.getResult(RespCode.Code.INTERNAL_SERVER_ERROR);
        }
    }
}
