package com.bbd.bpm.controller.user;

import com.bbd.bpm.base.PageBean;
import com.bbd.bpm.result.Result;
import com.bbd.bpm.service.UserInfoService;
import io.swagger.models.auth.In;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@Controller
@RequestMapping(value = "bpm/user")
public class userController {



    @Autowired
    private UserInfoService userInfoService;

    /**
     * @Author:cwd
     * @Description:进入组织管理
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "toOrganization")
    public String toOrganization(){
        return "user/organizationList";
    }


    /**
     * @Author:cwd
     * @Description:获取组织列表
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "getOrganizationInfo")
    @ResponseBody
    public Result getOrganizationInfo(Integer id){
       Result result= userInfoService.getOrganizationInfo(id);
       return result;
    }

    /**
     * @Author:cwd
     * @Description:获取组织列表
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "getOrganization")
    @ResponseBody
    public Result getOrganization(PageBean pageBean,Integer id,Integer pId){
        if(pageBean.getPageNum()==0){
            pageBean.setPageNum(1);
        }
        if (pageBean.getPageSize()==0) {
            pageBean.setPageSize(10);
        }
        Result result= userInfoService.getOrganization(pageBean,id,pId);
        return result;
    }



    /**
     * @Author:cwd
     * @Description:加载ztree
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "getOrganizationList")
    @ResponseBody
    public Result getOrganization(){
        Result result = userInfoService.getOrganizationList();
        return result;
    }

    /**
     * @Author:cwd
     * @Description:添加组织
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "addOrganization")
    @ResponseBody
    public Result addOrganization(String name, String abbreviationName, Long pId, Integer id){
        //获取session中的值
        Result result = userInfoService.addOrganization(name,abbreviationName,pId,id);
        return result;
    }


    /**
     * @Author:cwd
     * @Description:添加部门人员
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "addOrganizationMember")
    @ResponseBody
    public Result addOrganizationMember(String name, String position, Long pId, Integer id){
        //获取session中的值
        Result result = userInfoService.addOrganizationMember(name,position,pId,id);
        return result;
    }


    /**
     * @Author:cwd
     * @Description:修改组织
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @RequestMapping(value = "editOrganization")
    @ResponseBody
    public Result editOrganization(String name, String abbreviationName,Integer id){
        Result result = userInfoService.editOrganization(name,abbreviationName,id);
        return result;
    }

}
