package com.bbd.bpm.serviceImpl;

import com.bbd.bpm.dto.request.SpecialRequest;
import com.bbd.bpm.service.ActivitiService;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.*;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.image.ProcessDiagramGenerator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by yanlj on 2017/9/1.
 */
@Component("activitiService")
public class ActivitiServiceImpl implements ActivitiService {

    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;

    @Autowired
    private ProcessEngine processEngine;



    @Override
    public byte[] traceProcessImage(SpecialRequest request) throws IOException {
        Execution execution = null;
        if (StringUtils.isNotBlank(request.getExecutionId())) {
            execution = runtimeService.createExecutionQuery().executionId(request.getExecutionId()).singleResult();//执行实例
        }
        if (execution == null) {
            if (StringUtils.isNotBlank(request.getTaskId())) {
                Task task = taskService.createTaskQuery().taskId(request.getTaskId()).singleResult();
                if (task != null) {
                    execution = runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();//执行实例
                }
            }
        }
        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult();
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        List<String> activeActivityIds = runtimeService.getActiveActivityIds(execution.getId());

        // 使用spring注入引擎请使用下面的这行代码
        processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl) processEngineConfiguration);

        ProcessDiagramGenerator diagramGenerator = processEngineConfiguration.getProcessDiagramGenerator();
            InputStream imageStream = diagramGenerator.generateDiagram(
                    bpmnModel,
                    "png",
                    activeActivityIds,
                    new ArrayList<String>(),
                    "宋体",
                    "宋体",
                    null,
                    null,1.0);
        byte[] bytes = IOUtils.toByteArray(imageStream);
        return bytes;
    }


}
