package com.bbd.bpm.util.validate;

import com.bbd.bpm.dto.SysCode;
import com.bbd.bpm.dto.request.CompleteTaskRequest;
import com.bbd.bpm.dto.request.PendingTaskListRequest;
import com.bbd.bpm.dto.request.QueryStartedPiByUserIdRequest;
import com.bbd.bpm.dto.request.StartModelRequest;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by houkang on 2019/3/8.
 */
public class ValidateUtil {

    public static String check_startModel(StartModelRequest req){
        if(req == null){
            return SysCode.REQUEST_IS_NULL;
        }
        if(StringUtils.isBlank(req.getDeploymentId()) ){
            return "流程部署id"+SysCode.NOT_ALLOW_NULL;
        }
        if(StringUtils.isBlank(req.getUserId()) ){
            return "发起人id"+SysCode.NOT_ALLOW_NULL;
        }
        return null;

    }

    public static String check_queryStartedPiByUserId(QueryStartedPiByUserIdRequest req){
        if(req == null){
            return SysCode.REQUEST_IS_NULL;
        }
        if(StringUtils.isBlank(req.getUserId()) ){
            return "任务处理人id"+SysCode.NOT_ALLOW_NULL;
        }
        if(StringUtils.isBlank(req.getTaskStatus()) ){
            return "查询类型"+SysCode.NOT_ALLOW_NULL;
        }
        if(req.getPage()==null || req.getPage().getPageSize()==0 ){
            return "分页信息"+SysCode.NOT_ALLOW_NULL;
        }
        /*if(req.getPage().get == null ){
            return "分页信息"+SysCode.NOT_ALLOW_NULL;
        }*/
        return null;

    }

    public static String check_pendingTaskList(PendingTaskListRequest req){
        if(req == null){
            return SysCode.REQUEST_IS_NULL;
        }
        if(StringUtils.isBlank(req.getAssignee()) ){
            return "任务处理人id"+SysCode.NOT_ALLOW_NULL;
        }
        if(req.getPage()==null || req.getPage().getPageSize()==0 ){
            return "分页信息"+SysCode.NOT_ALLOW_NULL;
        }
        return null;
    }

    public static String check_completeTask(CompleteTaskRequest req ){
        if(req == null){
            return SysCode.REQUEST_IS_NULL;
        }
        if(StringUtils.isBlank(req.getTaskId()) ){
            return "任务id"+SysCode.NOT_ALLOW_NULL;
        }
        return null;
    }
}
