package com.bbd.bpm.util;

import com.bbd.bpm.dto.BtnBean;
import org.activiti.bpmn.model.*;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

public class BpmUtil {

    public static List<BtnBean> forTargetFlowElement(SequenceFlow sequenceFlow){
        List<BtnBean> buttons = new ArrayList<>();
        if(sequenceFlow==null){
            return buttons;
        }

        FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
        if(targetFlowElement!=null && targetFlowElement instanceof ExclusiveGateway){
            List<SequenceFlow> out = ((ExclusiveGateway) targetFlowElement).getOutgoingFlows();
            out.forEach(sequenceFlow1 -> {
                if (StringUtils.isNotBlank(sequenceFlow1.getConditionExpression())) {
                    BtnBean btn = new BtnBean();
                    btn.setBtnName(sequenceFlow1.getName());
                    btn.setBtnId(sequenceFlow1.getId());
                    btn.setCondition(sequenceFlow1.getConditionExpression());
                    buttons.add(btn);
                    if(sequenceFlow1.getTargetFlowElement()instanceof ExclusiveGateway){
                        buttons.addAll(forTargetFlowElement(sequenceFlow1));
                    }
                }
            });


        }else{
            if (StringUtils.isNotBlank(sequenceFlow.getConditionExpression())) {
                BtnBean btn = new BtnBean();
                btn.setBtnName(sequenceFlow.getName());
                btn.setBtnId(sequenceFlow.getId());
                btn.setCondition(sequenceFlow.getConditionExpression());
                buttons.add(btn);
            }
        }
        return buttons;

    }
}
