package com.bbd.bpm.controller;

import com.google.common.collect.Maps;
import org.activiti.engine.*;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.impl.form.DateFormType;
import org.activiti.engine.impl.form.StringFormType;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

/**
 * 启动类
 */
public class DemoMain {
    private static Logger logger = LoggerFactory.getLogger(DemoMain.class);
    public static void main(String[] args) throws ParseException {
        logger.info("启动我们的程序");
        //创建流程引擎
        ProcessEngine processEngine = getProcessEngine();
        //部署流程定义文件
        ProcessDefinition processDefinition = getProcessDefinition(processEngine);
        //启动运行流程
        ProcessInstance processInstance=getProcessInstance(processEngine, processDefinition);
        //处理流程任务
        processTask(processEngine, processInstance);
        logger.info("结束我们的程序");
    }



    private static void processTask(ProcessEngine processEngine, ProcessInstance processInstance) throws ParseException {
        Scanner scanner = new Scanner(System.in);
        while (processInstance!=null && !processInstance.isEnded()){
            TaskService taskService = processEngine.getTaskService();
            List<Task> list = taskService.createTaskQuery().list();
            logger.info("待处理人任务数量[{}]",list.size());
            for (Task task:list) {
                logger.info("待处理人任务[{}]",task.getName());
                HashMap<String, Object> map = getMap(processEngine, scanner, task);
                //提交表单
                taskService.complete(task.getId(),map);
                processInstance = processEngine.getRuntimeService().
                        createProcessInstanceQuery().
                        processInstanceId(processInstance.getId()).
                        singleResult();
            }
        }
        scanner.close();
    }

    private static HashMap<String, Object> getMap(ProcessEngine processEngine, Scanner scanner, Task task) throws ParseException {
        FormService formService = processEngine.getFormService();
        TaskFormData taskFormData = formService.getTaskFormData(task.getId());
        //获取属性表单
        List<FormProperty> formProperties = taskFormData.getFormProperties();
        HashMap<String, Object> map = Maps.newHashMap();
        for (FormProperty property : formProperties) {
            String line = null;
            if(StringFormType.class.isInstance(property.getType())){
                logger.info("请输入{} ？",property.getName());
                line = scanner.nextLine();
                map.put(property.getId(),line);
            }else if(DateFormType.class.isInstance(property.getType())){
                logger.info("请输入{} ？ 格式(yyyy-MM-dd）",property.getName());
                line = scanner.nextLine();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = dateFormat.parse(line);
                map.put(property.getId(),date);
            }else{
                logger.info("类型暂不支持{}",property.getType());
            }
            logger.info("你输入的内容是[{}]",line);


        }
        return map;
    }

    private static ProcessInstance getProcessInstance(ProcessEngine processEngine, ProcessDefinition processDefinition) {
        RuntimeService runtimeService = processEngine.getRuntimeService();
        ProcessInstance processInstance = runtimeService.startProcessInstanceById(processDefinition.getId());
        logger.info("启动流程[{}]",processInstance.getProcessDefinitionKey());
        return processInstance;
    }

    private static ProcessDefinition getProcessDefinition(ProcessEngine processEngine) {
        RepositoryService repositoryService = processEngine.getRepositoryService();
        DeploymentBuilder deploymentBuilder = repositoryService.createDeployment();
        deploymentBuilder.addClasspathResource("second_approve.bpmn20.xml");
        Deployment deployment = deploymentBuilder.deploy();
        String deploymentId = deployment.getId();

        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();

        logger.info("流程定义文件[{}]，流程id[{}]",processDefinition.getName(),processDefinition.getId() );
        return processDefinition;
    }

    private static ProcessEngine getProcessEngine() {
        ProcessEngineConfiguration cfg = ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration();
        ProcessEngine processEngine = cfg.buildProcessEngine();
        String name = processEngine.getName();
        String version=processEngine.VERSION;
        logger.info("流程引擎名称[{}],版本[{}]",name,version);
        return processEngine;
    }
}
