package com.bbd.bpm.controller;

import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by houkang on 2019/1/15.
 */
@RestController
@RequestMapping("/demo")
public class DemoController {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;

    @RequestMapping("/firstDemo")
    public void firstDemo() {

        //根据bpmn文件部署流程
        Deployment deployment = repositoryService.createDeployment().addClasspathResource("processes/bpm_one.bpmn").deploy();
        //获取流程定义
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        //启动流程定义，返回流程实例
        ProcessInstance pi = runtimeService.startProcessInstanceByKey(processDefinition.getKey(), "1111bussinessKey1111");
        String processId = pi.getId();
        System.out.println("流程创建成功，当前流程实例ID：" + processId);

        Task task = taskService.createTaskQuery().processInstanceId(processId).singleResult();
        System.out.println("第一次执行前，任务名称：" + task.getName());
        taskService.complete(task.getId());
        //2  通过任务对象获取流程实例
        ProcessInstance pit = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        //3 通过流程实例获取“业务键”
        String businessKey = pit.getBusinessKey();
        System.out.println("Businesskey:" + businessKey);
        task = taskService.createTaskQuery().processInstanceId(processId).singleResult();
        System.out.println("第二次执行前，任务名称：" + task.getName());
        taskService.complete(task.getId());

        task = taskService.createTaskQuery().processInstanceId(processId).singleResult();
        System.out.println("task为null，任务执行完毕：" + task);
    }

    @RequestMapping("/twoDemo")
    public void twoDemo() {

        //根据bpmn文件部署流程
        Deployment deployment = repositoryService.createDeployment().addClasspathResource("processes/bpm_one.bpmn").deploy();
        //获取流程定义
        ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        //启动流程定义，返回流程实例
        Map<String, Object> variables = new HashMap<String, Object>();
        variables.put("user","wang");
        ProcessInstance pi = runtimeService.startProcessInstanceByKey(processDefinition.getKey(), "1111bussinessKey1111",variables);
        String processId = pi.getId();
        System.out.println("流程创建成功，当前流程实例ID：" + processId);


    }

    @RequestMapping("/threeDemo")
    public void threeDemo() {
      List<Task> taskList =  taskService.createTaskQuery().taskAssignee("wang").list();
      if(taskList != null){
          for(Task t: taskList){
              System.out.println(t.getName()+t.getId());
              Map<String, Object> variables = new HashMap<String, Object>();
              variables.put("user","houkang");
              taskService.complete(t.getId(),variables);
          }
      }
    }

    @RequestMapping("/fourDemo")
    public void fourDemo() {
        List<Task> taskList =  taskService.createTaskQuery().taskAssignee("houkang").list();
        if(taskList != null){
            for(Task t: taskList){
               // t.
                System.out.println(t.getName());
                Map<String, Object> variables = new HashMap<String, Object>();
                taskService.complete(t.getId(),variables);
            }
        }
    }


}
