package com.bbd.bpm.dao;

import com.bbd.bpm.domain.AdminEntity;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by houkang on 2019/1/3.
 */
@Repository
public class AsminDaoImpl {

    @PersistenceContext
    private EntityManager enm;

    public List<AdminEntity> queryAsmin(){
        String sql = " select adminName    from asmin ";
        Session session = enm.unwrap(Session.class);
        NativeQuery query = session.createNativeQuery(sql);
        query.addScalar("adminName", StandardBasicTypes.STRING);
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(AdminEntity.class));
        List<AdminEntity> list = query.getResultList();
        return list;
    }

    public List<Map> queryAsminMap(){
        String sql = " select act_name_    from act_hi_actinst ";
        Session session = enm.unwrap(Session.class);
        NativeQuery query = session.createNativeQuery(sql);
        query.addScalar("act_name_", StandardBasicTypes.STRING);
        query.unwrap(NativeQueryImpl.class).setResultTransformer(Transformers.aliasToBean(HashMap.class));
        List<Map> list = query.getResultList();
        return list;
    }
}
