package com.bbd.bpm.controller;

import com.bbd.bpm.domain.AdminEntity;
import com.bbd.bpm.repository.AsminRepository;
import com.bbd.bpm.service.AsminService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by houkang on 2019/1/3.
 */
@RestController
@RequestMapping(value = "/bpm", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = {"Asmin Controller"})
public class AsminController {
    private static final Logger Log = LoggerFactory.getLogger(AsminController.class);

    @Autowired
    private AsminService asminService;

    @ApiOperation(value = "Find asmin")
    @GetMapping(value = "/asmin")
    public List<AdminEntity> searchAsmins() {

        try{

            return asminService.queryAsmin();
        }catch(Exception e){
            Log.error("查询错误",e);
        }

        return null;
    }

    @ApiOperation(value = "Find asmin by ")
    @GetMapping(value = "/asminby")
    public List<AdminEntity> searchAgents() {

        try{

            return asminService.findAdminEntitiesByAdminNo("06");
        }catch(Exception e){
            Log.error("查询错误",e);
        }

        return null;
    }

}
