package com.bbd.bpm.service;

import com.bbd.bpm.base.PageBean;
import com.bbd.bpm.domain.User;
import com.bbd.bpm.result.Result;

public interface UserInfoService {
    /**
     * 获取组织列表
     * @Author:cwd
     * @Description:获取组织列表
     * @Date: 2019/03/04 22:53
     * @param pageBean
     * @param id
     * @param pId
     * @param name
     * @return Result
     **/
    Result getOrganization(PageBean pageBean, Integer id, Integer pId, String name);
    /**
     * 加载ztree
     * @Author:cwd
     * @Description:加载ztree
     * @Date: 2019/03/04 22:53
     * @return Result
     **/
    Result getOrganizationList();
    /**
     * 添加组织
     * @Author:cwd
     * @Description:添加组织
     * @Date: 2019/03/04 22:53
     * @param pId
     * @param id
     * @param abbreviationName
     * @param name
     * @return
     **/
    Result addOrganization(String name, String abbreviationName, Long pId, Integer id);
    /**
     * 添加部门人员
     * @Author:cwd
     * @Description:添加部门人员
     * @Date: 2019/03/04 22:53
     * @param id
     * @param name
     * @param pId
     * @param department
     * @param position
     * @param type
     * @return Result
     **/
    Result addOrganizationMember(String name, String position, Long pId, Integer id, Integer department, Integer type);
    /**
     * 获取组织列表
     * @Author:cwd
     * @Description:获取组织列表
     * @Date: 2019/03/04 22:53
     * @param id
     * @return Result
     **/
    Result getOrganizationInfo(Integer id);
    /**
     * 修改组织
     * @Author:cwd
     * @Description:修改组织
     * @Date: 2019/03/04 22:53
     * @param name
     * @param abbreviationName
     * @param id
     * @return Result
     **/
    Result editOrganization(String name, String abbreviationName, Integer id);
    /**
     * 删除组织及下级
     * @Author:cwd
     * @Date: 2019/03/04 22:53
     * @param id
     * @param pId
     * @return Result
     */
    Result deleteOrganization(Long id, Integer pId);
    /**
     * 获取组织下级部门
     * @param id
     * @param pId
     * @return
     */
    Result getAreaAll(Integer id);

    /**
     * 获取左侧树
     * @Author:cwd
     * @Date: 2019.3.7
     * @return
     */
    Result getMenuList();
    /**
     * 用户列表
     * @Description: 用户列表
     * @author: cwd
     * @param id
     * @param pageBean
     * @param userName
     * @return Result
     * @date: 2019/3/4
     * @time: 11:03
     */
    Result userList(Integer id, PageBean pageBean, String userName);
    /**
     * 添加用户
     * @Author:cwd
     * @param user
     * @Date: 2019.4.4
     * @return Result
     */
    Result addUser(User user);
    /**
     * 删除用户
     * @Author:cwd
     * @Date: 2019.4.4
     * @return
     * @param user
     */
    Result deleteUser(User user);
}
