package com.bbd.bpm.web;

import com.bbd.bpm.domain.User;
import io.swagger.models.auth.In;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 用户功能模块管理
 * @Author:cwd
 * @Description:用户功能模块管理
 * @Date: 2019/03/04 22:53
 * @Param:
 * @return
 **/
@Controller
@RequestMapping(value = "/web/bpm/")
public class WebController {


    /**
     * @Author:cwd
     * @Description:我发起的流程
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @GetMapping(value = "toInitiatedDeployList")
    public String toInitiatedDeployList(ModelMap modelMap){
        User user = getUser();
        modelMap.addAttribute("userId",user.getId());
        return "deployment/initiatedDeployList";
    }


    /**
     * @Author:cwd
     * @Description:待我审批的流程
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @GetMapping(value = "toAppRoVaDeployList")
    public String toAppRoVaDeployList(ModelMap modelMap){
        User user = getUser();
        modelMap.addAttribute("name",user.getUsername());
        return "deployment/approvalDeployList";
    }



    /**
     * @Author:cwd
     * @Description:我已经审批的流程
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @GetMapping(value = "toCompletedTaskList")
    public String toCompletedTaskList(ModelMap modelMap){
        User user = getUser();
        modelMap.addAttribute("name",user.getUsername());
        return "deployment/completedTaskList";
    }


    /**
     * @Author:cwd
     * @Description:前往审批
     * @Date: 2019/03/04 22:53
     * @Param:
     * @return
     **/
    @GetMapping(value = "toAppRoValDeail")
    public String toAppRoValDeail(ModelMap modelMap, Integer taskId){
        modelMap.addAttribute("taskId",taskId);
        return "deployment/approvalDeail";
    }



    public User getUser() { //为了session从获取用户信息,可以配置如下
        User user = new User();
        SecurityContext ctx = SecurityContextHolder.getContext();
        Authentication auth = ctx.getAuthentication();
        if (auth.getPrincipal() instanceof UserDetails){ user = (User) auth.getPrincipal();}
        return user;
    }
}
