package com.bbd.bpm.controller.user;

import com.bbd.bpm.domain.User;
import com.bbd.bpm.util.VerifycodeUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.Principal;

/**
 * Created by houkang on 2019/3/19.
 */
@Controller
public class LoginController {

    @RequestMapping(value = "/login", method = RequestMethod.GET)
    public String login() {
        return "login";
    }

    @RequestMapping(value="/" ,method = RequestMethod.GET)
    public String root(Principal principal, ModelMap m) {
        m.addAttribute("userName",principal.getName());
        return "bpm/index";
    }

    public User getUser() { //为了session从获取用户信息,可以配置如下
        User user = new User();
        SecurityContext ctx = SecurityContextHolder.getContext();
        Authentication auth = ctx.getAuthentication();
        if (auth.getPrincipal() instanceof UserDetails){ user = (User) auth.getPrincipal();}
        return user;
    }

    public HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }


    /**
     * @描述：加载验证码
     * @param:
     * @return:
     * @作者： cwd
     * @创建时间：2017/6/1 10:20
     */
    @RequestMapping(value = "/loadverify", method = RequestMethod.GET)

    public void loadVerifyCode(HttpServletRequest request, HttpServletResponse response) {
        VerifycodeUtils.makeVerifyImageByNum(request, response, 4);
    }


}