package com.bbd.bpm.serviceImpl;

import com.bbd.bpm.base.PageBean;
import com.bbd.bpm.dao.UserInfoMapper;
import com.bbd.bpm.domain.ActReModelEntity;
import com.bbd.bpm.result.RespCode;
import com.bbd.bpm.result.Result;
import com.bbd.bpm.result.ResultUtil;
import com.bbd.bpm.service.ActReModelService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class ActReModelServiceImpl implements ActReModelService{

    @Autowired
    private UserInfoMapper userInfoMapper;

    @Override
    public Result getList(PageBean pageBean, String modelName) {
        PageHelper.startPage(pageBean.getPageNum(), pageBean.getPageSize());
        List<ActReModelEntity> list = userInfoMapper.getList(modelName);
        PageInfo<ActReModelEntity> pageInfo = new PageInfo<>(list);
        return ResultUtil.getResult(RespCode.Code.SUCCESS, pageInfo);
    }
}
