package com.bbd.bpm.result;

/**
 * ResultUtil
 *
 * @author WQiang
 * @Copyright  2018 BaiBangDa All rights reserved.
 */
public class ResultUtil {

    /**
     * @param respCode
     * @param data
     * @param pages
     * @return com.ph.shopping.common.util.result.Result
     * @methodname getResult 的描述：分页使用
     * @author 郑朋
     * @create 2017/4/25
     */
    public static Result getResult(RespCode respCode, Object data, long pages) {

        Result result = new Result();
        result.setData(data);
        result.setMessage(respCode.getMsg());
        result.setCode(respCode.getCode());
        result.setpages(pages);
        result.setSuccess("200".equals(respCode.getCode()));
        return result;
    }

    /**
     * @param respCode
     * @param data
     * @return com.ph.shopping.common.util.result.Result
     * @methodname getResult 的描述：获取数据
     * @author 郑朋
     * @create 2017/4/25
     */
    public static Result getResult(RespCode respCode, Object data) {
        Result result = new Result();
        result.setData(data);
        result.setMessage(respCode.getMsg());
        result.setCode(respCode.getCode());
        result.setSuccess("200".equals(respCode.getCode()));
        return result;
    }

    /**
     * @param respCode
     * @return com.ph.shopping.common.util.result.Result
     * @methodname getResult 的描述：获取数据
     * @author 郑朋
     * @create 2017/4/25
     */
    public static Result getResult(RespCode respCode) {
        Result result = new Result();
        result.setMessage(respCode.getMsg());
        result.setCode(respCode.getCode());
        result.setSuccess("200".equals(respCode.getCode()));
        return result;
    }

    /**
     * 返回错误信息
     * @param
     * @return
     */
    public static Result returnError(String message) {
        Result result = new Result();
        result.setMessage(message);
        result.setCode("0");
        result.setSuccess(false);
        return result;
    }

    /**
     * 返回带内容的成功提示
     *
     * @param msg
     * @return
     */
    public static Result returnSuccess(final String msg, final Object object) {
        Result result = new Result();
        result.setSuccess(true);
        result.setCode("200");
        result.setData(object);
        result.setMessage(msg);
        return result;
    }

    public static Result getResult(RespCode respCode, String message) {
        Result result = new Result();
        result.setMessage(message);
        result.setCode(respCode.getCode());
        result.setSuccess("200".equals(respCode.getCode()));
        return result;
    }

    /**
     * @throws
     * @Title: setResult
     * @Description: 设置返回结果
     * @param: @param result
     * @param: @param respCode
     * @param: @return
     * @return: Result
     * @author：李杰
     */
    public static Result setResult(Result result, RespCode respCode) {
        result.setMessage(respCode.getMsg());
        result.setCode(respCode.getCode());
        result.setSuccess(RespCode.Code.SUCCESS.getCode().equals(respCode.getCode()));
        return result;
    }

    /**
     * @throws
     * @Title: setResult
     * @Description:设置返回结果
     * @param: @param result
     * @param: @param flag
     * @param: @param message
     * @param: @return
     * @return: Result
     * @author：李杰
     */
    public static Result setResult(Result result, boolean flag, String message) {
        if (result == null) {
            result = new Result();
        }
        setResultValue(result, flag, message);
        return result;
    }

    /**
     * @throws
     * @Title: setResult
     * @Description: 设置返回结果
     * @param: @param flag
     * @param: @param message
     * @param: @return
     * @return: Result
     * @author：李杰
     */
    public static Result setResult(boolean flag, String message) {
        Result result = new Result();
        setResultValue(result, flag, message);
        return result;
    }

    /**
     * @throws
     * @Title: setResultValue
     * @Description: 赋值操作
     * @param: @param result
     * @param: @param flag
     * @param: @param message
     * @return: void
     * @author：李杰
     */
    private static void setResultValue(Result result, boolean flag, String message) {
        result.setCode(flag ? RespCode.Code.SUCCESS.getCode() : RespCode.Code.FAIL.getCode());
        result.setSuccess(flag);
        result.setMessage(message);
    }
}
