package com.bbd.bpm.listener;

import com.bbd.bpm.domain.BpmEmployee;
import com.bbd.bpm.repository.UserRepository;
import com.bbd.bpm.result.Result;
import com.bbd.bpm.serviceImpl.UserInfoServiceImpl;
import com.bbd.bpm.util.ContextUtils;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.el.FixedValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;

/**
 * Created by houkang on 2019/1/28.
 */
public class PutAssigneeListener   implements Serializable, TaskListener {
    private FixedValue job;

    private FixedValue userId;

    private FixedValue department;

    private FixedValue company;



    @Override
    public void notify(DelegateTask delegateTask) {

        Object obj_userID = delegateTask.getVariable("userId");
        String userId = null;
        if(obj_userID != null ){
            userId = String.valueOf(obj_userID);
        }

        UserInfoServiceImpl userService =  ContextUtils.getBean(UserInfoServiceImpl.class);



        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        TaskService taskService = processEngine.getTaskService();
        if(job!=null){
            if("jingli".equals(job.getExpressionText())){
                delegateTask.setAssignee("wang");
            }else if("emp".equals(job.getExpressionText())){
                delegateTask.setAssignee("houkang");
            }
        }else{
        taskService.setAssignee(delegateTask.getId(),"hr");
        }
    }
}
