package com.bbd.bpm.dao;


import com.bbd.bpm.base.BaseMapper;
import com.bbd.bpm.domain.ActReModelEntity;
import com.bbd.bpm.domain.BpmCompany;
import com.bbd.bpm.domain.User;
import com.bbd.bpm.vo.BpmCompanyVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface UserInfoMapper extends BaseMapper<BpmCompany>{

    List<BpmCompanyVo> getOrganization(@Param("id") Integer id, @Param("name") String name);

    List<Map<String,Object>> getOrganizationList();

    BpmCompanyVo getParentName(@Param("pId") Integer pId);

    String getOrganizationRelation(@Param("id") Integer id);

    Map<String,Object> getOrganizationInfo(@Param("id") Integer id);

    void deleteDepartment(@Param("id") Long id);

    void deleteDepartments(@Param("id") Long id);

    List<ActReModelEntity> getList(@Param("modelName") String modelName);

    List<User> userList(@Param("userName") String userName);

    void addUser(User user);

    void deleteUser(User user);
}
