package com.bbd.bpm.controller;

import com.bbd.bpm.dto.response.BpmResponse;
import com.bbd.bpm.service.AsminService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by houkang on 2019/1/3.
 */
@RestController
@RequestMapping(value = "/api/bpm", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = {"Asmin Controller"})
public class AsminController {
    private static final Logger Log = LoggerFactory.getLogger(AsminController.class);

    @Autowired
    private AsminService asminService;

    @ApiOperation(value = "Find asmin")
    @GetMapping(value = "/asmin")
    public BpmResponse searchAsmins() {
        BpmResponse resp = new BpmResponse();
        try{
            resp.setSuccess(true);
            resp.setMessage("成功");
            resp.setData( asminService.queryAsmin());
        }catch(Exception e){
            Log.error("查询错误",e);
            resp.setSuccess(false);
            resp.setMessage("错误");
        }

        return resp;
    }


    @ApiOperation(value = "Find asminMap")
    @GetMapping(value = "/asminMap")
    public BpmResponse asminMap() {
        BpmResponse resp = new BpmResponse();
        try{
            resp.setSuccess(true);
            resp.setMessage("成功");
            resp.setData( asminService.queryAsminMap());
        }catch(Exception e){
            Log.error("查询错误",e);
            resp.setSuccess(false);
            resp.setMessage("错误");
        }

        return resp;
    }
    @ApiOperation(value = "Find asmin by ")
    @GetMapping(value = "/asminby")
    public BpmResponse searchAgents() {
        BpmResponse resp = new BpmResponse();
        try{

            resp.setSuccess(true);
            resp.setMessage("成功");
            resp.setData(  asminService.findAdminEntitiesByAdminNo("06"));
        }catch(Exception e){
            Log.error("查询错误",e);
            resp.setSuccess(false);
            resp.setMessage("错误");
        }

        return resp;
    }


    @ApiOperation(value = "save demo ")
    @GetMapping(value = "/addDemo")
    public BpmResponse addDemo() {
        BpmResponse resp = new BpmResponse();
        try{
            asminService.saveDemo();
            resp.setSuccess(true);
            resp.setMessage("成功");
        }catch(Exception e){
            Log.error("查询错误",e);
            resp.setSuccess(false);
            resp.setMessage("错误");
        }

        return resp;
    }

}
