package com.bbd.bpm.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

import java.util.Optional;

/**
 * Created by houkang on 2019/3/19.
 */
@Component
public class ApplicationContextHolder implements ApplicationContextAware {

    private static ApplicationContext context;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context=applicationContext;
    }


    public static <T> Optional<T> getBean(Class<T> type){
        if (context==null){
            return Optional.empty();
        }
        return Optional.of(context.getBean(type));
    }

    public static <T> Optional<T> getBean(String name,Class<T> type){
        if (context==null){
            return Optional.empty();
        }
        return Optional.of(context.getBean(name,type));
    }


}
