package com.thinkgem.jeesite.modules.img.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.img.bean.ImgRequest;
import com.thinkgem.jeesite.modules.img.service.ImgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * 图片
 */
@RestController
@RequestMapping("/api/img")
public class ImgController {
    @Autowired
    private ImgService imgService;

    /**
     * 上传图片
     *
     * @param request
     * @return
     */
    @PostMapping("/upload")
    public Response uploadImg(ImgRequest request) {
        Response resp = new Response();
        try {
            // 判断业务入参是否为空
            if (StringUtils.isBlank(request.getSubMerchantCode()) || StringUtils.isBlank(request.getImgExt()) || StringUtils.isBlank(request.getImgBase())) {
                resp.setStatus(ComCode.STATUS_CODE_4001);
                resp.setMessage(ComCode.STATUS_CODE_4001_DESC);
                return resp;
            }
            Map<String, String> map = new HashMap<>();
            map.put("imgName", imgService.uploadImg(request));
            resp.setData(map);
            resp.setStatus(ComCode.STATUS_CODE_2000);
            resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
        } catch (Exception e) {
            resp.setStatus(ComCode.STATUS_CODE_9998);
            resp.setMessage(ComCode.STATUS_CODE_9998_DESC);
            resp.setError(e.getMessage());
        }
        return resp;
    }
}
