/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class OracleCachedRowSet
extends OracleRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    private SQLWarning sqlWarning;
    private RowSetWarning rowsetWarning;
    protected int presentRow = 0;
    private int currentPage;
    private boolean isPopulateDone;
    private boolean previousColumnWasNull = false;
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag = false;
    private int updateRowPosition;
    private boolean updateRowFlag = false;
    protected ResultSetMetaData rowsetMetaData;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private transient boolean isConnectionStayingOpenForTxnControl = false;
    protected Vector rows;
    private Vector param = new Vector();
    private String[] metaData;
    protected int colCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private int[] keyColumns;
    private int pageSize;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private String tableName;
    private boolean driverManagerInitialized = false;

    public OracleCachedRowSet() throws SQLException {
        this.rows = new Vector();
        this.sqlWarning = new SQLWarning();
        try {
            this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
        }
        catch (SyncFactoryException syncFactoryException) {
            throw new SQLException("SyncProvider instance not constructed.");
        }
        this.setReader(new OracleCachedRowSetReader());
        this.setWriter(new OracleCachedRowSetWriter());
        this.currentPage = 0;
        this.pageSize = 0;
        this.isPopulateDone = false;
        this.keyColumns = null;
        this.tableName = null;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionInternal();
    }

    Connection getConnectionInternal() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            String string = this.getUsername();
            String string2 = this.getPassword();
            if (this.getDataSourceName() != null) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(this.getDataSourceName());
                    if (this.username == null || string2 == null) {
                        this.connection = object.getConnection();
                    }
                    this.connection = object.getConnection(this.username, string2);
                }
                catch (NamingException namingException) {
                    throw new SQLException("Unable to connect through the DataSource\n" + namingException.getMessage());
                }
            } else if (this.getUrl() != null) {
                String string3;
                if (!this.driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    this.driverManagerInitialized = true;
                }
                if ((string3 = this.getUrl()).equals("") || string.equals("") || string2.equals("")) {
                    throw new SQLException("One or more of the authenticating parameter not set");
                }
                this.connection = DriverManager.getConnection(string3, string, string2);
            } else {
                throw new SQLException("Authentication parameters not set");
            }
        }
        return this.connection;
    }

    public Statement getStatement() throws SQLException {
        if (this.resultSet == null) {
            throw new SQLException("ResultSet not open");
        }
        return this.resultSet.getStatement();
    }

    public RowSetReader getReader() {
        return this.reader;
    }

    public RowSetWriter getWriter() {
        return this.writer;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.rowsetType == 1005) {
            throw new SQLException("Fetch direction cannot be applied when RowSet type is TYPE_SCROLL_SENSITIVE");
        }
        switch (n) {
            case 1000: 
            case 1002: {
                this.presentRow = 0;
                break;
            }
            case 1001: {
                if (this.rowsetType == 1003) {
                    throw new SQLException("FETCH_REVERSE cannot be applied when RowSet type is TYPE_FORWARD_ONLY");
                }
                this.presentRow = this.rowCount + 1;
                break;
            }
            default: {
                throw new SQLException("Illegal fetch direction");
            }
        }
        super.setFetchDirection(n);
    }

    public void setReader(RowSetReader rowSetReader) {
        this.reader = rowSetReader;
    }

    public void setWriter(RowSetWriter rowSetWriter) {
        this.writer = rowSetWriter;
    }

    private final int getColumnIndex(String string) throws SQLException {
        int n;
        string = string.toUpperCase();
        for (n = 0; n < this.metaData.length && !string.equals(this.metaData[n]); ++n) {
        }
        if (n >= this.metaData.length) {
            throw new SQLException("Invalid column name: " + string);
        }
        return n + 1;
    }

    private final void checkColumnIndex(int n) throws SQLException {
        if (this.readOnly) {
            throw new SQLException("The RowSet is not write enabled");
        }
        if (n < 1 || n > this.colCount) {
            throw new SQLException("invalid index : " + n);
        }
    }

    private final boolean isUpdated(int n) throws SQLException {
        if (n < 1 || n > this.colCount) {
            throw new SQLException("Invalid index : " + n);
        }
        return this.getCurrentRow().isColumnChanged(n);
    }

    private final void checkParamIndex(int n) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid parameter index : " + n);
        }
    }

    private final void populateInit(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        Statement statement = resultSet.getStatement();
        this.maxFieldSize = statement.getMaxFieldSize();
        this.fetchSize = statement.getFetchSize();
        this.queryTimeout = statement.getQueryTimeout();
        this.connection = statement.getConnection();
        this.transactionIsolation = this.connection.getTransactionIsolation();
        this.typeMap = this.connection.getTypeMap();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.url = databaseMetaData.getURL();
        this.username = databaseMetaData.getUserName();
    }

    private synchronized InputStream getStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            return ((OracleSerialClob)object).getAsciiStream();
        }
        if (object instanceof OracleSerialBlob) {
            return ((OracleSerialBlob)object).getBinaryStream();
        }
        if (object instanceof Reader) {
            try {
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                int n2 = 0;
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                while ((n2 = ((Reader)bufferedReader).read()) != -1) {
                    pipedOutputStream.write(n2);
                }
                pipedOutputStream.close();
                return pipedInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException("Error during conversion: " + iOException.getMessage());
            }
        }
        throw new SQLException("Could not convert the column into a stream type");
    }

    protected synchronized void notifyCursorMoved() {
        if (this.insertRowFlag) {
            this.insertRowFlag = false;
            this.insertRow.setRowUpdated(false);
            this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
        } else if (this.updateRowFlag) {
            try {
                this.updateRowFlag = false;
                int n = this.presentRow;
                this.presentRow = this.updateRowPosition;
                this.getCurrentRow().setRowUpdated(false);
                this.presentRow = n;
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    protected void checkAndFilterObject(int n, Object object) throws SQLException {
    }

    OracleRow getCurrentRow() throws SQLException {
        int n = this.presentRow - 1;
        if (this.presentRow < 1 || this.presentRow > this.rowCount) {
            throw new SQLException("Operation with out calling next/previous");
        }
        return (OracleRow)this.rows.elementAt(this.presentRow - 1);
    }

    boolean isConnectionStayingOpen() {
        return this.isConnectionStayingOpenForTxnControl;
    }

    void setOriginal() throws SQLException {
        int n = 1;
        do {
            boolean bl;
            if (bl = this.setOriginalRowInternal(n)) continue;
            ++n;
        } while (n <= this.rowCount);
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    boolean setOriginalRowInternal(int n) throws SQLException {
        if (n < 1 || n > this.rowCount) {
            throw new SQLException("Invalid cursor position, try next/previous first");
        }
        boolean bl = false;
        OracleRow oracleRow = (OracleRow)this.rows.elementAt(n - 1);
        if (oracleRow.isRowDeleted()) {
            this.rows.remove(n - 1);
            --this.rowCount;
            bl = true;
        } else {
            if (oracleRow.isRowInserted()) {
                oracleRow.setInsertedFlag(false);
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.makeUpdatesOriginal();
            }
        }
        return bl;
    }

    public boolean next() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowCount > 0 && this.presentRow == 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.rowCount > 0 && this.presentRow == this.rowCount + 1;
    }

    public boolean isFirst() throws SQLException {
        return this.presentRow == 1;
    }

    public boolean isLast() throws SQLException {
        return this.presentRow == this.rowCount;
    }

    public void beforeFirst() throws SQLException {
        this.presentRow = 0;
    }

    public void afterLast() throws SQLException {
        this.presentRow = this.rowCount + 1;
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public boolean absolute(int n) throws SQLException {
        if (this.rowsetType == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (n == 0 || Math.abs(n) > this.rowCount) {
            return false;
        }
        this.presentRow = n < 0 ? this.rowCount + n + 1 : n;
        this.notifyCursorMoved();
        return true;
    }

    public boolean relative(int n) throws SQLException {
        return this.absolute(this.presentRow + n);
    }

    public synchronized void populate(ResultSet resultSet) throws SQLException {
        int n;
        if (this.rows == null) {
            this.rows = new Vector(50, 10);
        } else {
            this.rows.clear();
        }
        this.rowsetMetaData = new OracleRowSetMetaData(resultSet.getMetaData());
        this.colCount = this.rowsetMetaData.getColumnCount();
        this.metaData = new String[this.colCount];
        for (n = 0; n < this.colCount; ++n) {
            this.metaData[n] = this.rowsetMetaData.getColumnName(n + 1);
        }
        if (!(resultSet instanceof OracleCachedRowSet)) {
            this.populateInit(resultSet);
        }
        n = this.fetchDirection == 1000 || this.fetchDirection == 1002 ? 1 : 0;
        this.rowCount = 0;
        OracleRow oracleRow = null;
        int n2 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
        if (resultSet.getType() != 1003 && this.rows.size() == 0 && n == 0) {
            resultSet.afterLast();
        }
        while (this.rowCount < n2 && !(n != 0 ? !resultSet.next() : !resultSet.previous())) {
            oracleRow = new OracleRow(this.colCount);
            for (int i = 1; i <= this.colCount; ++i) {
                Object object = null;
                try {
                    object = resultSet.getObject(i, this.typeMap);
                }
                catch (Exception exception) {
                    object = resultSet.getObject(i);
                }
                catch (AbstractMethodError abstractMethodError) {
                    object = resultSet.getObject(i);
                }
                if (object instanceof Clob || object instanceof CLOB) {
                    oracleRow.setColumnValue(i, new OracleSerialClob((Clob)object));
                } else if (object instanceof Blob || object instanceof BLOB) {
                    oracleRow.setColumnValue(i, new OracleSerialBlob((Blob)object));
                } else {
                    oracleRow.setColumnValue(i, object);
                }
                oracleRow.markOriginalNull(i, resultSet.wasNull());
            }
            if (n != 0) {
                this.rows.add(oracleRow);
            } else {
                this.rows.add(1, oracleRow);
            }
            ++this.rowCount;
        }
        if (n != 0 && resultSet.isAfterLast() || n == 0 && resultSet.isBeforeFirst()) {
            this.isPopulateDone = true;
        }
        this.connection = null;
        this.notifyRowSetChanged();
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Getting the cursor name is not supported.");
    }

    public synchronized void clearParameters() throws SQLException {
        this.param = null;
        this.param = new Vector();
    }

    public boolean wasNull() throws SQLException {
        return this.previousColumnWasNull;
    }

    public void close() throws SQLException {
        this.release();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    public int findColumn(String string) throws SQLException {
        return this.getColumnIndex(string);
    }

    public Object[] getParams() throws SQLException {
        return this.param.toArray();
    }

    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.rowsetMetaData = rowSetMetaData;
        if (rowSetMetaData != null) {
            this.colCount = rowSetMetaData.getColumnCount();
        }
    }

    public synchronized void execute() throws SQLException {
        this.isConnectionStayingOpenForTxnControl = false;
        this.getReader().readData(this);
    }

    public void acceptChanges() throws SyncProviderException {
        try {
            this.getWriter().writeData(this);
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException(sQLException.getMessage());
        }
    }

    public void acceptChanges(Connection connection) throws SyncProviderException {
        this.connection = connection;
        this.isConnectionStayingOpenForTxnControl = true;
        this.acceptChanges();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("SQL Error occured while cloning,\n" + sQLException.getMessage());
        }
    }

    public CachedRowSet createCopy() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createShared();
        int n = this.rows.size();
        oracleCachedRowSet.rows = new Vector(n);
        for (int i = 0; i < n; ++i) {
            oracleCachedRowSet.rows.add(((OracleRow)this.rows.elementAt(i)).createCopy());
        }
        return oracleCachedRowSet;
    }

    public RowSet createShared() throws SQLException {
        int n;
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rows = this.rows;
        oracleCachedRowSet.setDataSource(this.getDataSource());
        oracleCachedRowSet.setDataSourceName(this.getDataSourceName());
        oracleCachedRowSet.setUsername(this.getUsername());
        oracleCachedRowSet.setPassword(this.getPassword());
        oracleCachedRowSet.setUrl(this.getUrl());
        oracleCachedRowSet.setTypeMap(this.getTypeMap());
        oracleCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
        oracleCachedRowSet.setMaxRows(this.getMaxRows());
        oracleCachedRowSet.setQueryTimeout(this.getQueryTimeout());
        oracleCachedRowSet.setFetchSize(this.getFetchSize());
        oracleCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
        oracleCachedRowSet.setConcurrency(this.getConcurrency());
        oracleCachedRowSet.setReadOnly(this.readOnly);
        this.rowsetType = this.getType();
        this.fetchDirection = this.getFetchDirection();
        oracleCachedRowSet.setCommand(this.getCommand());
        oracleCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
        oracleCachedRowSet.presentRow = this.presentRow;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.showDeleted = this.showDeleted;
        oracleCachedRowSet.syncProvider = this.syncProvider;
        oracleCachedRowSet.currentPage = this.currentPage;
        oracleCachedRowSet.pageSize = this.pageSize;
        oracleCachedRowSet.tableName = this.tableName == null ? null : new String(this.tableName);
        oracleCachedRowSet.keyColumns = this.keyColumns == null ? null : (int[])this.keyColumns.clone();
        int n2 = this.listener.size();
        for (n = 0; n < n2; ++n) {
            oracleCachedRowSet.listener.add(this.listener.elementAt(n));
        }
        oracleCachedRowSet.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
        n2 = this.param.size();
        for (n = 0; n < n2; ++n) {
            oracleCachedRowSet.param.add(this.param.elementAt(n));
        }
        oracleCachedRowSet.metaData = new String[this.metaData.length];
        System.arraycopy(this.metaData, 0, oracleCachedRowSet.metaData, 0, this.metaData.length);
        return oracleCachedRowSet;
    }

    public void release() throws SQLException {
        this.rows = null;
        this.rows = new Vector();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.rowCount = 0;
        this.presentRow = 0;
        this.notifyRowSetChanged();
    }

    public void restoreOriginal() throws SQLException {
        boolean bl = false;
        for (int i = 0; i < this.rowCount; ++i) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(i);
            if (oracleRow.isRowInserted()) {
                this.rows.remove(i);
                --this.rowCount;
                --i;
                bl = true;
                continue;
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.setRowUpdated(false);
                bl = true;
                continue;
            }
            if (!oracleRow.isRowDeleted()) continue;
            oracleRow.setRowDeleted(false);
            bl = true;
        }
        if (!bl) {
            throw new SQLException("None of the rows are changed");
        }
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    public Collection toCollection() throws SQLException {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            for (int i = 0; i < this.rowCount; ++i) {
                map.put(new Integer(i), ((OracleRow)this.rows.elementAt(i)).toCollection());
            }
        }
        catch (Exception exception) {
            map = null;
            throw new SQLException("Map operation failed in toCollection()");
        }
        return map.values();
    }

    public Collection toCollection(int n) throws SQLException {
        if (n < 1 || n > this.colCount) {
            throw new SQLException("invalid index : " + n);
        }
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        for (int i = 0; i < this.rowCount; ++i) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(i);
            Object object = oracleRow.isColumnChanged(n) ? oracleRow.getModifiedColumn(n) : oracleRow.getColumn(n);
            vector.add(object);
        }
        return vector;
    }

    public Collection toCollection(String string) throws SQLException {
        return this.toCollection(this.getColumnIndex(string));
    }

    public int getRow() throws SQLException {
        if (this.presentRow > this.rowCount) {
            return this.rowCount;
        }
        return this.presentRow;
    }

    public void cancelRowInsert() throws SQLException {
        if (this.getCurrentRow().isRowInserted()) {
            this.rows.remove(--this.presentRow);
            --this.rowCount;
        } else {
            throw new SQLException("The row is not inserted");
        }
        this.notifyRowChanged();
    }

    public void cancelRowDelete() throws SQLException {
        if (!this.getCurrentRow().isRowDeleted()) {
            throw new SQLException("The row is not deleted");
        }
        this.getCurrentRow().setRowDeleted(false);
        this.notifyRowChanged();
    }

    public void cancelRowUpdates() throws SQLException {
        if (!this.getCurrentRow().isRowUpdated()) {
            throw new SQLException("The row is not updated.");
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(false);
        this.notifyRowChanged();
    }

    public void insertRow() throws SQLException {
        if (!this.insertRowFlag) {
            throw new SQLException("Current row not inserted/updated.");
        }
        if (!this.insertRow.isRowFullyPopulated()) {
            throw new SQLException("All the columns of the row are not set");
        }
        this.insertRow.insertRow();
        this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
        this.insertRowFlag = false;
        ++this.rowCount;
        this.notifyRowChanged();
    }

    public void updateRow() throws SQLException {
        if (!this.updateRowFlag) {
            throw new SQLException("Current row not updated");
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(true);
        this.notifyRowChanged();
    }

    public void deleteRow() throws SQLException {
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
    }

    public void refreshRow() throws SQLException {
        OracleRow oracleRow = this.getCurrentRow();
        if (oracleRow.isRowUpdated()) {
            oracleRow.cancelRowUpdates();
        }
    }

    public void moveToInsertRow() throws SQLException {
        this.insertRow = new OracleRow(this.colCount, true);
        this.insertRowFlag = true;
        this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
    }

    public void moveToCurrentRow() throws SQLException {
        this.insertRowFlag = false;
        this.updateRowFlag = false;
        this.absolute(this.presentRow);
    }

    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isRowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isRowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isRowDeleted();
    }

    public ResultSet getOriginalRow() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = 1;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        OracleRow oracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        oracleCachedRowSet.rows.add(oracleRow);
        return oracleCachedRowSet;
    }

    public ResultSet getOriginal() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setType(1004);
        oracleCachedRowSet.setConcurrency(1008);
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        int n = this.rowsetMetaData.getColumnCount();
        OracleRow oracleRow = null;
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            oracleRow = new OracleRow(n, ((OracleRow)iterator.next()).getOriginalRow());
            oracleCachedRowSet.rows.add(oracleRow);
        }
        return oracleCachedRowSet;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{new Integer(n2), string};
        this.param.add(n - 1, objectArray);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Boolean(bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Byte(by));
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Short(s));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Integer(n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Long(l));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Float(f));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, new Double(d));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, time);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, object);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, ref);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, blob);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, clob);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, array);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(546)};
        this.param.add(n - 1, objectArray);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{time, calendar};
        this.param.add(n - 1, objectArray);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.param.add(n - 1, objectArray);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n);
        this.param.add(n - 1, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(819)};
        this.param.add(n - 1, objectArray);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(273)};
        this.param.add(n - 1, objectArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(n2)};
        this.param.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2), new Integer(n3)};
        this.param.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2)};
        this.param.add(n - 1, objectArray);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n);
        Object[] objectArray = new Object[]{date, calendar};
        this.param.add(n - 1, objectArray);
    }

    public synchronized Object getObject(int n) throws SQLException {
        int n2 = this.presentRow * this.colCount + n - 1;
        Object object = null;
        object = !this.isUpdated(n) ? this.getCurrentRow().getColumn(n) : this.getCurrentRow().getModifiedColumn(n);
        this.previousColumnWasNull = object == null;
        return object;
    }

    private synchronized Number getNumber(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof BigDecimal || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return new Integer((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Fail to convert to internal representation");
            }
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(0L, 1)[0];
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, 1).getBytes()[0];
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public short getShort(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? (short)0 : number.shortValue();
    }

    public int getInt(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0 : number.intValue();
    }

    public long getLong(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0L : number.longValue();
    }

    public float getFloat(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0.0f : number.floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Number number = this.getNumber(n);
        return number == null ? 0.0 : number.doubleValue();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Number number = this.getNumber(n);
        if (number == null || number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Number) {
            return new BigDecimal(number.doubleValue());
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    public Date getDate(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (Date)object;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            return new Date(time.getTime());
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Date(date.getYear(), date.getMonth(), date.getDate());
        }
        throw new SQLException("Invalid column type");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)object;
            return new Time(date.getHours(), date.getMinutes(), date.getSeconds());
        }
        throw new SQLException("Invalid column type");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        throw new SQLException("Invalid column type");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (byte[])object;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof Number) {
            return ((Number)object).toString().getBytes();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes();
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(0L, (int)oracleSerialBlob.length());
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, (int)oracleSerialClob.length()).getBytes();
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public Ref getRef(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof Ref) {
            return (Ref)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object instanceof OracleSerialBlob) {
            return object == null ? null : (Blob)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object instanceof OracleSerialClob) {
            return object == null ? null : (Clob)object;
        }
        throw new SQLException("Invalid column type");
    }

    public Array getArray(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof Array) {
            return (Array)object;
        }
        throw new SQLException("Invalid column type");
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (String)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof BigDecimal) {
            return object.toString();
        }
        if (object instanceof Date) {
            return ((Date)object).toString();
        }
        if (object instanceof Timestamp) {
            return ((Date)object).toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(0L, (int)oracleSerialClob.length());
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return new String(oracleSerialBlob.getBytes(0L, (int)oracleSerialBlob.length()));
        }
        if (object instanceof URL) {
            return ((URL)object).toString();
        }
        if (object instanceof Reader) {
            try {
                Reader reader = (Reader)object;
                char[] cArray = new char[1024];
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer(1024);
                while ((n2 = reader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n2);
                }
                return stringBuffer.substring(0, stringBuffer.length());
            }
            catch (IOException iOException) {
                throw new SQLException("Error during conversion: " + iOException.getMessage());
            }
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = this.getStream(n);
        return inputStream == null ? null : inputStream;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new StringBufferInputStream((String)object);
        }
        throw new SQLException("Fail to convert to internal representation");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = this.getStream(n);
        return inputStream == null ? null : inputStream;
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        try {
            InputStream inputStream = this.getAsciiStream(n);
            if (inputStream == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while ((n2 = inputStream.read()) != -1) {
                stringBuffer.append((char)n2);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            cArray = null;
            return charArrayReader;
        }
        catch (IOException iOException) {
            throw new SQLException("Error: could not read from the stream");
        }
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.getColumnIndex(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnIndex(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnIndex(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnIndex(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnIndex(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnIndex(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnIndex(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnIndex(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnIndex(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnIndex(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnIndex(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColumnIndex(string), calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColumnIndex(string), calendar);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnIndex(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(string));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnIndex(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(string));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string), calendar);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.getColumnIndex(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColumnIndex(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColumnIndex(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColumnIndex(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColumnIndex(string));
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.checkColumnIndex(n);
        if (this.insertRowFlag) {
            this.checkAndFilterObject(n, object);
            this.insertRow.updateObject(n, object);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.updateRowFlag = true;
            this.updateRowPosition = this.presentRow;
            this.getCurrentRow().updateObject(n, object);
        } else {
            throw new SQLException("Updation not allowed on this column");
        }
    }

    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkColumnIndex(n);
        try {
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 += reader.read(cArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.getColumnIndex(string), reader, n);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnIndex(string), timestamp);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, n);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while ((n3 += inputStream.read(byArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new ByteArrayInputStream(byArray));
            byArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 += inputStreamReader.read(cArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw new SQLException("Error while reading the Stream\n" + iOException.getMessage());
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)new Timestamp(0, 0, 0, time.getHours(), time.getMinutes(), time.getSeconds(), 0));
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (!(object instanceof Number)) {
            throw new SQLException("Passed object is not Numeric type");
        }
        this.updateObject(n, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n2));
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnIndex(string));
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream, n);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColumnIndex(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColumnIndex(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.getColumnIndex(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.getColumnIndex(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.getColumnIndex(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.getColumnIndex(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.getColumnIndex(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnIndex(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnIndex(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnIndex(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColumnIndex(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnIndex(string), time);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object, n);
    }

    public URL getURL(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return (URL)object;
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        throw new SQLException("Invalid column type");
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.getColumnIndex(string));
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateObject(n, (Object)ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.getColumnIndex(string), ref);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateObject(n, (Object)blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateObject(n, (Object)clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColumnIndex(string), clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.updateObject(n, (Object)array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.getColumnIndex(string), array);
    }

    public int[] getKeyColumns() throws SQLException {
        return this.keyColumns;
    }

    public void setKeyColumns(int[] nArray) throws SQLException {
        int n = 0;
        if (this.rowsetMetaData != null) {
            n = this.rowsetMetaData.getColumnCount();
            if (nArray == null || nArray.length > n) {
                throw new SQLException("Invalid number of key columns");
            }
        }
        int n2 = nArray.length;
        this.keyColumns = new int[n2];
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] <= 0 || nArray[i] > n) {
                throw new SQLException("Invalid column index: " + nArray[i]);
            }
            this.keyColumns[i] = nArray[i];
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int n) throws SQLException {
        if (n < 0 || this.maxRows > 0 && n > this.maxRows) {
            throw new SQLException("Invalid page size specified");
        }
        this.pageSize = n;
    }

    public SyncProvider getSyncProvider() throws SQLException {
        return this.syncProvider;
    }

    public void setSyncProvider(String string) throws SQLException {
        this.syncProvider = SyncFactory.getInstance(string);
        this.reader = this.syncProvider.getRowSetReader();
        this.writer = this.syncProvider.getRowSetWriter();
    }

    public String getTableName() throws SQLException {
        return this.tableName;
    }

    public void setTableName(String string) throws SQLException {
        this.tableName = string;
    }

    public CachedRowSet createCopyNoConstraints() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.initializeProperties();
        oracleCachedRowSet.listener = new Vector();
        try {
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return oracleCachedRowSet;
    }

    public CachedRowSet createCopySchema() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.rows = null;
        oracleCachedRowSet.rowCount = 0;
        oracleCachedRowSet.currentPage = 0;
        return oracleCachedRowSet;
    }

    public boolean columnUpdated(int n) throws SQLException {
        if (this.insertRowFlag) {
            throw new SQLException("Trying to mark an inserted row as original");
        }
        return this.getCurrentRow().isColumnChanged(n);
    }

    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.getColumnIndex(string));
    }

    public synchronized void execute(Connection connection) throws SQLException {
        this.connection = connection;
        this.execute();
    }

    public void commit() throws SQLException {
        this.getConnectionInternal().commit();
    }

    public void rollback() throws SQLException {
        this.getConnectionInternal().rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        Connection connection = this.getConnectionInternal();
        boolean bl = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            connection.rollback(savepoint);
        }
        finally {
            connection.setAutoCommit(bl);
        }
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        ((OracleConnection)this.getConnectionInternal()).oracleRollback(oracleSavepoint);
    }

    public void setOriginalRow() throws SQLException {
        if (this.insertRowFlag) {
            throw new SQLException("Invalid operation on this row before insertRow is called");
        }
        this.setOriginalRowInternal(this.presentRow);
    }

    public int size() {
        return this.rowCount;
    }

    public boolean nextPage() throws SQLException {
        if (this.fetchDirection == 1001 && this.resultSet != null && this.resultSet.getType() == 1003) {
            throw new SQLException("The underlying ResultSet does not support this operation");
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            throw new SQLException("This operation can not be called without previous paging operations");
        }
        this.populate(this.resultSet);
        ++this.currentPage;
        return !this.isPopulateDone;
    }

    public boolean previousPage() throws SQLException {
        if (this.resultSet != null && this.resultSet.getType() == 1003) {
            throw new SQLException("The underlying ResultSet does not support this operation");
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            throw new SQLException("This operation can not be called without previous paging operations");
        }
        if (this.fetchDirection == 1001) {
            this.resultSet.relative(this.pageSize * 2);
        } else {
            this.resultSet.relative(-2 * this.pageSize);
        }
        this.populate(this.resultSet);
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        return this.currentPage != 0;
    }

    public void rowSetPopulated(RowSetEvent rowSetEvent, int n) throws SQLException {
        if (n <= 0 || n < this.fetchSize) {
            throw new SQLException("Invalid number of row parameter specified");
        }
        if (this.rowCount % n == 0) {
            this.rowsetEvent = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    public RowSetWarning getRowSetWarnings() throws SQLException {
        return this.rowsetWarning;
    }

    public void populate(ResultSet resultSet, int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("The start position should not be negative");
        }
        if (resultSet == null) {
            throw new SQLException("Null ResultSet supplied to populate");
        }
        int n2 = resultSet.getType();
        if (n2 == 1003) {
            int n3;
            for (n3 = 0; resultSet.next() && n3 < n; ++n3) {
            }
            if (n3 < n) {
                throw new SQLException("Too few rows to start populating at this position");
            }
        } else {
            resultSet.absolute(n);
        }
        this.populate(resultSet);
    }

    public void undoDelete() throws SQLException {
        this.cancelRowDelete();
    }

    public void undoInsert() throws SQLException {
        this.cancelRowInsert();
    }

    public void undoUpdate() throws SQLException {
        this.cancelRowUpdates();
    }
}

