package com.thinkgem.jeesite.modules.user.dao;

import com.thinkgem.jeesite.common.baseBean.Request;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.thinkgem.jeesite.modules.pay.entity.RateEntity;
import com.thinkgem.jeesite.modules.user.bean.UserRequest;
import com.thinkgem.jeesite.modules.user.entity.*;

import java.util.List;

@MyBatisDao
public interface UserApiDao {

    UserEntity getUserInfo(Request request);

    void saveIdentifyCode(IdentityCodeEntity identityCodeEntity);

    IdentityCodeEntity getIdentifyCode(UserRequest request);

    UserEntity checkRecommend(UserRequest request);

    UserEntity checkMobile(UserRequest request);

    void signUp(UserEntity userEntity);

    void resetPassword(UserEntity request);

    UserEntity getUserInfoByPassword(UserRequest request);

    UserDetailEntity getUserDetailByCode(UserEntity userEntity);

    CardEntity getCardInfoByCode(UserEntity userEntity);

    List<CardEntity> getCardsInfo(UserRequest request);

    void removeCards(UserRequest request);

    void updateCardStatus(CardEntity cardStatusEntity);

    void addNewCard(CardEntity cardEntity);

    void addFeedback(FeedbackEntity feedbackEntity);

    AboutUsEntity getAboutUsInfo(UserRequest request);

    void saveUserDetail(UserDetailEntity userDetailEntity);

    void updateUserDetail(UserDetailEntity userDetailEntity);

    void updateUserInfo(UserEntity userEntity);

    RateEntity getRateByLevel(RateEntity rateEntityParam);

    List<UserEntity> getUserInfoBySameRecommend(UserEntity queryUserRecommendEntity);

    UserEntity getUserInfoById(String userId);

    void updateUserLevel(UserEntity recommendedUser);

    List<CardEntity> getRecommendCardsInfo(UserEntity recommendedUser);

    void updateCardNoDebit(UserRequest request);

    void updateCardDebit(UserRequest request);

    CardEntity getDebitCard(CardEntity cardEntity);

    List<ProvinceCityEntity> getProvince(UserRequest request);

    List<ProvinceCityEntity> getCity(UserRequest request);

    List<BelongBankEntity> getBelongBank(UserRequest request);

}
