package com.thinkgem.jeesite.modules.homepage.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.homepage.bean.NoticeRequest;
import com.thinkgem.jeesite.modules.homepage.service.NoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 首页通知
 */
@RestController
@RequestMapping("/api/home")
public class NoticeController {
    @Autowired
    private NoticeService noticeService;

    @PostMapping("/getNotices")
    public Response getNotices(NoticeRequest request) {
        Response resp = new Response();
        try {
            resp.setData(noticeService.getNotice(request));
            resp.setStatus(ComCode.STATUS_CODE_2000);
            resp.setMessage(ComCode.STATUS_CODE_2000_DESC);
        } catch (Exception e) {
            resp.setStatus(ComCode.STATUS_CODE_9998);
            resp.setMessage(ComCode.STATUS_CODE_9998_DESC);
            resp.setError(e.getMessage());
        }
        return resp;
    }

}
