package com.thinkgem.jeesite.modules.pay.juhezhong.service;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.ApiQuickPayDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.MerchantDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.Bean2Map;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.HttpUtil;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.SignUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

/**
 * 首页通知
 */
@Service
@Transactional(readOnly = true)
public class JuHeZhongPayService {

    /**
     * 注册子商户
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject register(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.MERCHANT_REG_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 更新费率
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject updateRate(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.RATE_UPDATE_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 更新结算信息
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject updateSettle(MerchantDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.SETTLE_UPDATE_URL, params);
        return JSONObject.parseObject(respStr);
    }

    /**
     * 快捷支付
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject quickPay(ApiQuickPayDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.QUICK_PAY_URL, params);
        return JSONObject.parseObject(respStr);
    }
}
