package com.thinkgem.jeesite.modules.pay.juhezhong.service;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.ApiQuickPayDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.CommonDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.QrCodeDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.MerchantDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.QuickDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.Bean2Map;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.JFenHttpUtil;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.MakeOrderNum;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.SignUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Map;

/**
 * 首页通知
 */
@Service
@Transactional(readOnly = true)
public class JuHeZhongPayJFenService {
    private Logger logger = LoggerFactory.getLogger(Logger.class);

    /**
     * 查询订单状态
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject query(CommonDto dto) throws Exception {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.JFEN_MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = JFenHttpUtil.post(ComCode.HOST + ComCode.ORDER_QUERY_URL, params);
        logger.info("respStr:{}", respStr);
        return JSONObject.parseObject(respStr);
    }

    public JSONObject merchantIn(JSONObject dto) throws Exception {
        dto.put("merchantId",ComCode.JFEN_MERCHANT_ID);
        dto.put("merchantKey",ComCode.JFEN_MERCHANT_KEY);
        String signBefore = SignUtils.signBefore(dto);
        logger.info("signBefore:{}", signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.JFEN_MERCHANT_SECRET);
        dto.put("sign", sign);
        String respStr = JFenHttpUtil.postRaw(ComCode.HOST + ComCode.JFEN_MICRO_HANDLE_URL, dto.toString());
        return JSONObject.parseObject(respStr);
    }

    public JSONObject merchantAddFeel(JSONObject dto) throws Exception {
        dto.put("timestamp",System.currentTimeMillis());
        dto.put("serviceType","6");
        dto.put("orderId",MakeOrderNum.makeOrderNum());
        return merchantIn(dto);
    }

    public JSONObject merchantModifyFeel(JSONObject dto)throws Exception {
        dto.put("timestamp",System.currentTimeMillis());
        dto.put("serviceType","7");
        dto.put("orderId",MakeOrderNum.makeOrderNum());
        return merchantIn(dto);
    }

    public JSONObject openCard(JSONObject dto)throws Exception  {
        String signBefore = SignUtils.signBefore(dto);
        logger.info("signBefore:{}", signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.JFEN_MERCHANT_SECRET);
        dto.put("sign", sign);
        String respStr = JFenHttpUtil.postRaw(ComCode.HOST + ComCode.JFEN_QUICK_PAY_URL, dto.toString());
        return JSONObject.parseObject(respStr);
    }

    public JSONObject unionQrCodePay(QrCodeDto dto) throws Exception  {
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        logger.info("signBefore:{}", signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.JFEN_MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = JFenHttpUtil.post(ComCode.HOST + ComCode.JFEN_UNION_PAY_URL, params);
        return JSONObject.parseObject(respStr);
    }

    public JSONObject peakQuickPayHandle(JSONObject dto) throws Exception {
        String signBefore = SignUtils.signBefore(dto);
        logger.info("signBefore:{}", signBefore);
        String sign = SignUtils.sign(signBefore, ComCode.JFEN_MERCHANT_SECRET);
        dto.put("sign", sign);
        String respStr = JFenHttpUtil.post(ComCode.HOST + ComCode.JFEN_PEAK_QUICK_PAY_URL, dto.toJSONString());
        return JSONObject.parseObject(respStr);
    }


    public static void main(String[] args) throws Exception {
        JuHeZhongPayJFenService juHeZhongPayJFenService = new JuHeZhongPayJFenService();

        JSONObject dto = new JSONObject();
//        dto.put("orderId", MakeOrderNum.makeOrderNum());
          // subMchId = B105244442

        // 聂换换 B105247024
//        dto.put("serviceType",1);
//        dto.put("subMerchantName","kklsubMerchantName32");
//        dto.put("subMerchantType","PERSON");
//        dto.put("businessLicense","businessLicense23");
//        dto.put("legalPersonName","聂换换");
//        dto.put("legalPersonID","130434199212214429");
//        dto.put("subMerchantPersonName","聂换换");
//        dto.put("subMerchantPersonPhone","13722537737");
//        dto.put("bankType","TOPRIVATE");
//
//        dto.put("accountName","聂换换");
//        dto.put("accountNo","6217000060031684713");
//        dto.put("bankName","中国建设银行");
//        dto.put("bankProv","天津");
//        dto.put("bankCity","天津市");
//        dto.put("bankBranch","开户地址new");
//        dto.put("bankCode","105100000017");
//
//        dto.put("timestamp",System.currentTimeMillis());
//
//        juHeZhongPayJFenService.merchantIn(dto);



//        dto.put("subMchId","B105247024");
//        dto.put("paymentType","QUICKPAY");
//        dto.put("d0Fee","0.0043");// 最低是0.0043 d0Fee和d1Fee建议两个值相同
//        dto.put("d1Fee","0.0043");// 最低是0.0043
//        juHeZhongPayJFenService.merchantModifyFeel(dto);
//
//
//        dto.put("orderId",MakeOrderNum.makeOrderNum());
//        dto.put("merchantId",ComCode.JFEN_MERCHANT_ID);
//        dto.put("serviceType","8");
//        dto.put("subMchId","B105244442");
//        dto.put("idType","01");
//        dto.put("idNo","53250219850831031X");
//        dto.put("d0Fee","0.0043");
//        dto.put("accountName","李波");
//        dto.put("accountNo","6225571645517950");
//        dto.put("mobile","13821934497");
//        dto.put("notifyUrl","http://39.107.124.166:8080/youka-api/api/pay/openCardCallback");
//        dto.put("merchantKey",ComCode.JFEN_MERCHANT_KEY);
//        dto.put("timestamp",System.currentTimeMillis());

        /**
         * 。。。。。。openCardCallback回调。。。。。
         swpaccid=swpaccid
         [Ljava.lang.String;@37c7e16f=[Ljava.lang.String;@37c7e16f
         swpaccid=3296555230614091180
         msg=msg
         [Ljava.lang.String;@5fb7df1a=[Ljava.lang.String;@5fb7df1a
         msg=成功
         code=code
         [Ljava.lang.String;@7a5c7842=[Ljava.lang.String;@7a5c7842
         code=0000
         merchantId=merchantId
         [Ljava.lang.String;@53c16c4b=[Ljava.lang.String;@53c16c4b
         merchantId=100532502198424
         phone=phone
         [Ljava.lang.String;@5b8533c5=[Ljava.lang.String;@5b8533c5
         phone=13821934497
         sign=sign
         [Ljava.lang.String;@3aab68a0=[Ljava.lang.String;@3aab68a0
         sign=1c7358d6e3c067902ad8d24cb17e3aa6
         subMchId=subMchId
         [Ljava.lang.String;@232c89df=[Ljava.lang.String;@232c89df
         subMchId=B105244442
         cardNo=cardNo
         [Ljava.lang.String;@7bd70ac5=[Ljava.lang.String;@7bd70ac5
         cardNo=6225571645517950
         merchantKey=merchantKey
         [Ljava.lang.String;@93e1561=[Ljava.lang.String;@93e1561
         merchantKey=260a7539-6a2b-410d-aeec-9897ccee92a1
         timestamp=timestamp
         [Ljava.lang.String;@6831928e=[Ljava.lang.String;@6831928e
         timestamp=1523590870783
         2018-04-13 11:41:10,939 DEBUG [jeesite.modules.sys.interceptor.LogInterceptor] - 计时结束：11:41:10.939  耗时：0:0:0.37  URI: /youka-api/api/pay/openCardCallback  最大内存: 1739m  已分配内存: 743m  已分配内存中的剩余空间: 145m  最大可用内存: 1141m
         */
//        System.out.println(dto.toJSONString());
//        juHeZhongPayJFenService.openCard(dto);



//        dto.put("orderId",MakeOrderNum.makeOrderNum());
//        dto.put("merchantId",ComCode.JFEN_MERCHANT_ID);
//        dto.put("serviceType","4");
//        dto.put("subMchId","B105244442");
//        dto.put("merchantKey",ComCode.JFEN_MERCHANT_KEY);
//        dto.put("timestamp",System.currentTimeMillis());
//        dto.put("amount","100");
//        dto.put("idNo","53250219850831031X");
//        dto.put("accountName","李波");
//        dto.put("accountNo","6225571645517950");
//
//        dto.put("mobile","13821934497");
//        dto.put("swpaccid","3296555230614091180");
//
//        dto.put("notifyUrl","http://39.107.124.166:8080/youka-api/api/pay/openCardCallback");
//        dto.put("amount","1000");
//        juHeZhongPayJFenService.openCard(dto);
        // trade_no 20180413135023288124

        /**
         * 2018-04-13 13:54:01,804 DEBUG [modules.pay.juhezhong.utils.HttpUtil] - httpclient调用状态:HTTP/1.1 200
         2018-04-13 13:54:01,809 DEBUG [modules.pay.juhezhong.utils.HttpUtil] - httpclient调用结果{"serviceType":"4","swpaccid":"3296555230614091180","msg":"成功","amount":"1000","code":"0000","accountName":"李波","orderId":"20180413135359987000","mobile":"13821934497","sign":"9f0276f8632701b07ec67a9a2de637b7","subMchId":"B105244442","idNo":"53250219850831031X","merchantKey":"260a7539-6a2b-410d-aeec-9897ccee92a1","merchantId":"100532502198424","accountNo":"6225571645517950","notifyUrl":"http://39.107.124.166:8080/youka-api/api/pay/openCardCallback","trade_no":"20180413135359746143","timestamp":1523598840038}

         */

        dto.put("orderId",MakeOrderNum.makeOrderNum());
        dto.put("merchantId",ComCode.JFEN_MERCHANT_ID);
        dto.put("serviceType","5");
        dto.put("subMchId","B105244442");
        dto.put("merchantKey",ComCode.JFEN_MERCHANT_KEY);
        dto.put("timestamp",System.currentTimeMillis());
        dto.put("passwd","249286");
        dto.put("productName","productName");
        dto.put("tradeNo","20180413135359746143");

        dto.put("swpaccid","3296555230614091180");

        juHeZhongPayJFenService.openCard(dto);

    }
}
