package com.thinkgem.jeesite.modules.pay.weixin.service;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.Bean2Map;
import com.thinkgem.jeesite.modules.pay.weixin.dto.WeixinPayDto;
import com.thinkgem.jeesite.modules.pay.weixin.utils.HttpUtils;
import com.thinkgem.jeesite.modules.pay.weixin.utils.SignUtils;
import com.thinkgem.jeesite.modules.pay.weixin.utils.XMLAndEntityUtil;
import com.thinkgem.jeesite.modules.pay.weixin.utils.XmltoJsonUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.SortedMap;

@Transactional
@Service
public class WeixinPayService {
    public JSONObject unifiedorder(WeixinPayDto dto) throws Exception {
        dto.setMch_id(ComCode.WEIXIN_MERCHANT_ID);
        dto.setAppid(ComCode.WEIXIN_APPID);
        dto.setNonce_str(IdGen.uuid());
        dto.setSign_type("MD5");
        dto.setFee_type("CNY");
        SortedMap map = Bean2Map.Entity2SortedMap(dto);
//        map.put("sub_mch_id","1480689732");
        map.put("sign",SignUtils.createSign(map,ComCode.WEIXIN_APPSECRET));

        String xml = XMLAndEntityUtil.getRequestXML(map);
        System.out.println("xml:"+xml);
        String str =  HttpUtils.sendPost(ComCode.WEIXIN_UNIFIEDPAY_URL,xml);
        System.out.println(str);
        JSONObject jsonObject = XmltoJsonUtil.xmlToJSONObject(str);
        System.out.println(jsonObject.toJSONString());
        return jsonObject;
    }

    public static void main(String[] args) throws Exception {
        WeixinPayService weixinPayService = new WeixinPayService();
        WeixinPayDto dto = new WeixinPayDto();
        dto.setBody("body");
        dto.setOut_trade_no( ComCode.YYYYMMDDHHMM.format(new Date()) + IdGen.randomBase62(8));
        dto.setTotal_fee("1000");
        dto.setSpbill_create_ip("127.0.0.1");
        dto.setNotify_url("www.baidu.com");
        dto.setTrade_type("APP");

        weixinPayService.unifiedorder(dto);
    }
}
