/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.handlers.command;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.data.XmlAttribute;
import com.ckfinder.connector.data.XmlElementData;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.IPostCommand;
import com.ckfinder.connector.handlers.command.XMLCommand;
import com.ckfinder.connector.utils.AccessControlUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class LoadCookiesCommand
extends XMLCommand
implements IPostCommand {
    private Cookie[] cookies;
    private String sessionCookieName;
    private String sessionPathParamName;

    protected int getDataForXml() {
        if (!AccessControlUtil.getInstance(this.configuration).checkFolderACL(this.type, this.currentFolder, this.userRole, 16)) {
            return 103;
        }
        return 0;
    }

    protected void createXMLChildNodes(int errorNum, Element rootElement) throws ConnectorException {
        if (errorNum == 0) {
            this.createCookiesData(rootElement);
        }
    }

    public void initParams(HttpServletRequest request, IConfiguration configuration, Object ... params) throws ConnectorException {
        super.initParams(request, configuration, params);
        this.cookies = request.getCookies();
        this.sessionCookieName = (String)request.getAttribute("session.cookie.name");
        this.sessionPathParamName = (String)request.getAttribute("session.parameter.name");
    }

    private void createCookiesData(Element rootElement) {
        Element element = this.creator.getDocument().createElement("Cookies");
        if (this.sessionCookieName != null) {
            element.setAttribute("sessionCookieName", this.sessionCookieName);
        }
        if (this.sessionPathParamName != null) {
            element.setAttribute("sessionParameterName", this.sessionPathParamName);
        }
        for (int i = 0; i < this.cookies.length; ++i) {
            if (this.cookies[i].getName().startsWith("CKFinder_")) continue;
            XmlElementData elementData = new XmlElementData("Cookie");
            XmlAttribute attribute = new XmlAttribute("name", this.cookies[i].getName());
            elementData.getAttributes().add(attribute);
            attribute = new XmlAttribute("value", this.cookies[i].getValue());
            elementData.getAttributes().add(attribute);
            elementData.addToDocument(this.creator.getDocument(), element);
        }
        rootElement.appendChild(element);
    }
}

