package com.thinkgem.jeesite.common.baseBean;

import com.thinkgem.jeesite.common.constant.ComCode;

import java.text.SimpleDateFormat;

public class Response implements java.io.Serializable {

    private Object data;
    private String status;
    private String message;
    private String error;
    private String current;
    private Long currentTimeMillis;

    public Response() {
        this.setStatus(ComCode.STATUS_CODE_2000);
        this.setMessage(ComCode.STATUS_CODE_2000_DESC);
        this.getCurrent();
        this.getCurrentTimeMillis();
    }

    public Response(Object data, String code, String message, String error) {
        this.data = data;
        this.status = code;
        this.message = message;
        this.error = error;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCurrent() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        current = format.format(System.currentTimeMillis());
        return current;
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public Long getCurrentTimeMillis() {
        this.currentTimeMillis = System.currentTimeMillis();
        return this.currentTimeMillis;
    }

    public void setCurrentTimeMillis(Long currentTimeMillis) {
        this.currentTimeMillis = currentTimeMillis;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

}
