package com.thinkgem.jeesite.modules.user.entity;


import com.fasterxml.jackson.annotation.JsonIgnore;
import com.thinkgem.jeesite.common.baseBean.BaseEntity;

import java.io.Serializable;

public class UserEntity extends BaseEntity implements Serializable {
    private String nickname; // 昵称 注册时默认为等级_手机号
    @JsonIgnore
    private String subMerchantId; // 子商户id
    private String level; // 等级 S管理员 A王者 B钻石 C黄金 D白银 E青铜
    private String mobile; // 电话
    @JsonIgnore
    private String password; // 密码
    private String avatar; // 头像
    @JsonIgnore
    private String recommendedMobile; // 推荐人手机号
    @JsonIgnore
    private String recommendedPath; // 推荐人路径
    @JsonIgnore
    private String belongTo; // 归属 B佰邦达 S盛世互通
    private String status; // 状态 0未实名 1审核中 2已实名
    private UserDetailEntity userDetail; // 用户详情

    public UserEntity() {
    }

    public UserEntity(String code) {
        this.setCode(code);
    }

    public UserEntity(String code, String subMerchantId, String mobile, String password, String recommendedMobile, String recommendedPath, String belongTo) {
        this.setCode(code);
        this.nickname = "E_" + mobile;
        this.subMerchantId = subMerchantId;
        this.level = "E";
        this.mobile = mobile;
        this.password = password;
        this.avatar = "";
        this.recommendedMobile = recommendedMobile;
        this.recommendedPath = recommendedPath;
        this.belongTo = belongTo;
        this.status = "0";
        this.setCreatedUser("sys");
        this.setModifiedUser("sys");
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getSubMerchantId() {
        return subMerchantId;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getRecommendedMobile() {
        return recommendedMobile;
    }

    public void setRecommendedMobile(String recommendedMobile) {
        this.recommendedMobile = recommendedMobile;
    }

    public String getRecommendedPath() {
        return recommendedPath;
    }

    public void setRecommendedPath(String recommendedPath) {
        this.recommendedPath = recommendedPath;
    }

    public String getBelongTo() {
        return belongTo;
    }

    public void setBelongTo(String belongTo) {
        this.belongTo = belongTo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public UserDetailEntity getUserDetail() {
        return userDetail;
    }

    public void setUserDetail(UserDetailEntity userDetail) {
        this.userDetail = userDetail;
    }
}
