package com.thinkgem.jeesite.modules.pay.entity;

import com.thinkgem.jeesite.common.baseBean.BaseEntity;

import java.io.Serializable;

public class OrderEntity extends BaseEntity implements Serializable {
    private String userCode; // 用户code
    private String payNo; // 订单号 4位年+2位月+2位日+2位时+2位分+8位随机数
    private String payCode; // 支付号
    private String payChannel; // 支付渠道
    private String payStatus; // 订单状态 0待支付 1支付中 2已支付 3逾期取消
    private String amount; // 金额
    private String subject; // 商品名称
    private String tradeNo; // 交易号
    private String payType; // 交易类型 5借记卡 6贷记卡
    private String cardCode; // 支付卡code

    public OrderEntity() {
    }

    public OrderEntity(String code, String userCode, String payNo, String payCode, String payChannel, String payStatus, String amount, String subject, String tradeNo, String payType, String cardCode) {
        this.setCode(code);
        this.userCode = userCode;
        this.payNo = payNo;
        this.payCode = payCode;
        this.payChannel = payChannel;
        this.payStatus = payStatus;
        this.amount = amount;
        this.subject = subject;
        this.tradeNo = tradeNo;
        this.payType = payType;
        this.cardCode = cardCode;
        this.setCreatedUser("sys");
        this.setModifiedUser("sys");
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public String getPayCode() {
        return payCode;
    }

    public void setPayCode(String payCode) {
        this.payCode = payCode;
    }

    public String getPayChannel() {
        return payChannel;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
    }

    public String getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getCardCode() {
        return cardCode;
    }

    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }
}
