package com.thinkgem.jeesite.modules.pay.service;

import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.pay.bean.OrderRequest;
import com.thinkgem.jeesite.modules.pay.dao.OrderApiDao;
import com.thinkgem.jeesite.modules.pay.dao.PayApiDao;
import com.thinkgem.jeesite.modules.pay.entity.BalanceEntity;
import com.thinkgem.jeesite.modules.pay.entity.BenefitEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;

/**
 * @author niehh
 * @Description:分润相关
 * @date 2018年03月15日 10:30
 */
@Service
@Transactional(readOnly = true)
public class BenefitSevice {
    @Autowired
    private PayApiDao payDao;

    @Autowired
    private OrderApiDao orderApiDao;

    /**
     * 余额
     * @param entity
     * @return
     */
    public BalanceEntity getBalance(BenefitEntity entity){

        BalanceEntity balanceEntity = new BalanceEntity();

        // 总收益
        entity.setBenefitType("A");
        BenefitEntity benefitEntityA = payDao.getBenefitSum(entity);

        // 总提现
        entity.setBenefitType("M");
        BenefitEntity benefitEntityM = payDao.getBenefitSum(entity);

        // 余额 = 总收益-总提现
        if(benefitEntityA==null){
            balanceEntity.setBalance("0.00");
        }else {
            if(benefitEntityA.getAmount() == null){
                benefitEntityA.setAmount("0.00");
            }
            if(benefitEntityM == null){
                balanceEntity.setBalance(benefitEntityA.getAmount());
            }else{
                if(benefitEntityM.getAmount() == null ){
                    benefitEntityM.setAmount("0.00");
                }
                DecimalFormat df = new DecimalFormat("######0.00");
                balanceEntity.setBalance(df.format(Double.valueOf(benefitEntityA.getAmount()) - Double.valueOf(benefitEntityM.getAmount())));
            }
        }

        // 今日收益
        entity.setBenefitType("A");
        Date date = new Date();
        String today = DateUtils.formatDate(date,"yyyy-MM-dd HH:mm:ss");
        String todayYMD = DateUtils.formatDate(date,"yyyy-MM-dd");
        entity.setEndTime(today);
        entity.setStartTime(todayYMD+ " 00:00:00");
        BenefitEntity benefitEntityToday = payDao.getBenefitSum(entity);
        if(benefitEntityToday != null && StringUtils.isNotBlank(benefitEntityToday.getAmount())){
            balanceEntity.setTodayIncome(benefitEntityToday.getAmount());
        }else{
            balanceEntity.setTodayIncome("0.00");
        }

        // 昨日收益
        entity.setEndTime(DateUtils.getYesterday(todayYMD,"yyyy-MM-dd") + " 23:59:59");
        entity.setStartTime(DateUtils.getYesterday(todayYMD,"yyyy-MM-dd") + " 00:00:00");

        BenefitEntity benefitEntityYesterday = payDao.getBenefitSum(entity);
        if(benefitEntityYesterday != null && StringUtils.isNotBlank(benefitEntityYesterday.getAmount())){
            balanceEntity.setYesterdayIncome(benefitEntityYesterday.getAmount());
        }else{
            balanceEntity.setYesterdayIncome("0.00");
        }


        // 本月收益
        entity.setEndTime(today);
        entity.setStartTime(DateUtils.getFirstByMonth(todayYMD,"yyyy-MM-dd") + " 00:00:00");
        BenefitEntity benefitEntityMonth = payDao.getBenefitSum(entity);
        if(benefitEntityMonth != null && StringUtils.isNotBlank(benefitEntityMonth.getAmount())){
            balanceEntity.setMonthIncome(benefitEntityMonth.getAmount());
        }else{
            balanceEntity.setMonthIncome("0.00");
        }

        // 本年收益
        entity.setEndTime(today);
        entity.setStartTime(DateUtils.getCurrYearFirst(todayYMD,"yyyy-MM-dd") + " 00:00:00");
        BenefitEntity benefitEntityYear = payDao.getBenefitSum(entity);
        if(benefitEntityYear != null && StringUtils.isNotBlank(benefitEntityYear.getAmount())){
            balanceEntity.setYearIncome(benefitEntityYear.getAmount());
        }else{
            balanceEntity.setYearIncome("0.00");
        }

        return balanceEntity;
    }


    /**
     * 分润
     * @param request
     * @return
     */
    public List<BenefitEntity> getBenefitList(OrderRequest request){
        if(request.getStartDate()!= null){
            request.setStartTime(DateUtils.formatDate(new Date(request.getStartDate()),"yyyy-MM-dd") + " 00:00:00");
        }
        if(request.getEndDate() != null){
            request.setEndTime(DateUtils.formatDate(new Date(request.getEndDate()),"yyyy-MM-dd") + " 23:59:59");
        }

        return orderApiDao.getBenefitList(request);

    }

}
