package com.thinkgem.jeesite.modules.pay.juhezhong.service;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.CommonDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.MerchantDto;
import com.thinkgem.jeesite.modules.pay.juhezhong.dto.MerchantsEntering;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.Bean2Map;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.SignUtils;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.HttpUtil;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

@Transactional
@Service
public class JuHeZhongPayIntegralService {
    private Logger logger = LoggerFactory.getLogger(Logger.class);



    /**
     * 查询订单状态
     *
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject query(CommonDto dto) throws Exception {
        dto.setMerchantId(ComCode.MERCHANT_ID);
        dto.setMerchantKey(ComCode.INTEGRAL_MERCHANT_KEY);
        Map<String, Object> params = Bean2Map.Entity2Map(dto);
        String signBefore = SignUtils.signBefore(params);
        String sign = SignUtils.sign(signBefore, ComCode.INTEGRAL_MERCHANT_SECRET);
        params.put("sign", sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.INTEGRAL_ORDER_QUERY_URL, params);
        logger.info("respStr:{}", respStr);
        return JSONObject.parseObject(respStr);
    }


    public JSONObject quickPayHandle(JSONObject dto)throws Exception  {
        dto.put("merchantId",ComCode.INTEGRAL_MERCHANT_ID);
        dto.put("timestamp",System.currentTimeMillis());

        String signBefore = SignUtils.signBefore(dto);
        String sign = SignUtils.sign(signBefore, ComCode.INTEGRAL_MERCHANT_SECRET);
        dto.put("sign", sign);
        logger.info("signBefore:{},sign:{}", signBefore,sign);
        String respStr = HttpUtil.post(ComCode.HOST + ComCode.INTEGRAL_MERCHANT_REG_URL, dto.toJSONString());
        System.out.println(respStr);
        return JSONObject.parseObject(respStr);
    }

    public static void main(String[] args) throws Exception {
//        JSONObject dto = new JSONObject();
//        dto.put("orderId","12323243435545465");
//        dto.put("serviceType","4");
//        dto.put("","");
//        JuHeZhongPayIntegralService juHeZhongPayIntegralService = new JuHeZhongPayIntegralService();
//        JSONObject jsonObject = juHeZhongPayIntegralService.quickPayHandle(dto);
//        System.out.println(jsonObject.toJSONString());

        JuHeZhongPayIntegralService juHeZhongPayIntegralService = new JuHeZhongPayIntegralService();
        JSONObject dto = new JSONObject();

        dto.put("orderId", MakeOrderNum.makeOrderNum());//标识请求唯一（非订单号）
        dto.put("serviceType", 1);//服务类型
        dto.put("merchantId", ComCode.INTEGRAL_MERCHANT_ID);//商户号
        dto.put("subMerchantName", "niehh");//对公的就按照营业执照的注册名称进行商户名的报备进件，个体户的需要突出省，市，区一级营业范围，如：“XX市+XX区+法人名称+营业范围”--例“北京市朝阳区洪新阳饭店”而且一个身份证不要重复入很多个做银联二维码交易的商户  原则上一个身份证下只有一个做银联二维码交易的户，23:00—7:00，这段时间，银联二维码可以交易，不结算

        dto.put("accName", "聂换换");//开户名称
        dto.put("accNo", "6217000180000770507");//开户账号
        dto.put("accType",1); //1=个人账户     0=企业账户1=个人账户

        dto.put("bankName", "建设银行");//开户银行名（支行全称）
        dto.put("bankCode", "105100000017");//联行号
        dto.put("mobile","13722537737");
        dto.put("idNo","130434199212214429");//身份证号
        dto.put("settleType","795934");//费率类型 795934
        dto.put("address","天津市河西区");//地址
        dto.put("merchantKey", ComCode.INTEGRAL_MERCHANT_KEY);//商户key
        dto.put("timestamp", System.currentTimeMillis());//时间戳

        JSONObject jsonObject = juHeZhongPayIntegralService.quickPayHandle(dto);

        String signBefore = SignUtils.signBefore(jsonObject);
        String sign = SignUtils.sign(signBefore, ComCode.INTEGRAL_MERCHANT_SECRET);
        //B105004538
        System.out.println(jsonObject.toJSONString());
    }


}
